/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.util.DateHelper;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.pp.IOrgSchedule;
import com.kingdee.eas.fm.pp.OrgScheduleCollection;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPBankTypeInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PPParameterValuesCollection;
import com.kingdee.eas.fm.pp.PPParameterValuesInfo;
import com.kingdee.eas.fm.pp.PPScheduleSettingAutoEntryCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingAutoEntryInfo;
import com.kingdee.eas.fm.pp.PPScheduleSettingCollection;
import com.kingdee.eas.fm.pp.PPScheduleSettingInfo;
import com.kingdee.eas.fm.pp.PPSupplierEntryCollection;
import com.kingdee.eas.fm.pp.PPSupplierEntryInfo;
import com.kingdee.eas.fm.pp.PPSupplierSettingCollection;
import com.kingdee.eas.fm.pp.PPSupplierSettingInfo;
import com.kingdee.eas.fm.pp.PPUtils;
import com.kingdee.eas.fm.pp.StatusEnum;
import com.kingdee.eas.fm.pp.UserDefinedPeriodFactory;
import com.kingdee.eas.fm.pp.UserDefinedPeriodInfo;
import com.kingdee.eas.fm.pp.app.AbstractPPScheduleSettingControllerBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PPScheduleSettingControllerBean
extends AbstractPPScheduleSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.PPScheduleSettingControllerBean");
    private static final String PERM_ITEM_SET = "pp_schedule_02update";
    private static final String PERM_ITEM_DELETE = "pp_schedule_03delete";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PPScheduleSettingInfo info = (PPScheduleSettingInfo)model;
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_SET);
        if (!isPermission) {
            throw new PPException(PPException.NO_SETTING_AUTH, new String[]{info.getCompany().getName()});
        }
        PPSupplierEntryCollection supplierEntryColl = info.getSupplierEntry();
        PPSupplierEntryCollection newSupplierEntryColl = (PPSupplierEntryCollection)((Object)supplierEntryColl.clone());
        info.getSupplierEntry().clear();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)newSupplierEntryColl)) {
            for (int m = 0; m < newSupplierEntryColl.size(); ++m) {
                PPSupplierSettingCollection supplierSettingColl;
                PPSupplierEntryInfo supplierEntryInfo = newSupplierEntryColl.get(m);
                PPSupplierEntryInfo newSupplierEntryInfo = new PPSupplierEntryInfo();
                newSupplierEntryInfo.setId(supplierEntryInfo.getId());
                newSupplierEntryInfo.setSeq(m + 1);
                newSupplierEntryInfo.setRuleClassification(supplierEntryInfo.getRuleClassification());
                info.getSupplierEntry().add(newSupplierEntryInfo);
                PPParameterValuesCollection parameterColl = supplierEntryInfo.getParameterValues();
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)parameterColl)) {
                    for (int n = 0; n < parameterColl.size(); ++n) {
                        PPParameterValuesInfo parameterInfo = parameterColl.get(n);
                        PPBankTypeInfo bankTypeInfo = new PPBankTypeInfo();
                        bankTypeInfo.setId(parameterInfo.getId());
                        parameterInfo.setPpBankType(bankTypeInfo);
                        parameterInfo.setId(null);
                        newSupplierEntryInfo.getParameterValues().add(parameterInfo);
                    }
                }
                if (EmptyUtil.isEmpty((AbstractObjectCollection)(supplierSettingColl = supplierEntryInfo.getSupplierSetting()))) continue;
                for (int n = 0; n < supplierSettingColl.size(); ++n) {
                    PPSupplierSettingInfo supplierSettingInfo = supplierSettingColl.get(n);
                    SupplierInfo supplierInfo = new SupplierInfo();
                    supplierInfo.setId(supplierSettingInfo.getId());
                    supplierSettingInfo.setSupplier(supplierInfo);
                    supplierSettingInfo.setId(null);
                    newSupplierEntryInfo.getSupplierSetting().add(supplierSettingInfo);
                }
            }
        }
        HashMap<Integer, Integer> type_ParamMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> type_priorMap = new HashMap<Integer, Integer>();
        PPScheduleSettingAutoEntryCollection entryColl = info.getEntries();
        if (entryColl != null && entryColl.size() > 0) {
            for (int i = 0; i < entryColl.size(); ++i) {
                PPScheduleSettingAutoEntryInfo entryInfo = entryColl.get(i);
                int settingType = entryInfo.getSettingType().getValue();
                int settingParam = entryInfo.getSettingParam().getValue();
                Integer param = (Integer)type_ParamMap.get(settingType);
                if (param != null && settingParam == param) {
                    throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SettingParam_Same")});
                }
                type_ParamMap.put(settingType, settingParam);
                int priority = entryInfo.getPriority();
                Integer prior = (Integer)type_priorMap.get(settingType);
                if (prior != null && priority == prior) {
                    throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"Priority_Same")});
                }
                type_priorMap.put(settingType, priority);
            }
        }
        info.setEffectedDate(DateHelper.truncateDate((Date)info.getEffectedDate()));
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        info.setLastUpdateUser(user);
        return super._save(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PPScheduleSettingInfo info = (PPScheduleSettingInfo)model;
        if (this.isExistsByOrgId(ctx, info.getCompany().getId().toString()).booleanValue()) {
            throw new PPException(PPException.ORGISEXISTS);
        }
        IObjectPK pk = super._addnew(ctx, model);
        this.initOrgScheduleInfo(ctx, info);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getId().toString(), (String)"pp_scheduleSetting_addnew", (String)info.getCompany().getId().toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    private void initOrgScheduleInfo(Context ctx, PPScheduleSettingInfo info) throws EASBizException, BOSException {
        UserDefinedPeriodInfo periodInfo = UserDefinedPeriodFactory.getLocalInstance(ctx).getPeriodInfoByDate(info.getEffectedDate(), info.getCU().getId().toString());
        if (periodInfo == null) {
            throw new PPException(PPException.NO_PERIODINFO);
        }
        UserDefinedPeriodInfo nextPeriodInfo = UserDefinedPeriodFactory.getLocalInstance(ctx).getNextPeriodInfoById(periodInfo.getId().toString());
        if (nextPeriodInfo == null) {
            throw new PPException(PPException.NO_NEXT_PERIODINFO);
        }
        OrgScheduleInfo scheduleInfo = this.getScheduleInfoByPeriodInfo(periodInfo, info);
        OrgScheduleInfo nextScheduleInfo = this.getScheduleInfoByPeriodInfo(nextPeriodInfo, info);
        IOrgSchedule orgSchedule = OrgScheduleFactory.getLocalInstance(ctx);
        orgSchedule.addnew(scheduleInfo);
        orgSchedule.addnew(nextScheduleInfo);
    }

    private OrgScheduleInfo getScheduleInfoByPeriodInfo(UserDefinedPeriodInfo periodInfo, PPScheduleSettingInfo setInfo) {
        OrgScheduleInfo scheduleInfo = new OrgScheduleInfo();
        scheduleInfo.setUserDefinedPeriod(periodInfo);
        scheduleInfo.setCompany(setInfo.getCompany());
        scheduleInfo.setStatus(StatusEnum.NOT_SCHEDULE);
        scheduleInfo.setCount(0);
        return scheduleInfo;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _deleteBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        if (result.getSummaryMsg() != null) {
            return result;
        }
        String comNames = "";
        int success = 0;
        String summary = PPUtils.getResource(ctx, "041_settingSum", new String[]{idSet.size() + ""});
        ArrayList idList = new ArrayList(idSet);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map requestMap = iMutex.batchRequestObjIDForUpdate(idList);
        try {
            PPScheduleSettingCollection ppSettingColls = this.getSummaryCollection(ctx, idSet);
            HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
            for (int i = 0; i < ppSettingColls.size(); ++i) {
                PPScheduleSettingInfo info = ppSettingColls.get(i);
                String companyName = info.getCompany().getName();
                comNames = comNames + companyName + "  ";
                try {
                    Boolean noLocked;
                    if (!permissionSet.contains(info.getCompany().getId())) {
                        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)PERM_ITEM_DELETE);
                        if (!isPermission) {
                            String msg = PPUtils.getResource(ctx, "041_NO_SET_DELETE_AUTH", new String[]{info.getCompany().getName()});
                            result.getDetailMsgList().add(PPUtils.getResource(ctx, "042_DELETE_FAIL_REASON", new String[]{companyName, msg}));
                            continue;
                        }
                        permissionSet.add(info.getCompany().getId());
                    }
                    if (!(noLocked = (Boolean)requestMap.get(info.getId().toString())).booleanValue()) {
                        result.getDetailMsgList().add(PPUtils.getResource(ctx, "042_DELETE_FAIL_REASON", new String[]{companyName, PPUtils.getResource(ctx, "043_BILL_HAS_LOCK", null)}));
                        continue;
                    }
                    try {
                        this.deteleInitOrgScheduleInfo(ctx, info.getCompany().getId().toString());
                    }
                    catch (PPException e) {
                        result.getDetailMsgList().add(e.getMessage());
                        continue;
                    }
                    this.delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
                    ++success;
                    IObjectPK logPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), (String)info.getId().toString(), (String)"pp_scheduleSetting_delete", (String)info.getCompany().getId().toString());
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result.getDetailMsgList().add(PPUtils.getResource(ctx, "042_DELETE_FAIL_REASON", new String[]{companyName, PPUtils.getResource(ctx, "044_SYS_EXCEPTION", null)}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(idList);
        }
        summary = success == idSet.size() ? summary + PPUtils.getResource(ctx, "045_ALL_DELETE_SUCC", null) : summary + PPUtils.getResource(ctx, "046_DELETE_TITLE", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.setSummaryMsg(summary);
        if (idSet.size() > 0) {
            IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)new PPScheduleSettingInfo().getBOSType(), null, (String)comNames, (String)"pp_scheduleSetting_delete", null, null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        }
        return result;
    }

    private void deteleInitOrgScheduleInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        view.setFilter(filter);
        IOrgSchedule iOrgSchedule = OrgScheduleFactory.getLocalInstance(ctx);
        OrgScheduleCollection coll = iOrgSchedule.getOrgScheduleCollection(view);
        if (coll.size() > 2) {
            throw new PPException(PPException.NOSETTINGDELETE);
        }
        if (coll.size() < 2) {
            throw new PPException(PPException.ORGSCHEDULEERROR);
        }
        for (int i = 0; i < coll.size(); ++i) {
            OrgScheduleInfo info = coll.get(i);
            if (StatusEnum.NOT_SCHEDULE.equals((Object)info.getStatus())) continue;
            throw new PPException(PPException.NOSETTINGDELETE);
        }
        iOrgSchedule.delete(filter);
    }

    @Override
    protected Set _getOnAndNoExistsOrgIds(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("company.id"));
        view.setSelector(coll);
        if (idSet == null || idSet.size() == 0) {
            return ids;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        HashSet<String> existsIds = new HashSet<String>();
        PPScheduleSettingCollection ppColl = this.getPPScheduleSettingCollection(ctx, view);
        for (int i = 0; i < ppColl.size(); ++i) {
            existsIds.add(ppColl.get(i).getCompany().getId().toString());
        }
        idSet.removeAll(existsIds);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("PS301");
        ArrayList list = ParamControlFactory.getLocalInstance((Context)ctx).getParamListPatch(paramList, new ArrayList(idSet));
        for (int i = 0; i < list.size(); ++i) {
            ParamSimpleInfo info = (ParamSimpleInfo)list.get(i);
            if (!Boolean.valueOf(info.getParamValue()).booleanValue()) continue;
            ids.add(info.getOrgUnitPK().toString());
        }
        return ids;
    }

    private PPScheduleSettingCollection getSummaryCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("company.name"));
        entityViewInfo.setSelector(sel);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        return this.getPPScheduleSettingCollection(ctx, entityViewInfo);
    }

    private Boolean isExistsByOrgId(Context ctx, String companyId) throws BOSException {
        Boolean isExists = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        entityViewInfo.setFilter(filter);
        PPScheduleSettingCollection coll = this.getPPScheduleSettingCollection(ctx, entityViewInfo);
        if (coll.size() > 0) {
            isExists = true;
        }
        return isExists;
    }
}

