/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.IRecPlanBill;
import com.kingdee.eas.fm.pp.OrgScheduleFactory;
import com.kingdee.eas.fm.pp.OrgScheduleInfo;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.RecPlanBillCollection;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.app.AbstractRecPlanBillWebFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecPlanBillWebFacadeControllerBean
extends AbstractRecPlanBillWebFacadeControllerBean {
    private static final long serialVersionUID = 4238345791807813120L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.pp.app.RecPlanBillWebFacadeControllerBean");

    @Override
    public Map _batchSubmit(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IRecPlanBill RecPlanBill2 = RecPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        RecPlanBillCollection colls = RecPlanBill2.getRecPlanBillCollection(view);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            RecPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"recPlanBill_03submit");
                    if (!isPermission) {
                        throw new PPException(PPException.RECPLANBILL_NO_SUBMIT, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                RecPlanBillFactory.getLocalInstance(ctx).batchSubmit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_SUBMIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_SUBMIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _batchAudit(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IRecPlanBill RecPlanBill2 = RecPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        RecPlanBillCollection colls = RecPlanBill2.getRecPlanBillCollection(view);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            RecPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"recPlanBill_05audit");
                    if (!isPermission) {
                        throw new PPException(PPException.RECPLANBILL_NO_AUDIT, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                RecPlanBillFactory.getLocalInstance(ctx).audit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_AUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_AUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"AUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _batchUnAudit(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IRecPlanBill RecPlanBill2 = RecPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        RecPlanBillCollection colls = RecPlanBill2.getRecPlanBillCollection(view);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            RecPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"recPlanBill_06unAudit");
                    if (!isPermission) {
                        throw new PPException(PPException.RECPLANBILL_NO_UNAUDIT, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                RecPlanBillFactory.getLocalInstance(ctx).unAudit(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_UNAUDIT_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_UNAUDIT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"UNAUDIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _batchDelete(Context ctx, String[] ids) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        IRecPlanBill RecPlanBill2 = RecPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        RecPlanBillCollection colls = RecPlanBill2.getRecPlanBillCollection(view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            RecPlanBillInfo info = colls.get(i);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"recPlanBill_04delete");
                    if (!isPermission) {
                        throw new PPException(PPException.RECPLANBILL_NO_DELETE, new Object[]{info.getCompany().getName()});
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE"));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new Exception(CASWebUtil.getResource((Context)ctx, (String)"610_CantOpreateWhileOtherUse"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                RecPlanBillFactory.getLocalInstance(ctx).delete(idSet);
                ++success;
                iMutex.releaseObjIDForUpdate(info.getId().toString());
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_DELETE_FAIL_WF", (String[])new String[]{info.getCompany().getName(), info.getNumber()}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_DELETE_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"DELETE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _toNext(Context ctx, String orgScheId, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        StringBuffer numbers = new StringBuffer();
        numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"68_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer failNumbers = new StringBuffer();
        failNumbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"69_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        if (orgScheId == null) {
            return result;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("userDefinedPeriod.startDate");
        sic.add("userDefinedPeriod.endDate");
        sic.add("userDefinedPeriod.id");
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheId), sic);
        Date startDate = orgScheduleInfo.getUserDefinedPeriod().getStartDate();
        Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
        Date afterDate = DateUtil.getAfterDay((Date)endDate);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgScheduleInfo.getCompany().getId()), (String)"recPlanBill_09toNext");
        if (!isPermission) {
            throw new PPException(PPException.RECPLANBILL_NO_TONEXT, new Object[]{orgScheduleInfo.getCompany().getName()});
        }
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)orgScheduleInfo.getCompany())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE")});
        }
        IRecPlanBill recPlanBill = RecPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        RecPlanBillCollection colls = recPlanBill.getRecPlanBillCollection(view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            RecPlanBillInfo info = colls.get(i);
            try {
                Date recableDate = info.getRecableDate();
                if (recableDate.before(startDate) || recableDate.after(afterDate) || recableDate.equals(afterDate)) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_ToNext_CurrentPeriod"));
                }
                String companyId = info.getCompany().getId().toString();
                if (!companyId.equals(orgScheduleInfo.getCompany().getId().toString())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RECPAY_COMPANY_NOT_MATCH", (String[])new String[]{orgScheduleInfo.getCompany().getName()}));
                }
                BillStatusEnum billStatus = info.getBillStatus();
                if (billStatus != BillStatusEnum.AUDIT && billStatus != BillStatusEnum.SCHEDULED && billStatus != BillStatusEnum.TONEXT) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_ToNext_BillStatusErr", (String[])new String[]{billStatus.getAlias()}));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CANTTONEXT"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                numbers.append(info.getNumber());
                numbers.append(",");
                continue;
            }
            catch (Exception e) {
                failNumbers.append(info.getNumber());
                failNumbers.append(",");
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_TONEXT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_PP_RecPlanBill SET FBillLastStatus = FBillStatus , FBillStatus = ? , FRecableDate = ? , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                Integer status = new Integer(5);
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{status, new Timestamp(afterDate.getTime()), userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
                if (success != ids.length) {
                    numbers.append(failNumbers);
                }
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"toNext", (BOSObjectType)new RecPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_recPlanBill_toNext", (String)orgScheduleInfo.getCompany().getId().toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"93_RecPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()) + e));
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BATCHTONEXT_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_TONEXT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"TONEXT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    public Map _backToNext(Context ctx, String orgScheId, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        StringBuffer numbers = new StringBuffer();
        numbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"72_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        StringBuffer failNumbers = new StringBuffer();
        failNumbers.append(ResourceBase.getString((String)"com.kingdee.eas.fm.pp.PPAutoGenerateResource", (String)"73_PayPlanBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
        if (orgScheId == null) {
            return result;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("userDefinedPeriod.startDate");
        sic.add("userDefinedPeriod.endDate");
        sic.add("userDefinedPeriod.id");
        OrgScheduleInfo orgScheduleInfo = OrgScheduleFactory.getLocalInstance(ctx).getOrgScheduleInfo((IObjectPK)new ObjectUuidPK(orgScheId), sic);
        Date startDate = orgScheduleInfo.getUserDefinedPeriod().getStartDate();
        Date endDate = orgScheduleInfo.getUserDefinedPeriod().getEndDate();
        Date afterDate = DateUtil.getAfterDay((Date)endDate);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgScheduleInfo.getCompany().getId()), (String)"recPlanBill_10backToNext");
        if (!isPermission) {
            throw new PPException(PPException.RECPLANBILL_NO_BACKTONEXT, new Object[]{orgScheduleInfo.getCompany().getName()});
        }
        if (CASWebHelper.isAdjustPeriod((Context)ctx, (CompanyOrgUnitInfo)orgScheduleInfo.getCompany())) {
            throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"IN_ADJUST_PERIOD_SINGLE")});
        }
        IRecPlanBill recPlanBill = RecPlanBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.name");
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        RecPlanBillCollection colls = recPlanBill.getRecPlanBillCollection(view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<String> successIdset = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            RecPlanBillInfo info = colls.get(i);
            try {
                Date recableDate = info.getRecableDate();
                if (!recableDate.after(afterDate) && !recableDate.equals(afterDate)) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_BackToNext_AfterCurrent"));
                }
                String companyId = info.getCompany().getId().toString();
                if (!companyId.equals(orgScheduleInfo.getCompany().getId().toString())) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RECPAY_COMPANY_NOT_MATCH", (String[])new String[]{orgScheduleInfo.getCompany().getName()}));
                }
                BillStatusEnum billStatus = info.getBillStatus();
                if (billStatus != BillStatusEnum.TONEXT) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_BackToNext_BillStatusErr"));
                }
                boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"CANTBACKTONEXT"));
                }
                ++success;
                successIdset.add(info.getId().toString());
                numbers.append(info.getNumber());
                numbers.append(",");
                continue;
            }
            catch (Exception e) {
                failNumbers.append(info.getNumber());
                failNumbers.append(",");
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"REC_BACKTONEXT_FAIL", (String[])new String[]{info.getCompany().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        if (successIdset.size() > 0) {
            try {
                String successids = FMHelper.setTran2String(successIdset);
                String sql = "UPDATE T_PP_RecPlanBill SET FBillStatus = FBillLastStatus , FRecableDate = ? , FLastUpdateUserID = ? ,FLastUpdateTime = ?  WHERE FID IN " + successids;
                UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(startDate.getTime()), userInfo.getId().toString(), new Timestamp(Calendar.getInstance().getTimeInMillis())});
                if (success != ids.length) {
                    numbers.append(failNumbers);
                }
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)"backToNext", (BOSObjectType)new RecPlanBillInfo().getBOSType(), null, (String)numbers.toString(), (String)"pp_recPlanBill_backToNext", (String)orgScheduleInfo.getCompany().getId().toString(), null);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)("\u8f6c\u4e0b\u671f\u64a4\u56de\u9519\u8bef\uff1a" + e));
                throw new PPException(PPException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BATCHBACKTONEXT_FAIL")});
            }
            finally {
                iMutex.batchReleaseObjIDForUpdate(new ArrayList(successIdset));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"ALL_BACKTONEXT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"BACKTONEXT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }
}

