/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.PayPlanBillReBack;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.IPayPlanBill;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.SrcBillTypeEnum;
import com.kingdee.eas.fm.pp.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class PayPlanSaveService {
    private static Logger logger = Logger.getLogger((String)PayPlanSaveService.class.getName());
    protected Context ctx;
    protected PayPlanBillInfo info;
    protected ServiceHandler serviceHandler;
    protected boolean isAddNew = true;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void initService(Context ctx, PayPlanBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        if (null != info.getId() && PayPlanBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.isAddNew = false;
        }
    }

    public void beforeSave() throws EASBizException, BOSException {
        this.setPropertyForBeforeSave();
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"company");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"applyPayAmount");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"payableDate");
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        this.serviceHandler.checkAccountBank(this.ctx, this.info);
        this.serviceHandler.initAmout(this.ctx, this.info);
        this.info.setUsage(this.subStringByByte(this.info.getUsage()));
    }

    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        this.info.setId(BOSUuid.read((String)pk.toString()));
        if (this.isAddNew) {
            DbUtil.execute((Context)this.ctx, (String)"update T_PP_PayPlanBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ? ", (Object[])new String[]{pk.toString()});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"pp_payPlanBill_save");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        if (this.info.getSrcBillHeadID() != null || this.info.getSourceBillId() != null) {
            IPayPlanBill iPayPlanBill = PayPlanBillFactory.getLocalInstance(this.ctx);
            try {
                this.verifySorceBill(this.info);
                ServiceHandler.dispose(this.ctx, this.info, DisposerActionEnum.SAVE);
                pk = iPayPlanBill.submit((CoreBaseInfo)this.info);
                logger.error((Object)"\u63d0\u4ea4\u6210\u529f");
                iPayPlanBill.audit4WF(pk);
                logger.error((Object)"\u5ba1\u6279\u6210\u529f");
            }
            catch (Exception e) {
                logger.error((Object)("\u6709\u4e0a\u6e38\u5355\u636e\u7684\u4ed8\u6b3e\u8ba1\u5212" + this.info.getNumber() + "\u5728PayPlanSaveService\u65b9\u6cd5afterSave\u91cc\u9762 \u6821\u9a8c\uff0c\u53cd\u5199\uff0c\u63d0\u4ea4\uff0c\u5ba1\u6279\u7684\u65f6\u5019\u5931\u8d25\uff1a"), (Throwable)e);
                throw new PPException(PPException.COMMON, new String[]{e.getMessage()});
            }
        }
    }

    protected void setPropertyForBeforeSave() {
        if (this.info.getBillStatus() == null) {
            this.info.setBillStatus(BillStatusEnum.SAVE);
        }
    }

    private void verifySorceBill(PayPlanBillInfo info) throws BOSException, EASBizException {
        boolean ps301 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("PS301", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        SrcBillTypeEnum SrcBillType = info.getSourceBillType();
        if (!ps301) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"COMPANY_PS301_false", (String[])new String[]{info.getCompany().getName()})});
        }
        if (SrcBillType == SrcBillTypeEnum.PAYREQUESTBILL) {
            this.verifySourcePayRequestBill(info.getSrcBillHeadID());
        }
        if (SrcBillTypeEnum.BC_BizAccountBill == SrcBillType || SrcBillTypeEnum.BC_TravelAccountBill == SrcBillType || SrcBillTypeEnum.BC_DailyPurchaseAccountBill == SrcBillType || SrcBillTypeEnum.BC_BizAccountOutBill == SrcBillType || SrcBillTypeEnum.BC_DailyLoanBill == SrcBillType || SrcBillTypeEnum.BC_EvectionLoanBill == SrcBillType) {
            try {
                if (PayPlanBillReBack.isSupport1toMany()) {
                    logger.error((Object)"\u5ba2\u6237\u6709\u6253\u8d39\u7528\u8865\u4e01PT166854\uff0c\u8d44\u91d1\u4e0d\u6821\u9a8c\uff0c\u8d39\u7528\u6821\u9a8c\u63a7\u5236\u4e0d\u80fd\u91cd\u590d\u751f\u6210");
                }
            }
            catch (Throwable t) {
                logger.error((Object)"\u5ba2\u6237\u6ca1\u6709\u6253\u8d39\u7528\u8865\u4e01PT166854\uff0c\u8d44\u91d1\u7ef4\u6301\u539f\u72b6\u6821\u9a8c\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210");
                logger.error((Object)t);
                this.verifySourceBCBill(info.getSourceBillId(), info.getSourceBillType());
            }
        }
    }

    private void verifySourcePayRequestBill(String entryid) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("parent.company.id");
        selector.add("parent.company.name");
        selector.add("parent.currency.id");
        selector.add("parent.auditAmount");
        selector.add("parent.billStatus");
        selector.add("parent.number");
        selector.add("parent.isPaySchedule");
        selector.add("isPayPlanCreated");
        PayRequestSumEntryInfo sumEntryInfo = PayRequestSumEntryFactory.getLocalInstance((Context)this.ctx).getPayRequestSumEntryInfo((IObjectPK)new ObjectUuidPK(entryid), selector);
        PayRequestBillInfo payReqInfo = sumEntryInfo.getParent();
        if (payReqInfo.getBillStatus() != com.kingdee.eas.fi.ar.BillStatusEnum.AUDITED) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_audit", (String[])new String[]{this.info.getNumber()})});
        }
        if (!payReqInfo.isIsPaySchedule()) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_isPaySchedule_false", (String[])new String[]{this.info.getNumber()})});
        }
        if (sumEntryInfo.isIsPayPlanCreated()) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_IsPayPlanCreated_true", (String[])new String[]{this.info.getNumber()})});
        }
        if (!payReqInfo.getCurrency().getId().equals((Object)this.info.getCurrency().getId())) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_Currency_Not_Same", (String[])new String[]{payReqInfo.getNumber()})});
        }
        if (payReqInfo.getAuditAmount().compareTo(this.info.getApplyPayAmount()) != 0) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_AuditAmount_Not_Same", (String[])new String[]{payReqInfo.getNumber()})});
        }
    }

    private void verifySourceBCBill(String BillId, SrcBillTypeEnum SrcBillType) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isPaySchedule");
        selector.add("isCreatePayPlanBill");
        selector.add("isCallBackPayPlan");
        selector.add("amount");
        selector.add("state");
        selector.add("number");
        BizCollBillBaseInfo info = null;
        if (SrcBillType == SrcBillTypeEnum.BC_BizAccountBill) {
            info = BizAccountBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_TravelAccountBill) {
            info = TravelAccountBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_DailyPurchaseAccountBill) {
            info = DailyPurchaseAccountBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_BizAccountOutBill) {
            info = BizAccountOutBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_DailyLoanBill) {
            info = DailyLoanBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_EvectionLoanBill) {
            info = EvectionLoanBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        }
        if (info != null) {
            if (info.getState() != null && !info.getState().equals((Object)StateEnum.CHECKED)) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_Checked", (String[])new String[]{info.getNumber()})});
            }
            if (!info.isIsPaySchedule()) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_PAYSCHEDULE", (String[])new String[]{info.getNumber()})});
            }
            if (info.isIsCreatePayPlanBill()) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_CREATEPLANBILL", (String[])new String[]{info.getNumber()})});
            }
            if (info.isIsCallBackPayPlan()) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_CALLBACK", (String[])new String[]{info.getNumber()})});
            }
        }
    }

    private String subStringByByte(String str) {
        if (str == null) {
            return str;
        }
        int byteNum = 90;
        byte[] bt = str.getBytes();
        if (byteNum > bt.length) {
            return str;
        }
        String substrex = new String(bt, 0, byteNum);
        return substrex;
    }
}

