/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.PayPlanBillReBack;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.IPayPlanBill;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.SrcBillTypeEnum;
import com.kingdee.eas.fm.pp.app.service.handler.ServiceHandler;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PayPlanSubmitService {
    private static Logger logger = Logger.getLogger((String)PayPlanSubmitService.class.getName());
    protected Context ctx;
    protected PayPlanBillInfo info;
    protected ServiceHandler serviceHandler;
    protected HashMap param = new HashMap();
    protected boolean isAddNew = true;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void initService(Context ctx, PayPlanBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        if (null != info.getId() && PayPlanBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.isAddNew = false;
        }
    }

    public void beforeSubmit() throws EASBizException, BOSException {
        this.nullVerify();
        this.getParams();
        this.setDefaultPropertyValue();
        if (this.info.getBillStatus() != BillStatusEnum.SUBMIT && this.info.getBillStatus() != BillStatusEnum.SAVE) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_Submit")});
        }
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        if (this.info.getSettlementType() != null && !"\u73b0\u91d1".equals(this.info.getSettlementType().getName())) {
            FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"payeeAccountBank");
            FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"payeeBank");
        }
        this.serviceHandler.checkAccountBank(this.ctx, this.info);
        this.serviceHandler.initAmout(this.ctx, this.info);
    }

    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        if (this.isAddNew) {
            DbUtil.execute((Context)this.ctx, (String)"update T_PP_PayPlanBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ? ", (Object[])new String[]{pk.toString()});
        }
        if (this.info.getSrcBillHeadID() != null || this.info.getSourceBillId() != null) {
            IPayPlanBill iPayPlanBill = PayPlanBillFactory.getLocalInstance(this.ctx);
            try {
                if (this.isAddNew) {
                    this.verifySorceBill(this.info);
                    ServiceHandler.dispose(this.ctx, this.info, DisposerActionEnum.SAVE);
                    iPayPlanBill.audit4WF(pk);
                    logger.error((Object)"\u5ba1\u6279\u6210\u529f");
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u6709\u4e0a\u6e38\u5355\u636e\u7684\u4ed8\u6b3e\u8ba1\u5212" + this.info.getNumber() + "\u5728PayPlanSubmitService\u65b9\u6cd5afterSubmit\u91cc\u9762 \u6821\u9a8c\uff0c\u53cd\u5199\uff0c\u63d0\u4ea4\uff0c\u5ba1\u6279\u7684\u65f6\u5019\u5931\u8d25\uff1a"), (Throwable)e);
                throw new PPException(PPException.COMMON, new String[]{e.getMessage()});
            }
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"pp_payPlanBill_submit");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
    }

    private void verifySorceBill(PayPlanBillInfo info) throws BOSException, EASBizException {
        boolean ps301 = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam("PS301", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        SrcBillTypeEnum SrcBillType = info.getSourceBillType();
        if (!ps301) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"COMPANY_PS301_false", (String[])new String[]{info.getCompany().getName()})});
        }
        if (SrcBillType == SrcBillTypeEnum.PAYREQUESTBILL) {
            this.verifySourcePayRequestBill(info.getSrcBillHeadID());
        }
        if (SrcBillTypeEnum.BC_BizAccountBill == SrcBillType || SrcBillTypeEnum.BC_TravelAccountBill == SrcBillType || SrcBillTypeEnum.BC_DailyPurchaseAccountBill == SrcBillType || SrcBillTypeEnum.BC_BizAccountOutBill == SrcBillType || SrcBillTypeEnum.BC_DailyLoanBill == SrcBillType || SrcBillTypeEnum.BC_EvectionLoanBill == SrcBillType) {
            try {
                if (PayPlanBillReBack.isSupport1toMany()) {
                    logger.error((Object)"\u5ba2\u6237\u6709\u6253\u8d39\u7528\u8865\u4e01PT166854\uff0c\u8d44\u91d1\u4e0d\u6821\u9a8c\uff0c\u8d39\u7528\u6821\u9a8c\u63a7\u5236\u4e0d\u80fd\u91cd\u590d\u751f\u6210");
                }
            }
            catch (Throwable t) {
                logger.error((Object)"\u5ba2\u6237\u6ca1\u6709\u6253\u8d39\u7528\u8865\u4e01PT166854\uff0c\u8d44\u91d1\u7ef4\u6301\u539f\u72b6\u6821\u9a8c\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210");
                logger.error((Object)t);
                this.verifySourceBCBill(info.getSourceBillId(), info.getSourceBillType());
            }
        }
    }

    private void verifySourcePayRequestBill(String entryid) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("parent.company.id");
        selector.add("parent.company.name");
        selector.add("parent.currency.id");
        selector.add("parent.auditAmount");
        selector.add("parent.billStatus");
        selector.add("parent.number");
        selector.add("parent.isPaySchedule");
        selector.add("isPayPlanCreated");
        PayRequestSumEntryInfo sumEntryInfo = PayRequestSumEntryFactory.getLocalInstance((Context)this.ctx).getPayRequestSumEntryInfo((IObjectPK)new ObjectUuidPK(entryid), selector);
        PayRequestBillInfo payReqInfo = sumEntryInfo.getParent();
        if (payReqInfo.getBillStatus() != com.kingdee.eas.fi.ar.BillStatusEnum.AUDITED) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_audit", (String[])new String[]{this.info.getNumber()})});
        }
        if (!payReqInfo.isIsPaySchedule()) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_isPaySchedule_false", (String[])new String[]{this.info.getNumber()})});
        }
        if (sumEntryInfo.isIsPayPlanCreated()) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_IsPayPlanCreated_true", (String[])new String[]{this.info.getNumber()})});
        }
        if (!payReqInfo.getCurrency().getId().equals((Object)this.info.getCurrency().getId())) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_Currency_Not_Same", (String[])new String[]{payReqInfo.getNumber()})});
        }
        if (payReqInfo.getAuditAmount().compareTo(this.info.getApplyPayAmount()) != 0) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_AuditAmount_Not_Same", (String[])new String[]{payReqInfo.getNumber()})});
        }
    }

    private void verifySourceBCBill(String BillId, SrcBillTypeEnum SrcBillType) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("isPaySchedule");
        selector.add("isCreatePayPlanBill");
        selector.add("isCallBackPayPlan");
        selector.add("amount");
        selector.add("state");
        selector.add("number");
        BizCollBillBaseInfo info = null;
        if (SrcBillType == SrcBillTypeEnum.BC_BizAccountBill) {
            info = BizAccountBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_TravelAccountBill) {
            info = TravelAccountBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_DailyPurchaseAccountBill) {
            info = DailyPurchaseAccountBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_BizAccountOutBill) {
            info = BizAccountOutBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_DailyLoanBill) {
            info = DailyLoanBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        } else if (SrcBillType == SrcBillTypeEnum.BC_EvectionLoanBill) {
            info = EvectionLoanBillFactory.getLocalInstance((Context)this.ctx).getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(BillId), selector);
        }
        if (info != null) {
            if (info.getState() != null && !info.getState().equals((Object)StateEnum.CHECKED)) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_Checked", (String[])new String[]{info.getNumber()})});
            }
            if (!info.isIsPaySchedule()) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_PAYSCHEDULE", (String[])new String[]{info.getNumber()})});
            }
            if (info.isIsCreatePayPlanBill()) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_CREATEPLANBILL", (String[])new String[]{info.getNumber()})});
            }
            if (info.isIsCallBackPayPlan()) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"SRCBILL_NOT_CALLBACK", (String[])new String[]{info.getNumber()})});
            }
        }
    }

    protected void setDefaultPropertyValue() {
        if (this.info.getBillStatus() == null || this.info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
            this.info.setBillStatus(BillStatusEnum.SUBMIT);
        }
    }

    protected void nullVerify() throws EASBizException {
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"applyPayDate");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"payableDate");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"company");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"applyPayAmount");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"setFundProperty");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"paymentBillType");
    }

    protected void getParams() throws EASBizException, BOSException {
        String companyId = this.info.getCompany().getId().toString();
        List numberList = this.getParamNumberList();
        for (String paramNumber : numberList) {
            this.param.put(paramNumber, null);
        }
        this.param = this.serviceHandler.getParam(this.ctx, (IObjectPK)new ObjectUuidPK(companyId), this.param);
    }

    protected List getParamNumberList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("PS301");
        list.add("PS302");
        return list;
    }

    protected void setDefaultCompany() {
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
    }
}

