/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.IRecPlanBill;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.SrcBillTypeEnum;
import com.kingdee.eas.fm.pp.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class RecPlanSaveService {
    private static Logger logger = Logger.getLogger((String)RecPlanSaveService.class.getName());
    protected Context ctx;
    protected RecPlanBillInfo info;
    protected ServiceHandler serviceHandler;
    protected boolean isAddNew = true;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void initService(Context ctx, RecPlanBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        if (null != info.getId() && RecPlanBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.isAddNew = false;
        }
    }

    public void beforeSave() throws EASBizException, BOSException {
        this.setPropertyForBeforeSave();
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"company");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"recAmount");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"recableDate");
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        this.serviceHandler.checkAccountBank(this.ctx, this.info);
        this.serviceHandler.initAmout(this.ctx, this.info);
    }

    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        this.info.setId(BOSUuid.read((String)pk.toString()));
        if (this.isAddNew) {
            DbUtil.execute((Context)this.ctx, (String)"update T_PP_RecPlanBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ? ", (Object[])new String[]{pk.toString()});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"pp_recPlanBill_save");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
        if (this.info.getSrcBillHeadID() != null && this.info.getSourceBillType() == SrcBillTypeEnum.AR_OTHERBILL) {
            IRecPlanBill iRecPlanBill = RecPlanBillFactory.getLocalInstance(this.ctx);
            try {
                ServiceHandler.dispose(this.ctx, this.info, DisposerActionEnum.SAVE);
                pk = iRecPlanBill.submit((CoreBaseInfo)this.info);
                logger.error((Object)"\u63d0\u4ea4\u6210\u529f");
                iRecPlanBill.audit4WF(pk);
                logger.error((Object)"\u5ba1\u6279\u6210\u529f");
            }
            catch (Exception e) {
                logger.error((Object)("\u6709\u4e0a\u6e38\u5355\u636e\u7684\u6536\u6b3e\u8ba1\u5212" + this.info.getNumber() + "\u5728RecPlanSaveService\u65b9\u6cd5afterSave\u91cc\u9762 \u6821\u9a8c\uff0c\u53cd\u5199\uff0c\u63d0\u4ea4\uff0c\u5ba1\u6279\u7684\u65f6\u5019\u5931\u8d25\uff1a"), (Throwable)e);
                throw new PPException(PPException.COMMON, new String[]{e.getMessage()});
            }
        }
    }

    protected void setPropertyForBeforeSave() {
        if (this.info.getBillStatus() == null) {
            this.info.setBillStatus(BillStatusEnum.SAVE);
        }
    }
}

