/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.pp.BillStatusEnum;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.app.service.handler.ServiceHandler;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class RecPlanSubmitService {
    private static Logger logger = Logger.getLogger((String)RecPlanSubmitService.class.getName());
    protected Context ctx;
    protected RecPlanBillInfo info;
    protected ServiceHandler serviceHandler;
    protected HashMap param = new HashMap();
    protected boolean isAddNew = true;

    protected ServiceHandler getServiceHandler() {
        return new ServiceHandler();
    }

    public void initService(Context ctx, RecPlanBillInfo info) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.info = info;
        this.serviceHandler = this.getServiceHandler();
        if (null != info.getId() && RecPlanBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            this.isAddNew = false;
        }
    }

    public void beforeSubmit() throws EASBizException, BOSException {
        this.nullVerify();
        this.getParams();
        this.setDefaultPropertyValue();
        if (this.info.getBillStatus() != BillStatusEnum.SUBMIT && this.info.getBillStatus() != BillStatusEnum.SAVE) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)this.ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"No_Submit")});
        }
        this.serviceHandler.setCommonPropertyValue(this.ctx, this.info);
        this.serviceHandler.checkAccountBank(this.ctx, this.info);
        this.serviceHandler.initAmout(this.ctx, this.info);
    }

    public void afterSubmit(IObjectPK pk) throws EASBizException, BOSException {
        if (this.isAddNew) {
            DbUtil.execute((Context)this.ctx, (String)"update T_PP_RecPlanBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID= ? ", (Object[])new String[]{pk.toString()});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)this.ctx, null, (BOSObjectType)this.info.getBOSType(), null, (String)this.info.getLogInfo(), (String)"pp_recPlanBill_submit");
        LogUtil.afterLog((Context)this.ctx, (IObjectPK)pkOut);
    }

    protected void setDefaultPropertyValue() {
        if (this.info.getBillStatus() == null || this.info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
            this.info.setBillStatus(BillStatusEnum.SUBMIT);
        }
    }

    protected void nullVerify() throws EASBizException {
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"recableDate");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"company");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"recAmount");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"currency");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"asstActType");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"asstActID");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)this.info, (String)"setFundProperty");
    }

    protected void getParams() throws EASBizException, BOSException {
        String companyId = this.info.getCompany().getId().toString();
        List numberList = this.getParamNumberList();
        for (String paramNumber : numberList) {
            this.param.put(paramNumber, null);
        }
        this.param = this.serviceHandler.getParam(this.ctx, (IObjectPK)new ObjectUuidPK(companyId), this.param);
    }

    protected List getParamNumberList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("PS301");
        list.add("PS302");
        return list;
    }

    protected void setDefaultCompany() {
        if (this.info.getCompany() == null) {
            this.info.setCompany(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany());
        }
    }
}

