/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.pp.app.service.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.pp.IPPBillDisposer;
import com.kingdee.eas.fm.pp.PPDisposerFactory;
import com.kingdee.eas.fm.pp.PPException;
import com.kingdee.eas.fm.pp.PayPlanBillFactory;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.fm.pp.RecPlanBillFactory;
import com.kingdee.eas.fm.pp.RecPlanBillInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyEnableStatusEnum;
import com.kingdee.eas.fm.pp.SetFundPropertyFactory;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.fm.pp.app.PayRecPlanDataImportUtil;
import com.kingdee.eas.fm.ps.RevenueAndExpensesMarkEnum;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ServiceHandler {
    private static Logger logger = Logger.getLogger((String)ServiceHandler.class.getName());

    public HashMap getParam(Context ctx, IObjectPK companyPK, HashMap paramMap) throws BOSException, EASBizException {
        Iterator it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            paramMap.put(it.next(), companyPK);
        }
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        paramMap = pc.getParamHashMap(paramMap);
        return paramMap;
    }

    public void setCommonPropertyValue(Context ctx, PayPlanBillInfo info) throws EASBizException, BOSException {
        if (info.getCompany() != null && info.getCompany().getBaseCurrency() == null) {
            CompanyOrgUnitInfo cmp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(info.getCompany().getId().toString()));
            info.setCompany(cmp);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSetFundProperty())) {
            SettlementTypeInfo settlementType = info.getSetFundProperty().getDefaultSettlementType();
            info.setSettlementType(settlementType);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType())) {
            SettlementTypeInfo settlementTypeInfo = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeInfo((IObjectPK)new ObjectStringPK(info.getSettlementType().getId().toString()));
            info.setSettlementType(settlementTypeInfo);
        }
        try {
            this.setOtherPropertyForAsstAct(ctx, info);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.matchVerify(ctx, info);
    }

    public void matchVerify(Context ctx, PayPlanBillInfo info) throws EASBizException, BOSException {
        SetFundPropertyInfo setFundPropertyInfo = info.getSetFundProperty();
        if (setFundPropertyInfo != null && setFundPropertyInfo.getId() != null) {
            if (setFundPropertyInfo.getCompany() == null || setFundPropertyInfo.getStatus() == null || setFundPropertyInfo.getFundProperty() == null || setFundPropertyInfo.getFundProperty().getRevenueAndExpensesMark() == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("company.id"));
                selector.add(new SelectorItemInfo("status"));
                selector.add(new SelectorItemInfo("fundProperty.revenueAndExpensesMark"));
                setFundPropertyInfo = SetFundPropertyFactory.getLocalInstance(ctx).getSetFundPropertyInfo((IObjectPK)new ObjectUuidPK(setFundPropertyInfo.getId().toString()), selector);
            }
            String companyId = setFundPropertyInfo.getCompany().getId().toString();
            if (!info.getCompany().getId().toString().equals(companyId)) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_Company_NotMatch")});
            }
            if (setFundPropertyInfo.getStatus() != SetFundPropertyEnableStatusEnum.ENABLE) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_NoEnable")});
            }
            if (setFundPropertyInfo.getFundProperty().getRevenueAndExpensesMark() != RevenueAndExpensesMarkEnum.EXPENSES) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_NotEXPENSES")});
            }
        }
    }

    public void matchVerify(Context ctx, RecPlanBillInfo info) throws EASBizException, BOSException {
        SetFundPropertyInfo setFundPropertyInfo = info.getSetFundProperty();
        if (setFundPropertyInfo != null && setFundPropertyInfo.getId() != null) {
            if (setFundPropertyInfo.getCompany() == null || setFundPropertyInfo.getStatus() == null || setFundPropertyInfo.getFundProperty() == null || setFundPropertyInfo.getFundProperty().getRevenueAndExpensesMark() == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("company.id"));
                selector.add(new SelectorItemInfo("status"));
                selector.add(new SelectorItemInfo("fundProperty.revenueAndExpensesMark"));
                setFundPropertyInfo = SetFundPropertyFactory.getLocalInstance(ctx).getSetFundPropertyInfo((IObjectPK)new ObjectUuidPK(setFundPropertyInfo.getId().toString()), selector);
            }
            String companyId = setFundPropertyInfo.getCompany().getId().toString();
            if (!info.getCompany().getId().toString().equals(companyId)) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_Company_NotMatch")});
            }
            if (setFundPropertyInfo.getStatus() != SetFundPropertyEnableStatusEnum.ENABLE) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_NoEnable")});
            }
            if (setFundPropertyInfo.getFundProperty().getRevenueAndExpensesMark() != RevenueAndExpensesMarkEnum.REVENUE) {
                throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"setFundProperty_NotREVENUE")});
            }
        }
    }

    public void setCommonPropertyValue(Context ctx, RecPlanBillInfo info) throws EASBizException, BOSException {
        if (info.getCompany() != null && info.getCompany().getBaseCurrency() == null) {
            CompanyOrgUnitInfo cmp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(info.getCompany().getId().toString()));
            info.setCompany(cmp);
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getLastUpdateUser())) {
            info.setLastUpdateUser(info.getCreator());
            info.setLastUpdateTime(info.getCreateTime());
        }
        if (EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSetFundProperty())) {
            SettlementTypeInfo settlementType = info.getSetFundProperty().getDefaultSettlementType();
            info.setSettlementType(settlementType);
        }
        try {
            this.setOtherPropertyForAsstAct(ctx, info);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.matchVerify(ctx, info);
    }

    private void setOtherPropertyForAsstAct(Context ctx, PayPlanBillInfo info) throws Exception {
        CSBankInfo bankInfo;
        String id = info.getAsstActID();
        if (EmptyUtil.isEmpty((String)id)) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("asstHGAttribute"));
        AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(info.getAsstActType().getId().toString()), selector);
        if ("supplier".equals(asstActTypeInfo.getAsstHGAttribute()) || "provider".equals(asstActTypeInfo.getAsstHGAttribute())) {
            SupplierCompanyInfoInfo supplierCompany;
            SupplierInfo realSupplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(id));
            if (realSupplier != null) {
                if (info.getAsstActName() == null) {
                    info.setAsstActName(realSupplier.getName());
                }
                if (info.getAsstActNumber() == null) {
                    info.setAsstActNumber(realSupplier.getNumber());
                }
            }
            if ((supplierCompany = SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()))) != null && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) && !"\u73b0\u91d1".equals(info.getSettlementType().getName())) {
                bankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)realSupplier, (String)info.getCompany().getId().toString());
                if (info.getPayeeAccountBank() == null) {
                    info.setPayeeAccountBank(bankInfo.getBankAccount());
                }
                if (info.getPayeeBank() == null) {
                    info.setPayeeBank(bankInfo.getBank());
                }
            }
        }
        if ("customer".equals(asstActTypeInfo.getAsstHGAttribute())) {
            CustomerCompanyInfoInfo companyCompany;
            CustomerInfo customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(id));
            if (customer != null) {
                if (info.getAsstActName() == null) {
                    info.setAsstActName(customer.getName());
                }
                if (info.getAsstActNumber() == null) {
                    info.setAsstActNumber(customer.getNumber());
                }
            }
            if ((companyCompany = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()))) != null && !EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType()) && !"\u73b0\u91d1".equals(info.getSettlementType().getName())) {
                bankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)customer, (String)info.getCompany().getId().toString());
                if (info.getPayeeAccountBank() == null) {
                    info.setPayeeAccountBank(bankInfo.getBankAccount());
                }
                if (info.getPayeeBank() == null) {
                    info.setPayeeBank(bankInfo.getBank());
                }
            }
        }
    }

    private void setOtherPropertyForAsstAct(Context ctx, RecPlanBillInfo info) throws Exception {
        CSBankInfo bankInfo;
        String id = info.getAsstActID();
        if (EmptyUtil.isEmpty((String)id)) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("asstHGAttribute"));
        AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(info.getAsstActType().getId().toString()), selector);
        if ("supplier".equals(asstActTypeInfo.getAsstHGAttribute()) || "provider".equals(asstActTypeInfo.getAsstHGAttribute())) {
            SupplierCompanyInfoInfo supplierCompany;
            SupplierInfo realSupplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getAsstActName() == null) {
                info.setAsstActName(realSupplier.getName());
            }
            if (info.getAsstActNumber() == null) {
                info.setAsstActNumber(realSupplier.getNumber());
            }
            if ((supplierCompany = SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()))) != null) {
                bankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)realSupplier, (String)info.getCompany().getId().toString());
                if (info.getPayerAccountBank() == null) {
                    info.setPayerAccountBank(bankInfo.getBankAccount());
                }
                if (info.getPayerBank() == null) {
                    info.setPayerBank(bankInfo.getBank());
                }
            }
        }
        if ("customer".equals(asstActTypeInfo.getAsstHGAttribute())) {
            CustomerCompanyInfoInfo companyCompany;
            CustomerInfo customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getAsstActName() == null) {
                info.setAsstActName(customer.getName());
            }
            if (info.getAsstActNumber() == null) {
                info.setAsstActNumber(customer.getNumber());
            }
            if ((companyCompany = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()))) != null) {
                bankInfo = FMHelper.getCSBankInfo((Context)ctx, (Object)customer, (String)info.getCompany().getId().toString());
                if (info.getPayerAccountBank() == null) {
                    info.setPayerAccountBank(bankInfo.getBankAccount());
                }
                if (info.getPayerBank() == null) {
                    info.setPayerBank(bankInfo.getBank());
                }
            }
        }
    }

    public void checkAccountBank(Context ctx, PayPlanBillInfo info) throws BOSException, PPException {
        if (!EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) && info.getPayeeAccountBankO() == null) {
            info.setPayeeAccountBankO(this.getActBankByAccountNumber(ctx, info.getPayeeAccountBank()));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getPayerAccountBank().getId().toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isByCurrency"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("isClosed"));
            sic.add(new SelectorItemInfo("accountType"));
            sic.add(new SelectorItemInfo("property.property"));
            view.setSelector(sic);
            view.setFilter(filter);
            AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (acctColl != null && acctColl.size() > 0) {
                AccountBankInfo payerAcctBank = acctColl.get(0);
                if (!info.getCompany().getId().toString().equals(payerAcctBank.getCompany().getId().toString())) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PayAcctBank_Company_NotMatch")});
                }
                if (payerAcctBank.isIsByCurrency() && !info.getCurrency().getId().toString().equals(payerAcctBank.getCurrency().getId().toString())) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PayAcctBank_Currency_NotMatch")});
                }
                if (payerAcctBank.isIsClosed()) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PayAcctBank_IsClosed")});
                }
                if (payerAcctBank.getAccountType() == AccountType.PAYIN) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PayAcctBank_NOT_PAYIN")});
                }
                if (payerAcctBank.getProperty().getProperty() != AccountBankPropertyEnum.Current) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"PayAcctBank_Current")});
                }
            }
        }
    }

    public void checkAccountBank(Context ctx, RecPlanBillInfo info) throws BOSException, PPException {
        if (!EmptyUtil.isEmpty((String)info.getPayerAccountBank()) && info.getPayerAccountBankO() == null) {
            info.setPayerAccountBankO(this.getActBankByAccountNumber(ctx, info.getPayerAccountBank()));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccountBank())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getPayeeAccountBank().getId().toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isByCurrency"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("isClosed"));
            sic.add(new SelectorItemInfo("accountType"));
            sic.add(new SelectorItemInfo("property.property"));
            view.setSelector(sic);
            view.setFilter(filter);
            AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (acctColl != null && acctColl.size() > 0) {
                AccountBankInfo payeeAcctBank = acctColl.get(0);
                if (!info.getCompany().getId().toString().equals(payeeAcctBank.getCompany().getId().toString())) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RecAcctBank_Company_NotMatch")});
                }
                if (payeeAcctBank.isIsByCurrency() && !info.getCurrency().getId().toString().equals(payeeAcctBank.getCurrency().getId().toString())) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RecAcctBank_Currency_NotMatch")});
                }
                if (payeeAcctBank.isIsClosed()) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RecAcctBank_IsClosed")});
                }
                if (payeeAcctBank.getProperty().getProperty() != AccountBankPropertyEnum.Current) {
                    throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"RecAcctBank_Current")});
                }
            }
        }
    }

    public AccountBankInfo getActBankByAccountNumber(Context ctx, String number) throws BOSException {
        AccountBankInfo accountBank = null;
        try {
            IAccountBank iaccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)number));
            view.setFilter(fi);
            AccountBankCollection collection = iaccountBank.getAccountBankCollection(view);
            if (collection != null && collection.size() > 0) {
                accountBank = collection.get(0);
            }
        }
        catch (BOSException e) {
            throw new BOSException(e.getMessage());
        }
        return accountBank;
    }

    public void initAmout(Context ctx, PayPlanBillInfo info) throws EASBizException, BOSException {
        if (info.getCurrency() != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("precision"));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId().toString()), selector);
            if (currency != null && currency.getPrecision() > 0) {
                BigDecimal applyPayAmount = info.getApplyPayAmount().setScale(currency.getPrecision(), 4);
                info.setApplyPayAmount(applyPayAmount);
            }
        }
        if (info.getPaperSchdlLockAmt() == null) {
            info.setPaperSchdlLockAmt(BigDecimal.ZERO);
        }
        if (info.getCashSchdlLockAmt() == null) {
            info.setCashSchdlLockAmt(BigDecimal.ZERO);
        }
        BigDecimal lockAmt = info.getCashSchdlLockAmt().add(info.getPaperSchdlLockAmt());
        info.setLockAmt(lockAmt);
        BigDecimal schdlBalanceAmt = info.getApplyPayAmount().subtract(info.getLockAmt());
        info.setSchdlBalanceAmt(schdlBalanceAmt);
        if (info.getPaperToPayAmt() == null) {
            info.setPaperToPayAmt(BigDecimal.ZERO);
        }
        if (info.getCashToPayAmt() == null) {
            info.setCashToPayAmt(BigDecimal.ZERO);
        }
        BigDecimal toPayAmount = info.getCashToPayAmt().add(info.getPaperToPayAmt());
        info.setToPayAmount(toPayAmount);
        if (info.getPaperVerifyAmt() == null) {
            info.setPaperVerifyAmt(BigDecimal.ZERO);
        }
        if (info.getCashVerifyAmt() == null) {
            info.setCashVerifyAmt(BigDecimal.ZERO);
        }
        BigDecimal verifyAmount = info.getCashVerifyAmt().add(info.getPaperVerifyAmt());
        info.setVerifyAmount(verifyAmount);
        if (info.getApplyPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"applyPayAmountNotZero")});
        }
        if (info.getApplyPayLocAmt() == null || info.getApplyPayLocAmt().compareTo(BigDecimal.ZERO) == 0) {
            CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getBaseCurrency().getId().toString()));
            BigDecimal applyPayLocAmt = PayRecPlanDataImportUtil.getLocAmount(ctx, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), baseCurrency, info.getApplyPayAmount(), info.getPayableDate());
            info.setApplyPayLocAmt(applyPayLocAmt);
        }
    }

    public void initAmout(Context ctx, RecPlanBillInfo info) throws EASBizException, BOSException {
        if (info.getRecAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new PPException(PPException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)"com.kingdee.eas.fm.pp.PpResource", (String)"recAmountNotZero")});
        }
        if (info.getRecLocAmount() == null || info.getRecLocAmount().compareTo(BigDecimal.ZERO) == 0) {
            CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getBaseCurrency().getId().toString()));
            BigDecimal recLocAmt = PayRecPlanDataImportUtil.getLocAmount(ctx, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), baseCurrency, info.getRecAmount(), info.getRecableDate());
            info.setRecLocAmount(recLocAmt);
        }
    }

    public void initAndCheckNumber(Context ctx, IObjectValue model, int i) throws EASBizException, BOSException {
        BillBaseInfo info;
        if (i == 1) {
            info = (PayPlanBillInfo)model;
            ServiceHandler.initPayPlanBillNumber(ctx, info);
            this.checkNumberDup(ctx, model);
        }
        if (i == 2) {
            info = (RecPlanBillInfo)model;
            ServiceHandler.initRecPlanBillNumber(ctx, info);
            this.checkNumberDup(ctx, model);
        }
    }

    private static void initPayPlanBillNumber(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
            }
            if (EmptyUtil.isEmpty(numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (PayPlanBillFactory.getLocalInstance(ctx).exists(filter));
    }

    private static void initRecPlanBillNumber(Context ctx, BillBaseInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
            catch (CodingRuleException e) {
                logger.info((Object)e);
            }
            if (EmptyUtil.isEmpty(numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true);
            ++i;
        } while (RecPlanBillFactory.getLocalInstance(ctx).exists(filter));
    }

    public void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new PPException(PPException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (model instanceof PayPlanBillInfo && PayPlanBillFactory.getLocalInstance(ctx).exists(filter) || model instanceof RecPlanBillInfo && RecPlanBillFactory.getLocalInstance(ctx).exists(filter)) {
            throw new PPException(PPException.CHECKDUPNUMBER, new Object[]{number});
        }
    }

    public static void dispose(Context ctx, PayPlanBillInfo info, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        IPPBillDisposer disposer = PPDisposerFactory.getInstance(ctx, info.getSourceBillType());
        BillDisposerAction disposerAction = new BillDisposerAction();
        disposerAction.setDestBill((CoreBaseInfo)info);
        disposerAction.setActionType(disposerActionEnum);
        disposer.dispose(ctx, disposerAction);
    }

    public static void dispose(Context ctx, RecPlanBillInfo info, DisposerActionEnum disposerActionEnum) throws BOSException, EASBizException {
        IPPBillDisposer disposer = PPDisposerFactory.getInstance(ctx, info.getSourceBillType());
        BillDisposerAction disposerAction = new BillDisposerAction();
        disposerAction.setDestBill((CoreBaseInfo)info);
        disposerAction.setActionType(disposerActionEnum);
        disposer.dispose(ctx, disposerAction);
    }
}

