/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.rpt.liquid.dataset;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.liquid.LiquidHelper;
import com.kingdee.eas.fm.rpt.common.RptHelper;
import com.kingdee.eas.rpts.ctrlsqldesign.param.AbstractJavaDataSet;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LiquidBaseDataSet
extends AbstractJavaDataSet {
    protected Logger logger = CoreUIObject.getLogger(((Object)((Object)this)).getClass());

    protected String getFilterParamValue(String paramName) {
        return StringUtils.cnulls(this.filterParamMap.get(paramName), null);
    }

    private void getCompanyFilterParam(Map<String, Object> paramMap) {
        String orgUnionTreeId = this.getFilterParamValue("orgUnionTree");
        Set companyIdSet = null;
        if (EmptyUtil.isEmpty((String)orgUnionTreeId) || orgUnionTreeId.indexOf("#NAME") >= 0) {
            companyIdSet = LiquidHelper.ids2Set((String)this.getFilterParamValue("company"));
        } else {
            paramMap.put("orgUnionTreeId", orgUnionTreeId);
            companyIdSet = LiquidHelper.ids2Set((String)this.getFilterParamValue("companyUnion"));
        }
        if (companyIdSet != null) {
            paramMap.put("parentCompanyId", ((String)companyIdSet.iterator().next()).toString());
        }
    }

    protected Map<String, Object> getFilterParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.getCompanyFilterParam(paramMap);
        paramMap.put("currencyIdSet", LiquidHelper.ids2Set((String)this.getFilterParamValue("currency")));
        paramMap.put("queryCycle", this.getFilterParamValue("queryCycle"));
        paramMap.put("isDiffYear", this.getFilterParamValue("isDiffYear"));
        return paramMap;
    }

    protected abstract IRowSet getQueryRowSet(Map<String, Object> var1) throws Exception;

    public IRowSet[] getCustomRowSet(Window parent, String otherDataCenter) throws Exception {
        SimpleTimer timer = new SimpleTimer();
        Map<String, Object> filterParamMap = this.getFilterParamMap();
        IRowSet rowSet = null;
        try {
            rowSet = this.getQueryRowSet(filterParamMap);
            this.logger.info((Object)String.format("rowcount: %d sepend seconds: %s", rowSet.size(), (double)timer.getTime() / 1000.0));
            return new IRowSet[]{rowSet};
        }
        catch (EASBizException e) {
            RptHelper.handleException(e);
            throw e;
        }
    }
}

