/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.app.AbstractAffairSynFacadeControllerBean;
import com.kingdee.eas.hr.base.FluctuationTypeInfo;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AffairSynFacadeControllerBean
extends AbstractAffairSynFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.AffairSynFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected IRowSet _getAffairSynResult(Context ctx, Map param) throws BOSException, EASBizException {
        String tableName = null;
        Connection conn = null;
        TempTablePool pool = null;
        IRowSet rowSet = null;
        try {
            conn = super.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            List affairTypeEnumList = (List)param.get("affariType");
            List adjustType = (List)param.get("adjustType");
            tableName = this.getTempTable(affairTypeEnumList, adjustType, conn, pool);
            Object obj = null;
            obj = param.get("orgUnit");
            if (obj != null || param.get("orgUnitMult") != null) {
                this.selectOrgUnit(ctx, param, tableName);
            }
            if ((obj = param.get("position")) != null) {
                this.selectPosition(ctx, param, tableName);
            }
            if (affairTypeEnumList != null && affairTypeEnumList.size() > 0) {
                int affairType = -1;
                String handlSqlTemplate = this.getHandleBillTemplate(ctx, param, tableName);
                int n = affairTypeEnumList.size();
                block20: for (int i = 0; i < n; ++i) {
                    affairType = ((AffairTypeEnum)((Object)affairTypeEnumList.get(i))).getValue();
                    switch (affairType) {
                        case 0: {
                            this.handleEnroll(ctx, handlSqlTemplate, param, tableName, i);
                            continue block20;
                        }
                        case 1: {
                            this.handleHire(ctx, handlSqlTemplate, param, tableName, i);
                            continue block20;
                        }
                        case 3: {
                            this.handleResign(ctx, handlSqlTemplate, param, tableName, i);
                            continue block20;
                        }
                        case 4: {
                            this.handleFire(ctx, handlSqlTemplate, param, tableName, i);
                            continue block20;
                        }
                        case 5: {
                            this.handleRetire(ctx, handlSqlTemplate, param, tableName, i);
                            continue block20;
                        }
                        case 2: {
                            this.handleFlucuation(ctx, handlSqlTemplate, param, tableName, i);
                        }
                    }
                }
            }
            rowSet = this.fetchSynResult(ctx, param, tableName);
        }
        catch (Throwable throwable) {
            try {
                if (tableName == null) throw throwable;
                pool.releaseTable(tableName);
                throw throwable;
            }
            catch (Exception ex) {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        try {
            if (tableName == null) return rowSet;
            pool.releaseTable(tableName);
            return rowSet;
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private IRowSet fetchSynResult(Context ctx, Map param, String tableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (param.get("orgUnit") != null || param.get("orgUnitMult") != null) {
            sql.append("SELECT ");
            sql.append(" admin.FDisplayName_");
            sql.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
            sql.append(" AS item ,");
            sql.append(tableName);
            sql.append(".*");
            sql.append(" FROM ");
            sql.append(tableName);
            sql.append(" INNER JOIN T_ORG_Admin admin ");
            sql.append(" ON ");
            sql.append(tableName);
            sql.append(".FID = ");
            sql.append("admin.FID ");
            sql.append("ORDER BY admin.FSortCode, admin.FLongNumber");
        } else {
            sql.append("SELECT ");
            sql.append(" admin.FName_");
            sql.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
            sql.append(" as item , ");
            sql.append("position.FName_");
            sql.append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
            sql.append(" AS position ,");
            sql.append(tableName);
            sql.append(".*");
            sql.append(" FROM ");
            sql.append(tableName);
            sql.append(" INNER JOIN T_ORG_Position position ");
            sql.append(" ON ");
            sql.append(tableName);
            sql.append(".FID = ");
            sql.append(" position.FID ");
            sql.append(" INNER JOIN T_ORG_Admin admin ON position.FAdminOrgUnitID = admin.FID ");
            sql.append(" ORDER BY admin.FSortCode, admin.FLongNumber ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet;
    }

    private void selectPosition(Context ctx, Map param, String tableName) throws BOSException {
        Object obj = param.get("position");
        String hrOrgUnitID = ((HROrgUnitInfo)param.get("hrOrgUnit")).getId().toString();
        StringBuffer sql = new StringBuffer();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (obj instanceof String) {
            sql.append("INSERT INTO ");
            sql.append(tableName);
            sql.append("(FID) ");
            sql.append(" SELECT FID FROM T_ORG_Position WHERE FAdminOrgUnitID IN (");
            sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
            sql.append("'");
            sql.append(hrOrgUnitID);
            sql.append("'");
            sql.append(" AND ");
            sql.append(" FTypeRelationID = ");
            sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
            sql.append(" AND ");
            sql.append("FFromUnitID IN (");
            sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
            sql.append("'");
            sql.append(userID);
            sql.append("'");
            sql.append(" AND ");
            sql.append("FType = ");
            sql.append(20);
            sql.append("))");
        } else {
            Object[] array = (Object[])obj;
            sql.append("INSERT INTO ");
            sql.append(tableName);
            sql.append("(FID) ");
            sql.append("SELECT FID FROM T_ORG_Position WHERE FID IN( ");
            for (int i = 0; i < array.length; ++i) {
                sql.append("'");
                sql.append(((PositionInfo)array[i]).getId().toString());
                sql.append("',");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void selectOrgUnit(Context ctx, Map param, String tableName) throws BOSException {
        Object obj = param.get("orgUnit");
        Object orgs = param.get("orgUnitMult");
        String hrOrgUnitID = ((HROrgUnitInfo)param.get("hrOrgUnit")).getId().toString();
        boolean includeSealUp = false;
        if (param.get("includeSealUp") != null) {
            includeSealUp = (Boolean)param.get("includeSealUp");
        }
        StringBuffer sql = new StringBuffer();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (obj instanceof String && orgs == null) {
            sql.append("INSERT INTO ");
            sql.append(tableName);
            sql.append("(FID)");
            sql.append(" SELECT distinct T_ORG_Admin.FID ");
            sql.append(" FROM T_ORG_Admin ");
            sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
            sql.append(" WHERE ");
            if (!includeSealUp) {
                sql.append("T_ORG_Admin.FIsSealUp = 0 and ");
            }
            sql.append(" T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID = '");
            sql.append(userID);
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
            sql.append(" AND T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgUnitID);
            sql.append("'");
        } else {
            sql.append(" INSERT INTO ");
            sql.append(tableName);
            sql.append("( FID )");
            sql.append(" select fid from T_ORG_Admin where ");
            if (!includeSealUp) {
                sql.append("FIsSealUp = 0 and ");
            }
            sql.append("(");
            if (orgs != null) {
                sql.append("fid in (");
                sql.append(OrgStringUtil.getOrgIdsSql((Object[])((Object[])orgs)));
                sql.append(")");
            } else {
                AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)obj;
                boolean includeChild = (Boolean)param.get("includeChild");
                if (includeChild) {
                    sql.append("fid = '");
                    sql.append(orgUnit.getId().toString());
                    sql.append("' or ");
                    sql.append(" FLongNumber like '");
                    sql.append(orgUnit.getLongNumber() + "!%'");
                } else {
                    sql.append("fid = '");
                    sql.append(orgUnit.getId().toString());
                    sql.append("'");
                }
            }
            sql.append(") AND fid IN (");
            sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
            sql.append("'");
            sql.append(hrOrgUnitID);
            sql.append("'");
            sql.append(" AND ");
            sql.append(" FTypeRelationID = ");
            sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
            sql.append(" AND ");
            sql.append("FFromUnitID IN (");
            sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
            sql.append("'");
            sql.append(userID);
            sql.append("'");
            sql.append(" AND ");
            sql.append("FType = ");
            sql.append(20);
            sql.append("))");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getHandleBillTemplate(Context ctx, Map param, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET FAffair@index@");
        sql.append("= (");
        sql.append("SELECT count(distinct entry.FID) FROM @entryTable@ entry INNER JOIN ");
        sql.append("@billTable@ bill ON entry.@entryToBillField@ = bill.FID ");
        if (param.get("orgUnit") != null || param.get("orgUnitMult") != null) {
            sql.append("INNER JOIN T_ORG_Position position ON entry.@entryPositionField@ = position.FID ");
            sql.append(" WHERE ( ");
            sql.append(tableName);
            sql.append(".FID = ");
            sql.append("position.FAdminOrgUnitID )");
        } else if (param.get("position") != null) {
            sql.append(" WHERE ( ");
            sql.append(tableName);
            sql.append(".FID = ");
            sql.append("entry.@entryPositionField@ )");
        }
        this.addFilterCondition(sql, param);
        sql.append(")");
        return sql.toString();
    }

    private void handleEnroll(Context ctx, String sqlTemplate, Map param, String tableName, int index) throws BOSException {
        String sql = sqlTemplate.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FEnrollDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + index).replaceFirst("@entryTable@", "T_HR_EnrollBillEntry").replaceFirst("@billTable@", "T_HR_EnrollBill").replaceFirst("@entryToBillField@", "FEnrollID").replaceFirst("@entryPositionField@", "FPositionID");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void handleHire(Context ctx, String sqlTemplate, Map param, String tableName, int index) throws BOSException {
        String sql = sqlTemplate.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FHireDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + index).replaceFirst("@entryTable@", "T_HR_HireBillEntry").replaceFirst("@billTable@", "T_HR_HireBill").replaceFirst("@entryToBillField@", "FBillID").replaceFirst("@entryPositionField@", "FPositionID");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void handleResign(Context ctx, String sqlTemplate, Map param, String tableName, int index) throws BOSException {
        String sql = sqlTemplate.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FEffectDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + index).replaceFirst("@entryTable@", "T_HR_ResignBillEntry").replaceFirst("@billTable@", "T_HR_ResignBill").replaceFirst("@entryToBillField@", "FBillID").replaceFirst("@entryPositionField@", "FPositionID");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void handleFire(Context ctx, String sqlTemplate, Map param, String tableName, int index) throws BOSException {
        String sql = sqlTemplate.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FEffectDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + index).replaceFirst("@entryTable@", "T_HR_FireBillEntry").replaceFirst("@billTable@", "T_HR_FireBill").replaceFirst("@entryToBillField@", "FBillID").replaceFirst("@entryPositionField@", "FPositionID");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void handleRetire(Context ctx, String sqlTemplate, Map param, String tableName, int index) throws BOSException {
        String sql = sqlTemplate.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FRetireDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + index).replaceFirst("@entryTable@", "T_HR_RetireBillEntry").replaceFirst("@billTable@", "T_HR_RetireBill").replaceFirst("@entryToBillField@", "FBillID").replaceFirst("@entryPositionField@", "FPositionID");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void handleFlucuation(Context ctx, String sqlTemplate, Map param, String tableName, int index) throws BOSException {
        List adjustType = (List)param.get("adjustType");
        if (adjustType.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET @setField@@index@");
        sql.append("= (");
        sql.append("SELECT count(distinct entry.FID) FROM @entryTable@ entry INNER JOIN ");
        sql.append("@billTable@ bill ON entry.@entryToBillField@ = bill.FID ");
        if (param.get("orgUnit") != null || param.get("orgUnitMult") != null) {
            sql.append("INNER JOIN T_ORG_Position position ON ( entry.@entryPositionField1@ = position.FID OR entry.@entryPositionField2@ = position.FID)");
            sql.append(" WHERE ( ");
            sql.append(tableName);
            sql.append(".FID = ");
            sql.append("position.FAdminOrgUnitID AND entry.FTypeID IN (@type@) )");
        } else if (param.get("position") != null) {
            sql.append(" WHERE ( (");
            sql.append(tableName);
            sql.append(".FID = ");
            sql.append("entry.@entryPositionField1@");
            sql.append(" OR ");
            sql.append(tableName);
            sql.append(".FID= ");
            sql.append(" entry.@entryPositionField2@)");
            sql.append("AND entry.FTypeID IN (@type@))");
        }
        this.addFilterCondition(sql, param);
        sql.append(")");
        String template = sql.toString();
        String execSQL = null;
        FluctuationTypeInfo type = null;
        int n = adjustType.size();
        for (int i = 0; i < n; ++i) {
            type = (FluctuationTypeInfo)adjustType.get(i);
            execSQL = template.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FEffectDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + i).replaceFirst("@entryTable@", "T_HR_FluctuationBillEntry").replaceFirst("@billTable@", "T_HR_FluctuationBill").replaceFirst("@entryToBillField@", "FBillID").replaceFirst("@entryPositionField1@", "FOldPositionId").replaceFirst("@entryPositionField2@", "FNewPositionId").replaceFirst("@type@", "'" + type.getId().toString() + "'").replaceFirst("@setField@", "FAdjust");
            DbUtil.execute((Context)ctx, (String)execSQL);
        }
        StringBuffer allType = new StringBuffer();
        int n2 = adjustType.size();
        for (int i = 0; i < n2; ++i) {
            type = (FluctuationTypeInfo)adjustType.get(i);
            allType.append("'");
            allType.append(type.getId().toString());
            allType.append("'");
            allType.append(",");
        }
        allType.deleteCharAt(allType.length() - 1);
        execSQL = template.replaceAll("@applyDate@", "bill.FApplyDate").replaceAll("@validDate@", "entry.FEffectDate").replaceFirst("@bizState@", "bill.FState").replaceFirst("@index@", "" + index).replaceFirst("@entryTable@", "T_HR_FluctuationBillEntry").replaceFirst("@billTable@", "T_HR_FluctuationBill").replaceFirst("@entryToBillField@", "FBillID").replaceFirst("@entryPositionField1@", "FOldPositionId").replaceFirst("@entryPositionField2@", "FNewPositionId").replaceFirst("@type@", allType.toString()).replaceFirst("@setField@", "FAffair");
        DbUtil.execute((Context)ctx, (String)execSQL);
    }

    private void addFilterCondition(StringBuffer completeSql, Map param) {
        Object obj;
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        if (param.get("applyBeginDate") != null) {
            sql.append(" AND ");
            obj = param.get("applyBeginDate");
            if (obj != null) {
                sql.append(" ( @applyDate@ >= ");
                sql.append("TO_DATE('");
                sql.append(sf.format((Date)obj));
                sql.append("'))");
            }
        }
        if ((obj = param.get("aaplyEndDate")) != null) {
            sql.append(" AND ");
            sql.append("( @applyDate@ < ");
            sql.append("TO_DATE ('");
            calendar.setTime((Date)obj);
            calendar.add(5, 1);
            sql.append(sf.format(calendar.getTime()));
            sql.append("'))");
        }
        if ((obj = param.get("validBeginDate")) != null) {
            sql.append(" AND ");
            if (obj != null) {
                sql.append(" ( @validDate@ >= ");
                sql.append("TO_DATE('");
                sql.append(sf.format((Date)obj));
                sql.append("'))");
            }
        }
        if ((obj = param.get("validEndDate")) != null) {
            sql.append(" AND ");
            sql.append("( @validDate@ < ");
            sql.append("TO_DATE ('");
            calendar.setTime((Date)obj);
            calendar.add(5, 1);
            sql.append(sf.format(calendar.getTime()));
            sql.append("'))");
        }
        if ((obj = param.get("auditSTATE")) != null) {
            sql.append(" AND ");
            sql.append("( @bizState@ = ");
            HRAffairState state = (HRAffairState)((Object)obj);
            sql.append(state.getValue());
            sql.append(")");
        }
        completeSql.append(sql);
    }

    private String getTempTable(List affairTypeEnumList, List adjustType, Connection conn, TempTablePool pool) throws BOSException {
        int i;
        int n;
        StringBuffer sql = new StringBuffer("create table ");
        sql.append("t1");
        sql.append(" (  FID Varchar(44),");
        if (affairTypeEnumList != null) {
            n = affairTypeEnumList.size();
            for (i = 0; i < n; ++i) {
                sql.append("FAffair");
                sql.append(i);
                sql.append(" INT DEFAULT 0 ,");
            }
        }
        if (adjustType == null || adjustType.size() == 0) {
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
        } else {
            n = adjustType.size();
            for (i = 0; i < n; ++i) {
                sql.append("FAdjust");
                sql.append(i);
                sql.append(" INT DEFAULT 0 ,");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
        }
        String tableName = null;
        try {
            tableName = pool.createTempTable(sql.toString());
        }
        catch (Exception ex) {
            logger.error((Object)sql.toString());
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return tableName;
    }
}

