/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairTypeEnum;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.app.AbstractAffairUpgradeFacadeControllerBean;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AffairUpgradeFacadeControllerBean
extends AbstractAffairUpgradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.AffairUpgradeFacadeControllerBean");
    private static final String BILL_UPGRADE = "BILL_UPGRADE";

    @Override
    protected BatchProcessedResult _bizCheck(Context ctx) throws BOSException, EASBizException {
        BatchProcessedResult result = null;
        result = this.checkOldBillInProcesss(ctx);
        return result;
    }

    @Override
    protected BatchProcessedResult _bizUpgrade(Context ctx) throws BOSException, EASBizException {
        BatchProcessedResult result = null;
        result = this.checkOldBillInProcesss(ctx);
        this.upgradeHistory(ctx);
        this.upgradeBill(ctx);
        this.upgradeBillRelated(ctx);
        if (!HRInitFactory.getLocalInstance((Context)ctx).exists("where key='BILL_UPGRADE'")) {
            HRInitInfo info = new HRInitInfo();
            info.setKey(BILL_UPGRADE);
            info.setValue("true");
            info.put("IS_CU_FILTER", (Object)Boolean.FALSE);
            HRInitFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)info);
        }
        return result;
    }

    @Override
    protected boolean _isUpgrade(Context ctx) throws BOSException, EASBizException {
        HRInitCollection upgrade = HRInitFactory.getLocalInstance((Context)ctx).getHRInitCollection("where key = 'BILL_UPGRADE'");
        return upgrade != null && upgrade.size() > 0;
    }

    private BatchProcessedResult checkOldBillInProcesss(Context ctx) throws BOSException, EASBizException {
        BatchProcessedResult result = new BatchProcessedResult();
        result.setTitle(ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"10_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale()));
        IDynamicObject idy = DynamicObjectFactory.getLocalInstance((Context)ctx);
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String oql = "select bill.id,bill.number,bill.hrOrgUnit.displayName where ((bill.bizState = 0 or bill.bizState = 1 or bill.bizState = -1) or (bill.bizState = 3 and @effectDate >= {ts'" + sFormat.format(cal.getTime()) + "'}))";
        String tOql = null;
        String msg = null;
        tOql = StringUtils.replace((String)oql, (String)"@effectDate", (String)"enrollDate");
        msg = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"11_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale());
        this.checkBillInProcess(idy, result, BOSObjectType.create((String)"25404999"), tOql, msg);
        tOql = StringUtils.replace((String)oql, (String)"@effectDate", (String)"effectDate");
        msg = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"12_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale());
        this.checkBillInProcess(idy, result, BOSObjectType.create((String)"5681143E"), tOql, msg);
        tOql = StringUtils.replace((String)oql, (String)"@effectDate", (String)"desireDate");
        msg = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"13_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale());
        this.checkBillInProcess(idy, result, BOSObjectType.create((String)"79E18FC8"), tOql, msg);
        tOql = StringUtils.replace((String)oql, (String)"@effectDate", (String)"retireDate");
        msg = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"14_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale());
        this.checkBillInProcess(idy, result, BOSObjectType.create((String)"37A34A7D"), tOql, msg);
        tOql = StringUtils.replace((String)oql, (String)"@effectDate", (String)"desireDate");
        msg = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"15_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale());
        this.checkBillInProcess(idy, result, BOSObjectType.create((String)"91B41A02"), tOql, msg);
        tOql = StringUtils.replace((String)oql, (String)"@effectDate", (String)"hireDate");
        msg = ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"16_AffairUpgradeFacadeControllerBean", (Locale)ctx.getOriginLocale());
        this.checkBillInProcess(idy, result, BOSObjectType.create((String)"6EBA2704"), tOql, msg);
        return result;
    }

    private void checkBillInProcess(IDynamicObject idy, BatchProcessedResult result, BOSObjectType type, String oql, String msg) throws BOSException, EASBizException {
        IObjectCollection col = idy.getCollection(type, oql);
        if (col != null && col.size() > 0) {
            IObjectValue v = null;
            HRAffairBaseInfo info = null;
            StringBuffer message = new StringBuffer();
            message.append(msg);
            message.append(":\r\n");
            HashSet<String> billNumSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                v = col.getObject(i);
                info = (HRAffairBaseInfo)v.get("bill");
                if (info == null || billNumSet.contains(info.getNumber())) continue;
                billNumSet.add(info.getNumber());
                if (info.getHrOrgUnit() != null) {
                    message.append("\"");
                    message.append(info.getHrOrgUnit().getDisplayName());
                    message.append("\" , ");
                }
                message.append("\"");
                message.append(info.getNumber());
                message.append("\"");
                if (i == size - 1) continue;
                message.append("\n");
            }
            result.addinvalidInfo(message.toString());
        }
    }

    private BatchProcessedResult upgradeHistory(Context ctx) throws BOSException, EASBizException {
        BatchProcessedResult result = null;
        this.insertToBiz(ctx, "B41CAA3F", AffairTypeEnum.ENROLL, "t_hr_enrollbillEntry", "t_hr_enrollbill", "FEnrollID", null, null);
        this.insertToBiz(ctx, "B65CCEF1", AffairTypeEnum.HIRE, "T_HR_HireBillEntry", "T_HR_HireBill", "FBillID", null, null);
        this.upgradeFluc(ctx);
        this.insertToBiz(ctx, "CC58A617", AffairTypeEnum.RESIGN, "T_HR_ResignBillEntry", "T_HR_ResignBill", "FBillID", null, null);
        this.insertToBiz(ctx, "CC58A617", AffairTypeEnum.FIRE, "T_HR_FireBillEntry", "T_HR_FireBill", "FBillID", null, null);
        this.insertToBiz(ctx, "19438A0C", AffairTypeEnum.RETIRE, "T_HR_RetireBillEntry", "T_HR_RetireBill", "FBillID", null, null);
        DbUtil.execute((Context)ctx, (String)"update T_HR_AffairHistory set FIsUpgrade = 1 where FIsUpgrade = 0");
        return result;
    }

    private void upgradeFluc(Context ctx) throws BOSException, EASBizException {
        String tableSql = " inner join T_HR_BDFluctuationType t on a.FFluctuationTypeID = t.fid ";
        StringBuffer conditonSql = null;
        String type = null;
        type = "1";
        conditonSql = new StringBuffer();
        conditonSql.append(" a.FIsUpgrade=0 and t.FType= '");
        conditonSql.append(type);
        conditonSql.append("' and e.FprimaryFlu= '");
        conditonSql.append("0");
        conditonSql.append("'");
        this.insertToBiz(ctx, "B3F8AB50", AffairTypeEnum.FLUCTUATION, "T_HR_FluctuationBillEntry", "T_HR_FluctuationBill", "FBillID", conditonSql.toString(), tableSql);
        type = "2";
        conditonSql = new StringBuffer();
        conditonSql.append(" a.FIsUpgrade=0 and t.FType= '");
        conditonSql.append(type);
        conditonSql.append("'");
        this.insertToBiz(ctx, "4A33F25D", AffairTypeEnum.FLUCTUATION, "T_HR_FluctuationBillEntry", "T_HR_FluctuationBill", "FBillID", conditonSql.toString(), tableSql);
        StringBuffer orgFilter = new StringBuffer();
        orgFilter.append(" select * from T_ORG_UnitRelation ");
        orgFilter.append(" where T_ORG_UnitRelation.FFromUnitID = a.FOldDeptID and exists( ");
        orgFilter.append(" select * from T_ORG_UnitRelation R where R.FFromUnitID= a.FNewDeptID and R.FToUnitID = T_ORG_UnitRelation.FToUnitID");
        orgFilter.append(" )");
        StringBuffer con = new StringBuffer();
        con.append(" a.FIsUpgrade=0 and ((t.FType= '");
        con.append("1");
        con.append("' and e.FprimaryFlu= '");
        con.append("1");
        con.append("') or t.FType = '");
        con.append("0");
        con.append("') ");
        conditonSql = new StringBuffer();
        conditonSql.append(con);
        this.insertToBiz(ctx, "C0DAD00D", AffairTypeEnum.FLUCTUATION, "T_HR_FluctuationBillEntry", "T_HR_FluctuationBill", "FBillID", conditonSql.toString(), tableSql);
    }

    private void insertToBiz(Context ctx, String bosType, AffairTypeEnum type, String eTab, String bTab, String bField, String condition, String otherTable) throws BOSException, EASBizException {
        StringBuffer tableSql = new StringBuffer();
        tableSql.append(" from T_HR_AffairHistory  a ");
        tableSql.append(" inner join ");
        tableSql.append(eTab);
        tableSql.append(" e on e.fid = a.FAffairBillEntryId ");
        tableSql.append(" inner join ");
        tableSql.append(bTab);
        tableSql.append(" b on b.fid = e.");
        tableSql.append(bField);
        if (!StringUtils.isEmpty((String)otherTable)) {
            tableSql.append(otherTable);
        }
        tableSql.append(" where a.FIsUpgrade=0 and a.FAffairType = ");
        tableSql.append(type.getValue());
        if (!StringUtils.isEmpty((String)condition)) {
            tableSql.append(" and ");
            tableSql.append(condition);
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_HR_AffairBizDetail (");
        insertSql.append("FID,FBillBOSType,FBillID,FNumber,FEntryID,FEffectDate,FPersonID,FBillAdminID,FHrOrgUnitID,");
        insertSql.append("FOldAdminID,FNewAdminID,FOldPositionID,FNewPositionID,FApplyDate,FBillState,FApplierID,FOldBill) ");
        insertSql.append(" select ");
        insertSql.append("newbosid('A702BC28') as FBizId,'");
        insertSql.append(bosType);
        insertSql.append("' as FBosType,b.fid,b.fnumber,a.FAffairBillEntryId,a.FEffectDate,a.FPersonID,b.FAdminOrgUnitID,");
        insertSql.append("a.FHROrgUnitID,a.FOldDeptID,a.FNewDeptID,a.FOldPositionID,a.FNewPositionID,b.FApplyDate,3 as FBillState,b.FProposer,1 as FOldBill");
        insertSql.append(tableSql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        insertSql = new StringBuffer();
        insertSql.append("insert into T_HR_AffairBizHistory (");
        insertSql.append("FID,FBillBOSType,FBillID,FEntryID,FEffectDate,FPersonID,FBillAdminID,FHrOrgUnitID,");
        insertSql.append("FOldAdminID,FNewAdminID,FOldPositionID,FNewPositionID,FTuned,FOldAdminIoType,FNewAdminIoType)");
        insertSql.append(" select ");
        insertSql.append("newbosid('13BBBB9D') as FBizID,'");
        insertSql.append(bosType);
        insertSql.append("' as FBosType,b.fid,a.FAffairBillEntryId,a.FEffectDate,a.FPersonID,b.FAdminOrgUnitID,");
        insertSql.append("a.FHROrgUnitID,a.FOldDeptID,a.FNewDeptID,a.FOldPositionID,a.FNewPositionID,a.FIsTuned,a.FOldInOutType,a.FNewInOutType");
        insertSql.append(tableSql);
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void upgradeBill(Context ctx) throws BOSException, EASBizException {
        String tempTable = null;
        String createTempTable = "create Table t_ID_Create(newID VARCHAR(44),oldID VARCHAR(44))";
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTable = pool.createTempTable(createTempTable);
            this.insertIntoAffairUpgrade(ctx, "B41CAA3F", "04BEFD73", "t_hr_enrollbill", "t_hr_enrollbillentry", "FENROLLID", AffairTypeEnum.ENROLL, 0, tempTable, null, null);
            this.insertBill(ctx, "t_hr_empenrollbizbill", "t_hr_enrollbill", null, null);
            this.insertBillEntry(ctx, "t_hr_empenrollbizbillEntry", "t_hr_enrollbillentry", AffairTypeEnum.ENROLL, 0);
            this.insertIntoAffairUpgrade(ctx, "B65CCEF1", "08B3F801", "t_hr_hirebill", "t_hr_hirebillentry", "FBillID", AffairTypeEnum.HIRE, 0, tempTable, null, null);
            this.insertBill(ctx, "t_hr_empHireBizBill", "t_hr_hirebill", null, null);
            this.insertBillEntry(ctx, "t_hr_empHireBizBillEntry", "t_hr_hirebillentry", AffairTypeEnum.HIRE, 0);
            this.insertIntoAffairUpgrade(ctx, "CC58A617", "9A5EA89B", "t_hr_resignbill", "t_hr_resignbillentry", "FBillID", AffairTypeEnum.RESIGN, 0, tempTable, null, null);
            this.insertBill(ctx, "T_HR_ResignBizBill", "t_hr_resignbill", null, null);
            this.insertBillEntry(ctx, "T_HR_ResignBizBillEntry", "t_hr_resignbillentry", AffairTypeEnum.RESIGN, 0);
            this.insertIntoAffairUpgrade(ctx, "CC58A617", "9A5EA89B", "t_hr_firebill", "t_hr_firebillentry", "FBillID", AffairTypeEnum.FIRE, 0, tempTable, null, null);
            this.insertBill(ctx, "T_HR_ResignBizBill", "t_hr_firebill", null, null);
            this.insertBillEntry(ctx, "T_HR_ResignBizBillEntry", "t_hr_firebillentry", AffairTypeEnum.FIRE, 0);
            this.insertIntoAffairUpgrade(ctx, "19438A0C", "CDDCF5C6", "t_hr_retirebill", "t_hr_retirebillentry", "FBillID", AffairTypeEnum.RETIRE, 0, tempTable, null, null);
            this.insertBill(ctx, "T_HR_RetireBizBill", "t_hr_retirebill", null, null);
            this.insertBillEntry(ctx, "T_HR_RetireBizBillEntry", "t_hr_retirebillentry", AffairTypeEnum.RETIRE, 0);
            this.upgradeFluctuationBill(ctx, tempTable);
            this.insertApproveInfo(ctx);
            this.updateHistory(ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                pool.releaseTable(tempTable);
            }
        }
    }

    private void upgradeFluctuationBill(Context ctx, String tempTable) throws BOSException, EASBizException {
        String tableSql = " inner join T_HR_BDFluctuationType t on e.FTypeID = t.fid ";
        StringBuffer conditonSql = null;
        String type = null;
        String billInsertCon = " u.FSinal = " + AffairTypeEnum.FLUCTUATION.getValue();
        type = "1";
        conditonSql = new StringBuffer();
        conditonSql.append(" t.FType= '");
        conditonSql.append(type);
        conditonSql.append("' and e.FprimaryFlu= '");
        conditonSql.append("0");
        conditonSql.append("'");
        this.insertIntoAffairUpgrade(ctx, "B3F8AB50", "603DFF02", "t_hr_fluctuationBill", "t_hr_fluctuationBillEntry", "FBillID", AffairTypeEnum.FLUCTUATION, 0, tempTable, tableSql, conditonSql.toString());
        this.insertBill(ctx, "T_HR_PluralityAddBizBill", "t_hr_fluctuationBill", null, billInsertCon + 0);
        this.insertBillEntry(ctx, "T_HR_PluralityAddBizBillEntry", "t_hr_fluctuationBillEntry", AffairTypeEnum.FLUCTUATION, 0);
        type = "2";
        conditonSql = new StringBuffer();
        conditonSql.append(" t.FType= '");
        conditonSql.append(type);
        conditonSql.append("'");
        this.insertIntoAffairUpgrade(ctx, "4A33F25D", "B5261815", "t_hr_fluctuationBill", "t_hr_fluctuationBillEntry", "FBillID", AffairTypeEnum.FLUCTUATION, 1, tempTable, tableSql, conditonSql.toString());
        this.insertBill(ctx, "T_HR_PluralityReplaceBizBill", "t_hr_fluctuationBill", null, billInsertCon + 1);
        this.insertBillEntry(ctx, "T_HR_PluralityRBBE", "t_hr_fluctuationBillEntry", AffairTypeEnum.FLUCTUATION, 1);
        StringBuffer orgFilter = new StringBuffer();
        orgFilter.append(" select * from T_ORG_UnitRelation ");
        orgFilter.append(" where T_ORG_UnitRelation.FFromUnitID = h.FOldDeptID and exists( ");
        orgFilter.append(" select * from T_ORG_UnitRelation R where R.FFromUnitID= h.FNewDeptID and R.FToUnitID = T_ORG_UnitRelation.FToUnitID");
        orgFilter.append(" )");
        StringBuffer con = new StringBuffer();
        con.append(" ((t.FType= '");
        con.append("1");
        con.append("' and e.FprimaryFlu= '");
        con.append("1");
        con.append("') or t.FType = '");
        con.append("0");
        con.append("') ");
        conditonSql = new StringBuffer();
        conditonSql.append(con);
        this.insertIntoAffairUpgrade(ctx, "C0DAD00D", "C1964865", "t_hr_fluctuationBill", "t_hr_fluctuationBillEntry", "FBillID", AffairTypeEnum.FLUCTUATION, 2, tempTable, tableSql, conditonSql.toString());
        this.insertBill(ctx, "T_HR_FluctuationBizBill", "t_hr_fluctuationBill", null, billInsertCon + 2);
        this.insertBillEntry(ctx, "T_HR_FluctuationBizBillEntry", "t_hr_fluctuationBillEntry", AffairTypeEnum.FLUCTUATION, 2);
    }

    private void insertIntoAffairUpgrade(Context ctx, String billBosType, String entryBosType, String oldBillTable, String oldEntryTable, String joinField, AffairTypeEnum type, int signal, String tempTable, String joinTable, String condition) throws BOSException, EASBizException {
        String deleteSql = "delete from " + tempTable;
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        StringBuffer createBillID = new StringBuffer();
        createBillID.append("insert into ");
        createBillID.append(tempTable);
        createBillID.append("(newID,oldID)");
        createBillID.append(" select isnull(u.FNewBillID,newbosid('");
        createBillID.append(billBosType);
        createBillID.append("')) as newBillID,b.FID");
        createBillID.append(" from ");
        createBillID.append(oldBillTable);
        createBillID.append(" b ");
        createBillID.append(" left outer join ");
        createBillID.append("(select distinct FNewBillID,FOldBillID from T_HR_AffairUpgrade) u on u.FOldBillID = b.fid ");
        createBillID.append(" where b.FState = 3");
        DbUtil.execute((Context)ctx, (String)createBillID.toString());
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into T_HR_AffairUpgrade(FID,FNewBillID,FNewBillEntryID,FOldBillID,FOldBillEntryID,FSyn,FSinal) ");
        insertSql.append(" select newbosid('8B8E1800'),b.newID,newbosid('");
        insertSql.append(entryBosType);
        insertSql.append("') as newEntryID,b.oldID as oldBillID,e.FID as oldEntryID,0,");
        if (type.getValue() == 0) {
            insertSql.append("9");
        }
        insertSql.append(type.getValue());
        insertSql.append(signal);
        insertSql.append(" from ");
        insertSql.append(oldEntryTable);
        insertSql.append(" e ");
        insertSql.append(" inner join ");
        insertSql.append(tempTable);
        insertSql.append(" b on b.oldID = e.");
        insertSql.append(joinField);
        insertSql.append(" inner join T_HR_AffairHistory h on e.fid = h.FAffairBillEntryId ");
        if (!StringUtils.isEmpty((String)joinTable)) {
            insertSql.append(joinTable);
        }
        insertSql.append(" where h.FIsUpgrade=1 and h.FAffairType = ");
        insertSql.append(type.getValue());
        insertSql.append(" and not exists(select * from T_HR_AffairUpgrade where FOldBillEntryID = e.FID) ");
        if (!StringUtils.isEmpty((String)condition)) {
            insertSql.append(" and ");
            insertSql.append(condition);
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void insertBill(Context ctx, String newBillTable, String oldBillTable, String joinTable, String condition) throws BOSException, EASBizException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(newBillTable);
        insertSql.append("(FAPPLIERID,FAPPLYDATE,FADMINORGUNITID,FHRORGUNITID,FBILLSTATE,FAPPROVETYPE,FNUMBER,FDESCRIPTION,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID,FIsMultiEntry,FID)");
        insertSql.append(" select distinct ");
        insertSql.append(" o.FPROPOSER,o.FAPPLYDATE,o.FADMINORGUNITID,o.FHRORGUNITID,o.FState,o.fapprovestate,o.FNUMBER,o.FPHONE,o.FCREATORID,o.FCREATETIME,o.FLASTUPDATEUSERID,o.FLASTUPDATETIME,o.FCONTROLUNITID,o.FIsMultiEntry,u.FNewBillID");
        insertSql.append(" from ");
        insertSql.append(oldBillTable);
        insertSql.append(" o inner join T_HR_AffairUpgrade u on o.fid = u.FOldBillID ");
        if (!StringUtils.isEmpty((String)joinTable)) {
            insertSql.append(joinTable);
        }
        insertSql.append(" where u.FSyn = 0 and o.FState = 3");
        insertSql.append(" and not exists(select * from ");
        insertSql.append(newBillTable);
        insertSql.append(" where FID = u.FNewBillID) ");
        if (!StringUtils.isEmpty((String)condition)) {
            insertSql.append(" and ");
            insertSql.append(condition);
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
        StringBuffer approveDate = new StringBuffer();
        approveDate.append("update ");
        approveDate.append(newBillTable);
        approveDate.append(" set FBizDate = ");
        approveDate.append(" ( ");
        approveDate.append("   select max(T.FCreateTime) ");
        approveDate.append("   from ");
        approveDate.append("   ( ");
        approveDate.append("    select fid,FBillID,FCreateTime from T_BAS_MultiApprove ");
        approveDate.append("    union all ");
        approveDate.append("    select fid,FBillID,FCreateTime from T_BAS_MultiApproveHst ");
        approveDate.append("   ) as T ");
        approveDate.append("   inner join T_HR_AffairUpgrade u on T.FBillID = u.FOldBillID ");
        approveDate.append("   where u.FNewBillID = ");
        approveDate.append(newBillTable);
        approveDate.append(".FID ");
        approveDate.append(" )");
        approveDate.append(" where FBillState = 3 and FBizDate is null and exists ");
        approveDate.append(" ( ");
        approveDate.append(" select * from T_HR_AffairUpgrade where FSyn = 0 and FNewBillID = ");
        approveDate.append(newBillTable);
        approveDate.append(".FID");
        approveDate.append(" ) ");
        DbUtil.execute((Context)ctx, (String)approveDate.toString());
    }

    private String[] getEntryInsertParam(Context ctx, AffairTypeEnum type, int s) {
        String iCol = null;
        String sCol = null;
        String joinTable = null;
        String condition = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        if (AffairTypeEnum.ENROLL.equals((Object)type)) {
            iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FADMINORGID,FPOSITIONID,FJOBLEVELID,FJOBGRADEID,FSOURCEID,FEMPTYPEID,FEMPNUMBER,FEMPNAME_" + l + ",FIDCARDNO,FPASSPORTNO,FGENDER,FBIRTHDAY,FENROLLDATE,FPROBATION,FENROLLAGAIN,FEXISTPERSONID,FUSEOLDNUMBER,FRESUMEID,FSEQ,FID) ";
            sCol = " u.FNewBillID,e.FPERSONID,e.FENROLLDATE,e.FREMARK,p.FADMINORGUNITID,e.FPOSITIONID,e.FJOBLEVELID,e.FJOBGRADEID,e.FENROLLSOURCEID,e.FEMPTYPEID,e.FNUMBER,e.FPERSONNAME_" + l + ",e.FIDCARDNUM,e.FPASSPORTNUM,e.FGENDER,e.FBIRTHDAY,e.FENROLLDATE,e.FTRYOUTMONTH,e.FISENROLLAGAIN,e.FEXISTEDPERSONID,e.FISUSEOLDNUMBER,e.FRESUMEID,e.FSEQ,u.FNewBillEntryID";
            joinTable = " inner join t_org_position p on e.FPOSITIONID = p.fid ";
        } else if (AffairTypeEnum.HIRE.equals((Object)type)) {
            iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FADMINORGID,FPOSITIONID,FJOBLEVELID,FJOBGRADEID,FENROLLDATE,FPROBATION,FGRADE,FSEQ,FID) ";
            sCol = " u.FNewBillID,e.FPERSONID,e.FHIREDATE,e.FREMARK,p.FADMINORGUNITID,e.FPOSITIONID,e.FNewJobLevelId,e.FJOBGRADEID,e.FENROLLDATE,e.FTRYOUTMONTH,to_char(e.FASSESSRESULT,'NUMBER',2),e.FSEQ,u.FNewBillEntryID";
            joinTable = " inner join t_org_position p on e.FPOSITIONID = p.fid ";
        } else if (AffairTypeEnum.RESIGN.equals((Object)type)) {
            iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FADMINORGID,FPOSITIONID,FREASONID,FREASONTYPEID,FOLDEMPTYPEID,FEMPTYPEID,FSEQ,FID) ";
            sCol = " u.FNewBillID,e.FPERSONID,e.FEFFECTDATE,e.FREMARK,e.FPERSONDEP,e.FPOSITIONID,e.FREASONTYPE,e.FREASONTYPETYPEID,'00000000-0000-0000-0000-000000000001A29E85B3','00000000-0000-0000-0000-000000000007A29E85B3',e.FSEQ,u.FNewBillEntryID";
        } else if (AffairTypeEnum.FIRE.equals((Object)type)) {
            iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FADMINORGID,FPOSITIONID,FREASONID,FREASONTYPEID,FOLDEMPTYPEID,FEMPTYPEID,FSEQ,FID) ";
            sCol = " u.FNewBillID,e.FPERSONID,e.FEFFECTDATE,e.FREMARK,e.FPERSONDEP,e.FPOSITIONID,e.FREASONTYPE,e.FREASONTYPETYPEID,'00000000-0000-0000-0000-000000000001A29E85B3','00000000-0000-0000-0000-000000000006A29E85B3',e.FSEQ,u.FNewBillEntryID";
        } else if (AffairTypeEnum.RETIRE.equals((Object)type)) {
            iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FADMINORGID,FPOSITIONID,FREASON,FRETIREDATE,FOLDEMPTYPEID,FEMPTYPEID,FSEQ,FID) ";
            sCol = " u.FNewBillID,e.FPERSONID,e.FRETIREDATE,e.REMARK,e.FNOMINALDEPT,e.FPOSITIONID,left(e.FREASON,200),e.FRETIREDATE,'00000000-0000-0000-0000-000000000001A29E85B3',e.FRETIRE,e.FSEQ,u.FNewBillEntryID";
        } else if (AffairTypeEnum.FLUCTUATION.equals((Object)type)) {
            switch (s) {
                case 0: {
                    iCol = " (FBILLID,FPERSONID,FDESCRIPTION,FOLDADMINORGID,FOLDPOSITIONID,FADMINORGID,FPOSITIONID,FBEGINDATE,FENDDATE,FCHKLENGTH,FCHKENDDATE,FOLDEMPTYPEID,FRZTYPEID,FSEQ,FID)";
                    sCol = " u.FNewBillID,e.FPERSONID,left(e.FREASON,80),po.FADMINORGUNITID,e.FOLDPOSITIONID,pn.FADMINORGUNITID,e.FNEWPOSITIONID,e.FEFFECTDATE,e.FNEWENDDATE,e.FCHECKLEN,e.FCHECKOVERTIME,isnull(e.FOLDEMPTYPEID,'00000000-0000-0000-0000-000000000001A29E85B3'),e.FNEWPERSONRZTYPE,e.FSEQ,u.FNewBillEntryID";
                    joinTable = " inner join t_org_position po on e.FOLDPOSITIONID = po.fid  inner join t_org_position pn on e.FNEWPOSITIONID = pn.fid ";
                    condition = " u.FSinal = " + type.getValue() + 0;
                    break;
                }
                case 1: {
                    iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FOLDADMINORGID,FOLDPOSITIONID,FADMINORGID,FPOSITIONID,FREASON,FCHKLENGTH,FCHKENDDATE,FOLDEMPTYPEID,FSEQ,FID) ";
                    sCol = " u.FNewBillID,e.FPERSONID,e.FEFFECTDATE,e.FREMARK,po.FADMINORGUNITID,e.FOLDPOSITIONID,pn.FADMINORGUNITID,e.FNEWPOSITIONID,left(e.FREASON,80),e.FCHECKLEN,e.FCHECKOVERTIME,isnull(e.FOLDEMPTYPEID,'00000000-0000-0000-0000-000000000001A29E85B3'),e.FSEQ,u.FNewBillEntryID ";
                    joinTable = " inner join t_org_position po on e.FOLDPOSITIONID = po.fid  inner join t_org_position pn on e.FNEWPOSITIONID = pn.fid ";
                    condition = " u.FSinal = " + type.getValue() + 1;
                    break;
                }
                case 2: {
                    iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FOLDADMINORGID,FOLDPOSITIONID,FOLDJOBLEVELID,FOLDJOBGRADEID,FADMINORGID,FPOSITIONID,FJOBLEVELID,FJOBGRADEID,FREASON,FCHKLENGTH,FCHKENDDATE,FHOLDOLDPOSITION,FSEQ,FID) ";
                    sCol = " u.FNewBillID,e.FPERSONID,e.FEFFECTDATE,e.FREMARK,po.FADMINORGUNITID,e.FOLDPOSITIONID,e.FOLDJOBLEVELID,e.FOLDJOBGRADEID,pn.FADMINORGUNITID,e.FNEWPOSITIONID,e.FNEWJOBLEVELID,e.FNEWJOBGRADEID,left(e.FREASON,80),e.FCHECKLEN,e.FCHECKOVERTIME,0,e.FSEQ,u.FNewBillEntryID";
                    joinTable = " inner join t_org_position po on e.FOLDPOSITIONID = po.fid  inner join t_org_position pn on e.FNEWPOSITIONID = pn.fid ";
                    condition = " u.FSinal = " + type.getValue() + 2;
                    break;
                }
                case 3: {
                    iCol = " (FBILLID,FPERSONID,FBIZDATE,FDESCRIPTION,FOLDADMINORGID,FOLDPOSITIONID,FOLDJOBLEVELID,FOLDJOBGRADEID,FADMINORGID,FPOSITIONID,FJOBLEVELID,FJOBGRADEID,FInReason,FCHKLENGTH,FCHKENDDATE,FHoldPosition,FSEQ,FID) ";
                    sCol = " u.FNewBillID,e.FPERSONID,e.FEFFECTDATE,e.FREMARK,po.FADMINORGUNITID,e.FOLDPOSITIONID,e.FOLDJOBLEVELID,e.FOLDJOBGRADEID,pn.FADMINORGUNITID,e.FNEWPOSITIONID,e.FNEWJOBLEVELID,e.FNEWJOBGRADEID,left(e.FREASON,80),e.FCHECKLEN,e.FCHECKOVERTIME,0,e.FSEQ,u.FNewBillEntryID";
                    joinTable = " inner join t_org_position po on e.FOLDPOSITIONID = po.fid  inner join t_org_position pn on e.FNEWPOSITIONID = pn.fid ";
                    condition = " u.FSinal = " + type.getValue() + 3;
                }
            }
        }
        return new String[]{iCol, sCol, joinTable, condition};
    }

    private void insertBillEntry(Context ctx, String newEntryTable, String oldEntryTable, AffairTypeEnum type, int s) throws BOSException, EASBizException {
        String[] params = this.getEntryInsertParam(ctx, type, s);
        String iCol = params[0];
        String sCol = params[1];
        String joinTable = params[2];
        String condition = params[3];
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ");
        insertSql.append(newEntryTable);
        insertSql.append(iCol);
        insertSql.append(" select ");
        insertSql.append(sCol);
        insertSql.append(" from ");
        insertSql.append(oldEntryTable);
        insertSql.append(" e ");
        insertSql.append(" inner join T_HR_AffairUpgrade u on e.fid = u.FOldBillEntryID ");
        if (!StringUtils.isEmpty((String)joinTable)) {
            insertSql.append(joinTable);
        }
        insertSql.append(" where u.FSyn = 0");
        if (!StringUtils.isEmpty((String)condition)) {
            insertSql.append(" and ");
            insertSql.append(condition);
        }
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void insertApproveInfo(Context ctx) throws BOSException, EASBizException {
        StringBuffer insertApprove = new StringBuffer();
        insertApprove.append(" insert into T_BAS_MultiApprove ( FIsPass,FOpinion_l1,FOpinion_l2,FOpinion_l3,FHandlerOption,FMultiHandleOpinion,FHandlerContent,FBillID,FBosType,FNEXTHANDLERPERSONID,FASSIGNMENTID,FSTATUS,FTYPE,FNUMBER,FIsMailNotifyNext,FIsMobelNotifyNext,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID) ");
        insertApprove.append(" select tmptable.*, newbosid('63D30103') from (");
        insertApprove.append(" select distinct m.FIsPass,m.FOpinion_l1,m.FOpinion_l2,m.FOpinion_l3,m.FHandlerOption,m.FMultiHandleOpinion,m.FHandlerContent,a.FNewBillID,m.FBosType,m.FNEXTHANDLERPERSONID,m.FASSIGNMENTID,m.FSTATUS,m.FTYPE,m.FNUMBER,m.FIsMailNotifyNext,m.FIsMobelNotifyNext,m.FCreatorID,m.FCreateTime,m.FLastUpdateUserID,m.FLastUpdateTime,m.FControlUnitID");
        insertApprove.append(" from T_BAS_MultiApprove m ");
        insertApprove.append(" inner join t_hr_affairupgrade a on a.FOldBillID = m.FBillID ");
        insertApprove.append(" where a.FSyn = 0) tmptable ");
        DbUtil.execute((Context)ctx, (String)insertApprove.toString());
        StringBuffer insertApproveHis = new StringBuffer();
        insertApproveHis.append(" insert into T_BAS_MultiApproveHst ( FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FIsPass,FOpinion_l1,FOpinion_l2,FOpinion_l3,FHandlerOption,FMultiHandleOpinion,FHandlerContent,FBillID,FBosType,FNEXTHANDLERPERSONID,FASSIGNMENTID,FSTATUS,FTYPE,FNUMBER,FIsMailNotifyNext,FIsMobelNotifyNext) ");
        insertApproveHis.append(" select newbosid('F0F145B6'), tmptable.* from (");
        insertApproveHis.append(" select distinct m.FCreatorID,m.FCreateTime,m.FLastUpdateUserID,m.FLastUpdateTime,m.FControlUnitID,m.FIsPass,m.FOpinion_l1,m.FOpinion_l2,m.FOpinion_l3,m.FHandlerOption,m.FMultiHandleOpinion,m.FHandlerContent,a.FNewBillID,m.FBosType,m.FNEXTHANDLERPERSONID,m.FASSIGNMENTID,m.FSTATUS,m.FTYPE,m.FNUMBER,m.FIsMailNotifyNext,m.FIsMobelNotifyNext ");
        insertApproveHis.append(" from T_BAS_MultiApproveHst m ");
        insertApproveHis.append(" inner join t_hr_affairupgrade a on a.FOldBillID = m.FBillID ");
        insertApproveHis.append(" where a.FSyn = 0) tmptable ");
        DbUtil.execute((Context)ctx, (String)insertApproveHis.toString());
    }

    private void updateHistory(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateDetail = new StringBuffer();
        updateDetail.append("update T_HR_AffairBizDetail set(FBillID,FEntryID,FOldBill)");
        updateDetail.append(" = ");
        updateDetail.append("(select top 1 FNewBillID,FNewBillEntryID,0 from T_HR_AffairUpgrade t where  T_HR_AffairBizDetail.FEntryID = t.FOldBillEntryID)");
        updateDetail.append(" where exists(select * from T_HR_AffairUpgrade where FOldBillEntryID = T_HR_AffairBizDetail.FEntryID and FSyn = 0)");
        DbUtil.execute((Context)ctx, (String)updateDetail.toString());
        StringBuffer updateHistory = new StringBuffer();
        updateHistory.append("update T_HR_AffairBizHistory set(FBillID,FEntryID)");
        updateHistory.append(" = ");
        updateHistory.append("(select top 1 FNewBillID,FNewBillEntryID from T_HR_AffairUpgrade t where  T_HR_AffairBizHistory.FEntryID = t.FOldBillEntryID)");
        updateHistory.append(" where exists(select * from T_HR_AffairUpgrade where FOldBillEntryID = T_HR_AffairBizHistory.FEntryID and FSyn = 0)");
        DbUtil.execute((Context)ctx, (String)updateHistory.toString());
        String updateUpgrade = "update T_HR_AffairUpgrade set FSyn = 1 where FSyn = 0";
        DbUtil.execute((Context)ctx, (String)updateUpgrade.toString());
    }

    private void upgradeBillRelated(Context ctx) throws BOSException, EASBizException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update t_hr_emphirebizbillentry set femployeenumber = ");
        updateSql.append(" ( ");
        updateSql.append(" select top 1 fnumber from t_bd_person where fid = t_hr_emphirebizbillentry.fpersonid");
        updateSql.append(" ) ");
        updateSql.append(" where exists ");
        updateSql.append(" ( ");
        updateSql.append("select * from t_hr_affairupgrade where fnewbillentryid = t_hr_emphirebizbillentry.fid");
        updateSql.append(" )");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append(" update t_hr_resignbizbillentry set (foldadminorgid,foldpositionid) = ");
        updateSql.append(" ( ");
        updateSql.append(" select top 1 a.FOldDeptID,a.FOldPositionID ");
        updateSql.append(" from t_hr_affairHistory a,t_hr_affairupgrade u ");
        updateSql.append(" where ");
        updateSql.append(" a.FAffairBillEntryId = u.foldbillentryid ");
        updateSql.append(" and u.fnewbillentryid = t_hr_resignbizbillentry.FID ");
        updateSql.append(" )");
        updateSql.append(" where exists ");
        updateSql.append(" (");
        updateSql.append(" select * from t_hr_affairupgrade where fnewbillentryid =  t_hr_resignbizbillentry.fid ");
        updateSql.append(" )");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append(" update t_hr_retirebizbillentry set (foldadminorgid,foldpositionid) = ");
        updateSql.append(" ( ");
        updateSql.append(" select top 1 a.FOldDeptID,a.FOldPositionID ");
        updateSql.append(" from t_hr_affairHistory a,t_hr_affairupgrade u ");
        updateSql.append(" where ");
        updateSql.append(" a.FAffairBillEntryId = u.foldbillentryid ");
        updateSql.append(" and u.fnewbillentryid = t_hr_retirebizbillentry.FID ");
        updateSql.append(" ) ");
        updateSql.append(" where exists ");
        updateSql.append(" ( ");
        updateSql.append(" select * from t_hr_affairupgrade where fnewbillentryid =  t_hr_retirebizbillentry.fid ");
        updateSql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append(" update t_hr_fluctuationbizbillentry set foldjobid = ");
        updateSql.append(" ( ");
        updateSql.append(" select top 1 fjobid from t_org_position where fid = t_hr_fluctuationbizbillentry.foldpositionid ");
        updateSql.append(" ) ");
        updateSql.append(" where exists ");
        updateSql.append(" ( ");
        updateSql.append(" select * from t_hr_affairupgrade where fnewbillentryid = t_hr_fluctuationbizbillentry.fid ");
        updateSql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append(" update t_hr_fluctuationbizbillentry set fjobid = ");
        updateSql.append(" ( ");
        updateSql.append(" select top 1 fjobid from t_org_position where fid = t_hr_fluctuationbizbillentry.fpositionid ");
        updateSql.append(" ) ");
        updateSql.append(" where exists ");
        updateSql.append(" ( ");
        updateSql.append(" select * from t_hr_affairupgrade where fnewbillentryid = t_hr_fluctuationbizbillentry.fid ");
        updateSql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        updateSql = new StringBuffer();
        updateSql.append(" update T_HR_FluctuationBizBillEntry set FHOLDOLDPOSITION = 1 ");
        updateSql.append(" where exists ");
        updateSql.append(" (select * ");
        updateSql.append(" from T_HR_FluctuationBillEntry e ");
        updateSql.append(" inner join T_HR_BDFluctuationType t on e.FTypeID = t.fid ");
        updateSql.append(" inner join t_hr_affairupgrade u on u.FOldBillEntryID = e.fid ");
        updateSql.append(" where u.fnewBillEntryID = T_HR_FluctuationBizBillEntry.FID ");
        updateSql.append(" and (t.FType= '1' and e.FprimaryFlu= '1') ");
        updateSql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }
}

