/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.AffairUnAuitAlreadyEffectFacadeFactory;
import com.kingdee.eas.hr.affair.FlucOutBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FlucOutBizBillEntryFactory;
import com.kingdee.eas.hr.affair.FlucOutBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FlucOutBizBillFactory;
import com.kingdee.eas.hr.affair.FlucOutBizBillInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryFactory;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.app.AbstractFlucOutBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.FlucOutBillBizBean;
import com.kingdee.eas.hr.affair.app.HrAffairFillEmptyBizDefineUtil;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.BillEntryJobProcessCollection;
import com.kingdee.eas.hr.base.BillEntryJobProcessFactory;
import com.kingdee.eas.hr.base.BillEntryJobProcessInfo;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.hr.emp.CompleteStateEnum;
import com.kingdee.eas.hr.emp.FluctuationInOutCollection;
import com.kingdee.eas.hr.emp.FluctuationInOutFactory;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.IFluctuationInOut;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.app.util.FluctuationInOutUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class FlucOutBizBillControllerBean
extends AbstractFlucOutBizBillControllerBean {
    private IHRBillBizBean bizBean = null;

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.FlucOutBizBillEffectFunction";
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FlucOutBizBillInfo billInfo = (FlucOutBizBillInfo)model;
        FlucOutBizBillEntryCollection entrys = billInfo.getEntrys();
        HrAffairFillEmptyBizDefineUtil.fillFlucOutBizBillEntry(ctx, entrys);
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FlucOutBizBillInfo billInfo = (FlucOutBizBillInfo)model;
        FlucOutBizBillEntryCollection entrys = billInfo.getEntrys();
        HrAffairFillEmptyBizDefineUtil.fillFlucOutBizBillEntry(ctx, entrys);
        Date curDate = new Date();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            if (entrys.get(i).getBizDate() != null) continue;
            entrys.get(i).setBizDate(curDate);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return FlucOutBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new FlucOutBillBizBean();
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        AffairUtil.updateAffairEntryJobGradeInfo(ctx, FlucOutBizBillEntryFactory.getLocalInstance(ctx), entry);
    }

    @Override
    protected void _doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        FluctuationInOutInfo flucInOutInfo = this.flucOutEntryConvertToFlucInOutInfo(entry);
        EmpPosOrgRelationInfo eporInfo = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo((Context)ctx, (String)flucInOutInfo.getPerson().getId().toString());
        flucInOutInfo.setOldLaborRelState(eporInfo.getLaborRelation().getLaborRelationState());
        flucInOutInfo.setOldAdmin(eporInfo.getAdminOrg());
        flucInOutInfo.setOldPosition(eporInfo.getPosition());
        flucInOutInfo.setIsLoanBill(false);
        flucInOutInfo.setCompleteState(CompleteStateEnum.NO_COMPLETE);
        IFluctuationInOut iFluctuationInOut = FluctuationInOutFactory.getLocalInstance((Context)ctx);
        iFluctuationInOut.save((CoreBaseInfo)flucInOutInfo);
    }

    private FluctuationInOutInfo flucOutEntryConvertToFlucInOutInfo(HRAffairBizBillEntryInfo entry) {
        FlucOutBizBillEntryInfo eInfo = (FlucOutBizBillEntryInfo)entry;
        FluctuationInOutInfo flucInOutInfo = new FluctuationInOutInfo();
        flucInOutInfo.setPerson(eInfo.getPerson());
        flucInOutInfo.setOldPosition(eInfo.getOldPosition());
        flucInOutInfo.setOldAdmin(eInfo.getOldAdminOrg());
        flucInOutInfo.setBizDate(eInfo.getBizDate());
        flucInOutInfo.setActionDef(eInfo.getHrBizDefine());
        flucInOutInfo.setActionType(eInfo.getAffairActionReason());
        flucInOutInfo.setActionReason(eInfo.getVariationReason());
        flucInOutInfo.setIsEndEmpContract(eInfo.isIsEndEmpContract());
        flucInOutInfo.setIsEndOtherContract(eInfo.isIsEndEmpOtherContract());
        flucInOutInfo.setNewAdmin(eInfo.getCompany());
        flucInOutInfo.setCompany(eInfo.getCompany());
        flucInOutInfo.setFlucOutBill(eInfo.getBill());
        return flucInOutInfo;
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.checkBeforeSubmit(ctx, model);
        FlucOutBizBillInfo info = (FlucOutBizBillInfo)model;
        FlucOutBizBillEntryCollection eColl = info.getEntrys();
        FlucOutBizBillEntryInfo eInfo = null;
        for (int i = 0; i < eColl.size(); ++i) {
            eInfo = eColl.get(i);
            FluctuationInOutInfo flucInOutInfo = this.flucOutEntryConvertToFlucInOutInfo(eInfo);
            FlucOutBizBillControllerBean.checkOutPerson(ctx, flucInOutInfo);
            this.checkbizDate(ctx, eInfo);
        }
    }

    private void checkbizDate(Context ctx, FlucOutBizBillEntryInfo eInfo) throws BOSException, HRAffairException {
        String personId = eInfo.getPerson().getId().toString();
        EmpPosOrgRelationCollection empPosOrgRelationCol = null;
        EmpPosOrgRelationQueryHelper empPosOrgRelationHelper = new EmpPosOrgRelationQueryHelper();
        empPosOrgRelationCol = empPosOrgRelationHelper.getAppointDateAfterPrimaryPosition(ctx, personId, eInfo.getBizDate());
        if (empPosOrgRelationCol != null && empPosOrgRelationCol.size() > 0) {
            EmpPosOrgRelationInfo empPosOrgRelationInfo = empPosOrgRelationCol.get(0);
            if (eInfo.getBizDate().before(empPosOrgRelationInfo.getEFFDT())) {
                throw new HRAffairException(HRAffairException.PERSON_HAS_OPT_AT_TIME, new Object[]{HRUtilExtend.getDateStringWithoutMininute((Date)empPosOrgRelationInfo.getEFFDT())});
            }
        }
    }

    private static void checkOutPerson(Context ctx, FluctuationInOutInfo srcInfo) throws BOSException, HRAffairException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)srcInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)1, CompareType.NOTEQUALS));
        view.setSelector(sic);
        view.setFilter(filter);
        FluctuationInOutCollection col = FluctuationInOutFactory.getLocalInstance((Context)ctx).getFluctuationInOutCollection(view);
        if (col.size() > 0) {
            throw new HRAffairException(HRAffairException.PERSON_IS_FLUC_OUT);
        }
    }

    private static void checkLoanState(Context ctx, String personId, FluctuationInOutInfo fluctuationInOutInfo) throws BOSException, HRAffairException {
        if (fluctuationInOutInfo.isIsLoanBill()) {
            PersonLoanInfo personLoanInfo = null;
            boolean isLoanBackEffect = true;
            String oql = " where person ='" + personId + "'";
            PersonLoanCollection personLoanColl = PersonLoanFactory.getLocalInstance((Context)ctx).getPersonLoanCollection(oql);
            if (!personLoanColl.isEmpty()) {
                for (int i = 0; i < personLoanColl.size(); ++i) {
                    personLoanInfo = personLoanColl.get(i);
                    if (personLoanInfo.getBackEffectDate() != null) continue;
                    isLoanBackEffect = false;
                    break;
                }
                if (!isLoanBackEffect) {
                    throw new HRAffairException(HRAffairException.PERSON_IN_LOAN_OUT);
                }
            }
        }
    }

    public static boolean checkExistFluctuationOut(Context ctx, String personId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            return false;
        }
        String currDate = FlucOutBizBillControllerBean.getCurrentDate();
        StringBuffer oql = new StringBuffer();
        oql.append("where person.id = '");
        oql.append(personId).append("'");
        oql.append(" and (");
        oql.append(" bill.billState = ");
        oql.append(1);
        oql.append(" or bill.billState = ");
        oql.append(2);
        oql.append(" or (bill.billState = ");
        oql.append(3);
        oql.append(" and bizDate >= ");
        oql.append(currDate);
        oql.append(" ))");
        return FluctuationBizBillEntryFactory.getLocalInstance(ctx).exists(oql.toString());
    }

    private static String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    @Override
    protected void _doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    @Override
    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
        FlucOutBizBillEntryInfo einfo = (FlucOutBizBillEntryInfo)entry;
    }

    protected String getPermItemNameDelete() {
        return "flucOut_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "flucOut_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "flucOut_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FlucOutBizBillInfo BillInfo = FlucOutBizBillFactory.getLocalInstance(ctx).getFlucOutBizBillInfo(pk);
        FlucOutBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = new BillExtendBeanProcess(this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                decorators = plugIn != null ? new IReflectMethod[]{plugIn, billExtend} : new IReflectMethod[]{billExtend};
                if (decorators != null) {
                    this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                }
            }
        }
    }

    @Override
    protected void dropJobProcess(Context ctx, String billEntryIdStr) throws EASBizException, BOSException {
        block8: {
            BillEntryJobProcessCollection bejpCol = BillEntryJobProcessFactory.getLocalInstance((Context)ctx).getBillEntryJobProcessCollection("where billEntryId in (" + billEntryIdStr + ")");
            StringBuffer jobProcessIdStr = new StringBuffer();
            int size = bejpCol.size();
            for (int i = 0; i < size; ++i) {
                BillEntryJobProcessInfo bejpInfo = bejpCol.get(i);
                jobProcessIdStr.append("'");
                jobProcessIdStr.append(bejpInfo.getJobProcessId());
                if (i == size - 1) {
                    jobProcessIdStr.append("'");
                    continue;
                }
                jobProcessIdStr.append("',");
            }
            if (jobProcessIdStr == null || jobProcessIdStr.length() == 0) {
                return;
            }
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)ctx);
            String sql = "SELECT FID FROM T_JOB_Trigger WHERE FJobDefID in (" + jobProcessIdStr + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    rs.beforeFirst();
                    while (rs.next()) {
                        String triggerId = rs.getString(1);
                        jobService.disableTrigger(triggerId);
                    }
                    break block8;
                }
                throw new HRAffairException(HRAffairException.TRY_LATER_TIME);
            }
            catch (HRAffairException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void _passUnaudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        String billID = billId.toString();
        String entryField = this.getEntryField();
        HRBillBaseInfo model = this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        IObjectCollection entries = (IObjectCollection)model.get(entryField);
        if (this.checkIsUse(ctx, entries)) {
            throw new HRAffairException(HRAffairException.IS_ALREADY_USE);
        }
        this.initBizBean(ctx);
        if (entries != null) {
            this.updateBillState(ctx, BOSUuid.read((String)billID), HRBillStateEnum.SAVED);
            if (this.bizBean != null) {
                this.bizBean._setBillState(ctx, BOSUuid.read((String)billID), HRBillStateEnum.SAVED);
            }
            this.deletePersonFromEmployeePool(ctx, entries);
            this.dropJobProcess(ctx, this.getEntryIdStr(ctx, (IObjectPK)new ObjectUuidPK(billID)));
            boolean isRollBackShowMultiApproveInfo = false;
            String paramNum = "IS_ROLLBACK_AFTER_SHOW_MULTIAPPROVEINFO";
            HROrgUnitInfo hrOrgUnitIfo = model.getHrOrgUnit();
            String hrOrgUnitId = hrOrgUnitIfo.getId() == null ? null : hrOrgUnitIfo.getId().toString();
            isRollBackShowMultiApproveInfo = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgUnitId);
            if (!isRollBackShowMultiApproveInfo) {
                MultiApproveFactory.getLocalInstance((Context)ctx).delete("WHERE billId = '" + billID + "'");
            }
            String billField = this.getBillField();
            FlucOutBizBillEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (FlucOutBizBillEntryInfo)entries.getObject(i);
                entry.put(billField, model);
                AffairUnAuitAlreadyEffectFacadeFactory.getLocalInstance(ctx).empOutUnAudit(entry.getId().toString(), entry.getPerson().getId().toString());
            }
            this.clearProcInstBizInfo(ctx, model);
        }
    }

    private boolean checkIsUse(Context ctx, IObjectCollection entries) throws BOSException {
        boolean result = false;
        String entryIdStr = this.getEntryIdStr(entries);
        String sql = "SELECT FID FROM T_HR_FlucInBizBillEntry WHERE FSourceEntryId IN (" + entryIdStr + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                result = true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getEntryIdStr(IObjectCollection entries) {
        StringBuffer entryIdStr = new StringBuffer();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FlucOutBizBillEntryInfo entryInfo = (FlucOutBizBillEntryInfo)entries.getObject(i);
            entryIdStr.append("'");
            entryIdStr.append(entryInfo.getId().toString());
            if (i == size - 1) {
                entryIdStr.append("'");
                continue;
            }
            entryIdStr.append("',");
        }
        return entryIdStr.toString();
    }

    private String getPersonIdStr(IObjectCollection entries) {
        StringBuffer personIdStr = new StringBuffer();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            FlucOutBizBillEntryInfo entryInfo = (FlucOutBizBillEntryInfo)entries.getObject(i);
            personIdStr.append("'");
            personIdStr.append(entryInfo.getPerson().getId().toString());
            if (i == size - 1) {
                personIdStr.append("'");
                continue;
            }
            personIdStr.append("',");
        }
        return personIdStr.toString();
    }

    private void deletePersonFromEmployeePool(Context ctx, IObjectCollection entries) throws BOSException {
        String personIdStr = this.getPersonIdStr(entries);
        String sql = "DELETE FROM T_HR_EmployeePool WHERE FPersonID IN(" + personIdStr + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        FlucOutBizBillEntryInfo entryInfo = (FlucOutBizBillEntryInfo)entry;
        FluctuationInOutInfo flucInOutInfo = FluctuationInOutUtil.getFluctuationInOutInfoByOutBill((Context)ctx, (String)entryInfo.getBill().toString());
        if (flucInOutInfo != null) {
            FluctuationInOutFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(flucInOutInfo.getId().toString()));
        }
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        FluctuationInOutInfo flucInOutInfo;
        super._untiCheckBizBill(ctx, billId);
        if (!StringUtils.isEmpty((String)billId) && (flucInOutInfo = FluctuationInOutUtil.getFluctuationInOutInfoByOutBill((Context)ctx, (String)billId)) != null) {
            if (flucInOutInfo.getCompleteState() != CompleteStateEnum.NO_COMPLETE) {
                throw new AffairBizException(AffairBizException.FLUCOUT_CHECK_PERSON_IN);
            }
            FluctuationInOutFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(flucInOutInfo.getId().toString()));
        }
    }

    @Override
    protected boolean isNeedRecorderUserPermission() {
        return true;
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        JobGradeInfo jobGradeInfo = entryInfo.getJobGrade();
        JobLevelInfo jobLevelInfo = entryInfo.getJobLevel();
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        entryInfo.setJobGrade(jobGradeInfo);
        entryInfo.setJobLevel(jobLevelInfo);
        return entryInfo;
    }

    @Override
    protected void checkEntryIsEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        FlucOutBizBillEntryInfo entryInfo = (FlucOutBizBillEntryInfo)entry;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("flucOutBill", (Object)entryInfo.getBill().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)entryInfo.getPerson().getId().toString()));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        entityViewInfo.setSelector(sic);
        FluctuationInOutCollection colls = FluctuationInOutFactory.getLocalInstance((Context)ctx).getFluctuationInOutCollection(entityViewInfo);
        if (colls != null && colls.size() > 0) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.BILLENTRY_EFFECT_EXCEPTION);
        }
    }

    @Override
    protected void createBackGroundJob(Context ctx, IObjectValue entry, String jobKey) throws EASBizException, BOSException {
        super.createBackGroundJob(ctx, entry, jobKey);
        FlucOutBizBillEntryInfo info = (FlucOutBizBillEntryInfo)entry;
        String personId = info.getPerson().getId().toString();
        String billId = info.getBill().getId().toString();
        StringBuffer sql = new StringBuffer("update T_HR_FluctuationInOut set FflucOutBill ='").append(billId + "' where FCompleteState = 0 and FPersonID = '").append(personId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected boolean checkIsCreateJob() {
        return false;
    }
}

