/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizCollection;
import com.kingdee.eas.hr.affair.HRAffairBizFactory;
import com.kingdee.eas.hr.affair.HRAffairBizInfo;
import com.kingdee.eas.hr.affair.IAffairBizCheckFacade;
import com.kingdee.eas.hr.affair.IHRAffairBizBill;
import com.kingdee.eas.hr.affair.ReinviteBizBillEntryInfo;
import com.kingdee.eas.hr.affair.ReinviteBizBillInfo;
import com.kingdee.eas.hr.affair.RetireBizBillEntryFactory;
import com.kingdee.eas.hr.affair.RetireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.EmpAffairBizBillException;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.CheckEmployeeTypeOperatorUtil;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class ReinviteBillBizBean
extends HRAffairBillBizBean {
    public static final String PLURALITYADD_BOSTYPE = "B3F8AB50";
    public static final String PLURALITYDEL_BOSTYPE = "6422D4A6";

    @Override
    protected boolean isNeedCheckJobLevelGradeRange() {
        return true;
    }

    @Override
    protected void checkPersonAfterDateModify(Context ctx, HRBillBaseEntryInfo entry) throws EASBizException, BOSException {
        StringBuffer exceptionMsg = new StringBuffer();
        try {
            PersonInfo person;
            String bizdateField = this.getEntryEffectDateField();
            String personField = this.getPersonField();
            String personId = "";
            if (!StringUtils.isEmpty((String)personField) && (person = (PersonInfo)entry.get(personField)) != null && person.getId() != null) {
                personId = person.getId().toString();
            }
            Date bizDate = (Date)entry.get(bizdateField);
            String targetEmpTypeId = null;
            String targetPositionId = null;
            String targetOrgAdminId = null;
            String actionId = null;
            if (entry.get("empType") != null) {
                targetEmpTypeId = ((CoreBaseInfo)entry.get("empType")).getId().toString();
                ReinviteBizBillEntryInfo reinviteEntryInfo = (ReinviteBizBillEntryInfo)entry;
                if (reinviteEntryInfo.getSource() != null && reinviteEntryInfo.getSource().getId() != null) {
                    RetireBizBillEntryInfo retireEntryInfo = RetireBizBillEntryFactory.getLocalInstance(ctx).getRetireBizBillEntryInfo("select bill.id,bill.billState,bizdate,leftCompanyDate where id = '" + reinviteEntryInfo.getSource().getId().toString() + "'");
                    HRAffairBizInfo bizInfo = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizInfo("select entryBizDate where entryID ='" + retireEntryInfo.getId() + "'");
                    if (retireEntryInfo.getBill().getBillState().getValue() == 3 && bizInfo.getEntryBizDate().after(new Date())) {
                        targetEmpTypeId = "";
                    }
                }
            }
            if (entry.get("position") != null) {
                targetPositionId = ((CoreBaseInfo)entry.get("position")).getId().toString();
            }
            if (entry.get("adminOrg") != null) {
                targetOrgAdminId = ((CoreBaseInfo)entry.get("adminOrg")).getId().toString();
            }
            if (entry.get("hrBizDefine") != null) {
                actionId = ((CoreBaseInfo)entry.get("hrBizDefine")).getId().toString();
            }
            CheckEmployeeTypeOperatorUtil.checkPersonAfterDateModify((Context)ctx, (String)personId, (Date)bizDate, (String)actionId, (String)targetEmpTypeId, (String)targetPositionId, (String)targetOrgAdminId);
        }
        catch (EmpAffairBizBillException e) {
            e.printStackTrace();
            if (!StringUtils.isEmpty((String)exceptionMsg.toString())) {
                exceptionMsg.append("</br>");
            }
            exceptionMsg.append(e.getMessage());
        }
        if (!StringUtils.isEmpty((String)exceptionMsg.toString())) {
            throw new EmpAffairBizBillException(EmpAffairBizBillException.ANYTHING, new Object[]{exceptionMsg});
        }
    }

    @Override
    protected BatchProcessedResult checkPersonInAffair(Context ctx, IAffairBizCheckFacade checkFacade, HRBillBaseInfo info, StringBuffer personIds, String billID, Map validMap) throws EASBizException, BOSException {
        ReinviteBizBillInfo billInfo = (ReinviteBizBillInfo)info;
        ReinviteBizBillEntryInfo entryInfo = billInfo.getEntrys().get(0);
        if (entryInfo.getSource() != null && entryInfo.getSource().getId() != null) {
            RetireBizBillEntryInfo retireEntryInfo = RetireBizBillEntryFactory.getLocalInstance(ctx).getRetireBizBillEntryInfo("select bill.id,bill.billState,bizdate,leftCompanyDate where id = '" + entryInfo.getSource().getId().toString() + "'");
            HRAffairBizInfo bizInfo = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizInfo("select entryBizDate where entryID ='" + retireEntryInfo.getId() + "'");
            if (retireEntryInfo.getBill().getBillState().getValue() == 3 && bizInfo.getEntryBizDate().after(new Date())) {
                validMap = this.getValidMapByBillInfo(ctx, info, validMap);
                boolean isCheckPostRank = (Boolean)validMap.get("isCheckPostRankFlag");
                String excludeBillId = billID + "," + retireEntryInfo.getBill().getId().toString();
                return this.isPersonInAffairProcessByRetireToReinvite(ctx, personIds.toString(), excludeBillId, isCheckPostRank);
            }
        }
        return super.checkPersonInAffair(ctx, checkFacade, info, personIds, billID, validMap);
    }

    protected BatchProcessedResult isPersonInAffairProcessByRetireToReinvite(Context ctx, String personIds, String billId, boolean isCheckPostRank) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personIds)) {
            return null;
        }
        String currDate = this.getCurrentDate();
        StringBuffer oql = new StringBuffer("select person.id,person.name,person.number,billBOSType,billID ");
        oql.append("where person.id in ");
        oql.append(this.getIdsSql(personIds));
        if (!StringUtils.isEmpty((String)billId)) {
            oql.append(" and billID not in ");
            oql.append(this.getIdsSql(billId));
        }
        this.addNotCheckBosType(ctx, oql);
        oql.append(" and (");
        oql.append(" billState = ");
        oql.append(0);
        oql.append(" or billState = ");
        oql.append(1);
        oql.append(" or billState = ");
        oql.append(2);
        oql.append(" or (billState = ");
        oql.append(3);
        oql.append(" and entryBizDate > ");
        oql.append(currDate);
        oql.append(" ))");
        HRAffairBizCollection col = HRAffairBizFactory.getLocalInstance(ctx).getHRAffairBizCollection(oql.toString());
        if (col != null && col.size() > 0) {
            BatchProcessedResult result = new BatchProcessedResult();
            String personNumber = null;
            String personName = null;
            String billName = null;
            HRAffairBizInfo bizInfo = null;
            String bosType = null;
            String exsitBillId = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                bizInfo = col.get(i);
                personNumber = bizInfo.getPerson().getNumber();
                personName = bizInfo.getPerson().getName();
                bosType = bizInfo.getBillBOSType();
                billName = loader.getEntity(BOSObjectType.create((String)bosType)).getAlias();
                exsitBillId = bizInfo.getBillID().toString();
                String entityName = loader.getEntity(BOSObjectType.create((String)bosType)).getFullName();
                IHRAffairBizBill IHRAffairBizBill2 = (IHRAffairBizBill)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
                HRAffairBizBillInfo billInfo = IHRAffairBizBill2.getHRAffairBizBillInfo((IObjectPK)new ObjectUuidPK(exsitBillId));
                if (!isCheckPostRank && "C4D946DE".equals(bosType)) continue;
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"not_allow_option", (Context)ctx);
                Object[] params = new Object[]{personNumber, personName, billName, billName, billInfo.getNumber()};
                message = MessageFormat.format(message, params);
                result.addinvalidInfo(message);
            }
            return result;
        }
        return null;
    }

    protected String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    protected void addNotCheckBosType(Context ctx, StringBuffer oql) throws EASBizException, BOSException {
        boolean flag = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_PLURALITY_CHECKOTHERBILL", null);
        if (!flag) {
            oql.append(" and billBOSType <> 'B3F8AB50' ");
        }
        oql.append(" and billBOSType <> '6422D4A6' ");
    }
}

