/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.CmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.CmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.EmpCmpSchmFacadeException;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.ICmpSchemePerson;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.app.AbstractBankAgentIssueFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BankAgentIssueFacadeControllerBean
extends AbstractBankAgentIssueFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.BankAgentIssueFacadeControllerBean");
    private List personListInScheme = new ArrayList();
    private List allPersonListScheme = new ArrayList();

    @Override
    protected IRowSet _getEmpData(Context ctx, IObjectPK bankCmpSchemePK, List personIDs, List lstCmpItem) throws EASBizException, BOSException {
        return null;
    }

    protected IRowSet getEmpDataByPersonSql(Context ctx, IObjectPK bankCmpSchemePK, List lstCmpItem, EntityViewInfo entityViewInfoPerson, HashMap paramMap) throws EASBizException, BOSException {
        String cmpItemFilter;
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        String horTableName = null;
        List schemeIDs = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (bankCmpSchemePK != null) {
            CmpSchemeInfo cmpSchemeInfo = new CmpSchemeInfo();
            cmpSchemeInfo = iCmpScheme.getCmpSchemeInfo(bankCmpSchemePK);
            horTableName = cmpSchemeInfo.getHorTableName();
        } else {
            schemeIDs = (List)paramMap.get("Bank_CmpSchemeIDColl");
            try {
                horTableName = this.createTempTable(ctx, schemeIDs, lstCmpItem, pool);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
        String sql = null;
        try {
            sql = this.getItemSelectSQL(ctx, bankCmpSchemePK, lstCmpItem, horTableName, entityViewInfoPerson, paramMap);
        }
        catch (EASBizException e1) {
            throw e1;
        }
        catch (BOSException e1) {
            throw e1;
        }
        String whereSql = this.getWhereCondition(lstCmpItem);
        if (!whereSql.trim().equals("")) {
            StringBuffer newSql = new StringBuffer();
            String select = sql.substring(0, sql.indexOf(" FROM "));
            newSql.append(select).append(",\"PERSONCMP\".faccountoneflag  FPER025Flag ").append(",\"PERSONCMP\".faccounttwoflag  FPER026Flag ").append(",\"PERSONCMP\".faccountthreeflag  FPER027Flag ").append(",\"PERSONCMP\".faccountfourflag  FPER057Flag ").append(",\"PERSONCMP\".fbenefitacountflag  FPER044Flag ");
            sql = sql.replaceFirst(select, newSql.toString());
        }
        StringBuffer sb = new StringBuffer(sql);
        ICmpSchemeItem iCmpSchemItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        String oql = "SELECT id,isDelete,CmpItem.number,cmpScheme.id WHERE CmpItem.number='FOTH001' AND isDelete=0 ";
        oql = bankCmpSchemePK != null ? oql + " and cmpScheme.id='" + bankCmpSchemePK.toString() + "'" : oql + " and cmpScheme.id in " + CompUtils.getStrFromList(schemeIDs);
        CmpSchemeItemCollection cmpSchItemCol = iCmpSchemItem.getCmpSchemeItemCollection(oql);
        if (cmpSchItemCol.size() > 0) {
            sb.append(" AND (" + horTableName + "." + "FOTH001" + "<>1 ");
            sb.append(" OR " + horTableName + "." + "FOTH001" + " is null) ");
        }
        if (!StringUtils.isEmpty((String)(cmpItemFilter = (String)paramMap.get("cmpItemFilter")))) {
            sb.append(" and " + cmpItemFilter + " ");
        }
        if (sql.indexOf("\"PERSON\".FIndex") != -1) {
            sb.append(" order by INDEXOF ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)PersonInfoUtils.getOptimizeSql(sb.toString()));
        if (bankCmpSchemePK == null) {
            pool.releaseTable(horTableName);
        }
        return rs;
    }

    private String getWhereCondition(List lstCmpItem) {
        if (lstCmpItem == null || lstCmpItem.size() == 0) {
            return null;
        }
        String itemNumber = null;
        StringBuffer whereCondition = new StringBuffer();
        for (int i = 0; i < lstCmpItem.size(); ++i) {
            itemNumber = ((CmpItemInfo)lstCmpItem.get(i)).getNumber();
            String flagStr = null;
            if (itemNumber.equalsIgnoreCase("FPER025")) {
                flagStr = "\"PERSONCMP\".faccountoneflag = 1";
            } else if (itemNumber.equalsIgnoreCase("FPER026")) {
                flagStr = "\"PERSONCMP\".faccounttwoflag = 1";
            } else if (itemNumber.equalsIgnoreCase("FPER027")) {
                flagStr = "\"PERSONCMP\".faccountthreeflag = 1";
            } else if (itemNumber.equalsIgnoreCase("FPER057")) {
                flagStr = "\"PERSONCMP\".faccountfourflag = 1";
            } else if (itemNumber.equalsIgnoreCase("FPER044")) {
                flagStr = "\"PERSONCMP\".fbenefitacountflag = 1";
            }
            if (whereCondition.length() > 0 && flagStr != null) {
                whereCondition.append(" or ").append(flagStr);
                continue;
            }
            if (flagStr == null) continue;
            whereCondition.append(flagStr);
        }
        return whereCondition.toString();
    }

    protected String getEmpOrderSql(HashMap paramMap) {
        return " order by \"PERSON\".FNumber";
    }

    @Override
    protected IRowSet _getEmployeeData(Context ctx, IObjectPK bankCmpSchemePK, List lstCmpItem, EntityViewInfo entityViewInfoPerson, HashMap paramMap) throws BOSException, EASBizException {
        List newItemList = HRCmpItemUtils.deleteNoMappingPersonItem(ctx, lstCmpItem);
        IRowSet rs = this.getEmpDataByPersonSql(ctx, bankCmpSchemePK, newItemList, entityViewInfoPerson, paramMap);
        return rs;
    }

    protected String getItemSelectSQL(Context ctx, IObjectPK schemePK, List lstCmpItem, String horTableName, EntityViewInfo entityViewInfoPerson, HashMap paramMap) throws BOSException, EASBizException {
        SqlSelect select = null;
        FilterInfo filterInfo = new FilterInfo();
        if (entityViewInfoPerson == null) {
            entityViewInfoPerson = new EntityViewInfo();
        }
        if (entityViewInfoPerson.getFilter() != null && entityViewInfoPerson.getFilter().getMaskString() != null) {
            entityViewInfoPerson.getFilter().mergeFilter(filterInfo, "and");
        } else {
            entityViewInfoPerson.setFilter(filterInfo);
        }
        if (paramMap == null) {
            paramMap = new HashMap<String, String>();
        }
        paramMap.put("horTableName", horTableName);
        select = this.getBankItemSQL(ctx, entityViewInfoPerson, paramMap);
        ArrayList orderedSelectors = this.buildSelectItemList(lstCmpItem, horTableName, select);
        select.selectList = null;
        select.selectList = orderedSelectors;
        select.distinct = 1;
        StringBuffer sb = new StringBuffer();
        try {
            DrSQLFormater formater = new DrSQLFormater(sb);
            formater.formatSelect(select);
        }
        catch (FormaterException e2) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return sb.toString();
    }

    private ArrayList buildSelectItemList(List lstCmpItem, String horTableName, SqlSelect select) throws EmpCompenseException {
        List selectors = select.selectList;
        ArrayList<SqlSelectItem> orderedSelectors = new ArrayList<SqlSelectItem>();
        String itemNumber = "";
        SqlExprParser parser = null;
        int size = lstCmpItem.size();
        for (int i = 0; i < size; ++i) {
            SqlSelectItem item = null;
            itemNumber = ((CmpItemInfo)lstCmpItem.get(i)).getNumber();
            int jsize = selectors.size();
            for (int j = 0; j < jsize; ++j) {
                if (!((SqlSelectItem)selectors.get((int)j)).alias.replaceAll("\"", "").trim().equals(itemNumber.replaceAll("\"", "").trim())) continue;
                item = (SqlSelectItem)selectors.get(j);
                break;
            }
            if (item == null) {
                try {
                    item = new SqlSelectItem();
                    parser = itemNumber.equalsIgnoreCase("FOTHERTOTAL") ? new SqlExprParser(this.getTotalExpr(lstCmpItem, horTableName)) : new SqlExprParser(horTableName + "." + itemNumber);
                    item.expr = parser.expr();
                    item.alias = itemNumber;
                    orderedSelectors.add(item);
                    continue;
                }
                catch (ParserException e1) {
                    throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
                }
            }
            orderedSelectors.add(item);
        }
        try {
            SqlSelectItem item = null;
            itemNumber = "FPERSONID";
            item = new SqlSelectItem();
            parser = new SqlExprParser("PERSON.FID");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
            itemNumber = "INDEXOF";
            item = new SqlSelectItem();
            parser = new SqlExprParser("\"PERSON\".FIndex");
            item.expr = parser.expr();
            item.alias = itemNumber;
            orderedSelectors.add(item);
        }
        catch (ParserException e1) {
            throw new EmpCompenseException(EmpCompenseException.SQLFORMATTING_ERROR);
        }
        return orderedSelectors;
    }

    private String getTotalExpr(List lstColumn, String horTableName) {
        StringBuffer sb = new StringBuffer("");
        CmpItemInfo infoColumn = null;
        String number = null;
        int dataType = 0;
        int size = lstColumn.size();
        for (int i = 0; i < size; ++i) {
            infoColumn = (CmpItemInfo)lstColumn.get(i);
            number = infoColumn.getNumber();
            dataType = infoColumn.getDataType().getValue();
            if (number.equalsIgnoreCase("FOTHERTOTAL") || dataType != 60) continue;
            sb.append(horTableName);
            sb.append(".");
            sb.append(number);
            sb.append("+");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private SqlSelect getBankItemSQL(Context ctx, EntityViewInfo entityViewInfo, HashMap paramMap) throws BOSException, EmpCmpSchmFacadeException {
        SqlSelectBase sb;
        String horTableName = (String)paramMap.get("horTableName");
        String sql = HRSchemeUtils.getCmpDynamicTableSql(ctx, horTableName, entityViewInfo);
        int index = sql.indexOf(" ORDER BY ");
        if (index > -1) {
            sql = sql.substring(0, index);
        }
        SqlSelect select = null;
        try {
            SelectParser parser = new SelectParser(sql);
            sb = parser.select();
        }
        catch (ParserException e) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.PARSE_SQL_EXEC, e);
        }
        if (sb == null || !(sb instanceof SqlSelect)) {
            throw new EmpCmpSchmFacadeException(EmpCmpSchmFacadeException.GET_FIXEDSQL_EXEC);
        }
        select = (SqlSelect)sb;
        return select;
    }

    private void insertToPersonList(Context ctx, IObjectPK cmpSchemePK) throws BOSException {
        ICmpSchemePerson iCmpSchemePerson = CmpSchemePersonFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewCmpInfo = new EntityViewInfo();
        FilterInfo filterCmpInfo = new FilterInfo();
        filterCmpInfo.getFilterItems().add(new FilterItemInfo("CMPSCHEME.id", (Object)cmpSchemePK.toString()));
        filterCmpInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
        entityViewCmpInfo.setFilter(filterCmpInfo);
        CmpSchemePersonCollection cmpSchemePersonColl = iCmpSchemePerson.getCmpSchemePersonCollection(entityViewCmpInfo);
        int conutCycle = cmpSchemePersonColl.size();
        for (int i = 0; i < conutCycle; ++i) {
            CmpSchemePersonInfo cmpSchemePersonInfo = cmpSchemePersonColl.get(i);
            this.personListInScheme.add(cmpSchemePersonInfo.getPerson().getId().toString());
        }
    }

    protected String getCmpPersonInfoOfSql(Context ctx, IObjectPK cmpSchemePK, EntityViewInfo entityViewInfo, HashMap map) throws BOSException {
        StringBuffer sb = new StringBuffer("");
        if (entityViewInfo != null) {
            MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoQuery");
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemePK.toString()));
            if (entityViewInfo.getFilter() != null && entityViewInfo.getFilter().getMaskString() != null) {
                entityViewInfo.getFilter().mergeFilter(filterInfo, "and");
            } else {
                entityViewInfo.setFilter(filterInfo);
            }
            queryExec.setObjectView(entityViewInfo);
            sb.append("select FPERSONID from " + queryExec.getSQL());
        }
        String sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sb.toString());
        return sql;
    }

    protected String getSelectPersonSQLByCmp(Context ctx, IObjectPK cmpSchemePK, EntityViewInfo entityViewInfo, HashMap map) {
        StringBuffer sb = new StringBuffer("");
        sb.append(" select FPersonID  from   T_HR_CMPSCHEMEPERSON  where FCmpSchemeID='" + cmpSchemePK.toString() + "'");
        return sb.toString();
    }

    @Override
    protected List _getCmpPersonInfo(Context ctx, IObjectPK cmpSchemePK, EntityViewInfo entityViewInfo) throws BOSException {
        this.insertToPersonList(ctx, cmpSchemePK);
        if (entityViewInfo != null) {
            MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.BankOrgPersonNewQuery");
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            HROrgUnitInfo hROrgUnitInfo = HRSchemeUtils.getServerHROrgUnitInfo(ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hROrgUnitInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("PM.isPrimary", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("PM.isPrimary", (Object)"1"));
            filterInfo.setMaskString("#0 AND (#1 or #2)");
            if (entityViewInfo.getFilter() != null && entityViewInfo.getFilter().getMaskString() != null) {
                entityViewInfo.getFilter().mergeFilter(filterInfo, "and");
            } else {
                entityViewInfo.setFilter(filterInfo);
            }
            queryExec.setObjectView(entityViewInfo);
            IRowSet rowSetPerson = queryExec.executeQuery();
            String personId = null;
            try {
                while (rowSetPerson.next()) {
                    personId = rowSetPerson.getString(1);
                    if (!this.personListInScheme.contains(personId)) continue;
                    this.allPersonListScheme.add(personId);
                }
            }
            catch (SQLException e) {
                throw new BOSException();
            }
        } else {
            this.allPersonListScheme = this.personListInScheme;
        }
        return this.allPersonListScheme;
    }

    @Override
    protected CurrencyInfo _getCurrencyInfo(Context ctx) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = null;
        IHRInit tt = HRInitFactory.getLocalInstance((Context)ctx);
        String sID = tt.getJXCurrency();
        if (sID != null) {
            ICurrency iCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx);
            currencyInfo = iCurrencyInfo.getCurrencyInfo((IObjectPK)new ObjectUuidPK(sID));
        }
        return currencyInfo;
    }

    @Override
    protected IRowSet _getCmpCashRMB(Context ctx, HashMap paramMap) throws BOSException, EASBizException {
        int i;
        String language = ctx.getLocale().getLanguage();
        List adminList = (List)paramMap.get("adminList");
        String tableName = paramMap.get("cmpSchemeTable").toString();
        List empTypeList = (List)paramMap.get("employeeType");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT  sum(FFSAL230) AS FFSAL230,");
        stringBuffer.append(" t_org_admin.fdisplayname_").append(language).append(" AS ADMINNAME,");
        stringBuffer.append(" t_org_admin.fid AS ADMINID");
        stringBuffer.append(" FROM " + tableName);
        stringBuffer.append(" INNER JOIN T_BD_PERSON ON T_BD_PERSON.Fid = " + tableName + ".Fpersonid ");
        stringBuffer.append(" left join T_HR_BDEMPLOYEETYPE empType on empType.fid = T_BD_PERSON.femployeetypeid ");
        stringBuffer.append(" LEFT JOIN t_org_admin ON T_org_admin.fid = " + tableName + ".FADMINORGUNITID ");
        stringBuffer.append(" WHERE t_org_admin.fid in(");
        int size = adminList.size();
        for (i = 0; i < size; ++i) {
            stringBuffer.append("'" + adminList.get(i).toString() + "'");
            if (i == size - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" )");
        if (empTypeList != null && empTypeList.size() > 0) {
            stringBuffer.append(" and empType.fid in (");
            for (i = 0; i < empTypeList.size(); ++i) {
                stringBuffer.append("'" + empTypeList.get(i).toString() + "'");
                if (i == empTypeList.size() - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append("  Group by t_org_admin.fid, t_org_admin.fdisplayname_" + language);
        stringBuffer.append(" ORDER BY t_org_admin.fid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)stringBuffer.toString());
        return rs;
    }

    private String createTempTable(Context ctx, List schemeIDList, List cmpItemList, TempTablePool pool) throws BOSException, SQLException {
        String tempTableName = null;
        StringBuffer strSelectors = new StringBuffer();
        strSelectors.append(" create TABLE aa ").append(" (FCmpSchemeID varchar(44),FPersonId varchar(44),FAdminOrgUnitID varchar(44),FPositionID varchar(44) ");
        StringBuffer itemSql = new StringBuffer();
        CmpItemInfo itemInfo = null;
        String number = null;
        ArrayList<String> cmpItemNumberList = new ArrayList<String>();
        boolean hasCashFlag = false;
        for (int i = 0; i < cmpItemList.size(); ++i) {
            itemInfo = (CmpItemInfo)cmpItemList.get(i);
            number = itemInfo.getNumber();
            if (number.startsWith("FPER")) continue;
            if (number.equalsIgnoreCase("FOTH001")) {
                hasCashFlag = true;
            }
            itemSql.append(",");
            if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.CURRENCY) || itemInfo.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                itemSql.append(number).append(" Decimal(22,8) ");
            } else if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.INT) || itemInfo.getDataType().equals((Object)ItemDataTypeEnum.LOGIC)) {
                itemSql.append(number).append(" int ");
            } else if (itemInfo.getDataType().equals((Object)ItemDataTypeEnum.DATE)) {
                itemSql.append(number).append(" DateTime ");
            } else {
                itemSql.append(number).append(" nvarchar(255) ");
            }
            cmpItemNumberList.add(number);
        }
        if (!hasCashFlag) {
            itemSql.append(" ,FOTH001 int ");
            cmpItemNumberList.add("FOTH001");
        }
        strSelectors.append(itemSql).append(")");
        try {
            tempTableName = pool.createTempTable(strSelectors.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.fillDataToTempTable(ctx, schemeIDList, cmpItemNumberList, tempTableName);
        return tempTableName;
    }

    private void fillDataToTempTable(Context ctx, List schemeIDList, List cmpItemNumberList, String tempTableName) throws BOSException, SQLException {
        if (cmpItemNumberList == null || cmpItemNumberList.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select T1.fid,T1.FHorTableName,T3.fnumber ");
        sb.append(" from t_hr_cmpscheme T1");
        sb.append(" inner join t_hr_cmpschemeItem T2 on T1.fid = T2.fcmpschemeID ");
        sb.append(" inner join t_hr_cmpItem T3 on T3.fid = T2.fcmpItemID ");
        sb.append(" where T1.fid in ").append(CompUtils.getStrFromList(schemeIDList));
        sb.append("  and T3.Fnumber in ").append(CompUtils.getStrFromList(cmpItemNumberList));
        IRowSet rowResult = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap schemeItemMap = new HashMap();
        HashMap<String, String> schemeIDMap = new HashMap<String, String>();
        String tableName = null;
        List<String> itemList = null;
        rowResult.beforeFirst();
        while (rowResult.next()) {
            tableName = rowResult.getString("FHorTableName");
            if (schemeItemMap.containsKey(tableName)) {
                itemList = (List)schemeItemMap.get(tableName);
            } else {
                itemList = new ArrayList();
                schemeItemMap.put(tableName, itemList);
            }
            itemList.add(rowResult.getString("fnumber"));
            if (schemeIDMap.containsKey(tableName)) continue;
            schemeIDMap.put(tableName, rowResult.getString("fid"));
        }
        StringBuffer sql = null;
        StringBuffer inserSql = null;
        SQLUtils.cleanup((ResultSet)rowResult);
        Iterator iter = schemeItemMap.keySet().iterator();
        String cmpSchemeID = null;
        while (iter.hasNext()) {
            tableName = iter.next().toString();
            cmpSchemeID = (String)schemeIDMap.get(tableName);
            itemList = (List)schemeItemMap.get(tableName);
            if (itemList == null || itemList.size() == 0) continue;
            sql = new StringBuffer();
            for (int i = 0; i < itemList.size(); ++i) {
                sql.append(",").append(itemList.get(i).toString());
            }
            inserSql = new StringBuffer();
            inserSql.append(" insert into ").append(tempTableName).append("(FcmpschemeID,FPersonID,FAdminOrgUnitID,FPositionID").append(sql).append(")").append("select '").append(cmpSchemeID).append("',FPersonID,FAdminOrgUnitID,FPositionID").append(sql).append(" from ").append(tableName);
            DbUtil.execute((Context)ctx, (String)inserSql.toString());
        }
    }
}

