/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlUpdate;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.UpdateParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CalEmpSchmException;
import com.kingdee.eas.hr.compensation.CmpSchemeException;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchmException;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.SchemeAuditedEnum;
import com.kingdee.eas.hr.compensation.SimpleFormulaInfo;
import com.kingdee.eas.hr.compensation.app.AbstractCalCmpSchmFacadeControllerBean;
import com.kingdee.eas.hr.compensation.app.CmpCalculate;
import com.kingdee.eas.hr.compensation.formulateutil.KScriptToKSQL;
import com.kingdee.eas.hr.compensation.util.DependForest;
import com.kingdee.eas.hr.compensation.util.DependNode;
import com.kingdee.eas.hr.compensation.util.TODOException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalCmpSchmFacadeControllerBean
extends AbstractCalCmpSchmFacadeControllerBean {
    boolean showTODOException = false;
    private HashMap mapFormula = new HashMap(64);
    private HashMap mapFormulaId = new HashMap(64);

    @Override
    protected boolean _beforeCalCheck(Context ctx, IObjectPK empSchPK) throws BOSException, EASBizException {
        if (this.showTODOException) {
            throw new TODOException("TODO");
        }
        return true;
    }

    @Override
    protected void _calculateEmpScheme(Context ctx, IObjectPK empSchPK) throws BOSException, EASBizException {
        HashMap<String, Boolean> mapParam = new HashMap<String, Boolean>();
        mapParam.put("ISTAX", true);
        mapParam.put("ISGetBenefitData", true);
        mapParam.put("ISGetTimeData", true);
        mapParam.put("ISGetFixedData", true);
        CmpCalculate iCmpCalculate = new CmpCalculate(ctx, empSchPK.toString());
        iCmpCalculate.calculate();
    }

    @Override
    protected void _calculateEmpSchemes(Context ctx, List empSchPKList) throws BOSException, EASBizException {
        if (empSchPKList != null && empSchPKList.size() > 0) {
            int size = empSchPKList.size();
            for (int i = 0; i < size; ++i) {
                this._calculateEmpScheme(ctx, (IObjectPK)empSchPKList.get(i));
            }
        }
    }

    @Override
    protected void _rebuildSQLList(Context ctx, IObjectPK empSchPK) throws BOSException, EASBizException {
        this.updateItemFormula(ctx, empSchPK);
        String allSql = this.analyseSql(this.mapFormula);
        this.saveResultSql(ctx, empSchPK.toString(), allSql);
    }

    private String analyseSql(Map itemAndSQL) throws CalEmpSchmException {
        Iterator itl = null;
        StringBuffer regex = new StringBuffer();
        String depdReg = "";
        itl = itemAndSQL.keySet().iterator();
        while (itl.hasNext()) {
            regex.append((String)itl.next());
            regex.append("|");
        }
        if (regex.lastIndexOf("|") >= 0) {
            regex.deleteCharAt(regex.lastIndexOf("|"));
        }
        depdReg = regex.toString();
        regex = null;
        String key2 = null;
        String sql = null;
        HashMap<String, String> dependItems = new HashMap<String, String>();
        itl = itemAndSQL.keySet().iterator();
        String dependItmNumList = "";
        while (itl.hasNext()) {
            sql = ((SimpleFormulaInfo)itemAndSQL.get((Object)key2)).sqlStmt;
            key2 = (String)itl.next();
            dependItmNumList = this.getDependItems(depdReg, sql, key2);
            if (dependItmNumList.length() <= 0) continue;
            dependItems.put(key2, dependItmNumList);
        }
        DependForest chrt = new DependForest();
        ArrayList<DependNode> items = new ArrayList<DependNode>();
        List rst = null;
        HashMap<String, DependNode> nodes = new HashMap<String, DependNode>();
        itl = itemAndSQL.keySet().iterator();
        DependNode compenItem = null;
        while (itl.hasNext()) {
            key2 = (String)itl.next();
            compenItem = new DependNode(key2);
            items.add(compenItem);
            nodes.put(key2, compenItem);
        }
        itl = dependItems.keySet().iterator();
        String[] dependItemsNum = null;
        while (itl.hasNext()) {
            key2 = (String)itl.next();
            dependItemsNum = ((String)dependItems.get(key2)).split(";");
            int size = dependItemsNum.length;
            for (int i = 0; i < size; ++i) {
                ((DependNode)nodes.get(key2)).addDependItem((DependNode)nodes.get(dependItemsNum[i]));
            }
        }
        chrt.build(items);
        rst = chrt.travelForest();
        HashMap<Integer, CharSequence> levelSQL = new HashMap<Integer, CharSequence>();
        Map node = null;
        Integer level = null;
        Integer max = 0;
        StringBuffer itemSQLBuff = null;
        int size = rst.size();
        for (int i = 0; i < size; ++i) {
            node = (Map)rst.get(i);
            for (String key2 : node.keySet()) {
                level = (Integer)node.get(key2);
                if (level <= max) continue;
                max = level;
            }
            if (levelSQL.containsKey(level)) {
                ((StringBuffer)levelSQL.get(level)).append(";");
                ((StringBuffer)levelSQL.get(level)).append(((SimpleFormulaInfo)itemAndSQL.get((Object)key2)).sqlStmt);
                continue;
            }
            itemSQLBuff = new StringBuffer();
            itemSQLBuff.append(((SimpleFormulaInfo)itemAndSQL.get((Object)key2)).sqlStmt);
            levelSQL.put(level, itemSQLBuff);
        }
        itl = levelSQL.keySet().iterator();
        String itemSQL = "";
        Integer leveKey = null;
        while (itl.hasNext()) {
            leveKey = (Integer)itl.next();
            try {
                itemSQL = this.unitUpdStmt(((StringBuffer)levelSQL.get(leveKey)).toString());
            }
            catch (Exception e) {
                throw new CalEmpSchmException(CalEmpSchmException.MERGERSQL_WRONG, e);
            }
            levelSQL.put(leveKey, itemSQL);
        }
        StringBuffer allSQL = new StringBuffer();
        for (int i = max.intValue(); i >= 0; --i) {
            allSQL.append(levelSQL.get(i));
            allSQL.append(" ; ");
        }
        if (allSQL.lastIndexOf(";") > 0) {
            allSQL.deleteCharAt(allSQL.lastIndexOf(";"));
        }
        return allSQL.toString();
    }

    private void saveResultSql(Context ctx, String cmpSchemeId, String allSql) throws SQLDataException, CalEmpSchmException {
        String updSql = "UPDATE T_HR_CMPSCHEME SET FSQLSTMT = ? , FLASTCALTIME = ? WHERE FID= ? ";
        Connection con = this.getConnection(ctx);
        PreparedStatement stm = null;
        try {
            stm = con.prepareStatement(updSql);
            stm.setString(1, allSql.toString());
            stm.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stm.setString(3, cmpSchemeId);
            stm.executeUpdate();
        }
        catch (SQLException e) {
            throw new CalEmpSchmException(CalEmpSchmException.UPD_SQLSTMT_EXEC);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
            SQLUtils.cleanup((Statement)stm);
        }
    }

    private String unitUpdStmt(String sqlList) throws FormaterException, ParserException {
        if (sqlList == null || sqlList.length() == 0) {
            return null;
        }
        StringBuffer sqlBuff = new StringBuffer();
        HashMap<String, String> SQLMap = new HashMap<String, String>();
        String[] updStmtList = sqlList.split(";");
        String NO_WHERE_UPDSTMT = "NO_WHERE_EXPR";
        StringBuffer buff = new StringBuffer();
        UpdateParser parser = null;
        SqlUpdate update = null;
        SqlExpr whereExpr = null;
        int size = updStmtList.length;
        for (int i = 0; i < size; ++i) {
            parser = new UpdateParser(updStmtList[i]);
            update = parser.update();
            if (update == null) continue;
            whereExpr = update.condition;
            if (whereExpr == null) {
                Object obj = SQLMap.get(NO_WHERE_UPDSTMT);
                if (obj == null) {
                    SQLMap.put(NO_WHERE_UPDSTMT, updStmtList[i]);
                    continue;
                }
                parser = new UpdateParser((String)obj);
                SQLMap.put(NO_WHERE_UPDSTMT, this.unitUpdSetExpr(parser.update(), update));
                continue;
            }
            buff.delete(0, buff.length());
            DrSQLFormater formater = new DrSQLFormater(buff);
            formater.formatExpr(whereExpr);
            Object obj = SQLMap.get(buff.toString());
            if (obj == null) {
                SQLMap.put(buff.toString(), updStmtList[i]);
                continue;
            }
            parser = new UpdateParser((String)obj);
            SQLMap.put(buff.toString(), this.unitUpdSetExpr(parser.update(), update));
        }
        Iterator itl = SQLMap.keySet().iterator();
        int count = 0;
        while (itl.hasNext()) {
            sqlBuff.append(SQLMap.get((String)itl.next()));
            sqlBuff.append(";");
            ++count;
        }
        if (count > 0) {
            sqlBuff.deleteCharAt(sqlBuff.lastIndexOf(";"));
        }
        return sqlBuff.toString();
    }

    private String unitUpdSetExpr(SqlUpdate upd1, SqlUpdate upd2) throws FormaterException {
        StringBuffer sql = new StringBuffer();
        if (upd1 != null && upd1.updateList != null && upd2 != null && upd2.updateList != null) {
            int size = upd2.updateList.size();
            for (int i = 0; i < size; ++i) {
                upd1.updateList.add(upd2.updateList.get(i));
            }
            DrSQLFormater formater = new DrSQLFormater(sql);
            formater.formatUpdateStmt(new SqlUpdateStmt(upd1));
        }
        return sql.toString();
    }

    private String getDependItems(String regex, String sql, String self) {
        StringBuffer buff = new StringBuffer();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(sql);
        String itemNum = "";
        while (m.find()) {
            itemNum = sql.substring(m.start(), m.end());
            if (buff.indexOf(itemNum) >= 0 || itemNum.equals(self)) continue;
            buff.append(itemNum);
            buff.append(";");
        }
        if (buff.lastIndexOf(";") > 0) {
            buff.deleteCharAt(buff.lastIndexOf(";"));
        }
        return buff.toString();
    }

    private void updateItemFormula(Context ctx, IObjectPK empSchPK) throws EASBizException, BOSException {
        String key = "";
        SimpleFormulaInfo smpFormulaInfo = null;
        StringBuffer updStmt = new StringBuffer();
        updStmt.append("UPDATE t_hr_formula SET FSQLSTMT = ? WHERE FID = ?");
        Connection con = this.getConnection(ctx);
        PreparedStatement stm = null;
        Iterator itor = this.mapFormulaId.keySet().iterator();
        try {
            stm = con.prepareStatement(updStmt.toString());
            while (itor.hasNext()) {
                String sql;
                key = (String)itor.next();
                smpFormulaInfo = (SimpleFormulaInfo)this.mapFormulaId.get(key);
                KScriptToKSQL translator = new KScriptToKSQL();
                ((SimpleFormulaInfo)this.mapFormulaId.get((Object)key)).sqlStmt = sql = translator.translateScript(ctx, smpFormulaInfo.formula, empSchPK);
                stm.setString(1, sql);
                stm.setString(2, key);
                stm.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new CalEmpSchmException(CalEmpSchmException.UDP_ITMESQLSTMT_EXEC, e, new String[]{smpFormulaInfo.formula});
        }
        finally {
            SQLUtils.cleanup((Statement)stm, (Connection)con);
        }
    }

    @Override
    protected List _FormulaModifyList(Context ctx, IObjectPK empSchPK) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _calculateEmpScheme(Context ctx, HashMap mapParam) throws BOSException, EASBizException {
        IObjectPK pkCmpScheme = (IObjectPK)mapParam.get("CMPSCHEMEPK");
        CmpSchemeInfo infoCmpScheme = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo("select *,cmpPeriod.* where id='" + pkCmpScheme.toString() + "'");
        if (infoCmpScheme.getAudit() == SchemeAuditedEnum.AUDITING || infoCmpScheme.getAudit() == SchemeAuditedEnum.AUDITEDPASS) {
            throw new CmpSchemeException(CmpSchemeException.CMPSCHEME_NOT_CALCULATE);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)infoCmpScheme.getBOSType(), (IObjectPK)pkCmpScheme, (String)infoCmpScheme.getName(), (String)"cmpscheme_cal");
        CmpCalculate iCmpCalculate = new CmpCalculate(ctx, pkCmpScheme.toString(), mapParam);
        String temporaryTableName = null;
        Map map = new HashMap();
        try {
            iCmpCalculate.calculate();
            temporaryTableName = iCmpCalculate.temporaryTableName;
            this.increaseCalCount(ctx, pkCmpScheme.toString(), temporaryTableName, infoCmpScheme);
            map = this.getLessEqualZeroData(ctx, infoCmpScheme.getHorTableName(), temporaryTableName);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty(temporaryTableName)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(temporaryTableName);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return map;
    }

    @Override
    protected void _calculateTryScheme(Context ctx, String strTrySchemeId, String strAdjustSchemeID) throws BOSException, EASBizException {
        this._addCmpTrySchemePerson(ctx, strTrySchemeId, strAdjustSchemeID);
        ICmpScheme iScheme = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo schemeInfo = iScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strTrySchemeId));
        if (schemeInfo.getHorTableName() == null) {
            iScheme.enableScheme((IObjectPK)new ObjectUuidPK(strTrySchemeId));
        } else {
            StringBuffer sqlDelete = new StringBuffer();
            sqlDelete.append(" delete from " + schemeInfo.getHorTableName());
            sqlDelete.append(" where not exists (select fpersonid from T_HR_CMPSCHEMEPERSON where fcmpschemeid = '" + strTrySchemeId + "'");
            sqlDelete.append(" and fpersonid = " + schemeInfo.getHorTableName() + ".fpersonid and fisDelete = 0)");
            DbUtil.execute((Context)ctx, (String)sqlDelete.toString());
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append(" insert into " + schemeInfo.getHorTableName() + "(fpersonid,Fperiod,Fadminorgunitid,fpositionID,FSEQUENCE,Ftime) ");
            sqlInsert.append(" select fpersonid,'" + schemeInfo.getCmpPeriod().getId().toString() + "',fadminorgunitid,fpositionID,0,1 from T_HR_CMPSCHEMEPERSON ");
            sqlInsert.append(" where fcmpschemeid = '" + strTrySchemeId + "' and fisDelete = 0 ");
            sqlInsert.append(" and (not exists (select fpersonid from " + schemeInfo.getHorTableName() + " where fpersonid = T_HR_CMPSCHEMEPERSON.fpersonid) )");
            DbUtil.execute((Context)ctx, (String)sqlInsert.toString());
        }
        CmpCalculate iCmpCalculate = new CmpCalculate(ctx, strTrySchemeId, strAdjustSchemeID, true);
        iCmpCalculate.calculate();
    }

    @Override
    protected void _addCmpTrySchemePerson(Context ctx, String strTrySchemeID, String strAdjustSchemeID) throws BOSException, EASBizException {
        String sqlDelete = "delete T_HR_CMPSCHEMEPERSON where FCmpSchemeID = '" + strTrySchemeID + "'";
        DbUtil.execute((Context)ctx, (String)sqlDelete);
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_HR_CMPSCHEMEPERSON(Fid,FCmpSchemeID,FPersonID,FAdminOrgUnitID,FPositionID) ");
        sql.append(" select newbosid('2230733E'),'" + strTrySchemeID + "',TPerson.Fadjempid,TPerson.Fpersondep,TPerson.Fprimarypositionid ");
        sql.append(" from ");
        sql.append(" ( ");
        sql.append(" select distinct T1.Fadjempid,t3.fpersondep,t3.fprimarypositionid ");
        sql.append(" from t_hr_adjschitem T1 ");
        sql.append(" inner join t_hr_adjscheme T2 on t2.fid = T1.Fadjschemeid ");
        sql.append(" inner join t_hr_personposition T3 on t3.fpersonid = t1.fadjempid ");
        sql.append(" where t2.fid = '" + strAdjustSchemeID + "' ");
        sql.append(" ) TPerson");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _increaseCalCount(Context ctx, String cmpSchemeID, String tempTable, CmpSchemeInfo cmpSchemeInfo) throws BOSException, EASBizException {
        String sql = " UPDATE T_HR_CMPSCHEME SET FCalCount = (FCalCount+1) WHERE FID=?";
        Object[] param = new Object[]{cmpSchemeID};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
        this.updateCheckState(ctx, tempTable, 1, cmpSchemeInfo);
    }

    @Override
    protected void _updateCheckState(Context ctx, String temporaryTableName, int state, CmpSchemeInfo schemeInfo) throws BOSException, EASBizException {
        String horTable = schemeInfo.getHorTableName();
        if (!StringUtils.isEmpty((String)horTable)) {
            String str = " SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FCalType' AND KSQL_COL_TABNAME='" + horTable + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str);
            if (rs.size() == 0) {
                throw new CmpSchmException(CmpSchmException.SCHEME_UPDATE_ERROR);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("update ").append(horTable).append(" set FCalType = ").append(state).append(" where ").append(horTable).append(".FPERSONID IN ( SELECT FPERSONID FROM ").append(temporaryTableName).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private Map getLessEqualZeroData(Context ctx, String horTableName, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sql.append("select hor.FPERSONID as personid, p.FNumber as number, p.fName_").append(language).append(" as name from ");
        sql.append(horTableName);
        sql.append(" hor ");
        sql.append(" inner join ");
        sql.append(tempTableName);
        sql.append(" temp ");
        sql.append(" on hor.FPERSONID = temp.FPERSONID ");
        sql.append(" inner join t_bd_person p ");
        sql.append(" on hor.FPERSONID = p.FID ");
        sql.append(" where hor.FSAL006 <= 0");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String personID = null;
        HashMap map = new HashMap();
        ArrayList<String> list = null;
        try {
            while (rowSet.next()) {
                personID = rowSet.getString("personid");
                list = new ArrayList<String>();
                list.add(rowSet.getString("number"));
                list.add(rowSet.getString("name"));
                map.put(personID, list);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        return map;
    }
}

