/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpCheckInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.SimpleFormulaInfo;
import com.kingdee.eas.hr.compensation.app.AbstractCmpDataCheckFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.hr.compensation.util.TaxHistoryQueryUtilParam;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CmpDataCheckFacadeControllerBean
extends AbstractCmpDataCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpDataCheckFacadeControllerBean");

    @Override
    protected CmpCheckInfo _checkCmpSchemePersonDup(Context ctx, String schemeid) throws BOSException, EASBizException {
        CmpCheckInfo info = new CmpCheckInfo();
        info.setEntries(new ArrayList());
        String hortablename = null;
        String personid = null;
        String personnumber = null;
        String sql = " select FHORTABLENAME from t_hr_cmpscheme where fid=? ";
        Object[] param = new Object[]{schemeid};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (iRowSet.next()) {
                hortablename = iRowSet.getString("FHORTABLENAME");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        int countCmpSchemeDup = 0;
        int countDynamicDup = 0;
        int countDifference = 0;
        ArrayList<CmpCheckInfo> lstTemp = new ArrayList<CmpCheckInfo>();
        CmpCheckInfo infoTemp = new CmpCheckInfo();
        HashMap<String, String> mapDynamicPerson = new HashMap<String, String>();
        sql = "select per.fid as fpersonid, per.fnumber as fnumber from t_hr_personcmp pc inner join t_bd_person per on pc.fpersonid = per.fid where pc.fpersonid in (select fpersonid from t_hr_cmpschemeperson where fcmpschemeid = '" + schemeid + "' and fisDelete = 0) and pc.fispayperson = 0";
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("fpersonid");
                personnumber = iRowSet.getString("fnumber");
                infoTemp = new CmpCheckInfo();
                infoTemp.setOK(false);
                infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"18_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"19_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                lstTemp.add(infoTemp);
                ++countDynamicDup;
                mapDynamicPerson.put(personid, personnumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        if (countDynamicDup > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"20_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countDynamicDup + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"21_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        lstTemp = new ArrayList();
        infoTemp = new CmpCheckInfo();
        HashMap<String, String> mapSchemePerson = new HashMap<String, String>();
        sql = " select schemeperson.fpersonid,person.fnumber from t_hr_cmpschemeperson schemeperson  left outer join t_bd_person person on person.fid=schemeperson.fpersonid  where fcmpschemeid=? and fisDelete = 0";
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("fpersonid");
                personnumber = iRowSet.getString("fnumber");
                if (mapSchemePerson.get(personid) != null) {
                    infoTemp = new CmpCheckInfo();
                    infoTemp.setOK(false);
                    infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"22_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"23_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    lstTemp.add(infoTemp);
                    ++countCmpSchemeDup;
                }
                mapSchemePerson.put(personid, personnumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        if (countCmpSchemeDup > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"24_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countCmpSchemeDup + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"25_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        if (hortablename == null) {
            return info;
        }
        lstTemp = new ArrayList();
        infoTemp = new CmpCheckInfo();
        mapDynamicPerson = new HashMap();
        sql = " select dynamictable.fpersonid,person.fnumber from " + hortablename + " dynamictable  left outer join t_bd_person person on person.fid=dynamictable.fpersonid ";
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("fpersonid");
                personnumber = iRowSet.getString("fnumber");
                if (mapDynamicPerson.get(personid) != null) {
                    infoTemp = new CmpCheckInfo();
                    infoTemp.setOK(false);
                    infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"26_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"23_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    lstTemp.add(infoTemp);
                    ++countDynamicDup;
                }
                mapDynamicPerson.put(personid, personnumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        if (countDynamicDup > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"27_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countDynamicDup + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"25_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        lstTemp = new ArrayList();
        infoTemp = new CmpCheckInfo();
        Iterator itrSchemePerson = mapSchemePerson.entrySet().iterator();
        Map.Entry entry2 = null;
        while (itrSchemePerson.hasNext()) {
            entry2 = itrSchemePerson.next();
            personid = (String)entry2.getKey();
            personnumber = (String)entry2.getKey();
            if (mapDynamicPerson.get(personid) != null) continue;
            infoTemp = new CmpCheckInfo();
            infoTemp.setOK(false);
            personnumber = personnumber == null ? "" : personnumber;
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"28_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"29_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            lstTemp.add(infoTemp);
            ++countDifference;
        }
        for (Map.Entry entry2 : mapDynamicPerson.entrySet()) {
            personid = (String)entry2.getKey();
            personnumber = (String)entry2.getValue();
            if (mapSchemePerson.get(personid) != null) continue;
            infoTemp = new CmpCheckInfo();
            infoTemp.setOK(false);
            personnumber = personnumber == null ? "" : personnumber;
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"28_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"30_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            lstTemp.add(infoTemp);
            ++countDifference;
        }
        if (countDifference > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"31_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countDifference + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"32_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        return info;
    }

    @Override
    protected CmpCheckInfo _checkFixedCmpScheme(Context ctx, String schemeid) throws BOSException, EASBizException {
        CmpCheckInfo info = new CmpCheckInfo();
        String fixedSchemeId = null;
        info.setEntries(new ArrayList());
        String hortablename = null;
        String personid = null;
        String personnumber = null;
        int countCmpSchemeDup = 0;
        int countDynamicDup = 0;
        int countDifference = 0;
        ArrayList<CmpCheckInfo> lstTemp = new ArrayList<CmpCheckInfo>();
        CmpCheckInfo infoTemp = new CmpCheckInfo();
        CmpSchemeInfo schemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo("select cmpperiod.id,cmpperiod.beginDate,cmpperiod.endDate,cmpperiod.hrOrgUnit.id where id='" + schemeid + "'");
        FixedCmpSchemeInfo infoFixedCmpScheme = HRUtils.getFixedSchemeInfoByPeriod(ctx, schemeInfo.getCmpPeriod());
        if (infoFixedCmpScheme != null) {
            hortablename = infoFixedCmpScheme.getHorTableName();
            fixedSchemeId = infoFixedCmpScheme.getId().toString();
        }
        String cmpSchemePersonFilter0 = " exists(select csp.fid from t_hr_cmpSchemePerson csp where ";
        String cmpSchemePersonFilter1 = ".fpersonid = csp.fpersonid and csp.FCmpSchemeID = ? and csp.fisDelete = 0)";
        StringBuffer getPersonSql = null;
        Object[] param = new Object[]{HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString()};
        IRowSet iRowSet = null;
        if (HRUtils.isCmpSchemeHaveFixCurrency(ctx, schemeid)) {
            if (fixedSchemeId == null) {
                infoTemp = new CmpCheckInfo();
                infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"33_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "\n" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.CmpCheckWizardResource", (String)"CMPDATACHECKFACADE_CHECK_2", (Locale)ctx.getOriginLocale()) + "\n" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.CmpCheckWizardResource", (String)"CMPDATACHECKFACADE_CHECK_3", (Locale)ctx.getOriginLocale()) + "\n" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.CmpCheckWizardResource", (String)"CMPDATACHECKFACADE_CHECK_4", (Locale)ctx.getOriginLocale()));
                infoTemp.setEntries(null);
                infoTemp.setOK(false);
                info.setOK(false);
                info.getEntries().add(infoTemp);
                return info;
            }
        } else {
            info.setOK(true);
            return info;
        }
        HashMap<String, String> mapSchemePerson = new HashMap<String, String>();
        getPersonSql = new StringBuffer();
        getPersonSql.append(" select schemeperson.fpersonid,person.fnumber from t_hr_fixedcmpschemeperson schemeperson ");
        getPersonSql.append(" inner join t_bd_person person on person.fid=schemeperson.fpersonid ");
        getPersonSql.append(" where schemeperson.ffixedcmpschemeid=? ");
        getPersonSql.append(" and schemeperson.FENABLE = 1 ");
        getPersonSql.append(" and ");
        getPersonSql.append(cmpSchemePersonFilter0);
        getPersonSql.append("schemeperson");
        getPersonSql.append(cmpSchemePersonFilter1);
        param = new Object[]{fixedSchemeId, schemeid};
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)getPersonSql.toString(), (Object[])param);
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("fpersonid");
                personnumber = iRowSet.getString("fnumber");
                if (mapSchemePerson.get(personid) != null) {
                    infoTemp = new CmpCheckInfo();
                    infoTemp.setOK(false);
                    infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"34_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"35_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    lstTemp.add(infoTemp);
                    ++countCmpSchemeDup;
                }
                mapSchemePerson.put(personid, personnumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        if (countCmpSchemeDup > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"36_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countCmpSchemeDup + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"37_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        if (hortablename == null) {
            return info;
        }
        lstTemp = new ArrayList();
        infoTemp = new CmpCheckInfo();
        HashMap<String, String> mapDynamicPerson = new HashMap<String, String>();
        getPersonSql = new StringBuffer();
        getPersonSql.append(" select dynamictable.fpersonid,person.fnumber from ");
        getPersonSql.append(hortablename);
        getPersonSql.append(" dynamictable ");
        getPersonSql.append(" inner join t_bd_person person on person.fid = dynamictable.fpersonid ");
        getPersonSql.append(" inner join t_hr_fixedcmpschemeperson fixedPerson on fixedPerson.fpersonid = dynamictable.fpersonid ");
        getPersonSql.append(" where fixedPerson.ffixedcmpschemeid=? and fixedPerson.FENABLE = 1 and ");
        getPersonSql.append(cmpSchemePersonFilter0);
        getPersonSql.append("dynamictable");
        getPersonSql.append(cmpSchemePersonFilter1);
        param = new Object[]{fixedSchemeId, schemeid};
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)getPersonSql.toString(), (Object[])param);
        try {
            while (iRowSet.next()) {
                personid = iRowSet.getString("fpersonid");
                personnumber = iRowSet.getString("fnumber");
                if (mapDynamicPerson.get(personid) != null) {
                    infoTemp = new CmpCheckInfo();
                    infoTemp.setOK(false);
                    infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"34_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"38_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
                    lstTemp.add(infoTemp);
                    ++countDynamicDup;
                }
                mapDynamicPerson.put(personid, personnumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        if (countDynamicDup > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"36_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countDynamicDup + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"39_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        lstTemp = new ArrayList();
        infoTemp = new CmpCheckInfo();
        Iterator itrSchemePerson = mapSchemePerson.entrySet().iterator();
        Map.Entry entry2 = null;
        while (itrSchemePerson.hasNext()) {
            entry2 = itrSchemePerson.next();
            personid = (String)entry2.getKey();
            personnumber = (String)entry2.getValue();
            if (mapDynamicPerson.get(personid) != null) continue;
            infoTemp = new CmpCheckInfo();
            infoTemp.setOK(false);
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"34_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"40_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            lstTemp.add(infoTemp);
            ++countDifference;
        }
        for (Map.Entry entry2 : mapDynamicPerson.entrySet()) {
            personid = (String)entry2.getKey();
            personnumber = (String)entry2.getValue();
            if (mapSchemePerson.get(personid) != null) continue;
            infoTemp = new CmpCheckInfo();
            infoTemp.setOK(false);
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"34_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + personnumber + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"41_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            lstTemp.add(infoTemp);
            ++countDifference;
        }
        if (countDifference > 0) {
            infoTemp = new CmpCheckInfo();
            infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"36_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + countDifference + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"42_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()));
            infoTemp.setEntries(lstTemp);
            infoTemp.setOK(false);
            info.setOK(false);
            info.getEntries().add(infoTemp);
        }
        return info;
    }

    @Override
    protected CmpCheckInfo _checkCmpDepTimeAndBenefit(Context ctx, String schemeid) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected CmpCheckInfo _checkFormula(Context ctx, String schemeid) throws BOSException, EASBizException {
        CmpCheckInfo info = new CmpCheckInfo();
        info.setEntries(new ArrayList());
        HashMap<String, SimpleFormulaInfo> mapFormula = new HashMap<String, SimpleFormulaInfo>();
        String sql = "select a.fformula,a.fformuladesc,c.fnumber,a.fid,c.fid from t_hr_formula a,t_hr_cmpschemeitem b,t_hr_cmpitem c  where a.fid = b.fformulaid and b.fcmpitemid = c.fid and b.fisdelete=0 and b.fcmpschemeid=?";
        SimpleFormulaInfo finfo = null;
        Object[] param = new Object[]{schemeid};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (rs.next()) {
                finfo = new SimpleFormulaInfo();
                finfo.formula = rs.getString(1);
                finfo.sqlStmt = rs.getString(2);
                finfo.number = rs.getString(3);
                finfo.id = rs.getString(5);
                mapFormula.put(rs.getString(3), finfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
        }
        String language = ctx.getLocale().getLanguage();
        HashMap<String, String> mapItem = new HashMap<String, String>();
        sql = " select b.fnumber,b.fid,b.Fname_" + language + "  from t_hr_cmpschemeitem a,t_hr_cmpitem b  where  a.fcmpitemid = b.fid and a.Fisdelete=1 and a.fcmpschemeid=? and b.fnumber not like 'FPER%'";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (rs.next()) {
                mapItem.put(rs.getString("fnumber"), rs.getString("Fname_" + language));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
        }
        if (mapItem.isEmpty() || mapFormula.isEmpty()) {
            info.setOK(true);
            return info;
        }
        ArrayList<CmpCheckInfo> lstTemp = null;
        CmpCheckInfo infoTemp = null;
        Iterator itrFormula = mapFormula.keySet().iterator();
        String formula = null;
        String itemnumber = null;
        String itemname = null;
        while (itrFormula.hasNext()) {
            finfo = (SimpleFormulaInfo)mapFormula.get(itrFormula.next());
            formula = this.replaceItemValueFun(finfo.formula);
            lstTemp = new ArrayList<CmpCheckInfo>();
            Iterator itrItem = mapItem.keySet().iterator();
            while (itrItem.hasNext()) {
                itemnumber = itrItem.next().toString();
                itemname = (String)mapItem.get(itemnumber);
                if (formula.indexOf(itemnumber) <= 0) continue;
                infoTemp = new CmpCheckInfo();
                infoTemp.setOK(false);
                infoTemp.setMessage(finfo.sqlStmt);
                lstTemp.add(infoTemp);
                infoTemp = new CmpCheckInfo();
                infoTemp.setMessage(ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"43_CmpDataCheckFacadeControllerBean", (Locale)ctx.getOriginLocale()) + "[" + itemname + "]" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"44_CmpDataCheckFacadeControllerBean", (Locale)ctx.getLocale()));
                infoTemp.setEntries(lstTemp);
                infoTemp.setOK(false);
                info.setOK(false);
                info.getEntries().add(infoTemp);
            }
        }
        return info;
    }

    private String replaceItemValueFun(String formula) {
        int endIndex;
        int posBefore;
        if (formula.toLowerCase().indexOf("itemvalue_abs_period") == -1 && formula.toLowerCase().indexOf("itemvalue_rel_period") == -1) {
            return formula;
        }
        String tempFun = null;
        if (formula.toLowerCase().indexOf("itemvalue_abs_period") != -1) {
            posBefore = formula.indexOf("itemvalue_abs_period", 1);
            endIndex = formula.indexOf(")", posBefore);
            tempFun = formula.substring(posBefore, endIndex + 1);
            formula = StringUtils.replace((String)formula, (String)tempFun, (String)"1");
        }
        if (formula.toLowerCase().indexOf("itemvalue_rel_period") != -1) {
            posBefore = formula.indexOf("itemvalue_rel_period", 1);
            endIndex = formula.indexOf(")", posBefore);
            tempFun = formula.substring(posBefore, endIndex + 1);
            formula = StringUtils.replace((String)formula, (String)tempFun, (String)"1");
        }
        return this.replaceItemValueFun(formula);
    }

    @Override
    protected boolean _checkPeriodEndInputAudit(Context ctx, String strCmpSchemeID, String strCmpPeriodID, int time) throws BOSException, EASBizException {
        boolean checkstate = false;
        String sql = " SELECT FCHECKSTATE FROM t_hr_pendinputstate where FCHECKSTATE=1 AND FCMPSCHEMEID=? AND FCmpPerioidId=? AND FTIME=? ";
        Object[] param = new Object[]{strCmpSchemeID, strCmpPeriodID, time};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            while (iRowSet.next()) {
                checkstate = iRowSet.getBoolean("FCHECKSTATE");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        return checkstate;
    }

    protected boolean _doTableSameData(Context ctx, String tablename, List lstPrimaryKeyColumns) throws BOSException, EASBizException, SQLException {
        boolean checkstate = false;
        ArrayList<String> lstColumnName = new ArrayList<String>();
        HRSchemeUtils.createTableBackup(ctx, tablename);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)(" SELECT top 1 * FROM " + tablename));
        ResultSetMetaData temp = iRowSet.getMetaData();
        StringBuffer sbTemp = new StringBuffer("");
        int size = temp.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            lstColumnName.add(temp.getColumnName(i).toUpperCase());
            sbTemp.append(temp.getColumnName(i).toUpperCase());
            sbTemp.append(",");
        }
        sbTemp = sbTemp.deleteCharAt(sbTemp.length() - 1);
        StringBuffer sbSql = new StringBuffer(" SELECT  ");
        sbSql.append(sbTemp);
        sbSql.append(tablename);
        sbSql.append(" GROUP BY ");
        sbSql.append(sbTemp);
        sbSql.append(" HAVING COUNT(*) > 1 ");
        return checkstate;
    }

    protected boolean _doFixedCmpSchemePersonTableSameData(Context ctx, String strFixedCmpSchemeID, String tablename) throws BOSException, EASBizException, SQLException {
        boolean checkstate = false;
        HRSchemeUtils.createTableBackup(ctx, tablename);
        Connection conn = EJBFactory.getConnection((Context)ctx);
        StringBuffer sbSql = new StringBuffer("");
        if (KSqlUtil.getDbType((Connection)conn) == 3) {
            sbSql.append("/*dialect*/ declare @max integer,@fpersonid varchar(44) ");
            sbSql.append(" declare cur_rows cursor local for select fpersonid,count(*) from " + tablename + " where ffixedcmpschemeid='" + strFixedCmpSchemeID + "' group by fpersonid  having count(*) > 1");
            sbSql.append(" open cur_rows ");
            sbSql.append(" fetch cur_rows into @fpersonid,@max   ");
            sbSql.append(" while @@fetch_status=0 ");
            sbSql.append(" begin");
            sbSql.append(" select @max = @max -1 ");
            sbSql.append(" set rowcount @max ");
            sbSql.append(" delete from  " + tablename + " where fpersonid = @fpersonid and ffixedcmpschemeid='" + strFixedCmpSchemeID + "' ");
            sbSql.append(" fetch cur_rows into  @fpersonid,@max  ");
            sbSql.append(" end ");
            sbSql.append(" close cur_rows ");
            sbSql.append(" set rowcount 0 ");
        } else {
            sbSql.append("/*dialect*/  ");
            sbSql.append(" delete from  " + tablename + " where rowid not in ");
            sbSql.append(" (select max(rowid) from  " + tablename + " where  ffixedcmpschemeid='" + strFixedCmpSchemeID + "' group by fpersonid  having count(*) > 1) ");
            sbSql.append(" and  ffixedcmpschemeid='" + strFixedCmpSchemeID + "'  ");
        }
        DbUtil.execute((Context)ctx, (String)sbSql.toString());
        sbSql = new StringBuffer(" select count(*) fcount from " + tablename + " where ffixedcmpschemeid=? group by fpersonid  having count(*) > 1");
        Object[] param = new Object[]{strFixedCmpSchemeID};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])param);
        try {
            int count = 0;
            if (iRowSet.next()) {
                count = iRowSet.getInt("fcount");
            }
            if (count > 0) {
                checkstate = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        return checkstate;
    }

    protected boolean _doFixedCmpSchemeDynamicTableSameData(Context ctx, String tablename) throws BOSException, EASBizException, SQLException {
        boolean checkstate = false;
        HRSchemeUtils.createTableBackup(ctx, tablename);
        Connection conn = EJBFactory.getConnection((Context)ctx);
        StringBuffer sbSql = new StringBuffer("");
        if (KSqlUtil.getDbType((Connection)conn) == 3) {
            sbSql.append("/*dialect*/ declare @max integer,@fpersonid varchar(44) ");
            sbSql.append(" declare cur_rows cursor local for select fpersonid,count(*) from " + tablename + "  group by fpersonid  having count(*) > 1");
            sbSql.append(" open cur_rows ");
            sbSql.append(" fetch cur_rows into @fpersonid,@max   ");
            sbSql.append(" while @@fetch_status=0 ");
            sbSql.append(" begin");
            sbSql.append(" select @max = @max -1 ");
            sbSql.append(" set rowcount @max ");
            sbSql.append(" delete from  " + tablename + " where fpersonid = @fpersonid  ");
            sbSql.append(" fetch cur_rows into  @fpersonid,@max  ");
            sbSql.append(" end ");
            sbSql.append(" close cur_rows ");
            sbSql.append(" set rowcount 0 ");
        } else {
            sbSql.append("/*dialect*/  ");
            sbSql.append(" delete from  " + tablename + " where rowid not in ");
            sbSql.append(" (select max(rowid) from  " + tablename + "  group by fpersonid  having count(*) > 1) ");
        }
        SQLUtils.cleanup((Connection)conn);
        DbUtil.execute((Context)ctx, (String)sbSql.toString());
        return checkstate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRowSet _getFixedCmpSchemeData(Context ctx, HashMap mapParam) throws BOSException, EASBizException {
        String hortableName = null;
        String strFixedcmspchemeID = (String)mapParam.get("FIXEDCMPSCHEMEID");
        List lstTemp = (List)mapParam.get("CMPITEMLIST");
        String sql = " select fhortablename from t_hr_fixedcmpscheme where fid=?";
        Object[] param = new Object[]{strFixedcmspchemeID};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        try {
            if (iRowSet.next()) {
                hortableName = iRowSet.getString("fhortablename");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup((ResultSet)iRowSet, null, null);
        }
        if (hortableName == null) {
            return null;
        }
        try {
            this._doDynamicTableAddSpecialColumn(ctx, hortableName);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        String language = ctx.getLocale().getLanguage();
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select a.FSPECIALID Fpersonid,b.fnumber FPER002 ,b.fname_").append(language).append(",FPER001");
        int size = lstTemp.size();
        for (int i = 0; i < size; ++i) {
            sbSql.append(" a." + lstTemp.get(i).toString() + ",");
        }
        sbSql.deleteCharAt(sbSql.length() - 1);
        sbSql.append("  from " + hortableName + " a ");
        sbSql.append(" Left outer join t_bd_person b on b.fid=a.fpersonid ");
        sbSql.append(" where a.fpersonid in (select fpersonid from  " + hortableName + " group by fpersonid having count(*)>1)");
        iRowSet = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString());
        return iRowSet;
    }

    private void _doDynamicTableAddSpecialColumn(Context ctx, String tablename) throws BOSException, EASBizException, SQLException {
        Connection conn = EJBFactory.getConnection((Context)ctx);
        StringBuffer sbSql = new StringBuffer("");
        if (KSqlUtil.getDbType((Connection)conn) == 3) {
            sbSql = new StringBuffer("IF NOT EXISTS (SELECT * FROM SYSCOLUMNS SYSCOL LEFT JOIN SYSOBJECTS SYSOBJ ON SYSCOL.ID = SYSOBJ.ID WHERE (SYSCOL.NAME = 'FSPECIALID' AND SYSOBJ.NAME = '" + tablename + "'))");
            sbSql.append(" BEGIN ");
            sbSql.append(" alter table  " + tablename + " add  [FSPECIALID] [uniqueidentifier] null");
            sbSql.append(" end ");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
            sbSql = new StringBuffer(" update  " + tablename + " set FSPECIALID=newid() ");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
        } else {
            sbSql = new StringBuffer();
            sbSql.append(" If not exists (select 1 from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FSPECIALID' ");
            sbSql.append(" and KSQL_COL_TABNAME='" + tablename + "') ");
            sbSql.append(" ALTER TABLE " + tablename + " ADD FSPECIALID VARCHAR(44); ");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
            sbSql = new StringBuffer("/*dialect*/ update " + tablename + " set FSPECIALID=rowid");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private String getTaxHistoryTableName(Context ctx, String cmpSchemeId) throws BOSException, SQLException {
        String sql = "select fhistablename,fhortablename from t_hr_cmpscheme where fid='" + cmpSchemeId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (!rs.next()) {
            return null;
        }
        if (rs.getString(1) == null) {
            return rs.getString(2);
        }
        return rs.getString(1);
    }

    private HashMap getPersonDept(Context ctx, Map params) throws Exception {
        String cmpSchemeId = (String)params.get("cmpSchemeId");
        String historyName = (String)params.get("historyName");
        EntityViewInfo customEV = (EntityViewInfo)params.get("customEV");
        HashMap<String, String> personDeptMap = new HashMap<String, String>();
        if (historyName == null || "".equals(historyName)) {
            // empty if block
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("cmpPeriod.*"));
        CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(cmpSchemeId), selector);
        CmpPeriodInfo cmpSchemePeriod = cmpSchemeInfo.getCmpPeriod();
        TaxHistoryQueryUtilParam queryParam = (TaxHistoryQueryUtilParam)params.get("queryParam");
        CmpPeriodInfo endCmpPeriod = this.getRealEndLastPeriod(ctx, queryParam, cmpSchemePeriod);
        if (endCmpPeriod == null) {
            return personDeptMap;
        }
        String sql = HRSchemeUtils.getCmpDynamicTableSql(ctx, historyName, customEV);
        int index = sql.indexOf("ORDER");
        if (index > -1) {
            sql = sql.substring(0, index);
        }
        sql = sql + " and " + historyName + "." + "FPERIOD" + "='" + endCmpPeriod.getId().toString() + "'";
        int fromIndex = sql.indexOf("FROM ");
        String fromSubSql = sql.substring(fromIndex);
        String language = ctx.getLocale().getLanguage();
        sql = " select DISTINCT \"PERSON\".FID  \"FPERSONID\", \"ATTACHDEPT\".FName_" + language + " \"FPER005\" " + fromSubSql;
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql.toString());
        sql = PersonInfoUtils.getOptimizeSql(sql);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        String personId = "";
        while (row.next()) {
            personId = row.getString("FPersonID");
            personDeptMap.put(personId, row.getString("FPER005"));
        }
        return personDeptMap;
    }

    private CmpPeriodInfo getRealEndLastPeriod(Context ctx, TaxHistoryQueryUtilParam queryParam, CmpPeriodInfo cmpSchemePeriod) throws EASBizException, BOSException {
        CmpSchemeInfo cmpSchemeInfo = (CmpSchemeInfo)queryParam.getCmpSchInfos();
        int time = cmpSchemeInfo.getTime();
        CmpPeriodInfo startCmpPeriod = queryParam.getStartPeriodInfo();
        CmpPeriodInfo endCmpPeriod = queryParam.getEndPeriodInfo();
        int compareStartPeriod = cmpSchemePeriod.getBeginDate().compareTo(startCmpPeriod.getBeginDate());
        if (compareStartPeriod < 0) {
            return null;
        }
        if (compareStartPeriod == 0 && time == 1) {
            return null;
        }
        if (compareStartPeriod == 0) {
            return cmpSchemePeriod;
        }
        int periodNum = HRUtils.getCmpPeriodNumByDateServer(startCmpPeriod, endCmpPeriod, ctx);
        String peridIdStr = cmpSchemePeriod.getId().toString();
        int compareEndPeriod = cmpSchemePeriod.getBeginDate().compareTo(endCmpPeriod.getBeginDate());
        if (compareEndPeriod < 0 && time == 1) {
            endCmpPeriod = null;
            if (periodNum < 0) {
                return null;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodNum", periodNum);
            params.put("startCmpPeriod", startCmpPeriod);
            params.put("peridIdStr", peridIdStr);
            endCmpPeriod = this._getRealEndLastPeriod(ctx, params);
        } else if (compareEndPeriod < 0) {
            endCmpPeriod = cmpSchemePeriod;
        }
        return endCmpPeriod;
    }

    @Override
    protected Map _getgetTaxHistoryTableAndPersonDept(Context ctx, Map params) throws BOSException {
        Object rs = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("personDeptMap", rs);
        return result;
    }

    protected CmpPeriodInfo _getRealEndLastPeriod(Context ctx, Map params) throws BOSException {
        int periodNum = (Integer)params.get("periodNum");
        CmpPeriodInfo startCmpPeriod = (CmpPeriodInfo)params.get("startCmpPeriod");
        String peridIdStr = (String)params.get("peridIdStr");
        CmpPeriodInfo temNextCmpPeriod = null;
        CmpPeriodInfo endCmpPeriod = null;
        ICmpPeriod iCmpPeriod = null;
        iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        for (int i = 0; i < periodNum; ++i) {
            try {
                temNextCmpPeriod = iCmpPeriod.getNextCmpPeriod((IObjectPK)new ObjectUuidPK(startCmpPeriod.getId()));
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
            if (temNextCmpPeriod == null) {
                return null;
            }
            if (peridIdStr.equals(temNextCmpPeriod.getId().toString())) {
                endCmpPeriod = startCmpPeriod;
                break;
            }
            startCmpPeriod = temNextCmpPeriod;
        }
        return endCmpPeriod;
    }

    @Override
    protected Map _checkPeriodEndInputAudit(Context ctx, String schemeID, String periodId, int time, List empIdList) throws BOSException, EASBizException {
        HashMap<String, Integer> personCountMap = new HashMap<String, Integer>();
        StringBuffer checkHistorySql = new StringBuffer();
        checkHistorySql.append("select fCmpPeriod,fTime from t_hr_cmpscheme where fid='").append(schemeID).append("'");
        IRowSet schemeRow = DbUtil.executeQuery((Context)ctx, (String)checkHistorySql.toString());
        String curPeriod = null;
        int curTime = 0;
        try {
            while (schemeRow.next()) {
                curPeriod = schemeRow.getString(1);
                curTime = schemeRow.getInt(2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!curPeriod.equals(periodId)) {
            StringBuffer checkHisPeriodSql = new StringBuffer();
            checkHisPeriodSql.append("select fid from T_HR_CmpPeriod where fid in ('").append(periodId).append("','").append(curPeriod).append("') order by FBeginDate");
            IRowSet periodRow = DbUtil.executeQuery((Context)ctx, (String)checkHisPeriodSql.toString());
            String earlyPeriod = null;
            try {
                if (periodRow.next()) {
                    earlyPeriod = periodRow.getString(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (periodId.equals(earlyPeriod)) {
                personCountMap.put("auditPersonCount", Integer.valueOf("0"));
                personCountMap.put("unAuditPersonCount", Integer.valueOf("0"));
                personCountMap.put("isCloseCmpScheme", Integer.valueOf("1"));
                return personCountMap;
            }
        } else if (curPeriod.equals(periodId) && curTime > time) {
            personCountMap.put("auditPersonCount", Integer.valueOf("0"));
            personCountMap.put("unAuditPersonCount", Integer.valueOf("0"));
            personCountMap.put("isCloseCmpScheme", Integer.valueOf("1"));
            return personCountMap;
        }
        StringBuffer auditCountSql = new StringBuffer();
        auditCountSql.append("select count(*) as personCount from T_HR_PEndInStatus eStatus ").append(" where eStatus.fCmpSchemeID='").append(schemeID).append("'").append(" and eStatus.FCmpPeriodID='").append(periodId).append("'").append(" and eStatus.fTime=").append("" + time).append(" and eStatus.fEmpAuditFlag=1 ");
        String personTable = null;
        if (empIdList != null && empIdList.size() > 0) {
            if (empIdList.size() > 100) {
                try {
                    personTable = this.getPersonIdTmpTable(ctx, empIdList);
                    auditCountSql.append(" and eStatus.FPersonID in ").append(" (select FPersonID from ").append(personTable).append(")");
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            } else {
                String idStrs = HRSchemeUtils.getStrFromList(empIdList);
                auditCountSql.append(" and FPersonID in ").append(idStrs);
            }
            IRowSet schmRows = DbUtil.executeQuery((Context)ctx, (String)auditCountSql.toString());
            try {
                while (schmRows.next()) {
                    personCountMap.put("auditPersonCount", schmRows.getInt(1));
                    personCountMap.put("unAuditPersonCount", empIdList.size() - schmRows.getInt(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (!StringUtils.isEmpty((String)personTable)) {
                    this.realeasTmpTable(ctx, personTable);
                }
            }
        }
        String horTableName = HRSchemeUtils.getCmpSchemeHorTableName(ctx, schemeID);
        auditCountSql.append(" and eStatus.FPersonID in ").append(" (select FPersonID from ").append(horTableName).append(")");
        IRowSet schmRows = DbUtil.executeQuery((Context)ctx, (String)auditCountSql.toString());
        int auditPersonCount = 0;
        IRowSet allRows = DbUtil.executeQuery((Context)ctx, (String)("select count(FPersonID) from " + horTableName));
        try {
            while (schmRows.next()) {
                auditPersonCount = schmRows.getInt(1);
                personCountMap.put("auditPersonCount", auditPersonCount);
            }
            while (allRows.next()) {
                personCountMap.put("unAuditPersonCount", allRows.getInt(1) - auditPersonCount);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)personTable)) {
                this.realeasTmpTable(ctx, personTable);
            }
        }
        personCountMap.put("isCloseCmpScheme", Integer.valueOf("0"));
        return personCountMap;
    }

    private String getPersonIdTmpTable(Context ctx, List empIdList) throws BOSException, SQLException {
        String sql = " create TABLE aa (FPersonid varchar(44) not null primary key) ";
        String hrSelectPersonTempTable = null;
        try {
            hrSelectPersonTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        int psAddCount = 0;
        Connection conn = EJBFactory.getConnection((Context)ctx);
        PreparedStatement psAdd = null;
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(hrSelectPersonTempTable).append("(FPersonID)").append(" values (?)");
        psAdd = conn.prepareStatement(insertSql.toString());
        HashSet set = new HashSet();
        int size = empIdList.size();
        for (int i = 0; i < size; ++i) {
            set.add(empIdList.get(i));
        }
        Iterator ite = set.iterator();
        String str = null;
        while (ite.hasNext()) {
            str = (String)ite.next();
            if (str == null) continue;
            psAdd.setString(1, str);
            psAdd.addBatch();
            if (++psAddCount != 1000) continue;
            psAddCount = 0;
            psAdd.executeBatch();
            psAdd.clearBatch();
        }
        if (psAddCount > 0) {
            psAdd.executeBatch();
            psAdd.clearBatch();
        }
        SQLUtils.cleanup((Statement)psAdd, (Connection)conn);
        return hrSelectPersonTempTable;
    }

    private void realeasTmpTable(Context ctx, String tableName) throws BOSException {
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    @Override
    protected IRowSet _getTaxHistoryRS(Context ctx, Map params) throws BOSException {
        String cmpSchemeId = (String)params.get("cmpSchemeId");
        EntityViewInfo customEV = (EntityViewInfo)params.get("customEV");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("cmpPeriod.*"));
        String tableName = null;
        try {
            tableName = this.getTaxHistoryTableName(ctx, cmpSchemeId);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        TaxHistoryQueryUtilParam queryParam = (TaxHistoryQueryUtilParam)params.get("queryParam");
        String sql = HRSchemeUtils.getCmpDynamicTableSql(ctx, tableName, customEV);
        int index = sql.indexOf("ORDER");
        if (index > -1) {
            sql = sql.substring(0, index);
        }
        int fromIndex = sql.indexOf("FROM ");
        int whereIndex = sql.indexOf("WHERE ");
        String fromSubSql = sql.substring(fromIndex, whereIndex);
        String whereSubSql = sql.substring(whereIndex);
        String language = ctx.getLocale().getLanguage();
        StringBuffer selectStr = new StringBuffer();
        selectStr.append("select \"PERSON\".FID  \"FPERSONID\",").append("\"PERSON\".FNumber  \"FPER002\",").append("\"PERSON\".FName_").append(language).append(" \"FPER001\",").append("\"ATTACHDEPT\".FName_").append(language).append(" \"FPER005\",").append("\"PERSON\".FGender  \"FPER010\",").append("\"PERSON\".FIDCardNO  \"FPER023\",").append("\"PERSON\".FBirthday  \"FPER059\",").append("\"PERSON\".FPassportNO  \"passportNO\",").append("tax.fname_").append(language).append(" taxScheme,").append(" period.fnumber,period.fname_").append(language).append(",").append(tableName).append(".fperiod periodID,").append(" period.FBeginDate, ").append(tableName).append(".FSAL029, ").append(tableName).append(".FSAL007,").append(tableName).append(".FSAL027 ");
        selectStr.append(fromSubSql).append(" left outer join t_hr_taxscheme tax on tax.fid = \"PersonCmp\".FCmpTaxSchemeID ").append(" left outer join t_hr_cmpperiod period on period.fid = ").append(tableName).append(".fperiod ").append(whereSubSql);
        Date startDate = queryParam.getStartPeriodInfo().getBeginDate();
        Date endDate = queryParam.getEndPeriodInfo().getEndDate();
        selectStr.append(" and period.fbegindate >= {ts'" + startDate + "'} ").append(" and period.fenddate <= {ts'" + endDate + "'}").append(" order by \"PERSON\".FNumber,period.FBeginDate");
        sql = HRSchemeUtils.getReplaceQuerySQL(ctx, selectStr.toString());
        sql = PersonInfoUtils.getOptimizeSql(sql);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        return row;
    }
}

