/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.ColCmpSchemeTableInfo;
import com.kingdee.eas.hr.compensation.CommonPermissionFacadeFactory;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.app.AbstractCmpQueryFacadeControllerBean;
import com.kingdee.eas.hr.compensation.util.HRCommonQueryUtils;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class CmpQueryFacadeControllerBean
extends AbstractCmpQueryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.CmpQueryFacadeControllerBean");

    @Override
    protected List _getPersonDataKeys(Context ctx, String strSchemeId, IObjectCollection colPeriods, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        SelectorItemCollection cmpSchemeSelector = new SelectorItemCollection();
        cmpSchemeSelector.add(new SelectorItemInfo("id"));
        cmpSchemeSelector.add(new SelectorItemInfo("horTableName"));
        cmpSchemeSelector.add(new SelectorItemInfo("hisTableName"));
        CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strSchemeId), cmpSchemeSelector);
        String hisTable = cmpSchemeInfo.getHisTableName();
        String horTable = cmpSchemeInfo.getHorTableName();
        CmpPeriodCollection cmpPeriodColl = (CmpPeriodCollection)colPeriods;
        String sqlWhere = HRCommonQueryUtils.getQueryWhereSqlByFilter(ctx, "com.kingdee.eas.hr.compensation.app.PersonInfoForCmpQueryQuery", entityViewInfo);
        StringBuffer temp1 = new StringBuffer("");
        temp1.append("FPERIOD");
        temp1.append(" in (");
        if (colPeriods != null && colPeriods.size() > 0) {
            int size = cmpPeriodColl.size();
            for (int i = 0; i < size; ++i) {
                CmpPeriodInfo infoCmpPeriod = cmpPeriodColl.get(i);
                if (i > 0) {
                    temp1.append(", ");
                }
                temp1.append("'");
                temp1.append(infoCmpPeriod.getId().toString());
                temp1.append("'");
            }
        }
        temp1.append(" )");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select a.*   from (");
        if (horTable != null) {
            sbSql.append(" select fpersonid,fadminorgunitid,fpositionid from ");
            sbSql.append(horTable);
            sbSql.append(" where " + temp1.toString());
            if (hisTable != null) {
                sbSql.append(" union ");
                sbSql.append(" select fpersonid,fadminorgunitid,fpositionid from ");
                sbSql.append(hisTable);
                sbSql.append(" where " + temp1.toString());
            }
        }
        sbSql.append(" ) a ");
        sbSql.append(" LEFT JOIN T_PM_OrgRange ATTACHORGRANGE ON a.FAdminOrgUnitID = ATTACHORGRANGE.FOrgID");
        sbSql.append(" LEFT JOIN T_PM_User ATTACHPMUSER ON ATTACHORGRANGE.FUserID = ATTACHPMUSER.FID ");
        sbSql.append(" inner join T_BD_Person PERSON on person.fid = a.fpersonid");
        sbSql.append(" inner JOIN T_HR_PersonCmp PERSONCMP ON PERSON.FID = PERSONCMP.FPersonID");
        sbSql.append(" inner JOIN T_HR_PersonPosition  PERSONPOSITION ON PERSON.FID = PERSONPOSITION.FPersonID");
        sbSql.append(" LEFT JOIN T_HR_JobGrade  JOBGRADE ON PERSONPOSITION.FJobGrade = JOBGRADE.FID");
        sbSql.append(" LEFT JOIN T_BD_HRDiploma  DIPLOMA ON PERSON.FHighestDegreeID = DIPLOMA.FID");
        sbSql.append(" left JOIN T_ORG_Admin  ATTACHDEPT ON a.FAdminOrgUnitID = ATTACHDEPT.FID");
        sbSql.append(" left JOIN T_ORG_Position  POSITION ON a.FPositionID = POSITION.FID ");
        sbSql.append(" LEFT OUTER JOIN T_HR_EmployeeClassify AS EMPLOYEECLASSIFY ON PERSON.FEmployeeClassifyID = EMPLOYEECLASSIFY.FID ");
        sbSql.append(" LEFT OUTER JOIN T_HR_BDEmployeeType AS ET ON PERSON.FEmployeeTypeID = ET.FID ");
        sbSql.append(" LEFT OUTER JOIN T_HR_EmployeeFenLei AS EMPLOYEEFENLEI ON ET.FEmployeeFenLeiID = EMPLOYEEFENLEI.FID ");
        if (sqlWhere != null) {
            sbSql.append(" where " + sqlWhere + " and ");
        } else {
            sbSql.append(" where ");
        }
        sbSql.append(" ATTACHORGRANGE.FType = 20 and ATTACHORGRANGE.FUserID = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' ");
        sbSql.append(" order by a.fpersonid,a.fadminorgunitid,a.fpositionid");
        if (entityViewInfo.getSorter() == null || entityViewInfo.getSorter().size() == 0) {
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterOrderItem = new SorterItemInfo("indexOf");
            sorterOrderItem.setSortType(SortType.ASCEND);
            sorter.add(sorterOrderItem);
            entityViewInfo.setSorter(sorter);
        }
        String strFinallySql = HRReportUtils.addOrderBySQL(ctx, sbSql.toString(), entityViewInfo.getSorter(), "com.kingdee.eas.hr.compensation.app.PersonInfoForCmpQueryQuery", false);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strFinallySql);
        ArrayList<String> lsKeys = new ArrayList<String>();
        try {
            while (rs.next()) {
                lsKeys.add(rs.getString("fpersonid") + "~" + rs.getString("fadminorgunitid") + "~" + rs.getString("fpositionid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return lsKeys;
    }

    @Override
    protected List _getPersonDataByKeys(Context ctx, List lstPersonKeys, IObjectCollection colPeriods, EntityViewInfo entityViewInfo, String strSchemeId) throws BOSException, EASBizException {
        ArrayList<ColCmpSchemeTableInfo> lstData = new ArrayList<ColCmpSchemeTableInfo>();
        if (StringUtils.isEmpty((String)strSchemeId) || colPeriods == null || colPeriods.size() <= 0) {
            return lstData;
        }
        String tempPersonTable = this.getUnionSqlTableName(ctx, colPeriods, strSchemeId, lstPersonKeys);
        String sqlWhere = HRCommonQueryUtils.getQueryWhereSqlByFilter(ctx, "com.kingdee.eas.hr.compensation.app.PersonInfoForCmpQueryQuery", entityViewInfo);
        String language = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT PERSON.FID AS FPERSONID,PERSON.FNumber AS FPER002,");
        sql.append(" PERSON.FName_").append(language).append(" AS FPER001,tempPerson.FAdminOrgUnitID AS ATTACHDEPTID,");
        sql.append(" ATTACHDEPT.FName_").append(language).append(" AS FPER005,tempPerson.FPositionID AS POSITIONID,");
        sql.append(" POSITION.FName_").append(language).append(" AS FPER006,PERSONCMP.FIsPayPerson AS ISPAYPERSON,");
        sql.append(" PERSON.FIDCardNO AS FPER023,DIPLOMA.FName_").append(language).append(" AS FPER021,PERSONPOSITION.FHighestDegreeDate AS HIGHESTDEGREEDATE,");
        sql.append(" PERSONPOSITION.FjobStartDate AS JOBSTARTDATE,PERSONPOSITION.FEnterDate AS FPER024,");
        sql.append(" JOBGRADE.FName_").append(language).append(" AS FPER017,PERSONPOSITION.FJobGradeEndDate AS JOBGRADEENDDATE,");
        sql.append(" PERSONCMP.FLastAdjustSalDate AS FPER036");
        sql.append(" FROM " + tempPersonTable + " AS tempPerson");
        sql.append(" inner join T_BD_Person AS PERSON on person.fid = tempPerson.fpersonid");
        sql.append(" inner JOIN T_HR_PersonCmp AS PERSONCMP ON PERSON.FID = PERSONCMP.FPersonID");
        sql.append(" inner JOIN T_HR_PersonPosition AS PERSONPOSITION ON PERSON.FID = PERSONPOSITION.FPersonID");
        sql.append(" LEFT JOIN T_HR_JobGrade AS JOBGRADE ON PERSONPOSITION.FJobGrade = JOBGRADE.FID");
        sql.append(" LEFT JOIN T_BD_HRDiploma AS DIPLOMA ON PERSON.FHighestDegreeID = DIPLOMA.FID");
        sql.append(" left JOIN T_ORG_Admin AS ATTACHDEPT ON tempPerson.FAdminOrgUnitID = ATTACHDEPT.FID");
        sql.append(" left JOIN T_ORG_Position AS POSITION ON tempPerson.FPositionID = POSITION.FID ");
        sql.append(" LEFT OUTER JOIN T_HR_EmployeeClassify AS EMPLOYEECLASSIFY ON PERSON.FEmployeeClassifyID = EMPLOYEECLASSIFY.FID ");
        sql.append(" LEFT OUTER JOIN T_HR_BDEmployeeType AS ET ON PERSON.FEmployeeTypeID = ET.FID ");
        sql.append(" LEFT OUTER JOIN T_HR_EmployeeFenLei AS EMPLOYEEFENLEI ON ET.FEmployeeFenLeiID = EMPLOYEEFENLEI.FID ");
        if (sqlWhere != null) {
            sql.append(" where " + sqlWhere);
        }
        sql.append(" order by PERSON.FNumber");
        if (entityViewInfo.getSorter() == null || entityViewInfo.getSorter().size() == 0) {
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterOrderItem = new SorterItemInfo("indexOf");
            sorterOrderItem.setSortType(SortType.ASCEND);
            sorter.add(sorterOrderItem);
            entityViewInfo.setSorter(sorter);
        }
        String strFinallySql = HRReportUtils.addOrderBySQL(ctx, sql.toString(), entityViewInfo.getSorter(), "com.kingdee.eas.hr.compensation.app.PersonInfoForCmpQueryQuery", false);
        IRowSet rs = HRUtils.executeQuery(ctx, strFinallySql);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tempPersonTable);
        if (rs == null || rs.size() <= 0) {
            return lstData;
        }
        String personID = null;
        String adminID = null;
        String positionID = null;
        ColCmpSchemeTableInfo info = null;
        ColCmpSchemeTableInfo.PersonFixedInfo infoFixedPerson = null;
        try {
            while (rs.next()) {
                info = new ColCmpSchemeTableInfo();
                personID = rs.getString("FPersonID");
                adminID = rs.getString("attachDeptid");
                positionID = rs.getString("positionid");
                info.setPersonID(personID);
                infoFixedPerson = new ColCmpSchemeTableInfo.PersonFixedInfo();
                infoFixedPerson.setNumber(rs.getString("FPER002"));
                infoFixedPerson.setName(rs.getString("FPER001"));
                infoFixedPerson.setDepartment(rs.getString("FPER005"));
                infoFixedPerson.setPosition(rs.getString("FPER006"));
                infoFixedPerson.setAdminId(adminID);
                infoFixedPerson.setPositionId(positionID);
                infoFixedPerson.setIdCardNO(rs.getString("FPER023"));
                infoFixedPerson.setDiploma(rs.getString("FPER021"));
                infoFixedPerson.setHighestDegreeDate(rs.getDate("highestDegreeDate"));
                infoFixedPerson.setJobStartDate(rs.getDate("jobStartDate"));
                infoFixedPerson.setEnterDate(rs.getDate("FPER024"));
                infoFixedPerson.setJobGrade(rs.getString("FPER017"));
                infoFixedPerson.setJobGradeEndDate(rs.getDate("jobGradeEndDate"));
                infoFixedPerson.setLastAdjustSalDate(rs.getDate("FPER036"));
                info.setInfoFixedPerson(infoFixedPerson);
                lstData.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return lstData;
    }

    @Override
    protected List _getPersonData(Context ctx, String strCmpScheme, String strColCmpScheme, EntityViewInfo infoEntityView, IObjectCollection cmpPeriods) throws BOSException, EASBizException {
        ArrayList<ColCmpSchemeTableInfo> lstData = new ArrayList<ColCmpSchemeTableInfo>();
        if (StringUtils.isEmpty((String)strCmpScheme) || cmpPeriods == null || cmpPeriods.size() <= 0) {
            return lstData;
        }
        String sql = null;
        String tempPersonTable = this.getUnionSqlTableName(ctx, cmpPeriods, strCmpScheme, null);
        sql = this.getCmpQuerySql(ctx, tempPersonTable, infoEntityView);
        if (StringUtils.isEmpty((String)(sql = PersonInfoUtils.getOptimizeSql(sql)))) {
            return lstData;
        }
        IRowSet rs = HRUtils.executeQuery(ctx, sql);
        if (rs == null || rs.size() <= 0) {
            return lstData;
        }
        String personID = null;
        String adminID = null;
        String positionID = null;
        ColCmpSchemeTableInfo info = null;
        ColCmpSchemeTableInfo.PersonFixedInfo infoFixedPerson = null;
        try {
            while (rs.next()) {
                info = new ColCmpSchemeTableInfo();
                personID = rs.getString("FPersonID");
                adminID = rs.getString("attachDept.id");
                positionID = rs.getString("position.id");
                info.setPersonID(personID);
                infoFixedPerson = new ColCmpSchemeTableInfo.PersonFixedInfo();
                infoFixedPerson.setNumber(rs.getString("FPER002"));
                infoFixedPerson.setName(rs.getString("FPER001"));
                infoFixedPerson.setDepartment(rs.getString("FPER005"));
                infoFixedPerson.setPosition(rs.getString("FPER006"));
                infoFixedPerson.setAdminId(adminID);
                infoFixedPerson.setPositionId(positionID);
                infoFixedPerson.setIdCardNO(rs.getString("FPER023"));
                infoFixedPerson.setDiploma(rs.getString("FPER021"));
                infoFixedPerson.setHighestDegreeDate(rs.getDate("highestDegreeDate"));
                infoFixedPerson.setJobStartDate(rs.getDate("jobStartDate"));
                infoFixedPerson.setEnterDate(rs.getDate("FPER024"));
                infoFixedPerson.setJobGrade(rs.getString("FPER017"));
                infoFixedPerson.setJobGradeEndDate(rs.getDate("jobGradeEndDate"));
                infoFixedPerson.setLastAdjustSalDate(rs.getDate("FPER036"));
                info.setInfoFixedPerson(infoFixedPerson);
                lstData.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return lstData;
    }

    private String getCmpQuerySql(Context ctx, String tableName, EntityViewInfo view) throws BOSException {
        IQueryExecutor exec;
        String sql = "";
        MetaDataPK metaDataPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.PersonInfoForCmpQueryQuery");
        if (ctx == null) {
            exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metaDataPK);
            if (view != null && view.getSorter() != null && view.getSorter().size() > 0) {
                exec.option().isIgnoreOrder = true;
            }
            exec.setObjectView(view);
            sql = exec.getSQL();
            sql = HRSchemeUtils.getReplaceQuerySQL(null, sql.toString());
        } else {
            exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
            if (view != null && view.getSorter() != null && view.getSorter().size() > 0) {
                exec.option().isIgnoreOrder = true;
            }
            exec.setObjectView(view);
            sql = exec.getSQL();
            sql = HRSchemeUtils.getReplaceQuerySQL(ctx, sql.toString());
        }
        if (tableName != null) {
            sql = StringUtils.replaceIgnoreCase((String)sql, (String)"T_HR_CMPSCHEMEPERSON".toLowerCase(), (String)tableName);
        }
        while (sql.indexOf("\"CMPSCHEMEPERSON\"") > -1) {
            if (tableName != null) {
                sql = StringUtils.replaceIgnoreCase((String)sql, (String)"\"CMPSCHEMEPERSON\"".toLowerCase(), (String)tableName);
                continue;
            }
            return sql;
        }
        return sql;
    }

    @Override
    protected Hashtable _getCmpItemByPerson(Context ctx, String perssonId, String depId, String positionId, String strCmpScheme, IObjectCollection cmpPeriods) throws BOSException, EASBizException {
        Hashtable<CmpItemInfo, Hashtable> hstCmpItemData = new Hashtable<CmpItemInfo, Hashtable>();
        if (StringUtils.isEmpty((String)strCmpScheme)) {
            return hstCmpItemData;
        }
        ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
        SelectorItemCollection cmpSchemeSelector = new SelectorItemCollection();
        cmpSchemeSelector.add(new SelectorItemInfo("id"));
        cmpSchemeSelector.add(new SelectorItemInfo("name"));
        cmpSchemeSelector.add(new SelectorItemInfo("horTableName"));
        cmpSchemeSelector.add(new SelectorItemInfo("hisTableName"));
        CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strCmpScheme), cmpSchemeSelector);
        List lstCmpItem = null;
        String periodID = null;
        int time = 1;
        try {
            lstCmpItem = this.getCmpItem(ctx, strCmpScheme);
            IRowSet rsScheme = this.getRowSetHashtable(ctx, strCmpScheme, cmpPeriods, perssonId, depId, positionId);
            while (rsScheme.next()) {
                periodID = rsScheme.getString("FPERIOD");
                time = rsScheme.getInt("ftime");
                int size = lstCmpItem.size();
                for (int i = 0; i < size; ++i) {
                    BigDecimal objResult;
                    CmpItemInfo infoCmpItem = (CmpItemInfo)lstCmpItem.get(i);
                    Hashtable hstTemp = null;
                    hstTemp = hstCmpItemData.get(infoCmpItem) != null ? (Hashtable)hstCmpItemData.get(infoCmpItem) : new Hashtable();
                    if (infoCmpItem.isCol()) {
                        objResult = rsScheme.getBigDecimal(infoCmpItem.getNumber());
                        hstTemp = this.getCalculateHashtable(hstTemp, objResult, periodID, time, infoCmpScheme);
                        hstCmpItemData.put(infoCmpItem, hstTemp);
                        continue;
                    }
                    if (!infoCmpItem.getCmpSchemeName().equalsIgnoreCase(infoCmpScheme.getName())) continue;
                    objResult = rsScheme.getBigDecimal(infoCmpItem.getNumber());
                    hstTemp = this.getCalculateHashtable(hstTemp, objResult, periodID, time, infoCmpScheme);
                    hstCmpItemData.put(infoCmpItem, hstTemp);
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        return hstCmpItemData;
    }

    private Hashtable getCalculateHashtable(Hashtable hstTemp, Object objResult, String periodID, int time, CmpSchemeInfo infoCmpScheme) {
        String key = periodID + "&" + time;
        if (objResult == null) {
            return hstTemp;
        }
        Hashtable hst = null;
        if (hstTemp.get(key) != null) {
            hst = (Hashtable)hstTemp.get(key);
        } else {
            hst = new Hashtable();
            hstTemp.put(key, hst);
        }
        hst.put(infoCmpScheme, objResult);
        return hstTemp;
    }

    private List getCmpItem(Context ctx, String strCmpScheme) throws BOSException, EASBizException, SQLException {
        ArrayList<CmpItemInfo> lstCmpItem = new ArrayList<CmpItemInfo>();
        CmpItemInfo temp = null;
        if (strCmpScheme != null) {
            CmpSchemeItemCollection col;
            ICmpSchemeItem iCmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
            String hrUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            HashSet<String> hroSet = new HashSet<String>();
            hroSet.add(hrUnitID);
            EntityViewInfo view = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            CmpItemCollection cmpcols = null;
            StringBuffer cmpItemids = null;
            if (view.toString().indexOf("hrOrgUnit.id") != -1 && view.getFilter().getFilterItems().size() > 1) {
                cmpcols = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(view);
                cmpItemids = new StringBuffer();
                int size = cmpcols.size();
                for (int i = 0; i < size; ++i) {
                    cmpItemids.append("'");
                    cmpItemids.append(cmpcols.get(i).getId().toString());
                    cmpItemids.append("',");
                }
                if (cmpItemids.lastIndexOf(",") != -1) {
                    cmpItemids.deleteCharAt(cmpItemids.length() - 1).toString();
                }
            }
            if ((col = cmpItemids != null && cmpItemids.length() > 0 ? iCmpSchemeItem.getCmpSchemeItemCollection("select id,cmpscheme.name ,cmpitem.name,cmpitem.number,cmpitem.datatype,cmpitem.decDigital where cmpitem.datatype = 60 and cmpitem.number not like 'FPER%' and cmpscheme.id='" + strCmpScheme + "' and cmpItem.id in (" + cmpItemids + ") order by sortOrder ") : iCmpSchemeItem.getCmpSchemeItemCollection("select id,cmpscheme.name ,cmpitem.name,cmpitem.number,cmpitem.datatype,cmpitem.decDigital where cmpitem.datatype = 60 and cmpitem.number not like 'FPER%' and cmpscheme.id='" + strCmpScheme + "' order by sortOrder ")) != null && col.size() > 0) {
                String name = col.get(0).getCmpScheme().getName();
                CmpItemInfo info = null;
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    info = col.get(i).getCmpItem();
                    temp = new CmpItemInfo();
                    temp.setCmpSchemeName(name);
                    temp.setName(info.getName());
                    temp.setNumber(info.getNumber());
                    temp.setDataType(info.getDataType());
                    temp.setDecDigital(info.getDecDigital());
                    temp.setDefaultOrder(i);
                    lstCmpItem.add(temp);
                }
            }
        }
        return lstCmpItem;
    }

    private IRowSet getRowSetHashtable(Context ctx, String strCmpScheme, IObjectCollection colCmpPeriod, String perssonId, String depId, String positionId) throws BOSException, EASBizException {
        String tableName = "T";
        StringBuffer sbCondition = new StringBuffer(" WHERE ");
        sbCondition.append(tableName);
        sbCondition.append(".FPERIOD IN(");
        int size = colCmpPeriod.size();
        for (int i = 0; i < size; ++i) {
            CmpPeriodInfo info = (CmpPeriodInfo)colCmpPeriod.getObject(i);
            sbCondition.append("'");
            sbCondition.append(info.getId().toString());
            sbCondition.append("',");
        }
        sbCondition.deleteCharAt(sbCondition.length() - 1);
        sbCondition.append(") ");
        if (strCmpScheme != null) {
            ICmpScheme iCmpScheme = CmpSchemeFactory.getLocalInstance(ctx);
            SelectorItemCollection cmpSchemeSelector = new SelectorItemCollection();
            cmpSchemeSelector.add(new SelectorItemInfo("id"));
            cmpSchemeSelector.add(new SelectorItemInfo("name"));
            cmpSchemeSelector.add(new SelectorItemInfo("horTableName"));
            cmpSchemeSelector.add(new SelectorItemInfo("hisTableName"));
            CmpSchemeInfo infoCmpScheme = iCmpScheme.getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strCmpScheme), cmpSchemeSelector);
            String sql = this.getSchemeSQL(ctx, infoCmpScheme, sbCondition, tableName, perssonId, depId, positionId);
            return DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        return null;
    }

    private String getSchemeSQL(Context ctx, CmpSchemeInfo info, StringBuffer sbCondition, String tableName, String perssonId, String depId, String positionId) throws BOSException {
        StringBuffer sbSql = new StringBuffer("");
        String horTable = info.getHorTableName();
        String hisTable = info.getHisTableName();
        if (horTable == null && hisTable == null) {
            return null;
        }
        StringBuffer sqlGetColumns = new StringBuffer();
        StringBuffer columns = new StringBuffer();
        sqlGetColumns.append("select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME = '");
        sqlGetColumns.append(horTable);
        sqlGetColumns.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlGetColumns.toString());
        boolean isFirst = true;
        try {
            while (rs.next()) {
                if (!isFirst) {
                    columns.append(",");
                } else {
                    isFirst = false;
                }
                columns.append(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        sbSql.append(" SELECT ");
        sbSql.append(tableName);
        sbSql.append(".* FROM (SELECT ");
        sbSql.append(columns.toString());
        sbSql.append(" FROM ");
        sbSql.append(horTable);
        sbSql.append(" where fpositionid");
        if (positionId == null) {
            sbSql.append(" is null ");
        } else {
            sbSql.append(" = '");
            sbSql.append(positionId);
            sbSql.append("'");
        }
        sbSql.append(" and fadminorgunitid");
        if (depId == null) {
            sbSql.append(" is null ");
        } else {
            sbSql.append(" = '");
            sbSql.append(depId);
            sbSql.append("'");
        }
        sbSql.append(" and FPersonid = '");
        sbSql.append(perssonId);
        sbSql.append("'");
        if (hisTable != null) {
            sbSql.append(" UNION ALL SELECT ");
            sbSql.append(columns.toString());
            sbSql.append(" FROM ");
            sbSql.append(hisTable);
            sbSql.append(" where fpositionid");
            if (positionId == null) {
                sbSql.append(" is null ");
            } else {
                sbSql.append(" = '");
                sbSql.append(positionId);
                sbSql.append("'");
            }
            sbSql.append(" and fadminorgunitid");
            if (depId == null) {
                sbSql.append(" is null ");
            } else {
                sbSql.append(" = '");
                sbSql.append(depId);
                sbSql.append("'");
            }
            sbSql.append(" and FPersonid = '");
            sbSql.append(perssonId);
            sbSql.append("'");
        }
        sbSql.append(" ) AS ");
        sbSql.append(tableName);
        sbSql.append(sbCondition);
        return sbSql.toString();
    }

    private String getUnionPersonByKeySql(Context ctx, IObjectCollection colCmpPeriod, List lstPersonKeys, String strSchemeId) throws EASBizException, BOSException {
        SelectorItemCollection cmpSchemeSelector = new SelectorItemCollection();
        cmpSchemeSelector.add(new SelectorItemInfo("id"));
        cmpSchemeSelector.add(new SelectorItemInfo("horTableName"));
        cmpSchemeSelector.add(new SelectorItemInfo("hisTableName"));
        CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strSchemeId), cmpSchemeSelector);
        String hisTable = cmpSchemeInfo.getHisTableName();
        String horTable = cmpSchemeInfo.getHorTableName();
        CmpPeriodCollection cmpPeriodColl = (CmpPeriodCollection)colCmpPeriod;
        StringBuffer temp1 = new StringBuffer("");
        temp1.append("FPERIOD");
        temp1.append(" in (");
        if (colCmpPeriod != null && colCmpPeriod.size() > 0) {
            int size = cmpPeriodColl.size();
            for (int i = 0; i < size; ++i) {
                CmpPeriodInfo infoCmpPeriod = cmpPeriodColl.get(i);
                if (i > 0) {
                    temp1.append(", ");
                }
                temp1.append("'");
                temp1.append(infoCmpPeriod.getId().toString());
                temp1.append("'");
            }
        }
        temp1.append(" )");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select a.*   from (");
        if (horTable != null) {
            sbSql.append(" select fpersonid,fadminorgunitid,fpositionid from ");
            sbSql.append(horTable);
            sbSql.append(" where " + temp1.toString());
            if (hisTable != null) {
                sbSql.append(" union ");
                sbSql.append(" select fpersonid,fadminorgunitid,fpositionid from ");
                sbSql.append(hisTable);
                sbSql.append(" where " + temp1.toString());
            }
        }
        sbSql.append(" ) a ");
        return sbSql.toString();
    }

    private String getUnionSqlTableName(Context ctx, IObjectCollection colCmpPeriod, String strCmpScheme, List lstPersonKeys) throws EASBizException, BOSException {
        String tablename;
        SelectorItemCollection cmpSchemeSelector = new SelectorItemCollection();
        cmpSchemeSelector.add(new SelectorItemInfo("id"));
        cmpSchemeSelector.add(new SelectorItemInfo("horTableName"));
        cmpSchemeSelector.add(new SelectorItemInfo("hisTableName"));
        CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(strCmpScheme), cmpSchemeSelector);
        String hisTable = cmpSchemeInfo.getHisTableName();
        String horTable = cmpSchemeInfo.getHorTableName();
        CmpPeriodCollection cmpPeriodColl = (CmpPeriodCollection)colCmpPeriod;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String sql = " create TABLE T_HR_CmpTemp1 (FPersonid varchar(44) ,fadminorgunitid varchar(44),fpositionid varchar(44)  )";
        try {
            tablename = pool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        StringBuffer temp1 = new StringBuffer("");
        temp1.append("FPERIOD");
        temp1.append(" in (");
        if (colCmpPeriod != null && colCmpPeriod.size() > 0) {
            int size = cmpPeriodColl.size();
            for (int i = 0; i < size; ++i) {
                CmpPeriodInfo infoCmpPeriod = cmpPeriodColl.get(i);
                if (i > 0) {
                    temp1.append(", ");
                }
                temp1.append("'");
                temp1.append(infoCmpPeriod.getId().toString());
                temp1.append("'");
            }
        }
        temp1.append(" )");
        StringBuffer sbSql = new StringBuffer(" insert into " + tablename);
        sbSql.append(" select a.*   from (");
        if (horTable != null) {
            sbSql.append(" select fpersonid,fadminorgunitid,fpositionid from ");
            sbSql.append(horTable);
            sbSql.append(" where " + temp1.toString());
            if (hisTable != null) {
                sbSql.append(" union ");
                sbSql.append(" select fpersonid,fadminorgunitid,fpositionid from ");
                sbSql.append(hisTable);
                sbSql.append(" where " + temp1.toString());
            }
        }
        sbSql.append(" ) a ");
        sbSql.append(" LEFT JOIN T_PM_OrgRange ATTACHORGRANGE ON a.FAdminOrgUnitID = ATTACHORGRANGE.FOrgID");
        sbSql.append(" LEFT JOIN T_PM_User ATTACHPMUSER ON ATTACHORGRANGE.FUserID = ATTACHPMUSER.FID");
        sbSql.append(" where ATTACHORGRANGE.FType = 20 and ATTACHORGRANGE.FUserID = '" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' ");
        if (lstPersonKeys != null) {
            String keyFilter = "";
            String[] strIds = null;
            int size = lstPersonKeys.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    keyFilter = keyFilter + " or ";
                }
                strIds = lstPersonKeys.get(i).toString().split("~");
                keyFilter = keyFilter + "(";
                keyFilter = !strIds[0].equals("null") ? keyFilter + " a.fpersonid='" + strIds[0] + "'" : keyFilter + " a.fpersonid is null";
                keyFilter = !strIds[1].equals("null") ? keyFilter + " and a.fadminorgunitid='" + strIds[1] + "'" : keyFilter + " and a.fadminorgunitid is null";
                keyFilter = !strIds[2].equals("null") ? keyFilter + " and a.fpositionid='" + strIds[2] + "'" : keyFilter + " and a.fpositionid is null";
                keyFilter = keyFilter + ")";
            }
            if (!keyFilter.equals("")) {
                keyFilter = " and (" + keyFilter + ")";
                sbSql.append(keyFilter);
            }
        }
        DbUtil.execute((Context)ctx, (String)sbSql.toString());
        return tablename;
    }
}

