/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.hr.compensation.AdjDataPrvdException;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ICmpScheme;
import com.kingdee.eas.hr.compensation.app.AbstractCmpSchDataPrvdFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmpSchDataPrvdFacadeControllerBean
extends AbstractCmpSchDataPrvdFacadeControllerBean {
    @Override
    protected IObjectCollection _getValidCmpSch(Context ctx) throws BOSException, EASBizException, EASDBException {
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        String oql = "select id,name,horTableName,hisTableName where enable=1 and isDelete=0";
        CmpSchemeCollection schCols = sch.getCmpSchemeCollection(oql);
        return schCols;
    }

    @Override
    protected List _getCmpSchsEmp(Context ctx, IObjectValue cmpScheme, List empIDList) throws BOSException, EASBizException, EASDBException {
        if (!(cmpScheme instanceof CmpSchemeInfo) || empIDList == null || empIDList.size() == 0) {
            return null;
        }
        CmpSchemeInfo info = (CmpSchemeInfo)cmpScheme;
        String tbName = info.getHorTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select FPERSONID FROM ");
        sql.append(tbName);
        sql.append(" WHERE ");
        int size = empIDList.size();
        for (int i = 0; i < size; ++i) {
            sql.append("FPERSONID='");
            sql.append((String)empIDList.get(i));
            sql.append("'");
            if (i == size - 1) continue;
            sql.append(" OR ");
        }
        ArrayList<String> rst = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                rst.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
        }
        return rst;
    }

    @Override
    protected Map _getEmpCompenseData(Context ctx, String schemeID, List empIDList, List cmpItemNumList) throws BOSException, EASBizException, EASDBException {
        if (schemeID == null || empIDList == null || cmpItemNumList == null) {
            return null;
        }
        SqlSelect select = new SqlSelect();
        List selectList = null;
        SqlExpr where = null;
        StringBuffer sql = new StringBuffer();
        String tableName = this.getTableName(ctx, schemeID);
        try {
            selectList = this.buildSelector(cmpItemNumList);
            where = this.buildWhere(empIDList);
            SqlTableSource tabSource = new SqlTableSource(tableName);
            select.selectList = selectList;
            select.condition = where;
            select.tableSource = tabSource;
            DrSQLFormater formater = new DrSQLFormater(sql);
            formater.formatSelect(select);
        }
        catch (ParserException e) {
            throw new AdjDataPrvdException(AdjDataPrvdException.BUILDSQL_EXEC, e);
        }
        catch (FormaterException e) {
            throw new AdjDataPrvdException(AdjDataPrvdException.BUILDSQL_EXEC, e);
        }
        HashMap rst = new HashMap();
        Connection con = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            rs = pstm.executeQuery();
            while (rs.next()) {
                HashMap<String, String> itemValue = new HashMap<String, String>();
                String empID = rs.getString("FPERSONID");
                int size = cmpItemNumList.size();
                for (int i = 0; i < size; ++i) {
                    String value = rs.getString((String)cmpItemNumList.get(i));
                    String key = cmpItemNumList.get(i) + "_OLD";
                    itemValue.put(key, value);
                }
                rst.put(empID, itemValue);
            }
        }
        catch (Exception e) {
            try {
                throw new EASDBException(EASDBException.EXEC_SQL_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstm, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)con);
        return rst;
    }

    private SqlExpr buildWhere(List empIDList) throws ParserException {
        Object whereExpr = null;
        SqlExprParser parser = null;
        int size = empIDList.size();
        for (int i = 0; i < size; ++i) {
            String empID = (String)empIDList.get(i);
            empID = "FPERSONID='" + empID + "'";
            parser = new SqlExprParser(empID);
            whereExpr = whereExpr == null ? parser.expr() : new SqlBinaryOpExpr(whereExpr, 8, parser.expr());
        }
        return whereExpr;
    }

    private String getTableName(Context ctx, String schID) throws EASBizException, BOSException {
        String oql;
        String tabName = "";
        ICmpScheme sch = CmpSchemeFactory.getLocalInstance(ctx);
        CmpSchemeInfo info = (CmpSchemeInfo)sch.getValue(oql = "select id,horTableName where id='" + schID + "'");
        if (info != null) {
            tabName = info.getHorTableName();
        }
        return tabName;
    }

    private List buildSelector(List items) throws ParserException {
        ArrayList<SqlSelectItem> selectorList = new ArrayList<SqlSelectItem>();
        SqlExprParser parser = null;
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String itemNum = (String)items.get(i);
            parser = new SqlExprParser(itemNum);
            SqlSelectItem selItem = new SqlSelectItem(parser.expr(), itemNum);
            selectorList.add(selItem);
        }
        parser = new SqlExprParser("FPERSONID");
        SqlSelectItem personID = new SqlSelectItem(parser.expr(), "FPERSONID");
        selectorList.add(0, personID);
        return selectorList;
    }
}

