/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptInnerConsultItemCollection;
import com.kingdee.eas.hr.compensation.DeptInnerConsultItemEntryCollection;
import com.kingdee.eas.hr.compensation.DeptInnerConsultItemEntryInfo;
import com.kingdee.eas.hr.compensation.DeptInnerConsultItemInfo;
import com.kingdee.eas.hr.compensation.DeptInnerSchemeInfo;
import com.kingdee.eas.hr.compensation.app.AbstractDeptInnerConsultItemControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeptInnerConsultItemControllerBean
extends AbstractDeptInnerConsultItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.DeptInnerConsultItemControllerBean");

    @Override
    protected Map _saveData(Context ctx, DeptInnerConsultItemInfo consultItemInfo) throws BOSException, EASBizException {
        DeptInnerConsultItemInfo dataValue = consultItemInfo;
        dataValue.setPeriodNum(0);
        if (dataValue.getEndTime() == 10000) {
            dataValue.setEndTime(0);
        }
        DeptInnerConsultItemEntryCollection entryColl = dataValue.getCmpItemColl();
        dataValue.setCmpItemColl(null);
        IObjectPK pk = this.submit(ctx, dataValue);
        this.saveEntry(ctx, pk, entryColl);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("DeptInnerConsultItem_pk", pk.toString());
        return resultMap;
    }

    @Override
    protected DeptInnerConsultItemInfo _getData(Context ctx, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        DeptInnerConsultItemCollection coll = this.getDeptInnerConsultItemCollection(ctx, entityViewInfo);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        DeptInnerConsultItemInfo consultItemInfo = coll.get(0);
        return consultItemInfo;
    }

    @Override
    protected Map _getItemValueMap(Context ctx, DeptInnerConsultItemInfo consultItemInfo) throws BOSException, EASBizException {
        List cmpItemList = this.getCmpItemList(consultItemInfo);
        String sql = this.getCmpItemValueStr(ctx, consultItemInfo, cmpItemList);
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        Map resultMap = null;
        try {
            resultMap = this.getCmpItemValue(ctx, sql, cmpItemList);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    protected Map _getItemValueMap(Context ctx, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        DeptInnerConsultItemInfo consultItemInfo = this._getData(ctx, entityViewInfo);
        Map resultMap = this._getItemValueMap(ctx, consultItemInfo);
        resultMap.put("Dept_ConsultItemInfo", consultItemInfo);
        return resultMap;
    }

    private List getCmpItemList(DeptInnerConsultItemInfo consultItemInfo) {
        DeptInnerConsultItemEntryCollection entryColl = consultItemInfo.getCmpItemColl();
        ArrayList<CmpItemInfo> cmpItemList = new ArrayList<CmpItemInfo>();
        DeptInnerConsultItemEntryInfo itemEntry = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            itemEntry = entryColl.get(i);
            cmpItemList.add(itemEntry.getIndex(), itemEntry.getCmpItem());
        }
        return cmpItemList;
    }

    protected List saveEntry(Context ctx, IObjectPK pk, DeptInnerConsultItemEntryCollection entryColl) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("delete from T_HR_DeptInnerConsultEntry where fdeptInnerConItem='" + pk.toString() + "'"));
        if (entryColl == null || entryColl.size() == 0) {
            return null;
        }
        DeptInnerConsultItemInfo dataValue = new DeptInnerConsultItemInfo();
        dataValue.setId(BOSUuid.read((String)pk.toString()));
        DeptInnerConsultItemEntryInfo itemEntry = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" insert into T_HR_DeptInnerConsultEntry(FID,FCMPITEMID,FDEPTINNERCONITEM,FINDEX)\n");
        sbSql.append("VALUES (? ,? ,? ,? ) \n");
        String bosType = new DeptInnerConsultItemEntryInfo().getBOSType().toString();
        for (int i = 0; i < entryColl.size(); ++i) {
            itemEntry = entryColl.get(i);
            itemEntry.setDeptInnerConItem(dataValue);
            params = new Object[]{BOSUuid.create((String)bosType).toString(), itemEntry.getCmpItem().getId().toString(), pk.toString(), itemEntry.getIndex()};
            paramList.add(params);
        }
        HrExDbUtil.executeBatch((Context)ctx, (String)sbSql.toString(), paramList);
        return null;
    }

    private String getCmpItemValueStr(Context ctx, DeptInnerConsultItemInfo dataValue, List cmpItemList) throws EASBizException, BOSException {
        if (cmpItemList == null || cmpItemList.size() == 0) {
            return null;
        }
        CmpPeriodInfo infoCmpPeriod = dataValue.getCmpPeriod();
        CmpSchemeInfo infoCmpScheme = dataValue.getCmpScheme();
        int beginTime = dataValue.getBeginTime();
        int endTime = dataValue.getEndTime();
        if (endTime == 0) {
            endTime = 10000;
        }
        infoCmpScheme = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(infoCmpScheme.getId()));
        DeptInnerSchemeInfo deptInnerScheme = dataValue.getDeptInnerScheme();
        StringBuffer sql = new StringBuffer();
        StringBuffer selector = new StringBuffer();
        sql.append(" select horTable.fpersonid ");
        selector.append(" fpersonid,fperiod,ftime ");
        CmpItemInfo itemInfo = null;
        for (int i = 0; i < cmpItemList.size(); ++i) {
            itemInfo = (CmpItemInfo)cmpItemList.get(i);
            sql.append(",sum(isnull(horTable.").append(itemInfo.getNumber()).append(",0)) as ").append(itemInfo.getNumber());
            selector.append(",").append(itemInfo.getNumber());
        }
        String tableName = null;
        if (infoCmpScheme.getHisTableName() == null) {
            tableName = infoCmpScheme.getHorTableName();
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("(select ").append(selector).append(" from ").append(infoCmpScheme.getHorTableName()).append(" union select ").append(selector).append(" from ").append(infoCmpScheme.getHisTableName()).append(")");
            tableName = sb.toString();
        }
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        sql.append(" from ").append(tableName).append(" horTable ");
        sql.append(" left outer join T_HR_DeptInnerSchemePersonInfo t1 on t1.FPersonID = horTable.fpersonid ");
        sql.append(" left outer join t_hr_deptschemeentry t2 on t1.FDeptInnerSchemeID = t2.fid ");
        sql.append(" left outer join t_hr_deptinnerscheme t3 on t3.fid = t2.FDeptInnerSchemeID");
        sql.append(" where t3.fid='").append(deptInnerScheme.getId().toString()).append("'");
        sql.append(" and horTable.fperiod='").append(infoCmpPeriod.getId().toString()).append("'");
        sql.append("and horTable.ftime>=").append(beginTime).append(" and horTable.ftime<=").append(endTime).append(" group by horTable.fpersonid");
        return sql.toString();
    }

    private Map getCmpItemValue(Context ctx, String sql, List cmpItemList) throws EASBizException, BOSException, SQLException {
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap resultMap = new HashMap();
        String personID = null;
        HashMap<String, Object> itemMap = null;
        while (iRowSet.next()) {
            personID = iRowSet.getString("fpersonid");
            itemMap = new HashMap<String, Object>();
            CmpItemInfo itemInfo = null;
            boolean dataType = false;
            for (int i = 0; i < cmpItemList.size(); ++i) {
                itemInfo = (CmpItemInfo)cmpItemList.get(i);
                itemMap.put(itemInfo.getId().toString(), iRowSet.getObject(itemInfo.getNumber()));
            }
            resultMap.put(personID, itemMap);
        }
        return resultMap;
    }
}

