/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.EndInputPartFactory;
import com.kingdee.eas.hr.compensation.EndInputPartInfo;
import com.kingdee.eas.hr.compensation.app.AbstractEndInputPartControllerBean;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class EndInputPartControllerBean
extends AbstractEndInputPartControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.EndInputPartControllerBean");

    @Override
    protected void _createNewTable(Context ctx) throws BOSException, EASBizException {
        int seq = this.getNextSeq(ctx);
        this.createNewTable(ctx, seq);
    }

    @Override
    protected void _moveEndInputDataToNewTable(Context ctx, String cmpSchemeID, String newTableName, String oldTableName) throws BOSException, EASBizException {
        if (StringUtil.isEmpty((String)oldTableName) && StringUtil.isEmpty((String)newTableName)) {
            return;
        }
        if (StringUtil.isEmpty((String)newTableName)) {
            newTableName = "T_HR_PeriodEndInput";
        }
        if (StringUtil.isEmpty((String)oldTableName)) {
            oldTableName = "T_HR_PeriodEndInput";
        }
        this.insertDataToNewTable(ctx, cmpSchemeID, newTableName, oldTableName);
        this.deleteFromOldName(ctx, cmpSchemeID, oldTableName);
    }

    @Override
    protected void _deleteFromOldName(Context ctx, String cmpSchemeID, String oldTableName) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        DbUtil.execute((Context)ctx, (String)("delete from " + oldTableName + " where FCMPSCHEMEID = ? "), (Object[])new Object[]{cmpSchemeID});
        long endTime = System.currentTimeMillis();
        System.out.println("deleteFromOldName:(" + cmpSchemeID + ")" + (endTime - startTime));
    }

    @Override
    protected void _insertDataToNewTable(Context ctx, String cmpSchemeID, String newTableName, String oldTableName) throws BOSException, EASBizException {
        EndInputPartFactory.getLocalInstance(ctx).delete(" where cmpScheme.id='" + cmpSchemeID + "'");
        if (!StringUtil.isEmpty((String)newTableName) && !newTableName.equalsIgnoreCase("T_HR_PeriodEndInput")) {
            EndInputPartInfo endInputPartInfo = new EndInputPartInfo();
            CmpSchemeInfo cmpSchemeInfo = new CmpSchemeInfo();
            cmpSchemeInfo.setId(BOSUuid.read((String)cmpSchemeID));
            endInputPartInfo.setCmpScheme(cmpSchemeInfo);
            endInputPartInfo.setTableName(newTableName);
            EndInputPartFactory.getLocalInstance(ctx).addnew(endInputPartInfo);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(newTableName).append("").append("(FID,FCMPSCHEMEID,FCMPPERIODID,FCMPITEMID,FPERSONID,FSUPPLY,FVALUE,FFLOATVALUE,FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME)").append(" select FID,FCMPSCHEMEID,FCMPPERIODID,FCMPITEMID,FPERSONID,FSUPPLY,FVALUE,FFLOATVALUE,FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME").append(" from ").append(oldTableName).append(" where FCMPSCHEMEID = ? ");
        long startTime = System.currentTimeMillis();
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cmpSchemeID});
        long endTime = System.currentTimeMillis();
        System.out.println("insertDataToNewTable:(" + cmpSchemeID + ")" + (endTime - startTime));
    }

    @Override
    protected void _assingByHR(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        DbUtil.execute((Context)ctx, (String)"delete from T_HR_EndInputPart where LCASE(FTableName) = 't_hr_periodendinput'");
        sql.append("select Fid,FHROrgUnitID from t_hr_cmpScheme ").append("where fisdelete = 0").append(" and fid not in (select FcmpSchemeID from T_HR_EndInputPart)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap hrMap = new HashMap();
        String fid = null;
        String hrID = null;
        Set<String> idSet = null;
        try {
            while (rs.next()) {
                fid = rs.getString(1);
                hrID = rs.getString(2);
                if (!hrMap.containsKey(hrID)) {
                    idSet = new HashSet();
                    hrMap.put(hrID, idSet);
                } else {
                    idSet = (Set)hrMap.get(hrID);
                }
                idSet.add(fid);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        int startSeq = this.getNextSeq(ctx);
        Iterator keySet = hrMap.keySet().iterator();
        String tableName = null;
        while (keySet.hasNext()) {
            hrID = keySet.next().toString();
            tableName = this.createNewTable(ctx, startSeq++);
            idSet = (Set)hrMap.get(hrID);
            this.moveDataBatch(ctx, tableName, idSet);
        }
        try {
            TableManager.getTableManager((Context)ctx).truncateTable("T_HR_PeriodEndInput");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void moveDataBatch(Context ctx, String tableName, Set idSet) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tableName).append("").append("(FID,FCMPSCHEMEID,FCMPPERIODID,FCMPITEMID,FPERSONID,FSUPPLY,FVALUE,FFLOATVALUE,FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME)").append(" select FID,FCMPSCHEMEID,FCMPPERIODID,FCMPITEMID,FPERSONID,FSUPPLY,FVALUE,FFLOATVALUE,FINTVALUE,FSTRINGVALUE,FDATEVALUE,FTIME").append(" from T_HR_PeriodEndInput where FCMPSCHEMEID in ").append(CompUtils.getStrFromSet(idSet));
        long startTime = System.currentTimeMillis();
        DbUtil.execute((Context)ctx, (String)sql.toString());
        long endTime = System.currentTimeMillis();
        System.out.println("moveDataBatch---------------" + tableName + ":" + (endTime - startTime));
        PreparedStatement psAdd = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            psAdd = conn.prepareStatement("insert into T_HR_EndInputPart(FID,FCmpSchemeID,FTableName)values(?,?,?)");
            Iterator iter = idSet.iterator();
            while (iter.hasNext()) {
                psAdd.setString(1, BOSUuid.create((String)"35590F84").toString());
                psAdd.setString(2, iter.next().toString());
                psAdd.setString(3, tableName);
                psAdd.addBatch();
            }
            psAdd.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(psAdd, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)psAdd, (Connection)conn);
    }

    private String createNewTable(Context ctx, int seq) throws BOSException, EASBizException {
        String newTableName = "T_HR_PeriodEndInput_" + seq;
        StringBuffer sql = new StringBuffer();
        sql.append(" create table " + newTableName + " ( ").append(" FID               VARCHAR(44) not null,").append(" FCMPSCHEMEID      VARCHAR(44),").append(" FCMPPERIODID      VARCHAR(44),").append(" FCMPITEMID        VARCHAR(44),").append(" FPERSONID         VARCHAR(44),").append(" FSUPPLY           int default 10,").append(" FVALUE            NUMERIC(19,4),").append(" FFLOATVALUE       NUMERIC(21,8),").append(" FINTVALUE         int ,").append(" FSTRINGVALUE      NVARCHAR(255),").append(" FDATEVALUE        DateTime,").append(" FTIME             int default 1 )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        String indexName = "IX_HR_PEndInput" + seq;
        sql = new StringBuffer();
        sql.append("CREATE INDEX ").append(indexName).append(" ON ").append(newTableName).append("(FCMPSCHEMEID,FCMPPERIODID,FTIME,FCMPITEMID,FPERSONID)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into T_HR_EndInputPartTable(FTableName,FSeq)values(?,?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{newTableName, new Integer(seq)});
        return newTableName;
    }

    private int getNextSeq(Context ctx) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select max(FSEQ) from T_HR_EndInputPartTable");
        int seq = 0;
        try {
            while (rs.next()) {
                seq = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ++seq;
    }
}

