/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadServer;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.MailServerSetInfo;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.EmailShowTypeEnum;
import com.kingdee.eas.hr.compensation.EmpCompenseException;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.SalaryEMailFormatInfo;
import com.kingdee.eas.hr.compensation.app.AbstractSalaryEMailFormatControllerBean;
import com.kingdee.eas.hr.compensation.app.CmpBuildDynSqlHandler;
import com.kingdee.eas.hr.compensation.util.CompUtils;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.compensation.util.HtmlExporter;
import com.kingdee.eas.hr.compensation.util.PersonInfoUtils;
import com.kingdee.eas.hr.compensation.util.SalarySlipUtils;
import com.kingdee.eas.hr.train.MailForAttachUtil;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class SalaryEMailFormatControllerBean
extends AbstractSalaryEMailFormatControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.SalaryEMailFormatControllerBean");
    private static final int colC = 10;
    private static final String hF = " align=\"center\" width=\"90\" ";
    private static final String vF = " align=\"right\" width=\"90\" ";
    private static final String lF = " align=\"left\" width=\"90\" ";

    @Override
    protected List _sendSalaryMail(Context ctx, List cmpItemLst, Map salaryMap, SalaryEMailFormatInfo salaryEMailFormatInfo) throws BOSException, EASBizException {
        String temS = SalarySlipUtils.strReplace(" ", "&nbsp;", salaryEMailFormatInfo.getStartText());
        salaryEMailFormatInfo.setStartText(temS);
        temS = SalarySlipUtils.strReplace(" ", "&nbsp;", salaryEMailFormatInfo.getEndText());
        salaryEMailFormatInfo.setEndText(temS);
        boolean isUseExcelTemplate = salaryEMailFormatInfo.isIsUseExcelTemplate();
        boolean isAttachSend = salaryEMailFormatInfo.isIsSendAttachment();
        Set personSet = null;
        String htmlContent = null;
        Map dataMap = null;
        String attachmentID = null;
        POIFSFileSystem pfs = null;
        if (isUseExcelTemplate) {
            if (salaryMap.containsKey("salary_AttachmentID")) {
                personSet = (Set)salaryMap.get("personlist");
                attachmentID = (String)salaryMap.get("salary_AttachmentID");
                if (!isAttachSend) {
                    htmlContent = this.getContentFromExceltemp(ctx, attachmentID);
                } else {
                    Connection conn = null;
                    AttachmentDownloadServer downLoadServer = new AttachmentDownloadServer();
                    InputStream inputStream = null;
                    try {
                        conn = EJBFactory.getConnection((Context)ctx);
                        inputStream = downLoadServer.getContent4Server(attachmentID, conn);
                        pfs = new POIFSFileSystem(inputStream);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        throw new EmpCompenseException(EmpCompenseException.FILE_FORMAT_ERROR);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        SQLUtils.cleanup((Connection)conn);
                    }
                }
                dataMap = this.getPersonItemValue(ctx, salaryMap);
            } else {
                logger.info((Object)"send mail is unsuccessful:Attachment is null! ");
            }
        } else {
            personSet = salaryMap.keySet();
        }
        Map personMailAdd = this.getPersonMailAdd(ctx, personSet);
        HashSet<String> retError = new HashSet<String>();
        String personid = null;
        Map personSalary = null;
        String toMail = null;
        String fromMail = null;
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            fromMail = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getEmail();
        }
        MailForAttachUtil mailUtil = MailForAttachUtil.getInstance((Context)ctx);
        MailServerSetInfo mailServerInfo = mailUtil.getMailServerInfo();
        int i = 0;
        if (personSet != null) {
            Iterator keyIt = personSet.iterator();
            Map personItemMap = null;
            while (keyIt.hasNext()) {
                personid = (String)keyIt.next();
                toMail = (String)personMailAdd.get(personid);
                if (toMail == null) {
                    retError.add(personid);
                    continue;
                }
                if (isUseExcelTemplate) {
                    try {
                        personItemMap = (Map)dataMap.get(personid);
                        this.sendMailWithExcelTemp(ctx, mailServerInfo, personItemMap, salaryEMailFormatInfo, fromMail, toMail, htmlContent, pfs);
                    }
                    catch (Exception e) {
                        if (++i <= 2) {
                            logger.info((Object)e);
                        }
                        retError.add(personid);
                    }
                    continue;
                }
                personSalary = (Map)salaryMap.get(personid);
                if (personSalary == null) continue;
                try {
                    this.sendMail(mailServerInfo, salaryEMailFormatInfo, cmpItemLst, personSalary, fromMail, toMail, ctx);
                }
                catch (Exception e) {
                    if (++i <= 2) {
                        logger.info((Object)e);
                    }
                    retError.add(personid);
                }
            }
        }
        ArrayList<HashSet<String>> al = new ArrayList<HashSet<String>>();
        al.add(retError);
        return al;
    }

    private void sendMail(MailServerSetInfo mailServerInfo, SalaryEMailFormatInfo salaryEMailFormatInfo, List cmpItemLst, Map salaryMap, String fromMail, String toMail, Context ctx) throws Exception {
        String subject = salaryEMailFormatInfo.getSubject();
        String head = salaryEMailFormatInfo.getStartText();
        head = head.replaceAll("#NAME#", (String)salaryMap.get("FPER001"));
        String content = this.getContent(salaryEMailFormatInfo, cmpItemLst, salaryMap, ctx);
        String end = salaryEMailFormatInfo.getEndText();
        if (salaryEMailFormatInfo.getString("cmpPeriodInfoDate") != null) {
            subject = subject.replaceFirst("XXXX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()), salaryEMailFormatInfo.getString("cmpPeriodInfoDate"));
            head = head.replaceFirst("XXXX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()), salaryEMailFormatInfo.getString("cmpPeriodInfoDate"));
        }
        SimpleDateFormat sp = new SimpleDateFormat("yy" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "MM" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "dd" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"76_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()));
        String nowDate = sp.format(new Date());
        end = end.replaceFirst("XXXX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"76_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()), nowDate);
        MailForAttachUtil mailUtil = MailForAttachUtil.getInstance((Context)ctx);
        mailUtil.sendMail(mailServerInfo, fromMail, toMail, subject, head + content + end);
    }

    private String getContent(SalaryEMailFormatInfo salaryEMailFormatInfo, List cmpItemLst, Map salaryMap, Context ctx) {
        String str = null;
        if (1 == salaryEMailFormatInfo.getShowType().getValue()) {
            str = this.getContentOfTxt(salaryEMailFormatInfo.isIsDisplayZeroItem(), cmpItemLst, salaryMap, ctx);
            str = " <table border=1>" + str + "</table>";
        } else {
            str = this.getContentOfList(salaryEMailFormatInfo.isIsDisplayZeroItem(), cmpItemLst, salaryMap, ctx);
            str = " <table border=1  width=\"1000\">" + str + "</table>";
        }
        return str.toString();
    }

    private void sendMailWithExcelTemp(Context ctx, MailServerSetInfo mailServerInfo, Map personItemMap, SalaryEMailFormatInfo salaryEMailFormatInfo, String fromMail, String toMail, String htmlContent, POIFSFileSystem pfs) throws Exception {
        String subject = salaryEMailFormatInfo.getSubject();
        String head = salaryEMailFormatInfo.getStartText();
        head = head.replaceAll("#NAME#", (String)personItemMap.get("FPER001"));
        String end = salaryEMailFormatInfo.getEndText();
        if (salaryEMailFormatInfo.getString("cmpPeriodInfoDate") != null) {
            subject = subject.replaceFirst("XXXX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()), salaryEMailFormatInfo.getString("cmpPeriodInfoDate"));
            head = head.replaceFirst("XXXX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()), salaryEMailFormatInfo.getString("cmpPeriodInfoDate"));
        }
        SimpleDateFormat sp = new SimpleDateFormat("yy" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "MM" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "dd" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"76_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()));
        String nowDate = sp.format(new Date());
        end = end.replaceFirst("XXXX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"74_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"75_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) + "XX" + ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"76_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()), nowDate);
        String content = null;
        boolean isAttachSend = salaryEMailFormatInfo.isIsSendAttachment();
        if (!isAttachSend) {
            MailForAttachUtil mailUtil = MailForAttachUtil.getInstance((Context)ctx);
            content = this.replaceItemNumber(htmlContent, personItemMap);
            mailUtil.sendMail(mailServerInfo, fromMail, toMail, subject, head + content + end);
        } else {
            this.sendHtmlMailForAct(ctx, fromMail, toMail, subject, head + "<br/>" + end, pfs, mailServerInfo, personItemMap);
        }
    }

    private String getContentFromExceltemp(Context ctx, String attachmentID) throws BOSException, EASBizException {
        Connection conn = null;
        AttachmentDownloadServer downLoadServer = new AttachmentDownloadServer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        HtmlExporter exporter = new HtmlExporter();
        InputStream inputStream = null;
        try {
            inputStream = downLoadServer.getContent4Server(attachmentID, conn);
            KDSBook book = POIXlsReader.parse((InputStream)inputStream);
            exporter.setParameter(ExporterParameter.KD_Print, new PrintableBook(book));
            exporter.export();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new EmpCompenseException(EmpCompenseException.FILE_FORMAT_ERROR);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SQLUtils.cleanup((Connection)conn);
        }
        return exporter.getHtmlStr();
    }

    private Map getPersonItemValue(Context ctx, Map salaryMap) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        Set personSet = (Set)salaryMap.get("personlist");
        CmpPeriodInfo periodInfo = (CmpPeriodInfo)salaryMap.get("salary_cmpPeriod");
        Integer time = (Integer)salaryMap.get("salary_beginTime");
        String cmpSchemeID = (String)salaryMap.get("salary_cmpScheme");
        String oql = "select cmpPeriod.*,horTableName,hisTableName,time where id ='" + cmpSchemeID + "'";
        CmpSchemeInfo cmpSchemeInfo = CmpSchemeFactory.getLocalInstance(ctx).getCmpSchemeInfo(oql);
        String tableName = cmpSchemeInfo.getHorTableName();
        if (cmpSchemeInfo.getHisTableName() != null) {
            if (!cmpSchemeInfo.getCmpPeriod().getId().equals((Object)periodInfo.getId())) {
                tableName = cmpSchemeInfo.getHisTableName();
            } else if (cmpSchemeInfo.getTime() != time.intValue()) {
                tableName = cmpSchemeInfo.getHisTableName();
            }
        }
        oql = "select cmpItem.id,cmpItem.number,cmpItem.dataType,cmpItem.precisionType,cmpItem.decDigital,cmpItem.subject where cmpScheme.id = '" + cmpSchemeID + "'";
        CmpSchemeItemCollection cmpSchemeItemColl = CmpSchemeItemFactory.getLocalInstance(ctx).getCmpSchemeItemCollection(oql);
        if (cmpSchemeItemColl == null) {
            return resultMap;
        }
        ArrayList personItems = null;
        try {
            personItems = HRCmpItemUtils.getMappingPersonItems(ctx, 1);
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage());
        }
        ArrayList<CmpItemInfo> itemList = new ArrayList<CmpItemInfo>();
        CmpItemInfo itemInfo = null;
        for (int i = 0; i < cmpSchemeItemColl.size(); ++i) {
            itemInfo = cmpSchemeItemColl.get(i).getCmpItem();
            if (itemInfo.getNumber().startsWith("FPER") && ItemSubjectEnum.NOTSYSINIT.equals((Object)itemInfo.getSubject())) {
                if (personItems == null || !personItems.contains(itemInfo.getNumber())) continue;
                itemList.add(itemInfo);
                continue;
            }
            itemList.add(itemInfo);
        }
        CmpBuildDynSqlHandler handler = new CmpBuildDynSqlHandler(ctx, tableName);
        handler.setCmpItemList(itemList);
        handler.setAliasName("dynTableName");
        StringBuffer dynSql = new StringBuffer(handler.getItemSelectSQL(null, null));
        if (dynSql == null || dynSql.length() == 0) {
            return resultMap;
        }
        dynSql = dynSql.append(" and \"PERSON\".FID in ").append(CompUtils.getStrFromSet(personSet)).append(" and dynTableName.fperiod ='").append(periodInfo.getId()).append("'").append(" and dynTableName.ftime = ").append(time);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)PersonInfoUtils.getOptimizeSql(dynSql.toString()));
        String personid = null;
        try {
            HashMap<String, Object> personItemValueMap = null;
            String itemNumber = null;
            itemInfo = null;
            while (rs.next()) {
                personItemValueMap = new HashMap<String, Object>();
                personid = rs.getString("FPERSONID");
                for (int i = 0; i < itemList.size(); ++i) {
                    itemInfo = (CmpItemInfo)itemList.get(i);
                    itemNumber = itemInfo.getNumber();
                    if ("FPER010".equals(itemNumber)) {
                        personItemValueMap.put(itemNumber, Genders.getEnum((int)rs.getInt(itemNumber)));
                        continue;
                    }
                    if (10 == itemInfo.getDataType().getValue()) {
                        String logicValue = null;
                        logicValue = rs.getBoolean(itemNumber) ? ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.CmpCheckWizardResource.YES", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.CmpCheckWizardResource.NO", (Locale)ctx.getOriginLocale());
                        personItemValueMap.put(itemNumber, logicValue);
                        continue;
                    }
                    if (20 == itemInfo.getDataType().getValue()) {
                        personItemValueMap.put(itemNumber, rs.getDate(itemNumber));
                        continue;
                    }
                    if (60 == itemInfo.getDataType().getValue() || 50 == itemInfo.getDataType().getValue()) {
                        BigDecimal value = HRCmpItemUtils.convertPrecisionForBigDecimal(rs.getBigDecimal(itemNumber), itemInfo.getDecDigital(), itemInfo.getPrecisionType());
                        personItemValueMap.put(itemNumber, value);
                        continue;
                    }
                    personItemValueMap.put(itemNumber, rs.getString(itemNumber));
                }
                resultMap.put(personid, personItemValueMap);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return resultMap;
    }

    private String replaceItemNumber(String htmlContent, Map personItemMap) throws BOSException, EASBizException {
        Pattern pattern = Pattern.compile("F{1,2}(PER|SAL|CHK|WEL|OTH|PRM|CBG)\\d{3,5}");
        Matcher matcher = null;
        matcher = pattern.matcher(htmlContent);
        String itemNumber = null;
        Set itemNumeberSet = personItemMap.keySet();
        while (matcher.find()) {
            itemNumber = matcher.group();
            if (itemNumeberSet.contains(itemNumber) && personItemMap.get(itemNumber) != null) {
                htmlContent = StringUtils.replace((String)htmlContent, (String)itemNumber, (String)personItemMap.get(itemNumber).toString());
                continue;
            }
            htmlContent = StringUtils.replace((String)htmlContent, (String)itemNumber, (String)"");
        }
        return htmlContent;
    }

    private String getContentOfList(boolean notDisplayZeroItem, List cmpItemOriginalList, Map salaryMap, Context ctx) {
        ArrayList cmpItemLst = new ArrayList();
        cmpItemLst.addAll(cmpItemOriginalList);
        CmpItemInfo cmpItem = null;
        StringBuffer tableStr = new StringBuffer();
        StringBuffer strName = new StringBuffer("<tr>");
        StringBuffer strValue = new StringBuffer("<tr>");
        Object cmpItemNumber = null;
        Comparable<Boolean> cmpItemObj = null;
        String temStr = null;
        int j = 0;
        if (notDisplayZeroItem) {
            ArrayList<CmpItemInfo> cmpItemDisplayList = new ArrayList<CmpItemInfo>();
            int size = cmpItemLst.size();
            for (int i = 0; i < size; ++i) {
                cmpItem = (CmpItemInfo)cmpItemLst.get(i);
                cmpItemObj = (Comparable<Boolean>)salaryMap.get(cmpItem.getNumber());
                if (40 == cmpItem.getDataType().getValue()) {
                    if (cmpItemObj == null || (Integer)cmpItemObj == 0) continue;
                    cmpItemDisplayList.add(cmpItem);
                    continue;
                }
                if (50 == cmpItem.getDataType().getValue() || 60 == cmpItem.getDataType().getValue()) {
                    if (cmpItemObj == null || ((BigDecimal)cmpItemObj).compareTo(new BigDecimal("0.0")) == 0) continue;
                    cmpItemDisplayList.add(cmpItem);
                    continue;
                }
                cmpItemDisplayList.add(cmpItem);
            }
            cmpItemLst.clear();
            cmpItemLst.addAll(cmpItemDisplayList);
        }
        int size = cmpItemLst.size();
        for (int i = 0; i < size; ++i) {
            if (j != 0) {
                if (j % 10 == 0) {
                    if ("<tr>".equals(strName.toString())) continue;
                    strName.append("</tr>");
                    strValue.append("</tr>");
                    tableStr.append(strName.toString());
                    tableStr.append(strValue.toString());
                    strName = new StringBuffer("<tr>");
                    strValue = new StringBuffer("<tr>");
                }
            }
            cmpItem = (CmpItemInfo)cmpItemLst.get(i);
            cmpItemObj = (Comparable<Boolean>)salaryMap.get(cmpItem.getNumber());
            if (cmpItem.getDataType() == null || 30 == cmpItem.getDataType().getValue()) {
                strName.append("<td  align=\"center\" width=\"90\"  >" + cmpItem.getName() + "</td> ");
                strValue.append("<td  align=\"left\" width=\"90\" >" + this.getValuePrcNull(cmpItemObj) + "</td> ");
                ++j;
                continue;
            }
            if (20 == cmpItem.getDataType().getValue()) {
                strName.append("<td  align=\"center\" width=\"90\"  >" + cmpItem.getName() + "</td> ");
                strValue.append("<td align=\"left\" width=\"100\">" + this.getValueOfDate(cmpItemObj) + "</td> ");
                ++j;
                continue;
            }
            if (10 == cmpItem.getDataType().getValue()) {
                if (cmpItemObj == null) {
                    cmpItemObj = false;
                }
                temStr = (Boolean)cmpItemObj != false ? ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"77_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"78_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale());
                strName.append("<td  align=\"center\" width=\"90\"  >" + cmpItem.getName() + "</td>");
                strValue.append("<td  align=\"right\" width=\"90\" >" + temStr + "</td>");
                ++j;
                continue;
            }
            if (40 == cmpItem.getDataType().getValue()) {
                if (cmpItemObj == null || (Integer)cmpItemObj == 0) {
                    cmpItemObj = 0;
                    if (notDisplayZeroItem) continue;
                }
                this.appandAddLstRow(notDisplayZeroItem, strName, strValue, cmpItem.getName(), cmpItemObj.toString());
                ++j;
                continue;
            }
            if (50 == cmpItem.getDataType().getValue()) {
                if (cmpItemObj == null || ((BigDecimal)cmpItemObj).compareTo(new BigDecimal("0.0")) == 0) {
                    cmpItemObj = new Float(0.0f);
                    if (notDisplayZeroItem) continue;
                }
                this.appandAddLstRow(notDisplayZeroItem, strName, strValue, cmpItem.getName(), cmpItemObj.toString());
                ++j;
                continue;
            }
            if (60 != cmpItem.getDataType().getValue()) continue;
            if (cmpItemObj == null || ((BigDecimal)cmpItemObj).compareTo(new BigDecimal("0.0")) == 0) {
                cmpItemObj = new BigDecimal("0.0");
                if (notDisplayZeroItem) continue;
            }
            this.appandAddLstRow(notDisplayZeroItem, strName, strValue, cmpItem.getName(), cmpItemObj.toString());
            ++j;
        }
        if (!"<tr>".equals(strName.toString())) {
            if (j > 10) {
                if (j % 10 != 0) {
                    this.setLessColumn(10 - j % 10, strName, strValue);
                }
            }
            strName.append("</tr>");
            strValue.append("</tr>");
            tableStr.append(strName.toString());
            tableStr.append(strValue.toString());
        }
        return tableStr.toString();
    }

    private void setLessColumn(int lessC, StringBuffer strN, StringBuffer strV) {
        for (int i = 0; i < lessC; ++i) {
            strN.append("<td  align=\"center\" width=\"90\" >&nbsp;</td> ");
            strV.append("<td  align=\"right\" width=\"90\"  >&nbsp;</td> ");
        }
    }

    private void appandAddLstRow(boolean notDisplayZeroItem, StringBuffer strName, StringBuffer strValue, String name, Object va) {
        if (name == null) {
            return;
        }
        strName.append("<td  align=\"center\" width=\"90\"  >" + name + "</td>");
        strValue.append("<td  align=\"right\" width=\"90\" >" + va.toString() + "</td>");
    }

    private String getContentOfTxt(boolean notDisplayZeroItem, List cmpItemLst, Map salaryMap, Context ctx) {
        CmpItemInfo cmpItem = null;
        StringBuffer str = new StringBuffer();
        Object cmpItemNumber = null;
        Comparable<Boolean> cmpItemObj = null;
        String temStr = null;
        int size = cmpItemLst.size();
        for (int i = 0; i < size; ++i) {
            cmpItem = (CmpItemInfo)cmpItemLst.get(i);
            cmpItemObj = (Comparable<Boolean>)salaryMap.get(cmpItem.getNumber());
            if (30 == cmpItem.getDataType().getValue()) {
                str.append("<tr><td>" + cmpItem.getName() + "</td> <td>" + this.getValuePrcNull(cmpItemObj) + "</td></tr> \n");
            }
            if (20 == cmpItem.getDataType().getValue()) {
                str.append("<tr><td>" + cmpItem.getName() + "</td> <td>" + this.getValueOfDate(cmpItemObj) + "</td></tr> \n");
            }
            if (10 == cmpItem.getDataType().getValue()) {
                if (cmpItemObj == null) {
                    cmpItemObj = false;
                }
                temStr = (Boolean)cmpItemObj != false ? ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"77_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"78_SalaryEMailFormatControllerBean", (Locale)ctx.getOriginLocale());
                str.append("<tr><td>" + cmpItem.getName() + "</td> <td>" + temStr + "</td></tr> \n");
            }
            if (40 == cmpItem.getDataType().getValue()) {
                if (cmpItemObj == null || (Integer)cmpItemObj == 0) {
                    cmpItemObj = 0;
                    if (notDisplayZeroItem) continue;
                }
                this.appandAddTxtRow(notDisplayZeroItem, str, cmpItem.getName(), cmpItemObj.toString());
            }
            if (50 == cmpItem.getDataType().getValue()) {
                if (cmpItemObj == null || ((BigDecimal)cmpItemObj).compareTo(new BigDecimal("0.0")) == 0) {
                    cmpItemObj = new Float(0.0f);
                    if (notDisplayZeroItem) continue;
                }
                this.appandAddTxtRow(notDisplayZeroItem, str, cmpItem.getName(), cmpItemObj.toString());
            }
            if (60 != cmpItem.getDataType().getValue()) continue;
            if (cmpItemObj == null || ((BigDecimal)cmpItemObj).compareTo(new BigDecimal("0.0")) == 0) {
                cmpItemObj = new BigDecimal("0.0");
                if (notDisplayZeroItem) continue;
            }
            this.appandAddTxtRow(notDisplayZeroItem, str, cmpItem.getName(), cmpItemObj.toString());
        }
        return str.toString();
    }

    private String getValuePrcNull(Object cmpItemObj) {
        if (cmpItemObj == null || "".equals(cmpItemObj.toString())) {
            return "&nbsp;";
        }
        return cmpItemObj.toString();
    }

    private String getValueOfDate(Object cmpItemObj) {
        if (cmpItemObj == null || "".equals(cmpItemObj.toString())) {
            return "&nbsp;";
        }
        return cmpItemObj.toString();
    }

    private void appandAddTxtRow(boolean notDisplayZeroItem, StringBuffer str, String name, Object va) {
        if (name == null) {
            return;
        }
        str.append("<tr><td>" + name + "</td> <td>" + va.toString() + "</td></tr> \n");
    }

    private Map getPersonMailAdd(Context ctx, Set personSet) throws BOSException {
        if (personSet == null || personSet.size() == 0) {
            return null;
        }
        Iterator keyIt = personSet.iterator();
        String personid = null;
        StringBuffer idStr = new StringBuffer();
        int i = 0;
        while (keyIt.hasNext()) {
            personid = (String)keyIt.next();
            if (personid == null) continue;
            if (i == 0) {
                idStr.append("'" + personid + "'");
            } else {
                idStr.append(",'" + personid + "'");
            }
            ++i;
        }
        String sql = "select  FPersonID , FEmail from T_HR_PersonContactMethod where  FPersonID in (" + idStr.toString() + ")";
        HashMap<String, String> mailMap = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String personidTem = null;
        try {
            while (rs.next()) {
                personidTem = rs.getString("FPersonID");
                if (personidTem == null) continue;
                mailMap.put(personidTem, rs.getString("FEmail"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return mailMap;
    }

    @Override
    protected boolean _isSubjectExist(Context ctx, String subject) throws BOSException, EASBizException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "SELECT FID FROM T_HR_SalaryEMailFormat WHERE FCurrentUserId = '" + currentUserId + "' AND FSubject = '" + subject + "'";
        IRowSet rs = null;
        ISQLExecutor executor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        rs = executor.executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected String _addNew(Context ctx, IObjectValue salaryEmail, SimpleAttachmentInfo attachmentInfo, String[] curAttachIds) throws BOSException, EASBizException {
        SalaryEMailFormatInfo salaryEmailFormat = (SalaryEMailFormatInfo)salaryEmail;
        String sql = "INSERT INTO T_HR_SalaryEMailFormat (FId, FHrOrgUnitId, FStartText, FEndText, FIsDisplayZeroItem,FShowType, FSubject, FCurrentUserId, FIsDefault,FIsUseExcelTemplate,FIsSendAttachment) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement pstm = null;
        String fid = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstm = conn.prepareStatement(sql);
            fid = BOSUuid.create((String)"13FB64A7").toString();
            pstm.setString(1, fid);
            pstm.setString(2, salaryEmailFormat.getHrOrgUnit().getId().toString());
            pstm.setString(3, salaryEmailFormat.getStartText());
            pstm.setString(4, salaryEmailFormat.getEndText());
            pstm.setBoolean(5, salaryEmailFormat.isIsDisplayZeroItem());
            pstm.setInt(6, salaryEmailFormat.getShowType().getValue());
            pstm.setString(7, salaryEmailFormat.getSubject());
            pstm.setString(8, salaryEmailFormat.getCurrentUserId());
            pstm.setBoolean(9, salaryEmailFormat.isIsDefault());
            pstm.setBoolean(10, salaryEmailFormat.isIsUseExcelTemplate());
            pstm.setBoolean(11, salaryEmailFormat.isIsSendAttachment());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)conn);
        if (attachmentInfo != null) {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            if (curAttachIds != null && curAttachIds.length > 0) {
                asm.deleteAttachemtsByBoID(fid);
            }
            asm.addNewAttachment(fid, attachmentInfo);
        }
        this._updateDefaultValue(ctx, salaryEmailFormat.getSubject());
        return fid;
    }

    @Override
    protected void _deleteSalaryEmail(Context ctx, String fid) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)fid)) {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            asm.deleteAttachemtsByBoID(fid);
            String deleteSql = " delete FROM T_HR_SalaryEMailFormat WHERE fid = ? ";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{fid});
        }
    }

    @Override
    protected IObjectValue _selectDefaultSalaryEmailFormat(Context ctx) throws BOSException, EASBizException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "SELECT FStartText, FEndText, FIsDisplayZeroItem, FShowType, FSubject, FIsDefault, FId,FIsUseExcelTemplate,FIsSendAttachment FROM T_HR_SalaryEMailFormat WHERE FCurrentUserId = '" + currentUserId + "' AND FIsDefault = 1";
        SalaryEMailFormatInfo salaryEmail = new SalaryEMailFormatInfo();
        IRowSet rs = null;
        ISQLExecutor executor = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        rs = executor.executeSQL();
        try {
            while (rs.next()) {
                salaryEmail.setStartText(rs.getString(1));
                salaryEmail.setEndText(rs.getString(2));
                salaryEmail.setIsDisplayZeroItem(rs.getBoolean(3));
                salaryEmail.setShowType(EmailShowTypeEnum.getEnum(rs.getInt(4)));
                salaryEmail.setSubject(rs.getString(5));
                salaryEmail.setIsDefault(rs.getBoolean(6));
                salaryEmail.setId(BOSUuid.read((String)rs.getString(7)));
                salaryEmail.setIsUseExcelTemplate(rs.getBoolean(8));
                salaryEmail.setIsSendAttachment(rs.getBoolean(9));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return salaryEmail;
    }

    @Override
    protected void _updateSalaryEmail(Context ctx, String fid, IObjectValue salaryEmail, SimpleAttachmentInfo attachmentInfo, String[] curAttachIds) throws BOSException, EASBizException {
        SalaryEMailFormatInfo salaryEmailFormat = (SalaryEMailFormatInfo)salaryEmail;
        String sql = "UPDATE T_HR_SalaryEMailFormat SET FStartText = ?, FEndText = ?, FIsDisplayZeroItem = ?,FShowType = ?, FSubject = ?,FIsUseExcelTemplate  = ?,FIsSendAttachment=? WHERE  Fid = ?";
        Connection conn = null;
        PreparedStatement pstm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstm = conn.prepareStatement(sql);
            pstm.setString(1, salaryEmailFormat.getStartText());
            pstm.setString(2, salaryEmailFormat.getEndText());
            pstm.setBoolean(3, salaryEmailFormat.isIsDisplayZeroItem());
            pstm.setInt(4, salaryEmailFormat.getShowType().getValue());
            pstm.setString(5, salaryEmailFormat.getSubject());
            pstm.setBoolean(6, salaryEmailFormat.isIsUseExcelTemplate());
            pstm.setBoolean(7, salaryEmailFormat.isIsSendAttachment());
            pstm.setString(8, fid);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)conn);
        if (attachmentInfo != null) {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            if (curAttachIds != null && curAttachIds.length > 0) {
                asm.deleteAttachemtsByBoID(fid);
            }
            asm.addNewAttachment(fid, attachmentInfo);
        }
        this._updateDefaultValue(ctx, salaryEmailFormat.getSubject());
    }

    @Override
    protected void _updateDefaultValue(Context ctx, String subject) throws BOSException, EASBizException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql1 = "UPDATE T_HR_SalaryEMailFormat SET FIsDefault = 1 WHERE FCurrentUserId = '" + currentUserId + "' AND FSubject = '" + subject + "'";
        DbUtil.execute((Context)ctx, (String)sql1);
        String sql2 = "UPDATE T_HR_SalaryEMailFormat SET FIsDefault = 0 WHERE FCurrentUserId = '" + currentUserId + "' AND FSubject != '" + subject + "'";
        DbUtil.execute((Context)ctx, (String)sql2);
    }

    @Override
    protected void _updateDefaultValueFalse(Context ctx, String subject) throws BOSException, EASBizException {
        String currentUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "UPDATE T_HR_SalaryEMailFormat SET FIsDefault = 0 WHERE FCurrentUserId = ? AND FSubject != ?";
        Connection conn = null;
        PreparedStatement pstm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstm = conn.prepareStatement(sql);
            pstm.setString(1, currentUserId);
            pstm.setString(2, subject);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)conn);
    }

    private void sendHtmlMailForAct(Context ctx, String from, String to, String subject, String body, POIFSFileSystem pfs, MailServerSetInfo mssInfo, Map personItemMap) throws Exception {
        File file = null;
        FileOutputStream out = null;
        HSSFWorkbook workbook = this.getWorkBook(ctx, pfs, personItemMap);
        long time = System.currentTimeMillis();
        file = File.createTempFile("eastemp" + time, ".xls");
        out = new FileOutputStream(file);
        workbook.write((OutputStream)out);
        out.flush();
        out.close();
        SalarySlipUtils mailUtils = SalarySlipUtils.getInstance(ctx);
        mailUtils.sendHtmlMailForAct(ctx, from, to, null, null, subject, body, mssInfo, file);
        file.delete();
    }

    private HSSFWorkbook getWorkBook(Context ctx, POIFSFileSystem pfs, Map personItemMap) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook(pfs);
        int sheetNums = workbook.getNumberOfSheets();
        if (sheetNums <= 0) {
            return workbook;
        }
        Pattern pattern = Pattern.compile("F{1,2}(PER|SAL|CHK|WEL|OTH|PRM|CBG)\\d{3,5}");
        Matcher matcher = null;
        HSSFSheet sheet = null;
        HSSFRow row = null;
        HSSFCell fCell = null;
        String cellValue = null;
        String newValue = null;
        for (int i = 0; i < sheetNums; ++i) {
            sheet = workbook.getSheetAt(i);
            int rowNum = sheet.getPhysicalNumberOfRows();
            if (rowNum < 1) continue;
            for (int j = 0; j < rowNum; ++j) {
                row = sheet.getRow(j);
                int cellNumber = row.getPhysicalNumberOfCells();
                if (cellNumber < 1) continue;
                for (int k = 0; k < cellNumber; ++k) {
                    fCell = row.getCell(k);
                    cellValue = ExcelUtil.getCellValue((HSSFCell)fCell);
                    if (StringUtils.isEmpty((String)cellValue) || cellValue.length() > 10) continue;
                    matcher = pattern.matcher(cellValue);
                    if (personItemMap.containsKey(cellValue)) {
                        newValue = (String)personItemMap.get(cellValue);
                    } else {
                        if (!matcher.find()) continue;
                        newValue = "";
                    }
                    if (newValue == null) {
                        fCell.setCellValue("");
                        continue;
                    }
                    fCell.setCellValue(newValue.toString());
                }
            }
        }
        return workbook;
    }
}

