/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.util.HrExDbUtil;
import com.kingdee.eas.hr.compensation.ITeamGroup;
import com.kingdee.eas.hr.compensation.TeamGropupPersonCollection;
import com.kingdee.eas.hr.compensation.TeamGropupPersonInfo;
import com.kingdee.eas.hr.compensation.TeamGroupAuditPersonCollection;
import com.kingdee.eas.hr.compensation.TeamGroupAuditPersonInfo;
import com.kingdee.eas.hr.compensation.TeamGroupFactory;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.hr.compensation.TeamGroupStateEnum;
import com.kingdee.eas.hr.compensation.app.AbstractTeamGroupControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TeamGroupControllerBean
extends AbstractTeamGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.compensation.app.TeamGroupControllerBean");

    @Override
    public IObjectValue _getTeamGroupInfo(Context ctx, IObjectPK pk, boolean needSub) throws BOSException, EASBizException {
        ITeamGroup iTeam = TeamGroupFactory.getLocalInstance(ctx);
        TeamGroupInfo teamGroupInfo = null;
        teamGroupInfo = iTeam.getTeamGroupInfo(pk);
        if (needSub) {
            try {
                this.fillTeamMember(ctx, teamGroupInfo);
                this.fillAduitLeader(ctx, teamGroupInfo);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        return teamGroupInfo;
    }

    private void fillTeamMember(Context ctx, TeamGroupInfo teamGroupInfo) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.TeamGroupMemberQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("teamGroup", (Object)teamGroupInfo.getId().toString()));
        filterInfo.setMaskString("#0");
        evi.setFilter(filterInfo);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(evi);
        IRowSet iRow = queryExcu.executeQuery();
        TeamGropupPersonCollection gropupColl = new TeamGropupPersonCollection();
        TeamGropupPersonInfo memberInfo = null;
        if (iRow == null || iRow.size() == 0) {
            return;
        }
        while (iRow.next()) {
            memberInfo = new TeamGropupPersonInfo();
            memberInfo.setId(BOSUuid.read((String)iRow.getString("id")));
            memberInfo.setIsPrimary(iRow.getBoolean("isPrimary"));
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)iRow.getString("personid")));
            personInfo.setNumber(iRow.getString("personNumber"));
            personInfo.setName(iRow.getString("personName"));
            personInfo.put("primaryPosition", (Object)iRow.getString("primaryPosition"));
            personInfo.put("primaryAdminOrg", (Object)iRow.getString("adminOrg"));
            memberInfo.setPerson(personInfo);
            gropupColl.add(memberInfo);
        }
        teamGroupInfo.setTeamGroupPerson(gropupColl);
    }

    private void fillAduitLeader(Context ctx, TeamGroupInfo teamGroupInfo) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.TeamGroupAuditLeaderQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("teamGroup", (Object)teamGroupInfo.getId().toString()));
        filterInfo.setMaskString("#0");
        evi.setFilter(filterInfo);
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(evi);
        IRowSet iRow = queryExcu.executeQuery();
        TeamGroupAuditPersonCollection gropupColl = new TeamGroupAuditPersonCollection();
        TeamGroupAuditPersonInfo memberInfo = null;
        if (iRow == null || iRow.size() == 0) {
            return;
        }
        while (iRow.next()) {
            memberInfo = new TeamGroupAuditPersonInfo();
            memberInfo.setId(BOSUuid.read((String)iRow.getString("id")));
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)iRow.getString("personid")));
            personInfo.setNumber(iRow.getString("personNumber"));
            personInfo.setName(iRow.getString("personName"));
            personInfo.put("primaryPosition", (Object)iRow.getString("primaryPosition"));
            personInfo.put("primaryAdminOrg", (Object)iRow.getString("adminOrg"));
            memberInfo.setPerson(personInfo);
            gropupColl.add(memberInfo);
        }
        teamGroupInfo.setAuditPerson(gropupColl);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TeamGroupInfo groupInfo = (TeamGroupInfo)model;
        TeamGropupPersonCollection memberColl = groupInfo.getTeamGroupPerson();
        TeamGroupAuditPersonCollection leaderColl = groupInfo.getAuditPerson();
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        IObjectPK pk = super._submit(ctx, (IObjectValue)groupInfo);
        this.saveGroupMember(ctx, pk, memberColl);
        this.saveGroupLeader(ctx, pk, leaderColl);
        return pk;
    }

    private void saveGroupMember(Context ctx, IObjectPK pk, TeamGropupPersonCollection memberColl) throws BOSException, EASBizException {
        int i;
        if (memberColl == null || memberColl.size() == 0) {
            return;
        }
        ArrayList<TeamGropupPersonInfo> addMember = new ArrayList<TeamGropupPersonInfo>();
        ArrayList<TeamGropupPersonInfo> delMember = new ArrayList<TeamGropupPersonInfo>();
        ArrayList<TeamGropupPersonInfo> editMember = new ArrayList<TeamGropupPersonInfo>();
        ArrayList<TeamGropupPersonInfo> noChangeMember = new ArrayList<TeamGropupPersonInfo>();
        Integer state = null;
        TeamGropupPersonInfo memberInfo = null;
        for (int i2 = 0; i2 < memberColl.size(); ++i2) {
            memberInfo = memberColl.get(i2);
            state = (Integer)memberInfo.get("state");
            if (state == 10) {
                addMember.add(memberInfo);
                continue;
            }
            if (state == 20) {
                delMember.add(memberInfo);
                continue;
            }
            if (state == 30) {
                editMember.add(memberInfo);
                continue;
            }
            noChangeMember.add(memberInfo);
        }
        StringBuffer sbSql = null;
        Object[] params = null;
        ArrayList<Object[]> paramList = null;
        if (delMember.size() > 0) {
            sbSql = new StringBuffer(" DELETE FROM T_HR_TEAMGROPUPPERSON WHERE FID IN (");
            for (i = 0; i < delMember.size(); ++i) {
                sbSql.append("'").append(((TeamGropupPersonInfo)delMember.get(i)).getId().toString()).append("'");
                if (i == delMember.size() - 1) continue;
                sbSql.append(",");
            }
            sbSql.append(")");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
        }
        if (addMember.size() > 0) {
            // empty if block
        }
        if (editMember.size() > 0) {
            sbSql = new StringBuffer(" UPDATE T_HR_TEAMGROPUPPERSON SET fisprimary= ? where FID = ?");
            paramList = new ArrayList<Object[]>();
            for (i = 0; i < editMember.size(); ++i) {
                memberInfo = (TeamGropupPersonInfo)editMember.get(i);
                int primary = 0;
                if (memberInfo.isIsPrimary()) {
                    primary = 1;
                }
                params = new Object[]{primary, memberInfo.getId().toString()};
                paramList.add(params);
            }
            HrExDbUtil.executeBatch((Context)ctx, (String)sbSql.toString(), paramList);
        }
    }

    private void saveGroupLeader(Context ctx, IObjectPK pk, TeamGroupAuditPersonCollection leaderColl) throws BOSException, EASBizException {
        if (leaderColl == null || leaderColl.size() == 0) {
            return;
        }
        ArrayList<TeamGroupAuditPersonInfo> addMember = new ArrayList<TeamGroupAuditPersonInfo>();
        ArrayList<TeamGroupAuditPersonInfo> delMember = new ArrayList<TeamGroupAuditPersonInfo>();
        ArrayList<TeamGroupAuditPersonInfo> editMember = new ArrayList<TeamGroupAuditPersonInfo>();
        ArrayList<TeamGroupAuditPersonInfo> noChangeMember = new ArrayList<TeamGroupAuditPersonInfo>();
        Integer state = null;
        TeamGroupAuditPersonInfo memberInfo = null;
        for (int i = 0; i < leaderColl.size(); ++i) {
            memberInfo = leaderColl.get(i);
            state = (Integer)memberInfo.get("state");
            if (state == 10) {
                addMember.add(memberInfo);
                continue;
            }
            if (state == 20) {
                delMember.add(memberInfo);
                continue;
            }
            if (state == 30) {
                editMember.add(memberInfo);
                continue;
            }
            noChangeMember.add(memberInfo);
        }
        StringBuffer sbSql = null;
        if (delMember.size() > 0) {
            sbSql = new StringBuffer(" DELETE FROM T_HR_TEAMGROUPAUDITPERSON WHERE FID IN (");
            for (int i = 0; i < delMember.size(); ++i) {
                sbSql.append("'").append(((TeamGroupAuditPersonInfo)delMember.get(i)).getId().toString()).append("'");
                if (i == delMember.size() - 1) continue;
                sbSql.append(",");
            }
            sbSql.append(")");
            DbUtil.execute((Context)ctx, (String)sbSql.toString());
        }
        if (editMember.size() > 0) {
            // empty if block
        }
    }

    @Override
    protected void _updateState(Context ctx, IObjectPK key, TeamGroupStateEnum state) throws BOSException {
        String updateSql = null;
        Date fcreateTime = new Date(new java.util.Date().getTime());
        updateSql = state.equals((Object)TeamGroupStateEnum.DISABLE) ? " UPDATE T_HR_TEAMGROUP SET FSTATE = ?,FDISABLEDATE = ? WHERE FID = ? " : " UPDATE T_HR_TEAMGROUP SET FSTATE = ?,FENABLEDATE = ? WHERE FID = ? ";
        Object[] params = new Object[]{state.getValue(), fcreateTime, key.toString()};
        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])params);
    }

    @Override
    protected Map _getPrimaryPersonNames(Context ctx, Set idSet) throws BOSException, EASBizException {
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        sb.append("select teamgroup.FID as ID,person.FName").append(locale);
        sb.append(" as NAME");
        sb.append(" from T_HR_TeamGroup teamgroup");
        sb.append(" inner join T_HR_TeamGropupPerson tp on tp.FTeamGroupID = teamgroup.FID");
        sb.append(" inner join T_BD_Person person on tp.FPersonID = person.FID");
        sb.append(" where tp.FIsPrimary = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String id = null;
            String name = null;
            if (idSet == null) {
                while (rowSet.next()) {
                    id = rowSet.getString("ID");
                    name = map.get(id) != null ? map.get(id).toString() + ";" + rowSet.getString("NAME") : rowSet.getString("NAME");
                    map.put(id, name);
                }
            } else {
                while (rowSet.next()) {
                    id = rowSet.getString("ID");
                    if (!idSet.contains(id)) continue;
                    name = map.get(id) != null ? map.get(id).toString() + ";" + rowSet.getString("NAME") : rowSet.getString("NAME");
                    map.put(id, name);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return map;
    }
}

