/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CmpDateUtils {
    public static int getWorkDayOfMonth(Date date, int afterMonth) {
        Calendar gc = Calendar.getInstance();
        gc.add(2, afterMonth);
        Date newDate = gc.getTime();
        return CmpDateUtils.getWorkDayOfMonth(newDate);
    }

    public static int getWorkDayOfMonth(Date date) {
        Date sDate = CmpDateUtils.getFirstDateOfMonth(date);
        Date eDate = CmpDateUtils.getEndDateOfMonth(date);
        return CmpDateUtils.getWorkDayOfMonth(sDate, eDate);
    }

    public static int getWorkDayOfMonth(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return 0;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(startDate);
        int workDays = 0;
        int days = CmpDateUtils.subTwoDate(endDate, startDate) + 1;
        for (int i = 0; i < days; ++i) {
            if (gc.get(7) != 7 && gc.get(7) != 1) {
                ++workDays;
            }
            ((Calendar)gc).add(5, 1);
        }
        return workDays;
    }

    public static int getDayOfMonth(Date date) {
        Date sDate = CmpDateUtils.getFirstDateOfMonth(date);
        Date eDate = CmpDateUtils.getEndDateOfMonth(date);
        return CmpDateUtils.getDayOfMonth(sDate, eDate);
    }

    public static int getDayOfMonth(Date date, int afterMonth) {
        Calendar gc = Calendar.getInstance();
        gc.add(2, afterMonth);
        Date newDate = gc.getTime();
        return CmpDateUtils.getDayOfMonth(newDate);
    }

    public static int getDayOfMonth(Date sdate, Date edate) {
        return CmpDateUtils.subTwoDate(edate, sdate) + 1;
    }

    public static int subTwoDate(Date edate, Date sdate) {
        if (edate == null || sdate == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long slong = cal.getTimeInMillis();
        cal.setTime(edate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long elong = cal.getTimeInMillis();
        return (int)((elong - slong) / 86400000L);
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return CmpDateUtils.getDate(calendar.get(1), calendar.get(2) + 1, 1);
    }

    public static Date getEndDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastDay = CmpDateUtils.getLastDayOfMonth(date);
        return CmpDateUtils.getDate(calendar.get(1), calendar.get(2) + 1, lastDay);
    }

    private static int getLastDayOfMonth(Date date) {
        int lastDay = 0;
        int year = date.getYear() + 1900;
        int month = date.getMonth() + 1;
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            lastDay = 31;
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            lastDay = 30;
        } else if (month == 2) {
            GregorianCalendar leapYearCalendar = new GregorianCalendar();
            lastDay = leapYearCalendar.isLeapYear(year) ? 29 : 28;
        }
        return lastDay;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, 0, 0, 0);
        return CmpDateUtils.truncate(cal.getTime());
    }

    public static Date truncate(Date date) {
        date = new Date(date.getTime() / 1000L * 1000L);
        return date;
    }

    public static void setColumnDateFormat(KDTable kdTable, String[] columns) {
        int len = columns.length;
        for (int i = 0; i < len; ++i) {
            CmpDateUtils.setColumnDateFormat(kdTable, columns[i]);
        }
    }

    public static void setColumnDateTimeFormat(KDTable kdTable, String[] columns) {
        int len = columns.length;
        for (int i = 0; i < len; ++i) {
            CmpDateUtils.setColumnDateTimeFormat(kdTable, columns[i]);
        }
    }

    public static void setColumnDateFormat(KDTable kdTable, String column) {
        String dtFormat = CtrlFormatUtilities.getDateFormatString();
        if (!StringUtils.isEmpty((String)column) && kdTable != null && kdTable.getColumn(column) != null) {
            kdTable.getColumn(column).getStyleAttributes().setNumberFormat(dtFormat);
        }
    }

    public static void setColumnDateTimeFormat(KDTable kdTable, String column) {
        String dtFormat = CtrlFormatUtilities.getDateTimeFormatString();
        if (!StringUtils.isEmpty((String)column) && kdTable != null && kdTable.getColumn(column) != null) {
            kdTable.getColumn(column).getStyleAttributes().setNumberFormat(dtFormat);
        }
    }

    public static void setColumnNumberFormat(KDTable kdTable, String[] columns, int scale) {
        int i;
        String numberFormat = CtrlFormatUtilities.getDecimalFormatString();
        if (scale > 0) {
            numberFormat = numberFormat.indexOf(".") != -1 ? numberFormat.substring(0, numberFormat.indexOf(".") + 1) : numberFormat + ".";
            for (i = 0; i < scale; ++i) {
                numberFormat = numberFormat + "0";
            }
        }
        int len = columns.length;
        for (i = 0; i < len; ++i) {
            kdTable.getColumn(columns[i]).getStyleAttributes().setNumberFormat(numberFormat);
        }
    }

    public static void setColumnNumberFormat(KDTable kdTable, String[] columns) {
        String numberFormat = CtrlFormatUtilities.getDecimalFormatString();
        int len = columns.length;
        for (int i = 0; i < len; ++i) {
            kdTable.getColumn(columns[i]).getStyleAttributes().setNumberFormat(numberFormat);
        }
    }
}

