/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryCollection;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryFactory;
import com.kingdee.eas.hr.compensation.DeptSchemeEntryInfo;
import com.kingdee.eas.hr.compensation.DeptSchemeInfo;
import com.kingdee.eas.hr.compensation.IDeptSchemeEntry;
import com.kingdee.eas.hr.compensation.TeamGroupInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeptInnerSchemePersonHisUtils {
    private static Logger logger = Logger.getLogger(DeptInnerSchemePersonHisUtils.class);

    public static boolean isExitHis(Context ctx, String deptEntryID) throws BOSException, SQLException {
        String sql = "select count(FID) from T_HR_DeptInnerSchemePersonInfo where FDeptInnerSchemeID='" + deptEntryID.trim() + "'";
        IRowSet irs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rows = 0;
        if (irs.next()) {
            rows = irs.getInt(1);
        }
        return rows > 0;
    }

    public static void savePersonHisByEntryAndInner(Context ctx, String strEntryID, boolean isTeamG) throws BOSException, EASBizException {
        String oql = "SELECT *,teamGroup.id,adminOrgUnit.*,deptScheme.personRange,deptScheme.cmpScheme.id WHERE id='" + strEntryID + "'";
        IDeptSchemeEntry iDeptSchemeEntry = DeptSchemeEntryFactory.getLocalInstance(ctx);
        DeptSchemeEntryInfo deptSchemeEntryInfo = iDeptSchemeEntry.getDeptSchemeEntryInfo(oql);
        CmpSchemeInfo cmpSchemInfo = deptSchemeEntryInfo.getDeptScheme().getCmpScheme();
        boolean isPersonRange = deptSchemeEntryInfo.getDeptScheme().isPersonRange();
        if (isTeamG) {
            TeamGroupInfo tgi = deptSchemeEntryInfo.getTeamGroup();
            DeptInnerSchemePersonHisUtils.savePersonToDeptInnerSchemeHisByTeam(ctx, strEntryID, tgi);
        } else {
            AdminOrgUnitInfo adminOrgUnitInfoTem = deptSchemeEntryInfo.getAdminOrgUnit();
            DeptInnerSchemePersonHisUtils.savePersonToDeptInnerSchemeHisByAdmin(ctx, strEntryID, adminOrgUnitInfoTem, isPersonRange, deptSchemeEntryInfo.isHasSubDept(), cmpSchemInfo);
        }
    }

    public static void savePersonToDeptInnerSchemeHisByAdmin(Context ctx, String deptEntryId, AdminOrgUnitInfo adminOrgUnitInfo, boolean isPersonRange, boolean isHasSub, CmpSchemeInfo cmpSchemeInfo) throws BOSException {
        EntityViewInfo entityViewInfo = DeptInnerSchemePersonHisUtils.getEntityViewOfCurrentPerson(adminOrgUnitInfo, isHasSub);
        if (isPersonRange) {
            DeptInnerSchemePersonHisUtils.addCmpSchemeFilter(entityViewInfo, cmpSchemeInfo);
        }
        String metadataStr = "com.kingdee.eas.hr.compensation.app.DepReleaseSchemePersonQuery";
        String personDataSql = DeptInnerSchemePersonHisUtils.getPerson(ctx, entityViewInfo, metadataStr);
        String insertSql = "insert into T_HR_DeptInnerSchemePersonInfo(fid,FDeptInnerSchemeID,FPersonID,FPositionID,fAdminOrgUnitID,FJobGradeID,FDiplomaID)select newbosid('CEF435BB'),'" + deptEntryId + "',\"ID\", \"PRIMARYPOSITION.ID\",\"ADMINORGUNIT.ID\",\"JOBGRADE.ID\", \"DIPLOMA.ID\"    from (" + personDataSql + ") as PERSONDATATEMP";
        DbUtil.execute((Context)ctx, (String)insertSql);
    }

    public static void savePersonToDeptInnerSchemeHisByTeam(Context ctx, String deptEntryId, TeamGroupInfo tgi) throws BOSException {
        EntityViewInfo entityViewInfo = DeptInnerSchemePersonHisUtils.getEntityViewOfCurrentPersonByTeam(tgi);
        String metadataStr = "com.kingdee.eas.hr.compensation.app.DepReleaseSchemePersonQuery";
        String personDataSql = DeptInnerSchemePersonHisUtils.getPerson(ctx, entityViewInfo, metadataStr);
        String insertSql = "insert into T_HR_DeptInnerSchemePersonInfo(fid,FDeptInnerSchemeID,FPersonID,FPositionID,fAdminOrgUnitID,FJobGradeID,FDiplomaID)select newbosid('CEF435BB'),'" + deptEntryId + "',\"ID\", \"PRIMARYPOSITION.ID\",\"ADMINORGUNIT.ID\",\"JOBGRADE.ID\", \"DIPLOMA.ID\"    from (" + personDataSql + ") as PERSONDATATEMP";
        DbUtil.execute((Context)ctx, (String)insertSql);
    }

    public static EntityViewInfo getEntityViewOfCurrentPersonByTeam(TeamGroupInfo tgi) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String sql = " select tp.FPersonID from T_HR_TeamGropupPerson  tp where tp.FTeamGroupID='" + tgi.getId().toString() + "'";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("PersonCmp.isPayPerson", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        filter.setMaskString("#0 and #1");
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    public static String getPerson(Context ctx, EntityViewInfo entityViewInfo, String metadataStr) throws BOSException {
        MetaDataPK metadataPK = new MetaDataPK(metadataStr);
        IQueryExecutor queryExec = null;
        queryExec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)metadataPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        queryExec.setObjectView(entityViewInfo);
        return queryExec.getSQL();
    }

    public static EntityViewInfo getEntityViewOfCurrentPerson(AdminOrgUnitInfo adminOrgUnitInfo, boolean isHasSub) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String maskStr = "";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("PersonCmp.isPayPerson", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)adminOrgUnitInfo.getLongNumber()));
        if (isHasSub) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            maskStr = "#0 and (#1 or #2)";
        } else {
            maskStr = "#0 and #1";
        }
        filter.setMaskString(maskStr);
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    public static DeptSchemeEntryInfo getDeptSchemeEntryInfo(DeptSchemeInfo deptSchemeInfo, CmpPeriodInfo cmpPeriodInfo, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException {
        if (deptSchemeInfo.isEmpty() || cmpPeriodInfo.isEmpty() || adminOrgUnitInfo.isEmpty()) {
            return new DeptSchemeEntryInfo();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("deptInnerScheme.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parentNode.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("deptScheme", (Object)deptSchemeInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpPeriod", (Object)cmpPeriodInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit", (Object)adminOrgUnitInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)false));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("isParentNode", (Object)false));
        filterInfo.setMaskString("#0 AND #1 AND #2 AND (#3 OR (#4 AND #5))");
        entityViewInfo.setFilter(filterInfo);
        DeptSchemeEntryCollection deptSchemeEntityCollection = DeptSchemeEntryFactory.getRemoteInstance().getDeptSchemeEntryCollection(entityViewInfo);
        DeptSchemeEntryInfo deptSchemeEntryInfoGolTemp = null;
        if (deptSchemeEntityCollection.size() > 0) {
            deptSchemeEntryInfoGolTemp = deptSchemeEntityCollection.get(0);
        }
        return deptSchemeEntryInfoGolTemp;
    }

    public static Map getDeptSchemeEntryInfoByList(DeptSchemeInfo deptSchemeInfo, List cmpPeriodList, List adminOrgUnitList) throws BOSException {
        if (deptSchemeInfo.isEmpty() || cmpPeriodList.size() <= 0 || adminOrgUnitList.size() <= 0) {
            return new HashMap();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("cmpPeriod.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("parentNode.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("deptScheme", (Object)deptSchemeInfo.getId().toString()));
        StringBuffer maskString = new StringBuffer("#0 AND ");
        int countPer = 0;
        int countAdmin = 0;
        boolean countAll = false;
        int size = adminOrgUnitList.size();
        for (int i = 0; i < size; ++i) {
            int sum = cmpPeriodList.size();
            for (int j = 0; j < sum; ++j) {
                filterInfo.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", cmpPeriodList.get(j)));
                ++countPer;
                filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", adminOrgUnitList.get(i)));
                ++countAdmin;
                if (adminOrgUnitList.size() == 1 && cmpPeriodList.size() == 1) {
                    maskString.append("(#").append(countPer).append(" and ").append("#").append(countAdmin).append(")");
                    continue;
                }
                if (i != 0 || j != 0) {
                    if (i == size - 1 && j == sum - 1) {
                        maskString.append(" or (#").append(2 * countPer - 1).append(" and ").append("#").append(2 * countAdmin).append(")");
                        maskString.append(")");
                        continue;
                    }
                    maskString.append(" or (#").append(2 * countPer - 1).append(" and ").append("#").append(2 * countAdmin).append(")");
                    continue;
                }
                maskString.append("( (#").append(2 * countPer - 1).append(" and ").append("#").append(2 * countAdmin).append(")");
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)false));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMulSentFlag", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("isParentNode", (Object)false));
        maskString.append(" and (#").append(2 * countPer + 1).append(" or (#").append(2 * countPer + 2).append(" and #").append(2 * countPer + 3).append("))");
        filterInfo.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filterInfo);
        DeptSchemeEntryCollection deptSchemeEntityCollection = DeptSchemeEntryFactory.getRemoteInstance().getDeptSchemeEntryCollection(entityViewInfo);
        DeptSchemeEntryInfo deptSchemeEntryInfoGolTemp = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int size2 = deptSchemeEntityCollection.size();
        for (int i = 0; i < size2; ++i) {
            deptSchemeEntryInfoGolTemp = deptSchemeEntityCollection.get(i);
            map.put(deptSchemeEntryInfoGolTemp.getAdminOrgUnit().getId().toString() + "@@" + deptSchemeEntryInfoGolTemp.getCmpPeriod().getId().toString(), deptSchemeEntryInfoGolTemp.getId().toString());
        }
        return map;
    }

    public static String getPersonNotInSchemeInDept(DeptSchemeInfo deptSchemeInfo) {
        String language = SysContext.getSysContext().getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select p.fid as personID,p.fnumber as personNumber,p.fname_").append(language).append(" as personName from t_bd_person p ");
        sql.append(" where p.fid in(");
        if (2 == deptSchemeInfo.getAssignType().getValue()) {
            sql.append(" select distinct groupPer.Fpersonid ");
            sql.append(" from T_HR_DeptSchemeEntry as dse ");
            sql.append("  inner join t_hr_teamgroup as team on team.fid = dse.fteamgroupid");
            sql.append("  inner join t_hr_teamgropupperson as groupPer on groupPer.Fteamgroupid = team.fid ");
            sql.append("   where dse.FDeptSchemeID ='").append(deptSchemeInfo.getId()).append("'");
        } else {
            sql.append(" select distinct per.fid ");
            sql.append(" from T_BD_Person as per  ");
            sql.append(" inner join T_HR_PersonCmp as perCmp on per.fid = perCmp.Fpersonid ");
            sql.append(" left outer join T_HR_PersonPosition as position on per.fid =position.FPersonID  ");
            sql.append(" inner join T_ORG_Admin as adminOrg on position.FPersonDep = adminOrg.Fid  ");
            sql.append(" inner join T_HR_BDEmployeeType as et on et.Fid = per.femployeetypeid  ");
            sql.append(" where perCmp.Fispayperson=1 ");
            sql.append(" and (adminDdORadminLongNumber)");
        }
        sql.append(" )");
        sql.append(" and p.fid not in(");
        sql.append(" \t\tselect distinct cmpPerson.Fpersonid from T_HR_CMPSCHEMEPERSON cmpPerson");
        sql.append(" where cmpPerson.Fcmpschemeid = '").append(deptSchemeInfo.getCmpScheme().getId()).append("'");
        sql.append(" and cmpPerson.FisDelete =0");
        sql.append(" )");
        return sql.toString();
    }

    public static String getPersonNotInSchemeInDept(DeptSchemeEntryInfo entryInfo) {
        String language = SysContext.getSysContext().getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" select p.fid as personid,p.fnumber as personNumber,p.fname_").append(language).append(" as personName from t_bd_person as p ");
        sql.append(" where p.fid in(");
        if (entryInfo.getTeamGroup() != null) {
            sql.append(" select distinct groupPer.Fpersonid ");
            sql.append("  from t_hr_teamgroup as team ");
            sql.append("  inner join t_hr_teamgropupperson as groupPer on groupPer.Fteamgroupid = team.fid ");
            sql.append("   where team.fid ='").append(entryInfo.getTeamGroup().getId()).append("'");
        } else if (entryInfo.getAdminOrgUnit() != null) {
            sql.append(" select per.fid ");
            sql.append(" from T_BD_Person as per  ");
            sql.append(" inner join T_HR_PersonCmp as perCmp on per.fid = perCmp.Fpersonid ");
            sql.append(" left outer join T_HR_PersonPosition as position on per.fid =position.FPersonID  ");
            sql.append(" inner join T_ORG_Admin as adminOrg on position.FPersonDep = adminOrg.Fid  ");
            sql.append(" inner join T_HR_BDEmployeeType as et on et.Fid = per.femployeetypeid  ");
            sql.append(" where perCmp.Fispayperson=1 ");
            sql.append(" and adminOrg.Fid = '").append(entryInfo.getAdminOrgUnit().getId()).append("'");
            sql.append(" and (adminOrg.Flongnumber = '").append(entryInfo.getAdminOrgUnit().getLongNumber()).append("'");
            if (entryInfo.isHasSubDept()) {
                sql.append(" or adminOrg.Flongnumber like '").append(entryInfo.getAdminOrgUnit().getLongNumber()).append("!%'");
            }
            sql.append(")");
        }
        sql.append(")");
        sql.append(" and p.fid not in(");
        sql.append(" \t\tselect distinct cmpPerson.Fpersonid from T_HR_CMPSCHEMEPERSON cmpPerson");
        sql.append(" where cmpPerson.Fcmpschemeid = '");
        if (entryInfo.getCmpScheme() != null) {
            sql.append(entryInfo.getCmpScheme().getId());
        } else if (entryInfo.getDeptScheme() != null && entryInfo.getDeptScheme().getCmpScheme() != null) {
            sql.append(entryInfo.getDeptScheme().getCmpScheme().getId());
        }
        sql.append("'");
        sql.append(" and cmpPerson.FisDelete =0");
        sql.append(" )");
        return sql.toString();
    }

    public static void addNoPositionPerFilter(EntityViewInfo viewInfo, CmpSchemeInfo cmpSchemeInfo) {
        String oql = DeptInnerSchemePersonHisUtils.addCmpSchemeFilter(cmpSchemeInfo);
        FilterInfo filterInfoTemp = new FilterInfo();
        filterInfoTemp.getFilterItems().add(new FilterItemInfo("PM.isPrimary", (Object)"1"));
        filterInfoTemp.getFilterItems().add(new FilterItemInfo("PrimaryPosition.id", null));
        filterInfoTemp.getFilterItems().add(new FilterItemInfo("person.id", (Object)oql, CompareType.INNER));
        filterInfoTemp.setMaskString("(#0 or (#1 and #2))");
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(filterInfoTemp);
        } else {
            try {
                viewInfo.getFilter().mergeFilter(filterInfoTemp, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public static void addCmpSchemeFilter(EntityViewInfo viewInfo, CmpSchemeInfo cmpSchemeInfo) {
        String oql = DeptInnerSchemePersonHisUtils.addCmpSchemeFilter(cmpSchemeInfo);
        FilterInfo filterInfoTemp = new FilterInfo();
        filterInfoTemp.getFilterItems().add(new FilterItemInfo("person.id", (Object)oql, CompareType.INNER));
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(filterInfoTemp);
        } else {
            try {
                viewInfo.getFilter().mergeFilter(filterInfoTemp, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private static String addCmpSchemeFilter(CmpSchemeInfo cmpSchemeInfo) {
        String oql = "select fpersonid from t_hr_cmpschemeperson where fcmpschemeid ='" + cmpSchemeInfo.getId().toString() + "' and FisDelete =0";
        return oql;
    }
}

