/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.CmpSystemConfigFactory;
import com.kingdee.eas.hr.base.CmpSystemConfigInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.ICmpSystemConfig;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemCollection;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemFactory;
import com.kingdee.eas.hr.compensation.CmpAdjSchItemInfo;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpAdjustSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpItemCollection;
import com.kingdee.eas.hr.compensation.CmpItemFactory;
import com.kingdee.eas.hr.compensation.CmpItemInfo;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeItemFactory;
import com.kingdee.eas.hr.compensation.CommonPermissionFacadeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeException;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemeInfo;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonCollection;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonFactory;
import com.kingdee.eas.hr.compensation.FixedCmpSchemePersonInfo;
import com.kingdee.eas.hr.compensation.GrantTypeEnum;
import com.kingdee.eas.hr.compensation.GroupSummaryFacadeFactory;
import com.kingdee.eas.hr.compensation.HRParameterEnum;
import com.kingdee.eas.hr.compensation.HRParameterFactory;
import com.kingdee.eas.hr.compensation.HRParameterInfo;
import com.kingdee.eas.hr.compensation.HRParseException;
import com.kingdee.eas.hr.compensation.ICmpAdjSchItem;
import com.kingdee.eas.hr.compensation.ICmpItem;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.compensation.ICmpSchemeItem;
import com.kingdee.eas.hr.compensation.IFixedCmpScheme;
import com.kingdee.eas.hr.compensation.IFixedCmpSchemePerson;
import com.kingdee.eas.hr.compensation.IHRParameter;
import com.kingdee.eas.hr.compensation.ISalaraitCmpPersonItemProps;
import com.kingdee.eas.hr.compensation.ISalariatScheme;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemObjectTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.compensation.ItemTypeEnum;
import com.kingdee.eas.hr.compensation.ItemUsedEnum;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsCollection;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsFactory;
import com.kingdee.eas.hr.compensation.SalaraitCmpPersonItemPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatHiberPropsInfo;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemCollection;
import com.kingdee.eas.hr.compensation.SalariatMapPersonItemFactory;
import com.kingdee.eas.hr.compensation.SalariatPointPropsCollection;
import com.kingdee.eas.hr.compensation.SalariatPointPropsFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeFacadeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeFactory;
import com.kingdee.eas.hr.compensation.SalariatSchemeInfo;
import com.kingdee.eas.hr.compensation.StateEnum;
import com.kingdee.eas.hr.compensation.util.CopyToSelect;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class HRUtils {
    private static Logger logger = Logger.getLogger(HRUtils.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.hr.compensation.client.SalariatResource";
    public static final String COLUMN_PREFIX = "F";
    public static final String COLUMN_KEY = "FID";
    public static final String COLUMN_POINT = "FPointID";
    public static final String AFFAIR = "AFFAIR";
    public static final String COLUMN_PERSON_MAP = "FPersonMapID";
    public static final String COLUMN_MAP_PERSON_SCHM = "FSalSchmID";
    public static final String COLUMN_MAP_PERSON_GENDER = "FPER010";
    public static final String COLUMN_MAP_PERSON_WOKEAGE = "FPER015";
    public static final String F_ADMINORG_UNIT_ID = "fAdminOrgUnitID";
    public static final String EFFECT_DATE = "EFFECT_DATE";
    public static final int COLDIR = 1;
    public static final int ROWDIR = 0;
    public static final String NULLUUID = "00000000-0000-0000-0000-00000000000000000000";
    public static final String SELECTADJCMPSCHUIPARM = "SELECTADJCMPSCHUIPARM";
    public static final String ADJUSTSCHEMEEDITUIPARM = "ADJUSTSCHEMEEDITUIPARM";
    public static final String SELECTCMPITEMUIPARAM = "SELECTCMPITEMUIPARAM";
    public static final String EMPTRANSFORMDATE = "EMPTRANSFORMDATE";
    public static final String SELECTEDSCHNAME = "SELECTEDSCHNAME";
    public static final String SCHEME_ID = "schemeID";
    public static final String MAP_PERSON = "map_person";
    public static final String TABLE_MAP_PERSON = "T_HR_SALMAPPERITM";
    public static final String TABLE_MAP_PERSON_SCHM = "salSchm";
    public static final String DATEFORMAT = "yyyy-m-d";
    private static final String delim = ":";
    private static final String leftDelim = "(";
    private static final String rightDelim = ")";
    public static final Locale locale_l1 = new Locale("l1", "");
    public static final Locale locale_L1 = new Locale("L1", "");
    public static final Locale locale_en_US = new Locale("en", "US");
    public static final Locale locale_l2 = new Locale("l2", "");
    public static final Locale locale_L2 = new Locale("L2", "");
    public static final Locale locale_zh_CN = new Locale("zh", "CN");
    public static final Locale locale_l3 = new Locale("l3", "");
    public static final Locale locale_L3 = new Locale("L3", "");
    public static final Locale locale_zh_TW = new Locale("zh", "TW");
    public static final Locale locale_en = new Locale("en", "");

    public static String getSalariatResourceStr(String n) {
        return EASResource.getString((String)RESOURCE_PATH, (String)n);
    }

    public static String getCurrentCUID() {
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        return cu.getId().toString();
    }

    public static String getCurrentCUID(Context ctx) {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return cu.getId().toString();
    }

    public static boolean isEqual(Object objA, Object objB) {
        if (objA == objB) {
            return true;
        }
        if (objA == null && objB != null || objA != null && objB == null) {
            return false;
        }
        if (objA instanceof CoreBaseInfo && objB instanceof CoreBaseInfo) {
            CoreBaseInfo obj1 = (CoreBaseInfo)objA;
            CoreBaseInfo obj2 = (CoreBaseInfo)objB;
            return obj1.getId().equals((Object)obj2.getId());
        }
        if (objA instanceof BigDecimal && objB instanceof BigDecimal) {
            BigDecimal big1 = (BigDecimal)objA;
            BigDecimal big2 = (BigDecimal)objB;
            return big1.compareTo(big2) == 0;
        }
        return objA.equals(objB);
    }

    public static DefaultKingdeeTreeNode getSelectTreeNode(KDTree tree) {
        TreePath path;
        DefaultKingdeeTreeNode selectNode = null;
        if (tree != null && (path = tree.getSelectionPath()) != null) {
            selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        }
        return selectNode;
    }

    public static String getParamterValue(HRParameterEnum paramType) throws Exception {
        return HRParameterFactory.getRemoteInstance().getParamterValue(paramType);
    }

    public static GrantTypeEnum getGrantHRParamterValue(Context ctx) throws Exception {
        IParamControl iParam = null;
        String HRO_ID = null;
        if (ctx == null) {
            iParam = ParamControlFactory.getRemoteInstance();
            HRO_ID = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        } else {
            iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            HRO_ID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        }
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), "hr_cmp_001");
        int grantType = 0;
        if (val != null && !"".equals(val)) {
            grantType = Integer.parseInt(val);
        }
        return GrantTypeEnum.getEnum(grantType);
    }

    public static String getCompSqlByAdmin(String sqlAdmin) {
        String sqlCompId = " SELECT distinct r.FToUnitID as companyId FROM T_ORG_UNITRELATION R   INNER JOIN T_ORG_ADMIN A ON R.FFROMUNITID = A.FID   INNER JOIN T_ORG_Company H ON H.FID = R.FTOUNITID   WHERE r.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000010FE9F8B5'  AND  r.FFromUnitID in(" + sqlAdmin + ") ";
        return sqlCompId;
    }

    public static String getSqlAdminByComp(String compId) {
        String sqlCompId = " SELECT r.FFromUnitID as adminId FROM T_ORG_UNITRELATION R   INNER JOIN T_ORG_ADMIN A ON R.FFROMUNITID = A.FID   INNER JOIN T_ORG_Company H ON H.FID = R.FTOUNITID   WHERE r.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000010FE9F8B5'  AND  r.FToUnitID in('" + compId + "') ";
        return sqlCompId;
    }

    public static boolean updateParamterValue(HRParameterEnum paramType, String newValue) throws Exception {
        return HRParameterFactory.getRemoteInstance().updateParamterValue(paramType, newValue);
    }

    public static void initParameters() throws Exception {
        IHRParameter iBiz = HRParameterFactory.getRemoteInstance();
        HRParameterInfo info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.SCHM_TABLE_PREFIX);
        info.setValue("T_HR_SCHM_");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.SCHM_TABLE_SUFFIX);
        info.setValue("1");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.SAL_POINT_TABLE_PREFIX);
        info.setValue("T_HR_SALP_");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.SAL_POINT_TABLE_SUFFIX);
        info.setValue("1");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.SAL_POINTGRADE_TABLE_PREFIX);
        info.setValue("T_HR_SALG_");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.SAL_POINTGRADE_TABLE_SUFFIX);
        info.setValue("1");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.CMPITEMCAT_SUFFIX);
        info.setValue("100");
        iBiz.addnew(info);
        info = new HRParameterInfo();
        info.setNumber(HRParameterEnum.CMPITEM_SUFFIX);
        info.setValue("200");
        iBiz.addnew(info);
    }

    public static CmpItemCollection getCmpItemsByScheme(String schemeID) throws Exception {
        return HRUtils.getCmpItemsByScheme(null, schemeID);
    }

    public static CmpItemCollection getCmpItemsByScheme(Context ctx, String schemeID) throws Exception {
        EntityViewInfo view;
        SalariatSchemeInfo salariatSchemeInfo;
        CmpItemCollection items = new CmpItemCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpItemsQuery");
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        String hrUnitID = null;
        if (ctx == null) {
            if (SysContext.getSysContext().getCurrentHRUnit() != null) {
                hrUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            } else {
                salariatSchemeInfo = SalariatSchemeFactory.getRemoteInstance().getSalariatSchemeInfo("select id,hrOrgUnit.id,hrOrgUnit.name where id = '" + schemeID + "'");
                hrUnitID = salariatSchemeInfo.getHrOrgUnit().getId().toString();
            }
        } else if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            hrUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        } else {
            salariatSchemeInfo = SalariatSchemeFactory.getLocalInstance(ctx).getSalariatSchemeInfo("select id,hrOrgUnit.id,hrOrgUnit.name where id = '" + schemeID + "'");
            hrUnitID = salariatSchemeInfo.getHrOrgUnit().getId().toString();
        }
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(hrUnitID);
        CmpItemCollection cmpcols = null;
        if (ctx == null) {
            view = CommonPermissionFacadeFactory.getRemoteInstance().getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            if (view.toString().indexOf("hrOrgUnit.id") != -1 && view.getFilter().getFilterItems().size() > 1) {
                cmpcols = CmpItemFactory.getRemoteInstance().getCmpItemCollection(view);
            }
        } else {
            view = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            if (view.toString().indexOf("hrOrgUnit.id") != -1 && view.getFilter().getFilterItems().size() > 1) {
                cmpcols = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(view);
            }
        }
        if (cmpcols != null) {
            StringBuffer cmpItemids = new StringBuffer();
            int size = cmpcols.size();
            for (int i = 0; i < size; ++i) {
                cmpItemids.append("'");
                cmpItemids.append(cmpcols.get(i).getId().toString());
                cmpItemids.append("',");
            }
            if (cmpItemids.lastIndexOf(",") != -1) {
                cmpItemids.deleteCharAt(cmpItemids.length() - 1).toString();
            }
            if (cmpItemids.length() > 0) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("item.id", (Object)cmpItemids, CompareType.INNER));
                filterInfoItem.mergeFilter(fi, "and");
            }
        }
        entityView.setFilter(filterInfoItem);
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        Object cmpItem = null;
        while (selectItemRowSet.next()) {
            items.add(HRUtils.getItemInfo(selectItemRowSet));
        }
        return items;
    }

    public static CmpItemCollection getCmpItemsBySchem(Context ctx, String schemeID) throws Exception {
        CmpItemCollection items = new CmpItemCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpItemsQuery");
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        entityView.setFilter(filterInfoItem);
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        while (selectItemRowSet.next()) {
            items.add(HRUtils.getItemInfo(selectItemRowSet));
        }
        return items;
    }

    private static boolean isUseSalariat() throws Exception {
        boolean result = false;
        IHRInit tt = HRInitFactory.getRemoteInstance();
        if (tt.getSPSchema() == 1) {
            result = true;
        }
        return result;
    }

    public static CmpItemCollection getCmpItemCollection() throws Exception {
        ICmpItem iCmpItem = CmpItemFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        evi.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("defaultOrder");
        sorterOrderItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterOrderItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("cmpItemCatalog.*"));
        CmpItemCollection temp = iCmpItem.getCmpItemCollection(evi);
        CmpItemCollection colCmpItem = new CmpItemCollection();
        CmpItemInfo info = null;
        int size = temp.size();
        for (int i = 0; i < size; ++i) {
            info = temp.get(i);
            if (info.getEnable() == null || info.getEnable().getValue() != 1) continue;
            colCmpItem.add(info);
        }
        return colCmpItem;
    }

    public static CmpItemCollection getPersonItemsByScheme(String schemeID) throws Exception {
        return HRUtils.getPersonItemsByScheme(null, schemeID);
    }

    public static CmpItemCollection getPersonItemsByScheme(Context ctx, String schemeID) throws Exception {
        CmpItemCollection items = new CmpItemCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpPersonItemsQuery");
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        String cmpItemids = HRUtils.getCmpItemIds(ctx);
        if (cmpItemids != null && cmpItemids.length() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("item.id", (Object)cmpItemids, CompareType.INNER));
            filterInfoItem.mergeFilter(fi, "and");
        }
        entityView.setFilter(filterInfoItem);
        SorterItemCollection sortCollection = entityView.getSorter();
        sortCollection.add(new SorterItemInfo("seq"));
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        while (selectItemRowSet.next()) {
            items.add(HRUtils.getItemInfo(selectItemRowSet));
        }
        return items;
    }

    public static CmpItemCollection getPersonItemsBySchem(Context ctx, String schemeID) throws Exception {
        CmpItemCollection items = new CmpItemCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.compensation.app.SalSchCmpPersonItemsQuery");
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        entityView.setFilter(filterInfoItem);
        SorterItemCollection sortCollection = entityView.getSorter();
        sortCollection.add(new SorterItemInfo("seq"));
        exec.setObjectView(entityView);
        IRowSet selectItemRowSet = exec.executeQuery();
        while (selectItemRowSet.next()) {
            items.add(HRUtils.getItemInfo(selectItemRowSet));
        }
        return items;
    }

    public static boolean isCmpSchemeHaveSysInitedCmpItem(Context ctx, String schemeID) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)schemeID)) {
            return false;
        }
        ICmpSchemeItem cmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)schemeID));
        filter.getFilterItems().add(new FilterItemInfo("cmpItem.type", (Object)10));
        filter.setMaskString("#0 and #1");
        return cmpSchemeItem.exists(filter);
    }

    public static boolean isCmpSchemeHaveFixCurrency(Context ctx, String schemeID) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)schemeID)) {
            return false;
        }
        ICmpSchemeItem cmpSchemeItem = CmpSchemeItemFactory.getLocalInstance(ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)schemeID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.type", (Object)10));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.dataType", (Object)60));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FSAL029", CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FSAL000"));
        filterInfo.getFilterItems().add(new FilterItemInfo("cmpItem.number", (Object)"FPER", CompareType.NOTLIKE));
        filterInfo.setMaskString("#0 and #1 and ((#2 and #3 and #4) or #5) and #6");
        return cmpSchemeItem.exists(filterInfo);
    }

    public static SalariatPointPropsCollection getPointGradeItemsByScheme(String schemeID) throws Exception {
        SalariatPointPropsCollection items = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        view.setFilter(filterInfoItem);
        SorterItemCollection sortCollectiom = view.getSorter();
        sortCollectiom.add(new SorterItemInfo("seq"));
        items = SalariatPointPropsFactory.getRemoteInstance().getSalariatPointPropsCollection(view);
        return items;
    }

    public static SalariatHiberPropsCollection getPointItemsByScheme(String schemeID) throws Exception {
        SalariatHiberPropsCollection collection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("scheme.id"));
        selector.add(new SelectorItemInfo("scheme.name"));
        selector.add(new SelectorItemInfo("scheme.number"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.name"));
        selector.add(new SelectorItemInfo("parent.number"));
        selector.add(new SelectorItemInfo("parent.isLeaf"));
        selector.add(new SelectorItemInfo("parent.level"));
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("scheme.id", (Object)schemeID));
        filterInfoItem.getFilterItems().add(new FilterItemInfo("level", (Object)1));
        filterInfoItem.setMaskString(" #0 and #1 ");
        view.setFilter(filterInfoItem);
        SorterItemCollection sortCollectiom = view.getSorter();
        sortCollectiom.add(new SorterItemInfo("parent.name"));
        sortCollectiom.add(new SorterItemInfo("name"));
        collection = SalariatHiberPropsFactory.getRemoteInstance().getSalariatHiberPropsCollection(view);
        return collection;
    }

    public static SalariatMapPersonItemCollection getMapPersonItemsByScheme(String schemeID) throws Exception {
        SalariatMapPersonItemCollection collection = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = view.getSelector();
        selector.add(new SelectorItemInfo("id"));
        ISalaraitCmpPersonItemProps personPropsBiz = SalaraitCmpPersonItemPropsFactory.getRemoteInstance();
        String oql = "select item.number,item.itemValue where scheme.id='" + schemeID + "'";
        SalaraitCmpPersonItemPropsCollection personPropsCols = personPropsBiz.getSalaraitCmpPersonItemPropsCollection(oql);
        SalaraitCmpPersonItemPropsInfo info = null;
        int size = personPropsCols.size();
        for (int i = 0; i < size; ++i) {
            info = personPropsCols.get(i);
            String itemValue = info.getItem().getItemValue();
            if (itemValue == null || !HRUtils.getCmpItemBOSType(itemValue).equals("10")) {
                selector.add(new SelectorItemInfo(info.getItem().getNumber()));
                continue;
            }
            String dispName = HRUtils.getCmpItemDispName(itemValue);
            if (dispName == null || dispName.length() == 0) {
                selector.add(new SelectorItemInfo(info.getItem().getNumber() + ".name"));
                continue;
            }
            selector.add(new SelectorItemInfo(info.getItem().getNumber() + "." + dispName));
        }
        selector.add(new SelectorItemInfo("salSchm.id"));
        selector.add(new SelectorItemInfo("salSchm.number"));
        selector.add(new SelectorItemInfo("salSchm.name"));
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("salSchm.id", (Object)schemeID));
        filterInfoItem.setMaskString(" #0 ");
        view.setFilter(filterInfoItem);
        collection = SalariatMapPersonItemFactory.getRemoteInstance().getSalariatMapPersonItemCollection(view);
        return collection;
    }

    public static CmpItemInfo getItemInfo(IRowSet selectItemRowSet) throws Exception {
        CmpItemInfo cmpItem = new CmpItemInfo();
        cmpItem.setId(BOSUuid.read((String)selectItemRowSet.getString("item.id")));
        cmpItem.setNumber(selectItemRowSet.getString("item.number"));
        cmpItem.setName(selectItemRowSet.getString("item.name"));
        cmpItem.setEnable(StateEnum.getEnum(selectItemRowSet.getInt("item.enable")));
        cmpItem.setLength(selectItemRowSet.getInt("item.length"));
        cmpItem.setDecDigital(selectItemRowSet.getInt("item.decDigital"));
        cmpItem.setItemValue(selectItemRowSet.getString("item.itemValue"));
        cmpItem.setDefaultOrder(selectItemRowSet.getInt("item.defaultOrder"));
        cmpItem.setType(ItemTypeEnum.getEnum(selectItemRowSet.getInt("item.type")));
        cmpItem.setDataType(ItemDataTypeEnum.getEnum(selectItemRowSet.getInt("item.dataType")));
        cmpItem.setPrecisionType(CmpItemPrecisionTypeEnum.getEnum(selectItemRowSet.getInt("item.precisionType")));
        cmpItem.setSubject(ItemSubjectEnum.getEnum(selectItemRowSet.getInt("item.subject")));
        cmpItem.setUsed(ItemUsedEnum.getEnum(selectItemRowSet.getInt("item.used")));
        return cmpItem;
    }

    public static Map getPointValueMap(String salSchmID) throws Exception {
        ObjectUuidPK schemePK;
        HashMap pointMap = new HashMap();
        if (salSchmID == null) {
            return pointMap;
        }
        ISalariatScheme iBiz = SalariatSchemeFactory.getRemoteInstance();
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)(schemePK = new ObjectUuidPK(BOSUuid.read((String)salSchmID))));
        if (schemeInfo == null) {
            return pointMap;
        }
        if (!StateEnum.ENABLE.equals((Object)schemeInfo.getState())) {
            return pointMap;
        }
        BigDecimal stand = new BigDecimal("1.0");
        if (schemeInfo.isFlagStandardBase()) {
            stand = new BigDecimal(schemeInfo.getStandardBase());
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<IntEnum> columnTypes = new ArrayList<IntEnum>();
        columnNames.add(COLUMN_POINT);
        columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        CmpItemCollection cmpItems = HRUtils.getCmpItemsByScheme(salSchmID);
        int size = cmpItems.size();
        for (int i = 0; i < size; ++i) {
            columnNames.add(cmpItems.get(i).getNumber());
            columnTypes.add(cmpItems.get(i).getDataType());
        }
        IRowSet rowSet = SalariatSchemeFacadeFactory.getRemoteInstance().getListPointData(schemeInfo.getPointTableName());
        while (rowSet.next()) {
            String pointID = rowSet.getString(COLUMN_POINT);
            HashMap<String, Object> pointValueMap = new HashMap<String, Object>();
            for (int i = 1; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                Object columnType = columnTypes.get(i);
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rowSet.getString(columnName);
                    pointValueMap.put(columnName, strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rowSet.getBigDecimal(columnName);
                    if (value != null) {
                        pointValueMap.put(columnName, value.multiply(stand).setScale(2, 4));
                        continue;
                    }
                    pointValueMap.put(columnName, null);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rowSet.getInt(columnName);
                pointValueMap.put(columnName, intValue);
            }
            pointMap.put(pointID, pointValueMap);
        }
        return pointMap;
    }

    public static Map getPointValueMap(Context ctx, String salSchmID) throws Exception {
        ObjectUuidPK schemePK;
        HashMap pointMap = new HashMap();
        if (salSchmID == null) {
            return pointMap;
        }
        ISalariatScheme iBiz = SalariatSchemeFactory.getLocalInstance(ctx);
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)(schemePK = new ObjectUuidPK(BOSUuid.read((String)salSchmID))));
        if (schemeInfo == null) {
            return pointMap;
        }
        if (!StateEnum.ENABLE.equals((Object)schemeInfo.getState())) {
            // empty if block
        }
        BigDecimal stand = new BigDecimal("1.0");
        if (schemeInfo.isFlagStandardBase()) {
            stand = new BigDecimal(schemeInfo.getStandardBase());
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<IntEnum> columnTypes = new ArrayList<IntEnum>();
        ArrayList<Integer> columnDecimal = new ArrayList<Integer>();
        columnNames.add(COLUMN_POINT);
        columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        columnDecimal.add(null);
        CmpItemCollection cmpItems = HRUtils.getCmpItemsByScheme(ctx, salSchmID);
        int size = cmpItems.size();
        for (int i = 0; i < size; ++i) {
            columnNames.add(cmpItems.get(i).getNumber());
            columnTypes.add(cmpItems.get(i).getDataType());
            columnDecimal.add(cmpItems.get(i).getDecDigital());
        }
        IRowSet rowSet = SalariatSchemeFacadeFactory.getLocalInstance(ctx).getListPointData(schemeInfo.getPointTableName());
        while (rowSet.next()) {
            String pointID = rowSet.getString(COLUMN_POINT);
            HashMap<String, Object> pointValueMap = new HashMap<String, Object>();
            for (int i = 1; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                Object columnType = columnTypes.get(i);
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rowSet.getString(columnName);
                    pointValueMap.put(columnName, strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rowSet.getBigDecimal(columnName);
                    if (value != null) {
                        if (columnDecimal.get(i) != null) {
                            pointValueMap.put(columnName, value.multiply(stand).setScale((int)Integer.valueOf(columnDecimal.get(i).toString()), 4));
                            continue;
                        }
                        pointValueMap.put(columnName, value.multiply(stand).setScale(2, 4));
                        continue;
                    }
                    pointValueMap.put(columnName, null);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rowSet.getInt(columnName);
                pointValueMap.put(columnName, intValue);
            }
            pointMap.put(pointID, pointValueMap);
        }
        return pointMap;
    }

    public static Map getSalPointValueMap(Context ctx, String salSchmID) throws Exception {
        ObjectUuidPK schemePK;
        HashMap pointMap = new HashMap();
        if (salSchmID == null) {
            return pointMap;
        }
        ISalariatScheme iBiz = SalariatSchemeFactory.getLocalInstance(ctx);
        SalariatSchemeInfo schemeInfo = (SalariatSchemeInfo)iBiz.getValue((IObjectPK)(schemePK = new ObjectUuidPK(BOSUuid.read((String)salSchmID))));
        if (schemeInfo == null) {
            return pointMap;
        }
        if (!StateEnum.ENABLE.equals((Object)schemeInfo.getState())) {
            // empty if block
        }
        BigDecimal stand = new BigDecimal("1.0");
        if (schemeInfo.isFlagStandardBase()) {
            stand = new BigDecimal(schemeInfo.getStandardBase());
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<IntEnum> columnTypes = new ArrayList<IntEnum>();
        ArrayList<Integer> columnDecimal = new ArrayList<Integer>();
        columnNames.add(COLUMN_POINT);
        columnTypes.add(ItemObjectTypeEnum.BIZOBJECT);
        columnDecimal.add(null);
        CmpItemCollection cmpItems = HRUtils.getCmpItemsByScheme(ctx, salSchmID);
        int size = cmpItems.size();
        for (int i = 0; i < size; ++i) {
            columnNames.add(cmpItems.get(i).getNumber());
            columnTypes.add(cmpItems.get(i).getDataType());
            columnDecimal.add(cmpItems.get(i).getDecDigital());
        }
        IRowSet rowSet = SalariatSchemeFacadeFactory.getLocalInstance(ctx).getListPointData(schemeInfo.getPointTableName());
        while (rowSet.next()) {
            String pointID = rowSet.getString(COLUMN_POINT);
            HashMap<String, Object> pointValueMap = new HashMap<String, Object>();
            for (int i = 1; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                Object columnType = columnTypes.get(i);
                if (columnType.equals((Object)ItemDataTypeEnum.STRING)) {
                    String strValue = rowSet.getString(columnName);
                    pointValueMap.put(columnName, strValue);
                    continue;
                }
                if (columnType.equals((Object)ItemDataTypeEnum.FLOAT) || columnType.equals((Object)ItemDataTypeEnum.CURRENCY)) {
                    BigDecimal value = rowSet.getBigDecimal(columnName);
                    if (value != null) {
                        if (columnDecimal.get(i) != null) {
                            pointValueMap.put(columnName, value.multiply(stand).setScale((int)Integer.valueOf(columnDecimal.get(i).toString()), 4));
                            continue;
                        }
                        pointValueMap.put(columnName, value.multiply(stand).setScale(2, 4));
                        continue;
                    }
                    pointValueMap.put(columnName, null);
                    continue;
                }
                if (!columnType.equals((Object)ItemDataTypeEnum.INT)) continue;
                int intValue = rowSet.getInt(columnName);
                pointValueMap.put(columnName, intValue);
            }
            try {
                if (rowSet.getString("FSalPointSalGradeID") != null) {
                    pointMap.put(pointID + "_" + rowSet.getString("FSalPointSalGradeID"), pointValueMap);
                    continue;
                }
                pointMap.put(pointID, pointValueMap);
            }
            catch (SQLException e) {
                pointMap.put(pointID, pointValueMap);
            }
        }
        return pointMap;
    }

    public static String getCmpItemCatNumber() {
        String number = null;
        try {
            IHRParameter iHRParameter = HRParameterFactory.getRemoteInstance();
            String suffix = iHRParameter.getParamterValue(HRParameterEnum.CMPITEMCAT_SUFFIX);
            int int_suffix = Integer.parseInt(suffix);
            String newValue = Integer.valueOf(++int_suffix).toString();
            iHRParameter.updateParamterValue(HRParameterEnum.CMPITEMCAT_SUFFIX, newValue);
            number = COLUMN_PREFIX + suffix;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return number;
    }

    public static String getCmpItemNumber(String numberCat) {
        String number = null;
        try {
            IHRParameter iHRParameter = HRParameterFactory.getRemoteInstance();
            String suffix = iHRParameter.getParamterValue(HRParameterEnum.CMPITEM_SUFFIX);
            int int_suffix = Integer.parseInt(suffix);
            String newValue = Integer.valueOf(++int_suffix).toString();
            iHRParameter.updateParamterValue(HRParameterEnum.CMPITEM_SUFFIX, newValue);
            number = numberCat.equals("FPER") ? numberCat + suffix : COLUMN_PREFIX + numberCat + suffix;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return number;
    }

    public static String getCmpItemBOSType(String itemValue) {
        String[] values = itemValue.split(";");
        return values[0];
    }

    public static String getCmpItemEditor(String itemValue) {
        String[] values = itemValue.split(";");
        return values[1];
    }

    public static String getCmpItemDefaultQuery(String itemValue) {
        String[] values = itemValue.split(";");
        return values[2];
    }

    public static String getCmpItemDispName(String itemValue) {
        String[] values = itemValue.split(";");
        return values[3];
    }

    public static int getNextSelectIndex(KDList lst, int curIndex) {
        int index = 0;
        return index;
    }

    public static String getLocalLang(Context ctx) {
        return ctx.getLocale().getLanguage();
    }

    public static String utilDateToString(Date date) {
        StringBuffer buff = new StringBuffer();
        Date transDate = date;
        if (transDate == null) {
            transDate = new Date(System.currentTimeMillis());
        }
        buff.append(transDate.getYear() + 1900);
        buff.append("-");
        buff.append(transDate.getMonth() + 1);
        buff.append("-");
        buff.append(transDate.getDate());
        return buff.toString();
    }

    public static List subtract(List totalList, List tobeSubList) {
        ArrayList total = new ArrayList();
        total.addAll(totalList);
        if (totalList != null && tobeSubList != null) {
            int size = tobeSubList.size();
            for (int i = 0; i < size; ++i) {
                Object obj = tobeSubList.get(i);
                for (int j = total.size() - 1; j >= 0; --j) {
                    if (!total.get(j).equals(obj)) continue;
                    total.remove(j);
                }
            }
        }
        return total;
    }

    public static List addAll(List totalList, Object[] addElm) {
        if (totalList != null && addElm != null) {
            int size = addElm.length;
            for (int i = 0; i < size; ++i) {
                totalList.add(addElm[i]);
            }
        }
        return totalList;
    }

    public static void setFocusDir(KDTable kDTable, int dir) {
        if (kDTable == null) {
            return;
        }
        kDTable.getSelectManager().setSelectMode(1);
        if (dir == 0) {
            ActionMap actionMap = kDTable.getActionMap();
            actionMap.put("FocusChangeRow", (Action)new KDTFocusChangeAction(kDTable, 0, false));
            actionMap.put("FocusChangeCol", (Action)new KDTFocusChangeAction(kDTable, 0, false));
            actionMap.put("FocusChangeRowReverse", (Action)new KDTFocusChangeAction(kDTable, 0, true));
            actionMap.put("FocusChangeColReverse", (Action)new KDTFocusChangeAction(kDTable, 0, true));
        } else if (dir == 1) {
            ActionMap actionMap = kDTable.getActionMap();
            actionMap.put("FocusChangeRow", (Action)new KDTFocusChangeAction(kDTable, 1, false));
            actionMap.put("FocusChangeCol", (Action)new KDTFocusChangeAction(kDTable, 1, false));
            actionMap.put("FocusChangeRowReverse", (Action)new KDTFocusChangeAction(kDTable, 1, true));
            actionMap.put("FocusChangeColReverse", (Action)new KDTFocusChangeAction(kDTable, 1, true));
        }
    }

    public static java.sql.Date getDate(Date date) {
        return new java.sql.Date(date.getYear(), date.getMonth(), date.getDate());
    }

    public static FixedCmpSchemeInfo getFixedCmpScheme(Context ctx) throws EASBizException, BOSException {
        String hroID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        return HRUtils.getFixedCmpScheme(ctx, hroID);
    }

    public static FixedCmpSchemeInfo getFixedCmpScheme(Context ctx, String hroID) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer("SELECT FID,FNumber,FName_");
        sb.append(ctx.getLocale());
        sb.append(",FHorTableName,FSalariatScheme FROM T_HR_FixedCmpScheme ");
        sb.append("WHERE FEnable=1 AND FHROrgUnitID='");
        sb.append(hroID);
        sb.append("'");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rows == null || rows.size() == 0) {
            return null;
        }
        try {
            if (rows.next()) {
                FixedCmpSchemeInfo info = new FixedCmpSchemeInfo();
                info.setId(BOSUuid.read((String)rows.getString(1)));
                info.setNumber(rows.getString(2));
                info.setName(rows.getString(3));
                info.setHorTableName(rows.getString(4));
                if (!StringUtils.isEmpty((String)rows.getString(5))) {
                    SalariatSchemeInfo salarSchemeInfo = new SalariatSchemeInfo();
                    salarSchemeInfo.setId(BOSUuid.read((String)rows.getString(5)));
                    info.setSalariatScheme(salarSchemeInfo);
                } else {
                    info.setSalariatScheme(null);
                }
                return info;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static FixedCmpSchemeInfo getFixedCmpSchemeOFClient() throws EASBizException, BOSException {
        return HRUtils.getFixedCmpSchemeOFClientByHR(null);
    }

    public static FixedCmpSchemeInfo getFixedCmpSchemeOFClientByHR(String strHrOrgUnitId) throws EASBizException, BOSException {
        String oql;
        IFixedCmpScheme ifixed;
        FixedCmpSchemeCollection fixedCollection;
        if (StringUtils.isEmpty((String)strHrOrgUnitId)) {
            strHrOrgUnitId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        }
        if ((fixedCollection = (ifixed = FixedCmpSchemeFactory.getRemoteInstance()).getFixedCmpSchemeCollection(oql = " select id,horTableName,hrOrgUnit.id,enable,salariatScheme.id where enable=1 and hrOrgUnit.id='" + strHrOrgUnitId + "'")) != null && fixedCollection.size() != 0) {
            return fixedCollection.get(0);
        }
        return null;
    }

    public static FixedCmpSchemeInfo getFixedCmpSchemeOFClient(String personId, String strHrOrgUnitId) throws EASBizException, BOSException {
        IFixedCmpSchemePerson iFixedCmpSchemePerson = FixedCmpSchemePersonFactory.getRemoteInstance();
        FixedCmpSchemePersonInfo perInfo = null;
        FixedCmpSchemeInfo info = null;
        String oql = "select fixedCmpScheme.horTableName where person.id = '" + personId + "' and enable = 1 and fixedCmpScheme.enable = 1 and fixedCmpScheme.hrorgunit.id = '" + strHrOrgUnitId + "'";
        FixedCmpSchemePersonCollection fiexedCmpCollection = iFixedCmpSchemePerson.getFixedCmpSchemePersonCollection(oql);
        if (fiexedCmpCollection != null && fiexedCmpCollection.size() > 0 && (perInfo = fiexedCmpCollection.get(0)) != null) {
            info = perInfo.getFixedCmpScheme();
        }
        return info;
    }

    public static FixedCmpSchemeInfo getFixedCmpSchemeOFClient(String personId) throws EASBizException, BOSException {
        String strHrOrgUnitId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        return HRUtils.getFixedCmpSchemeOFClient(personId, strHrOrgUnitId);
    }

    public static FixedCmpSchemeInfo getFixedCmpSchemeEnable(String personId, String strHrOrgUnitId) throws EASBizException, BOSException {
        String fname = "fname_" + SysContext.getSysContext().getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT t1.FID,t1.FNumber,t1.").append(fname).append(",t1.FHorTableName,t1.FSalariatScheme ");
        sb.append(" FROM T_HR_FixedCmpScheme t1 ");
        sb.append(" INNER join T_HR_FixedCmpSchemePerson t2 on t1.fid = t2.ffixedCmpSchemeid ");
        sb.append("WHERE t1.FEnable = 1 and t2.FEnable = 1 AND t1.FHROrgUnitID='").append(strHrOrgUnitId);
        sb.append("' and T2.fpersonid='").append(personId).append("' order by t1.fenableDate desc");
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        if (rows == null || rows.size() == 0) {
            return null;
        }
        try {
            FixedCmpSchemeInfo info = null;
            if (rows.next()) {
                info = new FixedCmpSchemeInfo();
                info.setId(BOSUuid.read((String)rows.getString(1)));
                info.setNumber(rows.getString(2));
                info.setName(rows.getString(3));
                info.setHorTableName(rows.getString(4));
                if (!StringUtils.isEmpty((String)rows.getString(5))) {
                    SalariatSchemeInfo salarSchemeInfo = new SalariatSchemeInfo();
                    salarSchemeInfo.setId(BOSUuid.read((String)rows.getString(5)));
                    info.setSalariatScheme(salarSchemeInfo);
                } else {
                    info.setSalariatScheme(null);
                }
                return info;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static FixedCmpSchemeInfo getFixedSchemeInfoByPeriod(Context ctx, CmpPeriodInfo cmpPeriod) throws EASBizException, BOSException {
        Date endDate = cmpPeriod.getEndDate();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String hrID = null;
        hrID = cmpPeriod.getHrOrgUnit() != null ? cmpPeriod.getHrOrgUnit().getId().toString() : HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("enableDate", (Object)endDate, CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("disableDate", (Object)endDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("disableDate", null, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)0, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and #1 and (#2 or #3) and #4");
        entityViewInfo.setFilter(filterInfo);
        IFixedCmpScheme iFixedCmpScheme = FixedCmpSchemeFactory.getLocalInstance(ctx);
        FixedCmpSchemeCollection coll = iFixedCmpScheme.getFixedCmpSchemeCollection(entityViewInfo);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        return coll.get(0);
    }

    public static CmpAdjustSchemeInfo getEmpAdjustInfo(String personId) throws EASBizException, BOSException {
        CmpAdjustSchemeInfo csinfo = null;
        HRUtils.getAdjustCmpMap(personId);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.effectDate"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.oldValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.newValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.adjCmpItem.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.adjCmpItem.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.adjCmpItem.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.adjustReason.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.adjustReason.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entries.adjEmp.id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adjSchemeState", (Object)Integer.valueOf(30).toString(), CompareType.GREATER_EQUALS));
        FilterInfo entryFilter = new FilterInfo(EntryFilterType.NORMAL);
        entryFilter.setEntryName("entries");
        entryFilter.getFilterItems().add(new FilterItemInfo("adjEmp.id", (Object)personId));
        entityViewInfo.getEntryFilters().add(entryFilter);
        entityViewInfo.setFilter(filterInfo);
        CmpAdjustSchemeCollection cmpAdjColl = CmpAdjustSchemeFactory.getRemoteInstance().getCmpAdjustSchemeCollection(entityViewInfo);
        csinfo = cmpAdjColl.size() > 0 ? cmpAdjColl.get(0) : null;
        return csinfo;
    }

    public static SelectorItemCollection getAdjustSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("adjSchemeState"));
        sic.add(new SelectorItemInfo("entries.effectDate"));
        sic.add(new SelectorItemInfo("entries.oldValue"));
        sic.add(new SelectorItemInfo("entries.newValue"));
        sic.add(new SelectorItemInfo("entries.adjEmp.id"));
        sic.add(new SelectorItemInfo("entries.adjEmp.name"));
        sic.add(new SelectorItemInfo("entries.adjCmpItem.id"));
        sic.add(new SelectorItemInfo("entries.adjCmpItem.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("entries.adjustReason.id"));
        sic.add(new SelectorItemInfo("entries.adjustReason.name"));
        sic.add(new SelectorItemInfo("entries.oldSalPoint.id"));
        sic.add(new SelectorItemInfo("entries.oldSalPoint.name"));
        sic.add(new SelectorItemInfo("entries.newSalPoint.id"));
        sic.add(new SelectorItemInfo("entries.newSalPoint.name"));
        sic.add(new SelectorItemInfo("entries.salPointSalGradeID"));
        sic.add(new SelectorItemInfo("entries.oldSalPointSalGradeID"));
        sic.add(new SelectorItemInfo("entries.fixedCmpScheme.id"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    public static List getAdjustCmpMap(String personId, String strHrOrgUnitId) throws BOSException {
        ArrayList<CmpAdjSchItemInfo> adjustCmpList = new ArrayList<CmpAdjSchItemInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("effectDate"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("oldValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("newValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("remark"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("dispatchNum"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.decDigital"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjustReason.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjustReason.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjScheme.adjSchemeState"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("oldSalPoint.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("newSalPoint.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("oldSalPoint.parent.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("newSalPoint.parent.name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adjEmp.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.adjSchemeState", (Object)30, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.adjSchemeState", (Object)50, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.hrOrgUnit.id", (Object)strHrOrgUnitId));
        entityViewInfo.setFilter(filterInfo);
        SorterItemInfo sortInfo = new SorterItemInfo("effectDate");
        sortInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpAdjSchItemCollection cmpAdjSchItemCol = CmpAdjSchItemFactory.getRemoteInstance().getCmpAdjSchItemCollection(entityViewInfo);
        int cmpColSize = cmpAdjSchItemCol.size();
        if (cmpColSize > 0) {
            for (int i = 0; i < cmpColSize; ++i) {
                CmpAdjSchItemInfo cmpAdjSchItemInfo = cmpAdjSchItemCol.get(i);
                adjustCmpList.add(i, cmpAdjSchItemInfo);
            }
        } else {
            adjustCmpList = null;
        }
        return adjustCmpList;
    }

    public static List getAdjustCmpMap(String personId) throws BOSException {
        ArrayList<CmpAdjSchItemInfo> adjustCmpList = new ArrayList<CmpAdjSchItemInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("effectDate"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("oldValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("newValue"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("remark"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("dispatchNum"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjCmpItem.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjustReason.id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjustReason.name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("adjScheme.adjSchemeState"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("adjEmp.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.adjSchemeState", (Object)30, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("adjScheme.adjSchemeState", (Object)50, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 and #1 and #2");
        entityViewInfo.setFilter(filterInfo);
        SorterItemInfo sortInfo = new SorterItemInfo("effectDate");
        sortInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpAdjSchItemCollection cmpAdjSchItemCol = CmpAdjSchItemFactory.getRemoteInstance().getCmpAdjSchItemCollection(entityViewInfo);
        int cmpColSize = cmpAdjSchItemCol.size();
        if (cmpColSize > 0) {
            for (int i = 0; i < cmpColSize; ++i) {
                CmpAdjSchItemInfo cmpAdjSchItemInfo = cmpAdjSchItemCol.get(i);
                adjustCmpList.add(i, cmpAdjSchItemInfo);
            }
        } else {
            adjustCmpList = null;
        }
        return adjustCmpList;
    }

    public static Map getFixedCmpSchemeInfo(String personId) throws EASBizException, BOSException {
        String strHrOrgUnitId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        return HRUtils.getFixedCmpSchemeInfo(personId, strHrOrgUnitId);
    }

    public static Map getFixedCmpSchemeInfo(String personId, String strHrOrgUnitId) throws EASBizException, BOSException {
        FixedCmpSchemeInfo fixedInfo = HRUtils.getFixedCmpSchemeEnable(personId, strHrOrgUnitId);
        if (fixedInfo == null) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.INIT_FIXEDTABLE);
        }
        String tableName = fixedInfo.getHorTableName();
        String fixedId = fixedInfo.getId().toString();
        Map map = null;
        try {
            List lstItem = HRUtils.getFixedCmpSchemeItem(fixedId);
            map = HRUtils.getFixedCmpSchemeData(personId, tableName, lstItem);
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        return map;
    }

    private static Map getFixedCmpSchemeData(String personId, String table, List lstItem) throws BOSException, SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        String sql = "select * from " + table + " where fpersonid ='" + personId + "'";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (!rs.next()) {
            return map;
        }
        java.sql.Date effectDate = null;
        int size = lstItem.size();
        for (int i = 0; i < size; ++i) {
            CmpItemInfo item;
            if (effectDate == null) {
                effectDate = rs.getDate("fotherenabledate");
            }
            if (rs.getString((item = (CmpItemInfo)lstItem.get(i)).getNumber()) == null) continue;
            map.put(item.getName(), rs.getString(item.getNumber()));
        }
        map.put(EFFECT_DATE, effectDate);
        return map;
    }

    private static List getFixedCmpSchemeItem(String fixedId) throws BOSException, SQLException {
        String language = SysContext.getSysContext().getLocale().getLanguage();
        String sql = "select b.fid,b.fname_" + language + ",b.fnumber,b.FDecDigital from t_hr_fixedcmpschemeitem a,t_hr_cmpitem b where a.FFixedCmpSchemeID = '" + fixedId + "' and a.fcmpitemid = b.fid ";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        ArrayList<CmpItemInfo> lst = new ArrayList<CmpItemInfo>(32);
        while (rs.next()) {
            if (rs.getString(2).compareToIgnoreCase("FSAL000") == 0) continue;
            CmpItemInfo info = new CmpItemInfo();
            info.setId(BOSUuid.read((String)rs.getString("fid")));
            info.setName(rs.getString("fname_" + language));
            info.setNumber(rs.getString("fnumber"));
            info.setDecDigital(rs.getInt("FDecDigital"));
            lst.add(info);
        }
        return lst;
    }

    private static String getAdjustSchemeId(String personId) throws BOSException, SQLException {
        String sql = "select fadjschemeid from t_hr_adjscheme a,t_hr_adjschitem b where fadjempid='" + personId + "' and a.fid = b.fadjschemeid and a.FAdjSchemeState >= " + 30 + " and a.FHROrgUnitID='" + HRSchemeUtils.getClientHROrgUnitInfo().getId().toString() + "'";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (!rs.next()) {
            return null;
        }
        return rs.getString(1);
    }

    private static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.effectDate"));
        sic.add(new SelectorItemInfo("entries.oldValue"));
        sic.add(new SelectorItemInfo("entries.newValue"));
        sic.add(new SelectorItemInfo("entries.adjCmpItem.id"));
        sic.add(new SelectorItemInfo("entries.adjCmpItem.number"));
        sic.add(new SelectorItemInfo("entries.adjCmpItem.name"));
        sic.add(new SelectorItemInfo("entries.adjustReason.id"));
        sic.add(new SelectorItemInfo("entries.adjustReason.name"));
        return sic;
    }

    public static String getFilterTitleText() {
        return EASResource.getString((String)"com.kingdee.eas.hr.compensation.client.CmpReportResource.TITLE_TEXT");
    }

    public static String getDateString(Date date) {
        if (date == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(date.getYear() + 1900);
        sb.append("-");
        sb.append(date.getMonth() + 1);
        sb.append("-");
        sb.append(date.getDate());
        return sb.toString();
    }

    public static BigDecimal addData(BigDecimal oldValue, BigDecimal newValue) {
        if (newValue == null) {
            return oldValue;
        }
        if (oldValue == null) {
            return newValue;
        }
        return oldValue.add(newValue);
    }

    public static Date stringConvertToDate(String fomateString, String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat(fomateString);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(dateString, pos);
    }

    public static String getNowTime(boolean time) {
        Date now = new Date();
        String format = "";
        format = time ? "yyyyMMdd" : "yyyy";
        String nowtime = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            nowtime = sdf.format(now);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return nowtime;
    }

    private static CmpSystemConfigInfo getSysConfigDefaultValue() {
        CmpSystemConfigInfo cmpSystemConfigDefInfo = new CmpSystemConfigInfo();
        BigDecimal defalutIntValue = new BigDecimal("-1");
        cmpSystemConfigDefInfo.setPTJoberInCUPerNum(true);
        cmpSystemConfigDefInfo.setPTJoberInWeave(true);
        cmpSystemConfigDefInfo.setOverPerNum(true);
        cmpSystemConfigDefInfo.setReEnrollWorkerYears(true);
        cmpSystemConfigDefInfo.setIsAffairIfDisablePosition(true);
        cmpSystemConfigDefInfo.setGenLedgerIF(false);
        cmpSystemConfigDefInfo.setTellerManageIF(false);
        cmpSystemConfigDefInfo.setMonStaWorkDays(defalutIntValue);
        cmpSystemConfigDefInfo.setMonStaWorkDays(defalutIntValue);
        cmpSystemConfigDefInfo.setDailyWorkHours(defalutIntValue);
        cmpSystemConfigDefInfo.setUseAdditionRule(true);
        cmpSystemConfigDefInfo.setCalWeekend(false);
        cmpSystemConfigDefInfo.setCalFestival(false);
        cmpSystemConfigDefInfo.setUseSystemCalendar(true);
        cmpSystemConfigDefInfo.setYearVacationInitValue(Integer.valueOf(HRUtils.getNowTime(false)).intValue());
        cmpSystemConfigDefInfo.setIsEnableAfterAffair(false);
        return cmpSystemConfigDefInfo;
    }

    public static CmpSystemConfigInfo getSysConfigInfo() throws EASBizException, BOSException {
        CmpSystemConfigInfo cmpSystemConfigInfo = null;
        ICmpSystemConfig iCmpSystemConfig = CmpSystemConfigFactory.getRemoteInstance();
        cmpSystemConfigInfo = iCmpSystemConfig.getCmpSysConInfo();
        if (cmpSystemConfigInfo == null) {
            cmpSystemConfigInfo = HRUtils.getSysConfigDefaultValue();
        }
        return cmpSystemConfigInfo;
    }

    public static CmpSystemConfigInfo getSysConfigInfo(String cuId, Context ctx) throws EASBizException, BOSException {
        CmpSystemConfigInfo cmpSystemConfigInfo = null;
        ICmpSystemConfig iCmpSystemConfig = CmpSystemConfigFactory.getLocalInstance((Context)ctx);
        cmpSystemConfigInfo = iCmpSystemConfig.getCmpSysConInfo(cuId);
        if (cmpSystemConfigInfo == null) {
            cmpSystemConfigInfo = HRUtils.getSysConfigDefaultValue();
        }
        return cmpSystemConfigInfo;
    }

    public static CmpSystemConfigInfo getSysConfigInfo(String cuId) throws EASBizException, BOSException {
        CmpSystemConfigInfo cmpSystemConfigInfo = null;
        ICmpSystemConfig iCmpSystemConfig = CmpSystemConfigFactory.getRemoteInstance();
        cmpSystemConfigInfo = iCmpSystemConfig.getCmpSysConInfo(cuId);
        if (cmpSystemConfigInfo == null) {
            cmpSystemConfigInfo = HRUtils.getSysConfigDefaultValue();
        }
        return cmpSystemConfigInfo;
    }

    public static CmpSystemConfigInfo getSysConfigInfo(Context ctx) throws EASBizException, BOSException {
        CmpSystemConfigInfo cmpSystemConfigInfo = null;
        ICmpSystemConfig iCmpSystemConfig = CmpSystemConfigFactory.getLocalInstance((Context)ctx);
        cmpSystemConfigInfo = iCmpSystemConfig.getCmpSysConInfo();
        if (cmpSystemConfigInfo == null) {
            cmpSystemConfigInfo = HRUtils.getSysConfigDefaultValue();
        }
        return cmpSystemConfigInfo;
    }

    public static boolean hasSystemConfig() throws EASBizException, BOSException {
        ICmpSystemConfig iCmpSystemConfig = CmpSystemConfigFactory.getRemoteInstance();
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("T_HR_CMPSYSTEMCONFIG");
        boolean fisrtEnterFlag = iCmpSystemConfig.checkTableData(tableList);
        return fisrtEnterFlag;
    }

    public static String getCuIdStringOfServer(Context ctx) {
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String cuString = cu.getId().toString();
        return cuString;
    }

    public static int getCmpPeriodNumByDateClient(CmpPeriodInfo beginPeriodInfo, CmpPeriodInfo endPeriodInfo) throws EASBizException, BOSException {
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        return iCmpPeriod.getCmpPeriodNumByDateIF((IObjectValue)beginPeriodInfo, (IObjectValue)endPeriodInfo);
    }

    public static int getCmpPeriodNumByDateServer(CmpPeriodInfo beginPeriodInfo, CmpPeriodInfo endPeriodInfo, Context ctx) throws EASBizException, BOSException {
        ICmpPeriod iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        return iCmpPeriod.getCmpPeriodNumByDateIF((IObjectValue)beginPeriodInfo, (IObjectValue)endPeriodInfo);
    }

    public static boolean setCmpAdjSchItemDataServer(Context ctx, List personIDList, java.sql.Date[] effectDate, String operateState) throws EASBizException, BOSException {
        ICmpAdjSchItem iCmpAdjSchItem = CmpAdjSchItemFactory.getLocalInstance(ctx);
        return iCmpAdjSchItem.setCmpAdjSchItemDataIF(personIDList, effectDate, operateState);
    }

    public static boolean setCmpAdjSchItemDataClient(List personIDList, java.sql.Date[] effectDate, String operateState) throws EASBizException, BOSException {
        ICmpAdjSchItem iCmpAdjSchItem = CmpAdjSchItemFactory.getRemoteInstance();
        return iCmpAdjSchItem.setCmpAdjSchItemDataIF(personIDList, effectDate, operateState);
    }

    public static boolean setCmpAdjSchItemDataServer(Context ctx, List personIDList, String operateState) throws EASBizException, BOSException {
        ICmpAdjSchItem iCmpAdjSchItem = CmpAdjSchItemFactory.getLocalInstance(ctx);
        return iCmpAdjSchItem.setCmpAdjSchItemDataIF(personIDList, operateState);
    }

    public static boolean setCmpAdjSchItemDataClient(List personIDList, String operateState) throws EASBizException, BOSException {
        ICmpAdjSchItem iCmpAdjSchItem = CmpAdjSchItemFactory.getRemoteInstance();
        return iCmpAdjSchItem.setCmpAdjSchItemDataIF(personIDList, operateState);
    }

    public static CmpPeriodInfo getCmpPeriodInfoByConstantClient(Context ctx, CmpPeriodInfo currCmpPeriod, int constant) throws BOSException {
        return HRUtils.getCmpPeriodInfoForConstant(null, currCmpPeriod, constant);
    }

    public static CmpPeriodInfo getCmpPeriodInfoByConstantClient(Context ctx, CmpPeriodInfo currCmpPeriod, int constant, String strHrOrgUnitId) throws BOSException {
        return HRUtils.getCmpPeriodInfoForConstant(null, currCmpPeriod, constant, strHrOrgUnitId);
    }

    public static CmpPeriodInfo getCmpPeriodInfoByConstantServer(Context ctx, CmpPeriodInfo currCmpPeriod, int constant) throws BOSException {
        return HRUtils.getCmpPeriodInfoForConstant(ctx, currCmpPeriod, constant);
    }

    public static CmpPeriodInfo getNextCmpPeriodInfoServer(Context ctx, IObjectPK pkCmpPeriod) throws BOSException, EASBizException {
        ICmpPeriod iCmpPeriod = null;
        iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
        return iCmpPeriod.getNextCmpPeriod(pkCmpPeriod);
    }

    public static CmpPeriodInfo getNextCmpPeriodInfoClient(IObjectPK pkCmpPeriod) throws BOSException, EASBizException {
        ICmpPeriod iCmpPeriod = null;
        iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
        return iCmpPeriod.getNextCmpPeriod(pkCmpPeriod);
    }

    private static CmpPeriodInfo getCmpPeriodInfoForConstant(Context ctx, CmpPeriodInfo currCmpPeriod, int constant) throws BOSException {
        if (constant == 0) {
            return currCmpPeriod;
        }
        ICmpPeriod iCmpPeriod = null;
        Object cmpPeriodInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String hrOrgUnitID = null;
        if (ctx == null) {
            iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
            hrOrgUnitID = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        } else {
            iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
            hrOrgUnitID = HRSchemeUtils.getServerHROrgUnitInfo(ctx).getId().toString();
        }
        if (currCmpPeriod.getHrOrgUnit() != null) {
            hrOrgUnitID = currCmpPeriod.getHrOrgUnit().getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitID));
        entityViewInfo.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
        if (cmpPeriodColl == null || cmpPeriodColl.size() <= 1) {
            return null;
        }
        String id = currCmpPeriod.getId().toString();
        String temp = null;
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            temp = cmpPeriodColl.get(i).getId().toString();
            if (!temp.equals(id)) continue;
            if (constant > 0) {
                if (size > constant + i) {
                    return cmpPeriodColl.get(constant + i);
                }
                return null;
            }
            if (constant < 0) {
                if (i >= -constant) {
                    return cmpPeriodColl.get(i + constant);
                }
                return null;
            }
            return cmpPeriodColl.get(i);
        }
        return null;
    }

    private static CmpPeriodInfo getCmpPeriodInfoForConstant(Context ctx, CmpPeriodInfo currCmpPeriod, int constant, String strHrOrgUnitId) throws BOSException {
        ICmpPeriod iCmpPeriod = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)strHrOrgUnitId));
        iCmpPeriod = ctx == null ? CmpPeriodFactory.getRemoteInstance() : CmpPeriodFactory.getLocalInstance(ctx);
        entityViewInfo.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(entityViewInfo);
        if (cmpPeriodColl == null || cmpPeriodColl.size() <= 1) {
            return null;
        }
        String id = currCmpPeriod.getId().toString();
        String temp = null;
        int size = cmpPeriodColl.size();
        for (int i = 0; i < size; ++i) {
            temp = cmpPeriodColl.get(i).getId().toString();
            if (!temp.equals(id)) continue;
            if (constant > 0) {
                if (size > constant + i) {
                    return cmpPeriodColl.get(constant + i);
                }
                return null;
            }
            if (constant < 0) {
                if (i >= -constant) {
                    return cmpPeriodColl.get(i + constant);
                }
                return null;
            }
            return cmpPeriodColl.get(i);
        }
        return null;
    }

    public static List getCmpPeriodList(Context ctx, CmpPeriodInfo beginCmpPeriod, CmpPeriodInfo endCmpPeriod, boolean isGroupCmpPeriod) throws BOSException {
        ArrayList<CmpPeriodInfo> cmpPeriodList = new ArrayList<CmpPeriodInfo>();
        ICmpPeriod iCmpPeriod = null;
        HROrgUnitInfo hrOrgUnitInfo = null;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (beginCmpPeriod != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginCmpPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            hrOrgUnitInfo = beginCmpPeriod.getHrOrgUnit();
        }
        if (endCmpPeriod != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("beginDate", (Object)endCmpPeriod.getEndDate(), CompareType.LESS_EQUALS));
            hrOrgUnitInfo = endCmpPeriod.getHrOrgUnit();
        }
        if (ctx == null) {
            iCmpPeriod = CmpPeriodFactory.getRemoteInstance();
            if (hrOrgUnitInfo == null) {
                hrOrgUnitInfo = HRSchemeUtils.getClientHROrgUnitInfo();
            }
        } else {
            iCmpPeriod = CmpPeriodFactory.getLocalInstance(ctx);
            if (hrOrgUnitInfo == null) {
                hrOrgUnitInfo = HRSchemeUtils.getServerHROrgUnitInfo(ctx);
            }
        }
        if (!isGroupCmpPeriod) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitInfo.getId().toString()));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        }
        env.setFilter(filterInfo);
        SorterItemInfo sortInfo = new SorterItemInfo("begindate");
        sortInfo.setSortType(SortType.ASCEND);
        env.getSorter().add(sortInfo);
        CmpPeriodCollection cmpPeriodColl = iCmpPeriod.getCmpPeriodCollection(env);
        for (int i = 0; i < cmpPeriodColl.size(); ++i) {
            CmpPeriodInfo cmpPeriodInfo = cmpPeriodColl.get(i);
            cmpPeriodList.add(cmpPeriodInfo);
        }
        return cmpPeriodList;
    }

    public static java.sql.Date convertUtilDateTOSqlDate(Date uitlDate) {
        java.sql.Date sqlDate = new java.sql.Date(uitlDate.getTime());
        return sqlDate;
    }

    public static String getLastDayOfMonthOfYear(String selectDate) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String ret = "";
        formatter.format(formatter.parse(selectDate));
        Calendar tempcl = formatter.getCalendar();
        int MaxDayOfMonthOfYear = tempcl.getActualMaximum(5);
        ret = tempcl.get(1) + "-" + (tempcl.get(2) + 1) + "-" + MaxDayOfMonthOfYear;
        ret = formatter.format(formatter.parseObject(ret));
        return ret;
    }

    public static void setMulLanguageHelper(IObjectValue data, String propertyName, String propertyValue) {
        String local = SysContext.getSysContext().getLocale().getLanguage();
        HRUtils.setMulLanguageHelper2(data, propertyName, propertyValue, local);
    }

    public static void setMulLanguageHelper2(IObjectValue data, String propertyName, String propertyValue, String local) {
        if (local.equals("l3")) {
            String sdescription = STConverter.tc2sc((String)propertyValue);
            data.put(propertyName, (Object)sdescription, LocaleUtils.getLocale((String)"l2"));
            data.put(propertyName, (Object)propertyValue, LocaleUtils.getLocale((String)"l3"));
        } else if (local.equals("l2")) {
            String tdescription = STConverter.sc2tc((String)propertyValue);
            data.put(propertyName, (Object)propertyValue, LocaleUtils.getLocale((String)"l2"));
            data.put(propertyName, (Object)tdescription, LocaleUtils.getLocale((String)"l3"));
        } else if (local.equals("l1")) {
            data.put(propertyName, (Object)propertyValue, LocaleUtils.getLocale((String)"l1"));
        }
    }

    public static void msgBoxInfo(String msgStr, boolean isAbortFlag) {
        MsgBox.showInfo((String)EASResource.getString((String)msgStr));
        if (isAbortFlag) {
            SysUtil.abort();
        }
    }

    public static Map getYearVacation(int year, String personId) throws Exception {
        HashMap<String, Float> mapValue = new HashMap<String, Float>(16);
        float currQuantity = 0.0f;
        float currBalance = 0.0f;
        float lastBalance = 0.0f;
        String sql = " select * from t_hr_yvbalance where fyear=" + year + " and fpersonId = '" + personId + "'";
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = executor.executeSQL();
        if (rs.next()) {
            currQuantity = rs.getFloat("FCurrQuantity");
            currBalance = rs.getFloat("FCurrAvaiable");
            lastBalance = rs.getFloat("FLastBalance");
        }
        mapValue.put("FLastBalance", new Float(lastBalance));
        mapValue.put("FCurrQuantity", new Float(currQuantity));
        mapValue.put("FCurrAvailable", new Float(currBalance));
        return mapValue;
    }

    public static void prinntExecuteTime(String str, long start) {
        logger.info((Object)(str + " : " + (System.currentTimeMillis() - start) / 1000L + " s"));
    }

    public static AdminOrgUnitCollection getSubDeptCollection(AdminOrgUnitInfo infoDept, int level) throws Exception {
        HashSet<Integer> setLevel = new HashSet<Integer>();
        setLevel.add(infoDept.getLevel());
        for (int i = 0; i <= level; ++i) {
            setLevel.add(i + infoDept.getLevel());
        }
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("level", setLevel, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(infoDept.getLongNumber() + "!%"), CompareType.LIKE));
        SorterItemInfo sortInfo = new SorterItemInfo("longnumber");
        sortInfo.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo);
        entityViewInfo.setFilter(filterInfo);
        OrgType orgType = OrgType.Admin;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        FullOrgUnitCollection fullOrgCol = iPermission.getAuthorizedOrg((IObjectPK)new ObjectStringPK(userId), orgType, null, null, entityViewInfo);
        Object infoAdmin = null;
        FullOrgUnitInfo infoFull = null;
        ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
        int size = fullOrgCol.size();
        for (int i = 0; i < size; ++i) {
            infoFull = fullOrgCol.get(i);
            idList.add(infoFull.getId());
        }
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
        if (idList.size() > 0) {
            colDept = iAdminOrgUnit.getAdminOrgUnitCollection("select * where id in (" + ToolUtils.aryToStr(idList, (boolean)true) + ") order by longnumber");
        }
        colDept.add(infoDept);
        return colDept;
    }

    public static AdminOrgUnitCollection getSubDeptCollectionNew(AdminOrgUnitInfo infoDept, int level) throws Exception {
        HashSet<Integer> setLevel = new HashSet<Integer>();
        setLevel.add(infoDept.getLevel());
        for (int i = 0; i <= level; ++i) {
            setLevel.add(i + infoDept.getLevel());
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("level", setLevel, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("longnumber", (Object)infoDept.getLongNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(infoDept.getLongNumber() + "!%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminUser.id", (Object)userId));
        filterInfo.setMaskString("#0 and (#1 or #2) and #3");
        SorterItemInfo sortInfo1 = new SorterItemInfo("longnumber");
        sortInfo1.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo1);
        entityViewInfo.setFilter(filterInfo);
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.OrgRangeQuery"));
        iQe.setObjectView(entityViewInfo);
        IRowSet rows = iQe.executeQuery();
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        while (rows.next()) {
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)rows.getString("id")));
            adminInfo.setName(rows.getString("name"));
            adminInfo.setNumber(rows.getString("number"));
            adminInfo.setDisplayName(rows.getString("displayname"));
            adminInfo.setLongNumber(rows.getString("longnumber"));
            adminInfo.setLevel(rows.getInt("level"));
            colDept.add(adminInfo);
        }
        return colDept;
    }

    public static AdminOrgUnitCollection getSubDeptCollectionNew(AdminOrgUnitInfo infoDept, int level, boolean isShowSealUp) throws Exception {
        HashSet<Integer> setLevel = new HashSet<Integer>();
        setLevel.add(infoDept.getLevel());
        for (int i = 0; i <= level; ++i) {
            setLevel.add(i + infoDept.getLevel());
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("level", setLevel, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("longnumber", (Object)infoDept.getLongNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(infoDept.getLongNumber() + "!%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminUser.id", (Object)userId));
        if (isShowSealUp) {
            filterInfo.setMaskString("#0 and (#1 or #2) and #3");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)isShowSealUp));
            filterInfo.setMaskString("#0 and (#1 or #2) and #3 and #4");
        }
        SorterItemInfo sortInfo1 = new SorterItemInfo("longnumber");
        sortInfo1.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sortInfo1);
        entityViewInfo.setFilter(filterInfo);
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.compensation.app.OrgRangeQuery"));
        iQe.setObjectView(entityViewInfo);
        IRowSet rows = iQe.executeQuery();
        AdminOrgUnitCollection colDept = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        while (rows.next()) {
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)rows.getString("id")));
            adminInfo.setName(rows.getString("name"));
            adminInfo.setNumber(rows.getString("number"));
            adminInfo.setDisplayName(rows.getString("displayname"));
            adminInfo.setLongNumber(rows.getString("longnumber"));
            adminInfo.setLevel(rows.getInt("level"));
            colDept.add(adminInfo);
        }
        return colDept;
    }

    public static String getSqlofSubDepandSelf(Context ctx, AdminOrgUnitInfo infoDept, String adminTableColumnName, int level, boolean limitLevelDown) throws BOSException {
        if (infoDept == null) {
            return null;
        }
        String longNumber = infoDept.getLongNumber();
        BOSUuid id = infoDept.getId();
        int selfLevel = infoDept.getLevel();
        int toLevel = selfLevel + level;
        if (StringUtils.isEmpty((String)longNumber) || id == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \"ADMIN\".fid ");
        sql.append(" FROM T_ORG_Admin  \"ADMIN\"");
        sql.append(" INNER JOIN T_PM_OrgRange  \"ADMINORGRANGE\"");
        sql.append(" ON \"ADMIN\".FID = \"ADMINORGRANGE\".FOrgID");
        sql.append(" INNER JOIN T_PM_User  \"ADMINUSER\"");
        sql.append(" ON \"ADMINORGRANGE\".FUserID = \"ADMINUSER\".FID");
        sql.append(" WHERE (\"ADMIN\".fid = '");
        sql.append(id.toString());
        sql.append("' or \"ADMIN\".flongnumber like '");
        sql.append(longNumber);
        sql.append("!%') and \"ADMINORGRANGE\".FType = 20 and \"ADMINUSER\".FID = '");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("'");
        if (level >= 0 && selfLevel > 0) {
            sql.append(" and \"ADMIN\".flevel >= ");
            sql.append(selfLevel);
            sql.append(" and \"ADMIN\".flevel <= ");
            sql.append(selfLevel + level);
        }
        if (limitLevelDown) {
            sql.append(" and \"ADMIN\".flevel <= ");
            sql.append(toLevel);
        }
        if (!StringUtils.isEmpty((String)adminTableColumnName)) {
            sql.append(" and ");
            sql.append(adminTableColumnName);
            sql.append(" = \"ADMIN\".fid");
        }
        return sql.toString();
    }

    public static String getCurOrgSubOrgSql(Context ctx, AdminOrgUnitInfo infoDept, String adminTableColumnName, int level, boolean limitLevelDown) throws BOSException {
        if (infoDept == null) {
            return null;
        }
        String longNumber = infoDept.getLongNumber();
        BOSUuid id = infoDept.getId();
        int selfLevel = infoDept.getLevel();
        int toLevel = selfLevel + level;
        if (StringUtils.isEmpty((String)longNumber) || id == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \"ADMIN\".fid ");
        sql.append(" FROM T_ORG_Admin  \"ADMIN\"");
        sql.append(" INNER JOIN T_PM_OrgRange  \"ADMINORGRANGE\"");
        sql.append(" ON \"ADMIN\".FID = \"ADMINORGRANGE\".FOrgID");
        sql.append(" INNER JOIN T_PM_User  \"ADMINUSER\"");
        sql.append(" ON \"ADMINORGRANGE\".FUserID = \"ADMINUSER\".FID");
        sql.append(" WHERE (\"ADMIN\".fid = '");
        sql.append(id.toString());
        sql.append("' or \"ADMIN\".flongnumber like '");
        sql.append(longNumber);
        sql.append("!%') and \"ADMINORGRANGE\".FType = 20 and \"ADMINUSER\".FID = '");
        sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        sql.append("'");
        if (level >= 0 && selfLevel > 0 && limitLevelDown) {
            sql.append(" and \"ADMIN\".flevel >= ");
            sql.append(selfLevel);
            sql.append(" and \"ADMIN\".flevel <= ");
            sql.append(toLevel);
        } else {
            sql.append(" and \"ADMIN\".flevel >= ");
            sql.append(selfLevel);
        }
        if (!StringUtils.isEmpty((String)adminTableColumnName)) {
            sql.append(" and ");
            sql.append(adminTableColumnName);
            sql.append(" = \"ADMIN\".fid");
        }
        return sql.toString();
    }

    public static List getParentAndSefIdsOfDep(Context ctx, AdminOrgUnitInfo infoDept, int startLevel) throws BOSException, SQLException {
        int level;
        if (infoDept == null) {
            return new ArrayList();
        }
        String longNumber = infoDept.getLongNumber();
        BOSUuid id = infoDept.getId();
        int n = level = startLevel > 1 ? startLevel - 1 : 0;
        if (StringUtils.isEmpty((String)longNumber) || id == null) {
            return new ArrayList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        String[] numbers = longNumber.split("!");
        if (numbers.length > 0) {
            StringBuffer filterNumber = new StringBuffer();
            for (int i = level; i < numbers.length; ++i) {
                if (i != level) {
                    filterNumber.append(",");
                }
                filterNumber.append("'");
                filterNumber.append(numbers[i]);
                filterNumber.append("'");
            }
            if (!StringUtils.isEmpty((String)filterNumber.toString())) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT \"ADMIN\".fid ");
                sql.append(" FROM T_ORG_Admin  \"ADMIN\"");
                sql.append(" INNER JOIN T_PM_OrgRange  \"ADMINORGRANGE\"");
                sql.append(" ON \"ADMIN\".FID = \"ADMINORGRANGE\".FOrgID");
                sql.append(" INNER JOIN T_PM_User  \"ADMINUSER\"");
                sql.append(" ON \"ADMINORGRANGE\".FUserID = \"ADMINUSER\".FID");
                sql.append(" WHERE \"ADMIN\".fnumber in (");
                sql.append(filterNumber);
                sql.append(") and \"ADMINORGRANGE\".FType = 20 and \"ADMINUSER\".FID = '");
                sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                sql.append("' ");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    ids.add(rowSet.getString(1));
                }
            } else {
                ids.add(id.toString());
            }
        }
        return ids;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static void removeLintMenu(KDTable table, KDTMenuManager tm) {
        Component[] obj = tm.getMenu().getComponents();
        Component comp3 = null;
        Component comp2 = null;
        for (Component comp3 : obj) {
            if (comp3.getName() == null || !comp3.getName().equals("menuPublishReport")) continue;
            Component[] menus = ((KDMenu)comp3).getMenuComponents();
            for (int t = 0; t < menus.length; ++t) {
                comp2 = menus[t];
                if (comp3.getName() == null) continue;
                if (comp2.getName().equals("separatorRpt")) {
                    ((JPopupMenu.Separator)comp2).setVisible(false);
                }
                if (!comp2.getName().equals("menuItemToLinkForRpt")) continue;
                ((KDMenuItem)comp2).setVisible(false);
            }
        }
    }

    public static boolean isBOCUsed() throws Exception {
        boolean isBOCUsed = false;
        String sql = "select * from t_hr_parameter where fnumber=2020";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet iRowSet = exec.executeSQL();
        if (iRowSet.next()) {
            isBOCUsed = true;
        }
        return isBOCUsed;
    }

    public static boolean isPermissionByKey(String permissionItemKey) throws BOSException, EASBizException {
        if (permissionItemKey == null) {
            return false;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        UserInfo currUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(currUserInfo.getId().toString());
        HROrgUnitInfo hrOrgUnit = SysContext.getSysContext().getCurrentHRUnit();
        ObjectUuidPK hroPK = new ObjectUuidPK(hrOrgUnit.getId().toString());
        return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)hroPK, permissionItemKey);
    }

    public static Object copyToSelect(KDTable tbl) throws Exception {
        HashMap<Integer, CopyToSelect> hsp = new HashMap<Integer, CopyToSelect>();
        KDTSelectBlock sb = null;
        Integer itColumn = null;
        Object itRow = null;
        CopyToSelect temp = null;
        ICell iCell = null;
        Object obj = null;
        int size = tbl.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            sb = tbl.getSelectManager().get(i);
            int top = sb.getTop();
            int left = sb.getLeft();
            int bottom = sb.getBottom();
            int right = sb.getRight();
            for (int column = left; column <= right; ++column) {
                if (tbl.getColumn(column).getStyleAttributes().isLocked() || hsp.get(itColumn = Integer.valueOf(column)) != null) continue;
                temp = new CopyToSelect();
                temp.value = tbl.getCell(top, column).getValue();
                if (temp.value instanceof SalariatHiberPropsInfo) {
                    obj = temp.value;
                }
                temp.column = column;
                temp.row = top;
                hsp.put(itColumn, temp);
            }
        }
        Object value = null;
        for (int i = 0; i < size; ++i) {
            sb = tbl.getSelectManager().get(i);
            int top = sb.getTop();
            int left = sb.getLeft();
            int bottom = sb.getBottom();
            int right = sb.getRight();
            for (int row = top; row <= bottom; ++row) {
                for (int column = left; column <= right; ++column) {
                    itColumn = column;
                    if (hsp.get(itColumn) == null) continue;
                    temp = (CopyToSelect)hsp.get(itColumn);
                    if (row == temp.row || (iCell = tbl.getCell(row, column)).getStyleAttributes().isLocked()) continue;
                    iCell.setValue(temp.value);
                }
            }
        }
        return obj;
    }

    public static HashMap parseValue(String str) throws EASBizException {
        if (str == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(str, delim);
        String key_value = null;
        String key = null;
        String value = null;
        while (tokens.hasMoreTokens()) {
            key_value = tokens.nextToken().trim();
            if (key_value.indexOf(leftDelim) == -1) {
                throw new HRParseException(HRParseException.LEFT_DELIM);
            }
            if (key_value.indexOf(leftDelim) != key_value.lastIndexOf(leftDelim)) {
                throw new HRParseException(HRParseException.LEFT_DELIM);
            }
            if (key_value.indexOf(rightDelim) == -1) {
                throw new HRParseException(HRParseException.RIGHT_DELIM);
            }
            if (key_value.indexOf(rightDelim) != key_value.lastIndexOf(rightDelim)) {
                throw new HRParseException(HRParseException.RIGHT_DELIM);
            }
            if (key_value.indexOf(rightDelim) <= key_value.indexOf(leftDelim)) {
                throw new HRParseException(HRParseException.LEFT_RIGHT_REVERSE);
            }
            if (!key_value.endsWith(rightDelim)) {
                throw new HRParseException(HRParseException.DATA_FORMAT_ERROR);
            }
            if (key_value.startsWith(leftDelim)) {
                throw new HRParseException(HRParseException.KEY_ERROR);
            }
            key = key_value.substring(0, key_value.indexOf(leftDelim));
            value = key_value.substring(key_value.indexOf(leftDelim) + 1, key_value.indexOf(rightDelim));
            if (result.keySet().contains(key)) {
                throw new HRParseException(HRParseException.KEY_DUP);
            }
            result.put(key, value);
        }
        return result;
    }

    public static String getDataOfFirstDoubleQuotationofMarks(String target) {
        if (target.indexOf("\"") == -1) {
            return null;
        }
        Pattern p = Pattern.compile("\"(\\w)*\"");
        Matcher m = p.matcher(target);
        String tmp = null;
        if (m.find() && m.start() >= 0 && m.group() != null) {
            tmp = m.group().substring(1, m.group().length() - 1);
        }
        return tmp;
    }

    public static CmpSchemeCollection getCmpShemeCollection(HROrgUnitInfo hrOrg) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        ev.getSelector().add(new SelectorItemInfo("isDelete"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        ev.setFilter(filter);
        CmpSchemeCollection cmpSchemeCols = CmpSchemeFactory.getRemoteInstance().getCmpSchemeCollection(ev);
        if (cmpSchemeCols != null && cmpSchemeCols.size() > 0) {
            return cmpSchemeCols;
        }
        return null;
    }

    public static String getListSchemeIDs(Set cmpSchemeInfoSet) {
        StringBuffer ids = new StringBuffer("");
        if (cmpSchemeInfoSet.size() < 1) {
            return ids.toString();
        }
        Iterator it = null;
        for (Object o : cmpSchemeInfoSet) {
            ids.append(o.toString());
            ids.append("~");
        }
        if (ids.length() > 1) {
            ids.deleteCharAt(ids.length() - 1);
        }
        return ids.toString();
    }

    public static CmpPeriodInfo[] getCmpPeriodFromCustomerParams(String param) {
        if (param == null) {
            return null;
        }
        CmpPeriodInfo[] cmpPeriodArgs = null;
        String[] ids = param.split(delim);
        String tmp = null;
        if (ids != null && ids.length > 0) {
            tmp = ids[1];
        }
        if (tmp != null) {
            String[] cmpPeriodInfos = tmp.split(",");
            cmpPeriodArgs = new CmpPeriodInfo[cmpPeriodInfos.length];
            for (int i = 0; i < cmpPeriodInfos.length; ++i) {
                try {
                    cmpPeriodArgs[i] = CmpPeriodFactory.getRemoteInstance().getCmpPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cmpPeriodInfos[i])));
                    continue;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return cmpPeriodArgs;
    }

    public static CmpSchemeInfo[] getCmpSchemeInfosFromCustomerParam(String param) {
        int i;
        if (param == null) {
            return null;
        }
        String[] tmp = param.split("~");
        CmpSchemeCollection schemeColl = new CmpSchemeCollection();
        try {
            CmpSchemeInfo info = null;
            for (i = 0; i < tmp.length; ++i) {
                info = CmpSchemeFactory.getRemoteInstance().getCmpSchemeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tmp[i])));
                schemeColl.add(info);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        CmpSchemeInfo[] cmpSchemeInfos = new CmpSchemeInfo[schemeColl.size()];
        for (i = 0; i < schemeColl.size(); ++i) {
            cmpSchemeInfos[i] = schemeColl.get(i);
        }
        return cmpSchemeInfos;
    }

    public static CmpItemInfo[] getCmpItemInfosFromCustomerParam(String param) {
        if (param == null) {
            return null;
        }
        String[] tmp = param.split("~");
        CmpItemInfo[] cmpItemInfos = new CmpItemInfo[tmp.length];
        try {
            if (tmp != null && tmp.length > 0) {
                int arrayInt = tmp.length;
                HashSet<String> keySet = new HashSet<String>();
                for (int i = 0; i < arrayInt; ++i) {
                    keySet.add(tmp[i]);
                }
                CmpItemCollection cmpItemColl = (CmpItemCollection)CmpItemFactory.getRemoteInstance().getForNotDataAuthority(keySet);
                if (cmpItemColl != null && cmpItemColl.size() > 0) {
                    int size = cmpItemColl.size();
                    for (int i = 0; i < size; ++i) {
                        cmpItemInfos[i] = cmpItemColl.get(i);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return cmpItemInfos;
    }

    public static HashMap getPersonOrgAndPositionByIds(String[] idList) throws Exception {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        if (idList.length == 0) {
            return map;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < idList.length; ++i) {
            if (StringUtils.isEmpty((String)idList[i])) continue;
            set.add(idList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("personDep.id"));
        evi.getSelector().add(new SelectorItemInfo("personDep.name"));
        evi.getSelector().add(new SelectorItemInfo("personDep.number"));
        evi.getSelector().add(new SelectorItemInfo("personDep.displayName"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
        evi.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
        PersonPositionCollection ppColl = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(evi);
        PersonPositionInfo ppInfo = null;
        int size = ppColl.size();
        for (int i = 0; i < size; ++i) {
            ppInfo = ppColl.get(i);
            map.put(ppInfo.getPerson().getId().toString(), new Object[]{ppInfo.getPersonDep(), ppInfo.getPrimaryPosition()});
        }
        return map;
    }

    public static Integer convertBigDecimalToInteger(BigDecimal bdValue) {
        Integer iValue = null;
        if (bdValue != null) {
            iValue = bdValue.intValue();
        }
        return iValue;
    }

    public static int getSchemeQueryType(String queryPK) {
        if (StringUtils.isEmpty((String)queryPK)) {
            return 1;
        }
        if (queryPK.indexOf("HRPersonInfoQuery") > 0) {
            return 2;
        }
        if (queryPK.indexOf("PersonInfoQuery") > 0) {
            return 1;
        }
        return -1;
    }

    public static List getAdminOrgHROCollection(List adminOrgList) throws BOSException {
        if (adminOrgList == null || adminOrgList.size() == 0) {
            return null;
        }
        String orgIds = HRUtils.getOrgIdString(adminOrgList);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)orgIds, CompareType.INNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)16));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.org.app", "AdminOrgGetHROQuery"));
        iQe.setObjectView(entityViewInfo);
        IRowSet rowSet = iQe.executeQuery();
        ArrayList<HROrgUnitInfo> resultList = new ArrayList<HROrgUnitInfo>();
        try {
            while (rowSet != null && rowSet.next()) {
                HROrgUnitInfo info = new HROrgUnitInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("hrOrgUnit.id")));
                info.setNumber(rowSet.getString("hrOrgUnit.number"));
                info.setName(rowSet.getString("hrOrgUnit.name"));
                info.setLongNumber(rowSet.getString("hrOrgUnit.longNumber"));
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("ctrlUnit.id")));
                cu.setNumber(rowSet.getString("ctrlUnit.number"));
                cu.setName(rowSet.getString("ctrlUnit.name"));
                cu.setLongNumber(rowSet.getString("ctrlUnit.longNumber"));
                info.setCU(cu);
                if (resultList.contains(info)) continue;
                resultList.add(info);
            }
            return resultList;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getOrgIdString(List orgList) {
        if (orgList == null || orgList.size() < 1) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < orgList.size(); ++i) {
            if (!(orgList.get(i) instanceof OrgUnitInfo)) {
                return null;
            }
            OrgUnitInfo orgInfo = (OrgUnitInfo)orgList.get(i);
            String orgId = orgInfo.getId().toString();
            if (result.indexOf(orgId) >= 0) continue;
            result.append("'").append(orgId).append("',");
        }
        if (result.length() < 2) {
            return null;
        }
        return result.substring(0, result.length() - 1);
    }

    public static String getParentOrgId(Context ctx, List orgList, int orgType) throws SQLException, BOSException {
        if (orgList == null || orgList.size() < 1) {
            return null;
        }
        if (orgType != 1 && orgType != 2) {
            return null;
        }
        if (orgList.size() == 1) {
            String ids = HRUtils.getOrgIdString(orgList);
            return ids.substring(1, ids.length() - 1);
        }
        Collections.sort(orgList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String number0 = ((OrgUnitInfo)arg0).getLongNumber();
                String number1 = ((OrgUnitInfo)arg1).getLongNumber();
                return number0.compareTo(number1);
            }
        });
        OrgUnitInfo fristOrg = (OrgUnitInfo)orgList.get(0);
        OrgUnitInfo orgCur = null;
        boolean findFlag = true;
        int n = orgList.size();
        for (int i = 1; i < n; ++i) {
            orgCur = (OrgUnitInfo)orgList.get(i);
            if (orgCur.getLongNumber().startsWith(fristOrg.getLongNumber() + "!") || orgCur.getLongNumber().equals(fristOrg.getLongNumber())) continue;
            findFlag = false;
            break;
        }
        if (findFlag) {
            return fristOrg.getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        String result = null;
        String ids = HRUtils.getOrgIdString(orgList);
        if (orgType == 1) {
            sql.append("select top 1 FParentID from T_ORG_HRO where fid in ");
            sql.append("(select  tbl.fid from (select * from T_ORG_HRO where fid in (");
            sql.append(ids);
            sql.append(") ) tbl ) order by fLongNumber");
        } else {
            sql.append("select top 1 FParentID from T_ORG_Admin where fid in ");
            sql.append("(select  tbl.fid from (select * from T_ORG_HRO where fid in (");
            sql.append(ids);
            sql.append(") ) tbl ) order by fLongNumber");
        }
        ISQLExecutor iSQLExec = null;
        iSQLExec = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql.toString()) : SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rows = iSQLExec.executeSQL();
        while (rows.next()) {
            result = rows.getString("FParentID");
        }
        return result;
    }

    public static AdminOrgUnitCollection getHROrgUnitFromAdmin(AdminOrgUnitCollection adminColl) throws Exception {
        StringBuffer sql = new StringBuffer();
        Locale locale = SysContext.getSysContext().getLocale();
        sql.append("SELECT A.FID AS AFID,A.FNAME_");
        sql.append(locale);
        sql.append(" AS AFNAME,A.FLONGNUMBER AS AFLONGNUMBER ,A.FDISPLAYNAME_");
        sql.append(locale);
        sql.append(" AS AFDISPLAYNAME,H.FID AS HFID,H.FNAME_");
        sql.append(locale);
        sql.append(" AS HFNAME,H.FDISPLAYNAME_");
        sql.append(locale);
        sql.append(" AS HFDISPLAYNAME FROM T_ORG_UNITRELATION R ");
        sql.append("INNER JOIN T_ORG_HRO H ON R.FTOUNITID = H.FID ");
        sql.append("INNER JOIN T_ORG_ADMIN A ON R.FFROMUNITID = A.FID ");
        IRowSet rows = null;
        if (adminColl == null || adminColl.size() == 0) {
            sql.append("INNER JOIN T_PM_ORGRANGE UR ON UR.FORGID = A.FID ");
            sql.append("WHERE R.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sql.append("AND UR.FTYPE = 20 AND UR.FUSERID = '");
            sql.append(SysContext.getSysContext().getCurrentUserInfo().getId());
            sql.append("'");
        } else {
            sql.append("WHERE R.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sql.append("AND R.FFROMUNITID IN(");
            int size = adminColl.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("'");
                sql.append(adminColl.get(i).getId());
                sql.append("'");
            }
            sql.append(rightDelim);
        }
        sql.append(" ORDER BY A.FLONGNUMBER ");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        rows = iSQL.executeSQL();
        HROrgUnitInfo hroInfo = null;
        String adminID = null;
        block1: while (rows.next()) {
            adminID = rows.getString("AFID");
            int size = adminColl.size();
            for (int i = 0; i < size; ++i) {
                if (!adminID.equals(adminColl.get(i).getId().toString())) continue;
                hroInfo = new HROrgUnitInfo();
                hroInfo.setId(BOSUuid.read((String)rows.getString("HFID")));
                hroInfo.setName(rows.getString("HFNAME"));
                hroInfo.setDisplayName(rows.getString("HFDISPLAYNAME"));
                adminColl.get(i).put("HROrgUnitInfo", (Object)hroInfo);
                continue block1;
            }
        }
        return adminColl;
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        int MAX_DATA_ROW = 8000;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 12);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            try {
                Object sb = null;
                Object params = null;
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static String getAdminOrgTmpTbl(Context ctx, List orgCol) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String orgTmpTblName = null;
        String createSql = "create table t_hr_orgTmpTbl (fAdOrgUnitId varchar(44));";
        try {
            orgTmpTblName = pool.createTempTable(createSql);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer insertSql = new StringBuffer();
        if (orgCol == null || orgCol.size() == 0) {
            insertSql.append("insert into ").append(orgTmpTblName);
            insertSql.append(" SELECT DISTINCT FORGID FROM T_PM_OrgRange ");
            insertSql.append(" INNER JOIN T_ORG_UnitRelation ON T_PM_OrgRange.FORGID=T_ORG_UnitRelation.FFromUnitID ");
            insertSql.append(" WHERE T_PM_OrgRange.FType = 20 ");
            insertSql.append(" AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            insertSql.append(" AND T_PM_OrgRange.FUserID='");
            insertSql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            insertSql.append("' AND T_ORG_UnitRelation.FToUnitID='");
            insertSql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
            insertSql.append("'");
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
        } else {
            Object[] objects = null;
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            int n = orgCol.size();
            for (int i = 0; i < n; ++i) {
                objects = new Object[]{((AdminOrgUnitInfo)orgCol.get(i)).getId().toString()};
                paramsList.add(objects);
            }
            insertSql.append("insert into ").append(orgTmpTblName).append("(fAdOrgUnitId) values (?) \n");
            HRUtils.executeBatch(ctx, insertSql.toString(), paramsList);
        }
        return orgTmpTblName;
    }

    public static String getAdminOrgTmpTbl(Context ctx, List orgCol, boolean isShowSealUp) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String orgTmpTblName = null;
        String createSql = "create table t_hr_orgTmpTbl (fAdOrgUnitId varchar(44));";
        try {
            orgTmpTblName = pool.createTempTable(createSql);
            StringBuffer insertSql = new StringBuffer();
            if (orgCol == null || orgCol.size() == 0) {
                insertSql.append("insert into ").append(orgTmpTblName);
                insertSql.append(" SELECT DISTINCT ADMIN.FID FROM T_ORG_ADMIN ADMIN ");
                insertSql.append(" INNER JOIN T_PM_OrgRange ON T_PM_OrgRange.FORGID = ADMIN.FID ");
                insertSql.append(" INNER JOIN T_ORG_UnitRelation ON T_PM_OrgRange.FORGID=T_ORG_UnitRelation.FFromUnitID ");
                insertSql.append(" WHERE T_PM_OrgRange.FType = 20 ");
                insertSql.append(" AND T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
                insertSql.append(" AND T_PM_OrgRange.FUserID='");
                insertSql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                insertSql.append("' AND T_ORG_UnitRelation.FToUnitID='");
                insertSql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
                insertSql.append("'");
                if (isShowSealUp) {
                    DbUtil.execute((Context)ctx, (String)insertSql.toString());
                } else {
                    insertSql.append(" AND ADMIN.FIsSealUp = ?");
                    DbUtil.execute((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{isShowSealUp});
                }
            } else {
                Object[] objects = null;
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                AdminOrgUnitInfo tmpInfo = null;
                AdminOrgUnitInfo newInfo = null;
                int n = orgCol.size();
                for (int i = 0; i < n; ++i) {
                    tmpInfo = (AdminOrgUnitInfo)orgCol.get(i);
                    objects = new Object[]{tmpInfo.getId().toString()};
                    if (isShowSealUp) {
                        paramsList.add(objects);
                        continue;
                    }
                    IAdminOrgUnit iadmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    newInfo = iadmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(tmpInfo.getId().toString()));
                    if (newInfo.isIsSealUp()) continue;
                    paramsList.add(objects);
                }
                insertSql.append("insert into ").append(orgTmpTblName).append("(fAdOrgUnitId) values (?) \n");
                HRUtils.executeBatch(ctx, insertSql.toString(), paramsList);
            }
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return orgTmpTblName;
    }

    public static String getPropertyNameFromSelector(String aliasName, SelectorItemCollection selectorColl) {
        SelectorItemInfo selectorInfo = null;
        int size = selectorColl.size();
        for (int i = 0; i < size; ++i) {
            selectorInfo = selectorColl.get(i);
            if (selectorInfo.getAliasName() == null || !selectorInfo.getAliasName().equalsIgnoreCase(aliasName)) continue;
            return selectorInfo.getPropertyName();
        }
        return null;
    }

    public static List getColumnOfTable(Context ctx, String tableName) throws BOSException {
        String sql = " SELECT top 1 * FROM " + tableName;
        IRowSet rs = null;
        ArrayList<String> columnList = new ArrayList<String>();
        rs = ctx == null ? SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL() : DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            ResultSetMetaData meta = rs.getMetaData();
            int size = meta.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                columnList.add(meta.getColumnName(i).toUpperCase());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return columnList;
    }

    public static AdminOrgUnitInfo getAdminOrgByPostion(String postionId) throws BOSException {
        String oql = "select id,name,longNumber,adminOrgUnit.* where id='" + postionId + "'";
        PositionCollection orgCollection = PositionFactory.getRemoteInstance().getPositionCollection(oql);
        if (orgCollection != null && orgCollection.size() > 0) {
            return orgCollection.get(0).getAdminOrgUnit();
        }
        return null;
    }

    public static Map getFixedCmpSchemeInfoForEmp(String personId, String strHrOrgUnitId) throws EASBizException, BOSException {
        FixedCmpSchemeInfo fixedInfo;
        if (StringUtils.isEmpty((String)strHrOrgUnitId)) {
            strHrOrgUnitId = HRSchemeUtils.getClientHROrgUnitInfo().getId().toString();
        }
        if ((fixedInfo = HRUtils.getFixedCmpSchemeEnable(personId, strHrOrgUnitId)) == null) {
            throw new FixedCmpSchemeException(FixedCmpSchemeException.INIT_FIXEDTABLE);
        }
        String tableName = fixedInfo.getHorTableName();
        String fixedId = fixedInfo.getId().toString();
        Map map = null;
        try {
            List lstItem = HRUtils.getFixedCmpSchemeItem(fixedId);
            map = HRUtils.getFixedCmpSchemeDataForEmp(personId, tableName, lstItem);
        }
        catch (SQLException se) {
            throw new BOSException((Throwable)se);
        }
        return map;
    }

    private static Map getFixedCmpSchemeDataForEmp(String personId, String table, List lstItem) throws BOSException, SQLException {
        HashMap<Object, Object> map = new HashMap<Object, Object>(16);
        String sql = "select * from " + table + " where fpersonid ='" + personId + "'";
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (!rs.next()) {
            return map;
        }
        java.sql.Date effectDate = null;
        int size = lstItem.size();
        for (int i = 0; i < size; ++i) {
            CmpItemInfo item;
            if (effectDate == null) {
                effectDate = rs.getDate("fotherenabledate");
            }
            if (rs.getString((item = (CmpItemInfo)lstItem.get(i)).getNumber()) == null || !(rs.getObject(item.getNumber()) instanceof BigDecimal) || new BigDecimal("0").compareTo(rs.getBigDecimal(item.getNumber())) == 0) continue;
            map.put(item, rs.getObject(item.getNumber()));
        }
        map.put(EFFECT_DATE, effectDate);
        return map;
    }

    public static String getCmpItemIds(Context ctx) throws EASBizException, BOSException {
        EntityViewInfo view;
        String hrUnitID = null;
        if (ctx == null && SysContext.getSysContext().getCurrentHRUnit() != null) {
            hrUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        } else if (ctx != null && ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            hrUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        if (hrUnitID == null) {
            return null;
        }
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(hrUnitID);
        CmpItemCollection cmpcols = null;
        if (ctx == null) {
            view = CommonPermissionFacadeFactory.getRemoteInstance().getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            if (view.toString().indexOf("hrOrgUnit.id") != -1 && view.getFilter().getFilterItems().size() > 1) {
                cmpcols = CmpItemFactory.getRemoteInstance().getCmpItemCollection(view);
            }
        } else {
            view = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            if (view.toString().indexOf("hrOrgUnit.id") != -1 && view.getFilter().getFilterItems().size() > 1) {
                cmpcols = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(view);
            }
        }
        StringBuffer cmpItemids = new StringBuffer();
        if (cmpcols == null) {
            return null;
        }
        int size = cmpcols.size();
        for (int i = 0; i < size; ++i) {
            cmpItemids.append("'");
            cmpItemids.append(cmpcols.get(i).getId().toString());
            cmpItemids.append("',");
        }
        if (cmpItemids.lastIndexOf(",") != -1) {
            cmpItemids.deleteCharAt(cmpItemids.length() - 1).toString();
        }
        return cmpItemids.toString();
    }

    public static CmpItemCollection getCmpItems(Context ctx) throws EASBizException, BOSException {
        String hrUnitID = null;
        if (ctx == null && SysContext.getSysContext().getCurrentHRUnit() != null) {
            hrUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        } else if (ctx != null && ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            hrUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        if (hrUnitID == null) {
            return null;
        }
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add(hrUnitID);
        CmpItemCollection cmpcols = null;
        if (ctx == null) {
            EntityViewInfo view = CommonPermissionFacadeFactory.getRemoteInstance().getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            cmpcols = CmpItemFactory.getRemoteInstance().getCmpItemCollection(view);
        } else {
            EntityViewInfo view = CommonPermissionFacadeFactory.getLocalInstance(ctx).getHRsDataPermission(hroSet, "hrOrgUnit.id", "cmpitem_view");
            cmpcols = CmpItemFactory.getLocalInstance(ctx).getCmpItemCollection(view);
        }
        return cmpcols;
    }

    public static boolean getParamValue(Context ctx, String number, String hrUnitID) throws Exception {
        IParamControl iParam = null;
        iParam = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        if (hrUnitID == null) {
            if (ctx == null && SysContext.getSysContext().getCurrentHRUnit() != null) {
                hrUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            } else if (ctx != null && ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
                hrUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            }
        }
        if (hrUnitID == null) {
            return false;
        }
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(hrUnitID), number);
        return "true".equals(val);
    }

    public static void setComboBoxLevel(DataChangeEvent e, KDComboBox comboBox) throws Exception {
        CoreBaseInfo newInfo = (CoreBaseInfo)e.getNewValue();
        CoreBaseInfo oldInfo = (CoreBaseInfo)e.getOldValue();
        if (newInfo == null || oldInfo == null || !newInfo.getId().equals((Object)oldInfo.getId())) {
            comboBox.removeAllItems();
            String longNumber = null;
            boolean isOrg = false;
            if (newInfo instanceof HROrgUnitInfo) {
                longNumber = ((HROrgUnitInfo)newInfo).getLongNumber();
                isOrg = true;
            }
            if (longNumber != null) {
                int[] datas = HRUtils.getLevelByLongNumber(longNumber, isOrg);
                int level = datas[0] - datas[1] + 1;
                if (newInfo instanceof HROrgUnitInfo) {
                    ((HROrgUnitInfo)newInfo).setLevel(datas[1]);
                    e.setNewValue((Object)newInfo);
                }
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
                for (int i = 1; i < level; ++i) {
                    model.addElement(new Integer(i));
                }
                comboBox.setModel(model);
            }
        }
    }

    public static int[] getLevelByLongNumber(String longNumber, boolean isOrg) throws Exception {
        int[] datas = new int[2];
        IRowSet rows = GroupSummaryFacadeFactory.getRemoteInstance().getLevelByLongNumber(longNumber);
        if (rows.next()) {
            datas[0] = rows.getInt("MAX0");
            datas[1] = rows.getInt("MIN0");
        }
        return datas;
    }

    public static String getShortCode(Context ctx) {
        Locale locale = ctx.getLocale();
        return HRUtils.getShortCode(locale);
    }

    public static String getShortCode(Locale local) {
        if (locale_l2.equals(local)) {
            return "l2";
        }
        if (locale_L2.equals(local)) {
            return "l2";
        }
        if (locale_zh_CN.equals(local)) {
            return "l2";
        }
        if (locale_l1.equals(local)) {
            return "l1";
        }
        if (locale_L1.equals(local)) {
            return "l1";
        }
        if (locale_en_US.equals(local)) {
            return "l1";
        }
        if (locale_zh_TW.equals(local)) {
            return "l3";
        }
        if (locale_en.equals(local)) {
            return "l1";
        }
        if (locale_l3.equals(local)) {
            return "l3";
        }
        if (locale_L3.equals(local)) {
            return "l3";
        }
        return null;
    }
}

