/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.export.AbstractExporter;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.POIXlsExporter;
import com.kingdee.bos.ctrl.kdf.kds.IMerges;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSColumn;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class HtmlExporter
extends AbstractExporter {
    private static Logger logger = Logger.getLogger(HtmlExporter.class);
    private PrintableBook printkds = null;
    private StringBuffer sb = null;
    private String encoding = null;
    private int imageCount;
    private String imageDir;
    private String imageRelativeDir;
    private int startPageIndex = 0;
    private int endPageIndex = 0;

    public String getHtmlStr() {
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        return this.sb.toString();
    }

    public void export() {
        Integer start;
        this.imageCount = 0;
        this.printkds = (PrintableBook)this.parameters.get(ExporterParameter.KD_Print);
        if (this.printkds == null) {
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.hr.compensation.COMPENSATIONAutoGenerateResource", (String)"704_HtmlExporter"));
        }
        int lastPageIndex = -1;
        if (this.printkds.getIndexedPagesNoSavePaper() != null) {
            lastPageIndex = this.printkds.getIndexedPagesNoSavePaper().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(ExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new RuntimeException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(ExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < 0 || this.endPageIndex > lastPageIndex) {
                throw new RuntimeException("End page index out of range : " + this.endPageIndex + " of " + lastPageIndex);
            }
        }
        Integer index = (Integer)this.parameters.get(ExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new RuntimeException("PageContainer index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
        this.encoding = (String)this.parameters.get(ExporterParameter.CHARACTER_ENCODING);
        if (this.encoding == null) {
            this.encoding = "UNICODE";
        }
        try {
            this.exportReportToWriter();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to writer : ", e);
        }
    }

    private void exportReportToWriter() throws IOException {
        if (this.sb == null) {
            this.sb = new StringBuffer(4096);
        }
        this.exportHeadAndBody();
    }

    void exportHeadAndBody() throws IOException {
        int imagesCount = 0;
        if (this.printkds.getBook().getImages() != null) {
            imagesCount = this.printkds.getBook().getImages().size();
        }
        for (int i = 0; i < this.printkds.getBook().getSheetCount() + imagesCount; ++i) {
            if (i < this.printkds.getBook().getSheetCount()) {
                this.save_HtmlBody(i);
                continue;
            }
            this.save_HtmlBodyWithImage(i - this.printkds.getBook().getSheetCount());
        }
    }

    void save_HtmlJavaScriptEx() throws IOException {
        String csIndex;
        int i;
        this.sb.append("<script language=\"JavaScript\">\n");
        this.sb.append(" <!--\n");
        String csCount = this.printkds.getBook().getImages() == null ? String.valueOf(this.printkds.getBook().getSheetCount()) : String.valueOf(this.printkds.getBook().getSheetCount() + this.printkds.getBook().getImages().size());
        this.sb.append("  var c_lTabs=");
        this.sb.append(csCount);
        this.sb.append(";\n");
        this.sb.append("  var c_rgszSh=new Array(c_lTabs);\n");
        for (i = 0; i < this.printkds.getBook().getSheetCount(); ++i) {
            csIndex = String.valueOf(i);
            this.sb.append("  c_rgszSh[");
            this.sb.append(csIndex);
            this.sb.append("] = \"");
            this.sb.append(this.printkds.getBook().getSheet((Object)i).getName());
            this.sb.append("\";\n");
        }
        if (this.printkds.getBook().getImages() != null) {
            for (i = 0; i < this.printkds.getBook().getImages().size(); ++i) {
                csIndex = String.valueOf(this.printkds.getBook().getSheetCount() + i);
                this.sb.append("  c_rgszSh[");
                this.sb.append(csIndex);
                this.sb.append("] = \"");
                KDSBook.KDSImage image = (KDSBook.KDSImage)this.printkds.getBook().getImages().get(i);
                if (image.getSheetName().equals("unNamedSheet")) {
                    this.sb.append("sheet" + (this.printkds.getBook().getSheetCount() + i + 1));
                } else {
                    this.sb.append(image.getSheetName());
                }
                this.sb.append("\";\n");
            }
        }
        this.sb.append("\n\n");
        InputStream inputStream = com.kingdee.bos.ctrl.kdf.export.HtmlExporter.class.getResourceAsStream("javascript.txt");
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        String s = "";
        StringBuffer sbtemp = new StringBuffer();
        while ((s = in.readLine()) != null) {
            sbtemp.append(s);
            sbtemp.append("\n");
        }
        in.close();
        inputStream.close();
        this.sb.append(sbtemp.toString());
        this.sb.append("window.g_iIEVer=fnGetIEVer();\n");
        this.sb.append("if (window.g_iIEVer>=3)\n ");
        this.sb.append("fnBuildFrameset();\n");
        this.sb.append("swapSheet(0);\n");
        this.sb.append("//-->\r\n</script>\n");
    }

    private void save_HtmlBody(int index) throws IOException {
        KDSSheet sheet = this.printkds.getBook().getSheet((Object)index);
        ShareStyleAttributes ssa = sheet.getSSA();
        this.sb.append("<Table border=0 cellpadding=0 cellspacing=0 style='border-collapse: collapse;table-layout:fixed;\n");
        this.save_HtmlStyle(ssa, sheet.getStyle());
        this.sb.append("'>");
        int lStartCol = 0;
        int lEndCol = sheet.getExpandedColumns();
        int lStartRow = 0;
        int lEndRow = sheet.getExpandedRows();
        this.save_HtmlColumns(sheet, lStartCol, lEndCol);
        this.save_HtmlRows(sheet, lStartRow, lEndRow, lStartCol, lEndCol);
        this.sb.append("</Table>\n");
    }

    private void save_HtmlBodyWithImage(int index) throws IOException {
        String extendName = "";
        switch (((KDSBook.KDSImage)this.printkds.getBook().getImages().get(index)).getFileType()) {
            case 7: {
                extendName = "dib";
                break;
            }
            case 5: {
                extendName = "jpg";
                break;
            }
            case 6: {
                extendName = "png";
            }
        }
        String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
        if (fileName == null) {
            this.sb.append("<IMG src='./-" + index + "." + extendName + "'/>\n");
        } else {
            File destFile = new File(fileName);
            String file = destFile.getName();
            int dotIndex = file.indexOf(".");
            if (dotIndex != -1) {
                file = file.substring(0, dotIndex);
            }
            this.sb.append("<IMG src='./" + file + "-" + index + "." + extendName + "'/>\n");
        }
    }

    private void save_HtmlStyle(ShareStyleAttributes sa, Style stl) throws IOException {
        Color clr;
        Style ssa = stl;
        if (ssa == null || ssa.isEmpty()) {
            return;
        }
        String m_cs = this.get_Html_Align((ShareStyleAttributes)ssa);
        if (m_cs.length() > 0) {
            this.sb.append(m_cs);
        }
        if (ssa.hasBordersAttributes()) {
            if (ssa.hasBorderAttributes(Styles.Position.LEFT)) {
                m_cs = this.get_Html_Line(Styles.Position.LEFT, stl);
                this.sb.append(m_cs);
            }
            if (ssa.hasBorderAttributes(Styles.Position.TOP)) {
                m_cs = this.get_Html_Line(Styles.Position.TOP, stl);
                this.sb.append(m_cs);
            }
            if (ssa.hasBorderAttributes(Styles.Position.RIGHT)) {
                m_cs = this.get_Html_Line(Styles.Position.RIGHT, stl);
                this.sb.append(m_cs);
            }
            if (ssa.hasBorderAttributes(Styles.Position.BOTTOM)) {
                m_cs = this.get_Html_Line(Styles.Position.BOTTOM, stl);
                this.sb.append(m_cs);
            }
        }
        if (ssa.hasFontAttributes()) {
            m_cs = this.get_Html_Font((ShareStyleAttributes)ssa);
            this.sb.append(m_cs);
        }
        if ((clr = ssa.getBackground()) != null) {
            m_cs = "background:" + StyleParser.colorToHex((Color)clr) + ";";
            this.sb.append(m_cs);
        }
    }

    boolean isColHidden(KDSSheet sheet, int lcol) {
        ShareStyleAttributes ssa;
        KDSColumn column = sheet.getColumn(lcol, false);
        return column != null && (ssa = column.getSSA()) != null && ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) && ssa.isHided();
    }

    boolean isRowHidden(KDSSheet sheet, int lRow) {
        ShareStyleAttributes ssa;
        KDSRow row = sheet.getRow(lRow, false);
        return row != sheet.getDefaultRow() && (ssa = row.getSSA()) != null && ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) && ssa.isHided();
    }

    void save_HtmlColumns(KDSSheet sheet, int lStartCol, int lEndCol) throws IOException {
        for (int lCol = lStartCol; lCol <= lEndCol; ++lCol) {
            StringBuffer m_csProps = new StringBuffer();
            if (this.isColHidden(sheet, lCol)) continue;
            KDSColumn column = sheet.getColumn(lCol, false);
            this.sb.append("<col style='");
            if (column != sheet.getDefaultColumn() && column.getSSA() != null && !column.getSSA().isEmpty()) {
                this.save_HtmlStyle(column.getSSA(), column.getStyle());
            }
            m_csProps.append(" width:");
            m_csProps.append(sheet.getColumnWidth(lCol));
            m_csProps.append("mm '>\n");
            this.sb.append(m_csProps.toString());
        }
    }

    void save_HtmlRows(KDSSheet sheet, int lStartRow, int lEndRow, int lStartCol, int lEndCol) throws IOException {
        for (int lRow = lStartRow; lRow <= lEndRow; ++lRow) {
            KDSRow row = sheet.getRow(lRow, false);
            this.isRowHidden(sheet, lRow);
            if (row != sheet.getDefaultRow()) {
                if (this.isRowHidden(sheet, lRow)) continue;
                this.sb.append("<tr style='");
                if (row.getSSA() != null && !row.getSSA().isEmpty()) {
                    this.save_HtmlStyle(row.getSSA(), row.getStyle());
                }
                this.sb.append("height:");
                this.sb.append(sheet.getRowHeight(lRow));
                this.sb.append("mm'>\n");
            } else {
                this.sb.append("<tr style='");
                this.sb.append("height:");
                this.sb.append(sheet.getRowHeight(lRow));
                this.sb.append("mm'>\n");
            }
            for (int lCol = lStartCol; lCol <= lEndCol; ++lCol) {
                if (this.isColHidden(sheet, lCol)) continue;
                this.save_HtmlCell(sheet, lRow, lCol);
            }
            this.sb.append("</tr>\n");
        }
    }

    KDSMergeBlock getCellMerged(KDSSheet sheet, int row, int col) {
        IMerges ms = sheet.getMerges();
        for (KDSMergeBlock temp : ms) {
            if (!temp.include(row, col)) continue;
            return temp;
        }
        return null;
    }

    void save_HtmlCell(KDSSheet sheet, int row, int col) throws IOException {
        Object cellValue;
        KDSCell cell = sheet.getCell(row, col, false);
        boolean isMerged = cell.isMerged();
        boolean isFirstMerged = false;
        KDSMergeBlock mb = null;
        if (isMerged) {
            mb = cell.getMergeBlock();
            boolean bl = isFirstMerged = mb.col == col && mb.row == row;
        }
        if (isMerged && !isFirstMerged) {
            return;
        }
        this.sb.append("<td ");
        if (isMerged && isFirstMerged) {
            int i;
            int iHide;
            if (mb.getWidth() > 1) {
                iHide = 0;
                for (i = mb.col; i <= mb.getCol2(); ++i) {
                    if (!this.isColHidden(sheet, i)) continue;
                    ++iHide;
                }
                this.sb.append(" colspan=");
                this.sb.append(mb.getWidth() - iHide);
                this.sb.append("  ");
            }
            if (mb.getHeight() > 1) {
                iHide = 0;
                for (i = mb.row; i <= mb.getRow2(); ++i) {
                    if (!this.isRowHidden(sheet, i)) continue;
                    ++iHide;
                }
                this.sb.append(" rowspan=");
                this.sb.append(mb.getHeight() - iHide);
                this.sb.append("  ");
            }
        }
        if (cell != sheet.getDefaultCell() && !cell.getSSA().isEmpty()) {
            this.sb.append("style='");
            if (!isMerged) {
                this.save_HtmlStyle(cell.getSSA(), cell.getStyle());
            } else {
                Object ob;
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cell.getSSA());
                KDSCell destcell = sheet.getCell(row, col + mb.getWidth() - 1, false);
                if (destcell != sheet.getDefaultCell() && (ob = destcell.getSSA().get(ShareStyleAttributes.BORDER_RIGHT_PENSTYLE)) != null) {
                    sa.setBorderPenStyle(Styles.Position.RIGHT, (PenStyle)ob);
                }
                if ((destcell = sheet.getCell(row + mb.getHeight() - 1, col, false)) != sheet.getDefaultCell() && (ob = destcell.getSSA().get(ShareStyleAttributes.BORDER_BOTTOM_PENSTYLE)) != null) {
                    sa.setBorderPenStyle(Styles.Position.BOTTOM, (PenStyle)ob);
                }
                ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
                Style newstyle = Styles.getStyle((ShareStyleAttributes)ssa);
                this.save_HtmlStyle(ssa, newstyle);
            }
            this.sb.append("'>");
        }
        if ((cellValue = cell.getValue()) instanceof Image) {
            String href = this.saveImage((Image)cellValue);
            if (href != null) {
                this.sb.append(href);
            }
        } else {
            String strtext = null;
            Object theValue = cell.getValue();
            if (theValue != null && theValue instanceof Boolean) {
                String key = "BooleanValueFalse";
                if (((Boolean)theValue).equals(Boolean.TRUE)) {
                    key = "BooleanValueTrue";
                }
                strtext = LanguageManager.getLangMessage((String)key, POIXlsExporter.class, (String)theValue.toString());
            } else {
                strtext = cell.getText();
            }
            strtext = strtext.replaceAll(" ", "&nbsp;");
            strtext = strtext.replaceAll("\"", "&quot;");
            StringBuffer sbtemp = new StringBuffer(strtext);
            if (sbtemp.toString().length() > 0) {
                sbtemp.append("</div>");
                boolean bwraptext = false;
                Object obWraptext = cell.getSSA().get(ShareStyleAttributes.WRAP_TEXT);
                if (obWraptext != null) {
                    bwraptext = (Boolean)obWraptext;
                }
                if (bwraptext) {
                    sbtemp.insert(0, "<div style='display:table-cell; *display: inline; zoom:1; vertical-align:middle;'>");
                } else {
                    sbtemp.insert(0, "<div nowrap style='display:table-cell; *display: inline; zoom:1; vertical-align:middle;'>");
                }
                this.sb.append(sbtemp.toString());
            }
        }
        this.sb.append("&nbsp;</td>\n");
    }

    private String saveImage(Image img) throws IOException {
        if (img != null) {
            if (this.imageDir == null) {
                File fl = null;
                String fileName = (String)this.parameters.get(ExporterParameter.OUTPUT_FILE_NAME);
                fl = fileName == null ? (File)this.parameters.get(ExporterParameter.OUTPUT_FILE) : new File(fileName);
                if (fl != null) {
                    String path = fl.getParent();
                    String name = fl.getName();
                    int i = name.lastIndexOf(46);
                    name = i < 0 ? name + "_images" : name.substring(0, i) + "_images";
                    File dir = new File(path = path + File.separator + name);
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new IOException("create file is fail");
                    }
                    this.imageDir = path;
                    this.imageRelativeDir = name;
                }
            }
            if (this.imageDir != null) {
                ++this.imageCount;
                String imgName = this.imageDir + File.separator + "image" + String.valueOf(this.imageCount) + ".png";
                try {
                    BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                    bi.getGraphics().drawImage(img, 0, 0, null);
                    if (ImageIO.write((RenderedImage)bi, "png", new File(imgName))) {
                        return "<img src=&quot;" + this.imageRelativeDir + File.separator + "image" + String.valueOf(this.imageCount) + ".png&quot;/>";
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return null;
    }

    String replaceAll(String strValue, char chold, String newstr) {
        int count = strValue.length();
        StringBuffer sbtemp = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            if (strValue.charAt(i) != chold) {
                sbtemp.append(strValue.charAt(i));
                continue;
            }
            sbtemp.append(newstr);
        }
        return sbtemp.toString();
    }

    String get_Html_Align(ShareStyleAttributes ssa) {
        String csProp = "";
        StringBuffer sbtemp = new StringBuffer();
        Object obvalue = ssa.get(ShareStyleAttributes.HORIZONTAL_ALIGN);
        if (obvalue != null) {
            csProp = this.get_AlignStr((Styles.HorizontalAlignment)obvalue);
            sbtemp.append(" text-align:" + csProp + ";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.VERTICAL_ALIGN)) != null) {
            csProp = this.get_VertAlignStr((Styles.VerticalAlignment)obvalue);
            sbtemp.append(" vertical-align:" + csProp + ";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.WRAP_TEXT)) != null && ((Boolean)obvalue).booleanValue()) {
            sbtemp.append("word-break:normal;word-wrap:break-word;");
        } else {
            sbtemp.append(" word-break:keep-all;word-wrap:normal;");
        }
        return sbtemp.toString();
    }

    String get_Html_Font(ShareStyleAttributes ssa) {
        boolean bvalue;
        StringBuffer sbtemp = new StringBuffer();
        Object obvalue = ssa.get(ShareStyleAttributes.FONT_NAME);
        if (obvalue != null) {
            String strName = (String)obvalue;
            sbtemp.append(" font-family:" + strName + ";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_SIZE)) != null) {
            int intvalue = (Integer)obvalue;
            sbtemp.append(" font-size:" + intvalue + "pt;");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_WEIGHT)) != null) {
            float fvalue = ((Float)obvalue).floatValue();
            sbtemp.append(" font-weight:" + fvalue + ";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_ITALIC)) != null && (bvalue = ((Boolean)obvalue).booleanValue())) {
            sbtemp.append(" font-style:italic;");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_COLOR)) != null) {
            sbtemp.append(" color:" + StyleParser.colorToHex((Color)((Color)obvalue)) + ";");
        }
        return sbtemp.toString();
    }

    String get_Html_Line(Styles.Position pos, ShareStyleAttributes ssa) {
        StringBuffer sb = new StringBuffer();
        LineStyle ls = ssa.getBorderLineStyle(pos);
        if (!LineStyle.isNull((LineStyle)ls)) {
            if (pos == Styles.Position.LEFT) {
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_LEFT_PENSTYLE)) {
                    sb.append("border-left-style:" + this.get_Html_Style(ssa.getBorderPenStyle(pos)) + ";");
                }
                sb.append("border-left-width:" + ls.getWidth() + ";");
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_LEFT_COLOR)) {
                    sb.append("border-left-color:" + StyleParser.colorToHex((Color)ssa.getBorderColor(pos)) + ";");
                }
            } else if (pos == Styles.Position.TOP) {
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_TOP_PENSTYLE)) {
                    sb.append("border-top-style:" + this.get_Html_Style(ssa.getBorderPenStyle(pos)) + ";");
                }
                sb.append("border-top-width:" + ls.getWidth() + ";");
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_TOP_COLOR)) {
                    sb.append("border-top-color:" + StyleParser.colorToHex((Color)ssa.getBorderColor(pos)) + ";");
                }
            } else if (pos == Styles.Position.RIGHT) {
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_RIGHT_PENSTYLE)) {
                    sb.append("border-right-style:" + this.get_Html_Style(ssa.getBorderPenStyle(pos)) + ";");
                }
                sb.append("border-right-width:" + ls.getWidth() + ";");
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_RIGHT_COLOR)) {
                    sb.append("border-right-color:" + StyleParser.colorToHex((Color)ssa.getBorderColor(pos)) + ";");
                }
            } else if (pos == Styles.Position.BOTTOM) {
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_BOTTOM_PENSTYLE)) {
                    sb.append("border-bottom-style:" + this.get_Html_Style(ssa.getBorderPenStyle(pos)) + ";");
                }
                sb.append("border-bottom-width:" + ls.getWidth() + ";");
                if (ssa.hasAttributes(ShareStyleAttributes.BORDER_BOTTOM_COLOR)) {
                    sb.append("border-bottom-color:" + StyleParser.colorToHex((Color)ssa.getBorderColor(pos)) + ";");
                }
            }
        }
        return sb.toString();
    }

    String get_Html_Line(Styles.Position pos, Style stl) {
        StringBuffer sbtemp = new StringBuffer();
        LineStyle ls = stl.getBorderLineStyle(pos);
        if (!LineStyle.isNull((LineStyle)ls)) {
            if (pos == Styles.Position.LEFT) {
                sbtemp.append("border-left:");
            } else if (pos == Styles.Position.TOP) {
                sbtemp.append("border-top:");
            } else if (pos == Styles.Position.RIGHT) {
                sbtemp.append("border-right:");
            } else if (pos == Styles.Position.BOTTOM) {
                sbtemp.append("border-bottom:");
            }
            sbtemp.append(stl.getBorderLineStyle(pos).getWidth());
            sbtemp.append(" ");
            sbtemp.append(this.get_Html_Style(stl.getBorderPenStyle(pos)));
            sbtemp.append(" ");
            sbtemp.append(StyleParser.colorToHex((Color)stl.getBorderColor(pos)));
            sbtemp.append(";");
        }
        return sbtemp.toString();
    }

    String get_Html_Style(PenStyle ps) {
        String ret = ps == PenStyle.PS_SOLID ? "solid" : (ps == PenStyle.PS_DOT ? "dashed" : (ps == PenStyle.PS_CONTINUOUS ? "dotted" : "none"));
        return ret;
    }

    String get_AlignStr(Styles.HorizontalAlignment align) {
        String strRet = "";
        switch (align.getValue()) {
            case 1: {
                strRet = "left";
                break;
            }
            case 2: {
                strRet = "center";
                break;
            }
            case 3: {
                strRet = "right";
            }
        }
        return strRet;
    }

    String get_VertAlignStr(Styles.VerticalAlignment align) {
        String strRet = "";
        switch (align.getValue()) {
            case 1: {
                strRet = "top";
                break;
            }
            case 2: {
                strRet = "middle";
                break;
            }
            case 3: {
                strRet = "bottom";
            }
        }
        return strRet;
    }
}

