/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.CalEmpSchmException;
import com.kingdee.eas.hr.compensation.SimpleFormulaInfo;
import com.kingdee.eas.hr.compensation.formulateutil.FunctionEvalFactory;
import com.kingdee.eas.hr.compensation.formulateutil.FunctionEvaluation;
import com.kingdee.eas.hr.compensation.util.FunctionManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UDFFunctionHandler {
    private Context ctx = null;
    private boolean blnGetValue = true;

    public UDFFunctionHandler(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public boolean isBlnGetValue() {
        return this.blnGetValue;
    }

    public void setBlnGetValue(boolean blnGetValue) {
        this.blnGetValue = blnGetValue;
    }

    public void replaceFunctionWithValue(HashMap mapFormula) throws BOSException, EASBizException, SQLException {
        HashMap map = this.handleSpecialFunction(mapFormula);
        HashMap mapValue = this.evaluteFunction(map);
        Iterator itor = mapValue.entrySet().iterator();
        Map.Entry entry = null;
        while (itor.hasNext()) {
            entry = itor.next();
            String itemKey = (String)entry.getKey();
            SimpleFormulaInfo formulaInfo = (SimpleFormulaInfo)entry.getValue();
            String formula = formulaInfo.formula;
            List lstFunctionInfo = (List)map.get(itemKey);
            List lstValue = (List)mapValue.get(itemKey);
            formulaInfo.formula = formula = this.replace(formula, lstFunctionInfo, lstValue);
            mapFormula.put(itemKey, formulaInfo);
        }
    }

    public String replaceFunctionWithValue(String sql) throws BOSException, EASBizException, SQLException {
        List lstFunctionInfo = this.handleSpecialFunction(sql);
        List lstValue = this.evaluteFunction(lstFunctionInfo);
        return this.replace(sql, lstFunctionInfo, lstValue);
    }

    private String replace(String formula, List lstFunction, List lstValue) {
        formula = formula + " ";
        int where = formula.length() - 1;
        if (formula.indexOf("where") > 0) {
            where = formula.indexOf("where") - 1;
        }
        String strWhere = formula.substring(where, formula.length() - 1);
        String buff = formula.substring(0, where);
        int size = lstFunction.size();
        for (int i = 0; i < size; ++i) {
            FunctionInfo info = (FunctionInfo)lstFunction.get(i);
            String value = lstValue.get(i).toString();
            StringBuffer temp = new StringBuffer("" + info.name + "(");
            int tt = info.lstParam.size();
            for (int t = 0; t < tt; ++t) {
                temp.append("");
                temp.append(info.lstParam.get(t).toString());
                temp.append(",");
            }
            temp.deleteCharAt(temp.length() - 1);
            temp.append(")");
            buff = this.replace(buff, temp.toString(), value);
        }
        return buff + strWhere;
    }

    private String replace(String str, String oldChars, String newChars) {
        int pos;
        String strU = str.toUpperCase();
        String oldCharsU = oldChars.toUpperCase();
        String newCharsU = newChars.toUpperCase();
        int len = newCharsU.length();
        int lastPos = pos = strU.indexOf(oldCharsU);
        while (pos > -1) {
            String firstPart = str.substring(0, pos);
            String firstPartU = strU.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            String lastPartU = strU.substring(pos + oldCharsU.length(), strU.length());
            str = firstPart + newChars + lastPart;
            strU = firstPartU + newCharsU + lastPartU;
            lastPos = pos + len;
            pos = strU.indexOf(oldCharsU, lastPos);
        }
        return str;
    }

    private HashMap evaluteFunction(HashMap map) throws BOSException, EASBizException, SQLException {
        HashMap<String, List> mapValue = new HashMap<String, List>(map.size());
        Iterator itor = map.entrySet().iterator();
        Map.Entry entry = null;
        while (itor.hasNext()) {
            entry = itor.next();
            String itemKey = (String)entry.getKey();
            List lst = (List)entry.getValue();
            List lstValue = this.evaluteFunction(lst);
            mapValue.put(itemKey, lstValue);
        }
        return mapValue;
    }

    private List evaluteFunction(List lst) throws BOSException, EASBizException, SQLException {
        int size = lst.size();
        ArrayList<Object> lstValue = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            FunctionInfo info = (FunctionInfo)lst.get(i);
            Object value = this.callMethod(info.name, info.lstParam);
            lstValue.add(value);
        }
        return lstValue;
    }

    private HashMap handleSpecialFunction(HashMap mapFormula) throws BOSException, EASBizException, SQLException {
        HashMap<String, List> map = new HashMap<String, List>(16);
        Iterator itor = mapFormula.entrySet().iterator();
        Map.Entry entry = null;
        while (itor.hasNext()) {
            entry = itor.next();
            String itemKey = (String)entry.getKey();
            SimpleFormulaInfo formulaInfo = (SimpleFormulaInfo)entry.getValue();
            String formula = formulaInfo.formula;
            List lst = this.handleSpecialFunction(formula);
            map.put(itemKey, lst);
        }
        return map;
    }

    private List handleSpecialFunction(String formula) throws BOSException, EASBizException, SQLException {
        formula = formula.toLowerCase();
        ArrayList<FunctionInfo> lst = new ArrayList<FunctionInfo>(8);
        HashSet set = this.getSpecialFunctions();
        for (String name : set) {
            if (formula.indexOf(name) == -1) continue;
            int index = -1;
            int pos = 0;
            while ((index = formula.indexOf(name, pos)) != -1) {
                FunctionInfo finfo = this.getFunctionInfo(formula, pos, name);
                lst.add(finfo);
                pos = finfo.end + 1;
                index = -1;
            }
        }
        return lst;
    }

    private HashSet getSpecialFunctions() {
        HashSet<String> set = new HashSet<String>(16);
        set.add("itemvalue_abs_period");
        set.add("itemvalue_rel_period");
        return set;
    }

    private FunctionInfo getFunctionInfo(String formula, int startPos, String function) throws BOSException, EASBizException, SQLException {
        FunctionInfo info = new FunctionInfo();
        info.start = formula.indexOf(function, startPos);
        info.end = formula.indexOf(")", info.start);
        if (info.end == -1) {
            throw new CalEmpSchmException(CalEmpSchmException.CMPFORMULA_ERROR);
        }
        ++info.end;
        String params = formula.substring(info.start + function.length() + 1, info.end - 1);
        if (params == null) {
            throw new CalEmpSchmException(CalEmpSchmException.CMPFORMULA_ERROR);
        }
        String[] lstParam = params.split(",");
        for (int i = 0; i < lstParam.length; ++i) {
            info.lstParam.add(lstParam[i]);
        }
        info.name = function;
        return info;
    }

    private Object callMethod(String methodName, List lstParam) throws BOSException, EASBizException, SQLException {
        if (!this.blnGetValue) {
            return new Double(0.0);
        }
        String className = FunctionManager.getClassNameByFunctionName(methodName);
        FunctionEvaluation funEval = FunctionEvalFactory.create(className);
        funEval.beforeExecute(this.ctx);
        funEval.execute(lstParam);
        return funEval.afterExecute();
    }

    public static void main(String[] args) {
    }

    static class SymmetryNumber {
        SymmetryNumber() {
        }

        private int[] divideNumber(int num) {
            int i = 0;
            int srcnum = num;
            while (srcnum / 10 >= 1) {
                srcnum /= 10;
                ++i;
            }
            int[] arr = new int[i + 1];
            i = 0;
            while (num / 10 >= 1) {
                arr[i++] = num % 10;
                num /= 10;
            }
            arr[i] = num;
            return arr;
        }

        public boolean isSymmetryNumber(int num) {
            if (num < 10) {
                return true;
            }
            int[] arr = this.divideNumber(num);
            boolean flag = true;
            for (int i = 0; i <= arr.length / 2; ++i) {
                if (arr[i] == arr[arr.length - 1 - i]) continue;
                flag = false;
                break;
            }
            return flag;
        }
    }

    static class FunctionInfo {
        int start = 0;
        int end = 0;
        String name = null;
        List lstParam = new ArrayList(8);

        FunctionInfo() {
        }

        public String toString() {
            return this.lstParam.toString();
        }
    }
}

