/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.shr.base.syssetting.EntityF7ConfigCollection;
import com.kingdee.shr.base.syssetting.EntityF7ConfigFactory;
import com.kingdee.shr.base.syssetting.EntityF7ConfigInfo;
import com.kingdee.shr.base.syssetting.IEntityF7Config;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntityF7ConfigMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(EntityF7ConfigMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5f00\u59cb\u8fc1\u79fb\u6570\u636e\u3010\u5b9e\u4f53F7\u914d\u7f6e\u8fc1\u79fb\u3011----------------------------------------------------------------------------");
        EntityF7ConfigCollection shr_collection = new EntityF7ConfigCollection();
        EntityF7ConfigCollection eas_collection = new EntityF7ConfigCollection();
        shr_collection = this.getSHRData(shrConn, ctx);
        eas_collection = EntityF7ConfigFactory.getRemoteInstance().getEntityF7ConfigCollection();
        EntityF7ConfigCollection diffCollectionSHR = null;
        if (eas_collection.isEmpty()) {
            this.addSHRDataToEAS(ctx, shr_collection);
        } else {
            diffCollectionSHR = this.compareData(ctx, eas_collection, shr_collection);
            if (diffCollectionSHR.size() > 0) {
                this.addSHRDataToEAS(ctx, diffCollectionSHR);
            }
        }
        logger.info((Object)"-------------------------------------------------------\u7ed3\u675f\u8fc1\u79fb\u6570\u636e\u3010\u5b9e\u4f53F7\u914d\u7f6e\u8fc1\u79fb\u3011----------------------------------------------------------------------------");
        logger.info((Object)"-------------------------------------------------------\u5237\u65b0id\u3010\u5b9e\u4f53F7\u914d\u7f6e\u8fc1\u79fb\u3011----------------------------------------------------------------------------");
        this.do_moveAfter(ctx);
        return null;
    }

    private void do_moveAfter(Context ctx) throws EASBizException, BOSException, SQLException {
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BS_EntityF7Config", "FcreatorID");
    }

    public EntityF7ConfigCollection compareData(Context ctx, EntityF7ConfigCollection eas_collection, EntityF7ConfigCollection shr_collection) {
        EntityF7ConfigInfo infoEAS = null;
        EntityF7ConfigInfo infoSHR = null;
        EntityF7ConfigCollection diffCollectionSHR = new EntityF7ConfigCollection();
        boolean match = false;
        for (int i = 0; i < shr_collection.size(); ++i) {
            infoSHR = shr_collection.get(i);
            for (int j = 0; j < eas_collection.size(); ++j) {
                infoEAS = eas_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS(Context ctx, EntityF7ConfigCollection shr_collection) throws BOSException, EASBizException {
        EntityF7ConfigInfo info = null;
        IEntityF7Config EntityF7 = EntityF7ConfigFactory.getRemoteInstance();
        for (int i = 0; i < shr_collection.size(); ++i) {
            info = shr_collection.get(i);
            EntityF7.addnew((CoreBaseInfo)info);
        }
    }

    public EntityF7ConfigCollection getSHRData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BS_EntityF7Config";
        EntityF7ConfigCollection shrCollection = new EntityF7ConfigCollection();
        EntityF7ConfigInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BS_EntityF7Config".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fentityname = colummnsmap.containsKey("fentityname".toUpperCase()) ? rs.getString("fentityname") : "";
                String f7 = colummnsmap.containsKey("f7".toUpperCase()) ? rs.getString("f7") : "";
                String fdescription = colummnsmap.containsKey("fdescription".toUpperCase()) ? rs.getString("fdescription") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String ffunctionname = colummnsmap.containsKey("ffunctionname".toUpperCase()) ? rs.getString("ffunctionname") : "";
                String fparam = colummnsmap.containsKey("fparam".toUpperCase()) ? rs.getString("fparam") : "";
                String fdisplayformat = colummnsmap.containsKey("fdisplayformat".toUpperCase()) ? rs.getString("fdisplayformat") : "";
                shrInfo = new EntityF7ConfigInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setEntityName(fentityname);
                shrInfo.setF7(f7);
                shrInfo.setDescription(fdescription);
                shrInfo.setFunctionName(ffunctionname);
                shrInfo.setParam(fparam);
                shrInfo.setDisplayFormat(fdisplayformat);
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

