/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IJobCategory;
import com.kingdee.eas.basedata.org.JobCategoryCollection;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobCategoryInfo;
import com.kingdee.eas.basedata.org.JobFamilyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.util.BaseDataUpdateTool;
import com.kingdee.eas.hr.mvdt.util.WriteExcelDataTool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class JobCategoryMoveHandler {
    public static final String BOSTYPE = "B48B2DB6";
    public static List<String> excelHead = new ArrayList<String>();

    public String verifyData(Connection shrConn, Context ctx, List<List<String>> list) throws BOSException, EASBizException {
        String oql = "select id,name,number,parent,parent.name,parent.id";
        JobCategoryCollection JobCategoryCollectionEAS = JobCategoryFactory.getLocalInstance((Context)ctx).getJobCategoryCollection(oql);
        JobCategoryCollection JobCategoryCollectionSHR = this.querySHRData(shrConn, ctx);
        this.compareData(ctx, JobCategoryCollectionEAS, JobCategoryCollectionSHR, list);
        return null;
    }

    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_JobCategory";
        String compareKey = "FNUMBER";
        BaseDataUpdateTool.commonUpdate(shrConn, tableName, "", ctx, 0);
        return null;
    }

    private JobCategoryCollection compareData(Context ctx, JobCategoryCollection JobCategoryCollectionEAS, JobCategoryCollection JobCategoryCollectionSHR, List<List<String>> list) throws BOSException, EASBizException {
        int j;
        int i;
        JobCategoryInfo infoEAS = null;
        JobCategoryInfo infoSHR = null;
        boolean match = false;
        String oql = "where bosType ='B48B2DB6'";
        SynIdMappingFactory.getLocalInstance(ctx).delete(oql);
        for (i = 0; i < JobCategoryCollectionSHR.size(); ++i) {
            infoSHR = JobCategoryCollectionSHR.get(i);
            for (j = 0; j < JobCategoryCollectionEAS.size(); ++j) {
                infoEAS = JobCategoryCollectionEAS.get(j);
                if (!infoEAS.getName().equals(infoSHR.getName())) continue;
                this.generateMappingTable(ctx, infoSHR, infoEAS);
                this.generateMappingTrueExcelData(ctx, infoSHR, infoEAS, list);
                match = true;
                break;
            }
            if (!match) {
                this.generateNotFoundInEASMappingExcelData(ctx, infoSHR, infoEAS, list);
                continue;
            }
            match = false;
        }
        match = true;
        for (i = 0; i < JobCategoryCollectionEAS.size(); ++i) {
            infoEAS = JobCategoryCollectionEAS.get(i);
            for (j = 0; j < JobCategoryCollectionSHR.size(); ++j) {
                infoSHR = JobCategoryCollectionSHR.get(j);
                if (infoEAS.getName().equals(infoSHR.getName())) continue;
                match = false;
                break;
            }
            if (match) continue;
            this.generateNotFoundInSHRMappingExcelData(ctx, infoSHR, infoEAS, list);
            match = true;
        }
        return null;
    }

    private void generateMappingTable(Context ctx, JobCategoryInfo infoSHR, JobCategoryInfo infoEAS) throws EASBizException, BOSException {
        String infoSHRId = infoSHR.getId().toString();
        String infoEASId = infoEAS.getId().toString();
        SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
        synIdMappingInfo.setShrId(infoSHRId);
        synIdMappingInfo.setEasId(infoEASId);
        synIdMappingInfo.setBosType(BOSTYPE);
        SynIdMappingFactory.getLocalInstance(ctx).addnew(synIdMappingInfo);
    }

    private void generateMappingTrueExcelData(Context ctx, JobCategoryInfo infoSHR, JobCategoryInfo infoEAS, List<List<String>> list) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber().toString());
        resultRow.add(infoSHR.getName());
        resultRow.add(infoSHR.getJobFamily().getName());
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getName());
        if (infoEAS.getParent() != null) {
            resultRow.add(infoEAS.getParent().getName());
        } else {
            resultRow.add("");
        }
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(true));
        resultRow.add("");
        list.add(resultRow);
    }

    private void generateNotFoundInEASMappingExcelData(Context ctx, JobCategoryInfo infoSHR, JobCategoryInfo infoEAS, List<List<String>> list) throws EASBizException, BOSException {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getName());
        resultRow.add(infoSHR.getJobFamily().getName());
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(false));
        if (JobCategoryFactory.getLocalInstance((Context)ctx).exists("where number ='" + infoSHR.getNumber() + "'")) {
            resultRow.add(WriteExcelDataTool.transBooleanToChinese(true));
        } else {
            resultRow.add("");
        }
        list.add(resultRow);
    }

    private void generateNotFoundInSHRMappingExcelData(Context ctx, JobCategoryInfo infoSHR, JobCategoryInfo infoEAS, List<List<String>> list) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getName());
        if (infoEAS.getParent() != null) {
            resultRow.add(infoEAS.getParent().getName());
        } else {
            resultRow.add("");
        }
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(false));
        resultRow.add("");
        list.add(resultRow);
    }

    public void syncSHRFieldValueToEAS(Context ctx, JobCategoryInfo infoSHR, JobCategoryInfo infoEAS) throws EASBizException, BOSException {
        infoEAS.setDescription(infoSHR.getDescription());
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("unitLayer"));
        items.add(new SelectorItemInfo("description"));
        JobCategoryFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)infoEAS, items);
    }

    public JobCategoryCollection querySHRData(Connection shrConn, Context ctx) throws BOSException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select category.fid as fid, category.fname_l2 as fname_l2,category.fnumber as fnumber,family.fid as familyId,family.fname_l2 as familyName from T_ORG_JobCategory category left join T_HR_JobFamily family on category.FJobFamilyID = family.fid";
        JobCategoryCollection shrCollection = new JobCategoryCollection();
        JobCategoryInfo shrInfo = null;
        JobFamilyInfo familyInfo = null;
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fname_l2 = rs.getString("fname_l2");
                String fnumber = rs.getString("fnumber");
                String familyName = rs.getString("familyName");
                String familyId = rs.getString("familyId");
                shrInfo = new JobCategoryInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setNumber(fnumber);
                shrInfo.setName(fname_l2);
                familyInfo = new JobFamilyInfo();
                familyInfo.setId(BOSUuid.read((String)familyId));
                familyInfo.setName(familyName);
                shrInfo.setJobFamily(familyInfo);
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return shrCollection;
    }

    public void addSHRDataToEAS(Context ctx, JobCategoryCollection JobCategoryCollectionSHR) throws BOSException, EASBizException {
        JobCategoryInfo info = null;
        IJobCategory JobCategory = JobCategoryFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < JobCategoryCollectionSHR.size(); ++i) {
            info = JobCategoryCollectionSHR.get(i);
            JobCategory.addnew((CoreBaseInfo)info);
        }
    }

    static {
        excelHead.add("\u804c\u4f4d\u7c7b\u7f16\u7801");
        excelHead.add("\u804c\u4f4d\u7c7b\u540d\u79f0");
        excelHead.add("\u804c\u4f4d\u65cf");
        excelHead.add("\u804c\u52a1\u7c7b\u578b\u7f16\u7801");
        excelHead.add("\u804c\u52a1\u7c7b\u578b\u540d\u79f0\t");
        excelHead.add("\u4e0a\u7ea7\u804c\u52a1\u7c7b\u578b\t");
        excelHead.add("\u662f\u5426\u5339\u914d");
        excelHead.add("\u7f16\u7801\u91cd\u590d");
    }
}

