/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.shr.base.syssetting.BelongDomainType;
import com.kingdee.shr.base.syssetting.IMSFConfig;
import com.kingdee.shr.base.syssetting.MSFConfigCollection;
import com.kingdee.shr.base.syssetting.MSFConfigFactory;
import com.kingdee.shr.base.syssetting.MSFConfigInfo;
import com.kingdee.shr.base.syssetting.OsfCategoryInfo;
import com.kingdee.shr.base.syssetting.ServiceLevel;
import com.kingdee.shr.base.syssetting.ServiceTypeEnum;
import com.kingdee.shr.base.syssetting.StateEnum;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class MSFConfigMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(MSFConfigMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5f00\u59cb\u8fc1\u79fb\u3010OSF\u3011----------------------------------------------------------------------------");
        MSFConfigCollection shr_msfCollection = new MSFConfigCollection();
        MSFConfigCollection eas_msfCollection = new MSFConfigCollection();
        shr_msfCollection = this.getSHRData(shrConn, ctx);
        eas_msfCollection = MSFConfigFactory.getRemoteInstance().getMSFConfigCollection();
        MSFConfigCollection diffCollectionSHR = null;
        if (eas_msfCollection.isEmpty()) {
            this.addSHRDataToEAS(ctx, shr_msfCollection);
        } else {
            diffCollectionSHR = this.compareData(ctx, eas_msfCollection, shr_msfCollection);
            if (diffCollectionSHR.size() > 0) {
                this.addSHRDataToEAS(ctx, diffCollectionSHR);
            }
        }
        logger.info((Object)"-------------------------------------------------------\u7ed3\u675f\u8fc1\u79fb\u3010OSF\u3011----------------------------------------------------------------------------");
        this.do_moveAfter(ctx);
        return null;
    }

    private void do_moveAfter(Context ctx) throws EASBizException, BOSException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5237\u65b0ID\u3010OSF\u3011----------------------------------------------------------------------------");
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BD_MSFConfig", "FCREATORID");
    }

    public MSFConfigCollection compareData(Context ctx, MSFConfigCollection eas_msfCollection, MSFConfigCollection shr_msfCollection) {
        MSFConfigInfo infoEAS = null;
        MSFConfigInfo infoSHR = null;
        MSFConfigCollection diffCollectionSHR = new MSFConfigCollection();
        boolean match = false;
        for (int i = 0; i < shr_msfCollection.size(); ++i) {
            infoSHR = shr_msfCollection.get(i);
            if (infoSHR.getNumber() == null) {
                match = false;
                continue;
            }
            for (int j = 0; j < eas_msfCollection.size(); ++j) {
                infoEAS = eas_msfCollection.get(j);
                if (infoEAS.getNumber() == null || !infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS(Context ctx, MSFConfigCollection shr_msfCollection) throws BOSException, EASBizException {
        MSFConfigInfo info = null;
        IMSFConfig MSFC = MSFConfigFactory.getRemoteInstance();
        for (int i = 0; i < shr_msfCollection.size(); ++i) {
            info = shr_msfCollection.get(i);
            boolean isExist = this.checkExist(info.getNumber());
            if (isExist) continue;
            MSFC.addnew((CoreBaseInfo)info);
        }
    }

    private boolean checkExist(String number) throws EASBizException, BOSException {
        if (number == null || number.isEmpty()) {
            return true;
        }
        return MSFConfigFactory.getRemoteInstance().exists("where number='" + number + "'");
    }

    public MSFConfigCollection getSHRData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BD_MSFConfig";
        MSFConfigCollection shrCollection = new MSFConfigCollection();
        MSFConfigInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BD_MSFConfig".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fservicelevel = colummnsmap.containsKey("fservicelevel".toUpperCase()) ? rs.getString("fservicelevel") : "";
                String fbelongdomain = colummnsmap.containsKey("fbelongdomain".toUpperCase()) ? rs.getString("fbelongdomain") : "";
                String fconfig = colummnsmap.containsKey("fconfig".toUpperCase()) ? rs.getString("fconfig") : "";
                String fcategoryid = colummnsmap.containsKey("fcategoryid".toUpperCase()) ? rs.getString("fcategoryid") : "";
                String fstate = colummnsmap.containsKey("fstate".toUpperCase()) ? rs.getString("fstate") : "";
                String fservicetype = colummnsmap.containsKey("fservicetype".toUpperCase()) ? rs.getString("fservicetype") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fservicename = colummnsmap.containsKey("fservicename".toUpperCase()) ? rs.getString("fservicename") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new MSFConfigInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setServicelevel(ServiceLevel.getEnum((String)fservicelevel));
                shrInfo.setBelongDomain(BelongDomainType.getEnum((String)fbelongdomain));
                shrInfo.setConfig(fconfig);
                if (fcategoryid != null && !fcategoryid.isEmpty()) {
                    OsfCategoryInfo osfCtg = new OsfCategoryInfo();
                    osfCtg.setId(BOSUuid.read((String)fcategoryid));
                    shrInfo.setCategory(osfCtg);
                }
                shrInfo.setState(StateEnum.getEnum((String)fstate));
                shrInfo.setServiceType(ServiceTypeEnum.getEnum((String)fservicetype));
                shrInfo.setNumber(fnumber);
                shrInfo.setServiceName(fservicename);
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

