/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.baseconfig.IQueryConfig;
import com.kingdee.shr.baseconfig.IQueryConfigField;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldCollection;
import com.kingdee.shr.baseconfig.QueryConfigFieldFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.QueryConfigInfo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryConfigMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(QueryConfigMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveQueryConfig(shrConn, ctx);
        this.moveQueryConfigField(shrConn, ctx);
        this.do_moveAfter(shrConn, ctx);
        return null;
    }

    private void moveQueryConfigField(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        boolean isMove = true;
        try {
            String tableName = "T_HR_QueryConfigField";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                isMove = false;
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            SHRMoveDataHelpUtil.clearHrData(shrConn, ctx, "T_HR_QueryConfigField", "T_HR_QueryConfigField_tmp", "FALIAS");
            QueryConfigFieldCollection shr_QueryFiled_collection = new QueryConfigFieldCollection();
            shr_QueryFiled_collection = this.getSHRData_QueryFiled(shrConn, ctx);
            String delSql = "delete from T_HR_QueryConfigField";
            DbUtil.execute((Context)ctx, (String)delSql);
            QueryConfigFieldCollection eas_QueryFiled_collection = new QueryConfigFieldCollection();
            eas_QueryFiled_collection = QueryConfigFieldFactory.getRemoteInstance().getQueryConfigFieldCollection();
            QueryConfigFieldCollection diffQueryFieldCollectionSHR = null;
            if (eas_QueryFiled_collection.isEmpty()) {
                this.addSHRDataToEAS_QueryFiled(ctx, shr_QueryFiled_collection);
            } else {
                diffQueryFieldCollectionSHR = this.compareData_QueryFiled(ctx, eas_QueryFiled_collection, shr_QueryFiled_collection);
                if (diffQueryFieldCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS_QueryFiled(ctx, diffQueryFieldCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_QueryConfigField".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (isMove) {
                SHRMoveDataHelpUtil.restore(shrConn, "T_HR_QueryConfigField", "T_HR_QueryConfigField_tmp", "FALIAS");
            }
        }
    }

    private void moveQueryConfig(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        boolean isMove = true;
        try {
            String tableName = "T_HR_QueryConfig";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                isMove = false;
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            SHRMoveDataHelpUtil.clearHrData(shrConn, ctx, "T_HR_QueryConfig", "T_HR_QueryConfig_tmp", "FNAME_L2");
            String delSql = "delete  from T_HR_QueryConfig";
            DbUtil.execute((Context)ctx, (String)delSql);
            QueryConfigCollection shr_QueryConfig_collection = new QueryConfigCollection();
            shr_QueryConfig_collection = this.getSHRData_QueryConfig(shrConn, ctx);
            QueryConfigCollection eas_QueryConfig_collection = new QueryConfigCollection();
            eas_QueryConfig_collection = QueryConfigFactory.getRemoteInstance().getQueryConfigCollection();
            QueryConfigCollection diffQueryConfigCollectionSHR = null;
            if (eas_QueryConfig_collection.isEmpty()) {
                this.addSHRDataToEAS_QueryConfig(ctx, shr_QueryConfig_collection);
            } else {
                diffQueryConfigCollectionSHR = this.compareData_QueryConfig(ctx, eas_QueryConfig_collection, shr_QueryConfig_collection);
                if (diffQueryConfigCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS_QueryConfig(ctx, diffQueryConfigCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_HR_QueryConfig".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (isMove) {
                SHRMoveDataHelpUtil.restore(shrConn, "T_HR_QueryConfig", "T_HR_QueryConfig_tmp", "FNAME_L2");
            }
        }
    }

    private void do_moveAfter(Connection shrConn, Context ctx) throws EASBizException, BOSException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5237\u65b0ID\u3010\u67e5\u8be2\u914d\u7f6e\u3011----------------------------------------------------------------------------");
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_HR_QueryConfig", "FCREATORID");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_HR_QueryConfig".toUpperCase(), "finished");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_HR_QueryConfigField".toUpperCase(), "finished");
    }

    public QueryConfigFieldCollection compareData_QueryFiled(Context ctx, QueryConfigFieldCollection eas_QueryFiled_collection, QueryConfigFieldCollection shr_QueryFiled_collection) {
        QueryConfigFieldInfo infoEAS = null;
        QueryConfigFieldInfo infoSHR = null;
        QueryConfigFieldCollection diffCollectionSHR = new QueryConfigFieldCollection();
        boolean match = false;
        for (int i = 0; i < shr_QueryFiled_collection.size(); ++i) {
            infoSHR = shr_QueryFiled_collection.get(i);
            for (int j = 0; j < eas_QueryFiled_collection.size(); ++j) {
                infoEAS = eas_QueryFiled_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_QueryFiled(Context ctx, QueryConfigFieldCollection shr_QueryFiled_collection) throws EASBizException, BOSException {
        QueryConfigFieldInfo info = null;
        IQueryConfigField QueryFiled = QueryConfigFieldFactory.getRemoteInstance();
        for (int i = 0; i < shr_QueryFiled_collection.size(); ++i) {
            info = shr_QueryFiled_collection.get(i);
            if (info.getParent() != null) {
                String ConfigId = info.getParent().getId().toString();
                if (!QueryConfigFactory.getRemoteInstance().exists("where id='" + ConfigId + "'")) continue;
            }
            QueryFiled.addnew(info);
        }
    }

    public QueryConfigCollection compareData_QueryConfig(Context ctx, QueryConfigCollection eas_QueryConfig_collection, QueryConfigCollection shr_QueryConfig_collection) {
        QueryConfigInfo infoEAS = null;
        QueryConfigInfo infoSHR = null;
        QueryConfigCollection diffCollectionSHR = new QueryConfigCollection();
        boolean match = false;
        for (int i = 0; i < shr_QueryConfig_collection.size(); ++i) {
            infoSHR = shr_QueryConfig_collection.get(i);
            for (int j = 0; j < eas_QueryConfig_collection.size(); ++j) {
                infoEAS = eas_QueryConfig_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_QueryConfig(Context ctx, QueryConfigCollection shr_QueryConfig_collection) throws EASBizException, BOSException {
        QueryConfigInfo info = null;
        IQueryConfig QueryConfig = QueryConfigFactory.getRemoteInstance();
        for (int i = 0; i < shr_QueryConfig_collection.size(); ++i) {
            info = shr_QueryConfig_collection.get(i);
            boolean isExist = this.checkNumberExist(info.getNumber(), info.getScheme().getId().toString());
            if (isExist) {
                String newNumber = this.changeNumber(info.getNumber(), info.getScheme().getId().toString());
                info.setNumber(newNumber);
            }
            QueryConfig.addnew(info);
        }
    }

    private String changeNumber(String oldnumber, String schemeId) throws EASBizException, BOSException {
        int point_index = oldnumber.lastIndexOf("_shr");
        String newnumber = "";
        if (point_index == -1) {
            oldnumber = oldnumber + "_shr" + 1;
            point_index = oldnumber.lastIndexOf("_shr");
        }
        int version = Integer.parseInt(oldnumber.substring(point_index + 4, oldnumber.length()));
        String number = oldnumber.substring(0, point_index);
        while (true) {
            newnumber = number + "_shr" + version;
            if (!QueryConfigFactory.getRemoteInstance().exists("where number='" + newnumber + "' and scheme.id ='" + schemeId + "'")) break;
            ++version;
        }
        return newnumber;
    }

    public boolean checkNumberExist(String number, String schemeId) throws EASBizException, BOSException {
        if (number == null || number.isEmpty()) {
            return true;
        }
        return QueryConfigFactory.getRemoteInstance().exists("where number='" + number + "' and scheme.id ='" + schemeId + "'");
    }

    public QueryConfigFieldCollection getSHRData_QueryFiled(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_QueryConfigField";
        QueryConfigFieldCollection shrCollection = new QueryConfigFieldCollection();
        QueryConfigFieldInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_QueryConfigField".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String ffactfieldid = colummnsmap.containsKey("ffactfieldid".toUpperCase()) ? rs.getString("ffactfieldid") : "";
                String findex = colummnsmap.containsKey("findex".toUpperCase()) ? rs.getString("findex") : "";
                String falias = colummnsmap.containsKey("falias".toUpperCase()) ? rs.getString("falias") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String ffieldname = colummnsmap.containsKey("ffieldname".toUpperCase()) ? rs.getString("ffieldname") : "";
                String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
                shrInfo = new QueryConfigFieldInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setAlias(falias);
                shrInfo.setFieldName(ffieldname);
                shrInfo.setUipk(fuipk);
                if (findex != null && !findex.isEmpty()) {
                    shrInfo.setIndex(Integer.parseInt(findex));
                }
                if (ffactfieldid != null && !ffactfieldid.isEmpty()) {
                    StructureConfigColumnsInfo info = new StructureConfigColumnsInfo();
                    info.setId(BOSUuid.read((String)ffactfieldid));
                    shrInfo.setFactField(info);
                }
                if (fparentid != null && !fparentid.isEmpty()) {
                    QueryConfigInfo config = new QueryConfigInfo();
                    config.setId(BOSUuid.read((String)fparentid));
                    shrInfo.setParent(config);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public QueryConfigCollection getSHRData_QueryConfig(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_QueryConfig";
        QueryConfigCollection shrCollection = new QueryConfigCollection();
        QueryConfigInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_QueryConfig".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String fstructureid = colummnsmap.containsKey("fstructureid".toUpperCase()) ? rs.getString("fstructureid") : "";
                String fschemeid = colummnsmap.containsKey("fschemeid".toUpperCase()) ? rs.getString("fschemeid") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new QueryConfigInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                if (fparentid != null && !fparentid.isEmpty()) {
                    QueryConfigInfo config = new QueryConfigInfo();
                    config.setId(BOSUuid.read((String)fparentid));
                    shrInfo.setParent(config);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                if (fschemeid != null && !fschemeid.isEmpty()) {
                    StructureConfigSchemeInfo scheme = new StructureConfigSchemeInfo();
                    scheme.setId(BOSUuid.read((String)fschemeid));
                    shrInfo.setScheme(scheme);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

