/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.SynIdMappingUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.ws.ca.utils.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SHRWarningRuleMoveHandler
implements ISHRMoveDataHandler {
    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        Connection easConn = null;
        try {
            easConn = EJBFactory.getConnection((Context)ctx);
            TableColumnSyncTool.synSHRTableInfoToEAS(ctx, shrConn, easConn, "T_FW_ForewarnMsg");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SHRDbConnectionTool.releasDBResource(easConn, null, null);
        }
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_FOREWARNOBJECT", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_ForewarnObject", " where fItemId in (select fid from T_FW_ForewarnItem)", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_FOREWARNOBJECT");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_RECEIVER", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_Receiver", " where fItemID in (select fid from T_FW_ForewarnItem)", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_RECEIVER");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_FOREWARNITEM", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_ForewarnItem", "", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_FOREWARNITEM");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_SCHEDULE", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_schedule", "", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_SCHEDULE");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_THRESHOLD", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_Threshold", " where fConditionID in (select fid from T_FW_Condition)", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_THRESHOLD");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_CONDITION", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_Condition", " where fid in (select fConditionID from T_FW_ForewarnItem)", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_CONDITION");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_FOREWARNMSG", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_ForewarnMsg", " where fid in (select fMessageID from T_FW_ForewarnItem)", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_FOREWARNMSG");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_RIGHTNOWACTION", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_RightnowAction", " where fForeWarnTemplateId in (select fid from T_FW_ForewarnItem)", ctx, 1000);
        this.updateSHRMvTableListSatus(ctx, "T_FW_RIGHTNOWACTION");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_FW_DYNRECEIVERS", "moving");
        UpdateTool.commonUpdate(shrConn, "T_FW_DynReceivers", " where fFWItemID in (select fid from T_FW_ForewarnItem)", ctx, 1000);
        this.refreshFWReceiverValue(shrConn, ctx);
        this.updateSHRMvTableListSatus(ctx, "T_FW_DYNRECEIVERS");
        return null;
    }

    private void updateSHRMvTableListSatus(Context ctx, String tableName) throws BOSException {
        String sql = "update T_HR_SHRMvTableList set FMvSatus='finished' where FMVTABLENAME='" + tableName + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void refreshFWReceiverValue(Connection shrConn, Context ctx) throws BOSException, SQLException {
        String sql = "select fid,fValue from T_FW_Receiver where FReceiverType in (10,20,60,70)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String refreshSql = "update T_FW_Receiver set fValue=? where fid=?";
        Connection easConn = EJBFactory.getQueryConnection((Context)ctx);
        PreparedStatement pstmt = easConn.prepareStatement(refreshSql);
        try {
            easConn.setAutoCommit(false);
            boolean isCommit = false;
            while (rs.next()) {
                String shrId = rs.getString("FVALUE");
                String easId = SynIdMappingUtil.getIdMappingMap(ctx).get(shrId);
                if (StringUtils.isEmpty((String)easId)) {
                    easId = shrId;
                }
                pstmt.setString(1, easId);
                pstmt.setString(2, rs.getString("fid"));
                pstmt.addBatch();
                isCommit = true;
            }
            if (isCommit) {
                pstmt.executeBatch();
                easConn.commit();
                pstmt.clearBatch();
            }
        }
        catch (Exception e) {
            SHRDbConnectionTool.releasDBResource(shrConn, pstmt, (ResultSet)rs);
        }
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }
}

