/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.SHRMvTableListCollection;
import com.kingdee.eas.hr.mvdt.SHRMvTableListFactory;
import com.kingdee.eas.hr.mvdt.SHRMvTableListInfo;
import com.kingdee.eas.hr.mvdt.TableColumnConfigCollection;
import com.kingdee.eas.hr.mvdt.TableColumnConfigInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.SHRMoveOriginalDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRDataMoveConstant;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.SynIdMappingUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.XMLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WorkFlowXMLColumnUpdateHandler
implements ISHRMoveDataHandler {
    private boolean refreshFlag = false;

    public void test(Context ctx) {
        try {
            this.reCheckWFTablesColumns(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveData(shrConn, ctx, "T_WFD_PROCESSDEF", "FPROCESSXML", "FPROCESSID", " WHERE FPACKAGENAME LIKE '%hr%'");
        this.moveData(shrConn, ctx, "T_WFR_PROCDEF", "FKPDL", "FINNERVERSION,FPROCDEFID", " WHERE FPACKAGENAME LIKE '%hr%'");
        this.reCheckWFTablesColumns(ctx);
        this.commonUpdate(ctx);
        return null;
    }

    public String moveData(Connection shrConn, Context ctx, String table, String column, String key, String condition) throws BOSException, EASBizException, SQLException {
        if (condition == null || "".equals(condition.trim())) {
            condition = " WHERE FPACKAGENAME LIKE '%hr%'";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append("SELECT ").append(key).append("," + column).append(" FROM ").append(table).append(" " + condition);
        ResultSet rs = null;
        Statement stmt = null;
        Connection easConn = null;
        easConn = EJBFactory.getQueryConnection((Context)ctx);
        stmt = easConn.createStatement();
        rs = stmt.executeQuery(sb.toString());
        String[] keys = key.split(",");
        HashMap<String, String> idMap = SynIdMappingUtil.getIdMappingMap(ctx);
        while (rs.next()) {
            String[][] keyValue = new String[keys.length][2];
            for (int i = 0; i < keys.length; ++i) {
                keyValue[i][0] = keys[i];
                keyValue[i][1] = rs.getString(keys[i]);
            }
            Clob clob = rs.getClob(column);
            if (clob == null) continue;
            String value = clob.getSubString(1L, (int)clob.length());
            try {
                Document doc = XMLUtil.string2XML(value);
                this.refreshFlag = false;
                doc = this.refreshDocument(doc, idMap);
                if (!this.refreshFlag) continue;
                this.updateColumn(ctx, doc, table, column, keyValue);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Document refreshDocument(Document doc, HashMap<String, String> idMap) {
        int participantLen = doc.getElementsByTagName("Participant").getLength();
        for (int i = 0; i < participantLen; ++i) {
            int attributesLen = doc.getElementsByTagName("Participant").item(i).getAttributes().getLength();
            for (int j = 0; j < attributesLen; ++j) {
                String tmpVal;
                String tmpKey = doc.getElementsByTagName("Participant").item(i).getAttributes().item(j).getNodeValue();
                if (!StringUtils.isNotBlank((String)tmpKey) || !StringUtils.isNotBlank((String)(tmpVal = idMap.get(tmpKey)))) continue;
                this.refreshFlag = true;
                doc.getElementsByTagName("Participant").item(i).getAttributes().item(j).setNodeValue(tmpVal);
            }
            int childLen = doc.getElementsByTagName("Participant").item(i).getChildNodes().getLength();
            for (int k = 0; k < childLen; ++k) {
                String tmpVal;
                String tmpKey = doc.getElementsByTagName("Participant").item(i).getChildNodes().item(k).getTextContent();
                if (!StringUtils.isNotBlank((String)tmpKey) || !StringUtils.isNotBlank((String)(tmpVal = idMap.get(tmpKey)))) continue;
                this.refreshFlag = true;
                doc.getElementsByTagName("Participant").item(i).getChildNodes().item(k).setTextContent(tmpVal);
            }
        }
        return doc;
    }

    private String updateColumn(Context ctx, Document doc, String table, String column, String[][] keyValue) throws SQLException, TransformerException, BOSException {
        String strXML = XMLUtil.XML2String(doc);
        StringReader reader = new StringReader(strXML);
        StringBuffer updateSB = new StringBuffer("");
        updateSB.append("UPDATE ").append(table).append(" SET " + column + "=?").append(" WHERE ");
        for (int i = 0; i < keyValue.length; ++i) {
            updateSB.append(keyValue[i][0]).append("='").append(keyValue[i][1] + "'").append(" and ");
        }
        updateSB.delete(updateSB.length() - 4, updateSB.length());
        PreparedStatement upstmt = null;
        Connection easConn = null;
        easConn = EJBFactory.getQueryConnection((Context)ctx);
        easConn.setAutoCommit(false);
        upstmt = easConn.prepareStatement(updateSB.toString());
        upstmt.setCharacterStream(1, (Reader)reader, strXML.length());
        upstmt.addBatch();
        if (upstmt != null && easConn != null) {
            upstmt.executeBatch();
            easConn.commit();
            upstmt.clearBatch();
        }
        SHRDbConnectionTool.releasDBResource(easConn, upstmt, null);
        return null;
    }

    public void commonUpdate(Context ctx) throws BOSException, SQLException, EASBizException {
        String sql = "select * from T_HR_SHRMVTABLELIST WHERE FBIZTYPE = 'WF' AND FMVTABLENAME IS NOT NULL";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (iRowSet.size() > 0) {
            String[][] resTableArray = new String[iRowSet.size()][3];
            int tempIndex = 0;
            while (iRowSet.next()) {
                resTableArray[tempIndex][0] = iRowSet.getString("fmvTableName");
                resTableArray[tempIndex][1] = iRowSet.getString("fid");
                resTableArray[tempIndex++][2] = "0";
            }
            SHRMoveOriginalDataHandler move = new SHRMoveOriginalDataHandler();
            move.autoUpdateTablesMultiThreadsAction(ctx, resTableArray);
        }
    }

    public void reCheckWFTablesColumns(Context ctx) throws BOSException, InterfaceDataBaseException, SQLException {
        String oqlString = " WHERE DATATYPE = 2 AND bizType IN ('ATS','ATSC','CMP','REC','PER','TRA','DEP','PAD','SOC','CB','COS') AND MVTABLENAME!=null";
        SHRMvTableListCollection coll = SHRMvTableListFactory.getLocalInstance(ctx).getSHRMvTableListCollection(oqlString);
        Connection easConn = null;
        easConn = EJBFactory.getQueryConnection((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            SHRMvTableListInfo info = coll.get(i);
            String tableName = info.getMvTableName();
            Map<String, ColumnInfo> colInfoMap = TableColumnSyncTool.getEASTableColumnMap(easConn, tableName.trim().toUpperCase());
            for (String colNameString : colInfoMap.keySet()) {
                ColumnInfo columnInfo = colInfoMap.get(colNameString);
                String colName = columnInfo.getColumnName();
                String colType = columnInfo.getColumnType();
                if (!"VARCHAR2".equalsIgnoreCase(colType) && !"varchar".equalsIgnoreCase(colType) || columnInfo.getCharLength() != 44) continue;
                String testSql = "SELECT TOP 1 " + colName + " FROM " + tableName + " WHERE " + colName + " IS NOT NULL";
                IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)testSql);
                String tempString = "";
                while (ir.next()) {
                    tempString = ir.getString(1);
                }
                BOSObjectType bosType = BOSUuid.getBOSObjectType((String)tempString, (boolean)true);
                String bosTypeName = WorkFlowXMLColumnUpdateHandler.getBosTypeName(bosType);
                if (bosTypeName.equals("")) continue;
                TableColumnConfigCollection tccc = info.getTblColumns();
                boolean addFlag = true;
                if (tccc != null && !tccc.isEmpty()) {
                    for (int j = 0; j < tccc.size(); ++j) {
                        if (!tccc.get(j).getColumnName().equalsIgnoreCase(colName)) continue;
                        addFlag = false;
                        break;
                    }
                }
                if (!addFlag) continue;
                TableColumnConfigInfo tccInfo = new TableColumnConfigInfo();
                tccInfo.setMvTableName(tableName);
                tccInfo.setColumnName(colName);
                tccInfo.setColumnType(bosTypeName);
                tccInfo.setDataType(1);
                info.getTblColumns().add(tccInfo);
                try {
                    SHRMvTableListFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getBosTypeName(BOSObjectType bosType) {
        if (bosType == null) {
            return "";
        }
        if (bosType.equals((Object)SHRDataMoveConstant.PERSON_BOSTYPE)) {
            return "person";
        }
        if (bosType.equals((Object)SHRDataMoveConstant.ADMINORG_BOSTYPE)) {
            return "adminOrg";
        }
        if (bosType.equals((Object)SHRDataMoveConstant.POSITION_BOSTYPE)) {
            return "position";
        }
        if (bosType.equals((Object)SHRDataMoveConstant.JOB_BOSTYPE)) {
            return "job";
        }
        if (bosType.equals((Object)SHRDataMoveConstant.USER_BOSTYPE)) {
            return "user";
        }
        return "";
    }
}

