/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DB2DecimalConvertUtils {
    private static Logger logger = Logger.getLogger(DB2DecimalConvertUtils.class);
    private static Pattern p1 = Pattern.compile("decimal\\s*\\(\\s*28\\s*,\\s*16\\s*\\)|numeric\\s*\\(\\s*28\\s*,\\s*16\\s*\\)|decimal\\s*\\(\\s*28\\s*,10\\s*\\)|numeric\\s*\\(\\s*28\\s*,\\s*10\\s*\\)", 2);
    private static Pattern p2 = Pattern.compile("decimal\\s*\\(\\s*19\\s*,\\s*4\\s*\\)|numeric\\s*\\(\\s*19\\s*,\\s*4\\s*\\)", 2);

    public static String convertDB2Decimal(String sqlText) {
        sqlText = DB2DecimalConvertUtils.matchResult(p1, sqlText, "decimal(21,8)");
        sqlText = DB2DecimalConvertUtils.matchResult(p2, sqlText, "decimal(17,4)");
        return sqlText;
    }

    private static String matchResult(Pattern p, String sql, String rep) {
        boolean result;
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        boolean findDecimal = result = m.find();
        while (result) {
            m.appendReplacement(sb, rep);
            result = m.find();
        }
        if (findDecimal) {
            m.appendTail(sb);
            String resultString = sb.toString();
            logger.debug((Object)("=====Convert decimal sql: [" + sql + "] to [" + resultString + "]!"));
            return resultString;
        }
        return sql;
    }
}

