/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public final class InetUtil {
    private static Logger logger = Logger.getLogger(InetUtil.class);
    private static int socketTimeout = Integer.parseInt(System.getProperty("SocketTimeOut", "3000"));
    private static String localIP;
    private static ArrayList localIPList;

    public static boolean hasMoreThanOneNetworkInterface() {
        try {
            Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
            if (enu.hasMoreElements()) {
                enu.nextElement();
                if (enu.hasMoreElements()) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Get localhost networkinterface exception!", (Throwable)e);
        }
        return false;
    }

    public static String getLocalIP() {
        if (localIP == null || localIP.length() <= 0) {
            InetUtil.getLocalIPList(true);
            if (localIP == null || localIP.length() <= 0) {
                localIP = "127.0.0.1";
            }
        }
        return localIP;
    }

    public static String getLocalPrivateIP() {
        return "127.0.0.1";
    }

    public static boolean isMultiNetworkInterface() {
        ArrayList<NetworkInterface> list = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
            while (enu.hasMoreElements()) {
                NetworkInterface ni = enu.nextElement();
                if ("lo".equalsIgnoreCase(ni.getDisplayName())) continue;
                list.add(ni);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Check isMultiNetworkInterface exception!", (Throwable)e);
            return true;
        }
        return list.size() > 1;
    }

    public static ArrayList getLocalIPList() {
        if (localIPList.size() == 0) {
            InetUtil.getLocalIPList(false);
        }
        return localIPList;
    }

    private static ArrayList getLocalIPList(boolean initLocalIP) {
        block6: {
            if (localIPList.size() == 0) {
                try {
                    Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
                    while (enu.hasMoreElements()) {
                        NetworkInterface ni = enu.nextElement();
                        Enumeration<InetAddress> ias = ni.getInetAddresses();
                        while (ias.hasMoreElements()) {
                            String[] ips;
                            InetAddress localAddress = ias.nextElement();
                            String hostAddress = localAddress.getHostAddress();
                            if (hostAddress == null || (ips = hostAddress.split("\\.")).length != 4 || "127.0.0.1".equals(hostAddress)) continue;
                            if (initLocalIP) {
                                localIP = hostAddress;
                            }
                            localIPList.add(hostAddress);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Get localhost ip exception!", (Throwable)e);
                    if (!initLocalIP) break block6;
                    localIP = "127.0.0.1";
                }
            }
        }
        return localIPList;
    }

    public static void setLocalIP(String ip) {
        localIP = ip;
    }

    public static boolean isLocalComputer(String ipORname) {
        try {
            InetAddress varAddress = InetAddress.getByName(ipORname.trim());
            Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
            while (enu.hasMoreElements()) {
                NetworkInterface ni = enu.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress localAddress = ias.nextElement();
                    String hostName = localAddress.getHostName();
                    String hostAddress = localAddress.getHostAddress();
                    if (!varAddress.getHostName().equalsIgnoreCase(hostName) && !varAddress.getHostAddress().equalsIgnoreCase(hostAddress)) continue;
                    return true;
                }
            }
            return "127.0.0.1".equalsIgnoreCase(ipORname);
        }
        catch (Exception err) {
            logger.error((Object)err);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnection(String ip, int port) {
        Socket socket = new Socket();
        try {
            InetSocketAddress addr = new InetSocketAddress(ip, port);
            socket.connect(addr, socketTimeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        localIPList = new ArrayList();
        localIP = System.getProperty("localIP");
        if (localIP != null && localIP.length() > 0) {
            logger.info((Object)("Set localIP[" + localIP + "]!"));
        }
    }
}

