/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import java.io.File;

public class JDKUtils {
    public static final String JDK_VENDOR = System.getProperty("java.vendor");
    public static final String JDK_VERSION = System.getProperty("java.version");
    public static final String JAVA_HOME = System.getProperty("java.home");
    public static final String JDK_HOME = JDKUtils.getJDKHome(JAVA_HOME);
    public static final boolean IS_JDK_SUN = JDKUtils.getJDKVendorMatches(JDK_VENDOR, "SUN");
    public static final boolean IS_JDK_HP = JDKUtils.getJDKVendorMatches(JDK_VENDOR, "HP");
    public static final boolean IS_JDK_IBM = JDKUtils.getJDKVendorMatches(JDK_VENDOR, "IBM");
    public static final boolean IS_JDK_BEA = JDKUtils.getJDKVendorMatches(JDK_VENDOR, "BEA");
    public static final boolean IS_JDK_4 = JDKUtils.getJDKVersionMatches(JDK_VERSION, "1.4");
    public static final boolean IS_JDK_5 = JDKUtils.getJDKVersionMatches(JDK_VERSION, "1.5");
    public static final boolean IS_64_BIT_JVM = JDKUtils.isJDK64BitMode();

    private static boolean getJDKVendorMatches(String jdkVendor, String jdkNamePrefix) {
        if (jdkVendor == null) {
            return false;
        }
        return jdkVendor.toUpperCase().startsWith(jdkNamePrefix);
    }

    private static boolean isJDK64BitMode() {
        if (IS_JDK_SUN && "64".equalsIgnoreCase(System.getProperty("sun.arch.data.model"))) {
            return true;
        }
        if (IS_JDK_IBM && "64".equalsIgnoreCase(System.getProperty("com.ibm.vm.bitmode"))) {
            return true;
        }
        if (IS_JDK_BEA && "64".equalsIgnoreCase(System.getProperty("sun.arch.data.model"))) {
            return true;
        }
        return IS_JDK_HP;
    }

    public static int getFeadMaxHeapSize(int total, boolean is64BitJDK) {
        if (is64BitJDK) {
            return (int)((double)total * 0.8) > 2048 ? 2048 : (int)((double)total * 0.8);
        }
        return (int)((double)total * 0.8) > 1536 ? 1536 : (int)((double)total * 0.8);
    }

    public static int getFeadMaxHeapSize(int total, boolean isWindow, boolean is64BitJDK) {
        if (isWindow && !is64BitJDK) {
            return (int)((double)total * 0.8) > 1024 ? 1024 : (int)((double)total * 0.8);
        }
        return (int)((double)total * 0.8) > 2048 ? 2048 : (int)((double)total * 0.8);
    }

    public static int getLowerMaxHeapSize(boolean isWindow, boolean is64BitJDK) {
        if (isWindow) {
            return 768;
        }
        if (is64BitJDK) {
            return 1536;
        }
        return 1024;
    }

    public static int getFeadMaxHeapSize(int total) {
        if (IS_JDK_IBM) {
            if (IS_64_BIT_JVM) {
                return (int)((double)total * 0.8) > 2048 ? 2048 : (int)((double)total * 0.8);
            }
            return (int)((double)total * 0.8) > 1536 ? 1536 : (int)((double)total * 0.8);
        }
        if (IS_JDK_SUN) {
            if (IS_64_BIT_JVM) {
                return (int)((double)total * 0.8) > 2048 ? 2048 : (int)((double)total * 0.8);
            }
            return (int)((double)total * 0.8) > 1536 ? 1536 : (int)((double)total * 0.8);
        }
        if (IS_JDK_HP) {
            if (IS_64_BIT_JVM) {
                return (int)((double)total * 0.8) > 2048 ? 2048 : (int)((double)total * 0.8);
            }
            return (int)((double)total * 0.8) > 1536 ? 1536 : (int)((double)total * 0.8);
        }
        if (IS_JDK_BEA) {
            if (IS_64_BIT_JVM) {
                return (int)((double)total * 0.8) > 2048 ? 2048 : (int)((double)total * 0.8);
            }
            return (int)((double)total * 0.8) > 1536 ? 1536 : (int)((double)total * 0.8);
        }
        return (int)((double)total * 0.8) > 1536 ? 1536 : (int)((double)total * 0.8);
    }

    private static String getJDKHome(String java_home2) {
        try {
            if (java_home2 != null && java_home2.endsWith("jre")) {
                File javahome = new File(java_home2);
                String home = javahome.getCanonicalFile().getParentFile().getCanonicalPath();
                return home;
            }
            return java_home2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean getJDKVersionMatches(String jdkVersion, String jdkVersionPrefix) {
        if (jdkVersion == null) {
            return false;
        }
        return jdkVersion.toUpperCase().indexOf(jdkVersionPrefix) >= 0;
    }
}

