/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AntZipFileAccessor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.FileAccess;
import com.kingdee.eas.hr.mvdt.patch.executeSql.JDKUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.JDKZipFileAccessor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OsUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ZipFileAccessor;
import java.io.IOException;
import java.io.InputStream;

public class JarFileAccess
implements FileAccess,
ZipFileAccessor {
    private ZipFileAccessor accessor;

    public JarFileAccess(String filepath) throws IOException {
        if ("true".equals(System.getProperty("ForceUseJDKZip", "false"))) {
            this.accessor = new JDKZipFileAccessor(filepath);
            return;
        }
        if ("true".equals(System.getProperty("ForceUseAntZip", "false"))) {
            this.accessor = new AntZipFileAccessor(filepath);
            return;
        }
        if (OsUtils.IS_OS_LINUX && JDKUtils.IS_JDK_SUN) {
            this.accessor = new AntZipFileAccessor(filepath);
            return;
        }
        this.accessor = new JDKZipFileAccessor(filepath);
    }

    @Override
    public void close() throws Exception {
        this.accessor.close();
    }

    @Override
    public boolean isFileExist(String filename) {
        return this.accessor.isFileExist(filename);
    }

    @Override
    public InputStream getFileInputStream(String filename) {
        return this.accessor.getFileInputStream(filename);
    }

    @Override
    public String[] getFileNames(String filename) throws IOException {
        return this.accessor.getFileNames(filename);
    }

    @Override
    public String[] getFileInfo(String[] prefix, String[] postfix) throws IOException {
        return this.accessor.getFileInfo(prefix, postfix);
    }

    @Override
    public String getBaseFile() {
        return this.accessor.getBaseFile();
    }
}

