/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AbstractDB;
import com.kingdee.eas.hr.mvdt.patch.executeSql.AdminException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.CreateDBInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBInstanceNotExistException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBLoginException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.IOracle;
import com.kingdee.eas.hr.mvdt.patch.executeSql.IOracleDriver;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OptimizeDBParamVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OracleVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.QueryForObjectSQLProviderExecutor;
import com.kingdee.eas.hr.mvdt.patch.executeSql.RowCallbackHandler;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlTable;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.TableSpaceInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Oracle
extends AbstractDB
implements IOracle {
    private static final Logger logger = Logger.getLogger(Oracle.class);
    private IOracleDriver oracleDriver = null;
    private OracleVO oracle;

    public Oracle(OracleVO dbvo) {
        this.oracle = dbvo;
        this.oracleDriver = null;
    }

    @Override
    public void runStatics(Connection conn, String tableName) {
        String sql = "'{'CALL DBMS_STATS.GATHER_TABLE_STATS (OWNNAME=>''{0}'', TABNAME=>''{1}'',ESTIMATE_PERCENT=>NULL,CASCADE=>TRUE)'}'";
        sql = MessageFormat.format(sql, this.oracle.getDbUserName(), tableName);
        this.executeSqlProvider(conn, new DefaultSQLProviderExecutor(sql, false));
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.oracleDriver.getDriverClassName();
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        return this.oracleDriver.getJDBCUrl(dbVO);
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.oracle);
        Properties props = new Properties();
        props.setProperty("user", this.oracle.getDbUserName());
        props.setProperty("password", this.oracle.getDbPassword());
        if ("sys".equalsIgnoreCase(this.oracle.getDbUserName())) {
            props.put("internal_logon", "sysdba");
            logger.info((Object)"Get Oracle connection with sysdba ......");
        }
        logger.info((Object)("Create physical oracle connection with user [" + props.getProperty("user") + "]"));
        Connection conn = null;
        try {
            conn = this.oracleDriver.connect(this.getJDBCUrl(this.oracle), props);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 1017 || ex.getErrorCode() == 17443) {
                logger.error((Object)("Create Oracle connection error,login failed," + ex));
                throw new DBLoginException("Create Oracle connection error,login failed," + ex.getMessage(), this.oracle.getDBType(), this.oracle.getDbUserName(), this.oracle.getDisplayAddress(), this.oracle.getDbPort());
            }
            if (ex.getErrorCode() == 0) {
                logger.error((Object)("Create Oracle connection error,get DBInstance failed," + ex));
                throw new DBInstanceNotExistException("Create Oracle connection error,get DBInstance failed\u951b?", this.oracle.getDBType(), this.oracle.getDisplayDBName(), this.oracle.getDisplayAddress(), this.oracle.getDbPort());
            }
            throw ex;
        }
        return conn;
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add("SELECT TABLE_NAME, 'T' FROM USER_TABLES  ORDER BY TABLE_NAME");
            sqlList.add("SELECT VIEW_NAME, 'V' FROM USER_VIEWS  ORDER BY VIEW_NAME");
            this.execute(new DefaultSQLQueryProviderExecutor(sqlList){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    String type = rs.getString(2);
                    SqlTable table = new SqlTable(tbName, "V".equalsIgnoreCase(type.trim()));
                    tablesList.add(table);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get oracle table and view failed!", e);
            throw new AdminException("Get oracle table and view failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("Oracle ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseMajorVersion() + "." + meta.getDatabaseMinorVersion();
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public String getInstanceChartset() {
        QueryForObjectSQLProviderExecutor executor = new QueryForObjectSQLProviderExecutor("SELECT * FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER='NLS_NCHAR_CHARACTERSET'", "VALUE");
        this.execute(executor);
        return (String)executor.getResult();
    }

    @Override
    public String[] getDatabaseUserList() {
        String sql = "select UserName from All_Users";
        final ArrayList list = new ArrayList();
        this.executeQuery(sql, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet rs) throws SQLException {
                list.add(rs.getString(1));
            }
        });
        String[] dbList = list.toArray(new String[list.size()]);
        dbList = StringUtils.sortStringArray(dbList);
        return dbList;
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
    }

    @Override
    public void rebuildDisabledView() throws Exception {
        final ArrayList viewList = new ArrayList();
        String selectDisableView = "SELECT object_type, object_name, status  FROM   dba_objects  WHERE  status = 'INVALID'AND object_type = 'VIEW' AND owner = ?";
        Connection conn = this.getDBConnection();
        this.executeQueryWithSingleParam(selectDisableView, conn.getMetaData().getUserName().toUpperCase(), new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet rs) throws SQLException {
                viewList.add("alter view " + rs.getString(2) + " compile");
            }
        });
        this.execute(new DefaultSQLProviderExecutor(viewList, false));
    }

    @Override
    public boolean isTablespaceExist(String spaceName) {
        String checkTableSpaceSql = "select * from DBA_TABLESPACES WHERE TABLESPACE_NAME = '" + spaceName + "'";
        final ArrayList sameNameSpaceList = new ArrayList();
        this.executeQuery(checkTableSpaceSql, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet rs) throws SQLException {
                sameNameSpaceList.add("sameName");
            }
        });
        return sameNameSpaceList.size() > 0;
    }

    @Override
    public TableSpaceInfo getOldVersionDCTableSpaceInfo(String userName) {
        final TableSpaceInfo spaceInfo = new TableSpaceInfo();
        try {
            final double[] sizes = new double[2];
            String sql = "SELECT DEFAULT_TABLESPACE,TEMPORARY_TABLESPACE from SYS.DBA_USERS WHERE USERNAME='" + userName.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    final String dataSpace = rs.getString("DEFAULT_TABLESPACE");
                    spaceInfo.setSpaceName(dataSpace);
                    final String tempSpace = rs.getString("TEMPORARY_TABLESPACE");
                    String sql = "select file_name,file_id,bytes from dba_data_files where tablespace_name='" + dataSpace + "'";
                    Oracle.this.execute(new DefaultSQLQueryProviderExecutor(sql){

                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            double currentTotalSize;
                            sizes[0] = currentTotalSize = rs.getDouble("bytes");
                            String path = rs.getString("file_name");
                            spaceInfo.addSpacePath(path);
                            String fileID = rs.getString("file_id");
                            String tempSql = "select bytes from dba_free_space where tablespace_name='" + dataSpace + "' and file_id='" + fileID + "'";
                            Oracle.this.execute(new DefaultSQLQueryProviderExecutor(tempSql){

                                @Override
                                public void processRow(ResultSet rs) throws SQLException {
                                    double freeSize;
                                    sizes[1] = freeSize = rs.getDouble("bytes");
                                }
                            });
                            String percent = new DecimalFormat("0.00").format((sizes[0] - sizes[1]) / sizes[0] * 100.0);
                            spaceInfo.addNormalSize(String.valueOf((int)(sizes[0] / 1024.0 / 1024.0)) + "(" + percent + "%)");
                        }
                    });
                    sql = "select bytes, file_id from dba_temp_files where tablespace_name='" + tempSpace + "'";
                    Oracle.this.execute(new DefaultSQLQueryProviderExecutor(sql){

                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            double currentTotalSize;
                            sizes[0] = currentTotalSize = rs.getDouble("bytes");
                            String fileID = rs.getString("file_id");
                            String tempSql = "select BYTES_FREE from V$temp_space_header where tablespace_name='" + tempSpace + "' and file_id='" + fileID + "'";
                            Oracle.this.execute(new DefaultSQLQueryProviderExecutor(tempSql){

                                @Override
                                public void processRow(ResultSet rs) throws SQLException {
                                    double freeSize;
                                    sizes[1] = freeSize = rs.getDouble("BYTES_FREE");
                                }
                            });
                            String percent = new DecimalFormat("0.00").format((sizes[0] - sizes[1]) / sizes[0] * 100.0);
                            spaceInfo.addTempSize((int)(sizes[0] / 1024.0 / 1024.0) + "(" + percent + "%)");
                        }
                    });
                    spaceInfo.setSpaceType("standard");
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get tablespace information error !", (Throwable)ex);
            AdminException e = new AdminException("Get tablespace information error !", ex);
            throw e;
        }
        return spaceInfo;
    }

    @Override
    public void getTableSpaceActualSize(final TableSpaceInfo spaceInfo, String fileName, String tempFilePrefix) {
        try {
            spaceInfo.cleareNormalSizes();
            spaceInfo.clearSpacePath();
            final String name = fileName;
            final double[] sizes = new double[2];
            String sql = "select bytes,file_name,file_id from dba_data_files where tablespace_name='" + name + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    double currentTotalSize;
                    sizes[0] = currentTotalSize = rs.getDouble("bytes");
                    String path = rs.getString("file_name");
                    spaceInfo.addSpacePath(path);
                    String fileID = rs.getString("file_id");
                    String tempSql = "select bytes from dba_free_space where tablespace_name='" + name + "' and file_id='" + fileID + "'";
                    Oracle.this.execute(new DefaultSQLQueryProviderExecutor(tempSql){

                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            double freeSize;
                            sizes[1] = freeSize = rs.getDouble("bytes");
                        }
                    });
                    String percent = new DecimalFormat("0.00").format((sizes[0] - sizes[1]) / sizes[0] * 100.0);
                    spaceInfo.addNormalSize(String.valueOf((int)(sizes[0] / 1024.0 / 1024.0)) + "(" + percent + "%)");
                }
            });
            int firstIndex = fileName.indexOf("_");
            int secondIndex = fileName.indexOf("_", firstIndex + 1);
            final String tempSpaceName = tempFilePrefix + "_" + fileName.substring(secondIndex + 1);
            sql = "select bytes, file_id from dba_temp_files where tablespace_name='" + tempSpaceName + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    double currentTotalSize;
                    sizes[0] = currentTotalSize = rs.getDouble("bytes");
                    String fileID = rs.getString("file_id");
                    String tempSql = "select BYTES_FREE from V$temp_space_header where tablespace_name='" + tempSpaceName + "' and file_id='" + fileID + "'";
                    Oracle.this.execute(new DefaultSQLQueryProviderExecutor(tempSql){

                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            double freeSize;
                            sizes[1] = freeSize = rs.getDouble("BYTES_FREE");
                        }
                    });
                    String percent = new DecimalFormat("0.00").format((sizes[0] - sizes[1]) / sizes[0] * 100.0);
                    spaceInfo.addTempSize((int)(sizes[0] / 1024.0 / 1024.0) + "(" + percent + "%)");
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get table space actual size error !", (Throwable)ex);
            AdminException e = new AdminException("Get tablespace actual size error", ex);
            throw e;
        }
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT TABLE_NAME FROM USER_TABLES  ORDER BY TABLE_NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT VIEW_NAME FROM USER_VIEWS  ORDER BY VIEW_NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT CONSTRAINT_NAME AS PK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P' AND TABLE_NAME='" + tableName + "'" : "SELECT CONSTRAINT_NAME AS PK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public HashMap getDBIndexList(String dbSchema) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "SELECT INDEX_NAME AS NAME,TABLE_NAME AS TBName,INDEX_TYPE,TABLE_TYPE FROM USER_INDEXES";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get index list failed!", e);
            throw new DBException("Get index list form db error", e);
        }
        return indexList;
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT CONSTRAINT_NAME AS FK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R' AND TABLE_NAME='" + tableName + "'" : "SELECT CONSTRAINT_NAME AS FK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R' AND TABLE_NAME LIKE 'T_%'";
            this.executeQuery(sql, new RowCallbackHandler(){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get oracle DB FK list failed!", e);
            throw new AdminException("Get oracle DB FK list failed!", e);
        }
        return fkList;
    }

    @Override
    public String getID() {
        return "oracle:" + this.oracle.getID();
    }

    @Override
    public String getDetectSql() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public boolean isNCHAR(ResultSetMetaData metaData, int columnNum) throws SQLException {
        return this.oracleDriver.isNCHAR(metaData, columnNum);
    }

    @Override
    public OptimizeDBParamVO[] getDBParameterValue(OptimizeDBParamVO[] params) {
        ArrayList<OptimizeDBParamVO> list = new ArrayList<OptimizeDBParamVO>();
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                final OptimizeDBParamVO vo = params[i];
                if (!StringUtils.hasText(vo.getSelectSql())) {
                    vo.setSelectSql("select VALUE from v$parameter where NAME='" + vo.getName() + "'");
                }
                try {
                    this.execute(new DefaultSQLQueryProviderExecutor(vo.getSelectSql()){

                        @Override
                        public void processRow(ResultSet rs) throws SQLException {
                            Object obj = rs.getObject(1);
                            vo.setDefaultValue(String.valueOf(obj));
                        }
                    });
                    list.add(vo);
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)"getDBParameterValue error");
                }
            }
        }
        return list.toArray(new OptimizeDBParamVO[list.size()]);
    }

    @Override
    public void setDBParameterValue(OptimizeDBParamVO[] params) {
        if (params != null && params.length > 0) {
            ArrayList<String> sqlList = new ArrayList<String>();
            for (int i = 0; i < params.length; ++i) {
                String sql;
                String vouchValue;
                String scope;
                OptimizeDBParamVO vo = params[i];
                String name = vo.getName();
                if (name.startsWith("_")) {
                    name = "\"" + name + "\"";
                }
                if (!StringUtils.hasText(scope = vo.getScope())) {
                    scope = "both";
                }
                if (StringUtils.isNum(vouchValue = vo.getRealOptimizeValue()) || "true".equalsIgnoreCase(vouchValue) || "false".equalsIgnoreCase(vouchValue)) {
                    sql = "alter system set " + name + "=" + vouchValue + " scope=" + scope;
                    logger.info((Object)("[" + sql + "]"));
                    sqlList.add(sql);
                    continue;
                }
                sql = "alter system set " + name + "='" + vouchValue + "' scope=" + scope;
                logger.info((Object)("[" + sql + "]"));
                sqlList.add(sql);
            }
            DefaultSQLProviderExecutor provider = new DefaultSQLProviderExecutor(sqlList, true);
            this.execute(provider);
            ArrayList exceptionList = provider.getExceptions();
            if (exceptionList != null && exceptionList.size() > 0) {
                logger.error((Object)"setDBParameterValue failed!", (Throwable)((Exception)exceptionList.get(0)));
                throw new AdminException("setDBParameterValue failed!", (Exception)exceptionList.get(0));
            }
        }
    }
}

