/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.patch.Constants;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB2VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB400VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DataCenterInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DataCenterServiceImpl;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OracleVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ScriptInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlServerVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SyBaseVO;
import com.kingdee.shr.base.syssetting.MSFConfigFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class patchExcuterByControl {
    public void executeSqlAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        Constants.IS_CONTROL = true;
        this.routine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void routine() {
        try {
            MSFConfigFactory.getRemoteInstance().stopService();
            Constants.IS_CONTROL = true;
            for (String itemPath : Constants.PTM_SPECIAL_SUFFIX_CONTROL) {
                String sqlPath = System.getProperty("EAS_HOME") + "/properties/upgradescript/eas/8_2_0to8_5_0/8_5_0_feature/eas/shr/" + itemPath;
                String mainConfigFilePath = sqlPath + "\\" + Constants.CONFIG_FILENAME;
                ArrayList<String> xmlFileList = new ArrayList<String>();
                xmlFileList.add(mainConfigFilePath);
                this.doExecution(xmlFileList);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            try {
                MSFConfigFactory.getRemoteInstance().restartService();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void doExecution(ArrayList<String> xmlFileList) {
        int dbType = 0;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DatabaseVO database = null;
        if (3 == dbType) {
            database = new SqlServerVO();
        } else if (1 == dbType) {
            database = new DB2VO();
        } else if (2 == dbType || 8 == dbType || 7 == dbType) {
            database = new OracleVO();
        } else if (4 == dbType) {
            database = new SyBaseVO();
        } else if (9 == dbType) {
            database = new DB400VO();
        }
        String scriptPath = "";
        DataCenterInfo dcInfo = new DataCenterInfo(database);
        DataCenterServiceImpl dcservice = new DataCenterServiceImpl();
        Iterator<String> iterator = xmlFileList.iterator();
        while (iterator.hasNext()) {
            String xmlFile;
            scriptPath = xmlFile = iterator.next();
            ArrayList scriptFileList = this.getScriptFile(dcInfo.getDefaultDatabase(), scriptPath, dcservice);
            scriptFileList = this.scriptFileListFilter(scriptFileList);
            dcservice.executeSqlScriptFile(dcInfo, scriptFileList);
        }
    }

    private ArrayList getScriptFile(DatabaseVO database, String scriptPath, DataCenterServiceImpl dcservice) {
        ArrayList<ScriptInfo> scriptList = new ArrayList<ScriptInfo>();
        if (StringUtils.hasText(scriptPath = scriptPath.replaceAll("\\\\", "/"))) {
            String lowerPath = scriptPath.toLowerCase();
            if (lowerPath.endsWith(".xml")) {
                ScriptInfo[] scriptInfos = dcservice.getScriptInfoFromFile(database, scriptPath);
                if (scriptInfos != null && scriptInfos.length > 0) {
                    for (int i = 0; i < scriptInfos.length; ++i) {
                        ScriptInfo scriptInfo = scriptInfos[i];
                        scriptInfo.scriptFilePath = scriptInfo.scriptFilePath.replaceAll("\\\\", "/");
                        scriptList.add(scriptInfo);
                    }
                }
            } else if (lowerPath.endsWith("sql") || lowerPath.endsWith("ksql")) {
                ScriptInfo scriptInfo = new ScriptInfo();
                scriptInfo.charset = "UTF-8";
                scriptInfo.dialect = Boolean.FALSE;
                scriptInfo.scriptFilePath = scriptPath;
                scriptInfo.scriptSplit = ";";
                scriptInfo.scriptType = ScriptInfo.SCRIPT_TYPE_ALL;
                scriptList.add(scriptInfo);
            }
        }
        ArrayList<ScriptInfo> resList = new ArrayList<ScriptInfo>();
        for (int i = 0; i < scriptList.size(); ++i) {
            ScriptInfo info = (ScriptInfo)scriptList.get(i);
            if (info.scriptFilePath.indexOf(Constants.CONFIG_FILENAME) >= 0) {
                resList.addAll(this.getScriptFile(database, info.scriptFilePath, dcservice));
                continue;
            }
            resList.add(info);
        }
        return resList;
    }

    private ArrayList scriptFileListFilter(ArrayList scriptFileList) {
        ArrayList<ScriptInfo> resList = new ArrayList<ScriptInfo>();
        for (int i = 0; i < scriptFileList.size(); ++i) {
            ScriptInfo scriptInfo = (ScriptInfo)scriptFileList.get(i);
            if (scriptInfo == null || scriptInfo.scriptFilePath.indexOf("shrmvdt") > 0 || scriptInfo.scriptFilePath.indexOf("hr_dataclean") >= 0) continue;
            resList.add(scriptInfo);
        }
        return resList;
    }
}

