/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.patch.CommonUtils;
import com.kingdee.eas.hr.mvdt.patch.Constants;
import com.kingdee.eas.hr.mvdt.patch.ZIPUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB2VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB400VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DataCenterInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DataCenterServiceImpl;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OracleVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ScriptInfo;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlServerVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SyBaseVO;
import com.kingdee.shr.base.syssetting.MSFConfigFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.springframework.ui.ModelMap;

public class patchExcuterByControlPTM {
    public void executeSqlAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        this.routine();
    }

    public synchronized void routine() {
        try {
            MSFConfigFactory.getRemoteInstance().stopService();
            Constants.IS_CONTROL = true;
            this.setPatchPath();
            this.patchExecutor();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                MSFConfigFactory.getRemoteInstance().restartService();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void patchExecutor() throws BOSException, SQLException {
        ArrayList<File> patchList = this.getPatchList(Constants.PATCHPATH);
        this.innerPatchExecutor(patchList);
    }

    public ArrayList<File> getPatchList(String path) throws BOSException, SQLException {
        File[] files;
        ArrayList<File> resList = new ArrayList<File>();
        HashSet<String> fileNameSet = new HashSet<String>();
        File root = new File(path);
        for (File file : files = root.listFiles()) {
            String fileSuffix;
            String fileName = file.getName();
            if (!fileName.toUpperCase().equals(Constants.PTM_VERSION) || !Constants.PATCH_SUFFIX.equalsIgnoreCase(fileSuffix = fileName.substring(fileName.lastIndexOf(".") + 1)) || !file.canRead()) continue;
            resList.add(file);
            fileNameSet.add(fileName.substring(0, fileName.lastIndexOf(".")));
        }
        return resList;
    }

    private void sortList(ArrayList<File> list) {
        File tempFile;
        int j;
        int i;
        for (i = 0; i < list.size() - 1; ++i) {
            for (j = i + 1; j < list.size(); ++j) {
                if (list.get(i).lastModified() <= list.get(j).lastModified()) continue;
                tempFile = list.get(j);
                list.set(j, list.get(i));
                list.set(i, tempFile);
            }
        }
        for (i = 0; i < list.size() - 1; ++i) {
            for (j = i + 1; j < list.size(); ++j) {
                if (list.get(i).lastModified() != list.get(j).lastModified() || list.get(i).getName().compareTo(list.get(j).getName()) <= 0) continue;
                tempFile = list.get(j);
                list.set(j, list.get(i));
                list.set(i, tempFile);
            }
        }
    }

    public void innerPatchExecutor(ArrayList<File> patchList) {
        if (patchList == null || patchList.size() == 0) {
            return;
        }
        ArrayList<String> tmpFloderList = new ArrayList<String>();
        for (int i = 0; i < patchList.size(); ++i) {
            String patchName = patchList.get(i).getName();
            String floderFullPath = CommonUtils.createTmpFolder(Constants.PATCHPATH, patchName);
            if ("".equals(floderFullPath)) continue;
            tmpFloderList.add(floderFullPath);
            this.unZipPatchFiles(floderFullPath, patchList.get(i));
            String[] childPath = patchName.indexOf(Constants.PTM_SPECIAL_NUM) >= 0 ? Constants.PTM_SPECIAL_SUFFIX_PTM : Constants.PTM_SUFFIX;
            try {
                this.sqlExecutor(floderFullPath, childPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            File floder = new File(floderFullPath);
            CommonUtils.deleteDir(floder);
            floder.delete();
        }
    }

    public void sqlExecutor(String rootPath, String[] childPath) throws IOException, JDOMException {
        for (String itemPath : childPath) {
            String sqlPath = rootPath + itemPath;
            String mainConfigFilePath = sqlPath + "\\" + Constants.CONFIG_FILENAME;
            ArrayList<String> xmlFileList = new ArrayList<String>();
            xmlFileList.add(mainConfigFilePath);
            this.doExecution(xmlFileList);
        }
    }

    public void PtmXmlScanner(String xmlPath, ArrayList<String> xmlFileList) throws IOException, JDOMException {
        if (CommonUtils.configFileChecker(xmlPath)) {
            Document mainConfig = CommonUtils.XMLFileLoader(xmlPath);
            Element root = mainConfig.getRootElement();
            List childrenList = root.getChildren();
            for (Element ele : childrenList) {
                String text = ele.getText();
                String name = ele.getName();
                if (!"subsystem".equalsIgnoreCase(name) || text.indexOf("shrmvdt") >= 0 && text.indexOf("hr_dataclean") >= 0) continue;
                xmlFileList.add(xmlPath.substring(0, xmlPath.lastIndexOf("\\")) + text.substring(text.indexOf("\\")));
            }
        } else {
            return;
        }
    }

    public void doExecution(ArrayList<String> xmlFileList) {
        int dbType = 0;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DatabaseVO database = null;
        if (3 == dbType) {
            database = new SqlServerVO();
        } else if (1 == dbType) {
            database = new DB2VO();
        } else if (2 == dbType || 8 == dbType || 7 == dbType) {
            database = new OracleVO();
        } else if (4 == dbType) {
            database = new SyBaseVO();
        } else if (9 == dbType) {
            database = new DB400VO();
        }
        String scriptPath = "";
        DataCenterInfo dcInfo = new DataCenterInfo(database);
        DataCenterServiceImpl dcservice = new DataCenterServiceImpl();
        Iterator<String> iterator = xmlFileList.iterator();
        while (iterator.hasNext()) {
            String xmlFile;
            scriptPath = xmlFile = iterator.next();
            ArrayList scriptFileList = this.getScriptFile(dcInfo.getDefaultDatabase(), scriptPath, dcservice);
            scriptFileList = this.scriptFileListFilter(scriptFileList);
            dcservice.executeSqlScriptFile(dcInfo, scriptFileList);
        }
    }

    private ArrayList scriptFileListFilter(ArrayList scriptFileList) {
        ArrayList<ScriptInfo> resList = new ArrayList<ScriptInfo>();
        for (int i = 0; i < scriptFileList.size(); ++i) {
            ScriptInfo scriptInfo = (ScriptInfo)scriptFileList.get(i);
            if (scriptInfo == null || scriptInfo.scriptFilePath.indexOf("shrmvdt") > 0 || scriptInfo.scriptFilePath.indexOf("hr_dataclean") >= 0) continue;
            resList.add(scriptInfo);
        }
        return resList;
    }

    private ArrayList getScriptFile(DatabaseVO database, String scriptPath, DataCenterServiceImpl dcservice) {
        ArrayList<ScriptInfo> scriptList = new ArrayList<ScriptInfo>();
        if (StringUtils.hasText(scriptPath = scriptPath.replaceAll("\\\\", "/"))) {
            String lowerPath = scriptPath.toLowerCase();
            if (lowerPath.endsWith(".xml")) {
                ScriptInfo[] scriptInfos = dcservice.getScriptInfoFromFile(database, scriptPath);
                if (scriptInfos != null && scriptInfos.length > 0) {
                    for (int i = 0; i < scriptInfos.length; ++i) {
                        ScriptInfo scriptInfo = scriptInfos[i];
                        scriptInfo.scriptFilePath = scriptInfo.scriptFilePath.replaceAll("\\\\", "/");
                        scriptList.add(scriptInfo);
                    }
                }
            } else if (lowerPath.endsWith("sql") || lowerPath.endsWith("ksql")) {
                ScriptInfo scriptInfo = new ScriptInfo();
                scriptInfo.charset = "UTF-8";
                scriptInfo.dialect = Boolean.FALSE;
                scriptInfo.scriptFilePath = scriptPath;
                scriptInfo.scriptSplit = ";";
                scriptInfo.scriptType = ScriptInfo.SCRIPT_TYPE_ALL;
                scriptList.add(scriptInfo);
            }
        }
        ArrayList<ScriptInfo> resList = new ArrayList<ScriptInfo>();
        for (int i = 0; i < scriptList.size(); ++i) {
            ScriptInfo info = (ScriptInfo)scriptList.get(i);
            if (info.scriptFilePath.indexOf(Constants.CONFIG_FILENAME) >= 0) {
                resList.addAll(this.getScriptFile(database, info.scriptFilePath, dcservice));
                continue;
            }
            resList.add(info);
        }
        return resList;
    }

    private ScriptInfo[] scriptInfoFilter(ScriptInfo[] scriptInfos) {
        if (scriptInfos.length == 0) {
            return scriptInfos;
        }
        ArrayList<ScriptInfo> scriptInfoList = new ArrayList<ScriptInfo>();
        for (int i = 0; i < scriptInfos.length; ++i) {
            if (scriptInfos[i].scriptFilePath.indexOf("shrmvdt") >= 0) continue;
            scriptInfoList.add(scriptInfos[i]);
        }
        ScriptInfo[] resScriptInfo = new ScriptInfo[scriptInfoList.size()];
        for (int j = 0; j < scriptInfoList.size(); ++j) {
            resScriptInfo[j] = (ScriptInfo)scriptInfoList.get(j);
        }
        return resScriptInfo;
    }

    private void unZipPatchFiles(String toZipFloderPath, File unZipFile) {
        String patchPath = unZipFile.getAbsolutePath();
        boolean checkResult = CommonUtils.patchChecker(patchPath);
        if (checkResult) {
            try {
                ZIPUtils.unZip(patchPath, toZipFloderPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setPatchPath() {
        if (Constants.PATCHPATH == null) {
            Constants.setPatchPath(System.getProperty("EAS_HOME") + "/admin/patch/patchlist");
        }
    }
}

