/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.json.JSONObject;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;

public class ExcelUtil {
    public static final int TEMP_TYPE_IMPORT = 1;
    public static final int TEMP_TYPE_EXPORT = 2;
    public static final String SPLIT_STRING = "";
    public static final String TEMP_CLASSIFY_CMP = "CMP";
    public static JSONObject import_status;

    public static Cell createBodyCell(Row row, int col, String value) {
        Cell cell = row.createCell(col);
        cell.setCellValue(value);
        return cell;
    }

    public static Cell createHeadCell(Row row, int col, String name, Map<String, CellStyle> styles) {
        Cell cell = row.createCell(col);
        cell.setCellValue(name);
        cell.setCellStyle(styles.get("head"));
        return cell;
    }

    public static Object getCellValue(Cell cell) {
        Object value = SPLIT_STRING;
        if (cell == null) {
            return value;
        }
        switch (cell.getCellType()) {
            case BLANK: {
                value = SPLIT_STRING;
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                value = SPLIT_STRING;
                break;
            }
            case FORMULA: {
                Workbook wb = cell.getSheet().getWorkbook();
                CreationHelper createHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = createHelper.createFormulaEvaluator();
                value = ExcelUtil.getCellValue(evaluator.evaluateInCell(cell));
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = cell.getDateCellValue();
                    break;
                }
                value = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            default: {
                value = SPLIT_STRING;
            }
        }
        return value;
    }

    public static String getNameFieldValue(String value) {
        if (!StringUtils.isEmpty((String)value)) {
            String[] identityArray = value.split(SPLIT_STRING);
            String name = value;
            if (identityArray.length == 2) {
                name = identityArray[1];
            }
            return name;
        }
        return value;
    }

    public static String getNumberFieldValue(String value) {
        if (!StringUtils.isEmpty((String)value)) {
            String[] identityArray = value.split(SPLIT_STRING);
            String number = SPLIT_STRING;
            if (identityArray.length == 2) {
                number = identityArray[0];
            }
            return number;
        }
        return value;
    }

    public static String getRelateFieldValue(String name, String number) {
        return name + SPLIT_STRING + number;
    }

    public static void resetStatus() throws Exception {
        import_status = new JSONObject();
        JSONObject check = new JSONObject();
        check.put("status", 0.0);
        check.put("valid", false);
        import_status.put("check", (Object)check);
        JSONObject inport = new JSONObject();
        inport.put("status", 0.0);
        import_status.put("import", (Object)inport);
        import_status.put("errorPath", (Object)"undefined");
        import_status.put("over", false);
    }

    public static void setExportExcelHead(HttpServletResponse response, String path, String fileName) throws Exception {
        int len;
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xls", "UTF-8"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
        byte[] buffer = new byte[5120];
        while ((len = bis.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
    }

    static {
        try {
            ExcelUtil.resetStatus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

