/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.SHRMvDataDbConfigCollection;
import com.kingdee.eas.hr.mvdt.SHRMvDataDbConfigFactory;
import com.kingdee.eas.hr.mvdt.util.DataBaseConfigTool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SHRDbConnectionTool {
    private static final Logger logger = Logger.getLogger((String)SHRDbConnectionTool.class.getName());

    public static Connection getSHRDBConnection(Context ctx) throws InterfaceDataBaseException, BOSException {
        try {
            SHRMvDataDbConfigCollection DataDbs = SHRMvDataDbConfigFactory.getLocalInstance(ctx).getSHRMvDataDbConfigCollection();
            if (DataDbs.size() <= 0) {
                throw new BOSException("\u65e0\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f");
            }
            return DataBaseConfigTool.getOuterConnection(ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void releasDBResource(Connection conn, Statement stmt, ResultSet rs) throws BOSException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            stmt = null;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            conn = null;
        }
    }
}

