/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TableColumnSyncTool {
    public static void synSHRTableInfoToEAS(Context ctx, Connection shrConn, Connection easConn, String tblName) throws InterfaceDataBaseException, BOSException {
        Map<String, ColumnInfo> easColumnMap = TableColumnSyncTool.getEASTableColumnMap(easConn, tblName);
        Map<String, ColumnInfo> shrColumnMap = TableColumnSyncTool.getSHRTableColumnMap(shrConn, tblName);
        for (String columnName : shrColumnMap.keySet()) {
            if (!easColumnMap.containsKey(columnName)) {
                ColumnInfo columnInfo = shrColumnMap.get(columnName);
                String columnTypeName = TableColumnSyncTool.getTableColumnTypeName(columnInfo);
                if (columnTypeName == null) continue;
                StringBuffer alterSql = new StringBuffer();
                alterSql.append("alter table ").append(tblName).append(" add ").append(columnName).append(TableColumnSyncTool.getTableColumnTypeDefineString(columnInfo));
                if (SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tblName.toUpperCase(), columnName)) continue;
                DbUtil.execute((Context)ctx, (String)alterSql.toString());
                continue;
            }
            if (!easColumnMap.containsKey(columnName)) continue;
            ColumnInfo shrColumnInfo = shrColumnMap.get(columnName);
            ColumnInfo easColumnInfo = easColumnMap.get(columnName);
            String columnTypeName = TableColumnSyncTool.getTableColumnTypeName(shrColumnInfo);
            if (columnTypeName == null || !"VARCHAR".equals(columnTypeName) && !"NVARCHAR".equals(columnTypeName) || shrColumnInfo.getCharLength() <= easColumnInfo.getCharLength()) continue;
            StringBuffer alterSql = new StringBuffer();
            alterSql.append("alter table ").append(tblName).append(" alter column ").append(columnName);
            alterSql.append(TableColumnSyncTool.getTableColumnTypeDefineString(shrColumnInfo));
            DbUtil.execute((Context)ctx, (String)alterSql.toString());
        }
    }

    public static Map<String, ColumnInfo> getSHRTableColumnMap(Context ctx, String tblName) throws InterfaceDataBaseException, BOSException {
        Map<String, ColumnInfo> columnMap = null;
        Connection conn = null;
        try {
            conn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            columnMap = TableColumnSyncTool.getSHRTableColumnMap(conn, tblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SHRDbConnectionTool.releasDBResource(conn, null, null);
        }
        return columnMap;
    }

    public static Map<String, ColumnInfo> getSHRTableColumnMap(Connection conn, String tblName) throws InterfaceDataBaseException, BOSException {
        return TableColumnSyncTool.getTableColumnMap(conn, tblName);
    }

    public static Map<String, ColumnInfo> getTableColumnMap(Connection conn, String tblName) throws InterfaceDataBaseException, BOSException {
        Statement state = null;
        ResultSet rs = null;
        HashMap<String, ColumnInfo> columnMap = new HashMap<String, ColumnInfo>();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            String sql = null;
            sql = "Oracle".equals(dbName) ? "SELECT COLUMN_NAME, DATA_TYPE, CHAR_LENGTH, DATA_PRECISION, DATA_SCALE FROM USER_TAB_COLUMNS WHERE TABLE_NAME = '" + tblName + "'" : "SELECT syscol.name,systype.name,syscol.prec,syscol.xprec,syscol.xscale FROM syscolumns syscol left join sysobjects sysobj on syscol.id = sysobj.id left join systypes systype on syscol.xtype=systype.xtype WHERE  systype.name!='sysname' and SYSOBJ.NAME = '" + tblName + "' order by syscol.colorder";
            state = conn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                ColumnInfo columnInfo = new ColumnInfo();
                String columnName = rs.getString(1).toUpperCase();
                columnInfo.setColumnName(columnName);
                columnInfo.setColumnType(rs.getString(2));
                columnInfo.setCharLength(rs.getInt(3));
                columnInfo.setPrecision(rs.getInt(4));
                columnInfo.setScale(rs.getInt(5));
                columnMap.put(columnName, columnInfo);
            }
            SHRDbConnectionTool.releasDBResource(null, state, rs);
        }
        catch (SQLException e) {
            SHRDbConnectionTool.releasDBResource(conn, state, rs);
            throw new BOSException((Throwable)e);
        }
        return columnMap;
    }

    public static Map<String, ColumnInfo> getEASTableColumnMap(Connection conn, String tblName) throws InterfaceDataBaseException, BOSException {
        HashMap<String, ColumnInfo> columnMap = new HashMap();
        columnMap = TableColumnSyncTool.getTableColumnMap(conn, tblName);
        return columnMap;
    }

    public static String getTableColumnTypeName(ColumnInfo columnInfo) {
        String type = columnInfo.getColumnType();
        int precision = columnInfo.getPrecision();
        int scale = columnInfo.getScale();
        if ("NVARCHAR2".equals(type) || "nvarchar".equals(type) || "nchar".equalsIgnoreCase(type)) {
            return "NVARCHAR";
        }
        if ("VARCHAR2".equals(type) || "varchar".equals(type) || "char".equalsIgnoreCase(type)) {
            return "VARCHAR";
        }
        if ("TIMESTAMP(6)".equals(type) || "datetime".equals(type)) {
            return "TIMESTAMP";
        }
        if ("NUMBER".equals(type) && 10 == precision && 0 == scale || "int".equals(type)) {
            return "INT";
        }
        if ("NUMBER".equals(type) || "decimal".equals(type)) {
            return "NUMERIC";
        }
        if ("NCLOB".equals(type) || "ntext".equals(type)) {
            return "NCLOB";
        }
        if ("CLOB".equals(type) || "text".equals(type)) {
            return "CLOB";
        }
        if ("BLOB".equals(type) || "image".equals(type)) {
            return "BLOB";
        }
        return null;
    }

    public static String getTableColumnTypeDefineString(ColumnInfo columnInfo) {
        String type = columnInfo.getColumnType();
        int precision = columnInfo.getPrecision();
        int scale = columnInfo.getScale();
        int charLength = columnInfo.getCharLength();
        if ("NVARCHAR2".equals(type) || "nvarchar".equals(type) || "nchar".equalsIgnoreCase(type)) {
            return " NVARCHAR(" + charLength + ")";
        }
        if ("VARCHAR2".equals(type) || "varchar".equals(type) || "char".equalsIgnoreCase(type)) {
            return " VARCHAR(" + charLength + ")";
        }
        if ("TIMESTAMP(6)".equals(type) || "datetime".equals(type)) {
            return " DateTime";
        }
        if ("NUMBER".equals(type) && 10 == precision && 0 == scale || "int".equals(type)) {
            return " INT";
        }
        if ("NUMBER".equals(type) || "decimal".equals(type)) {
            return " NUMERIC(" + precision + "," + scale + ")";
        }
        if ("NCLOB".equals(type) || "ntext".equals(type)) {
            return " NCLOB";
        }
        if ("CLOB".equals(type) || "text".equals(type)) {
            return " CLOB";
        }
        if ("BLOB".equals(type) || "image".equals(type)) {
            return " BLOB";
        }
        return null;
    }

    public Set<String> getRefreshMappingFieldSet(Context ctx, String tableName, boolean needDefault) throws BOSException {
        HashSet<String> mappingFieldSet = new HashSet();
        if (needDefault) {
            mappingFieldSet = this.getDefaultRefreshMappingFieldSet();
        }
        String sql = "select FColumnName from T_HR_TableColumnConfig where FMvTableName='" + tableName.toUpperCase() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        mappingFieldSet = new HashSet();
        try {
            while (rs.next()) {
                mappingFieldSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return mappingFieldSet;
    }

    public Set<String> getDefaultRefreshMappingFieldSet() throws BOSException {
        HashSet<String> mappingFieldSet = new HashSet<String>();
        mappingFieldSet.add("FCREATORID");
        mappingFieldSet.add("FLASTUPDATEUSERID");
        mappingFieldSet.add("FCONTROLUNITID");
        return mappingFieldSet;
    }

    public static ArrayList<String> getTablePrimaryKeyName(Connection conn, String tblName) throws InterfaceDataBaseException, BOSException {
        Statement state = null;
        ResultSet rs = null;
        ArrayList<String> res = new ArrayList<String>();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            String sql = null;
            sql = "Oracle".equals(dbName) ? "select a.column_name PKNAME from user_cons_columns a, user_constraints b  where a.constraint_name = b.constraint_name  and b.constraint_type = 'P' and a.table_name = '" + tblName.trim().toUpperCase() + "'" : " SELECT a.name PKNAME FROM   syscolumns a  inner  join sysobjects d on a.id=d.id   where  d.name='" + tblName.trim().toUpperCase() + "' and exists(SELECT 1 FROM sysobjects where xtype='PK' and  parent_obj=a.id and name in (  SELECT name  FROM sysindexes   WHERE indid in(   SELECT indid FROM sysindexkeys WHERE id = a.id AND colid=a.colid)))";
            state = conn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                res.add(rs.getString(1).toUpperCase());
            }
            if (res.isEmpty()) {
                res = TableColumnSyncTool.getTableUniqueIndexes(conn, tblName);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SHRDbConnectionTool.releasDBResource(conn, state, rs);
                throw throwable;
            }
        }
        SHRDbConnectionTool.releasDBResource(conn, state, rs);
        return res;
    }

    public static ArrayList<String> getTableUniqueIndexes(Connection conn, String tblName) throws InterfaceDataBaseException, BOSException {
        Statement state = null;
        ResultSet rs = null;
        ArrayList<String> res = new ArrayList<String>();
        try {
            String dbName = conn.getMetaData().getDatabaseProductName();
            String sql = null;
            sql = "Oracle".equals(dbName) ? "select t.COLUMN_NAME from user_ind_columns t,user_indexes i  where t.index_name = i.index_name  and i.uniqueness = 'UNIQUE'  and t.table_name='" + tblName.trim().toUpperCase() + "'" : "select c.name colname from sys.objects as a , sys.indexes as h , sys.columns as c , sys.index_columns as i where a.type<>'s' and a.object_id = h.object_id and a.object_id = c.object_id and a.object_id = i.object_id and i.index_id=h.index_id and i.column_id = c.column_id and h.is_unique = 1 and a.name ='" + tblName.trim().toUpperCase() + "'";
            state = conn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                res.add(rs.getString(1).toUpperCase());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return res;
    }
}

