/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.DataMoveType;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRDataMoveConstant;
import com.kingdee.eas.hr.mvdt.util.SynIdMappingUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UpdateTool {
    private static final Logger logger = Logger.getLogger((String)UpdateTool.class.getName());

    public static void commonUpdate(Connection shrConn, String tableName, String condition, Context ctx, int irowNum) throws InterfaceDataBaseException, BOSException {
        UpdateTool.commonUpdate(shrConn, tableName, condition, ctx, irowNum, 0, true);
    }

    public static void commonUpdate(Connection shrConn, String tableName, String condition, Context ctx, int irowNum, int sRowNum) throws InterfaceDataBaseException, BOSException {
        UpdateTool.commonUpdate(shrConn, tableName, condition, ctx, irowNum, sRowNum, true);
    }

    public static void commonUpdate(Connection shrConn, String tableName, String condition, Context ctx, int iRowNum, int sRowNum, boolean deleteTag) throws InterfaceDataBaseException, BOSException {
        DataMoveType dataMoveType;
        tableName = tableName.trim().toUpperCase();
        if (condition == null || "".equals(condition.trim())) {
            condition = "";
        }
        String shrDbType = null;
        String easDbType = null;
        tableName = tableName.toUpperCase();
        Connection easConn = null;
        Statement stmt = null;
        ResultSet rs2 = null;
        Object pstmt = null;
        PreparedStatement ipstmt = null;
        PreparedStatement upstmt = null;
        Connection easConn2 = null;
        try {
            easConn2 = EJBFactory.getQueryConnection((Context)ctx);
            shrDbType = shrConn.getMetaData().getDatabaseProductName();
            easDbType = easConn2.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff01");
        }
        if ("Microsoft SQL Server".equals(easDbType)) {
            if (tableName.equalsIgnoreCase("T_HR_SCMPSTANDARD") && "".equals(condition)) {
                new UpdateTool();
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FREFERINFO IS NULL", ctx, iRowNum, sRowNum, true);
                new UpdateTool();
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FREFERINFO IS NOT NULL", ctx, iRowNum, sRowNum, false);
                return;
            }
            if (tableName.equalsIgnoreCase("T_HR_EMPLOYEEPAGE") && "".equals(condition)) {
                new UpdateTool();
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FPAGECONTENT IS NULL", ctx, iRowNum, sRowNum, true);
                new UpdateTool();
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FPAGECONTENT IS NOT NULL", ctx, iRowNum, sRowNum, false);
                return;
            }
            if (tableName.equalsIgnoreCase("T_HR_PERSONWORKEXP") && "".equals(condition)) {
                new UpdateTool();
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FJOBDESC IS NULL", ctx, iRowNum, sRowNum, true);
                new UpdateTool();
                UpdateTool.commonUpdate(shrConn, tableName, " WHERE FJOBDESC IS NOT NULL", ctx, iRowNum, sRowNum, false);
                return;
            }
        }
        try {
            dataMoveType = UpdateTool.getDataMoveType(ctx, tableName, deleteTag);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            throw new BOSException("\u83b7\u53d6\u8868DataMoveType\u5931\u8d25\uff01");
        }
        HashMap<String, String> idMap = SynIdMappingUtil.getIdMappingMap(ctx);
        ArrayList<String> primaryKeyList = TableColumnSyncTool.getTablePrimaryKeyName(easConn2, tableName);
        ArrayList<Map<String, String>> primaryList = new ArrayList();
        if (primaryKeyList.size() > 0) {
            primaryList = new UpdateTool().getAllFidByTableName(tableName, ctx, primaryKeyList);
        }
        Set<String> refreshMap = new UpdateTool().getRefreshMap();
        if (tableName.equalsIgnoreCase("T_HR_PERSONPHOTO")) {
            refreshMap.add("FPERSONID");
        }
        Map<String, ColumnInfo> ColumnMap = null;
        ColumnMap = new UpdateTool().EasShrColumnsAdpter(ctx, tableName);
        if (ColumnMap.isEmpty()) {
            throw new BOSException("\u8868:" + tableName + "\u5728\u8fc1\u5165\u5e93\u6216\u8fc1\u51fa\u5e93\u4e0d\u5b58\u5728\u3002");
        }
        Iterator<String> columns = ColumnMap.keySet().iterator();
        StringBuffer iSQL = new StringBuffer("INSERT INTO " + tableName + "(''");
        StringBuffer valuesSQL = new StringBuffer(" VALUES (''");
        StringBuffer updateSQL = new StringBuffer("UPDATE " + tableName).append(" SET ");
        String[] columnNames = new String[ColumnMap.size()];
        String[] columnTypes = new String[ColumnMap.size()];
        int i = 0;
        Iterator iterator = primaryKeyList.iterator();
        while (iterator.hasNext()) {
            String primaryKey;
            String columnName = primaryKey = (String)iterator.next();
            String columnTypeName = TableColumnSyncTool.getTableColumnTypeName(ColumnMap.get(primaryKey.toUpperCase()));
            columnNames[i] = columnName.trim();
            columnTypes[i] = columnTypeName.trim();
            iSQL.append("," + primaryKey);
            valuesSQL.append(",?");
            updateSQL.append(primaryKey + "=?,");
            ++i;
        }
        boolean isContainClob = false;
        while (columns.hasNext()) {
            String columnName = columns.next();
            String columnTypeName = TableColumnSyncTool.getTableColumnTypeName(ColumnMap.get(columnName));
            if ("CLOB".equals(columnTypeName.trim()) || "NCLOB".equals(columnTypeName.trim()) || "BLOB".equals(columnTypeName.trim()) || "text".equals(columnTypeName.trim()) || "ntext".equals(columnTypeName.trim())) {
                isContainClob = true;
            }
            if (primaryKeyList.contains(columnName.toUpperCase())) continue;
            columnNames[i] = columnName.trim();
            columnTypes[i] = columnTypeName.trim();
            iSQL.append("," + columnName);
            valuesSQL.append(",?");
            updateSQL.append(columnName + "=?,");
            ++i;
        }
        iSQL.append(")");
        valuesSQL.append(")");
        iSQL.append(valuesSQL);
        String selectSQL = "SELECT " + iSQL.substring(iSQL.indexOf(",") + 1, iSQL.indexOf(")")).toString() + " FROM " + tableName + " " + condition;
        String insertSQL = iSQL.toString().replaceAll("'',", "");
        String updateSelection = "_ WHERE 1=1 ";
        for (String primaryKey : primaryKeyList) {
            updateSelection = updateSelection + " and " + primaryKey + "=?";
        }
        updateSQL.append(updateSelection);
        String updSQL = updateSQL.toString().replaceAll(",_", "");
        HashMap<String, String> kvMap = new HashMap<String, String>();
        try {
            easConn = EJBFactory.getQueryConnection((Context)ctx);
            easConn.setAutoCommit(false);
            ipstmt = easConn.prepareStatement(insertSQL);
            upstmt = easConn.prepareStatement(updSQL);
            stmt = shrConn.createStatement();
            ResultSet rs = null;
            ResultSet rowset = null;
            if (isContainClob) {
                if (sRowNum <= 0) {
                    sRowNum = SHRDataMoveConstant.DEFAULT_PAGEQUERY_ROWNUM;
                }
                int totalSize = 0;
                int pageSize = sRowNum;
                int totalPage = 0;
                String totalSql = "SELECT COUNT(*) FROM " + tableName + " " + condition;
                ResultSet totalRs = stmt.executeQuery(totalSql);
                if (totalRs.next()) {
                    totalSize = totalRs.getInt(1);
                }
                totalRs.close();
                if (totalSize > 0 && pageSize > 0) {
                    Statement pageStmt = shrConn.createStatement();
                    totalPage = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
                    for (int pos = 1; pos <= totalPage; ++pos) {
                        rowset = new UpdateTool().getRowSetByPageDB(tableName, primaryKeyList, shrDbType, pageStmt, selectSQL, totalSize, pageSize, pos);
                        JdbcRowSet rsTmp = new JdbcRowSet();
                        rsTmp.populate(rowset);
                        rs = rsTmp;
                        UpdateTool.doCommonUpdate(easConn, rs, ipstmt, upstmt, primaryList, primaryKeyList, kvMap, ColumnMap, columnNames, columnTypes, idMap, refreshMap, shrDbType, easDbType, dataMoveType, iRowNum);
                    }
                    if (pageStmt != null) {
                        pageStmt.close();
                    }
                    if (rowset != null) {
                        rowset.close();
                    }
                }
            } else {
                stmt.setFetchSize(500);
                stmt.setFetchDirection(1000);
                rs = rowset = stmt.executeQuery(selectSQL);
                UpdateTool.doCommonUpdate(easConn, rs, ipstmt, upstmt, primaryList, primaryKeyList, kvMap, ColumnMap, columnNames, columnTypes, idMap, refreshMap, shrDbType, easDbType, dataMoveType, iRowNum);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                new UpdateTool().closeConn(rs2, ipstmt, upstmt, stmt, easConn);
                throw throwable;
            }
        }
        new UpdateTool().closeConn(rs2, ipstmt, upstmt, stmt, easConn);
    }

    public void truncateTable(Context ctx, String tableName) {
        try {
            DbUtil.execute((Context)ctx, (String)("truncate table " + tableName));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void doCommonUpdate(Connection easConn, ResultSet rs, PreparedStatement ipstmt, PreparedStatement upstmt, List<Map<String, String>> primaryList, List<String> primaryKeyList, Map<String, String> kvMap, Map<String, ColumnInfo> ColumnMap, String[] columnNames, String[] columnTypes, HashMap<String, String> idMap, Set<String> refreshMap, String shrDbType, String easDbType, DataMoveType dataMoveType, int iRowNum) throws BOSException, SQLException {
        int num = 0;
        int insertNum = 0;
        int updateNum = 0;
        while (rs.next()) {
            StringReader reader;
            ++num;
            boolean exist = false;
            for (String string : primaryKeyList) {
                kvMap.put(string, rs.getString(string));
            }
            if (primaryKeyList.size() > 0) {
                for (Map map : primaryList) {
                    int flagCount = 0;
                    for (String primaryKey : primaryKeyList) {
                        if (!map.containsValue(kvMap.get(primaryKey))) break;
                        ++flagCount;
                    }
                    if (flagCount != primaryKeyList.size()) continue;
                    exist = true;
                    break;
                }
            } else {
                exist = false;
            }
            if (!exist) {
                for (int j = 0; j < columnTypes.length; ++j) {
                    if (columnTypes[j].indexOf("CHAR") != -1) {
                        void var21_30;
                        Object var21_26 = null;
                        if (columnNames[j].equalsIgnoreCase("FPERSONID") && idMap.get(rs.getString(columnNames[j])) != null) {
                            String string = idMap.get(rs.getString(columnNames[j]));
                        } else if (j < primaryKeyList.size()) {
                            String string = kvMap.get(primaryKeyList.get(j));
                        } else {
                            String string = rs.getString(j + 1);
                        }
                        if (refreshMap.contains(columnNames[j].toUpperCase())) {
                            if (idMap.containsKey(var21_30) && !StringUtils.isEmpty((String)var21_30)) {
                                ipstmt.setString(j + 1, idMap.get(var21_30));
                                continue;
                            }
                            ipstmt.setString(j + 1, (String)var21_30);
                            continue;
                        }
                        if ("Oracle".equals(easDbType)) {
                            if (var21_30 != null) {
                                ipstmt.setCharacterStream(j + 1, (Reader)new StringReader((String)var21_30), var21_30.length());
                                continue;
                            }
                            ipstmt.setString(j + 1, (String)var21_30);
                            continue;
                        }
                        ipstmt.setString(j + 1, (String)var21_30);
                        continue;
                    }
                    if ("DATE".equalsIgnoreCase(columnTypes[j]) || "datetime".equalsIgnoreCase(columnTypes[j])) {
                        ipstmt.setDate(j + 1, rs.getDate(columnNames[j]));
                        continue;
                    }
                    if ("TIMESTAMP(6)".equalsIgnoreCase(columnTypes[j]) || "TIMESTAMP".equalsIgnoreCase(columnTypes[j])) {
                        ipstmt.setTimestamp(j + 1, rs.getTimestamp(columnNames[j]));
                        continue;
                    }
                    if ("NUMBER".equalsIgnoreCase(columnTypes[j]) && 10 == ColumnMap.get(columnNames[j]).getPrecision() && 0 == ColumnMap.get(columnNames[j]).getScale() || "int".equalsIgnoreCase(columnTypes[j])) {
                        ipstmt.setInt(j + 1, rs.getInt(columnNames[j]));
                        continue;
                    }
                    if ("NUMERIC".equalsIgnoreCase(columnTypes[j])) {
                        ipstmt.setBigDecimal(j + 1, rs.getBigDecimal(columnNames[j]));
                        continue;
                    }
                    if ("NCLOB".equalsIgnoreCase(columnTypes[j]) || "CLOB".equalsIgnoreCase(columnTypes[j])) {
                        if ("Oracle".equals(shrDbType) && "Oracle".equals(easDbType)) {
                            Clob clob = rs.getClob(columnNames[j]);
                            if (clob != null) {
                                String value2 = clob.toString();
                                reader = new StringReader(value2);
                                ipstmt.setCharacterStream(j + 1, (Reader)reader, value2.length());
                                continue;
                            }
                            StringReader reader3 = new StringReader("");
                            ipstmt.setCharacterStream(j + 1, (Reader)reader3, 0);
                            continue;
                        }
                        String string = rs.getString(columnNames[j]);
                        if (string != null) {
                            StringReader reader2 = new StringReader(string);
                            ipstmt.setCharacterStream(j + 1, (Reader)reader2, string.length());
                            continue;
                        }
                        StringReader reader2 = new StringReader("");
                        ipstmt.setCharacterStream(j + 1, (Reader)reader2, 0);
                        continue;
                    }
                    if (!"BLOB".equalsIgnoreCase(columnTypes[j])) continue;
                    if ("Oracle".equals(shrDbType) && "Oracle".equals(easDbType)) {
                        Blob blob = rs.getBlob(columnNames[j]);
                        if (blob != null) {
                            ipstmt.setBytes(j + 1, blob.getBytes(1L, (int)blob.length()));
                            continue;
                        }
                        StringReader reader4 = new StringReader("");
                        ipstmt.setCharacterStream(j + 1, (Reader)reader4, 0);
                        continue;
                    }
                    if ("Oracle".equals(shrDbType) && "Microsoft SQL Server".equals(easDbType)) {
                        Blob blob = rs.getBlob(columnNames[j]);
                        if (blob != null) {
                            ipstmt.setBytes(j + 1, blob.getBytes(1L, (int)blob.length()));
                            continue;
                        }
                        ipstmt.setBytes(j + 1, null);
                        continue;
                    }
                    byte[] byArray = rs.getBytes(columnNames[j]);
                    if (byArray != null) {
                        ipstmt.setBytes(j + 1, byArray);
                        continue;
                    }
                    ipstmt.setBytes(j + 1, null);
                }
                ++insertNum;
                ipstmt.addBatch();
            } else if (dataMoveType != DataMoveType.ExistNotDone) {
                for (int j = 0; j < columnTypes.length; ++j) {
                    if (columnTypes[j].indexOf("CHAR") != -1) {
                        void var21_40;
                        Object var21_36 = null;
                        if (columnNames[j].equalsIgnoreCase("FPERSONID") && idMap.get(rs.getString(columnNames[j])) != null) {
                            String string = idMap.get(rs.getString(columnNames[j]));
                        } else if (j < primaryKeyList.size()) {
                            String string = kvMap.get(primaryKeyList.get(j));
                        } else {
                            String string = rs.getString(j + 1);
                        }
                        if (refreshMap.contains(columnNames[j].toUpperCase())) {
                            if (idMap.containsKey(var21_40) && !StringUtils.isEmpty((String)idMap.get(var21_40))) {
                                upstmt.setString(j + 1, (String)var21_40);
                                continue;
                            }
                            upstmt.setString(j + 1, (String)var21_40);
                            continue;
                        }
                        if ("Oracle".equals(easDbType)) {
                            if (var21_40 != null) {
                                upstmt.setCharacterStream(j + 1, (Reader)new StringReader((String)var21_40), var21_40.length());
                                continue;
                            }
                            upstmt.setString(j + 1, (String)var21_40);
                            continue;
                        }
                        upstmt.setString(j + 1, (String)var21_40);
                        continue;
                    }
                    if ("DATE".equalsIgnoreCase(columnTypes[j]) || "datetime".equalsIgnoreCase(columnTypes[j])) {
                        upstmt.setDate(j + 1, rs.getDate(columnNames[j]));
                        continue;
                    }
                    if ("TIMESTAMP(6)".equalsIgnoreCase(columnTypes[j]) || "TIMESTAMP".equalsIgnoreCase(columnTypes[j])) {
                        upstmt.setTimestamp(j + 1, rs.getTimestamp(columnNames[j]));
                        continue;
                    }
                    if ("NUMBER".equalsIgnoreCase(columnTypes[j]) && 10 == ColumnMap.get(columnNames[j]).getPrecision() && 0 == ColumnMap.get(columnNames[j]).getScale() || "int".equalsIgnoreCase(columnTypes[j])) {
                        upstmt.setInt(j + 1, rs.getInt(columnNames[j]));
                        continue;
                    }
                    if ("NUMERIC".equalsIgnoreCase(columnTypes[j])) {
                        upstmt.setFloat(j + 1, rs.getFloat(columnNames[j]));
                        continue;
                    }
                    if ("NCLOB".equalsIgnoreCase(columnTypes[j]) || "CLOB".equalsIgnoreCase(columnTypes[j])) {
                        if ("Oracle".equals(shrDbType) && "Oracle".equals(easDbType)) {
                            Clob clob = rs.getClob(columnNames[j]);
                            if (clob != null) {
                                String value3 = clob.toString();
                                reader = new StringReader(value3);
                                upstmt.setCharacterStream(j + 1, (Reader)reader, value3.length());
                                continue;
                            }
                            StringReader reader6 = new StringReader("");
                            upstmt.setCharacterStream(j + 1, (Reader)reader6, 0);
                            continue;
                        }
                        String string = rs.getString(columnNames[j]);
                        if (string != null) {
                            StringReader reader5 = new StringReader(string);
                            upstmt.setCharacterStream(j + 1, (Reader)reader5, string.length());
                            continue;
                        }
                        StringReader reader3 = new StringReader("");
                        upstmt.setCharacterStream(j + 1, (Reader)reader3, 0);
                        continue;
                    }
                    if (!"BLOB".equalsIgnoreCase(columnTypes[j])) continue;
                    if ("Oracle".equals(shrDbType) && "Oracle".equals(easDbType)) {
                        Blob blob = rs.getBlob(columnNames[j]);
                        if (blob != null) {
                            upstmt.setBytes(j + 1, blob.getBytes(1L, (int)blob.length()));
                            continue;
                        }
                        StringReader reader7 = new StringReader("");
                        upstmt.setCharacterStream(j + 1, (Reader)reader7, 0);
                        continue;
                    }
                    byte[] byArray = rs.getBytes(columnNames[j]);
                    if (byArray != null) {
                        upstmt.setBytes(j + 1, byArray);
                        continue;
                    }
                    upstmt.setBytes(j + 1, null);
                }
                for (int keySize = 0; keySize < primaryKeyList.size(); ++keySize) {
                    upstmt.setString(columnNames.length + keySize + 1, kvMap.get(primaryKeyList.get(keySize)));
                }
                ++updateNum;
                upstmt.addBatch();
            }
            if (num % iRowNum != 0) continue;
            new UpdateTool().handleData(insertNum, ipstmt, easConn);
            new UpdateTool().handleData(updateNum, upstmt, easConn);
            insertNum = 0;
            updateNum = 0;
            num = 0;
        }
        if (num % iRowNum != 0) {
            new UpdateTool().handleData(insertNum, ipstmt, easConn);
            new UpdateTool().handleData(updateNum, upstmt, easConn);
        }
    }

    public ArrayList<Map<String, String>> getAllFidByTableName(String tableName, Context ctx, List<String> primaryList) throws BOSException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String selectSQL = "SELECT ";
        for (String primarKey : primaryList) {
            selectSQL = selectSQL + "," + primarKey;
        }
        selectSQL = selectSQL + " FROM " + tableName;
        selectSQL = selectSQL.replaceFirst(",", "");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (String primarKey : primaryList) {
                    map.put(primarKey, rowSet.getString(primarKey));
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    public Set<String> getRefreshMap() throws BOSException {
        Set<Object> defaultRefreshMap = new HashSet();
        HashSet<String> refreshMap = new HashSet<String>();
        try {
            defaultRefreshMap = new TableColumnSyncTool().getDefaultRefreshMappingFieldSet();
            refreshMap = new HashSet();
            Iterator<Object> it = defaultRefreshMap.iterator();
            while (it.hasNext()) {
                refreshMap.add(((String)it.next()).toUpperCase());
            }
            refreshMap.add("FBOID");
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return refreshMap;
    }

    public void closeConn(ResultSet rs, PreparedStatement ipstmt, PreparedStatement upstmt, Statement stmt, Connection conn) throws BOSException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            rs = null;
        }
        if (ipstmt != null) {
            try {
                ipstmt.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            ipstmt = null;
        }
        if (upstmt != null) {
            try {
                upstmt.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            upstmt = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            stmt = null;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception _) {
                logger.error((Object)"cleanup error", (Throwable)_);
            }
            conn = null;
        }
    }

    public void handleData(int iOruNum, PreparedStatement pstmt, Connection conn) throws BOSException {
        try {
            if (pstmt != null && conn != null && iOruNum > 0) {
                pstmt.executeBatch();
                conn.commit();
                pstmt.clearBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public Map<String, ColumnInfo> EasShrColumnsAdpter(Context ctx, String tableName) throws InterfaceDataBaseException, BOSException {
        Map<String, ColumnInfo> ColumnMap = TableColumnSyncTool.getSHRTableColumnMap(ctx, tableName);
        Iterator<String> sourceColumns = ColumnMap.keySet().iterator();
        Map<String, ColumnInfo> easColumnMap = UpdateTool.getEASTableColumnMap(ctx, tableName);
        Iterator<String> easColumns = easColumnMap.keySet().iterator();
        String[] eascColumnNames = new String[easColumnMap.size()];
        int easColNum = 0;
        while (easColumns.hasNext()) {
            String columnName = easColumns.next();
            eascColumnNames[easColNum] = columnName.trim();
            ++easColNum;
        }
        ArrayList<String> removeList = new ArrayList<String>();
        while (sourceColumns.hasNext()) {
            boolean flag = false;
            String shrColName = sourceColumns.next().trim();
            for (int i = 0; i < eascColumnNames.length; ++i) {
                if (!shrColName.equalsIgnoreCase(eascColumnNames[i])) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            removeList.add(shrColName);
        }
        for (String columnName : removeList) {
            ColumnMap.remove(columnName);
        }
        return ColumnMap;
    }

    public static void autoUpdateTablesByTableNames(Context ctx, String tableNames) throws BOSException, SQLException, EASBizException {
        UpdateTool.autoUpdateTablesByTableNames(ctx, tableNames.split(","));
    }

    public static void autoUpdateTablesByTableNames(Context ctx, String[] tableNames) throws BOSException, SQLException, EASBizException {
        UpdateTool.autoUpdateTablesByTableNames(ctx, new HashSet<String>(Arrays.asList((Object[])tableNames)));
    }

    public static void autoUpdateTablesByTableNames(Context ctx, Set<String> tableNames) throws BOSException, SQLException, EASBizException {
        for (String tableName : tableNames) {
            Set<String> columnSet = new TableColumnSyncTool().getRefreshMappingFieldSet(ctx, tableName, false);
            ArrayList<String> updateColumnList = new ArrayList<String>();
            for (String columnName : columnSet) {
                String tempString = UpdateTool.updateScriptItemBuilder(ctx, tableName, columnName);
                if ("".equals(tempString)) continue;
                updateColumnList.add(tempString);
            }
            if (updateColumnList.isEmpty()) continue;
            UpdateTool.updateTableCoreNew(ctx, updateColumnList);
        }
    }

    public static String updateScriptItemBuilder(Context ctx, String tableName, String columnName) {
        StringBuffer resSb = new StringBuffer("UPDATE ").append(tableName).append(" SET ").append(columnName).append("=").append("(SELECT FEASID FROM T_HR_SynIdMapping WHERE ").append(tableName + ".").append(columnName).append("= T_HR_SynIdMapping.FSHRID)").append(" WHERE ").append(columnName).append(" IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE fSHRID<>'00000000-0000-0000-0000-000000000000CCE7AED4')");
        return resSb.toString();
    }

    public static void updateTablesByTableNameAndSeletedColumns(Context ctx, String tableName, String columnNames) throws BOSException, SQLException, EASBizException {
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, tableName, columnNames.split(","));
    }

    public static void updateTablesByTableNameAndSeletedColumns(Context ctx, String tableName, String[] columnNames) throws BOSException, SQLException, EASBizException {
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, tableName, new HashSet<String>(Arrays.asList((Object[])columnNames)));
    }

    public static void updateTablesByTableNameAndSeletedColumns(Context ctx, String tableName, Set<String> columnNames) throws BOSException, SQLException, EASBizException {
        ArrayList<String> updateColumnList = new ArrayList<String>();
        for (String columnName : columnNames) {
            String tempString = UpdateTool.updateScriptItemBuilder(ctx, tableName, columnName);
            if ("".equals(tempString)) continue;
            updateColumnList.add(tempString);
        }
        if (!updateColumnList.isEmpty()) {
            UpdateTool.updateTableCoreNew(ctx, updateColumnList);
        }
    }

    public static String updateColumnCaseWhenBuilder(Context ctx, String tableName, String columnName) throws BOSException, SQLException {
        StringBuffer sb = new StringBuffer("");
        String tempGroupBy = "select " + columnName + " from " + tableName + " group by " + columnName;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)tempGroupBy);
        if (iRowSet.size() < 1) {
            return sb.toString();
        }
        boolean hasItem = false;
        sb.append(columnName).append(" = ").append(" ( case ");
        while (iRowSet.next()) {
            String tempEASId;
            String tempSHRId = iRowSet.getString(columnName);
            if (tempSHRId == null || "".equals(tempSHRId) || (tempEASId = SynIdMappingUtil.getMappingId(ctx, tempSHRId)) == null || "".equals(tempEASId)) continue;
            sb.append(" when ").append(columnName).append(" = '").append(tempSHRId).append("'").append(" then ").append("'" + tempEASId + "'");
            hasItem = true;
        }
        sb.append(" else " + columnName);
        sb.append(" end) ");
        if (hasItem) {
            return sb.toString();
        }
        return "";
    }

    public static void updateTableCore(Context ctx, String tableName, ArrayList<String> updateColumnList, int strategy) throws BOSException, EASBizException {
        if (strategy == 1) {
            StringBuffer sb = new StringBuffer("");
            sb.append("UPDATE ").append(tableName).append(" SET ");
            for (int i = 0; i < updateColumnList.size(); ++i) {
                sb.append(updateColumnList.get(i)).append(",");
            }
            String sql = sb.substring(0, sb.length() - 1).toString();
            DbUtil.execute((Context)ctx, (String)sql);
        } else if (strategy == 2) {
            for (int i = 0; i < updateColumnList.size(); ++i) {
                StringBuffer sb = new StringBuffer("");
                sb.append("UPDATE ").append(tableName).append(" SET ");
                sb.append(updateColumnList.get(i));
                DbUtil.execute((Context)ctx, (String)sb.toString());
            }
        }
    }

    public static void updateTableCoreNew(Context ctx, ArrayList<String> updateColumnList) throws BOSException, EASBizException, SQLException {
        for (int i = 0; i < updateColumnList.size(); ++i) {
            String tmpSript = updateColumnList.get(i);
            DbUtil.execute((Context)ctx, (String)tmpSript);
        }
    }

    public static Map<String, ColumnInfo> getEASTableColumnMap(Context ctx, String tblName) throws InterfaceDataBaseException, BOSException {
        Map<String, ColumnInfo> columnMap = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            columnMap = TableColumnSyncTool.getTableColumnMap(conn, tblName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return columnMap;
    }

    public ResultSet getRowSetByPageJDBC(Statement pageStmt, String sql, int totalSize, int pageSize, int currentPage) throws SQLException {
        int beginPos = (currentPage - 1) * pageSize;
        int endPos = beginPos + pageSize;
        if (endPos > totalSize) {
            endPos = totalSize;
        }
        pageStmt.setMaxRows(endPos);
        ResultSet resultSet = pageStmt.executeQuery(sql);
        if (beginPos > 0) {
            resultSet.absolute(beginPos);
        }
        return resultSet;
    }

    public ResultSet getRowSetByPageDB(String tableName, List<String> primaryKeyList, String dbType, Statement pageStmt, String sql, int totalSize, int pageSize, int currentPage) throws SQLException {
        ResultSet rs = null;
        int beginPos = (currentPage - 1) * pageSize + 1;
        int endPos = beginPos + pageSize - 1;
        if (endPos > totalSize) {
            endPos = totalSize;
        }
        if ("Oracle".equalsIgnoreCase(dbType)) {
            sql = this.pageSqlBuilderOracle(sql, beginPos, endPos);
        } else {
            int size = pageSize;
            if (endPos == totalSize && endPos % pageSize != 0) {
                size = endPos % pageSize;
            }
            sql = this.pageSqlBuilderSqlServer(tableName, primaryKeyList, sql, size, endPos);
        }
        rs = pageStmt.executeQuery(sql);
        return rs;
    }

    public String pageSqlBuilderOracle(String sql, int beginPos, int endPos) {
        StringBuffer sBuffer = new StringBuffer(sql);
        int bodyBeginIndex = sql.indexOf("SELECT") + 6;
        int bodyEndIndex = sql.indexOf(" FROM");
        String body = sql.substring(bodyBeginIndex, bodyEndIndex);
        sBuffer.insert(bodyBeginIndex, " ROWNUM RN,");
        sBuffer.insert(0, "SELECT " + body + " FROM (");
        sBuffer.append(") WHERE RN BETWEEN " + beginPos + " AND " + endPos);
        return sBuffer.toString();
    }

    public String pageSqlBuilderSqlServer(String tableName, List<String> primaryKeyList, String sql, int size, int endPos) {
        StringBuffer sBuffer = new StringBuffer(sql);
        int bodyBeginIndex = sql.indexOf("SELECT") + 6;
        int bodyEndIndex = sql.indexOf(" FROM");
        String body = sql.substring(bodyBeginIndex, bodyEndIndex);
        StringBuffer pkSb = new StringBuffer();
        String orderString = "";
        for (String pkString : primaryKeyList) {
            pkSb.append("C.").append(pkString).append("=B.").append(pkString).append(" AND ");
            orderString = orderString + pkString + ",";
        }
        pkSb.delete(pkSb.length() - 5, pkSb.length());
        String asc = orderString.replaceAll(",", " ASC,");
        asc = asc.substring(0, asc.length() - 1);
        String desc = orderString.replaceAll(",", " DESC,");
        desc = desc.substring(0, desc.length() - 1);
        sBuffer.insert(bodyBeginIndex, " TOP " + endPos);
        sBuffer.append(" ORDER BY " + desc + " ) A ORDER BY " + asc + " ");
        sBuffer.insert(0, "SELECT TOP " + size + body + " FROM (");
        sBuffer.insert(0, "SELECT C." + body.trim().replaceAll(",", ",C.") + " FROM " + tableName + " C ,(");
        sBuffer.append(" ) B WHERE ");
        sBuffer.append(pkSb);
        sBuffer.append(" ORDER BY " + desc);
        return sBuffer.toString();
    }

    private static DataMoveType getDataMoveType(Context ctx, String tableName, boolean deleteTag) throws BOSException, SQLException {
        DataMoveType dataMoveType = null;
        IRowSet dataMoveTypeRs = DbUtil.executeQuery((Context)ctx, (String)("select FMvDataType from T_HR_SHRMvTableList where FMvTableName='" + tableName + "'"));
        if (dataMoveTypeRs.next() && DataMoveType.DeleteThenInsert == (dataMoveType = DataMoveType.getEnum(dataMoveTypeRs.getInt("FMvDataType"))) && deleteTag) {
            new UpdateTool().truncateTable(ctx, tableName);
        }
        return dataMoveType;
    }
}

