/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.util.ExcelUtil;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.org.HRJobCategoryCollection;
import com.kingdee.eas.hr.org.HRJobCategoryFactory;
import com.kingdee.eas.hr.org.HRJobCategoryInfo;
import com.kingdee.eas.hr.org.HRJobFamilyCollection;
import com.kingdee.eas.hr.org.HRJobFamilyFactory;
import com.kingdee.eas.hr.org.HRJobFamilyInfo;
import com.kingdee.eas.hr.org.HRJobSubCategoryCollection;
import com.kingdee.eas.hr.org.HRJobSubCategoryFactory;
import com.kingdee.eas.hr.org.HRJobSubCategoryInfo;
import com.kingdee.eas.hr.org.HRJobSystemClassifyFactory;
import com.kingdee.eas.hr.org.HRJobSystemClassifyInfo;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.StyleUtil;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class ControlAdminDataMoveHandler
implements ISHRControlMoveDataHandler {
    private static final String DEPARTMENT_ID = "US3TP3eKJgbgU0A+qMDqhoRbQ4A=";
    private static final String COMPANY_ID = "US3TP3eJJgbgU0A+qMDqhoRbQ4A=";
    private static final String GROUP_ID = "US3TP3eIJgbgU0A+qMDqhoRbQ4A=";
    public static final String TEMP_DIR = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/tmp/";

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        this.adminCompanyAndDepartmentMove(ctx);
        this.adminDisplayNameMove(ctx);
        this.jobSystemDataMove(ctx);
        this.initHRJobSystemClassifyAction(ctx);
        this.adminOrgVerUpdateMove(ctx);
        this.personBuRelationUpdateMove(ctx);
        return null;
    }

    public void adminCompanyAndDepartmentMove(Context ctx) throws EASBizException, BOSException {
        String classifyNumber = "UpdateCompanyAndDepartment";
        String classifyName = "\u7ec4\u7ec7\u516c\u53f8\u3001\u90e8\u95e8\u5b57\u6bb5\u5347\u7ea7";
        if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, classifyNumber)) {
            return;
        }
        try {
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "moving");
            String sql = "SELECT adminOrg.FID AS adminID,adminOrg.FLONGNUMBER AS adminLongNumber,adminOrg.FPARENTID AS parentID, adminOrg.FNAME_L2 AS adminName,parent.FNAME_L2 AS parentName, adminAffiliationType.FID AS adminAffiliationTypeID FROM T_ORG_ADMIN adminOrg LEFT JOIN T_ORG_ADMIN parent ON adminOrg.FPARENTID = parent.FID LEFT JOIN T_Org_LayerType layType ON adminOrg.FLAYERTYPEID = layType.FID LEFT JOIN T_ORG_AdminAffiliationType adminAffiliationType ON layType.FAdminAffiliationType = adminAffiliationType.FID ORDER BY adminOrg.FLONGNUMBER";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                IRowSet execute;
                String selectSql;
                int i;
                String updateDepartmentSql;
                String updateCompanySql;
                String adminID = "";
                if (executeQuery.getString("adminID") != null) {
                    adminID = executeQuery.getString("adminID");
                }
                String parentID = "";
                String copyParentID = "";
                if (executeQuery.getString("parentID") != null) {
                    parentID = executeQuery.getString("parentID");
                }
                copyParentID = parentID;
                String adminLongNumber = executeQuery.getString("adminLongNumber");
                if (executeQuery.getString("adminAffiliationTypeID") == null) continue;
                String adminAffiliationTypeID = executeQuery.getString("adminAffiliationTypeID");
                if (adminAffiliationTypeID.equals(GROUP_ID)) {
                    updateCompanySql = "UPDATE T_ORG_ADMIN SET FCompanyID = '" + adminID + "' WHERE FID = '" + adminID + "'";
                    updateDepartmentSql = "UPDATE T_ORG_ADMIN SET FDepartmentID = '' WHERE FID = '" + adminID + "'";
                    DbUtil.execute((Context)ctx, (String)updateCompanySql);
                    DbUtil.execute((Context)ctx, (String)updateDepartmentSql);
                    continue;
                }
                if (adminAffiliationTypeID.equals(COMPANY_ID)) {
                    updateCompanySql = "UPDATE T_ORG_ADMIN SET FCompanyID = '" + adminID + "' WHERE FID = '" + adminID + "'";
                    updateDepartmentSql = "UPDATE T_ORG_ADMIN SET FDepartmentID = '' WHERE FID = '" + adminID + "'";
                    DbUtil.execute((Context)ctx, (String)updateCompanySql);
                    DbUtil.execute((Context)ctx, (String)updateDepartmentSql);
                    continue;
                }
                if (!adminAffiliationTypeID.equals(DEPARTMENT_ID)) continue;
                updateCompanySql = "";
                updateDepartmentSql = "UPDATE T_ORG_ADMIN SET FDepartmentID = '" + adminID + "' WHERE FID = '" + adminID + "'";
                boolean isCompanyUpdate = false;
                for (i = 0; i < adminLongNumber.split("!").length; ++i) {
                    if (this.checkAdminIsCompany(ctx, parentID, COMPANY_ID)) {
                        updateCompanySql = "UPDATE T_ORG_ADMIN SET FCompanyID = '" + parentID + "' WHERE FID = '" + adminID + "'";
                        isCompanyUpdate = true;
                        break;
                    }
                    selectSql = "SELECT FPARENTID AS parentID,FNAME_L2 AS adminName FROM T_ORG_ADMIN WHERE FID = '" + parentID + "'";
                    execute = DbUtil.executeQuery((Context)ctx, (String)selectSql);
                    if (!execute.next()) continue;
                    parentID = execute.getString("parentID");
                }
                if (!isCompanyUpdate) {
                    parentID = copyParentID;
                    for (i = 0; i < adminLongNumber.split("!").length; ++i) {
                        if (this.checkAdminIsCompany(ctx, parentID, GROUP_ID)) {
                            updateCompanySql = "UPDATE T_ORG_ADMIN SET FCompanyID = '" + parentID + "' WHERE FID = '" + adminID + "'";
                            break;
                        }
                        selectSql = "SELECT FPARENTID AS parentID,FNAME_L2 AS adminName FROM T_ORG_ADMIN WHERE FID = '" + parentID + "'";
                        execute = DbUtil.executeQuery((Context)ctx, (String)selectSql);
                        if (!execute.next()) continue;
                        parentID = execute.getString("parentID");
                    }
                }
                if (updateCompanySql.equals("")) {
                    updateCompanySql = "UPDATE T_ORG_ADMIN SET FCompanyID = '00000000-0000-0000-0000-000000000000CCE7AED4' WHERE FID = '" + adminID + "'";
                    DbUtil.execute((Context)ctx, (String)updateCompanySql);
                } else {
                    DbUtil.execute((Context)ctx, (String)updateCompanySql);
                }
                DbUtil.execute((Context)ctx, (String)updateDepartmentSql);
            }
            String updateOUPartSql = "update T_ORG_OUPartAdmin set  (FCompanyID,FDepartmentId,FOfficeID,FLevelFourGroupID,FLevelFiveGroupID,FLevelSixGroupID,FLevelOneGroupID,FLevelTwoGroupID) = (select t2.FCompanyID,t2.FDepartmentId,t2.FOfficeID,t2.FLevelFourGroupID,t2.FLevelFiveGroupID,t2.FLevelSixGroupID,t2.FLevelOneGroupID,t2.FLevelTwoGroupID from T_ORG_ADMIN t2 where t2.FID  = T_ORG_OUPartAdmin.FUNITID )";
            DbUtil.execute((Context)ctx, (String)updateOUPartSql);
            String updateAdminHisSql = "update T_ORG_ADMINHIS set  (FCompanyID,FDepartmentId) = (select t2.FCompanyID,t2.FDepartmentId from T_ORG_ADMIN t2 where t2.FID  = T_ORG_ADMINHIS.FHistoryRelateID ) WHERE T_ORG_ADMINHIS.FLEFFDT = {ts'2199-12-31'}";
            DbUtil.execute((Context)ctx, (String)updateAdminHisSql);
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "finished");
        }
        catch (Exception e) {
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, classifyNumber, "\u51fa\u9519\u5206\u7c7b\uff1a" + classifyName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void adminDisplayNameMove(Context ctx) throws EASBizException, BOSException {
        String classifyNumber = "UpdateDepDisplayName";
        String classifyName = "\u7ec4\u7ec7\u90e8\u95e8\u957f\u540d\u79f0\u5347\u7ea7";
        if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, classifyNumber)) {
            return;
        }
        String sql = "select fid from t_org_admin WHERE fisstartshr = 1 ";
        String updateSql = "update t_hr_shrAdminOrgUnitExtend set FDepDisplayName = ? where FAdminOrgUnitID = ?";
        String updateHisSql = "update t_hr_shrAdminOrgUnitExtendHis set FDepDisplayName = ? where FAdminOrgUnitID = ? and FLEFFDT = {ts '2199-12-31 00:00:00'}";
        try {
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "moving");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                String orgId = iRowSet.getString("fid");
                String depDisplayName = OrgUtils.getDepDisplayNameByOrgId((Context)ctx, (String)orgId);
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{depDisplayName, orgId});
                DbUtil.execute((Context)ctx, (String)updateHisSql, (Object[])new Object[]{depDisplayName, orgId});
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "finished");
        }
        catch (Exception e) {
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, classifyNumber, "\u51fa\u9519\u5206\u7c7b\uff1a" + classifyName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkAdminIsCompany(Context ctx, String parentID, String type) throws BOSException, EASBizException, SQLException {
        boolean result = false;
        try {
            String sql = "SELECT adminOrg.FID AS adminID FROM T_ORG_ADMIN adminOrg LEFT JOIN T_Org_LayerType layType ON adminOrg.FLAYERTYPEID = layType.FID LEFT JOIN T_ORG_AdminAffiliationType adminAffiliationType ON layType.FAdminAffiliationType = adminAffiliationType.FID WHERE adminAffiliationType.FID = '" + type + "' AND adminOrg.FID = '" + parentID + "'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (executeQuery.size() > 0) {
                result = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void jobSystemDataMove(Context ctx) throws EASBizException, BOSException, SQLException {
        String classifyNumber = "JobSystemDataMove";
        String classifyName = "\u804c\u52a1\u4f53\u7cfb\u6570\u636e\u5904\u7406";
        if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, classifyNumber)) {
            return;
        }
        try {
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "moving");
            String jobGradeModuleID = "";
            String jobLevelProjectID = "TpAbDDlmxke/1RE7lKvzDWqB4Xw=";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_HR_JobGradeModule WHERE Fenable = 1");
            if (executeQuery.next()) {
                jobGradeModuleID = executeQuery.getString("FID");
            }
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_JobLevel SET FJobLevelProjectID = '" + jobLevelProjectID + "'"));
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_JobLevelProject SET FJobGradeModuleID = '" + jobGradeModuleID + "' WHERE FID = '" + jobLevelProjectID + "'"));
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_JobGrade SET FIndex = FGrade");
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_JobLevel SET FIndex = 0 WHERE FIndex IS NULL");
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_HRJobFamily SET FJobGradeModuleID = (SELECT top 1 FID FROM T_HR_JobGradeModule WHERE FSTATE = 1 ORDER BY FCreateTime);");
            String updateSql = "UPDATE T_HR_JOBLEVEL SET FLowestJobGradeID = null,FJobGradeID = null  WHERE FLowestJobGradeID NOT IN ( SELECT grade.FID   FROM T_HR_JOBGrade grade LEFT JOIN T_HR_JobGradeModule jobGradeModule ON grade.FJOBGRADEMODULEID  = jobGradeModule.FID  WHERE jobGradeModule.FEnable = 1 )  OR FJobGradeID NOT IN ( SELECT grade.FID   FROM T_HR_JOBGrade grade LEFT JOIN T_HR_JobGradeModule jobGradeModule ON grade.FJOBGRADEMODULEID  = jobGradeModule.FID  WHERE jobGradeModule.FEnable = 1)";
            DbUtil.execute((Context)ctx, (String)updateSql);
            String sql = "SELECT hrJobCategory.FID AS hrJobCategoryID,parent.FID AS parentID FROM T_HR_HRJobCategory hrJobCategory LEFT JOIN T_HR_HRJobCategory parent ON hrJobCategory.FPARENTID = parent.FJobCategoryID";
            IRowSet execute = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (execute.next()) {
                String hrJobCategoryID = execute.getString("hrJobCategoryID");
                String parentID = "";
                if (execute.getString("parentID") != null) {
                    parentID = execute.getString("parentID");
                }
                DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_HRJobCategory SET FPARENTID = '" + parentID + "' WHERE FID = '" + hrJobCategoryID + "'"));
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "finished");
        }
        catch (Exception e) {
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, classifyNumber, "\u51fa\u9519\u5206\u7c7b\uff1a" + classifyName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void initHRJobSystemClassifyAction(Context ctx) throws BOSException, EASBizException {
        String classifyNumber = "HRJobSystemClassify";
        String classifyName = "\u6784\u5efa\u804c\u52a1\u5206\u7c7b\u7684\u6570\u636e";
        if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, classifyNumber)) {
            return;
        }
        try {
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "moving");
            String checkIsInitSql = "SELECT FID FROM T_HR_HRJobSystemClassify";
            IRowSet checkExecuteQuery = DbUtil.executeQuery((Context)ctx, (String)checkIsInitSql);
            if (checkExecuteQuery.size() < 1) {
                String sql = "SELECT hrJobFamily.FID AS hrJobFamilyID,hrJobFamily.FName_l2 AS hrJobFamilyName, hrJobCategory.FID AS hrJobCategoryID,hrJobCategory.FName_l2 AS hrJobCategoryName, hrJobSubCategory.FID AS hrJobSubCategoryID,hrJobSubCategory.FName_l2 AS hrJobSubCategoryName FROM T_HR_HRJobFamily hrJobFamily LEFT JOIN T_HR_HRJobCategory hrJobCategory ON hrJobCategory.FHRJobFamilyID = hrJobFamily.FID LEFT JOIN T_HR_HRJobSubCategory hrJobSubCategory ON  hrJobSubCategory.FHRJobCategoryID = hrJobCategory.FID";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (executeQuery.next()) {
                    HRJobCategoryCollection hrJobCategoryColl;
                    String hrJobCategoryID;
                    HRJobCategoryInfo hrJobCategoryInfo;
                    HRJobSystemClassifyInfo hrJobSystemClassifyInfo = new HRJobSystemClassifyInfo();
                    HRJobFamilyInfo hrJobFamilyInfo = new HRJobFamilyInfo();
                    String hrJobFamilyID = executeQuery.getString("hrJobFamilyID");
                    HRJobFamilyCollection hrJobFamilyColl = HRJobFamilyFactory.getRemoteInstance().getHRJobFamilyCollection("SELECT id WHERE ID = '" + hrJobFamilyID + "'");
                    if (hrJobFamilyColl.size() > 0) {
                        hrJobFamilyInfo = hrJobFamilyColl.get(0);
                    }
                    if (executeQuery.getString("hrJobCategoryID") == null && executeQuery.getString("hrJobSubCategoryID") == null) {
                        hrJobSystemClassifyInfo.setHrJobFamily(hrJobFamilyInfo);
                        hrJobSystemClassifyInfo.setIsLeaf(true);
                        hrJobSystemClassifyInfo.setLevel(1);
                        hrJobSystemClassifyInfo.setName(executeQuery.getString("hrJobFamilyName"));
                        IObjectPK pk = HRJobSystemClassifyFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)hrJobSystemClassifyInfo);
                        String updateSql = "UPDATE T_HR_HRJob SET FHRJobSystemClassifyID = '" + pk.toString() + "' WHERE FHRJobFamilyID = '" + executeQuery.getString("hrJobFamilyID") + "' AND FHRJobCategoryID IS NULL AND FHRJobSubCategoryID IS NULL";
                        DbUtil.execute((Context)ctx, (String)updateSql);
                        continue;
                    }
                    if (executeQuery.getString("hrJobSubCategoryID") == null && executeQuery.getString("hrJobCategoryID") != null) {
                        hrJobCategoryInfo = new HRJobCategoryInfo();
                        hrJobCategoryID = executeQuery.getString("hrJobCategoryID");
                        hrJobCategoryColl = HRJobCategoryFactory.getRemoteInstance().getHRJobCategoryCollection("SELECT * WHERE ID = '" + hrJobCategoryID + "'");
                        if (hrJobCategoryColl.size() > 0) {
                            hrJobCategoryInfo = hrJobCategoryColl.get(0);
                        }
                        hrJobSystemClassifyInfo.setHrJobFamily(hrJobFamilyInfo);
                        hrJobSystemClassifyInfo.setHrJobCategory(hrJobCategoryInfo);
                        hrJobSystemClassifyInfo.setIsLeaf(true);
                        hrJobSystemClassifyInfo.setLevel(2);
                        hrJobSystemClassifyInfo.setName(executeQuery.getString("hrJobFamilyName") + "/" + executeQuery.getString("hrJobCategoryName"));
                        IObjectPK pk = HRJobSystemClassifyFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)hrJobSystemClassifyInfo);
                        String updateSql = "UPDATE T_HR_HRJob SET FHRJobSystemClassifyID = '" + pk.toString() + "' WHERE FHRJobFamilyID = '" + executeQuery.getString("hrJobFamilyID") + "' AND FHRJobCategoryID ='" + hrJobCategoryID + "' AND FHRJobSubCategoryID IS NULL";
                        DbUtil.execute((Context)ctx, (String)updateSql);
                        continue;
                    }
                    if (executeQuery.getString("hrJobSubCategoryID") == null) continue;
                    hrJobCategoryInfo = new HRJobCategoryInfo();
                    hrJobCategoryID = executeQuery.getString("hrJobCategoryID");
                    hrJobCategoryColl = HRJobCategoryFactory.getRemoteInstance().getHRJobCategoryCollection("SELECT * WHERE ID = '" + hrJobCategoryID + "'");
                    if (hrJobCategoryColl.size() > 0) {
                        hrJobCategoryInfo = hrJobCategoryColl.get(0);
                    }
                    HRJobSubCategoryInfo hrJobSubCategoryInfo = new HRJobSubCategoryInfo();
                    String hrJobSubCategoryID = executeQuery.getString("hrJobSubCategoryID");
                    HRJobSubCategoryCollection hrJobSubCategoryColl = HRJobSubCategoryFactory.getRemoteInstance().getHRJobSubCategoryCollection("SELECT * WHERE ID = '" + hrJobSubCategoryID + "'");
                    if (hrJobSubCategoryColl.size() > 0) {
                        hrJobSubCategoryInfo = hrJobSubCategoryColl.get(0);
                    }
                    hrJobSystemClassifyInfo.setHrJobFamily(hrJobFamilyInfo);
                    hrJobSystemClassifyInfo.setHrJobCategory(hrJobCategoryInfo);
                    hrJobSystemClassifyInfo.setHrJobSubCategory(hrJobSubCategoryInfo);
                    hrJobSystemClassifyInfo.setIsLeaf(true);
                    hrJobSystemClassifyInfo.setLevel(3);
                    hrJobSystemClassifyInfo.setName(executeQuery.getString("hrJobFamilyName") + "/" + executeQuery.getString("hrJobCategoryName") + "/" + executeQuery.getString("hrJobSubCategoryName"));
                    IObjectPK pk = HRJobSystemClassifyFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)hrJobSystemClassifyInfo);
                    String updateSql = "UPDATE T_HR_HRJob SET FHRJobSystemClassifyID = '" + pk.toString() + "' WHERE FHRJobFamilyID = '" + executeQuery.getString("hrJobFamilyID") + "' AND FHRJobCategoryID ='" + hrJobCategoryID + "' AND FHRJobSubCategoryID = '" + hrJobSubCategoryID + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "finished");
        }
        catch (Exception e) {
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, classifyNumber, "\u51fa\u9519\u5206\u7c7b\uff1a" + classifyName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        String sql;
        IRowSet executeQuery;
        String resultError = "";
        if (resultError.equals("") && (executeQuery = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT * FROM T_Org_LayerType WHERE FAdminAffiliationType IS NULL OR FAdminAffiliationType =''"))).size() > 0) {
            resultError = "\u5b58\u5728\u884c\u653f\u7c7b\u578b\u5f52\u5c5e\u4e3a\u7a7a\u7684\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\uff0c\u8bf7\u5148\u5728GUI\u7684\u884c\u653f\u7ec4\u7ec7\u5c5e\u6027\u9875\u7b7e\u624b\u5de5\u7ef4\u62a4\uff01";
            return resultError;
        }
        if (resultError.equals("")) {
            int count = 0;
            String sql2 = "SELECT adminOrg.FID AS adminID,adminOrg.FNUMBER AS adminNumber,adminOrg.FNAME_l2 AS adminName,adminType.FID AS adminTypeID,adminType.FNUMBER AS adminTypeNumber,adminType.FNAME_L2 AS adminTypeName,parentAdminType.FID AS parentAdminTypeID,parentAdminType.FNUMBER AS parentAdminTypeNumber,parentAdminType.FNAME_L2 AS parentAdminTypeName FROM T_ORG_ADMIN adminOrg LEFT JOIN T_Org_LayerType layerType ON adminOrg.FLAYERTYPEID = layerType.FID LEFT JOIN T_ORG_AdminAffiliationType adminType ON layerType.FAdminAffiliationType = adminType.FID LEFT JOIN T_ORG_ADMIN parent ON adminOrg.FPARENTID = parent.FID  LEFT JOIN T_Org_LayerType parentLayerType ON parent.FLAYERTYPEID = parentLayerType.FID LEFT JOIN T_ORG_AdminAffiliationType parentAdminType ON parentLayerType.FAdminAffiliationType = parentAdminType.FID WHERE adminOrg.FID <> '00000000-0000-0000-0000-000000000000CCE7AED4' ORDER BY parentAdminType.FNUMBER";
            IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
            while (executeQuery2.next()) {
                String adminName = executeQuery2.getString("adminName");
                String adminNumber = executeQuery2.getString("adminNumber");
                String adminTypeID = "";
                String parentAdminTypeID = "";
                if (executeQuery2.getString("adminTypeID") == null) {
                    resultError = resultError + adminName + "\uff08" + adminNumber + "\uff09\u6ca1\u6709\u5bf9\u5e94\u7684\u884c\u653f\u7c7b\u578b\u5f52\u5c5e\uff1b</br>";
                    ++count;
                    continue;
                }
                adminTypeID = executeQuery2.getString("adminTypeID");
                if (executeQuery2.getString("parentAdminTypeID") == null) {
                    resultError = resultError + adminName + "\uff08" + adminNumber + "\uff09\u4e0a\u7ea7\u7ec4\u7ec7\u6ca1\u6709\u5bf9\u5e94\u7684\u884c\u653f\u7c7b\u578b\u5f52\u5c5e\uff1b</br>";
                    ++count;
                    continue;
                }
                parentAdminTypeID = executeQuery2.getString("parentAdminTypeID");
                if (adminTypeID.equals(GROUP_ID) && !parentAdminTypeID.equals(GROUP_ID)) {
                    resultError = resultError + adminName + "\uff08" + adminNumber + "\uff09\u4e0d\u7b26\u5408\u96c6\u56e2\u7684\u4e0a\u7ea7\u662f\u96c6\u56e2\uff1b</br>";
                    ++count;
                } else if (adminTypeID.equals(COMPANY_ID) && !parentAdminTypeID.equals(GROUP_ID) && !parentAdminTypeID.equals(COMPANY_ID)) {
                    resultError = resultError + adminName + "\uff08" + adminNumber + "\uff09\u4e0d\u7b26\u5408\u516c\u53f8\u7684\u4e0a\u7ea7\u662f\u96c6\u56e2\u548c\u516c\u53f8\uff1b</br>";
                    ++count;
                } else if (adminTypeID.equals(DEPARTMENT_ID) && !parentAdminTypeID.equals(GROUP_ID) && !parentAdminTypeID.equals(COMPANY_ID) && !parentAdminTypeID.equals(DEPARTMENT_ID)) {
                    resultError = resultError + adminName + "\uff08" + adminNumber + "\uff09\u4e0d\u7b26\u5408\u90e8\u95e8\u7684\u4e0a\u7ea7\u662f\u96c6\u56e2\u3001\u516c\u53f8\u3001\u90e8\u95e8\uff1b</br>";
                    ++count;
                }
                if (count <= 5) continue;
                resultError = resultError + "<a href='javascript:void(0)' id = 'adminViewMore'>\u67e5\u770b\u66f4\u591a</a>";
                resultError = resultError + "</br><a href='javascript:void(0)' id = 'adminUpdateUIPK'>\u4fee\u6539\u7ec4\u7ec7\u884c\u653f\u7c7b\u578b\u5f52\u5c5e</a>";
                return resultError;
            }
            if (!resultError.equals("")) {
                resultError = resultError + "</br><a href='javascript:void(0)' id = 'adminUpdateUIPK'>\u4fee\u6539\u7ec4\u7ec7\u884c\u653f\u7c7b\u578b\u5f52\u5c5e</a>";
            }
        }
        if (resultError.equals("")) {
            sql = "SELECT TOP 1 FID FROM T_ORG_POSITION WHERE FJOBLEVELID NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (executeQuery.size() > 0) {
                resultError = resultError + "</br>\u804c\u4f4d\u8868\u90e8\u5206\u804c\u4f4d\u5bf9\u5e94\u804c\u5c42\u5728\u804c\u5c42\u8868\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u6e05\u7a7a\u804c\u4f4d\u8868\u4e0a\u7684\u804c\u5c42\u6570\u636e";
                resultError = resultError + "</br>\u67e5\u8be2SQL\uff1aSELECT * FROM T_ORG_POSITION WHERE FJOBLEVELID NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
                resultError = resultError + "</br>\u4fee\u590dSQL\uff1aUPDATE T_ORG_POSITION SET FJOBLEVELID = NULL WHERE FJOBLEVELID NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT TOP 1 FID FROM T_ORG_POSITIONHIS WHERE FJOBLEVELID NOT IN (SELECT FID FROM T_HR_JOBLEVEL)"))).size() > 0) {
                resultError = resultError + "</br>\u804c\u4f4d\u5386\u53f2\u8868\u90e8\u5206\u804c\u4f4d\u5bf9\u5e94\u804c\u5c42\u5728\u804c\u5c42\u8868\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u6e05\u7a7a\u804c\u4f4d\u5386\u53f2\u8868\u4e0a\u7684\u804c\u5c42\u6570\u636e";
                resultError = resultError + "</br>\u67e5\u8be2SQL\uff1aSELECT * FROM T_ORG_POSITIONHIS WHERE FJOBLEVELID NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
                resultError = resultError + "</br>\u4fee\u590dSQL\uff1aUPDATE T_ORG_POSITIONHIS SET FJOBLEVELID = NULL WHERE FJOBLEVELID NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT TOP 1 FID FROM T_HR_POSITIONEXTEND WHERE FLowJobLevel NOT IN (SELECT FID FROM T_HR_JOBLEVEL)"))).size() > 0) {
                resultError = resultError + "</br>\u804c\u4f4d\u6269\u5c55\u8868\u90e8\u5206\u804c\u4f4d\u5bf9\u5e94\u6700\u4f4e\u804c\u5c42\u5728\u804c\u5c42\u8868\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u6e05\u7a7a\u804c\u4f4d\u6269\u5c55\u8868\u4e0a\u7684\u6700\u4f4e\u804c\u5c42\u6570\u636e";
                resultError = resultError + "</br>\u67e5\u8be2SQL\uff1aSELECT * FROM T_HR_POSITIONEXTEND WHERE FLowJobLevel NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
                resultError = resultError + "</br>\u4fee\u590dSQL\uff1aUPDATE T_HR_POSITIONEXTEND SET FLowJobLevel = NULL WHERE FLowJobLevel NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
            }
            if ((executeQuery = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT TOP 1 FID FROM T_HR_POSITIONEXTEND WHERE FHighJobLevel NOT IN (SELECT FID FROM T_HR_JOBLEVEL)"))).size() > 0) {
                resultError = resultError + "</br>\u804c\u4f4d\u6269\u5c55\u8868\u90e8\u5206\u804c\u4f4d\u5bf9\u5e94\u6700\u9ad8\u804c\u5c42\u5728\u804c\u5c42\u8868\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u6e05\u7a7a\u804c\u4f4d\u6269\u5c55\u8868\u4e0a\u7684\u6700\u9ad8\u804c\u5c42\u6570\u636e";
                resultError = resultError + "</br>\u67e5\u8be2SQL\uff1aSELECT * FROM T_HR_POSITIONEXTEND WHERE FHighJobLevel NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
                resultError = resultError + "</br>\u4fee\u590dSQL\uff1aUPDATE T_HR_POSITIONEXTEND SET FHighJobLevel = NULL WHERE FHighJobLevel NOT IN (SELECT FID FROM T_HR_JOBLEVEL)";
            }
            if (!resultError.equals("")) {
                resultError = "\u804c\u4f4d\u6570\u636e\u5907\u4efdSQL\uff08\u53ea\u9700\u8981\u6267\u884c\u4e00\u6b21\uff09:SELECT * INTO T_ORG_POSITION_COPY FROM T_ORG_POSITION</br>SELECT * INTO T_ORG_POSITIONHIS_COPY FROM T_ORG_POSITIONHIS" + resultError;
                return resultError;
            }
        }
        return resultError;
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        ArrayList<HashMap<String, String>> resultArrayList = new ArrayList<HashMap<String, String>>();
        return resultArrayList;
    }

    public static String exportAdminTypeCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
            itemMap.put("\u884c\u653f\u7ec4\u7ec7\u7f16\u7801", new Object[]{"adminNumber"});
            itemMap.put("\u884c\u653f\u7ec4\u7ec7\u540d\u79f0", new Object[]{"adminName"});
            itemMap.put("\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", new Object[]{"adminLayerType"});
            itemMap.put("\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u5f52\u5c5e", new Object[]{"adminAffairType"});
            itemMap.put("\u516c\u53f8\u540d\u79f0", new Object[]{"adminCompanyName"});
            itemMap.put("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7f16\u7801", new Object[]{"parentNumber"});
            itemMap.put("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u540d\u79f0", new Object[]{"parentName"});
            itemMap.put("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", new Object[]{"parentLayerType"});
            itemMap.put("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u5f52\u5c5e", new Object[]{"parentAffairType"});
            itemMap.put("\u4e0a\u7ea7\u516c\u53f8\u540d\u79f0", new Object[]{"parentCompanyName"});
            XSSFWorkbook wb = new XSSFWorkbook();
            Map<String, CellStyle> styles = StyleUtil.createStyles((Workbook)wb);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setColor(IndexedColors.DARK_RED.getIndex());
            font.setFontHeightInPoints((short)12);
            cellStyle.setWrapText(true);
            cellStyle.setFont((Font)font);
            XSSFSheet sheet = wb.createSheet("\u6821\u9a8c\u62a5\u544a");
            XSSFRow row = null;
            Cell cell = null;
            row = sheet.createRow(0);
            row.setHeight((short)400);
            int itemCount = 0;
            for (String itemName : itemMap.keySet()) {
                cell = row.createCell(itemCount++);
                cell.setCellValue(itemName);
                cell.setCellStyle(styles.get("mustInputHead"));
            }
            for (int i = 0; i < itemCount; ++i) {
                if (i == 1) {
                    sheet.setColumnWidth(i, 4000);
                    continue;
                }
                sheet.setColumnWidth(i, 4000);
            }
            int count = 0;
            String sql = "SELECT adminOrg.FNUMBER AS adminNumber,adminOrg.FNAME_l2 AS adminName, layerType.FNAME_L2 AS adminLayerType,adminType.FNAME_L2 AS adminAffairType,company.FNAME_L2 AS adminCompanyName, parent.FNUMBER AS parentNumber,parent.FNAME_l2 AS parentName, parentLayerType.FNAME_L2 AS parentLayerType,parentAdminType.FNAME_L2 AS parentAffairType,parentCompany.FNAME_L2 AS parentCompanyName, adminType.FID AS adminTypeID,parentAdminType.FID AS parentAdminTypeID FROM T_ORG_ADMIN adminOrg LEFT JOIN T_Org_LayerType layerType ON adminOrg.FLAYERTYPEID = layerType.FID LEFT JOIN T_ORG_AdminAffiliationType adminType ON layerType.FAdminAffiliationType = adminType.FID LEFT JOIN T_ORG_ADMIN company ON adminOrg.FCompanyID = company.FID LEFT JOIN T_ORG_ADMIN parent ON adminOrg.FPARENTID = parent.FID  LEFT JOIN T_Org_LayerType parentLayerType ON parent.FLAYERTYPEID = parentLayerType.FID LEFT JOIN T_ORG_AdminAffiliationType parentAdminType ON parentLayerType.FAdminAffiliationType = parentAdminType.FID LEFT JOIN T_ORG_ADMIN parentCompany ON parent.FCompanyID = parentCompany.FID WHERE adminOrg.FID <> '00000000-0000-0000-0000-000000000000CCE7AED4' ORDER BY parentAdminType.FNUMBER";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String adminTypeID = "";
                String parentAdminTypeID = "";
                boolean result = true;
                if (executeQuery.getString("adminTypeID") != null) {
                    adminTypeID = executeQuery.getString("adminTypeID");
                } else {
                    result = false;
                }
                if (executeQuery.getString("parentAdminTypeID") != null) {
                    parentAdminTypeID = executeQuery.getString("parentAdminTypeID");
                } else {
                    result = false;
                }
                if (result && adminTypeID.equals(GROUP_ID) && !parentAdminTypeID.equals(GROUP_ID)) {
                    result = false;
                } else if (adminTypeID.equals(COMPANY_ID) && !parentAdminTypeID.equals(GROUP_ID) && !parentAdminTypeID.equals(COMPANY_ID)) {
                    result = false;
                } else if (adminTypeID.equals(DEPARTMENT_ID) && !parentAdminTypeID.equals(GROUP_ID) && !parentAdminTypeID.equals(COMPANY_ID) && !parentAdminTypeID.equals(DEPARTMENT_ID)) {
                    result = false;
                }
                if (result) continue;
                row = sheet.createRow(1 + count);
                cell = row.createCell(0);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("adminNumber")));
                cell = row.createCell(1);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("adminName")));
                cell = row.createCell(2);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("adminLayerType")));
                cell = row.createCell(3);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("adminAffairType")));
                cell = row.createCell(4);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("adminCompanyName")));
                cell = row.createCell(5);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("parentNumber")));
                cell = row.createCell(6);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("parentName")));
                cell = row.createCell(7);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("parentLayerType")));
                cell = row.createCell(8);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("parentAffairType")));
                cell = row.createCell(9);
                cell.setCellValue(ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("parentCompanyName")));
                ++count;
            }
            String path = TEMP_DIR + UUID.randomUUID().toString() + ".xlsx";
            FileOutputStream out = new FileOutputStream(path);
            wb.write((OutputStream)out);
            out.close();
            ExcelUtil.setExportExcelHead(response, path, "\u6821\u9a8c\u62a5\u544a");
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getExeValue(Object temp) {
        if (temp == null) {
            return "";
        }
        return temp.toString();
    }

    public void adminOrgVerUpdateMove(Context ctx) throws EASBizException, BOSException {
        String classifyNumber = "UpdateAdminOrgVer";
        String classifyName = "\u7ec4\u7ec7\u8c03\u6574\u65b9\u6848\u5347\u7ea7";
        if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, classifyNumber)) {
            return;
        }
        try {
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "moving");
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PositionVer SET FLowJobLevelID = FJobLevelID WHERE FORGADJSCHM IN (SELECT FID FROM T_HR_HROrgAdjSchm WHERE fEnableStatus <> 1) AND FLowJobLevelID IS NULL");
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PositionVer SET FHighJobLevelID = FJobLevelID WHERE FORGADJSCHM IN (SELECT FID FROM T_HR_HROrgAdjSchm WHERE fEnableStatus <> 1) AND FHighJobLevelID IS NULL");
            String sql = "SELECT positionVer.FID AS positionVerID,hrJob.FID AS hrJobID FROM T_HR_PositionVer positionVer LEFT JOIN T_ORG_JOB jobTemp ON positionVer.FJOBID = jobTemp.FID  LEFT JOIN T_HR_HRJOB hrJob ON hrJob.FJOBID = jobTemp.FID  WHERE positionVer.FORGADJSCHM IN (SELECT FID FROM T_HR_HROrgAdjSchm WHERE fEnableStatus <> 1)";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String positionVerID = executeQuery.getString("positionVerID");
                if (executeQuery.getString("hrJobID") == null) continue;
                String hrJobID = executeQuery.getString("hrJobID");
                String updateSql = "UPDATE T_HR_PositionVer SET FHRJobID = '" + hrJobID + "' WHERE FID = '" + positionVerID + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "finished");
        }
        catch (Exception e) {
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, classifyNumber, "\u51fa\u9519\u5206\u7c7b\uff1a" + classifyName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void personBuRelationUpdateMove(Context ctx) throws EASBizException, BOSException {
        String classifyNumber = "UpdatePersonBuRelation";
        String classifyName = "\u5458\u5de5\u4e1a\u52a1\u5173\u7cfb\u5347\u7ea7";
        if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, classifyNumber)) {
            return;
        }
        try {
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "moving");
            Date nowDate = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateNowStr = sdf.format(nowDate);
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonBURelation SET FEFFDT = (SELECT T2.FEFFDT FROM T_HR_EMPORGRELATION T2  WHERE T_HR_PersonBURelation.FEmpOrgRelationID = T2.FID) WHERE T_HR_PersonBURelation.FBeginDate = {TS'1900-01-01'}");
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonBURelation SET FBeginDate = NULL WHERE FBeginDate = {TS'1900-01-01'} AND FBIZMANAGETYPEID NOT IN ('SGuJm3nXW0GshQfKRXenomWJ1dE=')");
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonBURelation SET FBeginDate = {TS'" + dateNowStr + "'} WHERE FBeginDate = {TS'1900-01-01'} AND FBIZMANAGETYPEID IN ('SGuJm3nXW0GshQfKRXenomWJ1dE=')"));
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, classifyNumber, "finished");
        }
        catch (Exception e) {
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, classifyNumber, "\u51fa\u9519\u5206\u7c7b\uff1a" + classifyName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        IRowSet checkQuery;
        ArrayList<String> sqlList = new ArrayList<String>();
        HashSet<String> errorSet = new HashSet<String>();
        int positionCount = 0;
        int adminCount = 0;
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_ORG_POSITION");
        positionCount = executeQuery.size();
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID FROM T_ORG_ADMIN");
        adminCount = executeQuery.size();
        int percent = 0;
        String adminID = "";
        String adminName = "";
        String adminNumber = "";
        String positionID = "";
        String positionName = "";
        String positionNumber = "";
        String insertSQL = "";
        String repairGuide = "";
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT,FLONGNUMBER FROM T_ORG_ADMIN WHERE FID NOT IN (SELECT FHistoryRelateID FROM T_ORG_ADMINHIS)");
        while (executeQuery.next()) {
            adminID = executeQuery.getString("FID");
            adminName = executeQuery.getString("FNAME_L2");
            adminNumber = executeQuery.getString("FNUMBER");
            repairGuide = "insert into T_ORG_AdminHiS(FID  ,FHistoryRelateID ,FIsEntity ,FIsVirtual ,FPhoneNumber ,FLayerID ,FResponPositionID ,FAddressID ,FPrincipalID ,FLayerTypeID ,FBaseDuty_l1 ,FBaseDuty_l2 ,FBaseDuty_l3 ,FJobSystemID ,FIndex ,FParentID ,FAdminAddress_l1 ,FAdminAddress_l2 ,FAdminAddress_l3 ,FZipCode ,FFax,FIsSealUp,FPropertySealUpDate  ,FSortCode ,FIndustryID ,FEconomicType  ,FRegisteredCapital ,FRegisteredCode ,FSetupDate  ,FEndupDate  ,FTerritory_l1 ,FTerritory_l2 ,FTerritory_l3 ,FIsChurchyard ,FTaxNumber ,FIsIndependence  ,FIsJuridicalCompany  ,FJuridicalPersonID ,FOrgPropertyID ,FRegistTypeID ,FOrgCode,FEFFDT ,FLEFFDT ,FDelegateHRID,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit  ,FIsCU,FIsUnion  ,FIsHROrgUnit,FIsTransportOrgUnit  ,FIsQualityOrgUnit  ,FIsStart  ,FIsOUSealUp ,FCode ,FVersionNumber ,FOrgTypeStr ,FIsLeaf  ,FLevel  ,FLongNumber ,FDisplayName_l1 ,FDisplayName_l2 ,FDisplayName_l3 ,FName_l1 ,FName_l2 ,FName_l3 ,FNumber ,FDescription_l1 ,FDescription_l2 ,FDescription_l3 ,FSimpleName ,FCreatorID ,FCreateTime  ,FLastUpdateUserID ,FLastUpdateTime ,FControlUnitID ) select newbosid(/E38B20F4/),Fid ,FIsEntity ,FIsVirtual ,FPhoneNumber ,FLayerID ,FResponPositionID ,FAddressID ,FPrincipalID ,FLayerTypeID ,FBaseDuty_l1 ,FBaseDuty_l2 ,FBaseDuty_l3 ,FJobSystemID ,FIndex ,FParentID ,FAdminAddress_l1 ,FAdminAddress_l2 ,FAdminAddress_l3 ,FZipCode ,FFax,FIsSealUp,FPropertySealUpDate,FSortCode ,FIndustryID ,FEconomicType  ,FRegisteredCapital ,FRegisteredCode ,FSetupDate  ,FEndupDate  ,FTerritory_l1 ,FTerritory_l2 ,FTerritory_l3 ,FIsChurchyard ,FTaxNumber ,FIsIndependence  ,FIsJuridicalCompany  ,FJuridicalPersonID ,FOrgPropertyID ,FRegistTypeID ,FOrgCode,FEFFDT ,FLEFFDT ,FDelegateHRID,FIsGrouping,FEffectDate,FInvalidDate,FIsFreeze,FIsCompanyOrgUnit,FIsAdminOrgUnit,FIsSaleOrgUnit,FIsPurchaseOrgUnit,FIsStorageOrgUnit,FIsProfitOrgUnit,FIsCostOrgUnit  ,FIsCU,FIsUnion  ,FIsHROrgUnit,FIsTransportOrgUnit  ,FIsQualityOrgUnit  ,FIsStart  ,FIsOUSealUp ,FCode ,FVersionNumber ,FOrgTypeStr ,FIsLeaf  ,FLevel  ,FLongNumber ,FDisplayName_l1 ,FDisplayName_l2 ,FDisplayName_l3 ,FName_l1 ,FName_l2 ,FName_l3 ,FNumber ,FDescription_l1 ,FDescription_l2 ,FDescription_l3 ,FSimpleName ,FCreatorID ,FCreateTime  ,FLastUpdateUserID ,FLastUpdateTime,FControlUnitID  from t_org_admin where FID not in (select FHistoryRelateID from T_ORG_AdminHIS) and FID = /" + adminID + "/";
            insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + adminNumber + "', null,N'" + adminName + "', null, N'\u7ec4\u7ec7', null,N'\u884c\u653f\u7ec4\u7ec7\u5386\u53f2\u8868T_ORG_ADMINHIS\u6570\u636e\u7f3a\u5931','" + repairGuide + "',newbosid('456B840C'),1);";
            sqlList.add(insertSQL);
            errorSet.add(adminID);
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 5, 0);
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT,FLONGNUMBER FROM T_ORG_ADMIN WHERE FID NOT IN (SELECT FAdminOrgUnitID FROM T_HR_SHRAdminOrgUnitExtend)");
        while (executeQuery.next()) {
            adminID = executeQuery.getString("FID");
            adminName = executeQuery.getString("FNAME_L2");
            adminNumber = executeQuery.getString("FNUMBER");
            repairGuide = "INSERT INTO T_HR_SHRAdminOrgUnitExtend(FID,FAdminOrgUnitID,FEFFDT,FLEFFDT) SELECT newbosid(/091646FA/),FID,FEFFDT,FLEFFDT FROM T_ORG_ADMIN WHERE FID = /" + adminID + "/";
            insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + adminNumber + "', null,N'" + adminName + "', null, N'\u7ec4\u7ec7', null,N'\u884c\u653f\u7ec4\u7ec7\u6269\u5c55\u8868T_HR_SHRAdminOrgUnitExtend\u6570\u636e\u7f3a\u5931','" + repairGuide + "',newbosid('456B840C'),1);";
            sqlList.add(insertSQL);
            errorSet.add(adminID);
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 5, 0);
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT,FLONGNUMBER FROM T_ORG_ADMIN WHERE FID NOT IN (SELECT FAdminOrgUnitID FROM T_HR_SHRAdminOrgUnitExtendHIS)");
        while (executeQuery.next()) {
            adminID = executeQuery.getString("FID");
            adminName = executeQuery.getString("FNAME_L2");
            adminNumber = executeQuery.getString("FNUMBER");
            repairGuide = "insert into T_HR_SHRAdminOrgUnitExtendhis (FADMINORGUNITID ,FHISTORYRELATEID, FEFFDT , FLEFFDT , FId ) select org.fid,orgext.fid,orghis.FEFFDT,orghis.FLEFFDT,newbosid(/776EB638/) from t_org_admin org left join T_ORG_ADMINhis orghis on org.fid = orghis.FHISTORYRELATEID left join T_HR_SHRAdminOrgUnitExtend  orgext on org.fid = orgext.FADMINORGUNITID WHERE org.fid not in (select FADMINORGUNITID from  T_HR_SHRAdminOrgUnitExtendhis ) and org.FID = /" + adminID + "/";
            insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + adminNumber + "', null,N'" + adminName + "', null, N'\u7ec4\u7ec7', null,N'\u884c\u653f\u7ec4\u7ec7\u6269\u5c55\u5386\u53f2\u8868T_HR_SHRAdminOrgUnitExtendHIS\u6570\u636e\u7f3a\u5931','" + repairGuide + "',newbosid('456B840C'),1);";
            sqlList.add(insertSQL);
            errorSet.add(adminID);
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 5, 0);
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT FROM T_ORG_POSITION WHERE FID NOT IN (SELECT FHistoryRelateID FROM T_ORG_POSITIONHIS)");
        while (executeQuery.next()) {
            positionID = executeQuery.getString("FID");
            positionName = executeQuery.getString("FNAME_L2");
            positionNumber = executeQuery.getString("FNUMBER");
            repairGuide = "insert into T_ORG_PositionHIS(FID,FEFFDT ,FLEFFDT ,FHistoryRelateID ,FParentID ,FProductLineID ,FDomainID ,FAdminOrgUnitID ,FHROrgUnitID ,FDeletedStatus  ,FPositionTypeID ,FPubProperLdap ,FIsRespPosition  ,FFluCheckTime  ,FIsCreateByJob ,FJOBID ,FJobLevelID ,FLowJobGradeID ,FHighJobGradeID ,FPosPlanCount ,FIndex ,FSortCode ,FName_l1 ,FName_l2 ,FName_l3 ,FNumber ,FDescription_l1 ,FDescription_l2 ,FDescription_l3 ,FSimpleName ,FCreatorID ,FCreateTime ,FLastUpdateUserID ,FLastUpdateTime ,FControlUnitID )  select newBosid(/50BFFF84/) ,FEFFDT ,FLEFFDT ,FID ,FParentID ,FProductLineID ,FDomainID ,FAdminOrgUnitID ,FHROrgUnitID ,FDeletedStatus  ,FPositionTypeID ,FPubProperLdap ,FIsRespPosition  ,CASE WHEN FFluCheckTime IS NULL THEN 0 ELSE FFluCheckTime END  ,FIsCreateByJob ,FJOBID ,FJobLevelID ,FLowJobGradeID ,FHighJobGradeID ,TO_INT(FPosPlanCount) ,FIndex ,FSortCode ,FName_l1 ,FName_l2 ,FName_l3 ,FNumber ,FDescription_l1 ,FDescription_l2 ,FDescription_l3 ,FSimpleName ,FCreatorID ,FCreateTime ,FLastUpdateUserID ,FLastUpdateTime ,FControlUnitID  from  T_ORG_Position  where FID not in (select FHistoryRelateID from T_ORG_PositionHIS) and FID = /" + positionID + "/";
            insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + positionNumber + "', null,N'" + positionName + "', null, N'\u804c\u4f4d', null,N'\u804c\u4f4d\u5386\u53f2\u8868T_ORG_POSITIONHIS\u6570\u636e\u7f3a\u5931','" + repairGuide + "',newbosid('456B840C'),1);";
            sqlList.add(insertSQL);
            errorSet.add(adminID);
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 5, 0);
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)"SELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT FROM T_ORG_POSITION WHERE FID NOT IN (SELECT FPositionID FROM T_HR_POSITIONEXTEND)");
        while (executeQuery.next()) {
            positionID = executeQuery.getString("FID");
            positionName = executeQuery.getString("FNAME_L2");
            positionNumber = executeQuery.getString("FNUMBER");
            repairGuide = "insert into T_HR_PositionExtend (FPOSITIONID,FLowJobLevel,FHighJobLevel,FHRJobID,FCREATORID,FCREATETIME,FLASTUPDATEUSERID,FLASTUPDATETIME,FCONTROLUNITID,FID)  select position.FID,position.FJobLevelID,position.FJobLevelID,hrJOb.FID,position.FCREATORID,position.FCREATETIME,position.FLASTUPDATEUSERID,position.FLASTUPDATETIME,'00000000-0000-0000-0000-000000000000CCE7AED4',newbosid(/079E7A39/)  from T_ORG_Position position left join T_HR_HRJOB hrJOb ON position.FJOBID = hrJOb.FJobID where position.fid not in (SELECT FPOSITIONID FROM T_HR_PositionExtend) and position.fid = '" + positionID + "'";
            insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + positionNumber + "', null,N'" + positionName + "', null, N'\u804c\u4f4d', null,N'\u804c\u4f4d\u6269\u5c55\u8868T_HR_POSITIONEXTEND\u6570\u636e\u7f3a\u5931','" + repairGuide + "',newbosid('456B840C'),1);";
            sqlList.add(insertSQL);
            errorSet.add(adminID);
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 5, 0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int checkCount = 0;
        String effdtString = "";
        String adminOrgUnitID = "";
        String id = "";
        String sql = "SELECT adminHis.FID AS hisID,adminOrg.FNAME_L2 AS adminName,adminOrg.FNUMBER AS adminNumber,adminOrg.FID AS adminOrgUnitID,adminHis.FEFFDT AS effdt,adminHis.FLEFFDT AS leffdt FROM T_ORG_ADMIN adminOrg LEFT JOIN T_ORG_ADMINHIS adminHis ON adminOrg.FID = adminHis.FHistoryRelateID ORDER BY adminHis.FHistoryRelateID,adminHis.FEFFDT";
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (executeQuery.next()) {
            id = executeQuery.getString("hisID");
            adminNumber = executeQuery.getString("adminNumber");
            adminName = executeQuery.getString("adminName");
            adminOrgUnitID = executeQuery.getString("adminOrgUnitID");
            repairGuide = "1\u3001\u67e5\u8be2\u7ec4\u7ec7\u5386\u53f2\u6570\u636e\uff1aSELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT FROM T_ORG_ADMINHIS  WHERE FHISTORYRELATEID = /" + id + "/  2\u3001\u5982\u679c\u4fee\u590d\u524d\u6ca1\u6709\u5907\u4efd\u8fc7\uff0c\u8bf7\u5907\u4efdT_ORG_ADMINHIS\u6570\u636e\uff1aSELECT * INTO T_ORG_ADMINHIS_BF FROM T_ORG_ADMINHIS 3\u3001\u901a\u8fc7FID\uff0c\u66f4\u65b0\u5386\u53f2\u6570\u636e\u65e5\u671f \uff081\uff09\u66f4\u65b0\u751f\u6548\u65e5\u671f\uff1aUPDATE T_ORG_ADMINHIS SET FEFFDT = /TS{xxxx-xx-xx}/ WHERE FID = /xxx/ \uff082\uff09\u66f4\u65b0\u5931\u6548\u65e5\u671f\uff1aUPDATE T_ORG_ADMINHIS SET FLEFFDT = /TS{xxxx-xx-xx}/ WHERE FID = /xxx/";
            if (executeQuery.getDate("leffdt") != null) {
                effdtString = formatter.format(executeQuery.getDate("leffdt"));
                checkQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT * FROM T_ORG_ADMINHIS WHERE FID <> '" + id + "' AND FHistoryRelateID = '" + adminOrgUnitID + "' AND FEFFDT <= {TS'" + effdtString + "'} AND FLEFFDT >= {TS'" + effdtString + "'}"));
                if (checkQuery.size() > 0) {
                    insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + adminNumber + "', null,N'" + adminName + "', null, N'\u7ec4\u7ec7', null,N'\u884c\u653f\u7ec4\u7ec7\u5386\u53f2\u8868T_ORG_ADMINHIS\uff0c\u65f6\u95f4\u4ea4\u53c9','" + repairGuide + "',newbosid('456B840C'),1);";
                    sqlList.add(insertSQL);
                    errorSet.add(adminID);
                }
            }
            if (++checkCount < executeQuery.size() / 5) continue;
            SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 3, 0);
            checkCount = 0;
        }
        percent = 40;
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent, 0);
        checkCount = 0;
        sql = "SELECT adminHis.FID AS hisID,adminOrg.FNAME_L2 AS adminName,adminOrg.FNUMBER AS adminNumber,adminOrg.FID AS adminOrgUnitID,adminHis.FEFFDT AS effdt,adminHis.FLEFFDT AS leffdt FROM T_ORG_ADMIN adminOrg LEFT JOIN T_ORG_AdminOrgTreeHis adminHis ON adminOrg.FID = adminHis.FAdminOrgID ORDER BY adminOrg.FID,adminHis.FEFFDT";
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (executeQuery.next()) {
            id = executeQuery.getString("hisID");
            adminNumber = executeQuery.getString("adminNumber");
            adminName = executeQuery.getString("adminName");
            adminOrgUnitID = executeQuery.getString("adminOrgUnitID");
            repairGuide = "1\u3001\u67e5\u8be2\u7ec4\u7ec7\u5386\u53f2\u4fe1\u606f_\u7ec4\u7ec7\u6811\u6570\u636e\uff1aSELECT FID,FDISPLAYNAME_L2,FLONGNUMBER,FEFFDT,FLEFFDT FROM T_ORG_AdminOrgTreeHis WHERE FADMINORGID = /" + adminOrgUnitID + "/ 2\u3001\u5982\u679c\u4fee\u590d\u524d\u6ca1\u6709\u5907\u4efd\u8fc7\uff0c\u8bf7\u5907\u4efdT_ORG_AdminOrgTreeHis\u6570\u636e\uff1aSELECT * INTO T_ORG_AdminOrgTreeHis_BF FROM T_ORG_AdminOrgTreeHis 3\u3001\u901a\u8fc7FID\uff0c\u66f4\u65b0\u5386\u53f2\u6570\u636e\u65e5\u671f \uff081\uff09\u66f4\u65b0\u751f\u6548\u65e5\u671f\uff1aUPDATE T_ORG_AdminOrgTreeHis SET FEFFDT = /TS{xxxx-xx-xx}/ WHERE FID = /xxx/ \uff082\uff09\u66f4\u65b0\u5931\u6548\u65e5\u671f\uff1aUPDATE T_ORG_AdminOrgTreeHis SET FLEFFDT = /TS{xxxx-xx-xx}/ WHERE FID = /xxx/";
            if (executeQuery.getDate("leffdt") != null) {
                effdtString = formatter.format(executeQuery.getDate("leffdt"));
                checkQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT * FROM T_ORG_AdminOrgTreeHis WHERE FID <> '" + id + "' AND FAdminOrgID = '" + adminOrgUnitID + "' AND FEFFDT <= {TS'" + effdtString + "'} AND FLEFFDT >= {TS'" + effdtString + "'}"));
                if (checkQuery.size() > 0) {
                    insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + adminNumber + "', null,N'" + adminName + "', null, N'\u7ec4\u7ec7', null,N'\u7ec4\u7ec7\u5386\u53f2\u4fe1\u606f_\u7ec4\u7ec7\u6811T_ORG_AdminOrgTreeHis\uff0c\u65f6\u95f4\u4ea4\u53c9','" + repairGuide + "',newbosid('456B840C'),1);";
                    sqlList.add(insertSQL);
                    errorSet.add(adminID);
                }
            }
            if (++checkCount < executeQuery.size() / 5) continue;
            SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 3, 0);
            checkCount = 0;
        }
        percent = 55;
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent, 0);
        checkCount = 0;
        sql = "SELECT positionHIS.FID AS hisID,position.FNumber AS positionNumber,position.FName_l2 AS positionName,position.FID AS positionID,positionHIS.FLEFFDT AS leffdt FROM T_ORG_POSITION position LEFT JOIN T_ORG_POSITIONHIS positionHIS ON position.FID = positionHIS.FHistoryRelateID ORDER BY position.FID,positionHIS.FEFFDT";
        executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (executeQuery.next()) {
            id = executeQuery.getString("hisID");
            positionNumber = executeQuery.getString("positionNumber");
            positionName = executeQuery.getString("positionName");
            positionID = executeQuery.getString("positionID");
            repairGuide = "1\u3001\u67e5\u8be2\u804c\u4f4d\u5386\u53f2\u6570\u636e\uff1aSELECT FID,FNAME_L2,FNUMBER,FEFFDT,FLEFFDT FROM T_ORG_POSITIONHIS  WHERE FHISTORYRELATEID = /" + positionID + "/  2\u3001\u5982\u679c\u4fee\u590d\u524d\u6ca1\u6709\u5907\u4efd\u8fc7\uff0c\u8bf7\u5907\u4efdT_ORG_POSITIONHIS\u6570\u636e\uff1aSELECT * INTO T_ORG_POSITIONHIS_BF FROM T_ORG_POSITIONHIS 3\u3001\u901a\u8fc7FID\uff0c\u66f4\u65b0\u5386\u53f2\u6570\u636e\u65e5\u671f \uff081\uff09\u66f4\u65b0\u751f\u6548\u65e5\u671f\uff1aUPDATE T_ORG_POSITIONHIS SET FEFFDT = /TS{xxxx-xx-xx}/ WHERE FID = /xxx/ \uff082\uff09\u66f4\u65b0\u5931\u6548\u65e5\u671f\uff1aUPDATE T_ORG_POSITIONHIS SET FLEFFDT = /TS{xxxx-xx-xx}/ WHERE FID = /xxx/";
            if (executeQuery.getDate("leffdt") != null) {
                effdtString = formatter.format(executeQuery.getDate("leffdt"));
                checkQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT * FROM T_ORG_POSITIONHIS WHERE FID <> '" + id + "' AND FHistoryRelateID = '" + positionID + "' AND FEFFDT <= {TS'" + effdtString + "'} AND FLEFFDT >= {TS'" + effdtString + "'}"));
                if (checkQuery.size() > 0) {
                    insertSQL = "insert into T_HR_DataCheckRecord(FType, FIndex, FNumber, FName_l1, FName_l2, FName_l3, FCheckItem, FCheckItemDescription, FCheckResult, FRepairGuide, FID, FIsMustRepair) values  (N'ADMINCHECK', null, N'" + positionNumber + "', null,N'" + positionName + "', null, N'\u804c\u4f4d', null,N'\u804c\u4f4d\u5386\u53f2\u8868T_ORG_POSITIONHIS\uff0c\u65f6\u95f4\u4ea4\u53c9','" + repairGuide + "',newbosid('456B840C'),1);";
                    sqlList.add(insertSQL);
                    errorSet.add(adminID);
                }
            }
            if (++checkCount < executeQuery.size() / 5) continue;
            SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent += 3, 0);
            checkCount = 0;
        }
        percent = 70;
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", percent, 0);
        SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, 50);
        int passCenter = 100;
        passCenter = errorSet.size() * 100 / (adminCount + positionCount) == 0 && errorSet.size() > 0 ? 99 : 100 - errorSet.size() * 100 / (adminCount + positionCount);
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ADMINCHECK", 100, passCenter);
    }

    public Date getNextDay(Date effdt) {
        Date resultDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(effdt);
        c.add(5, 1);
        resultDate = c.getTime();
        return resultDate;
    }

    public static String exportMoveFinishedReportAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            LinkedHashMap<String, Object[]> adminItemMap = new LinkedHashMap<String, Object[]>();
            adminItemMap.put("\u884c\u653f\u7ec4\u7ec7\u7f16\u7801", new Object[]{"adminNumber"});
            adminItemMap.put("\u884c\u653f\u7ec4\u7ec7", new Object[]{"adminName"});
            adminItemMap.put("\u95ee\u9898\u63cf\u8ff0", new Object[]{"FCheckItemDescription"});
            adminItemMap.put("\u89e3\u51b3\u65b9\u6cd5", new Object[]{"FRepairGuide"});
            adminItemMap.put("\u751f\u6548\u65e5\u671f", new Object[]{"effectDate"});
            adminItemMap.put("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u6700\u65e9\u751f\u6548\u65e5\u671f", new Object[]{"parentEffectDate"});
            LinkedHashMap<String, Object[]> positionItemMap = new LinkedHashMap<String, Object[]>();
            positionItemMap.put("\u804c\u4f4d\u7f16\u7801", new Object[]{"adminNumber"});
            positionItemMap.put("\u804c\u4f4d", new Object[]{"adminName"});
            positionItemMap.put("\u95ee\u9898\u63cf\u8ff0", new Object[]{"FCheckItemDescription"});
            positionItemMap.put("\u89e3\u51b3\u65b9\u6cd5", new Object[]{"FRepairGuide"});
            positionItemMap.put("\u751f\u6548\u65e5\u671f", new Object[]{"effectDate"});
            positionItemMap.put("\u4e0a\u7ea7\u804c\u4f4d\u6700\u65e9\u751f\u6548\u65e5\u671f", new Object[]{"parentEffectDate"});
            positionItemMap.put("\u884c\u653f\u7ec4\u7ec7\u6700\u65e9\u751f\u6548\u65e5\u671f", new Object[]{"adminEffectDate"});
            XSSFWorkbook wb = new XSSFWorkbook();
            Map<String, CellStyle> styles = StyleUtil.createStyles((Workbook)wb);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setColor(IndexedColors.DARK_RED.getIndex());
            font.setFontHeightInPoints((short)12);
            cellStyle.setWrapText(true);
            cellStyle.setFont((Font)font);
            XSSFSheet sheet = wb.createSheet("\u884c\u653f\u7ec4\u7ec7\u6821\u9a8c\u62a5\u544a");
            XSSFRow row = null;
            Cell cell = null;
            row = sheet.createRow(0);
            row.setHeight((short)400);
            int itemCount = 0;
            for (String itemName : adminItemMap.keySet()) {
                cell = row.createCell(itemCount++);
                cell.setCellValue(itemName);
                cell.setCellStyle(styles.get("mustInputHead"));
            }
            for (int i = 0; i < itemCount; ++i) {
                if (i == 0 || i == 1) {
                    sheet.setColumnWidth(i, 4000);
                    continue;
                }
                if (i == 2 || i == 3) {
                    sheet.setColumnWidth(i, 12000);
                    continue;
                }
                sheet.setColumnWidth(i, 4000);
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            int count = 0;
            String sql = "SELECT adminOrg.FID AS ID,checkRecord.FType,checkRecord.FNumber AS FNumber,checkRecord.FName_l2 AS FName_l2,checkRecord.FCheckResult AS FCheckResult,checkRecord.FRepairGuide AS FRepairGuide,adminOrg.FEFFDT AS FEFFDT FROM T_HR_DataCheckRecord checkRecord LEFT JOIN T_ORG_ADMIN adminOrg ON checkRecord.FNumber = adminOrg.FNumber WHERE checkRecord.FType = 'ADMINCHECK' AND checkRecord.FCheckItem = '\u7ec4\u7ec7' ORDER BY adminOrg.FLongNumber ASC";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            String id = "";
            String number = "";
            String name = "";
            String checkResult = "";
            String repairGuide = "";
            Date effdt = new Date();
            while (executeQuery.next()) {
                id = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("ID"));
                number = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FNumber"));
                name = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FName_l2"));
                checkResult = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FCheckResult"));
                repairGuide = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FRepairGuide"));
                effdt = executeQuery.getDate("FEFFDT");
                row = sheet.createRow(1 + count);
                cell = row.createCell(0);
                cell.setCellValue(number);
                cell = row.createCell(1);
                cell.setCellValue(name);
                cell = row.createCell(2);
                cell.setCellValue(checkResult);
                cell = row.createCell(3);
                cell.setCellValue(repairGuide.replaceAll("/", "'"));
                cell = row.createCell(4);
                cell.setCellValue(formatter.format(effdt));
                IRowSet effectExecuteQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT MIN(FEFFDT) AS FEFFDT FROM T_ORG_ADMINHIS WHERE FHistoryRelateID = '" + id + "'"));
                while (effectExecuteQuery.next()) {
                    if (effectExecuteQuery.getDate("FEFFDT") == null) continue;
                    cell = row.createCell(5);
                    cell.setCellValue(formatter.format(effectExecuteQuery.getDate("FEFFDT")));
                }
                ++count;
            }
            sheet = wb.createSheet("\u804c\u4f4d\u6821\u9a8c\u62a5\u544a");
            row = null;
            cell = null;
            row = sheet.createRow(0);
            row.setHeight((short)400);
            itemCount = 0;
            for (String itemName : positionItemMap.keySet()) {
                cell = row.createCell(itemCount++);
                cell.setCellValue(itemName);
                cell.setCellStyle(styles.get("mustInputHead"));
            }
            for (int i = 0; i < itemCount; ++i) {
                if (i == 0 || i == 1) {
                    sheet.setColumnWidth(i, 4000);
                    continue;
                }
                if (i == 2 || i == 3) {
                    sheet.setColumnWidth(i, 12000);
                    continue;
                }
                sheet.setColumnWidth(i, 4000);
            }
            count = 0;
            sql = "SELECT position.FID AS ID,checkRecord.FType,checkRecord.FNumber AS FNumber,checkRecord.FName_l2 AS FName_l2,checkRecord.FCheckResult AS FCheckResult,checkRecord.FRepairGuide AS FRepairGuide,position.FEFFDT AS FEFFDT ,adminOrg.FID AS adminOrgID FROM T_HR_DataCheckRecord checkRecord LEFT JOIN T_ORG_POSITION position ON checkRecord.FNumber = position.FNumber LEFT JOIN T_ORG_ADMIN adminOrg ON position.FAdminOrgUnitID = adminOrg.FID WHERE checkRecord.FType = 'ADMINCHECK' AND checkRecord.FCheckItem = '\u804c\u4f4d' ORDER BY adminOrg.FLongNumber ASC";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            String adminOrgID = "";
            while (executeQuery.next()) {
                id = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("ID"));
                number = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FNumber"));
                name = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FName_l2"));
                checkResult = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FCheckResult"));
                repairGuide = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("FRepairGuide"));
                adminOrgID = ControlAdminDataMoveHandler.getExeValue(executeQuery.getString("adminOrgID"));
                effdt = executeQuery.getDate("FEFFDT");
                row = sheet.createRow(1 + count);
                cell = row.createCell(0);
                cell.setCellValue(number);
                cell = row.createCell(1);
                cell.setCellValue(name);
                cell = row.createCell(2);
                cell.setCellValue(checkResult);
                cell = row.createCell(3);
                cell.setCellValue(repairGuide.replaceAll("/", "'"));
                cell = row.createCell(4);
                cell.setCellValue(formatter.format(effdt));
                IRowSet effectExecuteQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT MIN(FEFFDT) AS FEFFDT FROM T_ORG_POSITIONHIS WHERE FHistoryRelateID = '" + id + "'"));
                while (effectExecuteQuery.next()) {
                    if (executeQuery.getDate("FEFFDT") == null) continue;
                    cell = row.createCell(5);
                    cell.setCellValue(formatter.format(executeQuery.getDate("FEFFDT")));
                }
                effectExecuteQuery = DbUtil.executeQuery((Context)ctx, (String)("SELECT MIN(FEFFDT) AS FEFFDT FROM T_ORG_ADMINHIS WHERE FHistoryRelateID = '" + adminOrgID + "'"));
                while (effectExecuteQuery.next()) {
                    if (effectExecuteQuery.getDate("FEFFDT") == null) continue;
                    cell = row.createCell(6);
                    cell.setCellValue(formatter.format(effectExecuteQuery.getDate("FEFFDT")));
                }
                ++count;
            }
            String path = TEMP_DIR + UUID.randomUUID().toString() + ".xlsx";
            FileOutputStream out = new FileOutputStream(path);
            wb.write((OutputStream)out);
            out.close();
            ExcelUtil.setExportExcelHead(response, path, "\u6821\u9a8c\u62a5\u544a");
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }
}

