/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogCollection;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogFactory;
import com.kingdee.eas.hr.base.HRAffairActionTransactionLogInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.mvdt.DataCheckRecordFactory;
import com.kingdee.eas.hr.mvdt.DataCheckRecordInfo;
import com.kingdee.eas.hr.mvdt.IDataCheckRecord;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.hr.mvdt.handler.ExcelUtil;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCContractBizBillMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCContractMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCEmpLaborRelationMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCEmpPermissionUpdateHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCEmpPosOrgRelationMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCEmpPostExperienceHisMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCEmpPostRankMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCHrBizBillMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCInitHRUnitIDMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCPersonMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCPersonPositionExtendMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCPersonPositionMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.GCPreEntryMoveHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.UpdateStartEndDateTimeHandler;
import com.kingdee.shr.hr.mvdt.handler.emp.entity.EmpLaborRelationHisEntity;
import com.kingdee.shr.hr.mvdt.handler.emp.entity.EmpPosOrgRelationEntity;
import com.kingdee.shr.hr.mvdt.handler.emp.entity.EmpPostRankEntity;
import com.kingdee.shr.hr.mvdt.handler.emp.util.TableDataUtil;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class ControlPersonDataMoveHandler
implements ISHRControlMoveDataHandler {
    public static final String Type = "PERSONCHECK";
    public static final String EmpOrgRelation = "\u68c0\u67e5\u62a5\u544a";
    public static final int Oracle = 2;
    public static final int MS_SQL_Server = 3;
    public static final int Oracle9 = 7;
    public static final int Oracle10 = 8;

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        if (SHRControlMoveDataHelpUtil.checkMovaDataIsFinished(ctx)) {
            return null;
        }
        ArrayList<ISHRControlMoveDataHandler> handlers = new ArrayList<ISHRControlMoveDataHandler>();
        GCPersonMoveHandler handler1 = new GCPersonMoveHandler();
        handlers.add(handler1);
        GCEmpPosOrgRelationMoveHandler handler2 = new GCEmpPosOrgRelationMoveHandler();
        handlers.add(handler2);
        GCEmpPostExperienceHisMoveHandler handler3 = new GCEmpPostExperienceHisMoveHandler();
        handlers.add(handler3);
        GCEmpPostRankMoveHandler handler4 = new GCEmpPostRankMoveHandler();
        handlers.add(handler4);
        GCEmpLaborRelationMoveHandler handler5 = new GCEmpLaborRelationMoveHandler();
        handlers.add(handler5);
        GCPersonPositionExtendMoveHandler ppExtendHandler = new GCPersonPositionExtendMoveHandler();
        handlers.add(ppExtendHandler);
        GCPersonPositionMoveHandler handler6 = new GCPersonPositionMoveHandler();
        handlers.add(handler6);
        GCContractBizBillMoveHandler handler7 = new GCContractBizBillMoveHandler();
        handlers.add(handler7);
        GCContractMoveHandler handler8 = new GCContractMoveHandler();
        handlers.add(handler8);
        GCHrBizBillMoveHandler handler9 = new GCHrBizBillMoveHandler();
        handlers.add(handler9);
        GCInitHRUnitIDMoveHandler handler10 = new GCInitHRUnitIDMoveHandler();
        handlers.add(handler10);
        GCEmpPermissionUpdateHandler handler11 = new GCEmpPermissionUpdateHandler();
        handlers.add(handler11);
        UpdateStartEndDateTimeHandler hander12 = new UpdateStartEndDateTimeHandler();
        handlers.add(hander12);
        GCPreEntryMoveHandler handler13 = new GCPreEntryMoveHandler();
        handlers.add(handler13);
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            ISHRControlMoveDataHandler handler = (ISHRControlMoveDataHandler)handlers.get(i);
            if (SHRControlMoveDataHelpUtil.checkMoveClassifyIfFinished(ctx, handler.getClass().getName())) continue;
            try {
                handler.moveData(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, handler.getClass().getName(), "failed");
                SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, handler.getClass().getName(), e.getMessage());
                throw new BOSException((Throwable)e);
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, handler.getClass().getName(), "finished");
        }
        return null;
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        int i;
        int rowCount;
        String resultError = "";
        TableDataUtil.prepare(ctx);
        int maxCellCount = JdbcRowSet.UPPER_CELLNUMBER_FOR_EXCEPTION;
        String checkSQL = EmpLaborRelationHisEntity.getCountSql();
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkSQL);
        if (checkRs.next()) {
            rowCount = checkRs.getInt(1);
            if (rowCount * 16 >= maxCellCount && rowCount * 16 <= 5000000) {
                resultError = "\u7528\u5de5\u5173\u7cfb\u6570\u636e\u96c6\u5927\uff0c\u8bf7\u628a\u7ba1\u7406\u63a7\u5236\u53f0\u53c2\u6570exceptionCellNumber\u4fee\u6539\u4e3a5000000,\u4fee\u6539\u540e\u91cd\u542f\u7ba1\u7406\u63a7\u5236\u53f0\u5e76\u4e14\u91cd\u542f\u670d\u52a1\u5668\uff0c\u5347\u7ea7\u540e\u518d\u6062\u590d\u4e3a1000000";
                return resultError;
            }
            if (rowCount * 16 >= 10000000) {
                resultError = "\u7528\u5de5\u5173\u7cfb\u6570\u636e\u96c6\u5927\uff0c\u8bf7\u628a\u7ba1\u7406\u63a7\u5236\u53f0\u53c2\u6570exceptionCellNumber\u4fee\u6539\u4e3a10000000,\u4fee\u6539\u540e\u91cd\u542f\u7ba1\u7406\u63a7\u5236\u53f0\u5e76\u4e14\u91cd\u542f\u670d\u52a1\u5668\uff0c\u5347\u7ea7\u540e\u518d\u6062\u590d\u4e3a1000000";
                return resultError;
            }
        }
        if ((checkRs = DbUtil.executeQuery((Context)ctx, (String)(checkSQL = EmpPosOrgRelationEntity.getCountSql()))).next()) {
            rowCount = checkRs.getInt(1);
            if (rowCount * 18 >= maxCellCount && rowCount * 18 <= 5000000) {
                resultError = "\u53d8\u52a8\u8bb0\u5f55\u6570\u636e\u96c6\u5927\uff0c\u8bf7\u628a\u7ba1\u7406\u63a7\u5236\u53f0\u53c2\u6570exceptionCellNumber\u4fee\u6539\u4e3a5000000,\u4fee\u6539\u540e\u91cd\u542f\u7ba1\u7406\u63a7\u5236\u53f0\u5e76\u4e14\u91cd\u542f\u670d\u52a1\u5668\uff0c\u5347\u7ea7\u540e\u518d\u6062\u590d\u4e3a1000000";
                return resultError;
            }
            if (rowCount * 18 >= 10000000) {
                resultError = "\u53d8\u52a8\u8bb0\u5f55\u6570\u636e\u96c6\u5927\uff0c\u8bf7\u628a\u7ba1\u7406\u63a7\u5236\u53f0\u53c2\u6570exceptionCellNumber\u4fee\u6539\u4e3a10000000,\u4fee\u6539\u540e\u91cd\u542f\u7ba1\u7406\u63a7\u5236\u53f0\u5e76\u4e14\u91cd\u542f\u670d\u52a1\u5668\uff0c\u5347\u7ea7\u540e\u518d\u6062\u590d\u4e3a1000000";
                return resultError;
            }
        }
        if ((checkRs = DbUtil.executeQuery((Context)ctx, (String)(checkSQL = EmpPostRankEntity.getCountSql()))).next()) {
            rowCount = checkRs.getInt(1);
            if (rowCount * 18 >= maxCellCount && rowCount * 18 <= 5000000) {
                resultError = "\u5458\u5de5\u804c\u7b49\u6570\u636e\u96c6\u5927\uff0c\u8bf7\u628a\u7ba1\u7406\u63a7\u5236\u53f0\u53c2\u6570exceptionCellNumber\u4fee\u6539\u4e3a5000000,\u4fee\u6539\u540e\u91cd\u542f\u7ba1\u7406\u63a7\u5236\u53f0\u5e76\u4e14\u91cd\u542f\u670d\u52a1\u5668\uff0c\u5347\u7ea7\u540e\u518d\u6062\u590d\u4e3a1000000";
                return resultError;
            }
            if (rowCount * 18 >= 10000000) {
                resultError = "\u5458\u5de5\u804c\u7b49\u6570\u636e\u96c6\u5927\uff0c\u8bf7\u628a\u7ba1\u7406\u63a7\u5236\u53f0\u53c2\u6570exceptionCellNumber\u4fee\u6539\u4e3a10000000,\u4fee\u6539\u540e\u91cd\u542f\u7ba1\u7406\u63a7\u5236\u53f0\u5e76\u4e14\u91cd\u542f\u670d\u52a1\u5668\uff0c\u5347\u7ea7\u540e\u518d\u6062\u590d\u4e3a1000000";
                return resultError;
            }
        }
        String sql = "select a.FJoinGroupDate,min(a.feffdt)poseffdt,a.fpersonid,a.FNumber,a.fname_l2 from (select pp.fjoingroupdate,relation.feffdt,pp.fpersonid ,person.fnumber,person.fname_l2 from t_hr_personposition pp inner joint_hr_emporgrelation relation on pp.fpersonid = relation.fpersonidand relation.fisinner =1 left join t_bd_person person on person.fid = pp.fpersonid ) as a group by a.fpersonid ,a.fjoingroupdate,a.fnumber,a.fname_l2 having min(a.feffdt)<a.FJoinGroupDate";
        sql = "select count(*) from t_org_admin where fcompanyId is null or fcompanyId = ''";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next() && (i = rs.getInt(1)) > 0) {
            resultError = "\u8bf7\u68c0\u67e5\u884c\u653f\u7ec4\u7ec7\u662f\u5426\u6709\u6240\u5c5e\u516c\u53f8\u4e3a\u7a7a\u7684\u8bb0\u5f55\uff0c\u4f7f\u7528 select * from t_org_admin where fcompanyId is null or fcompanyId = ''\u8bed\u53e5\u8fdb\u884c\u67e5\u8be2\u6709\u54ea\u4e9b\u884c\u653f\u7ec4\u7ec7\u6ca1\u6709\u6240\u5c5e\u516c\u53f8,\u4f7f\u7528\u5bfc\u5165\u8fdb\u884c\u4fee\u590d\u6216\u8005\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458";
            return resultError;
        }
        sql = "select fpersonid,count(fpersonid) from  t_hr_emporgrelation  where FISINNER =1 and FLEFFDT={ts '2199-12-31'} and FASSIGNTYPE=1 group by fpersonid having count(FPERSONID)>1";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next() && (i = rs.getInt(2)) > 1) {
            resultError = "\u8bf7\u68c0\u67e5\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u4e3b\u4efb\u804c\u662f\u5426\u6709\u591a\u67612199\u7684\u8bb0\u5f55\uff0c\u4f7f\u7528 select fpersonid,count(fpersonid) from  t_hr_emporgrelation  where FISINNER =1 and FLEFFDT={ts '2199-12-31'} and FASSIGNTYPE=1 group by fpersonid having count(FPERSONID)>1\u8bed\u53e5\u8fdb\u884c\u67e5\u8be2\u548c\u4fee\u590d\u6216\u8005\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458";
            return resultError;
        }
        sql = "select femployeeContractId,count(Fid) from T_HR_HRContractInfo where FENTRYID is not null and FBILLSTATE = 3 and FBILLBOSTYPE in ('502B7D81','2A2632A9','056FBF2E') group by femployeeContractId having count(Fid)>1";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next() && (i = rs.getInt(2)) > 1) {
            resultError = "\u8bf7\u68c0\u67e5\u5408\u540c\u4e2d\u95f4\u8868\u662f\u5426\u6709\u591a\u6761\u5bf9\u5e94\u4e00\u6761\u5408\u540c\u8bb0\u5f55\u8868\u6570\u636e\u7684\u8bb0\u5f55\uff0c\u4f7f\u7528 select femployeeContractId,count(Fid) from T_HR_HRContractInfo where FENTRYID is not null and FBILLSTATE = 3 and FBILLBOSTYPE in ('502B7D81','2A2632A9','056FBF2E') group by femployeeContractId having count(Fid)>1\u8bed\u53e5\u8fdb\u884c\u67e5\u8be2\u548c\u4fee\u590d\u6216\u8005\u8054\u7cfb\u6280\u672f\u652f\u6301\u4eba\u5458";
            return resultError;
        }
        return resultError;
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        this.deleteFailReport(ctx);
        Set<String> personIds = this.getPersonIds(ctx);
        float personSize = personIds.size();
        float personCount = 0.0f;
        int num = 0;
        int numCount = 100;
        for (String personId : personIds) {
            personCount += 1.0f;
            ++num;
            IRowSet rowSet = this.getQuerySQL(ctx, personId);
            ResultSetMetaData resultData = rowSet.getMetaData();
            List<Map<String, String>> list = this.rowSetConvertList(rowSet, resultData);
            this.validateEmpPosRelationPositionEffdt(ctx, personId);
            Boolean validateEmpPosRelationIsInner = this.validateEmpPosRelationIsInner(ctx, personId, list);
            if (validateEmpPosRelationIsInner.booleanValue()) {
                this.validateEmpPosRelationAdminIsNull(ctx, list);
                this.validateEmpPosRelationPositionIsNull(ctx, list);
                this.validateEmpPosRelationEmployeeTypeIsNull(ctx, list);
                this.validateEmpLaborRelationEnterDateIsNull(ctx, list);
                this.validateEmpPosRelationEffdtIsNull(ctx, list);
                this.validateEmpPosRelationAffairIsNull(ctx, list);
                this.validateEmpPosRelationAffairActionTransactionLogIsNull(ctx, list);
                this.validateEmpPosRelationMainAssignTypeIsNull(ctx, list);
                this.validateEmpPosRelationAffairActionReasonIsNull(ctx, list);
                this.validateEmpPosRelationLeffdtIsDuplicate(ctx, list);
            }
            if (num == numCount) {
                SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, Type, (int)(personCount / personSize * 100.0f), 0);
                num = 0;
                if ((numCount += 50) != 300) continue;
                numCount = 50;
                continue;
            }
            if (personCount != personSize) continue;
            String failSql = "select distinct fnumber from T_HR_DataCheckRecord where FType='PERSONCHECK' order by fnumber";
            IRowSet rowFailSet = DbUtil.executeQuery((Context)ctx, (String)failSql);
            float failCount = rowFailSet.size();
            SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, Type, (int)(personCount / personSize * 100.0f), (int)((personSize - failCount) / personSize * 100.0f));
        }
    }

    private Set<String> getPersonIds(Context ctx) throws BOSException, EASBizException, SQLException {
        String sql = "select fid,fnumber,fname_l2 from t_bd_person where fid in(select fpersonid from t_hr_emporgrelation)";
        HashSet<String> set = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            set.add(rs.getString(1));
        }
        return set;
    }

    private void validateEmpPosRelationPositionEffdt(Context ctx, String personId) throws BOSException, EASBizException, SQLException {
        String sql = "SELECT PERSON.FID as personId, PERSON.FNUMBER as personNumber, PERSON.FNAME_l2 as personName, EMPORGRELATION.FPOSITIONID as positionId, EMPORGRELATION.FEFFDT as empRelationEffdt, EMPORGRELATION.FLEFFDT as empRelationLeffdt, EMPORGRELATION.fid as empOrgRelaId FROM T_BD_PERSON  PERSON LEFT OUTER JOIN T_HR_EMPORGRELATION EMPORGRELATION on EMPORGRELATION.FPERSONID = PERSON.FID";
        if (!StringUtils.isEmpty((String)personId)) {
            sql = sql + " where EMPORGRELATION.FPersonID ='" + personId + "' ";
        }
        sql = sql + " order by EMPORGRELATION.FAssignType,EMPORGRELATION.FEFFDT";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Date empRelationEffdt = null;
        Date empRelationLeffdt = null;
        Date positionEffdt = null;
        while (rs.next()) {
            String positionid = rs.getString("positionId");
            empRelationEffdt = rs.getDate("empRelationEffdt");
            empRelationLeffdt = rs.getDate("empRelationLeffdt");
            sql = "SELECT min(FEFFDT) as positionEffdt FROM t_org_positionhis where FHISTORYRELATEID = '" + positionid + "'";
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs1.next()) {
                positionEffdt = rs1.getDate("positionEffdt");
            }
            if (empRelationLeffdt == null || positionEffdt == null || !empRelationLeffdt.after(positionEffdt) || !empRelationEffdt.before(positionEffdt)) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(rs.getString(2));
            dataCheckRecordInfo.setName(rs.getString(3));
            dataCheckRecordInfo.setCheckItem(rs.getString("empOrgRelaId"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u8be5\u5458\u5de5\u7684\u53d8\u52a8\u8bb0\u5f55\u751f\u6548\u65f6\u95f4\uff1a" + empRelationEffdt + "\u8981\u665a\u4e8e\u804c\u4f4d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f:" + positionEffdt);
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private Boolean validateEmpPosRelationIsInner(Context ctx, String personId, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        if (list.size() == 0) {
            String sql = "select fid,fnumber,fname_l2 from t_bd_person where fid='" + personId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
                dataCheckRecordInfo.setType(Type);
                dataCheckRecordInfo.setNumber(rs.getString(2));
                dataCheckRecordInfo.setName(rs.getString(3));
                dataCheckRecordInfo.setCheckItem(null);
                dataCheckRecordInfo.setCheckItemDescription(null);
                dataCheckRecordInfo.setCheckResult("\u8be5\u5458\u5de5\u53d8\u52a8\u4ea7\u751fisinner=1\u7684\u4e00\u4e2a\u4efb\u804c\u90fd\u6ca1\u6709");
                dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord2.addnew(dataCheckRecordInfo);
            }
            return false;
        }
        return true;
    }

    private void validateEmpPosRelationAdminIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FADMINORGUNITDISPLAYNAME"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u7ec4\u7ec7\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationPositionIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FPOSITIONNAME"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u804c\u4f4d\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationEmployeeTypeIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FEMPLOYEETYPEID"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpLaborRelationEnterDateIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FENTERDATE"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u5458\u5de5\u7684\u5165\u804c\u65e5\u671f\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationEffdtIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FEFFDT"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u5458\u5de5\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validatePersonOtherInfoJobStartDateIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FJOBSTARTDATE"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u8be5\u5458\u5de5\u7684\u53c2\u52a0\u5de5\u4f5c\u65e5\u671f\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationAffairIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FLOWOUTAFFAIRID")) || !StringUtils.isEmpty((String)map.get("FFLOWINAFFAIRID"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u8be5\u5458\u5de5\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u6ca1\u6709\u5bf9\u5e94\u7684\u5355\u636e");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationAffairActionTransactionLogIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            IDataCheckRecord DataCheckRecord2;
            DataCheckRecordInfo dataCheckRecordInfo;
            if (StringUtils.isEmpty((String)map.get("FFLOWINAFFAIRID"))) continue;
            String flowInAffairId = map.get("FFLOWINAFFAIRID");
            String oql = " where affairEntryID ='" + flowInAffairId + "'";
            HRAffairActionTransactionLogCollection logCollection = HRAffairActionTransactionLogFactory.getLocalInstance((Context)ctx).getHRAffairActionTransactionLogCollection(oql);
            if (logCollection.size() == 0) {
                DataCheckRecordInfo dataCheckRecordInfo2 = new DataCheckRecordInfo();
                dataCheckRecordInfo2.setType(Type);
                dataCheckRecordInfo2.setNumber(map.get("FPERSONNUMBER"));
                dataCheckRecordInfo2.setName(map.get("FPERSONNAME"));
                dataCheckRecordInfo2.setCheckItem(map.get("FEMPORGRELAID"));
                dataCheckRecordInfo2.setCheckItemDescription(null);
                dataCheckRecordInfo2.setCheckResult("\u4e0d\u662f\u901a\u8fc7\u7cfb\u7edf\u5355\u636e\u6216\u8005\u7cfb\u7edf\u53d8\u52a8\u4ea7\u751f\u7684\u53d8\u52a8\u8bb0\u5f55");
                dataCheckRecordInfo2.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                IDataCheckRecord DataCheckRecord3 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord3.addnew(dataCheckRecordInfo2);
                continue;
            }
            HRAffairActionTransactionLogInfo logInfo = logCollection.get(0);
            PositionInfo logPositionInfo = logInfo.getTargetPosition();
            EmployeeTypeInfo logEmployeeTypeInfo = logInfo.getTargetEmployeeType();
            java.util.Date logEffectDate = logInfo.getEffectDate();
            String positionId = map.get("FPOSITIONID");
            String employeeTypeId = map.get("FEMPLOYEETYPEID");
            String fEffdt = map.get("FEFFDT");
            java.util.Date parseFeffdtDate = null;
            if (!StringUtils.isEmpty((String)fEffdt)) {
                try {
                    parseFeffdtDate = DateTimeUtils.parseDate((String)fEffdt);
                }
                catch (ParseException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            if (logPositionInfo == null) {
                dataCheckRecordInfo = new DataCheckRecordInfo();
                dataCheckRecordInfo.setType(Type);
                dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
                dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
                dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
                dataCheckRecordInfo.setCheckItemDescription(null);
                dataCheckRecordInfo.setCheckResult("\u53d8\u52a8\u65e5\u5fd7\u8868\u7684\u804c\u4f4dId\u4e3a\u7a7a");
                dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord2.addnew(dataCheckRecordInfo);
            } else if (logPositionInfo.getId() != null && !StringUtils.equals((String)logPositionInfo.getId().toString(), (String)positionId)) {
                dataCheckRecordInfo = new DataCheckRecordInfo();
                dataCheckRecordInfo.setType(Type);
                dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
                dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
                dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
                dataCheckRecordInfo.setCheckItemDescription(null);
                dataCheckRecordInfo.setCheckResult("\u4efb\u804c\u804c\u4f4d\u8fdb\u884c\u8fc7\u4eba\u4e3a\u4fee\u6539\uff0c\u4e0e\u5355\u636e\u4e0d\u4e00\u81f4");
                dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord2.addnew(dataCheckRecordInfo);
            }
            if (logEmployeeTypeInfo == null) {
                dataCheckRecordInfo = new DataCheckRecordInfo();
                dataCheckRecordInfo.setType(Type);
                dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
                dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
                dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
                dataCheckRecordInfo.setCheckItemDescription(null);
                dataCheckRecordInfo.setCheckResult("\u53d8\u52a8\u65e5\u5fd7\u8868\u7684\u7528\u5de5\u72b6\u6001Id\u4e3a\u7a7a");
                dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord2.addnew(dataCheckRecordInfo);
            } else if (logEmployeeTypeInfo.getId() != null && !StringUtils.isEmpty((String)employeeTypeId) && !StringUtils.equals((String)logEmployeeTypeInfo.getId().toString(), (String)employeeTypeId)) {
                dataCheckRecordInfo = new DataCheckRecordInfo();
                dataCheckRecordInfo.setType(Type);
                dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
                dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
                dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
                dataCheckRecordInfo.setCheckItemDescription(null);
                dataCheckRecordInfo.setCheckResult("\u7528\u5de5\u72b6\u6001\u7ecf\u8fc7\u4eba\u4e3a\u4fee\u6539\uff0c\u4e0e\u5355\u636e\u4e0d\u4e00\u81f4");
                dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord2.addnew(dataCheckRecordInfo);
            }
            if (parseFeffdtDate == null || logEffectDate == null || HRUtilExtend.getDateStringWithMinute((java.util.Date)logEffectDate).equals(HRUtilExtend.getDateStringWithMinute((java.util.Date)parseFeffdtDate))) continue;
            dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u751f\u6548\u65e5\u671f\u6709\u8fc7\u4eba\u4e3a\u4fee\u6539\uff0c\u4e0e\u5355\u636e\u4e0d\u4e00\u81f4");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationMainAssignTypeIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        ArrayList<Map<String, String>> mainList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> partTimeList = new ArrayList<Map<String, String>>();
        Iterator<Map<String, String>> iterator = list.iterator();
        String number = "";
        String name = "";
        while (iterator.hasNext()) {
            Map<String, String> map = iterator.next();
            number = map.get("FPERSONNUMBER");
            name = map.get("FPERSONNAME");
            if (map.get("FASSIGNTYPE").equals("1")) {
                mainList.add(map);
                continue;
            }
            partTimeList.add(map);
        }
        if (mainList.size() == 0 && partTimeList.size() > 0) {
            int size = partTimeList.size();
            for (int i = 0; i < size; ++i) {
                DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
                dataCheckRecordInfo.setType(Type);
                dataCheckRecordInfo.setNumber(number);
                dataCheckRecordInfo.setName(name);
                dataCheckRecordInfo.setCheckItem(null);
                dataCheckRecordInfo.setCheckItemDescription(null);
                dataCheckRecordInfo.setCheckResult("\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u7531\u53d8\u52a8\u4ea7\u751fisinner=1\u7684\u4e00\u4e2a\u4e3b\u4efb\u804c\u90fd\u6ca1\u6709");
                dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
                DataCheckRecord2.addnew(dataCheckRecordInfo);
            }
        }
        try {
            if (mainList.size() > 1) {
                for (int i = 0; i < mainList.size(); ++i) {
                    Map preMap = (Map)mainList.get(i);
                    for (int j = i + 1; j < mainList.size(); ++j) {
                        java.util.Date nowEffdt;
                        java.util.Date parseOneFeffdtDate;
                        if (j != i + 1) continue;
                        Map oneMap = (Map)mainList.get(j);
                        if (((String)preMap.get("FEMPORGRELAID")).equals(oneMap.get("FEMPORGRELAID"))) continue;
                        String preFleffdt = (String)preMap.get("FLEFFDT");
                        String preFIsLatestInAday = (String)preMap.get("FISLATESTINADAY");
                        String oneFeffdt = (String)oneMap.get("FEFFDT");
                        java.util.Date parsePreFleffdt = DateTimeUtils.parseDate((String)preFleffdt);
                        if (parsePreFleffdt.after(parseOneFeffdtDate = DateTimeUtils.parseDate((String)oneFeffdt))) {
                            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
                            dataCheckRecordInfo.setType(Type);
                            dataCheckRecordInfo.setNumber(number);
                            dataCheckRecordInfo.setName(name);
                            dataCheckRecordInfo.setCheckItem((String)oneMap.get("FEMPORGRELAID"));
                            dataCheckRecordInfo.setCheckItemDescription(null);
                            dataCheckRecordInfo.setCheckResult("\u4e0e\u4e0a\u4e00\u7b14\u53d8\u52a8\u8bb0\u5f55\u65f6\u95f4\u5b58\u5728\u4ea4\u53c9");
                            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                            IDataCheckRecord DataCheckRecord3 = DataCheckRecordFactory.getLocalInstance(ctx);
                            DataCheckRecord3.addnew(dataCheckRecordInfo);
                        }
                        if ((nowEffdt = DateTimeUtils.addDay((java.util.Date)parsePreFleffdt, (long)1L)).equals(parseOneFeffdtDate) || !preFIsLatestInAday.equals("1")) continue;
                        DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
                        dataCheckRecordInfo.setType(Type);
                        dataCheckRecordInfo.setNumber(number);
                        dataCheckRecordInfo.setName(name);
                        dataCheckRecordInfo.setCheckItem((String)oneMap.get("FEMPORGRELAID"));
                        dataCheckRecordInfo.setCheckItemDescription(null);
                        dataCheckRecordInfo.setCheckResult("\u751f\u6548\u65f6\u95f4\u4e0e\u4e0a\u4e00\u7b14\u53d8\u52a8\u8bb0\u5f55\u7684\u5931\u6548\u65f6\u95f4\u6ca1\u6709\u8fde\u7eed");
                        dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
                        IDataCheckRecord DataCheckRecord4 = DataCheckRecordFactory.getLocalInstance(ctx);
                        DataCheckRecord4.addnew(dataCheckRecordInfo);
                    }
                }
            }
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void validateEmpPosRelationAffairActionReasonIsNull(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        for (Map<String, String> map : list) {
            if (!StringUtils.isEmpty((String)map.get("FAFFAIRACTIONREASONNAME"))) continue;
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(map.get("FPERSONNUMBER"));
            dataCheckRecordInfo.setName(map.get("FPERSONNAME"));
            dataCheckRecordInfo.setCheckItem(map.get("FEMPORGRELAID"));
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u7684\u53d8\u52a8\u7c7b\u578b\u4e3a\u7a7a");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void validateEmpPosRelationLeffdtIsDuplicate(Context ctx, List<Map<String, String>> list) throws BOSException, EASBizException, SQLException {
        Iterator<Map<String, String>> iterator = list.iterator();
        int leffdtCount = 0;
        String number = "";
        String name = "";
        while (iterator.hasNext()) {
            String date;
            Map<String, String> map = iterator.next();
            String assignType = map.get("FASSIGNTYPE");
            number = map.get("FPERSONNUMBER");
            name = map.get("FPERSONNAME");
            if (!"1".equals(assignType) || (date = map.get("FLEFFDT")) == null) continue;
            java.util.Date parseDate = null;
            try {
                parseDate = DateTimeUtils.parseDate((String)date);
            }
            catch (ParseException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            if (!DateTimeUtils.dayEquals((java.util.Date)HRUtil.getMaxEndDate(), (java.util.Date)parseDate)) continue;
            ++leffdtCount;
        }
        if (leffdtCount >= 2) {
            DataCheckRecordInfo dataCheckRecordInfo = new DataCheckRecordInfo();
            dataCheckRecordInfo.setType(Type);
            dataCheckRecordInfo.setNumber(number);
            dataCheckRecordInfo.setName(name);
            dataCheckRecordInfo.setCheckItem(null);
            dataCheckRecordInfo.setCheckItemDescription(null);
            dataCheckRecordInfo.setCheckResult("\u7cfb\u7edf\u5185\u53d8\u52a8\u8bb0\u5f55\u7684\u5931\u6548\u65e5\u671f\u6709\u591a\u67612199");
            dataCheckRecordInfo.setRepairGuide("\u8bf7\u63d0\u5355\u5904\u7406");
            IDataCheckRecord DataCheckRecord2 = DataCheckRecordFactory.getLocalInstance(ctx);
            DataCheckRecord2.addnew(dataCheckRecordInfo);
        }
    }

    private void deleteFailReport(Context ctx) throws BOSException {
        String sql = "delete from T_HR_DataCheckRecord where FType='PERSONCHECK'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static String downloadpersonDataReport(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException {
        try {
            ServletOutputStream out = null;
            Context ctx = SHRContext.getInstance().getContext();
            Map<String, String> personEmpOrgRelationMap = ControlPersonDataMoveHandler.getPersonEmpOrgRelationMap();
            byte[] bytes = ControlPersonDataMoveHandler.exportPersonEmpOrgRelationTemplate(ctx, personEmpOrgRelationMap);
            String fileName = "\u68c0\u67e5\u62a5\u544a.xlsx";
            WebUtil.setFileResponseHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName);
            out = response.getOutputStream();
            out.write(bytes, 0, bytes.length);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static Map<String, String> getPersonEmpOrgRelationMap() throws BOSException {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        itemMap.put("\u5458\u5de5Id", "fpersonId");
        itemMap.put("\u5458\u5de5\u7f16\u7801", "fpersonNumber");
        itemMap.put("\u59d3\u540d", "fpersonName");
        itemMap.put("\u804c\u4f4d", "fpositionName");
        itemMap.put("\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7", "fadminOrgUnitDisplayName");
        itemMap.put("\u6240\u5c5e\u516c\u53f8", "fcompanyDisplayname");
        itemMap.put("\u4efb\u804c\u7c7b\u578b", "fassignType");
        itemMap.put("\u7528\u5de5\u5173\u7cfb\u72b6\u6001", "fempTypeName");
        itemMap.put("\u5f00\u59cb\u65e5\u671f", "fEFFDT");
        itemMap.put("\u7ed3\u675f\u65e5\u671f", "fLEFFDT");
        itemMap.put("\u53d8\u52a8\u64cd\u4f5c", "factionName");
        itemMap.put("\u53d8\u52a8\u539f\u56e0", "factionVariationName");
        itemMap.put("\u53d8\u52a8\u7c7b\u578b", "faffairActionReasonName");
        itemMap.put("\u5165\u53f8\u65e5\u671f", "fjoinDate");
        itemMap.put("\u79bb\u53f8\u65e5\u671f", "fleftCompanyDate");
        itemMap.put("\u53f8\u9f84\u8c03\u6574", "fadjustCoValue");
        itemMap.put("\u53f8\u9f84", "fjoinCompanyYears");
        itemMap.put("\u79bb\u804c\u65e5\u671f", "fleftDate");
        itemMap.put("\u9996\u6b21\u52a0\u5165\u96c6\u56e2\u65e5\u671f", "fjoinGroupDate");
        itemMap.put("\u672c\u6b21\u52a0\u5165\u96c6\u56e2\u65e5\u671f", "fjoinGroupDateCur");
        itemMap.put("\u5165\u804c\u65e5\u671f", "fenterDate");
        itemMap.put("\u8fd4\u8058\u65e5\u671f", "freinviteDate");
        itemMap.put("\u9884\u8ba1\u8f6c\u6b63\u65e5\u671f", "fplanFormalDate");
        itemMap.put("\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f", "factualFormalDate");
        itemMap.put("\u8bd5\u7528\u671f", "ftryoutMonth");
        itemMap.put("\u53c2\u52a0\u5de5\u4f5c\u65e5\u671f", "fjobStartDate");
        itemMap.put("\u6821\u9a8c\u4fe1\u606f", "fcheckResult");
        itemMap.put("\u89e3\u51b3\u65b9\u6848", "frepairGuide");
        return itemMap;
    }

    private static byte[] exportPersonEmpOrgRelationTemplate(Context ctx, Map<String, String> personEmpOrgRelationMap) throws BOSException {
        XSSFWorkbook wb = new XSSFWorkbook();
        Map<String, CellStyle> styles = ExcelUtil.createStyles((Workbook)wb);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setColor(IndexedColors.DARK_RED.getIndex());
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont((Font)font);
        XSSFSheet empOrgRelationSheet = wb.createSheet(EmpOrgRelation);
        CellStyle textStyle = ControlPersonDataMoveHandler.textStyle((Workbook)wb);
        XSSFRow empOrgRelationRow = null;
        Cell empOrgRelationCell = null;
        empOrgRelationRow = empOrgRelationSheet.createRow(0);
        empOrgRelationRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : personEmpOrgRelationMap.keySet()) {
            empOrgRelationCell = empOrgRelationRow.createCell(itemCount++);
            empOrgRelationCell.setCellValue(itemName);
            empOrgRelationCell.setCellStyle(styles.get("mustInputHead"));
        }
        for (int i = 0; i < itemCount; ++i) {
            if (i == 26 || i == 27) {
                empOrgRelationSheet.setColumnWidth(i, 12000);
                continue;
            }
            empOrgRelationSheet.setColumnWidth(i, 4000);
            empOrgRelationSheet.setDefaultColumnStyle(i, textStyle);
        }
        String countSql = "select count(1) count from T_HR_DataCheckRecord where FType='PERSONCHECK'";
        int pageSize = 5000;
        int totalNum = 0;
        int export_times = 0;
        int type = 0;
        Connection conn = null;
        int count = 0;
        IRowSet executeQuery = null;
        try {
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)countSql);
            while (executeQuery.next()) {
                totalNum = executeQuery.getInt("count");
            }
            export_times = totalNum % pageSize > 0 ? totalNum / pageSize + 1 : totalNum / pageSize;
            conn = EJBFactory.getConnection((Context)ctx);
            type = KSqlUtil.getDbType((Connection)conn);
        }
        catch (Exception e) {
            try {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        if (type != 2 && type != 3 && type != 7 && type != 8) {
            export_times = 1;
        }
        try {
            for (int i = 1; i <= export_times; ++i) {
                String reportSQL = ControlPersonDataMoveHandler.getReportSQL(ctx, type, count, pageSize, i);
                executeQuery = DbUtil.executeQuery((Context)ctx, (String)reportSQL);
                while (executeQuery.next()) {
                    int j = 0;
                    empOrgRelationRow = empOrgRelationSheet.createRow(1 + count);
                    for (Map.Entry<String, String> entry : personEmpOrgRelationMap.entrySet()) {
                        if ("fEFFDT".equals(entry.getValue()) || "fLEFFDT".equals(entry.getValue()) || "fjoinDate".equals(entry.getValue()) || "fleftCompanyDate".equals(entry.getValue()) || "fleftDate".equals(entry.getValue()) || "fjoinGroupDate".equals(entry.getValue()) || "fjoinGroupDateCur".equals(entry.getValue()) || "fenterDate".equals(entry.getValue()) || "freinviteDate".equals(entry.getValue()) || "fplanFormalDate".equals(entry.getValue()) || "factualFormalDate".equals(entry.getValue()) || "fjobStartDate".equals(entry.getValue())) {
                            Date date = executeQuery.getDate(entry.getValue());
                            empOrgRelationCell = empOrgRelationRow.createCell(j);
                            if (date != null) {
                                empOrgRelationCell.setCellValue(date + "");
                            } else {
                                empOrgRelationCell.setCellValue("");
                            }
                            empOrgRelationCell.setCellStyle(textStyle);
                        } else if ("fadjustCoValue".equals(entry.getValue()) || "fjoinCompanyYears".equals(entry.getValue())) {
                            float num = executeQuery.getFloat(entry.getValue());
                            empOrgRelationCell = empOrgRelationRow.createCell(j);
                            empOrgRelationCell.setCellValue(num + "");
                            empOrgRelationCell.setCellStyle(textStyle);
                        } else {
                            String value = executeQuery.getString(entry.getValue());
                            empOrgRelationCell = empOrgRelationRow.createCell(j);
                            empOrgRelationCell.setCellValue(value);
                            empOrgRelationCell.setCellStyle(textStyle);
                        }
                        ++j;
                    }
                    ++count;
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static CellStyle textStyle(Workbook wb) {
        CellStyle css = wb.createCellStyle();
        DataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        return css;
    }

    private IRowSet getQuerySQL(Context ctx, String personId) throws BOSException {
        String oql = "SELECT PERSON.FID AS FPERSONID , PERSON.FNumber AS FPERSONNUMBER , PERSON.FName_l2 AS FPERSONNAME , POSITION.FName_l2 AS FPOSITIONNAME , ADMINORGUNITT.FDisplayName_l2 AS FADMINORGUNITDISPLAYNAME , COMPANYT.FDisplayName_l2 AS FCOMPANYDISPLAYNAME , EMPORGRELATION.fid as FEMPORGRELAID, EMPORGRELATION.FAssignType AS FASSIGNTYPE , EMPORGRELATION.FEFFDT AS FEFFDT , EMPORGRELATION.FLEFFDT AS FLEFFDT , EMPORGRELATION.FStartDateTime AS FSTARTDATETIME , EMPORGRELATION.FENDDATETIME AS FENDDATETIME , EMPORGRELATION.FFlowOutAffairID AS FLOWOUTAFFAIRID , EMPORGRELATION.FFlowInAffairID AS FFLOWINAFFAIRID , EMPORGRELATION.FactionId AS FACTIONID , EMPORGRELATION.FPositionId AS FPOSITIONID , EMPORGRELATION.FIsLatestInAday AS FIsLatestInAday , AFFAIRACTION.FName_l2 AS FACTIONNAME , ACTIONVARIATION.FName_l2 AS FACTIONVARIATIONNAME , AFFAIRACTIONREASON.FName_l2 AS FAFFAIRACTIONREASONNAME , PP.FJoinDate AS FJOINDATE , PP.FLeftCompanyDate AS FLEFTCOMPANYDATE , PP.FAdjustCoValue AS FADJUSTCOVALUE , PP.FJoinCompanyYears AS FJOINCOMPANYYEARS , PP.FLeftDate AS FLEFTDATE , PP.FJoinGroupDate AS FJOINGROUPDATE , PP.FJoinGroupDateCur AS FJOINGROUPDATECUR , PP.FAdjustGroupVal AS FADJUSTGROUPVAL , PP.FJoinGroupYears AS FJOINGROUPYEARS , LABORRELA.FEnterDate AS FENTERDATE , LABORRELA.FEFFDT AS FLABORRELAEFFDT , LABORRELA.FReinviteDate AS FREINVITEDATE , LABORRELA.FPlanFormalDate AS FPLANFORMALDATE , LABORRELA.FTryoutMonth AS FTRYOUTMONTH , LABORRELA.FActualFormalDate AS FACTUALFORMALDATE , EMPTYPE.FID AS FEMPLOYEETYPEID,  EMPTYPE.FName_l2 AS FEMPTYPENAME, OTHERINFO.FJOBSTARTDATE AS FJOBSTARTDATE  FROM  T_BD_PERSON  PERSON LEFT JOIN  T_HR_PersonOtherInfo OTHERINFO ON PERSON.FID = OTHERINFO.FPERSONID  LEFT JOIN  T_HR_EMPORGRELATION  EMPORGRELATION ON EMPORGRELATION.FPersonID=PERSON.fid AND EMPORGRELATION.FIsInner=1  LEFT JOIN  T_HR_PERSONPOSITIONHIS  PP ON PP.FPersonID=EMPORGRELATION.FPERSONID AND PP.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND PP.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_HR_AFFAIRACTIONREASON  AFFAIRACTIONREASON ON AFFAIRACTIONREASON.FID=EMPORGRELATION.FACTIONTYPEID LEFT JOIN  T_HR_VARIATIONREASON  ACTIONVARIATION ON ACTIONVARIATION.FID=EMPORGRELATION.FACTIONREASONID LEFT JOIN  T_ORG_ADMINHIS  ADMINORGUNIT ON ADMINORGUNIT.FhistoryRelateID=EMPORGRELATION.FADMINORGID AND ADMINORGUNIT.FEFFDT <= EMPORGRELATION.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  ADMINORGUNITT ON ADMINORGUNIT.FhistoryRelateID = ADMINORGUNITT.FAdminOrgID AND ADMINORGUNIT.FLEFFDT <= ADMINORGUNITT.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= ADMINORGUNITT.FEFFDT LEFT JOIN  T_ORG_POSITIONHIS  POSITION ON POSITION.FhistoryRelateID=EMPORGRELATION.FPOSITIONID AND POSITION.FEFFDT <= EMPORGRELATION.FLEFFDT AND POSITION.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN  T_HR_EMPLABORRELATIONHIS  LABORRELA ON LABORRELA.FPersonID=EMPORGRELATION.FPERSONID AND LABORRELA.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND LABORRELA.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_ORG_ADMINHIS  COMPANY ON COMPANY.FhistoryRelateID=ADMINORGUNIT.FCOMPANYID AND COMPANY.FEFFDT <= ADMINORGUNIT.FLEFFDT AND COMPANY.FLEFFDT >= ADMINORGUNIT.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  COMPANYT ON COMPANY.FhistoryRelateID = COMPANYT.FAdminOrgID AND COMPANY.FLEFFDT <= COMPANYT.FLEFFDT AND COMPANY.FLEFFDT >= COMPANYT.FEFFDT LEFT JOIN  T_HR_BDEMPLOYEETYPE  EMPTYPE ON EMPTYPE.FID=LABORRELA.FLABORRELATIONSTATEID  LEFT JOIN  T_HR_HRBIZDEFINE  AFFAIRACTION ON AFFAIRACTION.FID=EMPORGRELATION.FACTIONID";
        if (!StringUtils.isEmpty((String)personId)) {
            oql = oql + " where EMPORGRELATION.FPersonID ='" + personId + "' ";
        }
        oql = oql + " order by EMPORGRELATION.FAssignType,EMPORGRELATION.FEFFDT";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql);
        return rs;
    }

    private static String getReportSQL(Context ctx, int type, int count, int pageSize, int i) throws BOSException {
        String sql = "";
        if (type == 2 || type == 7 || type == 8) {
            sql = " SELECT * FROM (SELECT tableA.*,ROWNUM RN  FROM (SELECT  PERSON.FID AS fpersonId, PERSON.FNumber AS fpersonNumber, PERSON.FName_l2 AS fpersonName, POSITION.FName_l2 AS fpositionName, ADMINORGUNITT.FDisplayName_l2 AS fadminOrgUnitDisplayName, COMPANYT.FDisplayName_l2 AS fcompanyDisplayname, EMPORGRELATION.fid as empOrgRelaId, EMPORGRELATION.FAssignType AS fassignType, EMPORGRELATION.FEFFDT AS fEFFDT, EMPORGRELATION.FLEFFDT AS fLEFFDT, EMPORGRELATION.FStartDateTime AS fstartDateTime, EMPORGRELATION.FENDDATETIME AS fendDateTime, EMPORGRELATION.FFlowOutAffairID AS FlowOutAffairID, EMPORGRELATION.FFlowInAffairID AS FFlowInAffairID, EMPORGRELATION.FactionId AS FactionId, EMPORGRELATION.FPositionId AS FPositionId, AFFAIRACTION.FName_l2 AS factionName, ACTIONVARIATION.FName_l2 AS factionVariationName, AFFAIRACTIONREASON.FName_l2 AS faffairActionReasonName, PP.FJoinDate AS fjoinDate, PP.FLeftCompanyDate AS fleftCompanyDate, PP.FAdjustCoValue AS fadjustCoValue, PP.FJoinCompanyYears AS fjoinCompanyYears, PP.FLeftDate AS fleftDate, PP.FJoinGroupDate AS fjoinGroupDate, PP.FJoinGroupDateCur AS fjoinGroupDateCur, PP.FAdjustGroupVal AS fadjustGroupVal, PP.FJoinGroupYears AS fjoinGroupYears, LABORRELA.FEnterDate AS fenterDate, LABORRELA.FEFFDT AS flaborRelaEffdt, LABORRELA.FReinviteDate AS freinviteDate, LABORRELA.FPlanFormalDate AS fplanFormalDate, LABORRELA.FTryoutMonth AS ftryoutMonth, LABORRELA.FActualFormalDate AS factualFormalDate, EMPTYPE.FID AS FemployeeTypeId, EMPTYPE.FName_l2 AS fempTypeName, OTHERINFO.FJOBSTARTDATE AS FJOBSTARTDATE, dataCheckRecord.FCHECKRESULT as fcheckResult, dataCheckRecord.FREPAIRGUIDE as frepairGuide  FROM  T_BD_PERSON  PERSON LEFT JOIN  T_HR_PersonOtherInfo OTHERINFO ON PERSON.FID = OTHERINFO.FPERSONID  LEFT JOIN  T_HR_EMPORGRELATION  EMPORGRELATION ON EMPORGRELATION.FPersonID=PERSON.fid  LEFT JOIN  T_HR_PERSONPOSITIONHIS  PP ON PP.FPersonID=EMPORGRELATION.FPERSONID AND PP.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND PP.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_HR_AFFAIRACTIONREASON  AFFAIRACTIONREASON ON AFFAIRACTIONREASON.FID=EMPORGRELATION.FACTIONTYPEID LEFT JOIN  T_HR_VARIATIONREASON  ACTIONVARIATION ON ACTIONVARIATION.FID=EMPORGRELATION.FACTIONREASONID LEFT JOIN  T_ORG_ADMINHIS  ADMINORGUNIT ON ADMINORGUNIT.FhistoryRelateID=EMPORGRELATION.FADMINORGID AND ADMINORGUNIT.FEFFDT <= EMPORGRELATION.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  ADMINORGUNITT ON ADMINORGUNIT.FhistoryRelateID = ADMINORGUNITT.FAdminOrgID AND ADMINORGUNIT.FLEFFDT <= ADMINORGUNITT.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= ADMINORGUNITT.FEFFDT LEFT JOIN T_ORG_POSITIONHIS  POSITION ON POSITION.FhistoryRelateID=EMPORGRELATION.FPOSITIONID AND POSITION.FEFFDT <= EMPORGRELATION.FLEFFDT AND POSITION.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN  T_HR_EMPLABORRELATIONHIS  LABORRELA ON LABORRELA.FPersonID=EMPORGRELATION.FPERSONID AND LABORRELA.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND LABORRELA.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_ORG_ADMINHIS  COMPANY ON COMPANY.FhistoryRelateID=ADMINORGUNIT.FCOMPANYID AND COMPANY.FEFFDT <= ADMINORGUNIT.FLEFFDT AND COMPANY.FLEFFDT >= ADMINORGUNIT.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  COMPANYT ON COMPANY.FhistoryRelateID = COMPANYT.FAdminOrgID AND COMPANY.FLEFFDT <= COMPANYT.FLEFFDT AND COMPANY.FLEFFDT >= COMPANYT.FEFFDT LEFT JOIN  T_HR_BDEMPLOYEETYPE  EMPTYPE ON EMPTYPE.FID=LABORRELA.FLABORRELATIONSTATEID  LEFT JOIN  T_HR_HRBIZDEFINE  AFFAIRACTION ON AFFAIRACTION.FID=EMPORGRELATION.FACTIONID left JOIN T_HR_DataCheckRecord dataCheckRecord on person.FNUMBER = dataCheckRecord.FNUMBER and (dataCheckRecord.FCheckItem = EMPORGRELATION.fid or dataCheckRecord.FCheckItem is null) where dataCheckRecord.FNUMBER is not null order by EMPORGRELATION.FAssignType,EMPORGRELATION.FEFFDT,PERSON.FNumber) tableA) WHERE RN >" + (i - 1) * pageSize + "AND RN <=" + i * pageSize;
            count = (i - 1) * pageSize;
        } else if (type == 3) {
            sql = " /*dialect*/SELECT * FROM( select *,row_number() over(order by fassignType,fEFFDT,fpersonNumber) rownumber FROM ( SELECT TOP " + i * pageSize + " * from (SELECT PERSON.FID AS fpersonId, PERSON.FNumber AS fpersonNumber, PERSON.FName_l2 AS fpersonName, POSITION.FName_l2 AS fpositionName, ADMINORGUNITT.FDisplayName_l2 AS fadminOrgUnitDisplayName, COMPANYT.FDisplayName_l2 AS fcompanyDisplayname, EMPORGRELATION.fid as empOrgRelaId, EMPORGRELATION.FAssignType AS fassignType, EMPORGRELATION.FEFFDT AS fEFFDT, EMPORGRELATION.FLEFFDT AS fLEFFDT, EMPORGRELATION.FStartDateTime AS fstartDateTime, EMPORGRELATION.FENDDATETIME AS fendDateTime, EMPORGRELATION.FFlowOutAffairID AS FlowOutAffairID, EMPORGRELATION.FFlowInAffairID AS FFlowInAffairID, EMPORGRELATION.FactionId AS FactionId, EMPORGRELATION.FPositionId AS FPositionId, AFFAIRACTION.FName_l2 AS factionName , ACTIONVARIATION.FName_l2 AS factionVariationName, AFFAIRACTIONREASON.FName_l2 AS faffairActionReasonName, PP.FJoinDate AS fjoinDate, PP.FLeftCompanyDate AS fleftCompanyDate, PP.FAdjustCoValue AS fadjustCoValue, PP.FJoinCompanyYears AS fjoinCompanyYears, PP.FLeftDate AS fleftDate, PP.FJoinGroupDate AS fjoinGroupDate, PP.FJoinGroupDateCur AS fjoinGroupDateCur, PP.FAdjustGroupVal AS fadjustGroupVal, PP.FJoinGroupYears AS fjoinGroupYears, LABORRELA.FEnterDate AS fenterDate, LABORRELA.FEFFDT AS flaborRelaEffdt, LABORRELA.FReinviteDate AS freinviteDate, LABORRELA.FPlanFormalDate AS fplanFormalDate, LABORRELA.FTryoutMonth AS ftryoutMonth, LABORRELA.FActualFormalDate AS factualFormalDate, EMPTYPE.FID AS FemployeeTypeId,  EMPTYPE.FName_l2 AS fempTypeName, OTHERINFO.FJOBSTARTDATE AS FJOBSTARTDATE, dataCheckRecord.FCHECKRESULT as fcheckResult, dataCheckRecord.FREPAIRGUIDE as frepairGuide  FROM  T_BD_PERSON  PERSON LEFT JOIN  T_HR_PersonOtherInfo OTHERINFO ON PERSON.FID = OTHERINFO.FPERSONID  LEFT JOIN  T_HR_EMPORGRELATION  EMPORGRELATION ON EMPORGRELATION.FPersonID=PERSON.fid  LEFT JOIN  T_HR_PERSONPOSITIONHIS  PP ON PP.FPersonID=EMPORGRELATION.FPERSONID AND PP.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND PP.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_HR_AFFAIRACTIONREASON  AFFAIRACTIONREASON ON AFFAIRACTIONREASON.FID=EMPORGRELATION.FACTIONTYPEID LEFT JOIN  T_HR_VARIATIONREASON  ACTIONVARIATION ON ACTIONVARIATION.FID=EMPORGRELATION.FACTIONREASONID LEFT JOIN  T_ORG_ADMINHIS  ADMINORGUNIT ON ADMINORGUNIT.FhistoryRelateID=EMPORGRELATION.FADMINORGID AND ADMINORGUNIT.FEFFDT <= EMPORGRELATION.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  ADMINORGUNITT ON ADMINORGUNIT.FhistoryRelateID = ADMINORGUNITT.FAdminOrgID AND ADMINORGUNIT.FLEFFDT <= ADMINORGUNITT.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= ADMINORGUNITT.FEFFDT LEFT JOIN T_ORG_POSITIONHIS  POSITION ON POSITION.FhistoryRelateID=EMPORGRELATION.FPOSITIONID AND POSITION.FEFFDT <= EMPORGRELATION.FLEFFDT AND POSITION.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN  T_HR_EMPLABORRELATIONHIS  LABORRELA ON LABORRELA.FPersonID=EMPORGRELATION.FPERSONID AND LABORRELA.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND LABORRELA.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_ORG_ADMINHIS  COMPANY ON COMPANY.FhistoryRelateID=ADMINORGUNIT.FCOMPANYID AND COMPANY.FEFFDT <= ADMINORGUNIT.FLEFFDT AND COMPANY.FLEFFDT >= ADMINORGUNIT.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  COMPANYT ON COMPANY.FhistoryRelateID = COMPANYT.FAdminOrgID AND COMPANY.FLEFFDT <= COMPANYT.FLEFFDT AND COMPANY.FLEFFDT >= COMPANYT.FEFFDT LEFT JOIN  T_HR_BDEMPLOYEETYPE  EMPTYPE ON EMPTYPE.FID=LABORRELA.FLABORRELATIONSTATEID  LEFT JOIN  T_HR_HRBIZDEFINE  AFFAIRACTION ON AFFAIRACTION.FID=EMPORGRELATION.FACTIONID left JOIN T_HR_DataCheckRecord dataCheckRecord on person.FNUMBER = dataCheckRecord.FNUMBER and (dataCheckRecord.FCheckItem = EMPORGRELATION.fid or dataCheckRecord.FCheckItem is null) where dataCheckRecord.FNUMBER is not null) AS tableA  order by fassignType,fEFFDT,fpersonNumber) AS tableB ) AS tableC where rownumber>" + (i - 1) * pageSize;
            count = (i - 1) * pageSize;
        } else {
            sql = " SELECT PERSON.FID AS fpersonId, PERSON.FNumber AS fpersonNumber, PERSON.FName_l2 AS fpersonName, POSITION.FName_l2 AS fpositionName, ADMINORGUNITT.FDisplayName_l2 AS fadminOrgUnitDisplayName, COMPANYT.FDisplayName_l2 AS fcompanyDisplayname, EMPORGRELATION.fid as empOrgRelaId, EMPORGRELATION.FAssignType AS fassignType, EMPORGRELATION.FEFFDT AS fEFFDT, EMPORGRELATION.FLEFFDT AS fLEFFDT, EMPORGRELATION.FStartDateTime AS fstartDateTime, EMPORGRELATION.FENDDATETIME AS fendDateTime, EMPORGRELATION.FFlowOutAffairID AS FlowOutAffairID, EMPORGRELATION.FFlowInAffairID AS FFlowInAffairID, EMPORGRELATION.FactionId AS FactionId, EMPORGRELATION.FPositionId AS FPositionId, AFFAIRACTION.FName_l2 AS factionName, ACTIONVARIATION.FName_l2 AS factionVariationName, AFFAIRACTIONREASON.FName_l2 AS faffairActionReasonName, PP.FJoinDate AS fjoinDate, PP.FLeftCompanyDate AS fleftCompanyDate, PP.FAdjustCoValue AS fadjustCoValue, PP.FJoinCompanyYears AS fjoinCompanyYears, PP.FLeftDate AS fleftDate, PP.FJoinGroupDate AS fjoinGroupDate, PP.FJoinGroupDateCur AS fjoinGroupDateCur, PP.FAdjustGroupVal AS fadjustGroupVal, PP.FJoinGroupYears AS fjoinGroupYears, LABORRELA.FEnterDate AS fenterDate, LABORRELA.FEFFDT AS flaborRelaEffdt, LABORRELA.FReinviteDate AS freinviteDate, LABORRELA.FPlanFormalDate AS fplanFormalDate, LABORRELA.FTryoutMonth AS ftryoutMonth, LABORRELA.FActualFormalDate AS factualFormalDate, EMPTYPE.FID AS FemployeeTypeId,  EMPTYPE.FName_l2 AS fempTypeName, OTHERINFO.FJOBSTARTDATE AS FJOBSTARTDATE, dataCheckRecord.FCHECKRESULT as fcheckResult, dataCheckRecord.FREPAIRGUIDE as frepairGuide  FROM T_BD_PERSON PERSON LEFT JOIN  T_HR_PersonOtherInfo OTHERINFO ON PERSON.FID = OTHERINFO.FPERSONID LEFT JOIN  T_HR_EMPORGRELATION  EMPORGRELATION ON EMPORGRELATION.FPersonID=PERSON.fid LEFT JOIN  T_HR_PERSONPOSITIONHIS  PP ON PP.FPersonID=EMPORGRELATION.FPERSONID AND PP.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND PP.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_HR_AFFAIRACTIONREASON  AFFAIRACTIONREASON ON AFFAIRACTIONREASON.FID=EMPORGRELATION.FACTIONTYPEID LEFT JOIN  T_HR_VARIATIONREASON  ACTIONVARIATION ON ACTIONVARIATION.FID=EMPORGRELATION.FACTIONREASONID LEFT JOIN  T_ORG_ADMINHIS  ADMINORGUNIT ON ADMINORGUNIT.FhistoryRelateID=EMPORGRELATION.FADMINORGID AND ADMINORGUNIT.FEFFDT <= EMPORGRELATION.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  ADMINORGUNITT ON ADMINORGUNIT.FhistoryRelateID = ADMINORGUNITT.FAdminOrgID AND ADMINORGUNIT.FLEFFDT <= ADMINORGUNITT.FLEFFDT AND ADMINORGUNIT.FLEFFDT >= ADMINORGUNITT.FEFFDT LEFT JOIN T_ORG_POSITIONHIS  POSITION ON POSITION.FhistoryRelateID=EMPORGRELATION.FPOSITIONID AND POSITION.FEFFDT <= EMPORGRELATION.FLEFFDT AND POSITION.FLEFFDT >= EMPORGRELATION.FLEFFDT LEFT JOIN  T_HR_EMPLABORRELATIONHIS  LABORRELA ON LABORRELA.FPersonID=EMPORGRELATION.FPERSONID AND LABORRELA.FStartDateTime<=EMPORGRELATION.FENDDATETIME AND LABORRELA.FEndDateTime>=EMPORGRELATION.FENDDATETIME LEFT JOIN  T_ORG_ADMINHIS  COMPANY ON COMPANY.FhistoryRelateID=ADMINORGUNIT.FCOMPANYID AND COMPANY.FEFFDT <= ADMINORGUNIT.FLEFFDT AND COMPANY.FLEFFDT >= ADMINORGUNIT.FLEFFDT LEFT JOIN T_ORG_ADMINORGTREEHIS  COMPANYT ON COMPANY.FhistoryRelateID = COMPANYT.FAdminOrgID AND COMPANY.FLEFFDT <= COMPANYT.FLEFFDT AND COMPANY.FLEFFDT >= COMPANYT.FEFFDT LEFT JOIN  T_HR_BDEMPLOYEETYPE  EMPTYPE ON EMPTYPE.FID=LABORRELA.FLABORRELATIONSTATEID LEFT JOIN  T_HR_HRBIZDEFINE  AFFAIRACTION ON AFFAIRACTION.FID=EMPORGRELATION.FACTIONID left JOIN T_HR_DataCheckRecord dataCheckRecord on person.FNUMBER = dataCheckRecord.FNUMBER and (dataCheckRecord.FCheckItem = EMPORGRELATION.fid or dataCheckRecord.FCheckItem is null) where dataCheckRecord.FNUMBER is not null order by EMPORGRELATION.FAssignType,EMPORGRELATION.FEFFDT,PERSON.FNumber";
            count = 0;
        }
        return sql;
    }

    private List<Map<String, String>> rowSetConvertList(IRowSet rs, ResultSetMetaData resultData) throws SQLException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 1; i <= resultData.getColumnCount(); ++i) {
                String dateStr;
                String columnName = resultData.getColumnName(i);
                String columnTypeName = resultData.getColumnTypeName(i);
                if (columnTypeName.equalsIgnoreCase("VARCHAR2") || columnTypeName.equalsIgnoreCase("varchar") || columnTypeName.equalsIgnoreCase("nvarchar") || columnTypeName.equalsIgnoreCase("NUMERIC") || columnTypeName.equalsIgnoreCase("decimal") || columnTypeName.equalsIgnoreCase("DOUBLE") || columnTypeName.equalsIgnoreCase("Float") || columnTypeName.equalsIgnoreCase("INT") || columnTypeName.equalsIgnoreCase("NUMBER")) {
                    String columnValue = rs.getString(i);
                    map.put(columnName, columnValue);
                    continue;
                }
                if (columnTypeName.equalsIgnoreCase("datetime")) {
                    dateStr = this.timeConvertString(rs.getDate(i));
                    map.put(columnName, dateStr);
                    continue;
                }
                if (!columnTypeName.equalsIgnoreCase("TIMESTAMP")) continue;
                dateStr = this.timeConvertString(rs.getDate(i));
                map.put(columnName, dateStr);
            }
            list.add(map);
        }
        return list;
    }

    private String timeConvertString(java.util.Date date) {
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateStr = simpleDateFormat.format(date);
            return dateStr;
        }
        return "";
    }
}

