/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.state.StateTrainCommonUtils;
import com.kingdee.eas.hr.state.app.StateTrainUtilsServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;
import org.apache.log4j.Logger;

public class StateCodingRuleServerHelper {
    private static final Logger logger = Logger.getLogger((String)StateCodingRuleServerHelper.class.getName());
    private static final String RESOURCE = "com.kingdee.eas.hr.state.MessageResource";

    public static void setInfoNumber(Context ctx, CoreBaseInfo info, OrgUnitInfo orgUnitInfo) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo)) {
            StateCodingRuleServerHelper.throwNumberIsEmpty(ctx);
        }
        if (info != null && StateTrainCommonUtils.isEmpty(info.getString("number"))) {
            String orgUnitId = orgUnitInfo.getId().toString();
            String number = null;
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, orgUnitId)) {
                number = codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
            }
            if (StateTrainCommonUtils.isEmpty(number)) {
                StateCodingRuleServerHelper.throwNumberIsEmpty(ctx);
            } else {
                info.setString("number", number);
            }
        }
    }

    private static void throwNumberIsEmpty(Context ctx) throws EASBizException {
        String str = ResourceBase.getString((String)RESOURCE, (String)"NUMBER", (Locale)ctx.getLocale());
        throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{str});
    }

    public static void setInfoNumber(Context ctx, CoreBaseInfo info, String bindingProperty, OrgUnitInfo orgUnitInfo) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo)) {
            StateCodingRuleServerHelper.throwNumberIsEmpty(ctx);
        }
        if (info != null && StateTrainCommonUtils.isEmpty(info.getString("number"))) {
            String orgUnitId = orgUnitInfo.getId().toString();
            String number = null;
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, orgUnitId, bindingProperty)) {
                String customString = null;
                number = codingRuleManager.getNumber((IObjectValue)info, orgUnitId, bindingProperty, customString);
            }
            if (StateTrainCommonUtils.isEmpty(number)) {
                StateCodingRuleServerHelper.throwNumberIsEmpty(ctx);
            } else {
                info.setString("number", number);
            }
        }
    }

    public static void setInfoNumber(Context ctx, CoreBaseInfo info) throws BOSException, CodingRuleException, EASBizException {
        StateCodingRuleServerHelper.setInfoNumber(ctx, info, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }

    public static void setInfoNumber(Context ctx, CoreBaseInfo info, String bindingProperty) throws BOSException, CodingRuleException, EASBizException {
        StateCodingRuleServerHelper.setInfoNumber(ctx, info, bindingProperty, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo)) {
            return;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, orgUnitId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId)) {
            codingRuleManager.recycleNumber((IObjectValue)info, orgUnitId, info.getString("number"));
        }
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, OrgUnitInfo orgUnitInfo, String bindingProperty) throws BOSException, EASBizException {
        if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo) || StateTrainCommonUtils.isEmpty(bindingProperty)) {
            return;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, orgUnitId, bindingProperty) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId, bindingProperty)) {
            codingRuleManager.recycleNumber((IObjectValue)info, orgUnitId, bindingProperty, null, info.getString("number"));
        }
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info) throws BOSException, EASBizException {
        StateCodingRuleServerHelper.recycleNumber(ctx, info, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String bindingProperty) throws BOSException, EASBizException {
        StateCodingRuleServerHelper.recycleNumber(ctx, info, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx), bindingProperty);
    }

    public static void recycleNumber(Context ctx, IObjectPK pk, OrgUnitInfo orgUnitInfo, ICoreBase bizInterface, String className) throws BOSException, EASBizException {
        if (pk == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo) || bizInterface == null || StateTrainCommonUtils.isEmpty(className)) {
            return;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        if (StateCodingRuleServerHelper.isUseIntermitNumber(ctx, className, orgUnitId)) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CoreBaseInfo dbInfo = bizInterface.getValue(pk);
            codingRuleManager.recycleNumber((IObjectValue)dbInfo, orgUnitId, dbInfo.getString("number"));
        }
    }

    public static boolean isUseIntermitNumber(Context ctx, String className, String orgUnitId) throws BOSException, EASBizException {
        CoreBaseInfo info = StateTrainUtilsServer.getCoreBaseInfo(className);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return codingRuleManager.isExist((IObjectValue)info, orgUnitId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId);
    }

    public static boolean isUseIntermitNumber(Context ctx, String className, String orgUnitId, String bindingProperty) throws BOSException, EASBizException {
        CoreBaseInfo info = StateTrainUtilsServer.getCoreBaseInfo(className);
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return codingRuleManager.isExist((IObjectValue)info, orgUnitId, bindingProperty) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId, bindingProperty);
    }

    public static void recycleNumber(Context ctx, IObjectPK pk, ICoreBase bizInterface, String className) throws BOSException, EASBizException {
        StateCodingRuleServerHelper.recycleNumber(ctx, pk, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx), bizInterface, className);
    }

    public static void recycleNumber(Context ctx, FilterInfo filterInfo, OrgUnitInfo orgUnitInfo, ICoreBase bizInterface, String className) throws BOSException, EASBizException {
        if (!FilterUtility.hasFilterItem((FilterInfo)filterInfo) || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo) || bizInterface == null || StateTrainCommonUtils.isEmpty(className)) {
            return;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        if (StateCodingRuleServerHelper.isUseIntermitNumber(ctx, className, orgUnitId)) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            CoreBaseCollection collection = bizInterface.getCollection(viewInfo);
            if (collection != null) {
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    CoreBaseInfo dbInfo = collection.get(i);
                    codingRuleManager.recycleNumber((IObjectValue)dbInfo, orgUnitId, dbInfo.getString("number"));
                }
            }
        }
    }

    public static void recycleNumber(Context ctx, FilterInfo filterInfo, ICoreBase bizInterface, String className) throws BOSException, EASBizException {
        StateCodingRuleServerHelper.recycleNumber(ctx, filterInfo, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx), bizInterface, className);
    }

    public static boolean hasNumberRule(Context ctx, CoreBaseInfo info, OrgUnitInfo orgUnitInfo) {
        if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo)) {
            return false;
        }
        boolean result = false;
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist((IObjectValue)info, orgUnitInfo.getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        return result;
    }

    public static boolean hasNumberRule(Context ctx, CoreBaseInfo info) {
        return StateCodingRuleServerHelper.hasNumberRule(ctx, info, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }

    public static void prepareCodingRule(Context ctx, CoreBaseInfo info, String state, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (state != null && "ADDNEW".equalsIgnoreCase(state)) {
            if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo)) {
                return;
            }
            String orgUnitId = orgUnitInfo.getId().toString();
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean result = codingRuleManager.isExist((IObjectValue)info, orgUnitId);
            if (result) {
                if (codingRuleManager.isAddView((IObjectValue)info, orgUnitId)) {
                    codingRuleManager.getProperties((IObjectValue)info, orgUnitId);
                    codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
                }
                codingRuleManager.isModifiable((IObjectValue)info, orgUnitId);
            }
        }
    }

    public static void prepareCodingRule(Context ctx, CoreBaseInfo info, String state) throws BOSException, EASBizException {
        StateCodingRuleServerHelper.prepareCodingRule(ctx, info, state, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }

    public static void prepareCodingRule(Context ctx, CoreBaseInfo info, String state, String bindingProperty, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (state != null && "ADDNEW".equalsIgnoreCase(state)) {
            if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo) || StateTrainCommonUtils.isEmpty(bindingProperty)) {
                return;
            }
            String orgUnitId = orgUnitInfo.getId().toString();
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean result = codingRuleManager.isExist((IObjectValue)info, orgUnitId, bindingProperty);
            if (result) {
                if (codingRuleManager.isAddView((IObjectValue)info, orgUnitId, bindingProperty)) {
                    codingRuleManager.getProperties((IObjectValue)info, orgUnitId, bindingProperty);
                    String customString = null;
                    codingRuleManager.getNumber((IObjectValue)info, orgUnitId, bindingProperty, customString);
                }
                codingRuleManager.isModifiable((IObjectValue)info, orgUnitId, bindingProperty);
            }
        }
    }

    public static void prepareCodingRule(Context ctx, CoreBaseInfo info, String state, String bindingProperty) throws BOSException, EASBizException {
        StateCodingRuleServerHelper.prepareCodingRule(ctx, info, state, bindingProperty, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }

    public static boolean hasNumberRule(Context ctx, CoreBaseInfo info, String state, String bindingProperty, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (info == null || StateTrainCommonUtils.isEmpty((CoreBaseInfo)orgUnitInfo) || StateTrainCommonUtils.isEmpty(bindingProperty)) {
            return false;
        }
        String orgUnitId = orgUnitInfo.getId().toString();
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)info, orgUnitId, bindingProperty);
    }

    public static boolean hasNumberRule(Context ctx, CoreBaseInfo info, String state, String bindingProperty) throws BOSException, EASBizException {
        return StateCodingRuleServerHelper.hasNumberRule(ctx, info, state, bindingProperty, (OrgUnitInfo)ContextUtil.getCurrentHRUnit((Context)ctx));
    }
}

