/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.time.AttendanceManagerCollection;
import com.kingdee.eas.hr.time.AttendanceManagerFactory;
import com.kingdee.eas.hr.time.AttendanceManagerInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.IAttendanceManager;
import com.kingdee.eas.hr.time.ILeaveDetail;
import com.kingdee.eas.hr.time.LeaveDetailCheckException;
import com.kingdee.eas.hr.time.LeaveDetailCollection;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.RefStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.app.AbstractAttendanceManagerControllerBean;
import com.kingdee.eas.hr.time.app.TimeServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AttendanceManagerControllerBean
extends AbstractAttendanceManagerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.AttendanceManagerControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AttendanceManagerInfo manaInfo = (AttendanceManagerInfo)model;
        manaInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)manaInfo);
    }

    protected void _submitAll(Context ctx, IObjectCollection infos, IObjectPK[] pkList) throws BOSException, EASBizException {
        IObjectPK logPK;
        AttendanceManagerCollection attendInfos = (AttendanceManagerCollection)infos;
        int counts = attendInfos.size();
        AttendanceManagerInfo attendInfo = null;
        for (int i = 0; i < counts; ++i) {
            attendInfo = attendInfos.get(i);
            if (attendInfo.getId() != null) {
                if (attendInfo.getCheckState().getValue() == 1 || attendInfo.getRefrence().getValue() == 1) continue;
                logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new AttendanceManagerInfo().getBOSType(), null, (String)(attendInfo.getAttendance() + ""), (String)"AttManager_Update");
                this._update(ctx, (IObjectPK)new ObjectUuidPK(attendInfo.getId()), (IObjectValue)attendInfo);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
                continue;
            }
            logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new AttendanceManagerInfo().getBOSType(), null, (String)(attendInfo.getAttendance() + ""), (String)"AttManager_AddNew");
            this._addnew(ctx, (IObjectValue)attendInfo);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        if (pkList != null) {
            AttendanceManagerInfo attmaninfo = (AttendanceManagerInfo)this.getValue(ctx, "select * , attendance.id,attendance.name where id='" + pkList[0].toString() + "'");
            logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new AttendanceManagerInfo().getBOSType(), null, (String)(attmaninfo.getAttendance() + ""), (String)"AttManager_Del");
            this._delete(ctx, pkList);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    protected void _delete(Context arg0, IObjectPK arg1) throws BOSException, EASBizException {
        this.checkCanDelete(arg0, arg1);
        super._delete(arg0, arg1);
    }

    void checkCanDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        AttendanceManagerInfo info = this.getAttendanceManagerInfo(ctx, pk);
        if (info.getCheckState().getValue() == 1 || info.getRefrence().getValue() == 1) {
            throw new TimeAttendanceException(TimeAttendanceException.ALREADY_REF_NOT_DELETE);
        }
    }

    protected IObjectCollection _getCollectionByList(Context ctx, ArrayList arrList) throws BOSException, EASBizException {
        if (arrList.size() == 0) {
            return null;
        }
        AttendanceManagerCollection collInfos = new AttendanceManagerCollection();
        HashSet set = new HashSet();
        int size = arrList.size();
        for (int i = 0; i < size; ++i) {
            set.add(arrList.get(i));
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.time.app.AttendanceManagerOrgQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        exec.setObjectView(view);
        IRowSet selectItemRowSet = exec.executeQuery();
        AttendanceManagerInfo attendInfo = null;
        PersonInfo pInfo = null;
        try {
            while (selectItemRowSet.next()) {
                attendInfo = new AttendanceManagerInfo();
                attendInfo.setId(BOSUuid.read((String)selectItemRowSet.getString("id")));
                attendInfo.setTotalValue(selectItemRowSet.getFloat("totalValue"));
                attendInfo.setStartDate(selectItemRowSet.getDate("startDate"));
                attendInfo.setEndDate(selectItemRowSet.getDate("endDate"));
                attendInfo.setCheckState(CheckStateEnum.getEnum(selectItemRowSet.getInt("checkState")));
                attendInfo.setRefrence(RefStateEnum.getEnum(selectItemRowSet.getInt("refrence")));
                attendInfo.setDescription(selectItemRowSet.getString("description"));
                TimeAttendanceInfo timeInfo = new TimeAttendanceInfo();
                timeInfo.setId(BOSUuid.read((String)selectItemRowSet.getString("timeAttendance.id")));
                timeInfo.setName(selectItemRowSet.getString("timeAttendance.name"));
                timeInfo.setUnitType(UnitTypeEnum.getEnum(selectItemRowSet.getInt("timeAttendance.unitType")));
                attendInfo.setAttendance(timeInfo);
                pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)selectItemRowSet.getString("person.id")));
                pInfo.setName(selectItemRowSet.getString("person.name"));
                pInfo.setNumber(selectItemRowSet.getString("person.number"));
                attendInfo.setPerson(pInfo);
                CmpPeriodInfo cmpInfo = new CmpPeriodInfo();
                cmpInfo.setId(BOSUuid.read((String)selectItemRowSet.getString("cmpPeriod.id")));
                cmpInfo.setName(selectItemRowSet.getString("cmpPeriod.name"));
                cmpInfo.setNumber(selectItemRowSet.getString("cmpPeriod.number"));
                attendInfo.setCmpPeriod(cmpInfo);
                if (selectItemRowSet.getString("recordPerson.id") != null) {
                    pInfo = new PersonInfo();
                    pInfo.setId(BOSUuid.read((String)selectItemRowSet.getString("recordPerson.id")));
                    pInfo.setName(selectItemRowSet.getString("recordPerson.name"));
                    attendInfo.setRecordPerson(pInfo);
                }
                attendInfo.put("adminOrgUnit", selectItemRowSet.getString("adminOrg.name"));
                collInfos.add(attendInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return collInfos;
    }

    boolean _checkEveryAttendance(Context ctx, String id) throws BOSException, EASBizException {
        AttendanceManagerInfo attendInfo = this.getAttendanceManagerInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (attendInfo.getStartDate() != null && attendInfo.getEndDate() != null) {
            if (attendInfo.getCmpPeriod() != null) {
                attendInfo.setCheckState(CheckStateEnum.CHECK);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)attendInfo);
                return true;
            }
            CmpPeriodInfo cmpInfo = this.findCmpPeriodInfo(ctx, attendInfo.getStartDate(), attendInfo.getEndDate());
            if (cmpInfo != null) {
                attendInfo.setCheckState(CheckStateEnum.CHECK);
                attendInfo.setCmpPeriod(cmpInfo);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)attendInfo);
                return true;
            }
            return false;
        }
        return false;
    }

    CmpPeriodInfo findCmpPeriodInfo(Context ctx, Date startDate, Date overDate) throws BOSException {
        Date beginDate = DateTimeUtils.truncateDate((Date)startDate);
        Date endDate = DateTimeUtils.truncateDate((Date)overDate);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beginDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)0));
        filter.setMaskString("#0 and #1 and #2 and #3");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CmpPeriodCollection c = CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodCollection(evi);
        if (c.size() > 0) {
            return c.get(0);
        }
        return null;
    }

    boolean _unCheckEveryAttendance(Context ctx, String id) throws BOSException, EASBizException {
        AttendanceManagerInfo attendInfo = this.getAttendanceManagerInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (attendInfo.getRefrence().getValue() == 1) {
            return false;
        }
        if (attendInfo.getCheckState().getValue() == 0) {
            return false;
        }
        attendInfo.setCheckState(CheckStateEnum.UNCHECK);
        this._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)attendInfo);
        return true;
    }

    protected int _checkAttendance(Context ctx, String[] id) throws BOSException, EASBizException {
        int counts = id.length;
        int checkCounts = 0;
        for (int i = 0; i < counts; ++i) {
            if (!this._checkEveryAttendance(ctx, id[i])) continue;
            ++checkCounts;
        }
        if (checkCounts != counts) {
            throw new LeaveDetailCheckException(LeaveDetailCheckException.CHECK_FAIL_NO_CMPPERIOD);
        }
        return checkCounts;
    }

    protected int _unCheckAttendance(Context ctx, String[] id) throws BOSException, EASBizException {
        int counts = id.length;
        int unCheckCounts = 0;
        for (int i = 0; i < counts; ++i) {
            if (!this._unCheckEveryAttendance(ctx, id[i])) continue;
            ++unCheckCounts;
        }
        return unCheckCounts;
    }

    protected void _saveALL(Context ctx, IObjectCollection infos) throws BOSException, EASBizException {
        AttendanceManagerCollection attendInfos = (AttendanceManagerCollection)infos;
        AttendanceManagerInfo attendInfo = null;
        int counts = attendInfos.size();
        ObjectUuidPK pk = null;
        for (int i = 0; i < counts; ++i) {
            pk = new ObjectUuidPK(attendInfos.get(i).getId());
            attendInfo = this.getAttendanceManagerInfo(ctx, (IObjectPK)pk);
            if (attendInfo.getCheckState().getValue() != 0) continue;
            attendInfo.setDescription(attendInfos.get(i).getDescription());
            attendInfo.setTotalValue(attendInfos.get(i).getTotalValue());
            attendInfo.setStartDate(attendInfos.get(i).getStartDate());
            attendInfo.setEndDate(attendInfos.get(i).getEndDate());
            attendInfo.setCmpPeriod(attendInfos.get(i).getCmpPeriod());
            attendInfo.setPosition(attendInfos.get(i).getPosition());
            attendInfo.setAdminOrgUnit(attendInfos.get(i).getAdminOrgUnit());
            attendInfo.setCmpScheme(attendInfos.get(i).getCmpScheme());
            this._update(ctx, (IObjectPK)pk, (IObjectValue)attendInfo);
        }
    }

    protected int _unAudit(Context ctx, String[] id) throws BOSException, EASBizException {
        int ret = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_HR_AttendanceManager SET FCheckState = ? WHERE FID IN (");
        for (int i = 0; i < id.length; ++i) {
            sb.append("?");
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = super.getConnection(ctx);
            pstmt = conn.prepareStatement(sb.toString());
            pstmt.setInt(1, 0);
            for (int i = 0; i < id.length; ++i) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)(2 + i), (String)id[i]);
            }
            ret = pstmt.executeUpdate();
        }
        catch (Exception ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return ret;
    }

    protected void _setPosAndorgunit(Context ctx) throws BOSException, EASBizException {
        if (!TimeServerUtils.getParamValue(ctx, "AttendanceData_Relate_OrgUnit")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_hr_attendanceManager ");
        sql.append(" set (FPositionId,FAdminOrgUnitId)= ");
        sql.append(" ( ");
        sql.append(" select pos.fid psId,org.fid orgId ");
        sql.append(" from t_org_positionMember pm ");
        sql.append(" inner join t_bd_person person on pm.fpersonId = person.fid ");
        sql.append(" inner join t_org_position pos on pm.fPositionId = pos.Fid ");
        sql.append(" inner join t_org_admin org on pos.FAdminOrgUnitId = org.fid ");
        sql.append(" where pm.fIsPrimary = 1 and pm.fpersonId = t_hr_attendanceManager.fpersonId ");
        sql.append(" ) ");
        sql.append(" where t_hr_attendanceManager.FAdminOrgUnitId is null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" update t_hr_leavedetail ");
        sql2.append(" set (FPositionId,FAdminOrgUnitId)= ");
        sql2.append(" ( ");
        sql2.append(" select pos.fid psId,org.fid orgId from t_org_positionMember pm ");
        sql2.append(" inner join t_bd_person person on pm.fpersonId = person.fid ");
        sql2.append(" inner join t_org_position pos on pm.fPositionId = pos.Fid ");
        sql2.append(" inner join t_org_admin org on pos.FAdminOrgUnitId = org.fid ");
        sql2.append(" where pm.fIsPrimary = 1 and pm.fpersonId = t_hr_leavedetail.fpersonId");
        sql2.append(" ) ");
        sql2.append(" where t_hr_leavedetail.FAdminOrgUnitId is null");
        DbUtil.execute((Context)ctx, (String)sql2.toString());
    }

    private void setPosAndorgunitForAdd(Context ctx) throws BOSException, EASBizException {
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("adminOrgUnit", null, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("person.id");
        sic.add("person.name");
        sic.add("position.id");
        sic.add("position.name");
        sic.add("adminorgunit.id");
        sic.add("adminorgunit.name");
        IAttendanceManager dao = AttendanceManagerFactory.getLocalInstance(ctx);
        AttendanceManagerCollection col = dao.getAttendanceManagerCollection(evi);
        if (col == null || col.size() <= 0) {
            return;
        }
        AttendanceManagerInfo amInfo = null;
        ObjectUuidPK pk = null;
        HashSet<String> personIds = new HashSet<String>();
        int j = col.size();
        for (int i = 0; i < j; ++i) {
            amInfo = col.get(i);
            if (amInfo.getPerson() == null) continue;
            personIds.add(amInfo.getPerson().getId().toString());
        }
        Map personAndOrg = this.getPosAndorgunit(ctx, personIds);
        int j2 = col.size();
        for (int i = 0; i < j2; ++i) {
            amInfo = col.get(i);
            pk = new ObjectUuidPK(amInfo.getId());
            if (amInfo.getPerson() == null) continue;
            PersonPositionInfo info = (PersonPositionInfo)personAndOrg.get(amInfo.getPerson().getId());
            amInfo.setPosition(info.getPrimaryPosition());
            amInfo.setAdminOrgUnit(info.getPersonDep());
            this._update(ctx, (IObjectPK)pk, (IObjectValue)amInfo);
        }
    }

    private void setPosAndorgunitForLea(Context ctx) throws BOSException, EASBizException {
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("adminOrgUnit", null, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("person.id");
        sic.add("person.name");
        sic.add("position.id");
        sic.add("position.name");
        sic.add("adminorgunit.id");
        sic.add("adminorgunit.name");
        ILeaveDetail dao = LeaveDetailFactory.getLocalInstance(ctx);
        LeaveDetailCollection col = dao.getLeaveDetailCollection(evi);
        if (col == null || col.size() <= 0) {
            return;
        }
        LeaveDetailInfo leInfo = null;
        ObjectUuidPK pk = null;
        HashSet<String> personIds = new HashSet<String>();
        int j = col.size();
        for (int i = 0; i < j; ++i) {
            leInfo = col.get(i);
            if (leInfo.getPerson() == null) continue;
            personIds.add(leInfo.getPerson().getId().toString());
        }
        Map personAndOrg = this.getPosAndorgunit(ctx, personIds);
        int j2 = col.size();
        for (int i = 0; i < j2; ++i) {
            leInfo = col.get(i);
            pk = new ObjectUuidPK(leInfo.getId());
            if (leInfo.getPerson() == null) continue;
            PersonPositionInfo info = (PersonPositionInfo)personAndOrg.get(leInfo.getPerson().getId());
            leInfo.setPosition(info.getPrimaryPosition());
            leInfo.setAdminOrgUnit(info.getPersonDep());
            LeaveDetailFactory.getLocalInstance(ctx).update((IObjectPK)pk, (CoreBaseInfo)leInfo);
        }
    }

    private Map getPosAndorgunit(Context ctx, Set personIds) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoItem = new FilterInfo();
        filterInfoItem.getFilterItems().add(new FilterItemInfo("person.id", (Object)personIds, CompareType.INCLUDE));
        evi.setFilter(filterInfoItem);
        SelectorItemCollection sic = AttendanceManagerControllerBean.getSic(new String[]{"id", "person.id", "person.name", "primaryPosition.id", "primaryPosition.name", "personDep.id", "personDep.name"});
        evi.setSelector(sic);
        PersonPositionCollection coll = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(evi);
        HashMap<BOSUuid, PersonPositionInfo> personAndOrg = new HashMap<BOSUuid, PersonPositionInfo>();
        if (coll == null || coll.size() <= 0) {
            return null;
        }
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            PersonPositionInfo info = coll.get(i);
            if (info.getPerson() == null) continue;
            personAndOrg.put(info.getPerson().getId(), info);
        }
        return personAndOrg;
    }

    private static SelectorItemCollection getSic(String[] columns) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < columns.length; ++i) {
            sic.add(new SelectorItemInfo(columns[i]));
        }
        return sic;
    }

    protected void _checkPositionAndOrg(Context ctx, List psList, List orgList, String orgId, boolean isInclude) throws BOSException, EASBizException {
        if (psList == null || orgList == null || psList.size() == 0 || orgList.size() == 0 || psList.size() != orgList.size()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(psList), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        evi.setFilter(fi);
        evi.setSelector(sic);
        PositionCollection psColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(evi);
        HashMap<String, String> psIdOrgIdMap = new HashMap<String, String>();
        int j = psColl.size();
        for (int i = 0; i < j; ++i) {
            PositionInfo psInfo = psColl.get(i);
            psIdOrgIdMap.put(psInfo.getId().toString(), psInfo.getAdminOrgUnit().getId().toString());
        }
        HashMap<String, String> longNumMap = new HashMap<String, String>();
        if (isInclude) {
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(orgList), CompareType.INCLUDE));
            SelectorItemCollection sic2 = new SelectorItemCollection();
            sic2.add(new SelectorItemInfo("id"));
            sic2.add(new SelectorItemInfo("longNumber"));
            evi.setFilter(fi);
            evi.setSelector(sic2);
            AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(evi);
            int j2 = orgColl.size();
            for (int i = 0; i < j2; ++i) {
                AdminOrgUnitInfo orgInfo = orgColl.get(i);
                longNumMap.put(orgInfo.getId().toString(), orgInfo.getLongNumber());
            }
        }
        int i = 0;
        int j3 = psList.size();
        int c = 1;
        while (i < j3) {
            Object psId = psList.get(i);
            Object orgUnitId = orgList.get(i);
            if (!TimeServerUtils.isEmpty(psId) && !orgUnitId.equals(psIdOrgIdMap.get(psId).toString())) {
                throw new TimeAttendanceException(TimeAttendanceException.UN_POSITION_ADMINORG, new Object[]{c + ""});
            }
            ++i;
            ++c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectPK[] addnewBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        Connection cn = null;
        IObjectPK[] objectPKArray = null;
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (IObjectValue value : colls) {
                dao.addNewBatch(value);
            }
            objectPKArray = dao.executeBatchWithReturn();
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return objectPKArray;
    }
}

