/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.ICmpPeriod;
import com.kingdee.eas.hr.time.AttendanceManagerFactory;
import com.kingdee.eas.hr.time.AttendanceManagerInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.RefStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AttendanceManagerDataImport
extends AbstractDataTransmission {
    String strRoll_ID = "00000000-0000-0000-0000-000000000001BE0D0183";
    String strwork_ID = "00000000-0000-0000-0000-000000000003BE0D0183";
    private String RES = "com.kingdee.eas.hr.time.LeaveDetailResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.AttendanceManagerDataImport");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AttendanceManagerFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AttendanceManagerInfo info = new AttendanceManagerInfo();
        String str = null;
        try {
            String strDate = (String)((DataToken)hsData.get((Object)"FStartDate")).data;
            if (strDate != null && !strDate.trim().equalsIgnoreCase("")) {
                try {
                    Date sd = DateTimeUtils.parseDate((String)strDate);
                    sd.setSeconds(0);
                    info.setStartDate(sd);
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"0_AttendanceManagerDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                throw new TaskExternalException(this.getString(this.RES, "STARTDATE_NULL", ctx));
            }
            String strDateEnd = (String)((DataToken)hsData.get((Object)"FEndDate")).data;
            if (strDateEnd != null && !strDateEnd.trim().equalsIgnoreCase("")) {
                try {
                    Date ed = DateTimeUtils.parseDate((String)strDateEnd);
                    ed.setSeconds(0);
                    info.setEndDate(ed);
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"0_AttendanceManagerDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                throw new TaskExternalException(this.getString(this.RES, "ENDDATE_NULL", ctx));
            }
            if (info.getStartDate() == null) {
                throw new TaskExternalException(this.getString(this.RES, "STARTDATE_NULL", ctx));
            }
            if (info.getEndDate() == null) {
                throw new TaskExternalException(this.getString(this.RES, "ENDDATE_NULL", ctx));
            }
            if (info.getEndDate().before(info.getStartDate())) {
                throw new TaskExternalException(this.getString(this.RES, "STARTDATE_ENDDATE_ERROR", ctx));
            }
            str = ((DataToken)hsData.get((Object)"FEmployeeNumber")).data.toString();
            if (str == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(this.getString(this.RES, "PNUMBER", ctx) + str + this.getString(this.RES, "NOTNULL", ctx));
            }
            PersonInfo pInfo = this.getPersonInfo(ctx, str, true);
            info.setPerson(pInfo);
            str = ((DataToken)hsData.get((Object)"FREmployeeNumber")).data.toString();
            if (str != null && !"".equalsIgnoreCase(str.trim())) {
                PersonInfo prInfo = this.getPersonInfo(ctx, str, false);
                info.setRecordPerson(prInfo);
            }
            if ((str = ((DataToken)hsData.get((Object)"FAttendanceNumber")).data.toString()) == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(this.getString(this.RES, "INUMBER", ctx) + str + this.getString(this.RES, "NOTNULL", ctx));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)this.strRoll_ID));
            filterInfo.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)this.strwork_ID));
            filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)"1"));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)str));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
            filterInfo.setMaskString("(#0  or #1) and #2 and #3 and (#4 or #5)");
            viewInfo.setFilter(filterInfo);
            ITimeAttendance iTime = TimeAttendanceFactory.getLocalInstance(ctx);
            TimeAttendanceCollection timeColl = iTime.getTimeAttendanceCollection(viewInfo);
            if (timeColl == null || timeColl.size() == 0) {
                throw new TaskExternalException(this.getString(this.RES, "INUMBER", ctx) + str + this.getString(this.RES, "NOTFOUND", ctx));
            }
            info.setAttendance(timeColl.get(0));
            str = (String)((DataToken)hsData.get((Object)"FCmpPeriodNumber")).data;
            if (str != null && str.length() > 0) {
                viewInfo = new EntityViewInfo();
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("enableState", (Object)"0"));
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)str));
                filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
                viewInfo.setFilter(filterInfo);
                ICmpPeriod iCmp = CmpPeriodFactory.getLocalInstance((Context)ctx);
                CmpPeriodCollection cmpColl = iCmp.getCmpPeriodCollection(viewInfo);
                if (cmpColl == null || cmpColl.size() == 0) {
                    throw new TaskExternalException(this.getString(this.RES, "CMPNUMBER", ctx) + " '" + str + "' " + this.getString(this.RES, "NOTFOUND", ctx));
                }
                info.setCmpPeriod(cmpColl.get(0));
            }
            if ((str = ((DataToken)hsData.get((Object)"FTotalValue")).data.toString()) == null || str.trim().equalsIgnoreCase("")) {
                throw new TaskExternalException(this.getString(this.RES, "TOTAL", ctx) + str + this.getString(this.RES, "NOTNULL", ctx));
            }
            info.setTotalValue(Float.parseFloat(str));
            info.setCheckState(CheckStateEnum.UNCHECK);
            info.setRefrence(RefStateEnum.UNREF);
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            AttendanceManagerInfo attendInfo = null;
            if (coreBaseInfo != null) {
                attendInfo = (AttendanceManagerInfo)coreBaseInfo;
                if (this.isSltImportUpdate()) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("person", (Object)attendInfo.getPerson().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)attendInfo.getStartDate()));
                    filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)attendInfo.getEndDate()));
                    filter.getFilterItems().add(new FilterItemInfo("attendance.id", (Object)attendInfo.getAttendance().getId().toString()));
                    AttendanceManagerFactory.getLocalInstance(ctx).delete(filter);
                }
                AttendanceManagerFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)attendInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private PersonInfo getPersonInfo(Context ctx, String str, boolean isNeed) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)str));
        view.setFilter(filterInfo);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personColl = iPerson.getPersonCollection(view);
        if (personColl == null || personColl.size() == 0) {
            if (isNeed) {
                throw new TaskExternalException(this.getString(this.RES, "PNUMBER", ctx) + str + this.getString(this.RES, "NOTFOUND", ctx));
            }
            return null;
        }
        return personColl.get(0);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        try {
            table.put("FEmployeeNumber", rs.getString("person.number"));
            table.put("FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase(), rs.getString("person.name"));
            table.put("FAttendanceNumber", rs.getString("attendance.number"));
            table.put("FTotalValue", rs.getString("totalValue"));
            table.put("FStartDate", rs.getDate("startDate"));
            table.put("FEndDate", rs.getDate("endDate"));
            table.put("FCmpPeriodNumber", rs.getString("cmpPeriod.number"));
            table.put("FREmployeeNumber", rs.getString("recordPerson.number"));
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return table;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.time.app.AttendanceManagerQuery";
    }

    private String getString(String res, String key, Context ctx) {
        return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale());
    }
}

