/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.compensation.CmpPeriodCollection;
import com.kingdee.eas.hr.compensation.CmpPeriodFactory;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.time.AttendanceManagerFactory;
import com.kingdee.eas.hr.time.AttendanceManagerInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.DataSourceEnum;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.RefStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.app.AbstractAttendanceManagerImportFacadeControllerBean;
import com.kingdee.eas.hr.time.app.TimeServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttendanceManagerImportFacadeControllerBean
extends AbstractAttendanceManagerImportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.AttendanceManagerImportFacadeControllerBean");
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean isRelateOrg = false;
    private boolean isHandleError = false;
    private PersonInfo operator;
    private HROrgUnitInfo hrInfo;
    Map taNumInfoMap;
    private Map pNumInfoMap = new HashMap();
    Map outOrgRangePNumInfoMap = new HashMap();
    private Map pNumPositionMap = new HashMap();
    private Set importedData = new HashSet();
    private Set hrAndAdminRangeSet = new HashSet();
    private boolean isHoliday = false;
    private DecimalFormat df = new DecimalFormat("#.0");

    protected Map _importAttendanceData(Context ctx, List list, boolean isOverImport, int errorHandleMode, boolean isHolidayImp) throws BOSException, EASBizException {
        if (list == null || list.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        this.initData(ctx, list, isOverImport, errorHandleMode, isHolidayImp);
        if (this.taNumInfoMap == null || this.taNumInfoMap.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        int rowCount = 5;
        boolean hasError = false;
        StringBuffer errorStr = new StringBuffer();
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            Map valueMap = (Map)list.get(i);
            if (valueMap == null || valueMap.size() <= 0) continue;
            Set attNumSet = (Set)valueMap.get("attendanceSet");
            if (attNumSet == null || attNumSet.size() <= 0) {
                ++rowCount;
                continue;
            }
            try {
                Map infoMap = this.getValue(ctx, valueMap, this.isRelateOrg);
                if (infoMap == null || infoMap.size() == 0) {
                    ++rowCount;
                    continue;
                }
                if (!isOverImport) {
                    this.checkDuplicateData(infoMap, ctx);
                }
                this.updateAttendanceData(ctx, valueMap, infoMap, isOverImport);
            }
            catch (Exception e) {
                hasError = true;
                if (this.isHandleError) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + rowCount + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"2_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                }
                errorStr.append(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale())).append(rowCount).append(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"2_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale())).append(e.getMessage()).append("\n");
                ++rowCount;
                continue;
            }
            ++rowCount;
        }
        resultMap.put("hasError", hasError);
        resultMap.put("errorStr", errorStr.toString());
        return resultMap;
    }

    private void initData(Context ctx, List list, boolean isOverImport, int errorHandleMode, boolean isHolidayImp) throws BOSException, EASBizException {
        this.isHandleError = errorHandleMode == 1;
        this.isHoliday = isHolidayImp;
        this.isRelateOrg = TimeServerUtils.getParamValue(ctx, "AttendanceData_Relate_OrgUnit");
        this.operator = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        this.hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        this.hrAndAdminRangeSet = this.getHRAndAdminOrgRange(ctx, this.hrInfo.getId().toString());
        this.taNumInfoMap = this.getAttendance(ctx);
        HashSet<String> pNumSet = new HashSet<String>();
        HashSet<String> poNullPNumSet = new HashSet<String>();
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            Map map = (Map)list.get(i);
            if (map == null || map.size() <= 0) continue;
            String pNum = map.get("personNumber").toString();
            if (!"null".equals(pNum)) {
                pNumSet.add(pNum);
            }
            if (!TimeServerUtils.isEmpty(map.get("position")) || !TimeServerUtils.isEmpty(map.get("adminOrgUnit"))) continue;
            poNullPNumSet.add(pNum);
        }
        this.pNumInfoMap = this.getPersons(ctx, pNumSet, true);
        HashSet<String> outOrgRangePNum = new HashSet<String>();
        Iterator it = pNumSet.iterator();
        while (it.hasNext()) {
            String str = it.next().toString();
            if (this.pNumInfoMap.containsKey(str)) continue;
            outOrgRangePNum.add(str);
        }
        this.outOrgRangePNumInfoMap = this.getPersons(ctx, outOrgRangePNum, false);
        this.pNumPositionMap = this.getPositionAndOrg(ctx, poNullPNumSet);
    }

    private Map getValue(Context ctx, Map valueMap, boolean isRelateOrg) throws Exception {
        String commet;
        PersonInfo pInfo;
        if (valueMap == null || valueMap.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String pNum = valueMap.get("personNumber").toString().trim();
        boolean isInnerOrgRange = true;
        if (this.pNumInfoMap.containsKey(pNum)) {
            isInnerOrgRange = true;
            pInfo = (PersonInfo)this.pNumInfoMap.get(pNum.trim());
            map.put("pNum", pNum);
            map.put("pInfo", pInfo);
        } else if (this.outOrgRangePNumInfoMap.containsKey(pNum)) {
            isInnerOrgRange = false;
            pInfo = (PersonInfo)this.outOrgRangePNumInfoMap.get(pNum.trim());
            map.put("pNum", pNum);
            map.put("pInfo", pInfo);
        } else {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"3_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        Date bDate = this.getDate(valueMap.get("beginDate"), true, ctx);
        map.put("bDate", bDate);
        Date eDate = this.getDate(valueMap.get("endDate"), false, ctx);
        map.put("eDate", eDate);
        Object[] po = this.getPositionAndOrgInfo(ctx, valueMap, isRelateOrg, isInnerOrgRange);
        if (po == null || po.length != 2 || po[1] == null) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"4_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        map.put("psInfo", po[0]);
        map.put("orgInfo", po[1]);
        if (valueMap.get("memo") != null && (commet = valueMap.get("memo").toString().trim()) != null && commet.length() > 80) {
            throw new Exception("\u5907\u6ce8\u4fe1\u606f\u8d85\u8fc780\u4e2a\u5b57\uff0c\u8bf7\u4fee\u6539\uff01");
        }
        Object value = valueMap.get("cmpScheme");
        if (!TimeServerUtils.isEmpty(value)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)value.toString().trim()));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrInfo.getId().toString()));
            evi.setFilter(fi);
            CmpSchemeCollection csColl = CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeCollection(evi);
            if (csColl.size() > 0) {
                map.put("csInfo", csColl.get(0));
            }
        }
        if (!TimeServerUtils.isEmpty(value = valueMap.get("cmpPeriod"))) {
            StringBuffer sqlWhere = new StringBuffer();
            sqlWhere.append("where number = '").append(value.toString().trim()).append("'");
            sqlWhere.append(" and hrOrgUnit.id = '").append(this.hrInfo.getId().toString()).append("'");
            CmpPeriodCollection cpColl = CmpPeriodFactory.getLocalInstance((Context)ctx).getCmpPeriodCollection(sqlWhere.toString());
            if (cpColl.size() > 0) {
                map.put("cpInfo", cpColl.get(0));
            }
        }
        Object memo = valueMap.get("memo");
        map.put("memo", memo);
        return map;
    }

    void checkDuplicateData(Map infoMap, Context ctx) throws Exception {
        if (infoMap == null || this.importedData == null) {
            return;
        }
        String pNum = infoMap.get("pNum").toString();
        AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)infoMap.get("orgInfo");
        Date bDate = (Date)infoMap.get("bDate");
        Date eDate = (Date)infoMap.get("eDate");
        String key = pNum + orgInfo.getNumber() + this.format.format(bDate) + this.format.format(eDate);
        if (this.importedData.contains(key)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"5_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + pNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"6_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        this.importedData.add(key);
    }

    private void updateAttendanceData(Context ctx, Map valueMap, Map infoMap, boolean isOverImport) throws Exception {
        Object amDAO;
        TimeAttendanceInfo taInfo;
        if (valueMap == null || infoMap == null || valueMap.size() == 0 || infoMap.size() == 0) {
            return;
        }
        Set attNumSet = (Set)valueMap.get("attendanceSet");
        PersonInfo pInfo = (PersonInfo)infoMap.get("pInfo");
        AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)infoMap.get("orgInfo");
        PositionInfo psInfo = (PositionInfo)infoMap.get("psInfo");
        Date bDate = (Date)infoMap.get("bDate");
        Date eDate = (Date)infoMap.get("eDate");
        Object memo = infoMap.get("memo");
        CmpPeriodInfo cpInfo = (CmpPeriodInfo)infoMap.get("cpInfo");
        CmpSchemeInfo csInfo = (CmpSchemeInfo)infoMap.get("csInfo");
        float totalValue = 0.0f;
        HashSet delAttNumSet = new HashSet(attNumSet);
        CoreBaseCollection coll = new CoreBaseCollection();
        Iterator it2 = attNumSet.iterator();
        while (it2.hasNext()) {
            ObjectBaseInfo amInfo;
            String attNumber = it2.next().toString().trim();
            if (!this.taNumInfoMap.containsKey(attNumber) || valueMap.get(attNumber) == null || !StringUtils.isNotEmpty((String)valueMap.get(attNumber).toString())) continue;
            taInfo = (TimeAttendanceInfo)this.taNumInfoMap.get(attNumber);
            boolean isExist = this.existCheckedData(ctx, pInfo.getId().toString(), taInfo.getId().toString(), bDate, eDate, orgInfo.getId().toString(), isOverImport);
            if (isExist) {
                if (isOverImport) {
                    throw new Exception(taInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"7_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
                }
                throw new Exception(taInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"8_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            String length = valueMap.get(attNumber).toString();
            if (length == null || length.trim().length() <= 0) {
                delAttNumSet.remove(attNumber);
                continue;
            }
            BigDecimal lastUnit = null;
            if (ItemDataTypeEnum.INT.getValue() == taInfo.getDataType().getValue()) {
                totalValue = this.strToInt(length, taInfo.getLength(), taInfo.getName(), ctx);
                if (taInfo.getLastUnit() != null && taInfo.getLastUnit().floatValue() > 0.0f && totalValue > 0.0f) {
                    lastUnit = taInfo.getLastUnit();
                    int a = (int)(totalValue * 100.0f);
                    int b = (int)(taInfo.getLastUnit().floatValue() * 100.0f);
                    if (a % b != 0) {
                        throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"72_LeaveBillSelfEditUI", (Locale)ctx.getLocale()) + lastUnit.floatValue() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils", (Locale)ctx.getLocale()));
                    }
                }
            } else {
                totalValue = this.strToFloat(length, taInfo.getLength(), taInfo.getDecDigital(), taInfo.getName(), ctx);
                if (taInfo.getLastUnit() != null && taInfo.getLastUnit().floatValue() > 0.0f && totalValue > 0.0f) {
                    lastUnit = taInfo.getLastUnit();
                    int a = (int)(totalValue * 100.0f);
                    int b = (int)(taInfo.getLastUnit().floatValue() * 100.0f);
                    if (a % b != 0) {
                        throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"72_LeaveBillSelfEditUI", (Locale)ctx.getLocale()) + lastUnit.floatValue() + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils", (Locale)ctx.getLocale()));
                    }
                }
            }
            if (this.isHoliday) {
                amInfo = new LeaveDetailInfo();
                amInfo.setTimeAttendance(taInfo);
                amInfo.setTotalRegReal(new BigDecimal(totalValue));
                amInfo.setPerson(pInfo);
                Calendar c = Calendar.getInstance();
                c.setTime(bDate);
                amInfo.setStartDateReal(new Timestamp(c.getTimeInMillis()));
                c.setTime(eDate);
                amInfo.setEndDateReal(new Timestamp(c.getTimeInMillis()));
                amInfo.setCmpPeriod(cpInfo);
                amInfo.setHrOrgUnit(this.hrInfo);
                amInfo.setDataOfSource(DataSourceEnum.LEAVEREG);
                amInfo.setPosition(psInfo);
                amInfo.setAdminOrgUnit(orgInfo);
                amInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                if (memo != null) {
                    amInfo.setComment(memo.toString());
                }
                amInfo.setCheckState(CheckStateEnum.UNCHECK);
                amInfo.setRefrence(false);
                if (this.isRelateOrg && csInfo != null) {
                    amInfo.setCmpScheme(csInfo);
                }
                coll.add((CoreBaseInfo)amInfo);
                continue;
            }
            amInfo = new AttendanceManagerInfo();
            amInfo.setAttendance(taInfo);
            amInfo.setTotalValue(totalValue);
            amInfo.setPerson(pInfo);
            amInfo.setRecordPerson(this.operator);
            amInfo.setStartDate(bDate);
            amInfo.setEndDate(eDate);
            amInfo.setCmpPeriod(cpInfo);
            amInfo.setHrOrgUnit(this.hrInfo);
            amInfo.setPosition(psInfo);
            amInfo.setAdminOrgUnit(orgInfo);
            if (memo != null) {
                amInfo.setDescription(memo.toString());
            }
            amInfo.setCheckState(CheckStateEnum.UNCHECK);
            amInfo.setRefrence(RefStateEnum.UNREF);
            if (this.isRelateOrg && csInfo != null) {
                amInfo.setCmpScheme(csInfo);
            }
            coll.add((CoreBaseInfo)amInfo);
        }
        if (isOverImport && delAttNumSet.size() > 0) {
            HashSet<String> attIdSet = new HashSet<String>();
            Iterator it1 = delAttNumSet.iterator();
            while (it1.hasNext()) {
                String attNumber = it1.next().toString();
                if (!this.taNumInfoMap.containsKey(attNumber)) continue;
                taInfo = (TimeAttendanceInfo)this.taNumInfoMap.get(attNumber);
                attIdSet.add(taInfo.getId().toString());
            }
            this.deleteData(ctx, pInfo.getId().toString(), attIdSet, bDate, eDate, orgInfo.getId().toString());
        }
        if (this.isHoliday) {
            amDAO = LeaveDetailFactory.getLocalInstance(ctx);
            if (coll.size() > 0) {
                amDAO.addnewBatchData(coll);
            }
        } else {
            amDAO = AttendanceManagerFactory.getLocalInstance(ctx);
            if (coll.size() > 0) {
                amDAO.addnewBatchData(coll);
            }
        }
    }

    private Map getPositionAndOrg(Context ctx, Set pNumSet) throws BOSException {
        if (pNumSet == null || pNumSet.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, PositionInfo> map = new HashMap<String, PositionInfo>(pNumSet.size() * 3 / 4);
        StringBuffer temp = new StringBuffer();
        int i = 0;
        Iterator it = pNumSet.iterator();
        while (it.hasNext()) {
            if (i != 0) {
                temp.append(",");
            }
            temp.append("'").append(it.next().toString()).append("'");
            ++i;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.FNumber pNum,pm.fPositionId psId,admin.FID orgId ");
        sql.append(" from T_ORG_PositionMember pm ");
        sql.append(" left join t_bd_person person on pm.fpersonId = person.fid ");
        sql.append(" left join T_ORG_Position position on pm.FPositionID = position.FID ");
        sql.append(" left join T_ORG_Admin admin on position.FAdminOrgUnitID = admin.FID ");
        sql.append(" where pm.fIsPrimary = 1 and person.FNumber in(");
        sql.append(temp.toString());
        sql.append(" ) ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (result.next()) {
                String pNum = result.getString("pNum");
                String psId = result.getString("psId");
                String orgId = result.getString("orgId");
                if (pNum == null || psId == null || orgId == null) continue;
                AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)orgId));
                PositionInfo psInfo = new PositionInfo();
                psInfo.setId(BOSUuid.read((String)psId));
                psInfo.setAdminOrgUnit(orgInfo);
                map.put(pNum, psInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return map;
    }

    private Date getDate(Object value, boolean isBeginDate, Context ctx) throws Exception {
        Date date = null;
        if (TimeServerUtils.isEmpty(value)) {
            if (isBeginDate) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"9_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"10_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        try {
            value = value.toString().trim();
            date = value.toString().length() == 10 ? this.format.parse(value.toString() + " " + "00:00:00") : this.format.parse(value.toString());
        }
        catch (ParseException e) {
            if (isBeginDate) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"11_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"12_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return date;
    }

    private Object[] getPositionAndOrgInfo(Context ctx, Map valueMap, boolean isRelateOrg, boolean isInnerOrgRange) throws Exception {
        if (valueMap == null) {
            return null;
        }
        String pNum = valueMap.get("personNumber").toString().trim();
        String pId = null;
        if (this.pNumInfoMap.containsKey(pNum)) {
            pId = ((PersonInfo)this.pNumInfoMap.get(pNum)).getId().toString();
        } else if (this.outOrgRangePNumInfoMap.containsKey(pNum)) {
            pId = ((PersonInfo)this.outOrgRangePNumInfoMap.get(pNum)).getId().toString();
        }
        if (pId == null) {
            return null;
        }
        Object psNum = valueMap.get("position");
        Object orgNum = valueMap.get("adminOrgUnit");
        PositionInfo psInfo = null;
        AdminOrgUnitInfo orgInfo = null;
        if (TimeServerUtils.isEmpty(psNum) && TimeServerUtils.isEmpty(orgNum)) {
            boolean isNoPositionPerson = this.isNoPositionPerson(ctx, pId);
            if (isNoPositionPerson) {
                orgInfo = this.getPersonDep(ctx, pId);
                return new Object[]{null, orgInfo};
            }
            if (!isInnerOrgRange) {
                if (isRelateOrg) {
                    psInfo = this.getPositionFromJZ(ctx, pId);
                    if (psInfo == null) {
                        psInfo = this.getPositionFromWorkExp(ctx, pId);
                    }
                    if (psInfo != null) {
                        orgInfo = psInfo.getAdminOrgUnit();
                    }
                } else {
                    psInfo = (PositionInfo)this.pNumPositionMap.get(pNum);
                    if (psInfo != null) {
                        orgInfo = psInfo.getAdminOrgUnit();
                    }
                }
            } else {
                psInfo = (PositionInfo)this.pNumPositionMap.get(pNum);
                if (psInfo != null) {
                    orgInfo = psInfo.getAdminOrgUnit();
                }
            }
        } else if (TimeServerUtils.isEmpty(psNum) && !TimeServerUtils.isEmpty(orgNum)) {
            AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where number = '" + orgNum + "'");
            if (orgColl.size() == 0) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"13_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + orgNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"14_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            orgInfo = orgColl.get(0);
            if (!this.hrAndAdminRangeSet.contains(orgInfo.getId().toString())) {
                orgInfo = null;
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"15_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + orgNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"16_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (!TimeServerUtils.isEmpty(psNum) && TimeServerUtils.isEmpty(orgNum)) {
            PositionCollection psColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("where number = '" + psNum + "'");
            if (psColl.size() == 0) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"13_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + psNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"17_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            psInfo = psColl.get(0);
            if (!this.hrAndAdminRangeSet.contains(psInfo.getAdminOrgUnit().getId().toString())) {
                psInfo = null;
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"15_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + psNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"18_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            orgInfo = psInfo.getAdminOrgUnit();
        } else {
            PositionCollection psColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("where number = '" + psNum + "'");
            AdminOrgUnitCollection orgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where number = '" + orgNum + "'");
            if (orgColl.size() == 0) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"13_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + orgNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"14_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            if (psColl.size() == 0) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"13_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + psNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"17_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            psInfo = psColl.get(0);
            orgInfo = orgColl.get(0);
            if (!psInfo.getAdminOrgUnit().getId().toString().equals(orgInfo.getId().toString())) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"19_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + psNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"17_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"20_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + orgNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"21_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
            if (!this.hrAndAdminRangeSet.contains(orgInfo.getId().toString())) {
                psInfo = null;
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"15_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()) + orgNum + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"22_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
            }
        }
        return new Object[]{psInfo, orgInfo};
    }

    private boolean existCheckedData(Context ctx, String pId, String attId, Date bDate, Date eDate, String orgId, boolean isOverImport) throws EASBizException, BOSException {
        if (pId == null || attId == null || bDate == null || eDate == null) {
            return false;
        }
        if (this.isHoliday) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId));
            fi.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)attId));
            fi.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)bDate));
            fi.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)eDate));
            fi.getFilterItems().add(new FilterItemInfo("dataOfSource", (Object)DataSourceEnum.LEAVEREG));
            if (isOverImport) {
                fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)CheckStateEnum.CHECK));
            }
            fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)orgId));
            return LeaveDetailFactory.getLocalInstance(ctx).exists(fi);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId));
        fi.getFilterItems().add(new FilterItemInfo("attendance.id", (Object)attId));
        fi.getFilterItems().add(new FilterItemInfo("startDate", (Object)bDate));
        fi.getFilterItems().add(new FilterItemInfo("endDate", (Object)eDate));
        if (isOverImport) {
            fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)CheckStateEnum.CHECK));
        }
        fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)orgId));
        return AttendanceManagerFactory.getLocalInstance(ctx).exists(fi);
    }

    private void deleteData(Context ctx, String pId, Set attIdSet, Date bDate, Date eDate, String orgId) throws EASBizException, BOSException {
        if (pId == null || attIdSet == null || attIdSet.size() <= 0 || bDate == null || eDate == null) {
            return;
        }
        if (this.isHoliday) {
            Calendar c = Calendar.getInstance();
            c.setTime(bDate);
            Timestamp bd = new Timestamp(c.getTimeInMillis());
            c.setTime(eDate);
            Timestamp ed = new Timestamp(c.getTimeInMillis());
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId));
            fi.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)attIdSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)bd));
            fi.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)ed));
            fi.getFilterItems().add(new FilterItemInfo("dataOfSource", (Object)DataSourceEnum.LEAVEREG));
            fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)CheckStateEnum.UNCHECK));
            fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)orgId));
            LeaveDetailFactory.getLocalInstance(ctx).delete(fi);
        } else {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId));
            fi.getFilterItems().add(new FilterItemInfo("attendance.id", (Object)attIdSet, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("startDate", (Object)bDate));
            fi.getFilterItems().add(new FilterItemInfo("endDate", (Object)eDate));
            fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)CheckStateEnum.UNCHECK));
            fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)orgId));
            AttendanceManagerFactory.getLocalInstance(ctx).delete(fi);
        }
    }

    private int strToInt(String str, int maxLength, String colName, Context ctx) throws Exception {
        int i;
        if (str == null) {
            return -1;
        }
        str = str.trim();
        Pattern p = Pattern.compile("^[1-9]\\d*|0$");
        if (!p.matcher(str).matches()) {
            throw new Exception(colName + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"23_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (str.length() > maxLength) {
            throw new Exception(colName + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"24_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new BOSException(colName + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"25_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return i;
    }

    private float strToFloat(String str, int maxLength, int digital, String colName, Context ctx) throws Exception {
        if (str == null) {
            return -1.0f;
        }
        str = str.trim();
        Pattern p = Pattern.compile("^(\\d+)(\\.\\d+)?$");
        if (!p.matcher(str).matches()) {
            throw new Exception(colName + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"26_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        int length = 0;
        length = str.indexOf(".") < 0 ? str.length() : str.length() - 1;
        if (length > maxLength) {
            throw new Exception(colName + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"27_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        DecimalFormat tempDf = this.adjustFormat(this.df, digital);
        float f = 0.0f;
        try {
            f = Float.parseFloat(str);
            Number number = tempDf.parse(tempDf.format(f));
            if (number != null) {
                f = number.floatValue();
            }
        }
        catch (Exception e) {
            throw new Exception(colName + ResourceBase.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"25_AttendanceManagerImportFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return f;
    }

    private DecimalFormat adjustFormat(DecimalFormat df, int i) {
        switch (i) {
            case 0: {
                df.applyPattern("#.0");
                break;
            }
            case 1: {
                df.applyPattern("#.0");
                break;
            }
            case 2: {
                df.applyPattern("#.00");
                break;
            }
            default: {
                df.applyPattern("#.00");
            }
        }
        return df;
    }

    private Map getAttendance(Context ctx) throws EASBizException, BOSException {
        FilterInfo fi;
        EntityViewInfo evi;
        TimeAttendanceCollection coll = null;
        if (this.isHoliday) {
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000002BE0D0183"));
            fi.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrInfo.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
            fi.setMaskString("#0 and #1 and (#2 or #3)");
            evi.setFilter(fi);
            coll = TimeAttendanceFactory.getLocalInstance(ctx).getTimeAttendanceCollection(evi);
        } else {
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000001BE0D0183"));
            fi.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000003BE0D0183"));
            fi.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.hrInfo.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
            fi.setMaskString("(#0 or #1) and #2 and (#3 or #4)");
            evi.setFilter(fi);
            coll = TimeAttendanceFactory.getLocalInstance(ctx).getTimeAttendanceCollection(evi);
        }
        LinkedHashMap<String, TimeAttendanceInfo> numberInfoMap = new LinkedHashMap<String, TimeAttendanceInfo>();
        if (coll != null && coll.size() > 0) {
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                TimeAttendanceInfo info = coll.get(i);
                numberInfoMap.put(info.getNumber(), info);
            }
        }
        return numberInfoMap;
    }

    private Map getPersons(Context ctx, Set pNumSet, boolean isOrgRangeFilter) throws EASBizException, BOSException {
        if (pNumSet == null || pNumSet.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)pNumSet, CompareType.INCLUDE));
        if (isOrgRangeFilter) {
            FilterInfo fi2 = this.getAdminRangePersonFilter(ctx, "id");
            fi.mergeFilter(fi2, "and");
        }
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        PersonCollection pColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
        HashMap<String, PersonInfo> resultMap = new HashMap<String, PersonInfo>();
        int j = pColl.size();
        for (int i = 0; i < j; ++i) {
            PersonInfo pInfo = pColl.get(i);
            resultMap.put(pInfo.getNumber(), pInfo);
        }
        return resultMap;
    }

    private Set getHRAndAdminOrgRange(Context ctx, String hrOrgId) throws BOSException {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        HashSet<String> set = new HashSet<String>();
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (row.next()) {
                set.add(row.getString("FFromUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return set;
    }

    private FilterInfo getAdminRangePersonFilter(Context ctx, String colName) {
        if (colName == null || colName.trim().length() <= 0) {
            return new FilterInfo();
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.FID from T_BD_PERSON person ");
        sql.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        sql.append(" where pp.fpersonDep in ( ");
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append("))");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(colName, (Object)sql.toString(), CompareType.INNER));
        return fi;
    }

    private FilterInfo getHRAndAdminRangeFilterInfo(Context ctx, String hrColumnName, String orgUnitColumnName) {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID);
        filter.getFilterItems().add(item);
        return filter;
    }

    private PositionInfo getPositionFromJZ(Context ctx, String pId) throws BOSException {
        if (pId == null) {
            return null;
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select pm.FPositionId psId,org.FId orgId,org.fnumber num from t_org_PositionMember pm ");
        sql.append(" left join t_org_position p on pm.FpositionId = p.fid ");
        sql.append(" left join t_org_admin org on p.FadminOrgUnitId = org.fid ");
        sql.append(" where pm.FPersonId = ").append("'").append(pId).append("'");
        sql.append(" and  pm.FIsPrimary = 0 ");
        sql.append(" and org.fid in ");
        sql.append(" ( ");
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(this.hrInfo.getId().toString());
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        sql.append(" ) ");
        sql.append(" order by pm.FCreateTime desc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String psId = null;
        String orgId = null;
        String num = null;
        try {
            if (row.next()) {
                psId = row.getString("psId");
                orgId = row.getString("orgId");
                num = row.getString("num");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (psId != null && orgId != null) {
            PositionInfo psInfo = new PositionInfo();
            psInfo.setId(BOSUuid.read((String)psId));
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgId));
            orgInfo.setNumber(num);
            psInfo.setAdminOrgUnit(orgInfo);
            return psInfo;
        }
        return null;
    }

    private PositionInfo getPositionFromWorkExp(Context ctx, String pId) throws BOSException {
        if (pId == null) {
            return null;
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select pw.FPositionId psId,pw.FDeptId orgId,org.fnumber num from t_hr_PersonWorkExpCur pw");
        sql.append(" left join t_org_admin org on pw.FDeptId = org.FId ");
        sql.append(" where pw.FPersonId =").append("'").append(pId).append("'");
        sql.append(" and pw.FDeptID in ");
        sql.append(" ( ");
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(this.hrInfo.getId().toString());
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        sql.append(" ) ");
        sql.append(" order by pw.FCreateTime desc ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String psId = null;
        String orgId = null;
        String num = null;
        try {
            if (row.next()) {
                psId = row.getString("psId");
                orgId = row.getString("orgId");
                num = row.getString("num");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (psId != null && orgId != null) {
            PositionInfo psInfo = new PositionInfo();
            psInfo.setId(BOSUuid.read((String)psId));
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgId));
            orgInfo.setNumber(num);
            psInfo.setAdminOrgUnit(orgInfo);
            return psInfo;
        }
        return null;
    }

    private boolean isNoPositionPerson(Context ctx, String pId) throws BOSException, EASBizException {
        String sql = "where person.id = '" + pId + "'";
        return !PositionMemberFactory.getLocalInstance((Context)ctx).exists(sql);
    }

    private AdminOrgUnitInfo getPersonDep(Context ctx, String pId) throws BOSException, EASBizException {
        if (pId == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fid id,org.fnumber num from T_HR_PersonPosition pp ");
        sql.append(" left join t_org_admin org on pp.FPersonDep = org.fid ");
        sql.append(" where pp.FPersonId =").append("'").append(pId).append("'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String orgId = null;
        String num = null;
        try {
            if (row.next()) {
                orgId = row.getString("id");
                num = row.getString("num");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (orgId != null) {
            AdminOrgUnitInfo orgInfo = new AdminOrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)orgId));
            orgInfo.setNumber(num);
            return orgInfo;
        }
        return null;
    }

    protected Map _saveAttendanceData(Context ctx, Map map, boolean isOverImport, int errorHandleMode, String personId) throws BOSException, EASBizException {
        return Collections.EMPTY_MAP;
    }
}

