/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.benefit.util.BenefitUtils;
import com.kingdee.eas.hr.time.CmpRefCollection;
import com.kingdee.eas.hr.time.CmpRefFactory;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogInfo;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.app.AbstractLeaveAndAttendanceReportControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LeaveAndAttendanceReportControllerBean
extends AbstractLeaveAndAttendanceReportControllerBean {
    private static final long serialVersionUID = -61166L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.app.LeaveAndAttendanceReportControllerBean");
    public String localString;

    public String getLocal(Context ctx) {
        this.localString = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        return this.localString;
    }

    protected IRowSet _getInitHeaderAtt(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String[] reference, int refrence, boolean isLowLevel) throws BOSException, EASBizException {
        int len;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ATTENDANCE.FID, ATTENDANCE.FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(",ATTENDANCE.FUnitType ");
        strBuffer.append("FROM T_HR_AttendanceManager AS ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance AS ATTENDANCE ON ATTENDANCEMANAGER.FAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person AS PERSON ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOSITION ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position AS POSITION ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        if (beginDate != null && endDate != null) {
            strBuffer.append("where ATTENDANCEMANAGER.FSTARTDATE <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and ATTENDANCEMANAGER.FENDDATE >= ");
            strBuffer.append(this.getSqlDate(beginDate));
        }
        if (adminOrgUtil != null && isLowLevel) {
            strBuffer.append(" and (ADMINORGUNIT.FLongNumber = '");
            strBuffer.append(adminOrgUtil);
            strBuffer.append("' or ");
            strBuffer.append(" ADMINORGUNIT.FLongNumber like '");
            strBuffer.append(adminOrgUtil + "!%");
            strBuffer.append("') ");
        } else if (adminOrgUtil != null && !isLowLevel) {
            strBuffer.append(" and ADMINORGUNIT.FLongNumber = '");
            strBuffer.append(adminOrgUtil);
            strBuffer.append("'");
        }
        if (cuOrgInfo != null) {
            strBuffer.append(" and ADMINORGUNIT.FID IN (");
            strBuffer.append(cuOrgInfo);
            strBuffer.append(")");
        }
        if (person != null) {
            strBuffer.append(" and PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("'");
        }
        if (checkState == 0) {
            strBuffer.append(" and ATTENDANCEMANAGER.FCHECKSTATE = 0 ");
        } else if (checkState == 1) {
            strBuffer.append(" and ATTENDANCEMANAGER.FCHECKSTATE = 1 ");
        } else {
            strBuffer.append("");
        }
        if (refrence == 0) {
            strBuffer.append(" and ATTENDANCEMANAGER.Frefrence = 0 ");
        } else if (refrence == 1) {
            strBuffer.append(" and ATTENDANCEMANAGER.Frefrence = 1 ");
        } else {
            strBuffer.append("");
        }
        if (reference != null && reference.length > 0 && reference[(len = reference.length) - 1] != null && reference[len - 1].length() > 0) {
            strBuffer.append(" and (");
            int size = len - 1;
            for (int i = 0; i < size; ++i) {
                strBuffer.append(reference[i]);
                strBuffer.append(" or ");
            }
            strBuffer.append(reference[len - 1]);
            strBuffer.append(")");
        }
        strBuffer.append(" GROUP BY ATTENDANCE.FID,ATTENDANCE.FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(",ATTENDANCE.FUnitType");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = iQe.executeSQL();
        return row;
    }

    protected IRowSet _getInitHeaderLeave(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String person, int personType, int checkState, String[] reference, int refrence, String cuOrgInfo, boolean isLowLevel) throws BOSException, EASBizException {
        int len;
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ATTENDANCE.FID, ATTENDANCE.FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(", ATTENDANCE.FUnitType FROM T_HR_LeaveDetail AS LEAVEDETAIL ");
        strBuffer.append("INNER JOIN T_BD_Person AS PERSON ON LEAVEDETAIL.FPersonID = PERSON.FID ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance AS ATTENDANCE ON LEAVEDETAIL.FTimeAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOSITION ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position AS POSITION ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        strBuffer.append("WHERE ");
        if (beginDate != null && endDate != null) {
            strBuffer.append("FSTARTDATEREAL <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and FENDDATEREAL >= ");
            strBuffer.append(this.getSqlDate(beginDate));
        }
        if (adminOrgUtil != null && isLowLevel) {
            strBuffer.append(" and (ADMINORGUNIT.FLongNumber = '");
            strBuffer.append(adminOrgUtil);
            strBuffer.append("' or ");
            strBuffer.append(" ADMINORGUNIT.FLongNumber like '");
            strBuffer.append(adminOrgUtil + "!%");
            strBuffer.append("') ");
        } else if (adminOrgUtil != null && !isLowLevel) {
            strBuffer.append(" and ADMINORGUNIT.FLongNumber = '");
            strBuffer.append(adminOrgUtil);
            strBuffer.append("'");
        }
        if (cuOrgInfo != null) {
            strBuffer.append(" and ADMINORGUNIT.FID IN (");
            strBuffer.append(cuOrgInfo);
            strBuffer.append(")");
        }
        if (person != null) {
            strBuffer.append(" and PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("'");
        }
        if (checkState == 0) {
            strBuffer.append(" and LEAVEDETAIL.FCHECKSTATE = 0 ");
        } else if (checkState == 1) {
            strBuffer.append(" and LEAVEDETAIL.FCHECKSTATE = 1 ");
        } else {
            strBuffer.append("");
        }
        if (refrence == 0) {
            strBuffer.append(" and LEAVEDETAIL.Frefrence = 0 ");
        } else if (refrence == 1) {
            strBuffer.append(" and LEAVEDETAIL.Frefrence = 1 ");
        } else {
            strBuffer.append("");
        }
        if (reference != null && reference.length > 0 && reference[(len = reference.length) - 1] != null && reference[len - 1].length() > 0) {
            strBuffer.append(" and (");
            int size = len - 1;
            for (int i = 0; i < size; ++i) {
                strBuffer.append(reference[i]);
                strBuffer.append(" or ");
            }
            strBuffer.append(reference[len - 1]);
            strBuffer.append(")");
        }
        strBuffer.append(" GROUP BY ATTENDANCE.FID,ATTENDANCE.FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(",ATTENDANCE.FUnitType ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = iQe.executeSQL();
        return row;
    }

    protected IRowSet _getTblSetAtt(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException, EASBizException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.TOTALVALUE TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID ");
        strBuffer.append("FROM T_BD_Person PERSON ");
        strBuffer.append("INNER JOIN (SELECT ");
        strBuffer.append("Sum(ATTENDANCEMANAGER.FTotalValue) TOTALVALUE, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID ");
        strBuffer.append("FROM T_HR_AttendanceManager ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON ATTENDANCEMANAGER.FAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON ATTENDANCEMANAGER.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (ATTENDANCEMANAGER.FSTARTDATE <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and ATTENDANCEMANAGER.FENDDATE >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        strBuffer.append(" and ");
        strBuffer.append(" ATTENDANCEMANAGER.FPersonId in ");
        strBuffer.append(" ( ");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" select person.FID pId from T_BD_PERSON person ");
        strBuffer.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        strBuffer.append(" where pp.fpersonDep in ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append("))");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID) SUBQUERY ");
        strBuffer.append("ON PERSON.FID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION ");
        strBuffer.append("ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = iQe.executeSQL();
        return row;
    }

    protected IRowSet _getTblSetLeave(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException, EASBizException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.totalRegReal TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID ");
        strBuffer.append("FROM T_BD_Person PERSON ");
        strBuffer.append("inner join (select ");
        strBuffer.append("Sum(LeaveDetail.FTotalRegReal) totalRegReal, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID ");
        strBuffer.append("FROM T_HR_LeaveDetail LeaveDetail ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON LeaveDetail.FTimeAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON LeaveDetail.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON LeaveDetail.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (LeaveDetail.FStartDateReal <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and LeaveDetail.FEndDateReal >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        strBuffer.append(" and ");
        strBuffer.append(" LeaveDetail.FPersonId in ");
        strBuffer.append(" ( ");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" select person.FID pId from T_BD_PERSON person ");
        strBuffer.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        strBuffer.append(" where pp.fpersonDep in ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append("))");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID) SUBQUERY ");
        strBuffer.append("ON PERSON.FID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION ");
        strBuffer.append("ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = iQe.executeSQL();
        return row;
    }

    private String getSqlDate(Date date) throws BOSException {
        String strTime = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        String strKSQLTime = "{ts '" + strTime + "'}";
        return strKSQLTime;
    }

    public HashMap _getEvaluResults(Context ctx, String personIDList, String cmpPeriodID, ArrayList cmpItemIDList) throws EASBizException, LeaveDetailException, BOSException {
        ArrayList<String> cmpPeriodIDList = new ArrayList<String>();
        cmpPeriodIDList.add(cmpPeriodID);
        return this.getEvaluResultsImpl(ctx, personIDList, cmpPeriodIDList, cmpItemIDList);
    }

    private HashMap getEvaluResultsImpl(Context ctx, String cmpSchemeId, List cmpPeriodIDList, List cmpItemIDList) throws BOSException, EASBizException, LeaveDetailException {
        int i;
        if (cmpSchemeId == null || cmpItemIDList == null || cmpItemIDList.size() == 0) {
            return new HashMap();
        }
        ArrayList leaveList = new ArrayList();
        ArrayList attList = new ArrayList();
        HashMap<String, HashMap> mapPerson = new HashMap<String, HashMap>();
        HashMap mapItem = null;
        ArrayList<String> attIDList = new ArrayList<String>();
        HashMap<String, String> cmpAttMap = new HashMap<String, String>();
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            HashSet set = new HashSet();
            set.addAll(cmpItemIDList);
            filter.getFilterItems().add(new FilterItemInfo("cmpItem.id", set, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            viewInfo.getSelector().add(new SelectorItemInfo("timeAttendance.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("cmpItem.id"));
            CmpRefCollection coll = CmpRefFactory.getLocalInstance(ctx).getCmpRefCollection(viewInfo);
            int n = coll.size();
            for (i = 0; i < n; ++i) {
                attIDList.add(coll.get(i).getTimeAttendance().getId().toString());
                cmpAttMap.put(coll.get(i).getTimeAttendance().getId().toString(), coll.get(i).getCmpItem().getId().toString());
            }
        }
        catch (BOSException e) {
            return new HashMap();
        }
        int size = attIDList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.isLeaveDetail(ctx, (String)attIDList.get(i2))) {
                leaveList.add(attIDList.get(i2));
                continue;
            }
            attList.add(attIDList.get(i2));
        }
        int leaveCounts = leaveList.size();
        StringBuffer leaveIds = new StringBuffer();
        for (int i3 = 0; i3 < leaveCounts; ++i3) {
            if (leaveCounts == 1) {
                leaveIds.append("'");
                leaveIds.append(leaveList.get(i3).toString());
                leaveIds.append("'");
                continue;
            }
            if (i3 != 0) {
                leaveIds.append(", '" + leaveList.get(i3).toString());
                leaveIds.append("'");
                continue;
            }
            leaveIds.append("'");
            leaveIds.append(leaveList.get(i3).toString());
            leaveIds.append("'");
        }
        int attCounts = attList.size();
        StringBuffer attIds = new StringBuffer();
        for (i = 0; i < attCounts; ++i) {
            if (attCounts == 1) {
                attIds.append("'");
                attIds.append(attList.get(i).toString());
                attIds.append("'");
                continue;
            }
            if (i != 0) {
                attIds.append(", '" + attList.get(i).toString());
                attIds.append("'");
                continue;
            }
            attIds.append("'");
            attIds.append(attList.get(i).toString());
            attIds.append("'");
        }
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "LeaveDetailDataQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        HashSet cmpPeriodSet = new HashSet();
        cmpPeriodSet.addAll(cmpPeriodIDList);
        if (cmpPeriodSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", cmpPeriodSet, CompareType.INCLUDE));
        }
        if (cmpSchemeId != null) {
            StringBuffer pb = new StringBuffer();
            pb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid =");
            pb.append("'");
            pb.append(cmpSchemeId);
            pb.append("'");
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pb.toString(), CompareType.INNER));
        }
        if (leaveCounts > 0) {
            StringBuffer tb = new StringBuffer();
            tb.append(leaveIds);
            tb.append(" ");
            filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)tb, CompareType.INNER));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        if (cmpSchemeId != null && cmpSchemeId.trim().length() >= 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", null));
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeId));
            fi.setMaskString("#0 or #1");
            filter.mergeFilter(fi, "and");
        }
        iqec.setObjectView(viewInfo);
        IRowSet row = iqec.executeQuery();
        String person = null;
        String cmpItem = null;
        String attItem = null;
        try {
            while (row.next()) {
                person = row.getString("person.id");
                attItem = row.getString("timeAttendance.id");
                if (cmpAttMap.get(attItem) == null) continue;
                cmpItem = cmpAttMap.get(attItem).toString();
                if (!mapPerson.containsKey(person)) {
                    mapItem = new HashMap();
                    mapPerson.put(person, mapItem);
                } else {
                    mapItem = (HashMap)mapPerson.get(person);
                }
                mapItem.put(cmpItem, row.getString("totalRegReal"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "AttendanceManagerDataQuery"));
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        viewInfo.setFilter(filter);
        cmpPeriodSet = new HashSet();
        cmpPeriodSet.addAll(cmpPeriodIDList);
        if (cmpPeriodSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", cmpPeriodSet, CompareType.INCLUDE));
        }
        if (cmpSchemeId != null) {
            StringBuffer pb = new StringBuffer();
            pb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid =");
            pb.append("'");
            pb.append(cmpSchemeId);
            pb.append("'");
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pb.toString(), CompareType.INNER));
        }
        if (attCounts > 0) {
            StringBuffer tb = new StringBuffer();
            tb.append(attIds);
            tb.append(" ");
            filter.getFilterItems().add(new FilterItemInfo("attendance.id", (Object)tb, CompareType.INNER));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        if (cmpSchemeId != null && cmpSchemeId.trim().length() >= 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", null));
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeId));
            fi.setMaskString("#0 or #1");
            filter.mergeFilter(fi, "and");
        }
        iqec.setObjectView(viewInfo);
        row = iqec.executeQuery();
        try {
            while (row.next()) {
                person = row.getString("person.id");
                attItem = row.getString("attendance.id");
                if (cmpAttMap.get(attItem) == null) continue;
                cmpItem = cmpAttMap.get(attItem).toString();
                if (!mapPerson.containsKey(person)) {
                    mapItem = new HashMap();
                    mapPerson.put(person, mapItem);
                } else {
                    mapItem = (HashMap)mapPerson.get(person);
                }
                mapItem.put(cmpItem, row.getString("totalValue"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        this.updateAttReference(ctx, cmpSchemeId, cmpPeriodIDList, attCounts, attIds);
        this.updateLeaveReference(ctx, cmpSchemeId, cmpPeriodIDList, leaveCounts, leaveIds);
        return mapPerson;
    }

    public void updateLeaveReference(Context ctx, String personIDList, List cmpPeriodID, int leaveCounts, StringBuffer cmpItemIDList) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (personIDList != null && leaveCounts > 0) {
            sb.append("update t_hr_leavedetail set frefrence = 1 where fcheckstate=1 and fpersonid in (");
            sb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid = '");
            sb.append(personIDList);
            sb.append("') and ftimeattendanceid in (");
            sb.append(cmpItemIDList);
            sb.append(") and fcmpperiodid in");
            sb.append(BenefitUtils.getStrFromList((List)cmpPeriodID));
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    public void updateAttReference(Context ctx, String personIDList, List cmpPeriodID, int attCounts, StringBuffer cmpItemIDList) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (personIDList != null && attCounts > 0) {
            sb.append("update t_hr_attendancemanager set frefrence = 1 where fcheckstate=1 and fpersonid in (");
            sb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid = '");
            sb.append(personIDList);
            sb.append("') and fattendanceid in (");
            sb.append(cmpItemIDList);
            sb.append(") and fcmpperiodid in");
            sb.append(BenefitUtils.getStrFromList((List)cmpPeriodID));
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    public boolean isLeaveDetail(Context ctx, String LeaveDetailID) throws EASBizException, BOSException, LeaveDetailException {
        ITimeAttendance iTimeAttendance = TimeAttendanceFactory.getLocalInstance(ctx);
        TimeAttendanceCollection timeAttendanceInfos = iTimeAttendance.getTimeAttendanceCollection("select id,attendCatalog.id where id='" + LeaveDetailID + "'");
        if (timeAttendanceInfos.size() == 0) {
            throw new LeaveDetailException(LeaveDetailException.ATTENDANCEIDERROR);
        }
        TimeAttendanceCatalogInfo catalogId = timeAttendanceInfos.get(0).getAttendCatalog();
        return catalogId.getId().toString().equals("00000000-0000-0000-0000-000000000002BE0D0183");
    }

    protected IRowSet _getDataRows(Context ctx, String personid, Date beginDate, Date endDate) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        if (personid == null) {
            return iRowSet;
        }
        if (beginDate == null) {
            beginDate = new Date();
        }
        if (endDate == null) {
            endDate = new Date();
        }
        beginDate = DateTimeUtils.truncateDate((Date)beginDate);
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        endDate = DateTimeUtils.addDay((Date)DateTimeUtils.addSecond((Date)endDate, (long)-1L), (long)1L);
        StringBuffer strBuffer = new StringBuffer("SELECT \"LEAVEBILLENTRY\".FBillID AS \"LEAVEBILLENTRY.BillID\",\"HRTYPE\".FID AS \"HRTYPE.ID\",  \"LEAVEREPORTBILL\".FReportToState AS \"LEAVEREPORTBILL.FReportToState\", \"HRTYPE\".FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(" AS \"HRTYPE.NAME\", \"HRTYPE\".FUnitType AS \"HRTYPE.UNITTYPE\", \"PERSON\".FID AS \"PERSON.ID\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBeginTime AS \"BEGINTIME\", \"LEAVEBILLENTRY\".FEndTime AS \"ENDTIME\", \"LEAVEBILLENTRY\".FLeaveLength AS \"LEAVELENGTH\",");
        strBuffer.append(" \"LPBILLENTRY\".FBeginTime AS \"LPBILLENTRY.BEGINTIME\", \"LPBILLENTRY\".FEndTime AS \"LPBILLENTRY.ENDTIME\", \"LPBILLENTRY\".FLeaveLength AS \"LPBILLENTRY.LEAVELENGTH\"");
        strBuffer.append(" FROM T_HR_LeaveBillEntry AS \"LEAVEBILLENTRY\" LEFT OUTER JOIN T_HR_LeaveReportBillEntry AS ");
        strBuffer.append(" \"LPBILLENTRY\" ON \"LEAVEBILLENTRY\".FID = \"LPBILLENTRY\".FLeaveBillEntryID");
        strBuffer.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FPersonID = \"PERSON\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"HRTYPE\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FTypeID = \"HRTYPE\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"REPORTTYPE\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FTypeID = \"REPORTTYPE\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LEAVEREPORTBILL AS \"LEAVEREPORTBILL\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FBillID = \"LEAVEREPORTBILL\".FID ");
        strBuffer.append(" WHERE (\"HRTYPE\".FID=\"REPORTTYPE\".FID OR \"REPORTTYPE\".FID IS NULL) and ");
        strBuffer.append("  (\"LEAVEREPORTBILL\".FReportToState != 0 AND \"LEAVEREPORTBILL\".FReportToState != 1) AND \"LPBILLENTRY\".FBeginTime <= ");
        strBuffer.append(this.getSqlDate(endDate));
        strBuffer.append(" and \"LPBILLENTRY\".FEndTime >= ");
        strBuffer.append(this.getSqlDate(beginDate));
        strBuffer.append(" and \"PERSON\".FID = '");
        strBuffer.append(personid);
        strBuffer.append("'");
        strBuffer.append(" UNION ");
        strBuffer.append(" SELECT ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBillID AS \"LEAVEBILLENTRY.BillID\",\"REPORTTYPE\".FID AS \"HRTYPE.ID\", \"LEAVEREPORTBILL\".FReportToState AS \"LEAVEREPORTBILL.FReportToState\",");
        strBuffer.append(" \"REPORTTYPE\".FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(" AS \"HRTYPE.NAME\", ");
        strBuffer.append("  \"REPORTTYPE\".FUnitType AS \"HRTYPE.UNITTYPE\", ");
        strBuffer.append(" \"PERSON\".FID AS \"PERSON.ID\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"BEGINTIME\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"ENDTIME\", ");
        strBuffer.append(" TO_DECIMAL(NULL) AS \"LEAVELENGTH\", ");
        strBuffer.append(" \"LPBILLENTRY\".FBeginTime AS \"LPBILLENTRY.BEGINTIME\", ");
        strBuffer.append(" \"LPBILLENTRY\".FEndTime AS \"LPBILLENTRY.ENDTIME\", ");
        strBuffer.append(" \"LPBILLENTRY\".FLeaveLength AS \"LPBILLENTRY.LEAVELENGTH\" ");
        strBuffer.append(" FROM T_HR_LeaveBillEntry AS \"LEAVEBILLENTRY\" ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LeaveReportBillEntry AS \"LPBILLENTRY\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FID = \"LPBILLENTRY\".FLeaveBillEntryID ");
        strBuffer.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FPersonID = \"PERSON\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_TimeAttendance AS \"HRTYPE\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FTypeID = \"HRTYPE\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"REPORTTYPE\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FTypeID = \"REPORTTYPE\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LEAVEREPORTBILL AS \"LEAVEREPORTBILL\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FBillID = \"LEAVEREPORTBILL\".FID ");
        strBuffer.append(" WHERE ((\"HRTYPE\".FID<>\"REPORTTYPE\".FID AND \"REPORTTYPE\".FID IS NOT NULL) OR \"HRTYPE\".FID IS NULL) and ");
        strBuffer.append(" (\"LEAVEREPORTBILL\".FReportToState != 0 AND \"LEAVEREPORTBILL\".FReportToState != 1) and \"LPBILLENTRY\".FBeginTime <= ");
        strBuffer.append(this.getSqlDate(endDate));
        strBuffer.append(" and \"LPBILLENTRY\".FEndTime >= ");
        strBuffer.append(this.getSqlDate(beginDate));
        strBuffer.append(" and \"PERSON\".FID = '");
        strBuffer.append(personid);
        strBuffer.append("'");
        strBuffer.append(" UNION ");
        strBuffer.append(" SELECT ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBillID AS \"LEAVEBILLENTRY.BillID\",\"HRTYPE\".FID AS \"HRTYPE.ID\", TO_INT(NULL) AS \"LEAVEREPORTBILL.FReportToState\", ");
        strBuffer.append(" \"HRTYPE\".FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(" AS \"HRTYPE.NAME\", ");
        strBuffer.append(" \"HRTYPE\".FUnitType AS \"HRTYPE.UNITTYPE\", ");
        strBuffer.append(" \"PERSON\".FID AS \"PERSON.ID\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBeginTime AS \"BEGINTIME\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FEndTime AS \"ENDTIME\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FLeaveLength AS \"LEAVELENGTH\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"LPBILLENTRY.BEGINTIME\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"LPBILLENTRY.ENDTIME\", ");
        strBuffer.append(" TO_DECIMAL(NULL) AS \"LPBILLENTRY.LEAVELENGTH\" ");
        strBuffer.append(" FROM T_HR_LeaveBillEntry AS \"LEAVEBILLENTRY\" ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LeaveReportBillEntry AS \"LPBILLENTRY\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FID = \"LPBILLENTRY\".FLeaveBillEntryID ");
        strBuffer.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FPersonID = \"PERSON\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"HRTYPE\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FTypeID = \"HRTYPE\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_TimeAttendance AS \"REPORTTYPE\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FTypeID = \"REPORTTYPE\".FID ");
        strBuffer.append(" WHERE ((\"HRTYPE\".FID<>\"REPORTTYPE\".FID AND \"HRTYPE\".FID IS NOT NULL) OR \"REPORTTYPE\".FID IS NULL) ");
        strBuffer.append(" AND \"LEAVEBILLENTRY\".FBeginTime <= ");
        strBuffer.append(this.getSqlDate(endDate));
        strBuffer.append(" and \"LEAVEBILLENTRY\".FEndTime >= ");
        strBuffer.append(this.getSqlDate(beginDate));
        strBuffer.append(" and \"PERSON\".FID = '");
        strBuffer.append(personid);
        strBuffer.append("'");
        return DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
    }

    protected Map _getEvaluResultsList(Context ctx, String cmpSchemeId, List cmpPeriodList, List cmpItemList) throws BOSException, EASBizException {
        return this.getEvaluResultsImpl(ctx, cmpSchemeId, cmpPeriodList, cmpItemList);
    }

    protected IRowSet _getTblSetAtt1(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException, EASBizException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT distinct ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION1.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT1.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT1.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.TOTALVALUE TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID,");
        strBuffer.append("SUBQUERY.fpositionid fpositionid,");
        strBuffer.append("SUBQUERY.FAdminOrgUnitID FAdminOrgUnitID  ");
        strBuffer.append("FROM T_HR_AttendanceManager ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN (SELECT ");
        strBuffer.append("Sum(ATTENDANCEMANAGER.FTotalValue) TOTALVALUE, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID,");
        strBuffer.append("fpositionid,");
        strBuffer.append("FAdminOrgUnitID ");
        strBuffer.append("FROM T_HR_AttendanceManager ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON ATTENDANCEMANAGER.FAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON ATTENDANCEMANAGER.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON ATTENDANCEMANAGER.FAdminOrgUnitId = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (ATTENDANCEMANAGER.FSTARTDATE <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and ATTENDANCEMANAGER.FENDDATE >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" and ATTENDANCEMANAGER.FAdminOrgUnitId in ");
        strBuffer.append(" ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitId);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append(")");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID,fpositionid,FAdminOrgUnitID) SUBQUERY ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION1 ");
        strBuffer.append("ON SUBQUERY.fpositionid  = POSITION1.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT1 ");
        strBuffer.append("ON SUBQUERY.FAdminOrgUnitID = ADMINORGUNIT1.FID ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = iQe.executeSQL();
        return row;
    }

    protected IRowSet _getTblSetLeave1(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException, EASBizException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT distinct ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION1.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT1.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT1.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.totalRegReal TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID,");
        strBuffer.append("SUBQUERY.fpositionid fpositionid,");
        strBuffer.append("SUBQUERY.FAdminOrgUnitID FAdminOrgUnitID  ");
        strBuffer.append("FROM T_HR_LeaveDetail LeaveDetail ");
        strBuffer.append("inner join (select ");
        strBuffer.append("Sum(LeaveDetail.FTotalRegReal) totalRegReal, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID, ");
        strBuffer.append("fpositionid,");
        strBuffer.append("FAdminOrgUnitID ");
        strBuffer.append("FROM T_HR_LeaveDetail LeaveDetail ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON LeaveDetail.FTimeAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON LeaveDetail.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON LeaveDetail.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON LeaveDetail.FAdminOrgUnitId = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (LeaveDetail.FStartDateReal <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and LeaveDetail.FEndDateReal >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" and LeaveDetail.FAdminOrgUnitId in ");
        strBuffer.append(" ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitId);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append(")");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID,fpositionid,FAdminOrgUnitID) SUBQUERY ");
        strBuffer.append("ON LeaveDetail.FPersonID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON LeaveDetail.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION1 ");
        strBuffer.append("ON SUBQUERY.fpositionid  = POSITION1.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT1 ");
        strBuffer.append("ON SUBQUERY.FAdminOrgUnitID = ADMINORGUNIT1.FID ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = iQe.executeSQL();
        return row;
    }

    protected Map _getEvaluResultsList(Context ctx, String cmpSchemeId, Date startDateReal, Date endDateReal, List cmpItemList) throws BOSException, EASBizException {
        return this.getEvaluResultsImpl(ctx, cmpSchemeId, startDateReal, endDateReal, cmpItemList);
    }

    private HashMap getEvaluResultsImpl(Context ctx, String cmpSchemeId, Date startDateReal, Date endDateReal, List cmpItemIDList) throws BOSException, EASBizException, LeaveDetailException {
        int i;
        if (cmpSchemeId == null || cmpItemIDList == null || cmpItemIDList.size() == 0) {
            return new HashMap();
        }
        ArrayList leaveList = new ArrayList();
        ArrayList attList = new ArrayList();
        HashMap<String, HashMap> mapPerson = new HashMap<String, HashMap>();
        HashMap mapItem = null;
        ArrayList<String> attIDList = new ArrayList<String>();
        HashMap<String, String> cmpAttMap = new HashMap<String, String>();
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            HashSet set = new HashSet();
            set.addAll(cmpItemIDList);
            filter.getFilterItems().add(new FilterItemInfo("cmpItem.id", set, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
            viewInfo.getSelector().add(new SelectorItemInfo("timeAttendance.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("cmpItem.id"));
            CmpRefCollection coll = CmpRefFactory.getLocalInstance(ctx).getCmpRefCollection(viewInfo);
            int n = coll.size();
            for (i = 0; i < n; ++i) {
                attIDList.add(coll.get(i).getTimeAttendance().getId().toString());
                cmpAttMap.put(coll.get(i).getTimeAttendance().getId().toString(), coll.get(i).getCmpItem().getId().toString());
            }
        }
        catch (BOSException e) {
            return new HashMap();
        }
        int size = attIDList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.isLeaveDetail(ctx, (String)attIDList.get(i2))) {
                leaveList.add(attIDList.get(i2));
                continue;
            }
            attList.add(attIDList.get(i2));
        }
        int leaveCounts = leaveList.size();
        StringBuffer leaveIds = new StringBuffer();
        for (int i3 = 0; i3 < leaveCounts; ++i3) {
            if (leaveCounts == 1) {
                leaveIds.append("'");
                leaveIds.append(leaveList.get(i3).toString());
                leaveIds.append("'");
                continue;
            }
            if (i3 != 0) {
                leaveIds.append(", '" + leaveList.get(i3).toString());
                leaveIds.append("'");
                continue;
            }
            leaveIds.append("'");
            leaveIds.append(leaveList.get(i3).toString());
            leaveIds.append("'");
        }
        int attCounts = attList.size();
        StringBuffer attIds = new StringBuffer();
        for (i = 0; i < attCounts; ++i) {
            if (attCounts == 1) {
                attIds.append("'");
                attIds.append(attList.get(i).toString());
                attIds.append("'");
                continue;
            }
            if (i != 0) {
                attIds.append(", '" + attList.get(i).toString());
                attIds.append("'");
                continue;
            }
            attIds.append("'");
            attIds.append(attList.get(i).toString());
            attIds.append("'");
        }
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "LeaveDetailDataQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        if (startDateReal != null) {
            filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)startDateReal, CompareType.GREATER_EQUALS));
        }
        if (endDateReal != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)endDateReal, CompareType.LESS_EQUALS));
        }
        if (cmpSchemeId != null) {
            StringBuffer pb = new StringBuffer();
            pb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid =");
            pb.append("'");
            pb.append(cmpSchemeId);
            pb.append("'");
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pb.toString(), CompareType.INNER));
        }
        if (leaveCounts > 0) {
            StringBuffer tb = new StringBuffer();
            tb.append(leaveIds);
            tb.append(" ");
            filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)tb, CompareType.INNER));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        if (cmpSchemeId != null && cmpSchemeId.trim().length() >= 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", null));
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeId));
            fi.setMaskString("#0 or #1");
            filter.mergeFilter(fi, "and");
        }
        iqec.setObjectView(viewInfo);
        IRowSet row = iqec.executeQuery();
        String person = null;
        String cmpItem = null;
        String attItem = null;
        try {
            while (row.next()) {
                person = row.getString("person.id");
                attItem = row.getString("timeAttendance.id");
                if (cmpAttMap.get(attItem) == null) continue;
                cmpItem = cmpAttMap.get(attItem).toString();
                if (!mapPerson.containsKey(person)) {
                    mapItem = new HashMap();
                    mapPerson.put(person, mapItem);
                } else {
                    mapItem = (HashMap)mapPerson.get(person);
                }
                mapItem.put(cmpItem, row.getString("totalRegReal"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "AttendanceManagerDataQuery"));
        viewInfo = new EntityViewInfo();
        filter = new FilterInfo();
        viewInfo.setFilter(filter);
        if (startDateReal != null) {
            filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)startDateReal, CompareType.GREATER_EQUALS));
        }
        if (endDateReal != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)endDateReal, CompareType.LESS_EQUALS));
        }
        if (cmpSchemeId != null) {
            StringBuffer pb = new StringBuffer();
            pb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid =");
            pb.append("'");
            pb.append(cmpSchemeId);
            pb.append("'");
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pb.toString(), CompareType.INNER));
        }
        if (attCounts > 0) {
            StringBuffer tb = new StringBuffer();
            tb.append(attIds);
            tb.append(" ");
            filter.getFilterItems().add(new FilterItemInfo("attendance.id", (Object)tb, CompareType.INNER));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        if (cmpSchemeId != null && cmpSchemeId.trim().length() >= 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", null));
            fi.getFilterItems().add(new FilterItemInfo("cmpScheme.id", (Object)cmpSchemeId));
            fi.setMaskString("#0 or #1");
            filter.mergeFilter(fi, "and");
        }
        iqec.setObjectView(viewInfo);
        row = iqec.executeQuery();
        try {
            while (row.next()) {
                person = row.getString("person.id");
                attItem = row.getString("attendance.id");
                if (cmpAttMap.get(attItem) == null) continue;
                cmpItem = cmpAttMap.get(attItem).toString();
                if (!mapPerson.containsKey(person)) {
                    mapItem = new HashMap();
                    mapPerson.put(person, mapItem);
                } else {
                    mapItem = (HashMap)mapPerson.get(person);
                }
                mapItem.put(cmpItem, row.getString("totalValue"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        this.updateAttReference(ctx, cmpSchemeId, startDateReal, endDateReal, attCounts, attIds);
        this.updateLeaveReference(ctx, cmpSchemeId, startDateReal, endDateReal, leaveCounts, leaveIds);
        return mapPerson;
    }

    public void updateAttReference(Context ctx, String personIDList, Date startDateReal, Date endDateReal, int attCounts, StringBuffer cmpItemIDList) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (personIDList != null && attCounts > 0) {
            sb.append("update t_hr_attendancemanager set frefrence = 1 where fcheckstate=1 and fpersonid in (");
            sb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid = '");
            sb.append(personIDList);
            sb.append("') and fattendanceid in (");
            sb.append(cmpItemIDList);
            sb.append(") and FStartDate >=");
            sb.append(this.getSqlDate(startDateReal));
            sb.append(" and FEndDate <=");
            sb.append(this.getSqlDate(endDateReal));
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    public void updateLeaveReference(Context ctx, String personIDList, Date startDateReal, Date endDateReal, int leaveCounts, StringBuffer cmpItemIDList) throws BOSException {
        StringBuffer sb = new StringBuffer();
        if (personIDList != null && leaveCounts > 0) {
            sb.append("update t_hr_leavedetail set frefrence = 1 where fcheckstate=1 and fpersonid in (");
            sb.append("select fpersonid from t_hr_cmpschemePerson where fcmpschemeid = '");
            sb.append(personIDList);
            sb.append("') and ftimeattendanceid in (");
            sb.append(cmpItemIDList);
            sb.append(") and FStartDateReal >=");
            sb.append(this.getSqlDate(startDateReal));
            sb.append(" and FEndDateReal <=");
            sb.append(this.getSqlDate(endDateReal));
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    protected IRowSet _getMyLeaveAndAttendanceRpt(Context ctx, IObjectValue person, Date startDate, Date endDate) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append("\"ID\", ");
        sql.append("\"ATTENDCATALOG.NAME\",");
        sql.append("\"ATTENDANCE.NAME\", ");
        sql.append("\"ATTENDANCE.UNITTYPE\", ");
        sql.append("SUM(\"TOTALVALUE\") AS \"TOTALVALUE\", ");
        sql.append("\"ENABLE\" ");
        sql.append(" FROM ");
        sql.append("( SELECT ");
        sql.append("\"ATTENDANCE\".FID AS \"ID\",");
        sql.append("\"ATTENDCATALOG\".FName_" + ctx.getLocale() + " AS \"ATTENDCATALOG.NAME\", ");
        sql.append("\"ATTENDANCE\".FName_" + ctx.getLocale() + " AS \"ATTENDANCE.NAME\", ");
        sql.append("\"ATTENDANCE\".FUnitType AS \"ATTENDANCE.UNITTYPE\", ");
        sql.append("0 AS \"TOTALVALUE\", ");
        sql.append("\"ATTENDANCE\".FEnable AS \"ENABLE\" ");
        sql.append("FROM T_HR_AttendanceManager AS \"ATTENDANCEMANAGER\" ");
        sql.append("INNER JOIN T_BD_Person AS \"PERSON\" ");
        sql.append("ON \"ATTENDANCEMANAGER\".FPersonID = \"PERSON\".FID ");
        sql.append("RIGHT JOIN T_HR_TimeAttendance AS \"ATTENDANCE\" ");
        sql.append("ON \"ATTENDANCEMANAGER\".FAttendanceID = \"ATTENDANCE\".FID ");
        sql.append("INNER JOIN T_HR_TimeAttendanceCatalog AS \"ATTENDCATALOG\" ");
        sql.append("ON \"ATTENDANCE\".FAttendCatalogID = \"ATTENDCATALOG\".FID ");
        sql.append(" AND (\"ATTENDANCE\".FHrOrgUnitID = '");
        sql.append(ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        sql.append("' OR \"ATTENDANCE\".FHrOrgUnitID IS NULL) ");
        sql.append("WHERE \"ATTENDANCE\".FEnable = 1 ");
        sql.append(" GROUP BY ");
        sql.append("\"ATTENDANCE\".FID,");
        sql.append("\"ATTENDCATALOG\".FName_" + ctx.getLocale() + ",");
        sql.append("\"ATTENDANCE\".FName_" + ctx.getLocale() + ",");
        sql.append("\"ATTENDANCE\".FUnitType,");
        sql.append("\"ATTENDANCE\".FEnable ");
        sql.append(" UNION ");
        sql.append(" SELECT ");
        sql.append("\"ATTENDANCE\".FID AS \"ID\",");
        sql.append("\"ATTENDCATALOG\".FName_" + ctx.getLocale() + " AS \"ATTENDCATALOG.NAME\", ");
        sql.append("\"ATTENDANCE\".FName_" + ctx.getLocale() + " AS \"ATTENDANCE.NAME\", ");
        sql.append("\"ATTENDANCE\".FUnitType AS \"ATTENDANCE.UNITTYPE\", ");
        sql.append("SUM(\"ATTENDANCEMANAGER\".FTotalValue) AS \"TOTALVALUE\", ");
        sql.append("\"ATTENDANCE\".FEnable AS \"ENABLE\" ");
        sql.append("FROM T_HR_AttendanceManager AS \"ATTENDANCEMANAGER\" ");
        sql.append("INNER JOIN T_BD_Person AS \"PERSON\" ");
        sql.append("ON \"ATTENDANCEMANAGER\".FPersonID = \"PERSON\".FID ");
        sql.append("RIGHT JOIN T_HR_TimeAttendance AS \"ATTENDANCE\" ");
        sql.append("ON \"ATTENDANCEMANAGER\".FAttendanceID = \"ATTENDANCE\".FID ");
        sql.append("INNER JOIN T_HR_TimeAttendanceCatalog AS \"ATTENDCATALOG\" ");
        sql.append("ON \"ATTENDANCE\".FAttendCatalogID = \"ATTENDCATALOG\".FID ");
        sql.append("WHERE \"ATTENDANCE\".FEnable = 1 ");
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null && ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId() != null) {
            sql.append(" AND \"ATTENDANCEMANAGER\".FPersonID = '");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId());
            sql.append("' ");
        }
        if (startDate != null && endDate != null) {
            sql.append(" AND \"ATTENDANCEMANAGER\".FStartDate >= {ts'");
            sql.append(startDate);
            sql.append(" 00:00:00");
            sql.append("'} ");
            if (DateTimeUtils.dayBefore((Date)startDate, (Date)endDate)) {
                sql.append(" AND \"ATTENDANCEMANAGER\".FEndDate <= {ts'");
                sql.append(endDate);
                sql.append(" 23:59:59");
                sql.append("'} ");
            }
        }
        sql.append(" GROUP BY ");
        sql.append("\"ATTENDANCE\".FID,");
        sql.append("\"ATTENDCATALOG\".FName_" + ctx.getLocale() + ",");
        sql.append("\"ATTENDANCE\".FName_" + ctx.getLocale() + ",");
        sql.append("\"ATTENDANCE\".FUnitType,");
        sql.append("\"ATTENDANCE\".FEnable ");
        sql.append(" UNION ");
        sql.append(" SELECT ");
        sql.append("\"TIMEATTENDANCE\".FID AS \"ID\",");
        sql.append("\"ATTENDCATALOG\".FName_" + ctx.getLocale() + " AS \"ATTENDCATALOG.NAME\",");
        sql.append("\"TIMEATTENDANCE\".FName_" + ctx.getLocale() + " AS \"ATTENDANCE.NAME\",");
        sql.append("\"TIMEATTENDANCE\".FUnitType AS \"ATTENDANCE.UNITTYPE\",");
        sql.append("SUM(\"LEAVEDETAIL\".FTotalRegReal) AS \"TOTALVALUE\",");
        sql.append("\"TIMEATTENDANCE\".FEnable AS \"ENABLE\" ");
        sql.append(" FROM T_HR_LeaveDetail AS \"LEAVEDETAIL\" ");
        sql.append(" INNER JOIN T_HR_TimeAttendance AS \"TIMEATTENDANCE\" ");
        sql.append(" ON \"LEAVEDETAIL\".FTimeAttendanceID = \"TIMEATTENDANCE\".FID ");
        sql.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        sql.append(" ON \"LEAVEDETAIL\".FPersonID = \"PERSON\".FID ");
        sql.append(" INNER JOIN T_HR_TimeAttendanceCatalog AS \"ATTENDCATALOG\" ");
        sql.append(" ON \"TIMEATTENDANCE\".FAttendCatalogID = \"ATTENDCATALOG\".FID ");
        sql.append(" WHERE \"TIMEATTENDANCE\".FEnable = 1 ");
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null && ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId() != null) {
            sql.append(" AND \"LEAVEDETAIL\".FPersonID = '");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId());
            sql.append("' ");
        }
        if (startDate != null && endDate != null) {
            sql.append(" AND \"LEAVEDETAIL\".FStartDateReal >= {ts'");
            sql.append(startDate);
            sql.append(" 00:00:00");
            sql.append("'} ");
            if (DateTimeUtils.dayBefore((Date)startDate, (Date)endDate)) {
                sql.append(" AND \"LEAVEDETAIL\".FEndDateReal <= {ts'");
                sql.append(endDate);
                sql.append(" 23:59:59");
                sql.append("'} ");
            }
        }
        sql.append(" GROUP BY ");
        sql.append(" \"TIMEATTENDANCE\".FID, ");
        sql.append(" \"ATTENDCATALOG\".FName_" + ctx.getLocale() + ",");
        sql.append(" \"TIMEATTENDANCE\".FName_" + ctx.getLocale() + ", ");
        sql.append(" \"TIMEATTENDANCE\".FUnitType, ");
        sql.append(" \"TIMEATTENDANCE\".FEnable ");
        sql.append(" ) t ");
        sql.append(" GROUP BY \"ID\", ");
        sql.append(" \"ATTENDCATALOG.NAME\", ");
        sql.append(" \"ATTENDANCE.NAME\", ");
        sql.append(" \"ATTENDANCE.UNITTYPE\", ");
        sql.append(" \"ENABLE\" ");
        sql.append(" ORDER BY t.\"ATTENDCATALOG.NAME\" ");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        logger.info((Object)sql);
        logger.debug((Object)sql);
        return iQe.executeSQL();
    }

    protected IRowSet _getTblSetByAdmin(Context ctx, String adminOrgUtil, boolean isLowLevel, String employeeType) throws BOSException, EASBizException {
        IQueryExecutor executor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "PersonQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        if (isLowLevel) {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgUtil));
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminOrgUtil + "!%"), CompareType.LIKE));
            if (employeeType != null && !employeeType.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("EmployeeType.id", (Object)("'" + employeeType + "'"), CompareType.INNER));
                filter.setMaskString("(#0 or #1) and #2");
            } else {
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgUtil));
            if (employeeType != null && !employeeType.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("EmployeeType.id", (Object)("'" + employeeType + "'"), CompareType.INNER));
                filter.setMaskString("#0 and #1");
            }
        }
        executor.setObjectView(viewInfo);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)executor.getSQL());
        return row;
    }

    protected IRowSet _getTblSetByAdminCount(Context ctx, String adminOrgUtil, boolean isLowLevel, String employeeType, String maxRowCount) throws BOSException, EASBizException {
        IQueryExecutor executor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "PersonQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        if (isLowLevel) {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgUtil));
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminOrgUtil + "!%"), CompareType.LIKE));
            if (employeeType != null && !employeeType.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("EmployeeType.id", (Object)("'" + employeeType + "'"), CompareType.INNER));
                filter.setMaskString("(#0 or #1) and #2");
            } else {
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminOrgUtil));
            if (employeeType != null && !employeeType.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("EmployeeType.id", (Object)("'" + employeeType + "'"), CompareType.INNER));
                filter.setMaskString("#0 and #1");
            }
        }
        executor.setObjectView(viewInfo);
        String sql = executor.getSQL();
        sql = sql.replaceFirst("SELECT", "SELECT top " + maxRowCount + " ");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
        return row;
    }

    protected String _getTblSetAtt1String(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT distinct ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append(" PERSON.FIndex FIndex, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION1.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT1.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT1.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.TOTALVALUE TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID,");
        strBuffer.append("SUBQUERY.fpositionid fpositionid,");
        strBuffer.append("SUBQUERY.FAdminOrgUnitID FAdminOrgUnitID  ");
        strBuffer.append("FROM T_HR_AttendanceManager ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN (SELECT ");
        strBuffer.append("Sum(ATTENDANCEMANAGER.FTotalValue) TOTALVALUE, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID,");
        strBuffer.append("fpositionid,");
        strBuffer.append("FAdminOrgUnitID ");
        strBuffer.append("FROM T_HR_AttendanceManager ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON ATTENDANCEMANAGER.FAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON ATTENDANCEMANAGER.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON ATTENDANCEMANAGER.FAdminOrgUnitId = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (ATTENDANCEMANAGER.FSTARTDATE <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and ATTENDANCEMANAGER.FENDDATE >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" and ATTENDANCEMANAGER.FAdminOrgUnitId in ");
        strBuffer.append(" ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitId);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append(")");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID,fpositionid,FAdminOrgUnitID) SUBQUERY ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION1 ");
        strBuffer.append("ON SUBQUERY.fpositionid  = POSITION1.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT1 ");
        strBuffer.append("ON SUBQUERY.FAdminOrgUnitID = ADMINORGUNIT1.FID ");
        return strBuffer.toString();
    }

    protected String _getTblSetAttString(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append(" PERSON.FIndex FIndex, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.TOTALVALUE TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID ");
        strBuffer.append("FROM T_BD_Person PERSON ");
        strBuffer.append("INNER JOIN (SELECT ");
        strBuffer.append("Sum(ATTENDANCEMANAGER.FTotalValue) TOTALVALUE, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID ");
        strBuffer.append("FROM T_HR_AttendanceManager ATTENDANCEMANAGER ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON ATTENDANCEMANAGER.FAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON ATTENDANCEMANAGER.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON ATTENDANCEMANAGER.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (ATTENDANCEMANAGER.FSTARTDATE <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and ATTENDANCEMANAGER.FENDDATE >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        strBuffer.append(" and ");
        strBuffer.append(" ATTENDANCEMANAGER.FPersonId in ");
        strBuffer.append(" ( ");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" select person.FID pId from T_BD_PERSON person ");
        strBuffer.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        strBuffer.append(" where pp.fpersonDep in ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append("))");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" ATTENDANCEMANAGER.FCHECKSTATE = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID) SUBQUERY ");
        strBuffer.append("ON PERSON.FID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION ");
        strBuffer.append("ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        return strBuffer.toString();
    }

    protected String _getTblSetLeave1String(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT distinct ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append(" PERSON.FIndex FIndex, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION1.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT1.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT1.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.totalRegReal TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID,");
        strBuffer.append("SUBQUERY.fpositionid fpositionid,");
        strBuffer.append("SUBQUERY.FAdminOrgUnitID FAdminOrgUnitID  ");
        strBuffer.append("FROM T_HR_LeaveDetail LeaveDetail ");
        strBuffer.append("inner join (select ");
        strBuffer.append("Sum(LeaveDetail.FTotalRegReal) totalRegReal, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID, ");
        strBuffer.append("fpositionid,");
        strBuffer.append("FAdminOrgUnitID ");
        strBuffer.append("FROM T_HR_LeaveDetail LeaveDetail ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON LeaveDetail.FTimeAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON LeaveDetail.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON LeaveDetail.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON LeaveDetail.FAdminOrgUnitId = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (LeaveDetail.FStartDateReal <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and LeaveDetail.FEndDateReal >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" and LeaveDetail.FAdminOrgUnitId in ");
        strBuffer.append(" ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitId);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append(")");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID,fpositionid,FAdminOrgUnitID) SUBQUERY ");
        strBuffer.append("ON LeaveDetail.FPersonID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON LeaveDetail.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION1 ");
        strBuffer.append("ON SUBQUERY.fpositionid  = POSITION1.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT1 ");
        strBuffer.append("ON SUBQUERY.FAdminOrgUnitID = ADMINORGUNIT1.FID ");
        return strBuffer.toString();
    }

    protected String _getTblSetLeaveString(Context ctx, Date beginDate, Date endDate, String adminOrgUtil, String cuOrgInfo, String person, int personType, int checkState, String totalInfo, boolean isLowLevel, String employeeType) throws BOSException {
        String local = this.getLocal(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT ");
        strBuffer.append("PERSON.FID PID, ");
        strBuffer.append(" PERSON.FIndex FIndex, ");
        strBuffer.append("PERSON.FName" + local + " PNAME, ");
        strBuffer.append("PERSON.FNumber PNUMBER, ");
        strBuffer.append("POSITION.FName" + local + " POSITIONNAME, ");
        strBuffer.append("ADMINORGUNIT.FName" + local + " ADMINORGUNITNAME, ");
        strBuffer.append("ADMINORGUNIT.FDisplayName" + local + " ADMINORGUNITDISPLAYNAME, ");
        strBuffer.append("SUBQUERY.totalRegReal TOTALVALUE, ");
        strBuffer.append("SUBQUERY.ATTENDANCEID ATTENDANCEFID ");
        strBuffer.append("FROM T_BD_Person PERSON ");
        strBuffer.append("inner join (select ");
        strBuffer.append("Sum(LeaveDetail.FTotalRegReal) totalRegReal, ");
        strBuffer.append("PERSON.FID PERSONID, ");
        strBuffer.append("ATTENDANCE.FID ATTENDANCEID ");
        strBuffer.append("FROM T_HR_LeaveDetail LeaveDetail ");
        strBuffer.append("INNER JOIN T_HR_TimeAttendance ATTENDANCE ");
        strBuffer.append("ON LeaveDetail.FTimeAttendanceID = ATTENDANCE.FID ");
        strBuffer.append("INNER JOIN T_BD_Person PERSON ");
        strBuffer.append("ON LeaveDetail.FPersonID = PERSON.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_BDEmployeeType EmployeeType ");
        strBuffer.append("ON PERSON.FEmployeeTypeID = EmployeeType.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_CtrlUnit CU ");
        strBuffer.append("ON LeaveDetail.FControlUnitID = CU.FID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        boolean hasWhere = false;
        if (beginDate != null && endDate != null) {
            strBuffer.append("where (LeaveDetail.FStartDateReal <= ");
            strBuffer.append(this.getSqlDate(endDate));
            strBuffer.append(" and LeaveDetail.FEndDateReal >= ");
            strBuffer.append(this.getSqlDate(beginDate));
            strBuffer.append(") ");
            hasWhere = true;
        }
        if (employeeType != null && !employeeType.equals("")) {
            strBuffer.append(" and EmployeeType.FID in ('");
            strBuffer.append(employeeType);
            strBuffer.append("')");
        }
        strBuffer.append(" and ");
        strBuffer.append(" LeaveDetail.FPersonId in ");
        strBuffer.append(" ( ");
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String hrOrgUnitID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        strBuffer.append(" select person.FID pId from T_BD_PERSON person ");
        strBuffer.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        strBuffer.append(" where pp.fpersonDep in ( ");
        strBuffer.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        strBuffer.append("'");
        strBuffer.append(hrOrgUnitID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append(" FTypeRelationID = ");
        strBuffer.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        strBuffer.append(" AND ");
        strBuffer.append("FFromUnitID IN (");
        strBuffer.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        strBuffer.append("'");
        strBuffer.append(userID);
        strBuffer.append("'");
        strBuffer.append(" AND ");
        strBuffer.append("FType = ");
        strBuffer.append(20);
        strBuffer.append("))");
        strBuffer.append(" ) ");
        if (person != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" PERSON.FID = '");
            strBuffer.append(person);
            strBuffer.append("' ");
        } else if (adminOrgUtil != null) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            if (isLowLevel) {
                strBuffer.append("(ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' or ");
                strBuffer.append("ADMINORGUNIT.FLongNumber like '");
                strBuffer.append(adminOrgUtil + "!%");
                strBuffer.append("') ");
            } else {
                strBuffer.append("ADMINORGUNIT.FLongNumber = '");
                strBuffer.append(adminOrgUtil);
                strBuffer.append("' ");
            }
        }
        if (checkState == 0) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 0 ");
        } else if (checkState == 1) {
            if (hasWhere) {
                strBuffer.append(" and ");
            } else {
                strBuffer.append(" where ");
                hasWhere = true;
            }
            strBuffer.append(" LeaveDetail.FCheckState = 1 ");
        } else {
            strBuffer.append("");
        }
        strBuffer.append("GROUP BY ");
        strBuffer.append("PERSON.FID, ");
        strBuffer.append("ATTENDANCE.FID) SUBQUERY ");
        strBuffer.append("ON PERSON.FID = SUBQUERY.PERSONID ");
        strBuffer.append("LEFT OUTER JOIN T_HR_PersonPosition PERSONPOSITION ");
        strBuffer.append("ON PERSON.FID = PERSONPOSITION.FPersonID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Position POSITION ");
        strBuffer.append("ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        strBuffer.append("LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ");
        strBuffer.append("ON PERSONPOSITION.FPersonDep = ADMINORGUNIT.FID ");
        return strBuffer.toString();
    }

    protected IRowSet _getTblSetUnion(Context ctx, String tblSetAtt, String tblSetLeave) throws BOSException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(tblSetAtt);
        strBuffer.append(" union all ");
        strBuffer.append(tblSetLeave);
        strBuffer.append(" order by FIndex");
        ISQLExecutor iQe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)strBuffer.toString());
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
        return row;
    }
}

